// auto-generated by Georg Sauthoff's eti2wireshark.py

/* packet-eti.c
 * Routines for ETI dissection
 * Copyright 2021, Georg Sauthoff <mail@gms.tf>
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

/*
 * The Enhanced Trading Interface 10.0 (ETI) is an electronic trading protocol
 * that is used by a few exchanges (Eurex, Xetra, ...).
 *
 * It's a Length-Tag based protocol consisting of mostly fix sized
 * request/response messages.
 *
 * Links:
 * https://en.wikipedia.org/wiki/List_of_electronic_trading_protocols#Europe
 * https://github.com/gsauthof/python-eti#protocol-descriptions
 * https://github.com/gsauthof/python-eti#protocol-introduction
 *
 */

#include <config.h>


#include <epan/packet.h>   // Should be first Wireshark include (other than config.h)
#include "packet-tcp.h"    // tcp_dissect_pdus()
#include <epan/expert.h>   // expert info

#include <inttypes.h>
#include <stdio.h>         // snprintf()


/* Prototypes */
/* (Required to prevent [-Wmissing-prototypes] warnings */
void proto_reg_handoff_eti(void);
void proto_register_eti(void);

static dissector_handle_t eti_handle;

static int proto_eti;
static expert_field ei_eti_counter_overflow;
static expert_field ei_eti_invalid_template;
static expert_field ei_eti_invalid_length;
static expert_field ei_eti_unaligned;
static expert_field ei_eti_missing;
static expert_field ei_eti_overused;

static int hf_eti[444];
static int hf_eti_dscp_exec_summary;
static int hf_eti_dscp_improved;
static int hf_eti_dscp_widened;
enum Field_Handle_Index {
      ACCOUNT_FH_IDX
    , AFFECTEDORDERREQUESTID_FH_IDX
    , ALLOCID_FH_IDX
    , ALLOCQTY_FH_IDX
    , APPLBEGMSGID_FH_IDX
    , APPLBEGSEQNUM_FH_IDX
    , APPLENDMSGID_FH_IDX
    , APPLENDSEQNUM_FH_IDX
    , APPLID_FH_IDX
    , APPLIDSTATUS_FH_IDX
    , APPLMSGID_FH_IDX
    , APPLRESENDFLAG_FH_IDX
    , APPLSEQINDICATOR_FH_IDX
    , APPLSEQNUM_FH_IDX
    , APPLSEQSTATUS_FH_IDX
    , APPLSEQTRADEDATE_FH_IDX
    , APPLSUBID_FH_IDX
    , APPLTOTALMESSAGECOUNT_FH_IDX
    , APPLUSAGEORDERS_FH_IDX
    , APPLUSAGEQUOTES_FH_IDX
    , APPLICATIONSYSTEMNAME_FH_IDX
    , APPLICATIONSYSTEMVENDOR_FH_IDX
    , APPLICATIONSYSTEMVERSION_FH_IDX
    , AUTOAPPROVALRULEID_FH_IDX
    , BASKETEXECID_FH_IDX
    , BASKETPARTYCONTRAFIRM_FH_IDX
    , BASKETPROFILEID_FH_IDX
    , BASKETSIDETRADEREPORTID_FH_IDX
    , BASKETTRADEREPORTTEXT_FH_IDX
    , BASKETTRADEREPORTTYPE_FH_IDX
    , BASKETTRDMATCHID_FH_IDX
    , BESTBIDPX_FH_IDX
    , BESTBIDSIZE_FH_IDX
    , BESTOFFERPX_FH_IDX
    , BESTOFFERSIZE_FH_IDX
    , BIDPX_FH_IDX
    , BIDPXISLOCKED_FH_IDX
    , BIDSIZE_FH_IDX
    , BODYLEN_FH_IDX
    , CLORDID_FH_IDX
    , CLEARINGTRADEPRICE_FH_IDX
    , CLEARINGTRADEQTY_FH_IDX
    , COMPLIANCETEXT_FH_IDX
    , COMPRESSIONACTION_FH_IDX
    , COMPRESSIONID_FH_IDX
    , COMPRESSIONSTATUS_FH_IDX
    , CONTRACTDATE_FH_IDX
    , CROSSID_FH_IDX
    , CROSSREQUESTID_FH_IDX
    , CROSSEDINDICATOR_FH_IDX
    , CUMQTY_FH_IDX
    , CUSTORDERHANDLINGINST_FH_IDX
    , CXLQTY_FH_IDX
    , CXLSIZE_FH_IDX
    , DEFAULTCSTMAPPLVERID_FH_IDX
    , DEFAULTCSTMAPPLVERSUBID_FH_IDX
    , DELETEREASON_FH_IDX
    , DELTA_FH_IDX
    , EFFECTONBASKET_FH_IDX
    , EFFECTIVETIME_FH_IDX
    , ENLIGHTRFQAVGRESPRATERANKING_FH_IDX
    , ENLIGHTRFQAVGRESPTIMERANKING_FH_IDX
    , ENRICHMENTRULEID_FH_IDX
    , EUREXVOLUMERANKING_FH_IDX
    , EVENTDATE_FH_IDX
    , EVENTTYPE_FH_IDX
    , EXECID_FH_IDX
    , EXECINST_FH_IDX
    , EXECRESTATEMENTREASON_FH_IDX
    , EXECTYPE_FH_IDX
    , EXECUTINGTRADER_FH_IDX
    , EXECUTINGTRADERQUALIFIER_FH_IDX
    , EXERCISESTYLE_FH_IDX
    , EXPIREDATE_FH_IDX
    , EXPIRETIME_FH_IDX
    , EXPOSUREDURATION_FH_IDX
    , FIXCLORDID_FH_IDX
    , FIXENGINENAME_FH_IDX
    , FIXENGINEVENDOR_FH_IDX
    , FIXENGINEVERSION_FH_IDX
    , FILLEXECID_FH_IDX
    , FILLLIQUIDITYIND_FH_IDX
    , FILLMATCHID_FH_IDX
    , FILLPX_FH_IDX
    , FILLQTY_FH_IDX
    , FILLREFID_FH_IDX
    , FIRMNEGOTIATIONID_FH_IDX
    , FIRMTRADEID_FH_IDX
    , FREETEXT1_FH_IDX
    , FREETEXT2_FH_IDX
    , FREETEXT3_FH_IDX
    , FREETEXT5_FH_IDX
    , FREETEXT5DISCLOSUREINSTRUCTION_FH_IDX
    , HEADLINE_FH_IDX
    , HEARTBTINT_FH_IDX
    , HEDGETYPE_FH_IDX
    , HEDGINGINSTRUCTION_FH_IDX
    , HIGHLIMITPRICE_FH_IDX
    , IMPLIEDMARKETINDICATOR_FH_IDX
    , INDIVIDUALALLOCID_FH_IDX
    , INPUTSOURCE_FH_IDX
    , INSTRATTRIBTYPE_FH_IDX
    , INSTRATTRIBVALUE_FH_IDX
    , INSTRMTMATCHSIDEID_FH_IDX
    , LASTENTITYPROCESSED_FH_IDX
    , LASTFRAGMENT_FH_IDX
    , LASTPX_FH_IDX
    , LASTPXDISCLOSUREINSTRUCTION_FH_IDX
    , LASTQTY_FH_IDX
    , LASTQTYDISCLOSUREINSTRUCTION_FH_IDX
    , LASTUPDATETIME_FH_IDX
    , LEAVESQTY_FH_IDX
    , LEAVESQTYDISCLOSUREINSTRUCTION_FH_IDX
    , LEGACCOUNT_FH_IDX
    , LEGEXECID_FH_IDX
    , LEGINPUTSOURCE_FH_IDX
    , LEGLASTPX_FH_IDX
    , LEGLASTQTY_FH_IDX
    , LEGPOSITIONEFFECT_FH_IDX
    , LEGPRICE_FH_IDX
    , LEGQTY_FH_IDX
    , LEGRATIOQTY_FH_IDX
    , LEGSECURITYID_FH_IDX
    , LEGSECURITYTYPE_FH_IDX
    , LEGSIDE_FH_IDX
    , LEGSYMBOL_FH_IDX
    , LISTUPDATEACTION_FH_IDX
    , LOWLIMITPRICE_FH_IDX
    , MDBOOKTYPE_FH_IDX
    , MDSUBBOOKTYPE_FH_IDX
    , MMPARAMETERREPORTID_FH_IDX
    , MARKETID_FH_IDX
    , MARKETSEGMENTID_FH_IDX
    , MASSACTIONREASON_FH_IDX
    , MASSACTIONREPORTID_FH_IDX
    , MASSACTIONSUBTYPE_FH_IDX
    , MASSACTIONTYPE_FH_IDX
    , MATCHDATE_FH_IDX
    , MATCHINSTCROSSID_FH_IDX
    , MATCHSUBTYPE_FH_IDX
    , MATCHTYPE_FH_IDX
    , MATCHINGENGINESTATUS_FH_IDX
    , MATCHINGENGINETRADEDATE_FH_IDX
    , MATURITYDATE_FH_IDX
    , MATURITYMONTHYEAR_FH_IDX
    , MAXIMUMPRICE_FH_IDX
    , MESSAGEEVENTSOURCE_FH_IDX
    , MSGSEQNUM_FH_IDX
    , MULTILEGREPORTINGTYPE_FH_IDX
    , MULTILEGMODEL_FH_IDX
    , MULTILEGPRICEMODEL_FH_IDX
    , NEGOTIATIONID_FH_IDX
    , NEGOTIATIONSTARTTIME_FH_IDX
    , NETTINGCOEFFICIENT_FH_IDX
    , NETWORKMSGID_FH_IDX
    , NOAFFECTEDORDERREQUESTS_FH_IDX
    , NOBASKETROOTPARTYGRPS_FH_IDX
    , NOBASKETROOTPARTYGRPSBC_FH_IDX
    , NOBASKETSIDEALLOC_FH_IDX
    , NOCROSSLEGS_FH_IDX
    , NOENRICHMENTRULES_FH_IDX
    , NOEVENTS_FH_IDX
    , NOFILLS_FH_IDX
    , NOINSTRATTRIB_FH_IDX
    , NOINSTRMTMATCHSIDES_FH_IDX
    , NOLEGEXECS_FH_IDX
    , NOLEGS_FH_IDX
    , NOMMPARAMETERS_FH_IDX
    , NONOTAFFECTEDORDERS_FH_IDX
    , NONOTAFFECTEDSECURITIES_FH_IDX
    , NOORDERBOOKITEMS_FH_IDX
    , NOORDEREVENTS_FH_IDX
    , NOPARTYDETAILS_FH_IDX
    , NOQUOTEENTRIES_FH_IDX
    , NOQUOTEEVENTS_FH_IDX
    , NOQUOTEEVENTSINDEX_FH_IDX
    , NOQUOTESIDEENTRIES_FH_IDX
    , NORISKLIMITS_FH_IDX
    , NORISKLIMITSQTY_FH_IDX
    , NOSRQSQUOTEGRPS_FH_IDX
    , NOSRQSRELATEDTRADEIDS_FH_IDX
    , NOSRQSTARGETPARTYTRDGRPS_FH_IDX
    , NOSESSIONS_FH_IDX
    , NOSIDEALLOCS_FH_IDX
    , NOSIDES_FH_IDX
    , NOTARGETPARTYIDS_FH_IDX
    , NOUNDERLYINGSTIPS_FH_IDX
    , NOTAFFORIGCLORDID_FH_IDX
    , NOTAFFECTEDORDERID_FH_IDX
    , NOTAFFECTEDSECURITYID_FH_IDX
    , NOTIFICATIONIN_FH_IDX
    , NUMBEROFRESPDISCLOSUREINSTRUCTION_FH_IDX
    , NUMBEROFRESPONDENTS_FH_IDX
    , NUMBEROFSECURITIES_FH_IDX
    , OFFERPX_FH_IDX
    , OFFERPXISLOCKED_FH_IDX
    , OFFERSIZE_FH_IDX
    , OPTATTRIBUTE_FH_IDX
    , ORDSTATUS_FH_IDX
    , ORDTYPE_FH_IDX
    , ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX
    , ORDERATTRIBUTERISKREDUCTION_FH_IDX
    , ORDERCATEGORY_FH_IDX
    , ORDEREVENTMATCHID_FH_IDX
    , ORDEREVENTPX_FH_IDX
    , ORDEREVENTQTY_FH_IDX
    , ORDEREVENTREASON_FH_IDX
    , ORDERID_FH_IDX
    , ORDERORIGINATION_FH_IDX
    , ORDERQTY_FH_IDX
    , ORDERQTYDISCLOSUREINSTRUCTION_FH_IDX
    , ORDERQTYISLOCKED_FH_IDX
    , ORDERROUTINGINDICATOR_FH_IDX
    , ORDERSIDE_FH_IDX
    , ORIGCLORDID_FH_IDX
    , ORIGTIME_FH_IDX
    , ORIGTRADEID_FH_IDX
    , OWNERSHIPINDICATOR_FH_IDX
    , PACKAGEID_FH_IDX
    , PARTITIONID_FH_IDX
    , PARTYACTIONTYPE_FH_IDX
    , PARTYDETAILDESKID_FH_IDX
    , PARTYDETAILEXECUTINGTRADER_FH_IDX
    , PARTYDETAILEXECUTINGUNIT_FH_IDX
    , PARTYDETAILIDEXECUTINGTRADER_FH_IDX
    , PARTYDETAILIDEXECUTINGUNIT_FH_IDX
    , PARTYDETAILROLEQUALIFIER_FH_IDX
    , PARTYDETAILSTATUS_FH_IDX
    , PARTYDETAILSTATUSINFORMATION_FH_IDX
    , PARTYENTERINGTRADER_FH_IDX
    , PARTYEXECUTINGFIRM_FH_IDX
    , PARTYEXECUTINGTRADER_FH_IDX
    , PARTYEXECUTINGUNIT_FH_IDX
    , PARTYIDBENEFICIARY_FH_IDX
    , PARTYIDCLIENTID_FH_IDX
    , PARTYIDENTERINGFIRM_FH_IDX
    , PARTYIDENTERINGTRADER_FH_IDX
    , PARTYIDEXECUTINGTRADER_FH_IDX
    , PARTYIDEXECUTINGUNIT_FH_IDX
    , PARTYIDLOCATIONID_FH_IDX
    , PARTYIDORDERORIGINATIONFIRM_FH_IDX
    , PARTYIDORIGINATIONMARKET_FH_IDX
    , PARTYIDPOSITIONACCOUNT_FH_IDX
    , PARTYIDSESSIONID_FH_IDX
    , PARTYIDSETTLEMENTLOCATION_FH_IDX
    , PARTYIDTAKEUPTRADINGFIRM_FH_IDX
    , PARTYIDINVESTMENTDECISIONMAKER_FH_IDX
    , PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX
    , PARTYORDERORIGINATIONDISCLOSUREINSTRUCTION_FH_IDX
    , PARTYORDERORIGINATIONTRADER_FH_IDX
    , PARTYSUBIDTYPE_FH_IDX
    , PASSWORD_FH_IDX
    , PCTCOUNT_FH_IDX
    , POSITIONEFFECT_FH_IDX
    , PRICE_FH_IDX
    , PRICEDISCLOSUREINSTRUCTION_FH_IDX
    , PRICEVALIDITYCHECKTYPE_FH_IDX
    , PRODUCTCOMPLEX_FH_IDX
    , PUTORCALL_FH_IDX
    , QUOTECANCELREASON_FH_IDX
    , QUOTECONDITION_FH_IDX
    , QUOTEENTRYREJECTREASON_FH_IDX
    , QUOTEENTRYSTATUS_FH_IDX
    , QUOTEEVENTEXECID_FH_IDX
    , QUOTEEVENTLIQUIDITYIND_FH_IDX
    , QUOTEEVENTMATCHID_FH_IDX
    , QUOTEEVENTPX_FH_IDX
    , QUOTEEVENTQTY_FH_IDX
    , QUOTEEVENTREASON_FH_IDX
    , QUOTEEVENTSIDE_FH_IDX
    , QUOTEEVENTTYPE_FH_IDX
    , QUOTEID_FH_IDX
    , QUOTEINSTRUCTION_FH_IDX
    , QUOTEMSGID_FH_IDX
    , QUOTEREFPRICE_FH_IDX
    , QUOTEREQID_FH_IDX
    , QUOTERESPONSEID_FH_IDX
    , QUOTESIZETYPE_FH_IDX
    , QUOTESUBTYPE_FH_IDX
    , QUOTETYPE_FH_IDX
    , QUOTINGSTATUS_FH_IDX
    , REFAPPLID_FH_IDX
    , REFAPPLLASTMSGID_FH_IDX
    , REFAPPLLASTSEQNUM_FH_IDX
    , REFAPPLSUBID_FH_IDX
    , REGULATORYTRADEID_FH_IDX
    , RELATEDCLOSEPRICE_FH_IDX
    , RELATEDMARKETSEGMENTID_FH_IDX
    , RELATEDPRODUCTCOMPLEX_FH_IDX
    , RELATEDSECURITYID_FH_IDX
    , RELATEDSYMBOL_FH_IDX
    , RELATEDTRADEID_FH_IDX
    , RELATEDTRADEQUANTITY_FH_IDX
    , REQUESTTIME_FH_IDX
    , REQUESTINGPARTYCLEARINGFIRM_FH_IDX
    , REQUESTINGPARTYENTERINGFIRM_FH_IDX
    , REQUESTINGPARTYIDENTERINGFIRM_FH_IDX
    , REQUESTINGPARTYIDEXECUTINGSYSTEM_FH_IDX
    , REQUESTINGPARTYIDEXECUTINGTRADER_FH_IDX
    , REQUESTINGPARTYSUBIDTYPE_FH_IDX
    , RESPONDENTTYPE_FH_IDX
    , RESPONSEIN_FH_IDX
    , REVERSALAPPROVALTIME_FH_IDX
    , REVERSALCANCELLATIONREASON_FH_IDX
    , REVERSALINDICATOR_FH_IDX
    , REVERSALINITIATIONTIME_FH_IDX
    , REVERSALREASONTEXT_FH_IDX
    , RISKLIMITACTION_FH_IDX
    , RISKLIMITGROUP_FH_IDX
    , RISKLIMITNETPOSITIONQTY_FH_IDX
    , RISKLIMITOPENQTY_FH_IDX
    , RISKLIMITPLATFORM_FH_IDX
    , RISKLIMITQTY_FH_IDX
    , RISKLIMITREPORTID_FH_IDX
    , RISKLIMITREQUESTINGPARTYROLE_FH_IDX
    , RISKLIMITTYPE_FH_IDX
    , RISKLIMITVIOLATIONINDICATOR_FH_IDX
    , ROOTPARTYCLEARINGFIRM_FH_IDX
    , ROOTPARTYCLEARINGORGANIZATION_FH_IDX
    , ROOTPARTYCONTRAFIRM_FH_IDX
    , ROOTPARTYCONTRATRADER_FH_IDX
    , ROOTPARTYENTERINGTRADER_FH_IDX
    , ROOTPARTYEXECUTINGFIRM_FH_IDX
    , ROOTPARTYEXECUTINGTRADER_FH_IDX
    , ROOTPARTYIDBENEFICIARY_FH_IDX
    , ROOTPARTYIDCLEARINGUNIT_FH_IDX
    , ROOTPARTYIDCLIENTID_FH_IDX
    , ROOTPARTYIDEXECUTINGTRADER_FH_IDX
    , ROOTPARTYIDEXECUTINGUNIT_FH_IDX
    , ROOTPARTYIDEXECUTIONVENUE_FH_IDX
    , ROOTPARTYIDINVESTMENTDECISIONMAKER_FH_IDX
    , ROOTPARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX
    , ROOTPARTYIDORDERORIGINATIONFIRM_FH_IDX
    , ROOTPARTYIDPOSITIONACCOUNT_FH_IDX
    , ROOTPARTYIDSESSIONID_FH_IDX
    , ROOTPARTYIDTAKEUPTRADINGFIRM_FH_IDX
    , ROOTPARTYSUBIDTYPE_FH_IDX
    , SRQSRELATEDTRADEID_FH_IDX
    , SECONDARYQUOTEID_FH_IDX
    , SECONDARYTRADEID_FH_IDX
    , SECURITYID_FH_IDX
    , SECURITYRESPONSEID_FH_IDX
    , SECURITYSUBTYPE_FH_IDX
    , SELECTIVEREQUESTFORQUOTERTMSERVICESTATUS_FH_IDX
    , SELECTIVEREQUESTFORQUOTESERVICESTATUS_FH_IDX
    , SELECTIVEREQUESTFORQUOTESERVICETRADEDATE_FH_IDX
    , SENDERSUBID_FH_IDX
    , SENDINGTIME_FH_IDX
    , SESSIONINSTANCEID_FH_IDX
    , SESSIONMODE_FH_IDX
    , SESSIONREJECTREASON_FH_IDX
    , SESSIONSTATUS_FH_IDX
    , SESSIONSUBMODE_FH_IDX
    , SETTLMETHOD_FH_IDX
    , SHOWLASTDEALONCLOSURE_FH_IDX
    , SIDE_FH_IDX
    , SIDECOMPLIANCETEXT_FH_IDX
    , SIDEDISCLOSUREINSTRUCTION_FH_IDX
    , SIDEISLOCKED_FH_IDX
    , SIDELASTPX_FH_IDX
    , SIDELASTQTY_FH_IDX
    , SIDELIQUIDITYIND_FH_IDX
    , SIDEMARKETSEGMENTID_FH_IDX
    , SIDETRADEID_FH_IDX
    , SIDETRDSUBTYP_FH_IDX
    , SIMPLESECURITYID_FH_IDX
    , SKIPVALIDATIONS_FH_IDX
    , STOPPX_FH_IDX
    , STRATEGYLINKID_FH_IDX
    , STRIKEPRICE_FH_IDX
    , SUBSCRIPTIONSCOPE_FH_IDX
    , SWAPCLEARER_FH_IDX
    , T7ENTRYSERVICERTMSTATUS_FH_IDX
    , T7ENTRYSERVICERTMTRADEDATE_FH_IDX
    , T7ENTRYSERVICESTATUS_FH_IDX
    , T7ENTRYSERVICETRADEDATE_FH_IDX
    , TESENRICHMENTRULEID_FH_IDX
    , TESEXECID_FH_IDX
    , TARGETPARTYENTERINGTRADER_FH_IDX
    , TARGETPARTYEXECUTINGFIRM_FH_IDX
    , TARGETPARTYEXECUTINGTRADER_FH_IDX
    , TARGETPARTYIDDESKID_FH_IDX
    , TARGETPARTYIDEXECUTINGTRADER_FH_IDX
    , TARGETPARTYIDSESSIONID_FH_IDX
    , TEMPLATEID_FH_IDX
    , THROTTLEDISCONNECTLIMIT_FH_IDX
    , THROTTLENOMSGS_FH_IDX
    , THROTTLETIMEINTERVAL_FH_IDX
    , TIMEINFORCE_FH_IDX
    , TOTNUMTRADEREPORTS_FH_IDX
    , TRADSESEVENT_FH_IDX
    , TRADSESMODE_FH_IDX
    , TRADEAGGREGATIONTRANSTYPE_FH_IDX
    , TRADEALLOCSTATUS_FH_IDX
    , TRADEDATE_FH_IDX
    , TRADEID_FH_IDX
    , TRADEMANAGERSTATUS_FH_IDX
    , TRADEMANAGERTRADEDATE_FH_IDX
    , TRADEPLATFORM_FH_IDX
    , TRADEPUBLISHINDICATOR_FH_IDX
    , TRADEREPORTID_FH_IDX
    , TRADEREPORTTEXT_FH_IDX
    , TRADEREPORTTYPE_FH_IDX
    , TRADEREQUESTRESULT_FH_IDX
    , TRADETOQUOTERATIO_FH_IDX
    , TRADETOQUOTERATIOPOSITION_FH_IDX
    , TRADETOQUOTERATIORANKING_FH_IDX
    , TRADETOREQUESTRATIO_FH_IDX
    , TRADINGCAPACITY_FH_IDX
    , TRADINGSESSIONSUBID_FH_IDX
    , TRANSBKDTIME_FH_IDX
    , TRANSACTTIME_FH_IDX
    , TRANSACTIONDELAYINDICATOR_FH_IDX
    , TRANSFERREASON_FH_IDX
    , TRDMATCHID_FH_IDX
    , TRDREGTSENTRYTIME_FH_IDX
    , TRDREGTSEXECUTIONTIME_FH_IDX
    , TRDREGTSTIMEIN_FH_IDX
    , TRDREGTSTIMEOUT_FH_IDX
    , TRDREGTSTIMEPRIORITY_FH_IDX
    , TRDRPTSTATUS_FH_IDX
    , TRDTYPE_FH_IDX
    , TRIGGERED_FH_IDX
    , UNDERLYINGCURRENCY_FH_IDX
    , UNDERLYINGDELTAPERCENTAGE_FH_IDX
    , UNDERLYINGEFFECTIVEDELTAPERCENTAGE_FH_IDX
    , UNDERLYINGISSUER_FH_IDX
    , UNDERLYINGMATURITYDATE_FH_IDX
    , UNDERLYINGPRICESTIPVALUE_FH_IDX
    , UNDERLYINGPX_FH_IDX
    , UNDERLYINGQTY_FH_IDX
    , UNDERLYINGSECURITYDESC_FH_IDX
    , UNDERLYINGSECURITYID_FH_IDX
    , UNDERLYINGSETTLEMENTDATE_FH_IDX
    , UNDERLYINGSTIPTYPE_FH_IDX
    , UNDERLYINGSTIPVALUE_FH_IDX
    , USERSTATUS_FH_IDX
    , USERNAME_FH_IDX
    , VALIDUNTILTIME_FH_IDX
    , VALUECHECKTYPEMINLOTSIZE_FH_IDX
    , VALUECHECKTYPEVALUE_FH_IDX
    , VARTEXT_FH_IDX
    , VARTEXTLEN_FH_IDX
    , VEGA_FH_IDX
};
static const value_string template_id_vals[] = { // TemplateID
    { 10000, "LogonRequest" },
    { 10001, "LogonResponse" },
    { 10002, "LogoutRequest" },
    { 10003, "LogoutResponse" },
    { 10004, "Unknown" },
    { 10005, "SubscribeResponse" },
    { 10006, "UnsubscribeRequest" },
    { 10007, "UnsubscribeResponse" },
    { 10008, "RetransmitRequest" },
    { 10009, "RetransmitResponse" },
    { 10010, "Reject" },
    { 10011, "Heartbeat" },
    { 10012, "ForcedLogoutNotification" },
    { 10013, "Unknown" },
    { 10014, "Unknown" },
    { 10015, "Unknown" },
    { 10016, "Unknown" },
    { 10017, "Unknown" },
    { 10018, "UserLoginRequest" },
    { 10019, "UserLoginResponse" },
    { 10020, "Unknown" },
    { 10021, "Unknown" },
    { 10022, "Unknown" },
    { 10023, "HeartbeatNotification" },
    { 10024, "UserLogoutResponse" },
    { 10025, "SubscribeRequest" },
    { 10026, "RetransmitMEMessageRequest" },
    { 10027, "RetransmitMEMessageResponse" },
    { 10028, "ThrottleUpdateNotification" },
    { 10029, "UserLogoutRequest" },
    { 10030, "ServiceAvailabilityBroadcast" },
    { 10031, "NewsBroadcast" },
    { 10032, "BroadcastErrorNotification" },
    { 10033, "RiskNotificationBroadcast" },
    { 10034, "PartyEntitlementsUpdateReport" },
    { 10035, "InquireSessionListRequest" },
    { 10036, "InquireSessionListResponse" },
    { 10037, "LegalNotificationBroadcast" },
    { 10038, "InquireUserRequest" },
    { 10039, "InquireUserResponse" },
    { 10040, "InquireEnrichmentRuleIDListRequest" },
    { 10041, "InquireEnrichmentRuleIDListResponse" },
    { 10042, "PartyActionReport" },
    { 10043, "ForcedUserLogoutNotification" },
    { 10044, "ServiceAvailabilityMarketBroadcast" },
    { 10045, "Unknown" },
    { 10046, "Unknown" },
    { 10047, "Unknown" },
    { 10048, "Unknown" },
    { 10049, "Unknown" },
    { 10050, "Unknown" },
    { 10051, "Unknown" },
    { 10052, "Unknown" },
    { 10053, "Unknown" },
    { 10054, "Unknown" },
    { 10055, "Unknown" },
    { 10056, "Unknown" },
    { 10057, "Unknown" },
    { 10058, "Unknown" },
    { 10059, "Unknown" },
    { 10060, "Unknown" },
    { 10061, "Unknown" },
    { 10062, "Unknown" },
    { 10063, "Unknown" },
    { 10064, "Unknown" },
    { 10065, "Unknown" },
    { 10066, "Unknown" },
    { 10067, "Unknown" },
    { 10068, "Unknown" },
    { 10069, "Unknown" },
    { 10070, "Unknown" },
    { 10071, "Unknown" },
    { 10072, "Unknown" },
    { 10073, "Unknown" },
    { 10074, "Unknown" },
    { 10075, "Unknown" },
    { 10076, "Unknown" },
    { 10077, "Unknown" },
    { 10078, "Unknown" },
    { 10079, "Unknown" },
    { 10080, "Unknown" },
    { 10081, "Unknown" },
    { 10082, "Unknown" },
    { 10083, "Unknown" },
    { 10084, "Unknown" },
    { 10085, "Unknown" },
    { 10086, "Unknown" },
    { 10087, "Unknown" },
    { 10088, "Unknown" },
    { 10089, "Unknown" },
    { 10090, "Unknown" },
    { 10091, "Unknown" },
    { 10092, "Unknown" },
    { 10093, "Unknown" },
    { 10094, "Unknown" },
    { 10095, "Unknown" },
    { 10096, "Unknown" },
    { 10097, "Unknown" },
    { 10098, "Unknown" },
    { 10099, "Unknown" },
    { 10100, "NewOrderSingleRequest" },
    { 10101, "NewOrderResponse" },
    { 10102, "NewOrderNRResponse" },
    { 10103, "OrderExecResponse" },
    { 10104, "OrderExecNotification" },
    { 10105, "Unknown" },
    { 10106, "ModifyOrderSingleRequest" },
    { 10107, "ModifyOrderResponse" },
    { 10108, "ModifyOrderNRResponse" },
    { 10109, "DeleteOrderSingleRequest" },
    { 10110, "DeleteOrderResponse" },
    { 10111, "DeleteOrderNRResponse" },
    { 10112, "DeleteOrderBroadcast" },
    { 10113, "NewOrderComplexRequest" },
    { 10114, "ModifyOrderComplexRequest" },
    { 10115, "Unknown" },
    { 10116, "Unknown" },
    { 10117, "OrderExecReportBroadcast" },
    { 10118, "CrossRequest" },
    { 10119, "CrossRequestResponse" },
    { 10120, "DeleteAllOrderRequest" },
    { 10121, "DeleteAllOrderResponse" },
    { 10122, "DeleteAllOrderBroadcast" },
    { 10123, "DeleteOrderComplexRequest" },
    { 10124, "DeleteAllOrderNRResponse" },
    { 10125, "NewOrderSingleShortRequest" },
    { 10126, "ModifyOrderSingleShortRequest" },
    { 10127, "Unknown" },
    { 10128, "Unknown" },
    { 10129, "NewOrderComplexShortRequest" },
    { 10130, "ModifyOrderComplexShortRequest" },
    { 10131, "EnterCLIPRequest" },
    { 10132, "DeleteCLIPRequest" },
    { 10133, "CLIPResponse" },
    { 10134, "CLIPDeletionNotification" },
    { 10135, "CLIPExecutionNotification" },
    { 10136, "Unknown" },
    { 10137, "Unknown" },
    { 10138, "Unknown" },
    { 10139, "Unknown" },
    { 10140, "Unknown" },
    { 10141, "Unknown" },
    { 10142, "Unknown" },
    { 10143, "Unknown" },
    { 10144, "Unknown" },
    { 10145, "Unknown" },
    { 10146, "Unknown" },
    { 10147, "Unknown" },
    { 10148, "Unknown" },
    { 10149, "Unknown" },
    { 10150, "Unknown" },
    { 10151, "Unknown" },
    { 10152, "Unknown" },
    { 10153, "Unknown" },
    { 10154, "Unknown" },
    { 10155, "Unknown" },
    { 10156, "Unknown" },
    { 10157, "Unknown" },
    { 10158, "Unknown" },
    { 10159, "Unknown" },
    { 10160, "Unknown" },
    { 10161, "Unknown" },
    { 10162, "Unknown" },
    { 10163, "Unknown" },
    { 10164, "Unknown" },
    { 10165, "Unknown" },
    { 10166, "Unknown" },
    { 10167, "Unknown" },
    { 10168, "Unknown" },
    { 10169, "Unknown" },
    { 10170, "Unknown" },
    { 10171, "Unknown" },
    { 10172, "Unknown" },
    { 10173, "Unknown" },
    { 10174, "Unknown" },
    { 10175, "Unknown" },
    { 10176, "Unknown" },
    { 10177, "Unknown" },
    { 10178, "Unknown" },
    { 10179, "Unknown" },
    { 10180, "Unknown" },
    { 10181, "Unknown" },
    { 10182, "Unknown" },
    { 10183, "Unknown" },
    { 10184, "Unknown" },
    { 10185, "Unknown" },
    { 10186, "Unknown" },
    { 10187, "Unknown" },
    { 10188, "Unknown" },
    { 10189, "Unknown" },
    { 10190, "Unknown" },
    { 10191, "Unknown" },
    { 10192, "Unknown" },
    { 10193, "Unknown" },
    { 10194, "Unknown" },
    { 10195, "Unknown" },
    { 10196, "Unknown" },
    { 10197, "Unknown" },
    { 10198, "Unknown" },
    { 10199, "Unknown" },
    { 10200, "Unknown" },
    { 10201, "Unknown" },
    { 10202, "Unknown" },
    { 10203, "Unknown" },
    { 10204, "Unknown" },
    { 10205, "Unknown" },
    { 10206, "Unknown" },
    { 10207, "Unknown" },
    { 10208, "Unknown" },
    { 10209, "Unknown" },
    { 10210, "Unknown" },
    { 10211, "Unknown" },
    { 10212, "Unknown" },
    { 10213, "Unknown" },
    { 10214, "Unknown" },
    { 10215, "Unknown" },
    { 10216, "Unknown" },
    { 10217, "Unknown" },
    { 10218, "Unknown" },
    { 10219, "Unknown" },
    { 10220, "Unknown" },
    { 10221, "Unknown" },
    { 10222, "Unknown" },
    { 10223, "Unknown" },
    { 10224, "Unknown" },
    { 10225, "Unknown" },
    { 10226, "Unknown" },
    { 10227, "Unknown" },
    { 10228, "Unknown" },
    { 10229, "Unknown" },
    { 10230, "Unknown" },
    { 10231, "Unknown" },
    { 10232, "Unknown" },
    { 10233, "Unknown" },
    { 10234, "Unknown" },
    { 10235, "Unknown" },
    { 10236, "Unknown" },
    { 10237, "Unknown" },
    { 10238, "Unknown" },
    { 10239, "Unknown" },
    { 10240, "Unknown" },
    { 10241, "Unknown" },
    { 10242, "Unknown" },
    { 10243, "Unknown" },
    { 10244, "Unknown" },
    { 10245, "Unknown" },
    { 10246, "Unknown" },
    { 10247, "Unknown" },
    { 10248, "Unknown" },
    { 10249, "Unknown" },
    { 10250, "Unknown" },
    { 10251, "Unknown" },
    { 10252, "Unknown" },
    { 10253, "Unknown" },
    { 10254, "Unknown" },
    { 10255, "Unknown" },
    { 10256, "Unknown" },
    { 10257, "Unknown" },
    { 10258, "Unknown" },
    { 10259, "Unknown" },
    { 10260, "Unknown" },
    { 10261, "Unknown" },
    { 10262, "Unknown" },
    { 10263, "Unknown" },
    { 10264, "Unknown" },
    { 10265, "Unknown" },
    { 10266, "Unknown" },
    { 10267, "Unknown" },
    { 10268, "Unknown" },
    { 10269, "Unknown" },
    { 10270, "Unknown" },
    { 10271, "Unknown" },
    { 10272, "Unknown" },
    { 10273, "Unknown" },
    { 10274, "Unknown" },
    { 10275, "Unknown" },
    { 10276, "Unknown" },
    { 10277, "Unknown" },
    { 10278, "Unknown" },
    { 10279, "Unknown" },
    { 10280, "Unknown" },
    { 10281, "Unknown" },
    { 10282, "Unknown" },
    { 10283, "Unknown" },
    { 10284, "Unknown" },
    { 10285, "Unknown" },
    { 10286, "Unknown" },
    { 10287, "Unknown" },
    { 10288, "Unknown" },
    { 10289, "Unknown" },
    { 10290, "Unknown" },
    { 10291, "Unknown" },
    { 10292, "Unknown" },
    { 10293, "Unknown" },
    { 10294, "Unknown" },
    { 10295, "Unknown" },
    { 10296, "Unknown" },
    { 10297, "Unknown" },
    { 10298, "Unknown" },
    { 10299, "Unknown" },
    { 10300, "Unknown" },
    { 10301, "AddComplexInstrumentRequest" },
    { 10302, "AddComplexInstrumentResponse" },
    { 10303, "MMParameterDefinitionRequest" },
    { 10304, "MMParameterDefinitionResponse" },
    { 10305, "InquireMMParameterRequest" },
    { 10306, "InquireMMParameterResponse" },
    { 10307, "TradingSessionStatusBroadcast" },
    { 10308, "DeleteAllOrderQuoteEventBroadcast" },
    { 10309, "AddFlexibleInstrumentRequest" },
    { 10310, "AddFlexibleInstrumentResponse" },
    { 10311, "InquirePreTradeRiskLimitsRequest" },
    { 10312, "PreTradeRiskLimitsDefinitionRequest" },
    { 10313, "PreTradeRiskLimitResponse" },
    { 10314, "Unknown" },
    { 10315, "Unknown" },
    { 10316, "Unknown" },
    { 10317, "Unknown" },
    { 10318, "Unknown" },
    { 10319, "Unknown" },
    { 10320, "PingRequest" },
    { 10321, "PingResponse" },
    { 10322, "Unknown" },
    { 10323, "Unknown" },
    { 10324, "Unknown" },
    { 10325, "Unknown" },
    { 10326, "Unknown" },
    { 10327, "Unknown" },
    { 10328, "Unknown" },
    { 10329, "Unknown" },
    { 10330, "Unknown" },
    { 10331, "Unknown" },
    { 10332, "Unknown" },
    { 10333, "Unknown" },
    { 10334, "Unknown" },
    { 10335, "Unknown" },
    { 10336, "Unknown" },
    { 10337, "Unknown" },
    { 10338, "Unknown" },
    { 10339, "Unknown" },
    { 10340, "Unknown" },
    { 10341, "Unknown" },
    { 10342, "Unknown" },
    { 10343, "Unknown" },
    { 10344, "Unknown" },
    { 10345, "Unknown" },
    { 10346, "Unknown" },
    { 10347, "Unknown" },
    { 10348, "Unknown" },
    { 10349, "Unknown" },
    { 10350, "Unknown" },
    { 10351, "Unknown" },
    { 10352, "Unknown" },
    { 10353, "Unknown" },
    { 10354, "Unknown" },
    { 10355, "Unknown" },
    { 10356, "Unknown" },
    { 10357, "Unknown" },
    { 10358, "Unknown" },
    { 10359, "Unknown" },
    { 10360, "Unknown" },
    { 10361, "Unknown" },
    { 10362, "Unknown" },
    { 10363, "Unknown" },
    { 10364, "Unknown" },
    { 10365, "Unknown" },
    { 10366, "Unknown" },
    { 10367, "Unknown" },
    { 10368, "Unknown" },
    { 10369, "Unknown" },
    { 10370, "Unknown" },
    { 10371, "Unknown" },
    { 10372, "Unknown" },
    { 10373, "Unknown" },
    { 10374, "Unknown" },
    { 10375, "Unknown" },
    { 10376, "Unknown" },
    { 10377, "Unknown" },
    { 10378, "Unknown" },
    { 10379, "Unknown" },
    { 10380, "Unknown" },
    { 10381, "Unknown" },
    { 10382, "Unknown" },
    { 10383, "Unknown" },
    { 10384, "Unknown" },
    { 10385, "Unknown" },
    { 10386, "Unknown" },
    { 10387, "Unknown" },
    { 10388, "Unknown" },
    { 10389, "Unknown" },
    { 10390, "Unknown" },
    { 10391, "Unknown" },
    { 10392, "Unknown" },
    { 10393, "Unknown" },
    { 10394, "Unknown" },
    { 10395, "Unknown" },
    { 10396, "Unknown" },
    { 10397, "Unknown" },
    { 10398, "Unknown" },
    { 10399, "Unknown" },
    { 10400, "Unknown" },
    { 10401, "RFQRequest" },
    { 10402, "RFQResponse" },
    { 10403, "QuoteActivationRequest" },
    { 10404, "QuoteActivationResponse" },
    { 10405, "MassQuoteRequest" },
    { 10406, "MassQuoteResponse" },
    { 10407, "QuoteExecutionReport" },
    { 10408, "DeleteAllQuoteRequest" },
    { 10409, "DeleteAllQuoteResponse" },
    { 10410, "DeleteAllQuoteBroadcast" },
    { 10411, "QuoteActivationNotification" },
    { 10412, "Unknown" },
    { 10413, "Unknown" },
    { 10414, "Unknown" },
    { 10415, "Unknown" },
    { 10416, "Unknown" },
    { 10417, "Unknown" },
    { 10418, "Unknown" },
    { 10419, "Unknown" },
    { 10420, "Unknown" },
    { 10421, "Unknown" },
    { 10422, "Unknown" },
    { 10423, "Unknown" },
    { 10424, "Unknown" },
    { 10425, "Unknown" },
    { 10426, "Unknown" },
    { 10427, "Unknown" },
    { 10428, "Unknown" },
    { 10429, "Unknown" },
    { 10430, "Unknown" },
    { 10431, "Unknown" },
    { 10432, "Unknown" },
    { 10433, "Unknown" },
    { 10434, "Unknown" },
    { 10435, "Unknown" },
    { 10436, "Unknown" },
    { 10437, "Unknown" },
    { 10438, "Unknown" },
    { 10439, "Unknown" },
    { 10440, "Unknown" },
    { 10441, "Unknown" },
    { 10442, "Unknown" },
    { 10443, "Unknown" },
    { 10444, "Unknown" },
    { 10445, "Unknown" },
    { 10446, "Unknown" },
    { 10447, "Unknown" },
    { 10448, "Unknown" },
    { 10449, "Unknown" },
    { 10450, "Unknown" },
    { 10451, "Unknown" },
    { 10452, "Unknown" },
    { 10453, "Unknown" },
    { 10454, "Unknown" },
    { 10455, "Unknown" },
    { 10456, "Unknown" },
    { 10457, "Unknown" },
    { 10458, "Unknown" },
    { 10459, "Unknown" },
    { 10460, "Unknown" },
    { 10461, "Unknown" },
    { 10462, "Unknown" },
    { 10463, "Unknown" },
    { 10464, "Unknown" },
    { 10465, "Unknown" },
    { 10466, "Unknown" },
    { 10467, "Unknown" },
    { 10468, "Unknown" },
    { 10469, "Unknown" },
    { 10470, "Unknown" },
    { 10471, "Unknown" },
    { 10472, "Unknown" },
    { 10473, "Unknown" },
    { 10474, "Unknown" },
    { 10475, "Unknown" },
    { 10476, "Unknown" },
    { 10477, "Unknown" },
    { 10478, "Unknown" },
    { 10479, "Unknown" },
    { 10480, "Unknown" },
    { 10481, "Unknown" },
    { 10482, "Unknown" },
    { 10483, "Unknown" },
    { 10484, "Unknown" },
    { 10485, "Unknown" },
    { 10486, "Unknown" },
    { 10487, "Unknown" },
    { 10488, "Unknown" },
    { 10489, "Unknown" },
    { 10490, "Unknown" },
    { 10491, "Unknown" },
    { 10492, "Unknown" },
    { 10493, "Unknown" },
    { 10494, "Unknown" },
    { 10495, "Unknown" },
    { 10496, "Unknown" },
    { 10497, "Unknown" },
    { 10498, "Unknown" },
    { 10499, "Unknown" },
    { 10500, "TradeBroadcast" },
    { 10501, "TMTradingSessionStatusBroadcast" },
    { 10502, "Unknown" },
    { 10503, "Unknown" },
    { 10504, "Unknown" },
    { 10505, "Unknown" },
    { 10506, "Unknown" },
    { 10507, "Unknown" },
    { 10508, "Unknown" },
    { 10509, "Unknown" },
    { 10510, "Unknown" },
    { 10511, "Unknown" },
    { 10512, "Unknown" },
    { 10513, "Unknown" },
    { 10514, "Unknown" },
    { 10515, "Unknown" },
    { 10516, "Unknown" },
    { 10517, "Unknown" },
    { 10518, "Unknown" },
    { 10519, "Unknown" },
    { 10520, "Unknown" },
    { 10521, "Unknown" },
    { 10522, "Unknown" },
    { 10523, "Unknown" },
    { 10524, "Unknown" },
    { 10525, "Unknown" },
    { 10526, "Unknown" },
    { 10527, "Unknown" },
    { 10528, "Unknown" },
    { 10529, "Unknown" },
    { 10530, "Unknown" },
    { 10531, "Unknown" },
    { 10532, "Unknown" },
    { 10533, "Unknown" },
    { 10534, "Unknown" },
    { 10535, "Unknown" },
    { 10536, "Unknown" },
    { 10537, "Unknown" },
    { 10538, "Unknown" },
    { 10539, "Unknown" },
    { 10540, "Unknown" },
    { 10541, "Unknown" },
    { 10542, "Unknown" },
    { 10543, "Unknown" },
    { 10544, "Unknown" },
    { 10545, "Unknown" },
    { 10546, "Unknown" },
    { 10547, "Unknown" },
    { 10548, "Unknown" },
    { 10549, "Unknown" },
    { 10550, "Unknown" },
    { 10551, "Unknown" },
    { 10552, "Unknown" },
    { 10553, "Unknown" },
    { 10554, "Unknown" },
    { 10555, "Unknown" },
    { 10556, "Unknown" },
    { 10557, "Unknown" },
    { 10558, "Unknown" },
    { 10559, "Unknown" },
    { 10560, "Unknown" },
    { 10561, "Unknown" },
    { 10562, "Unknown" },
    { 10563, "Unknown" },
    { 10564, "Unknown" },
    { 10565, "Unknown" },
    { 10566, "Unknown" },
    { 10567, "Unknown" },
    { 10568, "Unknown" },
    { 10569, "Unknown" },
    { 10570, "Unknown" },
    { 10571, "Unknown" },
    { 10572, "Unknown" },
    { 10573, "Unknown" },
    { 10574, "Unknown" },
    { 10575, "Unknown" },
    { 10576, "Unknown" },
    { 10577, "Unknown" },
    { 10578, "Unknown" },
    { 10579, "Unknown" },
    { 10580, "Unknown" },
    { 10581, "Unknown" },
    { 10582, "Unknown" },
    { 10583, "Unknown" },
    { 10584, "Unknown" },
    { 10585, "Unknown" },
    { 10586, "Unknown" },
    { 10587, "Unknown" },
    { 10588, "Unknown" },
    { 10589, "Unknown" },
    { 10590, "Unknown" },
    { 10591, "Unknown" },
    { 10592, "Unknown" },
    { 10593, "Unknown" },
    { 10594, "Unknown" },
    { 10595, "Unknown" },
    { 10596, "Unknown" },
    { 10597, "Unknown" },
    { 10598, "Unknown" },
    { 10599, "Unknown" },
    { 10600, "EnterTESTradeRequest" },
    { 10601, "ModifyTESTradeRequest" },
    { 10602, "DeleteTESTradeRequest" },
    { 10603, "ApproveTESTradeRequest" },
    { 10604, "TESBroadcast" },
    { 10605, "Unknown" },
    { 10606, "TESDeleteBroadcast" },
    { 10607, "TESApproveBroadcast" },
    { 10608, "Unknown" },
    { 10609, "Unknown" },
    { 10610, "TESExecutionBroadcast" },
    { 10611, "TESResponse" },
    { 10612, "UploadTESTradeRequest" },
    { 10613, "TESUploadBroadcast" },
    { 10614, "TESTradeBroadcast" },
    { 10615, "TESTradingSessionStatusBroadcast" },
    { 10616, "TESCompressionRunStatusRequest" },
    { 10617, "TESCompressionRunStatusResponse" },
    { 10618, "TESCompressionRunStatusBroadcast" },
    { 10619, "Unknown" },
    { 10620, "EnterBasketTradeRequest" },
    { 10621, "ModifyBasketTradeRequest" },
    { 10622, "DeleteBasketTradeRequest" },
    { 10623, "ApproveBasketTradeRequest" },
    { 10624, "BasketResponse" },
    { 10625, "BasketBroadcast" },
    { 10626, "BasketDeleteBroadcast" },
    { 10627, "BasketApproveBroadcast" },
    { 10628, "BasketExecutionBroadcast" },
    { 10629, "AmendBasketTradeRequest" },
    { 10630, "ReverseTESTradeRequest" },
    { 10631, "ApproveReverseTESTradeRequest" },
    { 10632, "TESReversalBroadcast" },
    { 10633, "Unknown" },
    { 10634, "Unknown" },
    { 10635, "Unknown" },
    { 10636, "Unknown" },
    { 10637, "Unknown" },
    { 10638, "Unknown" },
    { 10639, "Unknown" },
    { 10640, "Unknown" },
    { 10641, "Unknown" },
    { 10642, "Unknown" },
    { 10643, "Unknown" },
    { 10644, "Unknown" },
    { 10645, "Unknown" },
    { 10646, "Unknown" },
    { 10647, "Unknown" },
    { 10648, "Unknown" },
    { 10649, "Unknown" },
    { 10650, "Unknown" },
    { 10651, "Unknown" },
    { 10652, "Unknown" },
    { 10653, "Unknown" },
    { 10654, "Unknown" },
    { 10655, "Unknown" },
    { 10656, "Unknown" },
    { 10657, "Unknown" },
    { 10658, "Unknown" },
    { 10659, "Unknown" },
    { 10660, "Unknown" },
    { 10661, "Unknown" },
    { 10662, "Unknown" },
    { 10663, "Unknown" },
    { 10664, "Unknown" },
    { 10665, "Unknown" },
    { 10666, "Unknown" },
    { 10667, "Unknown" },
    { 10668, "Unknown" },
    { 10669, "Unknown" },
    { 10670, "Unknown" },
    { 10671, "Unknown" },
    { 10672, "Unknown" },
    { 10673, "Unknown" },
    { 10674, "Unknown" },
    { 10675, "Unknown" },
    { 10676, "Unknown" },
    { 10677, "Unknown" },
    { 10678, "Unknown" },
    { 10679, "Unknown" },
    { 10680, "Unknown" },
    { 10681, "Unknown" },
    { 10682, "Unknown" },
    { 10683, "Unknown" },
    { 10684, "Unknown" },
    { 10685, "Unknown" },
    { 10686, "Unknown" },
    { 10687, "Unknown" },
    { 10688, "Unknown" },
    { 10689, "Unknown" },
    { 10690, "Unknown" },
    { 10691, "Unknown" },
    { 10692, "Unknown" },
    { 10693, "Unknown" },
    { 10694, "Unknown" },
    { 10695, "Unknown" },
    { 10696, "Unknown" },
    { 10697, "Unknown" },
    { 10698, "Unknown" },
    { 10699, "Unknown" },
    { 10700, "SRQSOpenNegotiationRequest" },
    { 10701, "SRQSUpdateNegotiationRequest" },
    { 10702, "SRQSEnterQuoteRequest" },
    { 10703, "SRQSQuoteResponse" },
    { 10704, "SRQSHitQuoteRequest" },
    { 10705, "SRQSDealResponse" },
    { 10706, "SRQSUpdateDealStatusRequest" },
    { 10707, "SRQSQuoteNotification" },
    { 10708, "SRQSCreateDealNotification" },
    { 10709, "SRQSDealNotification" },
    { 10710, "SRQSOpenNegotiationRequesterNotification" },
    { 10711, "SRQSOpenNegotiationNotification" },
    { 10712, "SRQSNegotiationRequesterNotification" },
    { 10713, "SRQSNegotiationNotification" },
    { 10714, "SRQSStatusBroadcast" },
    { 10715, "SRQSNegotiationStatusNotification" },
    { 10716, "Unknown" },
    { 10717, "SRQSQuotingStatusRequest" },
    { 10718, "SRQSInquireSmartRespondentRequest" },
    { 10719, "SRQSInquireSmartRespondentResponse" },
    { 0, NULL }
};
static value_string_ext template_id_vals_ext = VALUE_STRING_EXT_INIT(template_id_vals);
static const value_string appl_id_vals[] = { // ApplID
    { 1, "Trade" },
    { 2, "News" },
    { 3, "Service_availability" },
    { 4, "Session_data" },
    { 5, "Listener_data" },
    { 6, "RiskControl" },
    { 7, "TES_Maintenance" },
    { 8, "TES_Trade" },
    { 9, "SRQS_Maintenance" },
    { 10, "Service_Availability_Market" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static value_string_ext appl_id_vals_ext = VALUE_STRING_EXT_INIT(appl_id_vals);
static const value_string appl_idstatus_vals[] = { // ApplIDStatus
    { 105, "Outbound_conversion_error" },
    { 0xFFFFFFFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string appl_resend_flag_vals[] = { // ApplResendFlag
    { 0, "False" },
    { 1, "True" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string appl_seq_indicator_vals[] = { // ApplSeqIndicator
    { 0, "No_Recovery_Required" },
    { 1, "Recovery_Required" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string appl_seq_status_vals[] = { // ApplSeqStatus
    { 0, "Unavailable" },
    { 1, "Available" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string appl_usage_orders_vals[] = { // ApplUsageOrders
    { 0, "NO_VALUE" },
    { 'A', "Automated" },
    { 'B', "AutoSelect" },
    { 'M', "Manual" },
    { 'N', "None" },
    { 0, NULL }
};
// ApplUsageQuotes aliased by ApplUsageOrders
static const value_string basket_trade_report_type_vals[] = { // BasketTradeReportType
    { 0, "Submit" },
    { 4, "Addendum" },
    { 5, "No_Was_Substitute" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string bid_px_is_locked_vals[] = { // BidPxIsLocked
    { 0, "No" },
    { 1, "Yes" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string compression_action_vals[] = { // CompressionAction
    { 1, "Start_Compression" },
    { 2, "Commit_Compression" },
    { 3, "Cancel_Compression" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string compression_status_vals[] = { // CompressionStatus
    { 1, "Open" },
    { 2, "Executed" },
    { 3, "Cancelled_By_User" },
    { 4, "Cancelled_By_System" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string crossed_indicator_vals[] = { // CrossedIndicator
    { 0, "No_crossing" },
    { 1, "Cross_rejected" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string cust_order_handling_inst_vals[] = { // CustOrderHandlingInst
    { 0, "NO_VALUE" },
    { 'C', "C" },
    { 'D', "D" },
    { 'G', "G" },
    { 'H', "H" },
    { 'W', "W" },
    { 'Y', "Y" },
    { 0, NULL }
};
static const value_string delete_reason_vals[] = { // DeleteReason
    { 100, "No_special_reason" },
    { 101, "TAS_Change" },
    { 102, "Intraday_Expiration" },
    { 103, "Risk_Event" },
    { 104, "Stop_Trading" },
    { 105, "Instrument_Deletion" },
    { 106, "Instrument_Suspension" },
    { 107, "PreTrade_Risk_Event" },
    { 108, "Amendment_Reset" },
    { 109, "Amendment_User_Cancelled" },
    { 110, "Compression_Cancelled_By_User" },
    { 111, "Compression_Cancelled_By_System" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static value_string_ext delete_reason_vals_ext = VALUE_STRING_EXT_INIT(delete_reason_vals);
static const value_string effect_on_basket_vals[] = { // EffectOnBasket
    { 1, "Add_Volume" },
    { 2, "Remove_Volume" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string enlight_rfqavg_resp_rate_ranking_vals[] = { // EnlightRFQAvgRespRateRanking
    { 1, "Low" },
    { 2, "Medium" },
    { 3, "High" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
// EnlightRFQAvgRespTimeRanking aliased by EnlightRFQAvgRespRateRanking
// EurexVolumeRanking aliased by EnlightRFQAvgRespRateRanking
static const value_string event_type_vals[] = { // EventType
    { 8, "Swap_Start_Date" },
    { 9, "Swap_End_Date" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string exec_inst_vals[] = { // ExecInst
    { 1, "H" },
    { 2, "Q" },
    { 3, "H_Q" },
    { 5, "H_6" },
    { 6, "Q_6" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string exec_restatement_reason_vals[] = { // ExecRestatementReason
    { 1, "Order_Book_Restatement" },
    { 101, "Order_Added" },
    { 102, "Order_Modified" },
    { 103, "Order_Cancelled" },
    { 105, "IOC_Order_Cancelled" },
    { 108, "Book_Order_Executed" },
    { 114, "Changed_to_IOC" },
    { 122, "Instrument_State_Change" },
    { 135, "Market_Order_Triggered" },
    { 149, "CAO_Order_Activated" },
    { 150, "CAO_Order_Inactivated" },
    { 164, "OCO_Order_Triggered" },
    { 172, "Stop_Order_Triggered" },
    { 181, "Ownership_Changed" },
    { 197, "Order_Cancellation_Pending" },
    { 199, "Pending_Cancellation_Executed" },
    { 212, "BOC_Order_Cancelled" },
    { 261, "Panic_Cancel" },
    { 302, "Market_Order_Uncrossing" },
    { 340, "CLIP_Execution" },
    { 343, "CLIP_Arrangement_time_out" },
    { 344, "CLIP_Arrangement_Validation" },
    { 0xFFFF, "NO_VALUE" },
    { 0, NULL }
};
static value_string_ext exec_restatement_reason_vals_ext = VALUE_STRING_EXT_INIT(exec_restatement_reason_vals);
static const value_string exec_type_vals[] = { // ExecType
    { 0, "NO_VALUE" },
    { '0', "New" },
    { '4', "Canceled" },
    { '5', "Replaced" },
    { '6', "Pending_Cancel_e" },
    { '9', "Suspended" },
    { 'D', "Restated" },
    { 'F', "Trade" },
    { 'L', "Triggered" },
    { 0, NULL }
};
static value_string_ext exec_type_vals_ext = VALUE_STRING_EXT_INIT(exec_type_vals);
static const value_string executing_trader_qualifier_vals[] = { // ExecutingTraderQualifier
    { 22, "Algo" },
    { 24, "Human" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string exercise_style_vals[] = { // ExerciseStyle
    { 0, "European" },
    { 1, "American" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string fill_liquidity_ind_vals[] = { // FillLiquidityInd
    { 1, "Added_Liquidity" },
    { 2, "Removed_Liquidity" },
    { 4, "Auction" },
    { 5, "Triggered_Stop_Order" },
    { 6, "Triggered_OCO_Order" },
    { 7, "Triggered_Market_Order" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
// FreeText5DisclosureInstruction aliased by BidPxIsLocked
static const value_string hedge_type_vals[] = { // HedgeType
    { 0, "Duration_Hedge" },
    { 1, "Nominal_Hedge" },
    { 2, "Price_Factor_Hedge" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string hedging_instruction_vals[] = { // HedgingInstruction
    { 1, "On_Close" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string implied_market_indicator_vals[] = { // ImpliedMarketIndicator
    { 0, "Not_implied" },
    { 3, "Implied_in_out" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string input_source_vals[] = { // InputSource
    { 1, "Client_Broker" },
    { 2, "Proprietary_Broker" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string instr_attrib_type_vals[] = { // InstrAttribType
    { 5, "Variable_Rate" },
    { 100, "Coupon_Rate" },
    { 101, "Offset_to_the_variable_coupon_rate" },
    { 102, "Swap_Customer_1" },
    { 103, "Swap_Customer_2" },
    { 104, "Cash_Basket_Reference" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string last_fragment_vals[] = { // LastFragment
    { 0, "Not_Last_Message" },
    { 1, "Last_Message" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
// LastPxDisclosureInstruction aliased by BidPxIsLocked
// LastQtyDisclosureInstruction aliased by BidPxIsLocked
// LeavesQtyDisclosureInstruction aliased by BidPxIsLocked
// LegInputSource aliased by InputSource
static const value_string leg_position_effect_vals[] = { // LegPositionEffect
    { 0, "NO_VALUE" },
    { 'C', "Close" },
    { 'O', "Open" },
    { 0, NULL }
};
static const value_string leg_security_type_vals[] = { // LegSecurityType
    { 1, "Multileg_Instrument" },
    { 2, "Underlying_Leg" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string leg_side_vals[] = { // LegSide
    { 1, "Buy" },
    { 2, "Sell" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string list_update_action_vals[] = { // ListUpdateAction
    { 0, "NO_VALUE" },
    { 'A', "Add" },
    { 'D', "Delete" },
    { 0, NULL }
};
static const value_string mdbook_type_vals[] = { // MDBookType
    { 1, "TopOfBook" },
    { 2, "PriceDepth" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string mdsub_book_type_vals[] = { // MDSubBookType
    { 1, "Implied" },
    { 2, "VolumeWeightedAverage" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string market_id_vals[] = { // MarketID
    { 1, "XEUR" },
    { 2, "XEEE" },
    { 12, "NODX" },
    { 0xFFFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string mass_action_reason_vals[] = { // MassActionReason
    { 0, "No_Special_Reason" },
    { 1, "Stop_Trading" },
    { 2, "Emergency" },
    { 3, "Market_Maker_Protection" },
    { 6, "Session_Loss" },
    { 7, "Duplicate_Session_Login" },
    { 8, "Clearing_Risk_Control" },
    { 100, "Internal_Connection_Loss" },
    { 105, "Product_State_Halt" },
    { 106, "Product_State_Holiday" },
    { 107, "Instrument_Suspended" },
    { 109, "Complex_Instrument_Deletion" },
    { 110, "Volatility_Interruption" },
    { 111, "Product_temporarily_not_tradeable" },
    { 117, "Member_disable" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static value_string_ext mass_action_reason_vals_ext = VALUE_STRING_EXT_INIT(mass_action_reason_vals);
static const value_string mass_action_sub_type_vals[] = { // MassActionSubType
    { 1, "Book_or_Cancel" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string mass_action_type_vals[] = { // MassActionType
    { 1, "Suspend_quotes" },
    { 2, "Release_quotes" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string match_sub_type_vals[] = { // MatchSubType
    { 1, "Opening_Auction" },
    { 2, "Closing_Auction" },
    { 3, "Intraday_Auction" },
    { 4, "Circuit_Breaker_Auction" },
    { 6, "Outside_BBO" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string match_type_vals[] = { // MatchType
    { 3, "Confirmed_Trade_Report" },
    { 4, "Auto_match_incoming" },
    { 5, "Cross_Auction" },
    { 7, "Call_Auction" },
    { 11, "Auto_match_resting" },
    { 13, "Liquidity_Improvement_Cross" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
// MatchingEngineStatus aliased by ApplSeqStatus
static const value_string message_event_source_vals[] = { // MessageEventSource
    { 0, "NO_VALUE" },
    { 'A', "Broadcast_to_Approver" },
    { 'I', "Broadcast_to_Initiator" },
    { 'Q', "Broadcast_to_Quote_Submitter" },
    { 'R', "Broadcast_to_Requester" },
    { 0, NULL }
};
static const value_string multi_leg_reporting_type_vals[] = { // MultiLegReportingType
    { 1, "Single_security" },
    { 2, "Individual_leg_of_a_multileg_security" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string multileg_model_vals[] = { // MultilegModel
    { 0, "Predefined_Multileg_Security" },
    { 1, "User_defined_Multileg" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string multileg_price_model_vals[] = { // MultilegPriceModel
    { 0, "Standard" },
    { 1, "UserDefined" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
// NumberOfRespDisclosureInstruction aliased by BidPxIsLocked
// OfferPxIsLocked aliased by BidPxIsLocked
static const value_string ord_status_vals[] = { // OrdStatus
    { 0, "NO_VALUE" },
    { '0', "New" },
    { '1', "Partially_filled" },
    { '2', "Filled" },
    { '4', "Canceled" },
    { '6', "Pending_Cancel" },
    { '9', "Suspended" },
    { 0, NULL }
};
static const value_string ord_type_vals[] = { // OrdType
    { 1, "Market" },
    { 2, "Limit" },
    { 3, "Stop" },
    { 4, "Stop_Limit" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string order_attribute_liquidity_provision_vals[] = { // OrderAttributeLiquidityProvision
    { 0, "N" },
    { 1, "Y" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
// OrderAttributeRiskReduction aliased by OrderAttributeLiquidityProvision
static const value_string order_category_vals[] = { // OrderCategory
    { 0, "NO_VALUE" },
    { '1', "Order" },
    { '2', "Quote" },
    { 0, NULL }
};
static const value_string order_event_reason_vals[] = { // OrderEventReason
    { 100, "SMP" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string order_origination_vals[] = { // OrderOrigination
    { 5, "Direct_access_or_sponsored_access_customer" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
// OrderQtyDisclosureInstruction aliased by BidPxIsLocked
// OrderQtyIsLocked aliased by BidPxIsLocked
static const value_string order_routing_indicator_vals[] = { // OrderRoutingIndicator
    { 0, "NO_VALUE" },
    { 'N', "No" },
    { 'Y', "Yes" },
    { 0, NULL }
};
// OrderSide aliased by LegSide
static const value_string ownership_indicator_vals[] = { // OwnershipIndicator
    { 0, "No_Change_of_Ownership" },
    { 1, "Change_to_Executing_Trader" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string party_action_type_vals[] = { // PartyActionType
    { 1, "Halt_Trading" },
    { 2, "Reinstate" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string party_detail_role_qualifier_vals[] = { // PartyDetailRoleQualifier
    { 10, "Trader" },
    { 11, "Head_Trader" },
    { 12, "Supervisor" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string party_detail_status_vals[] = { // PartyDetailStatus
    { 0, "Active" },
    { 1, "Suspend" },
    { 2, "Rejected" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string party_detail_status_information_vals[] = { // PartyDetailStatusInformation
    { 1, "TRR_THRESHOLD_TOO_BIG" },
    { 2, "BLOCK_ALL_ANONYMOUS" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string party_identering_firm_vals[] = { // PartyIDEnteringFirm
    { 1, "Participant" },
    { 2, "MarketSupervision" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string party_idorigination_market_vals[] = { // PartyIDOriginationMarket
    { 1, "XKFE" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string party_idsettlement_location_vals[] = { // PartyIDSettlementLocation
    { 1, "Clearstream_Banking_Frankfurt" },
    { 2, "Clearstream_Banking_Luxemburg" },
    { 3, "CLS_Group" },
    { 4, "Euroclear" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
// PartyIdInvestmentDecisionMakerQualifier aliased by ExecutingTraderQualifier
// PartyOrderOriginationDisclosureInstruction aliased by BidPxIsLocked
static const value_string party_sub_idtype_vals[] = { // PartySubIDType
    { 14001, "Buyer" },
    { 14002, "Seller" },
    { 0xFFFF, "NO_VALUE" },
    { 0, NULL }
};
// PositionEffect aliased by LegPositionEffect
// PriceDisclosureInstruction aliased by BidPxIsLocked
static const value_string price_validity_check_type_vals[] = { // PriceValidityCheckType
    { 0, "None" },
    { 1, "Optional" },
    { 2, "Mandatory" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string product_complex_vals[] = { // ProductComplex
    { 1, "simple_instrument" },
    { 2, "standard_option_strategy" },
    { 3, "non_standard_option_strategy" },
    { 4, "volatility_strategy" },
    { 5, "futures_Spread" },
    { 6, "inter_product_spread" },
    { 7, "standard_future_strategy" },
    { 8, "pack_and_bundle" },
    { 9, "strip" },
    { 10, "flexible_simple_instrument" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static value_string_ext product_complex_vals_ext = VALUE_STRING_EXT_INIT(product_complex_vals);
static const value_string put_or_call_vals[] = { // PutOrCall
    { 0, "Put" },
    { 1, "Call" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string quote_cancel_reason_vals[] = { // QuoteCancelReason
    { 5, "Expired" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string quote_condition_vals[] = { // QuoteCondition
    { 0, "NO_VALUE" },
    { '8', "Expired" },
    { 'A', "Active" },
    { 'B', "Closed" },
    { 'z', "Suspended" },
    { 0, NULL }
};
static const value_string quote_entry_reject_reason_vals[] = { // QuoteEntryRejectReason
    { 1, "Unknown_Security" },
    { 6, "Duplicate_Quote" },
    { 8, "Invalid_Price" },
    { 16, "No_Reference_Price_Available" },
    { 100, "No_Single_Sided_Quotes" },
    { 103, "Invalid_Quoting_Model" },
    { 106, "Invalid_Size" },
    { 107, "Invalid_Underlying_Price" },
    { 108, "Bid_Price_Not_Reasonable" },
    { 109, "Ask_Price_Not_Reasonable" },
    { 110, "Bid_Price_Exceeds_Range" },
    { 111, "Ask_Price_Exceeds_Range" },
    { 115, "Instrument_State_Freeze" },
    { 116, "Deletion_Already_Pending" },
    { 119, "Entitlement_Not_Assigned_For_Underlying" },
    { 124, "Currently_Not_Tradeable_On_Book" },
    { 125, "Quantity_Limit_Exceeded" },
    { 126, "Value_Limit_Exceeded" },
    { 127, "Invalid_Quote_Spread" },
    { 128, "Book_or_Cancel" },
    { 131, "Cant_Proc_In_Curr_Instr_State" },
    { 134, "Invalid_Quote_Type" },
    { 143, "Trading_indication_running_for_trader" },
    { 144, "On_Book_Trading_disabled_for_Instrument_Type" },
    { 147, "Liquidity_provider_protection_bid_side_cancelled" },
    { 148, "Liquidity_provider_protection_ask_side_cancelled" },
    { 155, "Outside_Quoting_Period" },
    { 156, "Match_Price_Not_On_Price_Step" },
    { 161, "Quantity_Limit_Exceeds_TSL" },
    { 163, "Too_Many_Orders_and_Quotes_in_Order_Book" },
    { 166, "Contract_cannot_be_traded_due_to_insufficient_eligibility" },
    { 0xFFFFFFFF, "NO_VALUE" },
    { 0, NULL }
};
static value_string_ext quote_entry_reject_reason_vals_ext = VALUE_STRING_EXT_INIT(quote_entry_reject_reason_vals);
static const value_string quote_entry_status_vals[] = { // QuoteEntryStatus
    { 0, "Accepted" },
    { 5, "Rejected" },
    { 6, "Removed_and_Rejected" },
    { 10, "Pending" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string quote_event_liquidity_ind_vals[] = { // QuoteEventLiquidityInd
    { 1, "Added_Liquidity" },
    { 2, "Removed_Liquidity" },
    { 4, "Auction" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string quote_event_reason_vals[] = { // QuoteEventReason
    { 14, "Pending_cancellation_executed" },
    { 15, "Invalid_price" },
    { 16, "Cross_rejected" },
    { 17, "Book_or_Cancel" },
    { 18, "PLP" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
// QuoteEventSide aliased by LegSide
static const value_string quote_event_type_vals[] = { // QuoteEventType
    { 2, "Modified_quote_side" },
    { 3, "Removed_quote_side" },
    { 4, "Partially_filled" },
    { 5, "Filled" },
    { 6, "Removed_Quantity" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string quote_instruction_vals[] = { // QuoteInstruction
    { 0, "Do_Not_Quote" },
    { 1, "Quote" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string quote_size_type_vals[] = { // QuoteSizeType
    { 1, "TotalSize" },
    { 2, "OpenSize" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string quote_sub_type_vals[] = { // QuoteSubType
    { 1, "WorkingDelta" },
    { 2, "BasisTrade" },
    { 3, "Regular" },
    { 4, "NegotiateUnderlyingOutsideExchange" },
    { 5, "VolaStrategyFix" },
    { 6, "VolaStrategyNegotiateUnderlying" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string quote_type_vals[] = { // QuoteType
    { 0, "Indicative" },
    { 1, "Tradeable" },
    { 100, "Tradeable_BOC" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string quoting_status_vals[] = { // QuotingStatus
    { 1, "Open_Active" },
    { 2, "Open_Idle" },
    { 3, "Closed_Inactive" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
// RefApplID aliased by ApplID
static const value_string related_product_complex_vals[] = { // RelatedProductComplex
    { 2, "standard_option_strategy" },
    { 3, "non_standard_option_strategy" },
    { 4, "volatility_strategy" },
    { 5, "futures_Spread" },
    { 6, "inter_product_spread" },
    { 7, "standard_future_strategy" },
    { 8, "pack_and_bundle" },
    { 9, "strip" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static value_string_ext related_product_complex_vals_ext = VALUE_STRING_EXT_INIT(related_product_complex_vals);
// RequestingPartyIDEnteringFirm aliased by PartyIDEnteringFirm
static const value_string requesting_party_idexecuting_system_vals[] = { // RequestingPartyIDExecutingSystem
    { 1, "EurexClearing" },
    { 2, "T7" },
    { 0xFFFFFFFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string requesting_party_sub_idtype_vals[] = { // RequestingPartySubIDType
    { 5000, "Requester" },
    { 5001, "Responder" },
    { 5002, "Both" },
    { 5003, "System" },
    { 0xFFFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string respondent_type_vals[] = { // RespondentType
    { 1, "AllMarketParticipants" },
    { 102, "Anonymous" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string reversal_cancellation_reason_vals[] = { // ReversalCancellationReason
    { 1, "TAS_Change" },
    { 2, "Intraday_Expiration" },
    { 3, "Instrument_Deletion" },
    { 4, "Instrument_Suspension" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
// ReversalIndicator aliased by BidPxIsLocked
static const value_string risk_limit_action_vals[] = { // RiskLimitAction
    { 0, "QueueInbound" },
    { 2, "Reject" },
    { 4, "Warning" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string risk_limit_platform_vals[] = { // RiskLimitPlatform
    { 0, "On_Book" },
    { 1, "Off_Book" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string risk_limit_requesting_party_role_vals[] = { // RiskLimitRequestingPartyRole
    { 4, "Clearing_firm" },
    { 22, "Exchange" },
    { 59, "Executing_unit" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string risk_limit_type_vals[] = { // RiskLimitType
    { 4, "Long_limit" },
    { 5, "Short_limit" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
// RiskLimitViolationIndicator aliased by BidPxIsLocked
// RootPartyIDInvestmentDecisionMakerQualifier aliased by ExecutingTraderQualifier
static const value_string root_party_sub_idtype_vals[] = { // RootPartySubIDType
    { 4001, "Buyer" },
    { 4002, "Seller" },
    { 4003, "Broker" },
    { 0xFFFF, "NO_VALUE" },
    { 0, NULL }
};
// SelectiveRequestForQuoteRtmServiceStatus aliased by ApplSeqStatus
// SelectiveRequestForQuoteServiceStatus aliased by ApplSeqStatus
static const value_string session_mode_vals[] = { // SessionMode
    { 1, "HF" },
    { 2, "LF" },
    { 3, "GUI" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string session_reject_reason_vals[] = { // SessionRejectReason
    { 1, "Required_Tag_Missing" },
    { 5, "Value_is_incorrect" },
    { 7, "Decryption_problem" },
    { 11, "Invalid_MsgID" },
    { 16, "Incorrect_NumInGroup_count" },
    { 99, "Other" },
    { 100, "Throttle_Limit_Exceeded" },
    { 101, "Exposure_Limit_Exceeded" },
    { 102, "Service_Temporarily_Not_Available" },
    { 103, "Service_Not_Available" },
    { 105, "Outbound_conversion_error" },
    { 152, "Heartbeat_Violation" },
    { 200, "Internal_technical_error" },
    { 210, "Validation_Error" },
    { 211, "User_Already_Logged_In" },
    { 216, "Gateway_Is_Standby" },
    { 217, "Session_Login_Limit_Reached" },
    { 223, "User_Entitlement_Data_Timeout" },
    { 224, "PSGateway_Session_Limit_Reached" },
    { 225, "User_Login_Limit_Reached" },
    { 226, "Outstanding_Logins_Bu_Limit_Reached" },
    { 227, "Outstanding_Logins_Session_Limit_Reached" },
    { 10000, "Order_Not_Found" },
    { 10001, "Price_Not_Reasonable" },
    { 10002, "ClientOrderID_Not_Unique" },
    { 10003, "Quote_Activation_In_Progress" },
    { 10006, "Stop_Bid_Price_Not_Reasonable" },
    { 10007, "Stop_Ask_Price_Not_Reasonable" },
    { 10008, "Order_Not_Executable_Within_Validity" },
    { 10010, "Create_CI_Throttle_Exceeded" },
    { 10011, "Transaction_Not_Allowed_In_Current_State" },
    { 0xFFFFFFFF, "NO_VALUE" },
    { 0, NULL }
};
static value_string_ext session_reject_reason_vals_ext = VALUE_STRING_EXT_INIT(session_reject_reason_vals);
static const value_string session_status_vals[] = { // SessionStatus
    { 0, "Active" },
    { 4, "Logout" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string session_sub_mode_vals[] = { // SessionSubMode
    { 0, "Regular_trading_session" },
    { 1, "FIX_trading_session" },
    { 2, "Regular_Back_Office_session" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string settl_method_vals[] = { // SettlMethod
    { 0, "NO_VALUE" },
    { 'C', "Cash_Settlement" },
    { 'P', "Physical_Settlement" },
    { 0, NULL }
};
// ShowLastDealOnClosure aliased by BidPxIsLocked
// Side aliased by LegSide
// SideDisclosureInstruction aliased by BidPxIsLocked
// SideIsLocked aliased by BidPxIsLocked
// SideLiquidityInd aliased by QuoteEventLiquidityInd
static const value_string side_trd_sub_typ_vals[] = { // SideTrdSubTyp
    { 2001, "Block_Trade" },
    { 2004, "Trade_at_Market" },
    { 0xFFFF, "NO_VALUE" },
    { 0, NULL }
};
// SkipValidations aliased by ApplResendFlag
static const value_string swap_clearer_vals[] = { // SwapClearer
    { 0, "ECAG" },
    { 1, "NON_ECAG" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
// T7EntryServiceRtmStatus aliased by ApplSeqStatus
// T7EntryServiceStatus aliased by ApplSeqStatus
static const value_string time_in_force_vals[] = { // TimeInForce
    { 0, "Day" },
    { 1, "GTC" },
    { 3, "IOC" },
    { 6, "GTD" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string trad_ses_event_vals[] = { // TradSesEvent
    { 101, "Start_of_Service" },
    { 102, "Market_Reset" },
    { 103, "End_of_Restatement" },
    { 104, "End_of_Day_Service" },
    { 105, "Service_Resumed" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string trad_ses_mode_vals[] = { // TradSesMode
    { 1, "Testing" },
    { 2, "Simulated" },
    { 3, "Production" },
    { 4, "Acceptance" },
    { 5, "Disaster_Recovery" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string trade_aggregation_trans_type_vals[] = { // TradeAggregationTransType
    { 0, "New" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string trade_alloc_status_vals[] = { // TradeAllocStatus
    { 1, "Pending" },
    { 2, "Approved" },
    { 3, "Auto_Approved" },
    { 4, "Uploaded" },
    { 5, "Canceled" },
    { 6, "Pending_Execution" },
    { 7, "Pending_Reversal" },
    { 8, "Approved_Reversal" },
    { 9, "Reversed" },
    { 10, "Cancelled_Reversal" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static value_string_ext trade_alloc_status_vals_ext = VALUE_STRING_EXT_INIT(trade_alloc_status_vals);
// TradeManagerStatus aliased by ApplSeqStatus
static const value_string trade_platform_vals[] = { // TradePlatform
    { 0, "Off_Book" },
    { 1, "On_Book" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string trade_publish_indicator_vals[] = { // TradePublishIndicator
    { 0, "Do_Not_Publish_Trade" },
    { 1, "Publish_Trade" },
    { 2, "Deferred_Publication" },
    { 3, "Published" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string trade_report_type_vals[] = { // TradeReportType
    { 0, "Submit" },
    { 1, "Alleged" },
    { 2, "Accept" },
    { 3, "Decline" },
    { 5, "No_Was_Replaced" },
    { 6, "Trade_Report_Cancel" },
    { 7, "Trade_Break" },
    { 11, "Alleged_New" },
    { 13, "Alleged_No_Was" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static value_string_ext trade_report_type_vals_ext = VALUE_STRING_EXT_INIT(trade_report_type_vals);
static const value_string trade_request_result_vals[] = { // TradeRequestResult
    { 100, "Cancel_pending" },
    { 101, "Cancel_declined" },
    { 102, "Cancel_approved" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
// TradeToQuoteRatioRanking aliased by EnlightRFQAvgRespRateRanking
static const value_string trading_capacity_vals[] = { // TradingCapacity
    { 1, "Customer" },
    { 5, "Principal" },
    { 6, "Market_Maker" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string trading_session_sub_id_vals[] = { // TradingSessionSubID
    { 4, "Closing_auction" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string transaction_delay_indicator_vals[] = { // TransactionDelayIndicator
    { 0, "Not_delayed" },
    { 1, "Delayed" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string transfer_reason_vals[] = { // TransferReason
    { 1, "Owner" },
    { 2, "Clearer" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string trd_rpt_status_vals[] = { // TrdRptStatus
    { 0, "Accepted" },
    { 1, "Rejected" },
    { 2, "Cancelled" },
    { 4, "Pending_New" },
    { 5, "Pending_Cancel" },
    { 7, "Terminated" },
    { 9, "Deemed_Verified" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static value_string_ext trd_rpt_status_vals_ext = VALUE_STRING_EXT_INIT(trd_rpt_status_vals);
static const value_string trd_type_vals[] = { // TrdType
    { 1, "Block_Trade" },
    { 12, "Exchange_for_Swap" },
    { 50, "Compression" },
    { 1000, "Vola_Trade" },
    { 1001, "EFP_Fin_Trade" },
    { 1002, "EFP_Index_Futures_Trade" },
    { 1004, "Trade_at_Market" },
    { 1006, "Enlight" },
    { 1007, "BLOCK_QTPIP" },
    { 1010, "BTRF" },
    { 1011, "EBB" },
    { 0xFFFF, "NO_VALUE" },
    { 0, NULL }
};
static value_string_ext trd_type_vals_ext = VALUE_STRING_EXT_INIT(trd_type_vals);
static const value_string triggered_vals[] = { // Triggered
    { 0, "Not_triggered" },
    { 1, "Triggered_Stop" },
    { 2, "Triggered_OCO" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string user_status_vals[] = { // UserStatus
    { 7, "User_forced_logout" },
    { 10, "User_stopped" },
    { 11, "User_released" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
static const value_string value_check_type_min_lot_size_vals[] = { // ValueCheckTypeMinLotSize
    { 0, "Do_not_check" },
    { 1, "Check" },
    { 0xFF, "NO_VALUE" },
    { 0, NULL }
};
// ValueCheckTypeValue aliased by ValueCheckTypeMinLotSize

enum ETI_Type {
    ETI_EOF,
    ETI_PADDING,
    ETI_UINT,
    ETI_INT,
    ETI_UINT_ENUM,
    ETI_INT_ENUM,
    ETI_COUNTER,
    ETI_FIXED_POINT,
    ETI_TIMESTAMP_NS,
    ETI_CHAR,
    ETI_STRING,
    ETI_VAR_STRING,
    ETI_STRUCT,
    ETI_VAR_STRUCT,
    ETI_DSCP
};

struct ETI_Field {
    uint8_t  type;
    uint8_t  counter_off;      // offset into counter array
                               // if ETI_COUNTER => storage
                               // if ETI_VAR_STRING or ETI_VAR_STRUCT => load
                               // to get length or repeat count
                               // if ETI_FIXED_POINT: #fractional digits
    uint16_t size;             // or offset into struct_names if ETI_STRUCT/ETI_VAR_STRUCT
    uint16_t field_handle_idx; // or index into fields array if ETI_STRUCT/ETI_VAR_STRUT
    uint16_t ett_idx;          // index into ett array if ETI_STRUCT/ETI_VAR_STRUCT
                               // or max value if ETI_COUNTER
};

static gint ett_eti[53];
static gint ett_eti_dscp;
/* This method dissects fully reassembled messages */
static int
dissect_eti_message(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *data _U_)
{
    col_set_str(pinfo->cinfo, COL_PROTOCOL, "ETI");
    col_clear(pinfo->cinfo, COL_INFO);
    guint16 templateid = tvb_get_letohs(tvb, 4);
    const char *template_str = val_to_str_ext(templateid, &template_id_vals_ext, "Unknown ETI template: 0x%04x");
    col_add_fstr(pinfo->cinfo, COL_INFO, "%s", template_str);

    /* create display subtree for the protocol */
    proto_item *ti = proto_tree_add_item(tree, proto_eti, tvb, 0, -1, ENC_NA);
    guint32 bodylen= tvb_get_letohl(tvb, 0);
    proto_item_append_text(ti, ", %s (%" PRIu16 "), BodyLen: %u", template_str, templateid, bodylen);
    proto_tree *root = proto_item_add_subtree(ti, ett_eti[0]);

    static const char struct_names[] = "AffectedOrderRequestsGrp\0BasketExecGrp\0BasketRootPartyGrp\0BasketSideAllocExtBCGrp\0BasketSideAllocExtGrp\0BasketSideAllocGrp\0CrossRequestAckSideGrp\0CrossRequestSideGrp\0EnrichmentRulesGrp\0FillsGrp\0InstrmntLegExecGrp\0InstrmtLegGrp\0InstrmtMatchSideGrp\0InstrumentAttributeGrp\0InstrumentEventGrp\0LegOrdGrp\0MMParameterGrp\0MessageHeaderIn\0MessageHeaderOut\0NRBCHeader\0NRResponseHeaderME\0NotAffectedOrdersGrp\0NotAffectedSecuritiesGrp\0NotifHeader\0OrderBookItemGrp\0OrderEventGrp\0PartyDetailsGrp\0QuotReqLegsGrp\0QuoteEntryAckGrp\0QuoteEntryGrp\0QuoteEventGrp\0QuoteLegExecGrp\0RBCHeader\0RBCHeaderME\0RequestHeader\0ResponseHeader\0ResponseHeaderME\0RiskLimitQtyGrp\0RiskLimitsRptGrp\0SRQSHitQuoteGrp\0SRQSQuoteGrp\0SRQSRelatedTradeIDGrp\0SRQSTargetPartyTrdGrp\0SessionsGrp\0SideAllocExtGrp\0SideAllocGrp\0SideAllocGrpBC\0SideCrossLegGrp\0SmartPartyDetailGrp\0TargetParties\0TrdInstrmntLegGrp\0UnderlyingStipGrp";
    static const struct ETI_Field fields[] = {
        // AffectedOrderRequestsGrpComp@0
          { ETI_UINT, 0, 4, AFFECTEDORDERREQUESTID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // BasketExecGrpComp@3
        , { ETI_UINT, 0, 4, PACKAGEID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, SIDEMARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ALLOCID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, SIDETRDSUBTYP_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // BasketRootPartyGrpComp@9
        , { ETI_UINT_ENUM, 0, 2, ROOTPARTYSUBIDTYPE_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, ROOTPARTYCONTRAFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, ROOTPARTYCONTRATRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, BASKETSIDETRADEREPORTID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // BasketSideAllocExtBCGrpComp@15
        , { ETI_FIXED_POINT, 4, 8, ALLOCQTY_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, LASTPX_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSBKDTIME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 6, 8, RELATEDCLOSEPRICE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PACKAGEID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, SIDEMARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ALLOCID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, SIDETRDSUBTYP_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, PARTYSUBIDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, POSITIONEFFECT_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EFFECTONBASKET_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEALLOCSTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEPUBLISHINDICATOR_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, ACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT3_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYIDTAKEUPTRADINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 7, PARTYIDORDERORIGINATIONFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 9, PARTYIDBENEFICIARY_FH_IDX, 0 }
        , { ETI_STRING, 0, 32, PARTYIDPOSITIONACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, PARTYIDLOCATIONID_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, CUSTORDERHANDLINGINST_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, COMPLIANCETEXT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // BasketSideAllocExtGrpComp@47
        , { ETI_FIXED_POINT, 4, 8, ALLOCQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDCLIENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PACKAGEID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, SIDEMARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ALLOCID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, POSITIONEFFECT_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTERISKREDUCTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERORIGINATION_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, ACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT3_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYIDTAKEUPTRADINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 7, PARTYIDORDERORIGINATIONFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 9, PARTYIDBENEFICIARY_FH_IDX, 0 }
        , { ETI_STRING, 0, 32, PARTYIDPOSITIONACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, PARTYIDLOCATIONID_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, CUSTORDERHANDLINGINST_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, COMPLIANCETEXT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // BasketSideAllocGrpComp@77
        , { ETI_FIXED_POINT, 4, 8, ALLOCQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, INDIVIDUALALLOCID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, PARTYSUBIDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT, 0, 1, INSTRMTMATCHSIDEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEALLOCSTATUS_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // CrossRequestAckSideGrpComp@87
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, INPUTSOURCE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // CrossRequestSideGrpComp@92
        , { ETI_UINT, 0, 8, PARTYIDCLIENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, MAXIMUMPRICE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, INPUTSOURCE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, POSITIONEFFECT_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, CUSTORDERHANDLINGINST_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, ACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 32, PARTYIDPOSITIONACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT3_FH_IDX, 0 }
        , { ETI_STRING, 0, 7, PARTYIDORDERORIGINATIONFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 9, PARTYIDBENEFICIARY_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYIDTAKEUPTRADINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, SIDECOMPLIANCETEXT_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, PARTYIDLOCATIONID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // EnrichmentRulesGrpComp@116
        , { ETI_UINT, 0, 2, ENRICHMENTRULEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDORIGINATIONMARKET_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, ACCOUNT_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, POSITIONEFFECT_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYIDTAKEUPTRADINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 7, PARTYIDORDERORIGINATIONFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 9, PARTYIDBENEFICIARY_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT3_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // FillsGrpComp@128
        , { ETI_FIXED_POINT, 8, 8, FILLPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, FILLQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, FILLMATCHID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, FILLEXECID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, FILLLIQUIDITYIND_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // InstrmntLegExecGrpComp@135
        , { ETI_INT, 0, 8, LEGSECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, LEGLASTPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LEGLASTQTY_FH_IDX, 0 }
        , { ETI_INT, 0, 4, LEGEXECID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, LEGSIDE_FH_IDX, 0 }
        , { ETI_UINT, 0, 1, FILLREFID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // InstrmtLegGrpComp@143
        , { ETI_INT, 0, 8, LEGSECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, LEGPRICE_FH_IDX, 0 }
        , { ETI_INT, 0, 4, LEGSYMBOL_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, LEGRATIOQTY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, LEGSIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, LEGSECURITYTYPE_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // InstrmtMatchSideGrpComp@151
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, LASTPX_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSBKDTIME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 6, 8, RELATEDCLOSEPRICE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PACKAGEID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, SIDEMARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, SIDETRDSUBTYP_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEPUBLISHINDICATOR_FH_IDX, 0 }
        , { ETI_UINT, 0, 1, INSTRMTMATCHSIDEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EFFECTONBASKET_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTTEXT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // InstrumentAttributeGrpComp@165
        , { ETI_UINT_ENUM, 0, 1, INSTRATTRIBTYPE_FH_IDX, 0 }
        , { ETI_STRING, 0, 32, INSTRATTRIBVALUE_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // InstrumentEventGrpComp@169
        , { ETI_UINT, 0, 4, EVENTDATE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EVENTTYPE_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // LegOrdGrpComp@173
        , { ETI_STRING, 0, 2, LEGACCOUNT_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, LEGPOSITIONEFFECT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 5, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // MMParameterGrpComp@177
        , { ETI_INT, 0, 8, EXPOSUREDURATION_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CUMQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, DELTA_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, VEGA_FH_IDX, 0 }
        , { ETI_INT, 0, 4, PCTCOUNT_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TARGETPARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // MessageHeaderInComp@184
        , { ETI_UINT, 0, 4, BODYLEN_FH_IDX, 0 }
        , { ETI_UINT, 0, 2, TEMPLATEID_FH_IDX, 0 }
        , { ETI_STRING, 0, 8, NETWORKMSGID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // MessageHeaderOutComp@189
        , { ETI_UINT, 0, 4, BODYLEN_FH_IDX, 0 }
        , { ETI_UINT, 0, 2, TEMPLATEID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // NRBCHeaderComp@193
        , { ETI_TIMESTAMP_NS, 0, 8, SENDINGTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, APPLSUBID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, LASTFRAGMENT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // NRResponseHeaderMEComp@199
        , { ETI_TIMESTAMP_NS, 0, 8, REQUESTTIME_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSTIMEIN_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSTIMEOUT_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, RESPONSEIN_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, SENDINGTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MSGSEQNUM_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, LASTFRAGMENT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // NotAffectedOrdersGrpComp@208
        , { ETI_UINT, 0, 8, NOTAFFECTEDORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, NOTAFFORIGCLORDID_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // NotAffectedSecuritiesGrpComp@211
        , { ETI_UINT, 0, 8, NOTAFFECTEDSECURITYID_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // NotifHeaderComp@213
        , { ETI_TIMESTAMP_NS, 0, 8, SENDINGTIME_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // OrderBookItemGrpComp@215
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, BESTBIDPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, BESTBIDSIZE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, BESTOFFERPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, BESTOFFERSIZE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MDBOOKTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MDSUBBOOKTYPE_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // OrderEventGrpComp@224
        , { ETI_FIXED_POINT, 8, 8, ORDEREVENTPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDEREVENTQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ORDEREVENTMATCHID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDEREVENTREASON_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // PartyDetailsGrpComp@230
        , { ETI_UINT, 0, 4, PARTYDETAILIDEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYDETAILEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYDETAILROLEQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYDETAILSTATUS_FH_IDX, 0 }
        , { ETI_STRING, 0, 3, PARTYDETAILDESKID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // QuotReqLegsGrpComp@237
        , { ETI_INT, 0, 8, LEGSECURITYID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, LEGRATIOQTY_FH_IDX, 0 }
        , { ETI_INT, 0, 4, LEGSYMBOL_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, LEGSECURITYTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, LEGSIDE_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // QuoteEntryAckGrpComp@244
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CXLSIZE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 4, QUOTEENTRYREJECTREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTEENTRYSTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // QuoteEntryGrpComp@251
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, BIDPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, BIDSIZE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, OFFERPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, OFFERSIZE_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // QuoteEventGrpComp@257
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, QUOTEEVENTPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, QUOTEEVENTQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, QUOTEMSGID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, QUOTEEVENTMATCHID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, QUOTEEVENTEXECID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTEEVENTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTEEVENTSIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTEEVENTLIQUIDITYIND_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTEEVENTREASON_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // QuoteLegExecGrpComp@269
        , { ETI_INT, 0, 8, LEGSECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, LEGLASTPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LEGLASTQTY_FH_IDX, 0 }
        , { ETI_INT, 0, 4, LEGEXECID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, LEGSIDE_FH_IDX, 0 }
        , { ETI_UINT, 0, 1, NOQUOTEEVENTSINDEX_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // RBCHeaderComp@277
        , { ETI_TIMESTAMP_NS, 0, 8, SENDINGTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, APPLSEQNUM_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, APPLSUBID_FH_IDX, 0 }
        , { ETI_UINT, 0, 2, PARTITIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLRESENDFLAG_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, LASTFRAGMENT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // RBCHeaderMEComp@286
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSTIMEOUT_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, NOTIFICATIONIN_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, SENDINGTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, APPLSUBID_FH_IDX, 0 }
        , { ETI_UINT, 0, 2, PARTITIONID_FH_IDX, 0 }
        , { ETI_STRING, 0, 16, APPLMSGID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLRESENDFLAG_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, LASTFRAGMENT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // RequestHeaderComp@297
        , { ETI_UINT, 0, 4, MSGSEQNUM_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SENDERSUBID_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // ResponseHeaderComp@300
        , { ETI_TIMESTAMP_NS, 0, 8, REQUESTTIME_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, SENDINGTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MSGSEQNUM_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // ResponseHeaderMEComp@305
        , { ETI_TIMESTAMP_NS, 0, 8, REQUESTTIME_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSTIMEIN_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSTIMEOUT_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, RESPONSEIN_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, SENDINGTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MSGSEQNUM_FH_IDX, 0 }
        , { ETI_UINT, 0, 2, PARTITIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLID_FH_IDX, 0 }
        , { ETI_STRING, 0, 16, APPLMSGID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, LASTFRAGMENT_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // RiskLimitQtyGrpComp@316
        , { ETI_FIXED_POINT, 4, 8, RISKLIMITQTY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, RISKLIMITTYPE_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // RiskLimitsRptGrpComp@320
        , { ETI_FIXED_POINT, 4, 8, RISKLIMITQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, RISKLIMITOPENQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, RISKLIMITNETPOSITIONQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, NETTINGCOEFFICIENT_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, RISKLIMITTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, RISKLIMITREQUESTINGPARTYROLE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, RISKLIMITVIOLATIONINDICATOR_FH_IDX, 0 }
        , { ETI_STRING, 0, 3, RISKLIMITGROUP_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SRQSHitQuoteGrpComp@330
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SRQSQuoteGrpComp@335
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SRQSRelatedTradeIDGrpComp@337
        , { ETI_UINT, 0, 4, SRQSRELATEDTRADEID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SRQSTargetPartyTrdGrpComp@340
        , { ETI_FIXED_POINT, 4, 8, SIDELASTQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TARGETPARTYIDEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, TARGETPARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, TARGETPARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, TARGETPARTYENTERINGTRADER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SessionsGrpComp@348
        , { ETI_UINT, 0, 4, PARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SESSIONMODE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SESSIONSUBMODE_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SideAllocExtGrpComp@353
        , { ETI_FIXED_POINT, 4, 8, ALLOCQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDCLIENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, INDIVIDUALALLOCID_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_UINT, 0, 4, TESENRICHMENTRULEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEALLOCSTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, POSITIONEFFECT_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTERISKREDUCTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERORIGINATION_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, ACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 32, PARTYIDPOSITIONACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYIDTAKEUPTRADINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT3_FH_IDX, 0 }
        , { ETI_STRING, 0, 7, PARTYIDORDERORIGINATIONFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 9, PARTYIDBENEFICIARY_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, PARTYIDLOCATIONID_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, CUSTORDERHANDLINGINST_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, COMPLIANCETEXT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SideAllocGrpComp@384
        , { ETI_FIXED_POINT, 4, 8, ALLOCQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, INDIVIDUALALLOCID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TESENRICHMENTRULEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SideAllocGrpBCComp@392
        , { ETI_FIXED_POINT, 4, 8, ALLOCQTY_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, REVERSALAPPROVALTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, INDIVIDUALALLOCID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TESENRICHMENTRULEID_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEALLOCSTATUS_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SideCrossLegGrpComp@402
        , { ETI_UINT_ENUM, 0, 1, LEGINPUTSOURCE_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, LEGPOSITIONEFFECT_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, LEGACCOUNT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SmartPartyDetailGrpComp@407
        , { ETI_STRING, 0, 5, PARTYDETAILEXECUTINGUNIT_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYDETAILEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 5, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // TargetPartiesComp@411
        , { ETI_UINT, 0, 4, TARGETPARTYIDEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDEDISCLOSUREINSTRUCTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRICEDISCLOSUREINSTRUCTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, LEAVESQTYDISCLOSUREINSTRUCTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, LASTPXDISCLOSUREINSTRUCTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, LASTQTYDISCLOSUREINSTRUCTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, FREETEXT5DISCLOSUREINSTRUCTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYORDERORIGINATIONDISCLOSUREINSTRUCTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTEINSTRUCTION_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, TARGETPARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, TARGETPARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYDETAILSTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYDETAILSTATUSINFORMATION_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // TrdInstrmntLegGrpComp@426
        , { ETI_INT, 0, 8, LEGSECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, LEGPRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LEGQTY_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // UnderlyingStipGrpComp@430
        , { ETI_STRING, 0, 32, UNDERLYINGSTIPVALUE_FH_IDX, 0 }
        , { ETI_STRING, 0, 7, UNDERLYINGSTIPTYPE_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // AddComplexInstrumentRequest@434
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, SECURITYSUBTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOLEGS_FH_IDX, 20 } // <- counter@0
        , { ETI_STRING, 0, 20, COMPLIANCETEXT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 213, 143, 12 } // InstrmtLegGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // AddComplexInstrumentResponse@444
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 358, 199, 21 } // NRResponseHeaderME
        , { ETI_FIXED_POINT, 8, 8, LOWLIMITPRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, HIGHLIMITPRICE_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, LASTUPDATETIME_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, SECURITYRESPONSEID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, NUMBEROFSECURITIES_FH_IDX, 0 }
        , { ETI_INT, 0, 4, SECURITYSUBTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MULTILEGMODEL_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, IMPLIEDMARKETINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOLEGS_FH_IDX, 20 } // <- counter@0
        , { ETI_VAR_STRUCT, 0, 213, 143, 12 } // InstrmtLegGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // AddFlexibleInstrumentRequest@460
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_FIXED_POINT, 8, 8, STRIKEPRICE_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MATURITYDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, CONTRACTDATE_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, SETTLMETHOD_FH_IDX, 0 }
        , { ETI_UINT, 0, 1, OPTATTRIBUTE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PUTORCALL_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXERCISESTYLE_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, COMPLIANCETEXT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // AddFlexibleInstrumentResponse@473
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 358, 199, 21 } // NRResponseHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, SECURITYRESPONSEID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, STRIKEPRICE_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MATURITYDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, CONTRACTDATE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, SETTLMETHOD_FH_IDX, 0 }
        , { ETI_UINT, 0, 1, OPTATTRIBUTE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PUTORCALL_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXERCISESTYLE_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // AmendBasketTradeRequest@488
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_UINT, 0, 8, BASKETTRDMATCHID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, BASKETEXECID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MATURITYMONTHYEAR_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, BASKETPROFILEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NOBASKETSIDEALLOC_FH_IDX, 398 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, BASKETTRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_COUNTER, 1, 1, NOBASKETROOTPARTYGRPS_FH_IDX, 2 } // <- counter@1
        , { ETI_COUNTER, 2, 1, NOINSTRMTMATCHSIDES_FH_IDX, 199 } // <- counter@2
        , { ETI_STRING, 0, 20, BASKETTRADEREPORTTEXT_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_VAR_STRUCT, 1, 39, 9, 3 } // BasketRootPartyGrp
        , { ETI_VAR_STRUCT, 2, 227, 151, 13 } // InstrmtMatchSideGrp
        , { ETI_VAR_STRUCT, 0, 104, 77, 6 } // BasketSideAllocGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // ApproveBasketTradeRequest@507
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_UINT, 0, 8, BASKETTRDMATCHID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, BASKETEXECID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, ROOTPARTYSUBIDTYPE_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NOBASKETSIDEALLOC_FH_IDX, 398 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, BASKETTRADEREPORTTEXT_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, BASKETSIDETRADEREPORTID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 5, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 82, 47, 5 } // BasketSideAllocExtGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // ApproveReverseTESTradeRequest@522
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PACKAGEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ALLOCID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TESEXECID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, RELATEDMARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // ApproveTESTradeRequest@533
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_UINT, 0, 8, PARTYIDCLIENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ALLOCQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, COMPRESSIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PACKAGEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ALLOCID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TESEXECID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, RELATEDMARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTERISKREDUCTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERORIGINATION_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, POSITIONEFFECT_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, ACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT3_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYIDTAKEUPTRADINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 32, PARTYIDPOSITIONACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 7, PARTYIDORDERORIGINATIONFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 9, PARTYIDBENEFICIARY_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, PARTYIDLOCATIONID_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, CUSTORDERHANDLINGINST_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, COMPLIANCETEXT_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // BasketApproveBroadcast@570
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_UINT, 0, 8, BASKETTRDMATCHID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, BASKETEXECID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, BASKETPROFILEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NOBASKETSIDEALLOC_FH_IDX, 398 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, BASKETTRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, MESSAGEEVENTSOURCE_FH_IDX, 0 }
        , { ETI_COUNTER, 1, 1, NOBASKETROOTPARTYGRPS_FH_IDX, 2 } // <- counter@1
        , { ETI_UINT_ENUM, 0, 1, PARTYIDENTERINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYENTERINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, BASKETTRADEREPORTTEXT_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 5, 0, 0 }
        , { ETI_VAR_STRUCT, 1, 39, 9, 3 } // BasketRootPartyGrp
        , { ETI_VAR_STRUCT, 0, 58, 15, 4 } // BasketSideAllocExtBCGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // BasketBroadcast@591
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_UINT, 0, 8, BASKETTRDMATCHID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, BASKETEXECID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MATURITYMONTHYEAR_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, BASKETPROFILEID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NOBASKETSIDEALLOC_FH_IDX, 398 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, BASKETTRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, MESSAGEEVENTSOURCE_FH_IDX, 0 }
        , { ETI_COUNTER, 1, 1, NOBASKETROOTPARTYGRPSBC_FH_IDX, 3 } // <- counter@1
        , { ETI_COUNTER, 2, 1, NOINSTRMTMATCHSIDES_FH_IDX, 199 } // <- counter@2
        , { ETI_STRING, 0, 20, BASKETTRADEREPORTTEXT_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_VAR_STRUCT, 1, 39, 9, 3 } // BasketRootPartyGrp
        , { ETI_VAR_STRUCT, 2, 227, 151, 13 } // InstrmtMatchSideGrp
        , { ETI_VAR_STRUCT, 0, 104, 77, 6 } // BasketSideAllocGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // BasketDeleteBroadcast@613
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_UINT, 0, 8, BASKETTRDMATCHID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, BASKETEXECID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, BASKETPROFILEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, DELETEREASON_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, MESSAGEEVENTSOURCE_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // BasketExecutionBroadcast@626
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_UINT, 0, 8, BASKETTRDMATCHID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, BASKETEXECID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, BASKETPROFILEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOINSTRMTMATCHSIDES_FH_IDX, 199 } // <- counter@0
        , { ETI_CHAR, 0, 1, MESSAGEEVENTSOURCE_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, BASKETSIDETRADEREPORTID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 25, 3, 2 } // BasketExecGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // BasketResponse@641
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 594, 300, 36 } // ResponseHeader
        , { ETI_UINT, 0, 4, BASKETEXECID_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // BroadcastErrorNotification@646
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 423, 213, 24 } // NotifHeader
        , { ETI_UINT_ENUM, 0, 4, APPLIDSTATUS_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, REFAPPLSUBID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, VARTEXTLEN_FH_IDX, 2000 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, REFAPPLID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SESSIONSTATUS_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_VAR_STRING, 0, 2000, VARTEXT_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // CLIPDeletionNotification@656
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 568, 286, 34 } // RBCHeaderME
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CXLQTY_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, EXECRESTATEMENTREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, EXECTYPE_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // CLIPExecutionNotification@670
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 568, 286, 34 } // RBCHeaderME
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CXLQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LEAVESQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CUMQTY_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, EXECRESTATEMENTREASON_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NOLEGEXECS_FH_IDX, 600 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, EXECTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MATCHTYPE_FH_IDX, 0 }
        , { ETI_COUNTER, 1, 1, NOFILLS_FH_IDX, 100 } // <- counter@1
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_VAR_STRUCT, 1, 185, 128, 10 } // FillsGrp
        , { ETI_VAR_STRUCT, 0, 194, 135, 11 } // InstrmntLegExecGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // CLIPResponse@691
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 358, 199, 21 } // NRResponseHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, CROSSREQUESTID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOSIDES_FH_IDX, 2 } // <- counter@0
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 123, 87, 7 } // CrossRequestAckSideGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // CrossRequest@701
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, COMPLIANCETEXT_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // CrossRequestResponse@708
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 358, 199, 21 } // NRResponseHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteAllOrderBroadcast@712
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 568, 286, 34 } // RBCHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, MASSACTIONREPORTID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, PRICE_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TARGETPARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TARGETPARTYIDEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDENTERINGTRADER_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NONOTAFFECTEDORDERS_FH_IDX, 500 } // <- counter@0
        , { ETI_COUNTER, 1, 2, NOAFFECTEDORDERREQUESTS_FH_IDX, 500 } // <- counter@1
        , { ETI_UINT_ENUM, 0, 1, PARTYIDENTERINGFIRM_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MASSACTIONREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECINST_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_VAR_STRUCT, 0, 377, 208, 22 } // NotAffectedOrdersGrp
        , { ETI_VAR_STRUCT, 1, 0, 0, 1 } // AffectedOrderRequestsGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteAllOrderNRResponse@730
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 358, 199, 21 } // NRResponseHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, MASSACTIONREPORTID_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteAllOrderQuoteEventBroadcast@734
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 568, 286, 34 } // RBCHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, MASSACTIONREPORTID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MASSACTIONREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECINST_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteAllOrderRequest@743
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, PRICE_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TARGETPARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TARGETPARTYIDEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERORIGINATION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteAllOrderResponse@757
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 609, 305, 37 } // ResponseHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, MASSACTIONREPORTID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NONOTAFFECTEDORDERS_FH_IDX, 500 } // <- counter@0
        , { ETI_COUNTER, 1, 2, NOAFFECTEDORDERREQUESTS_FH_IDX, 500 } // <- counter@1
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 377, 208, 22 } // NotAffectedOrdersGrp
        , { ETI_VAR_STRUCT, 1, 0, 0, 1 } // AffectedOrderRequestsGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteAllQuoteBroadcast@766
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 568, 286, 34 } // RBCHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, MASSACTIONREPORTID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TARGETPARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDENTERINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TARGETPARTYIDEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NONOTAFFECTEDSECURITIES_FH_IDX, 500 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, MASSACTIONREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDENTERINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 3, TARGETPARTYIDDESKID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 398, 211, 23 } // NotAffectedSecuritiesGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteAllQuoteRequest@781
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TARGETPARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteAllQuoteResponse@791
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 358, 199, 21 } // NRResponseHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, MASSACTIONREPORTID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NONOTAFFECTEDSECURITIES_FH_IDX, 500 } // <- counter@0
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 398, 211, 23 } // NotAffectedSecuritiesGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteBasketTradeRequest@798
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_UINT, 0, 8, BASKETTRDMATCHID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, BASKETEXECID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteCLIPRequest@808
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, CROSSREQUESTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteOrderBroadcast@820
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 568, 286, 34 } // RBCHeaderME
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORIGCLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CUMQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CXLQTY_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDENTERINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, EXECRESTATEMENTREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDENTERINGFIRM_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, EXECTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIXCLORDID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteOrderComplexRequest@841
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORIGCLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TARGETPARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERORIGINATION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIXCLORDID_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, COMPLIANCETEXT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 5, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteOrderNRResponse@858
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 358, 199, 21 } // NRResponseHeaderME
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORIGCLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CUMQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CXLQTY_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, EXECTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, EXECRESTATEMENTREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRANSACTIONDELAYINDICATOR_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteOrderResponse@874
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 609, 305, 37 } // ResponseHeaderME
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORIGCLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CUMQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CXLQTY_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, EXECTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, EXECRESTATEMENTREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRANSACTIONDELAYINDICATOR_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteOrderSingleRequest@890
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORIGCLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SIMPLESECURITYID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TARGETPARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERORIGINATION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIXCLORDID_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, COMPLIANCETEXT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // DeleteTESTradeRequest@907
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_UINT, 0, 8, COMPRESSIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PACKAGEID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TESEXECID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, RELATEDMARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // EnterBasketTradeRequest@919
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MATURITYMONTHYEAR_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, BASKETPROFILEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NOBASKETSIDEALLOC_FH_IDX, 398 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, BASKETTRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_COUNTER, 1, 1, NOBASKETROOTPARTYGRPS_FH_IDX, 2 } // <- counter@1
        , { ETI_COUNTER, 2, 1, NOINSTRMTMATCHSIDES_FH_IDX, 199 } // <- counter@2
        , { ETI_STRING, 0, 20, BASKETTRADEREPORTTEXT_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_VAR_STRUCT, 1, 39, 9, 3 } // BasketRootPartyGrp
        , { ETI_VAR_STRUCT, 2, 227, 151, 13 } // InstrmtMatchSideGrp
        , { ETI_VAR_STRUCT, 0, 104, 77, 6 } // BasketSideAllocGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // EnterCLIPRequest@937
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, PRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, CROSSID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, CROSSREQUESTID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOSIDES_FH_IDX, 2 } // <- counter@0
        , { ETI_COUNTER, 1, 1, NOCROSSLEGS_FH_IDX, 40 } // <- counter@1
        , { ETI_UINT_ENUM, 0, 1, SIDEDISCLOSUREINSTRUCTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRICEDISCLOSUREINSTRUCTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERQTYDISCLOSUREINSTRUCTION_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, ROOTPARTYCONTRAFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, ROOTPARTYCONTRATRADER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 146, 92, 8 } // CrossRequestSideGrp
        , { ETI_VAR_STRUCT, 1, 788, 402, 48 } // SideCrossLegGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // EnterTESTradeRequest@956
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, LASTPX_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSBKDTIME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, UNDERLYINGPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 6, 8, RELATEDCLOSEPRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, RELATEDTRADEQUANTITY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, UNDERLYINGQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, COMPRESSIONID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, UNDERLYINGSETTLEMENTDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, UNDERLYINGMATURITYDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, RELATEDTRADEID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, RELATEDMARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEPUBLISHINDICATOR_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOSIDEALLOCS_FH_IDX, 99 } // <- counter@0
        , { ETI_COUNTER, 1, 1, NOEVENTS_FH_IDX, 2 } // <- counter@1
        , { ETI_COUNTER, 2, 1, NOLEGS_FH_IDX, 20 } // <- counter@2
        , { ETI_COUNTER, 3, 1, NOINSTRATTRIB_FH_IDX, 6 } // <- counter@3
        , { ETI_COUNTER, 4, 1, NOUNDERLYINGSTIPS_FH_IDX, 1 } // <- counter@4
        , { ETI_UINT_ENUM, 0, 1, PARTYIDSETTLEMENTLOCATION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, HEDGETYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SWAPCLEARER_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTTEXT_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, UNDERLYINGSECURITYID_FH_IDX, 0 }
        , { ETI_STRING, 0, 30, UNDERLYINGSECURITYDESC_FH_IDX, 0 }
        , { ETI_STRING, 0, 3, UNDERLYINGCURRENCY_FH_IDX, 0 }
        , { ETI_STRING, 0, 30, UNDERLYINGISSUER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 760, 384, 47 } // SideAllocGrp
        , { ETI_VAR_STRUCT, 2, 838, 426, 51 } // TrdInstrmntLegGrp
        , { ETI_VAR_STRUCT, 1, 270, 169, 15 } // InstrumentEventGrp
        , { ETI_VAR_STRUCT, 3, 247, 165, 14 } // InstrumentAttributeGrp
        , { ETI_VAR_STRUCT, 4, 856, 430, 52 } // UnderlyingStipGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // ForcedLogoutNotification@996
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 423, 213, 24 } // NotifHeader
        , { ETI_COUNTER, 0, 2, VARTEXTLEN_FH_IDX, 2000 } // <- counter@0
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_VAR_STRING, 0, 2000, VARTEXT_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // ForcedUserLogoutNotification@1002
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 423, 213, 24 } // NotifHeader
        , { ETI_UINT, 0, 4, USERNAME_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, VARTEXTLEN_FH_IDX, 2000 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, USERSTATUS_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_VAR_STRING, 0, 2000, VARTEXT_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // Heartbeat@1010
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_EOF, 0, 0, 0, 0 }
        // HeartbeatNotification@1012
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 423, 213, 24 } // NotifHeader
        , { ETI_EOF, 0, 0, 0, 0 }
        // InquireEnrichmentRuleIDListRequest@1015
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_STRING, 0, 16, LASTENTITYPROCESSED_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // InquireEnrichmentRuleIDListResponse@1019
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 594, 300, 36 } // ResponseHeader
        , { ETI_STRING, 0, 16, LASTENTITYPROCESSED_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NOENRICHMENTRULES_FH_IDX, 400 } // <- counter@0
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 166, 116, 9 } // EnrichmentRulesGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // InquireMMParameterRequest@1026
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TARGETPARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // InquireMMParameterResponse@1031
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 358, 199, 21 } // NRResponseHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, MMPARAMETERREPORTID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOMMPARAMETERS_FH_IDX, 9 } // <- counter@0
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 299, 177, 17 } // MMParameterGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // InquirePreTradeRiskLimitsRequest@1039
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, RISKLIMITPLATFORM_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGUNIT_FH_IDX, 0 }
        , { ETI_STRING, 0, 3, RISKLIMITGROUP_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // InquireSessionListRequest@1047
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_EOF, 0, 0, 0, 0 }
        // InquireSessionListResponse@1050
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 594, 300, 36 } // ResponseHeader
        , { ETI_COUNTER, 0, 2, NOSESSIONS_FH_IDX, 1000 } // <- counter@0
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 732, 348, 44 } // SessionsGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // InquireUserRequest@1056
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_STRING, 0, 16, LASTENTITYPROCESSED_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // InquireUserResponse@1060
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 594, 300, 36 } // ResponseHeader
        , { ETI_STRING, 0, 16, LASTENTITYPROCESSED_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NOPARTYDETAILS_FH_IDX, 1000 } // <- counter@0
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 466, 230, 27 } // PartyDetailsGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // LegalNotificationBroadcast@1067
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, VARTEXTLEN_FH_IDX, 2000 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, USERSTATUS_FH_IDX, 0 }
        , { ETI_PADDING, 0, 5, 0, 0 }
        , { ETI_VAR_STRING, 0, 2000, VARTEXT_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // LogonRequest@1075
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_UINT, 0, 4, HEARTBTINT_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_STRING, 0, 30, DEFAULTCSTMAPPLVERID_FH_IDX, 0 }
        , { ETI_STRING, 0, 32, PASSWORD_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, APPLUSAGEORDERS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, APPLUSAGEQUOTES_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDERROUTINGINDICATOR_FH_IDX, 0 }
        , { ETI_STRING, 0, 30, FIXENGINENAME_FH_IDX, 0 }
        , { ETI_STRING, 0, 30, FIXENGINEVERSION_FH_IDX, 0 }
        , { ETI_STRING, 0, 30, FIXENGINEVENDOR_FH_IDX, 0 }
        , { ETI_STRING, 0, 30, APPLICATIONSYSTEMNAME_FH_IDX, 0 }
        , { ETI_STRING, 0, 30, APPLICATIONSYSTEMVERSION_FH_IDX, 0 }
        , { ETI_STRING, 0, 30, APPLICATIONSYSTEMVENDOR_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // LogonResponse@1092
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 594, 300, 36 } // ResponseHeader
        , { ETI_INT, 0, 8, THROTTLETIMEINTERVAL_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, THROTTLENOMSGS_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, THROTTLEDISCONNECTLIMIT_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, HEARTBTINT_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SESSIONINSTANCEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, MARKETID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADSESMODE_FH_IDX, 0 }
        , { ETI_STRING, 0, 30, DEFAULTCSTMAPPLVERID_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, DEFAULTCSTMAPPLVERSUBID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // LogoutRequest@1105
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_EOF, 0, 0, 0, 0 }
        // LogoutResponse@1108
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 594, 300, 36 } // ResponseHeader
        , { ETI_EOF, 0, 0, 0, 0 }
        // MMParameterDefinitionRequest@1111
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_INT, 0, 8, EXPOSUREDURATION_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CUMQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, DELTA_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, VEGA_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TARGETPARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, PCTCOUNT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // MMParameterDefinitionResponse@1122
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 358, 199, 21 } // NRResponseHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // MassQuoteRequest@1126
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MATCHINSTCROSSID_FH_IDX, 0 }
        , { ETI_UINT, 0, 2, ENRICHMENTRULEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRICEVALIDITYCHECKTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEVALUE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTESIZETYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTETYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOQUOTEENTRIES_FH_IDX, 100 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 514, 251, 30 } // QuoteEntryGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // MassQuoteResponse@1145
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 358, 199, 21 } // NRResponseHeaderME
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, QUOTERESPONSEID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOQUOTESIDEENTRIES_FH_IDX, 200 } // <- counter@0
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 497, 244, 29 } // QuoteEntryAckGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // ModifyBasketTradeRequest@1154
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_UINT, 0, 8, BASKETTRDMATCHID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, BASKETEXECID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MATURITYMONTHYEAR_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, BASKETPROFILEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NOBASKETSIDEALLOC_FH_IDX, 398 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_COUNTER, 1, 1, NOBASKETROOTPARTYGRPS_FH_IDX, 2 } // <- counter@1
        , { ETI_COUNTER, 2, 1, NOINSTRMTMATCHSIDES_FH_IDX, 199 } // <- counter@2
        , { ETI_STRING, 0, 20, BASKETTRADEREPORTTEXT_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_VAR_STRUCT, 1, 39, 9, 3 } // BasketRootPartyGrp
        , { ETI_VAR_STRUCT, 2, 227, 151, 13 } // InstrmtMatchSideGrp
        , { ETI_VAR_STRUCT, 0, 104, 77, 6 } // BasketSideAllocGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // ModifyOrderComplexRequest@1173
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORIGCLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, PRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDCLIENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, EXPIREDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MATCHINSTCROSSID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TARGETPARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYIDTAKEUPTRADINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 7, PARTYIDORDERORIGINATIONFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 9, PARTYIDBENEFICIARY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLSEQINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRICEVALIDITYCHECKTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEVALUE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECINST_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TIMEINFORCE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, OWNERSHIPINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERORIGINATION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, PARTYIDLOCATIONID_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, CUSTORDERHANDLINGINST_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, COMPLIANCETEXT_FH_IDX, 0 }
        , { ETI_STRING, 0, 32, PARTYIDPOSITIONACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT3_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIXCLORDID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOLEGS_FH_IDX, 20 } // <- counter@0
        , { ETI_PADDING, 0, 5, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 289, 173, 16 } // LegOrdGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // ModifyOrderComplexShortRequest@1217
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORIGCLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, PRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDCLIENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MATCHINSTCROSSID_FH_IDX, 0 }
        , { ETI_UINT, 0, 2, ENRICHMENTRULEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLSEQINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRICEVALIDITYCHECKTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEVALUE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECINST_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TIMEINFORCE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERORIGINATION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, COMPLIANCETEXT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // ModifyOrderNRResponse@1245
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 358, 199, 21 } // NRResponseHeaderME
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORIGCLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LEAVESQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CUMQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CXLQTY_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, EXECTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, EXECRESTATEMENTREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, CROSSEDINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRIGGERED_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRANSACTIONDELAYINDICATOR_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOORDEREVENTS_FH_IDX, 100 } // <- counter@0
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 452, 224, 26 } // OrderEventGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // ModifyOrderResponse@1266
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 609, 305, 37 } // ResponseHeaderME
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORIGCLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LEAVESQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CUMQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CXLQTY_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSTIMEPRIORITY_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, EXECTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, EXECRESTATEMENTREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, CROSSEDINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRIGGERED_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRANSACTIONDELAYINDICATOR_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOORDEREVENTS_FH_IDX, 100 } // <- counter@0
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 452, 224, 26 } // OrderEventGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // ModifyOrderSingleRequest@1288
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORIGCLORDID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, PRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, STOPPX_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDCLIENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, EXPIREDATE_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SIMPLESECURITYID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MATCHINSTCROSSID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TARGETPARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYIDTAKEUPTRADINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 7, PARTYIDORDERORIGINATIONFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 9, PARTYIDBENEFICIARY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLSEQINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRICEVALIDITYCHECKTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEVALUE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TIMEINFORCE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECINST_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGSESSIONSUBID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERORIGINATION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, ACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 32, PARTYIDPOSITIONACCOUNT_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, POSITIONEFFECT_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, OWNERSHIPINDICATOR_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, PARTYIDLOCATIONID_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, CUSTORDERHANDLINGINST_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, COMPLIANCETEXT_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT3_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIXCLORDID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // ModifyOrderSingleShortRequest@1333
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORIGCLORDID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, PRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDCLIENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SIMPLESECURITYID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MATCHINSTCROSSID_FH_IDX, 0 }
        , { ETI_UINT, 0, 2, ENRICHMENTRULEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRICEVALIDITYCHECKTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEVALUE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TIMEINFORCE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLSEQINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECINST_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERORIGINATION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, COMPLIANCETEXT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // ModifyTESTradeRequest@1359
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_FIXED_POINT, 8, 8, LASTPX_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSBKDTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, COMPRESSIONID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PACKAGEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TESEXECID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, RELATEDMARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEPUBLISHINDICATOR_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOSIDEALLOCS_FH_IDX, 99 } // <- counter@0
        , { ETI_COUNTER, 1, 1, NOLEGS_FH_IDX, 20 } // <- counter@1
        , { ETI_UINT_ENUM, 0, 1, SWAPCLEARER_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTTEXT_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 760, 384, 47 } // SideAllocGrp
        , { ETI_VAR_STRUCT, 1, 838, 426, 51 } // TrdInstrmntLegGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // NewOrderComplexRequest@1380
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, PRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDCLIENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, EXPIREDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MATCHINSTCROSSID_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYIDTAKEUPTRADINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 7, PARTYIDORDERORIGINATIONFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 9, PARTYIDBENEFICIARY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLSEQINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRICEVALIDITYCHECKTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEVALUE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTERISKREDUCTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECINST_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TIMEINFORCE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERORIGINATION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, PARTYIDLOCATIONID_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, COMPLIANCETEXT_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, CUSTORDERHANDLINGINST_FH_IDX, 0 }
        , { ETI_STRING, 0, 32, PARTYIDPOSITIONACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT3_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIXCLORDID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOLEGS_FH_IDX, 20 } // <- counter@0
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 289, 173, 16 } // LegOrdGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // NewOrderComplexShortRequest@1421
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, PRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDCLIENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MATCHINSTCROSSID_FH_IDX, 0 }
        , { ETI_UINT, 0, 2, ENRICHMENTRULEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLSEQINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRICEVALIDITYCHECKTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEVALUE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECINST_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TIMEINFORCE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERORIGINATION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, COMPLIANCETEXT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // NewOrderNRResponse@1448
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 358, 199, 21 } // NRResponseHeaderME
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LEAVESQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CXLQTY_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, EXECTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, EXECRESTATEMENTREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, CROSSEDINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRIGGERED_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRANSACTIONDELAYINDICATOR_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOORDEREVENTS_FH_IDX, 100 } // <- counter@0
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 452, 224, 26 } // OrderEventGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // NewOrderResponse@1467
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 609, 305, 37 } // ResponseHeaderME
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LEAVESQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CXLQTY_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSENTRYTIME_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSTIMEPRIORITY_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, EXECTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, EXECRESTATEMENTREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, CROSSEDINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRIGGERED_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRANSACTIONDELAYINDICATOR_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOORDEREVENTS_FH_IDX, 100 } // <- counter@0
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 452, 224, 26 } // OrderEventGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // NewOrderSingleRequest@1488
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_FIXED_POINT, 8, 8, PRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, STOPPX_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDCLIENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, EXPIREDATE_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SIMPLESECURITYID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MATCHINSTCROSSID_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYIDTAKEUPTRADINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 7, PARTYIDORDERORIGINATIONFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 9, PARTYIDBENEFICIARY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLSEQINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRICEVALIDITYCHECKTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEVALUE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTERISKREDUCTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TIMEINFORCE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECINST_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGSESSIONSUBID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERORIGINATION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, ACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 32, PARTYIDPOSITIONACCOUNT_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, POSITIONEFFECT_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, PARTYIDLOCATIONID_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, CUSTORDERHANDLINGINST_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, COMPLIANCETEXT_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT3_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIXCLORDID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // NewOrderSingleShortRequest@1530
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_FIXED_POINT, 8, 8, PRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDCLIENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SIMPLESECURITYID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MATCHINSTCROSSID_FH_IDX, 0 }
        , { ETI_UINT, 0, 2, ENRICHMENTRULEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLSEQINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRICEVALIDITYCHECKTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEVALUE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TIMEINFORCE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECINST_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERORIGINATION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, COMPLIANCETEXT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // NewsBroadcast@1555
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, ORIGTIME_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, VARTEXTLEN_FH_IDX, 2000 } // <- counter@0
        , { ETI_STRING, 0, 256, HEADLINE_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_VAR_STRING, 0, 2000, VARTEXT_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // OrderExecNotification@1563
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 568, 286, 34 } // RBCHeaderME
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORIGCLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LEAVESQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CUMQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CXLQTY_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NOLEGEXECS_FH_IDX, 600 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 2, EXECRESTATEMENTREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, EXECTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRIGGERED_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, CROSSEDINDICATOR_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIXCLORDID_FH_IDX, 0 }
        , { ETI_COUNTER, 1, 1, NOFILLS_FH_IDX, 100 } // <- counter@1
        , { ETI_COUNTER, 2, 1, NOORDEREVENTS_FH_IDX, 100 } // <- counter@2
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_VAR_STRUCT, 1, 185, 128, 10 } // FillsGrp
        , { ETI_VAR_STRUCT, 0, 194, 135, 11 } // InstrmntLegExecGrp
        , { ETI_VAR_STRUCT, 2, 452, 224, 26 } // OrderEventGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // OrderExecReportBroadcast@1590
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 568, 286, 34 } // RBCHeaderME
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORIGCLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSENTRYTIME_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSTIMEPRIORITY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, PRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LEAVESQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CUMQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CXLQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, STOPPX_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, EXPIREDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MATCHINSTCROSSID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDEXECUTINGUNIT_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDENTERINGTRADER_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NOLEGEXECS_FH_IDX, 600 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 2, EXECRESTATEMENTREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDENTERINGFIRM_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, EXECTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TIMEINFORCE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECINST_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGSESSIONSUBID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLSEQINDICATOR_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, ACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 32, PARTYIDPOSITIONACCOUNT_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, POSITIONEFFECT_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYIDTAKEUPTRADINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 7, PARTYIDORDERORIGINATIONFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 9, PARTYIDBENEFICIARY_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, PARTYIDLOCATIONID_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, CUSTORDERHANDLINGINST_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, COMPLIANCETEXT_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT3_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIXCLORDID_FH_IDX, 0 }
        , { ETI_COUNTER, 1, 1, NOFILLS_FH_IDX, 100 } // <- counter@1
        , { ETI_COUNTER, 2, 1, NOLEGS_FH_IDX, 20 } // <- counter@2
        , { ETI_COUNTER, 3, 1, NOORDEREVENTS_FH_IDX, 100 } // <- counter@3
        , { ETI_UINT_ENUM, 0, 1, TRIGGERED_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, CROSSEDINDICATOR_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_VAR_STRUCT, 2, 289, 173, 16 } // LegOrdGrp
        , { ETI_VAR_STRUCT, 1, 185, 128, 10 } // FillsGrp
        , { ETI_VAR_STRUCT, 0, 194, 135, 11 } // InstrmntLegExecGrp
        , { ETI_VAR_STRUCT, 3, 452, 224, 26 } // OrderEventGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // OrderExecResponse@1649
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 609, 305, 37 } // ResponseHeaderME
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORIGCLORDID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSENTRYTIME_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSTIMEPRIORITY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LEAVESQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CUMQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CXLQTY_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NOLEGEXECS_FH_IDX, 600 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 2, EXECRESTATEMENTREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, EXECTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRIGGERED_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, CROSSEDINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRANSACTIONDELAYINDICATOR_FH_IDX, 0 }
        , { ETI_COUNTER, 1, 1, NOFILLS_FH_IDX, 100 } // <- counter@1
        , { ETI_COUNTER, 2, 1, NOORDEREVENTS_FH_IDX, 100 } // <- counter@2
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_VAR_STRUCT, 1, 185, 128, 10 } // FillsGrp
        , { ETI_VAR_STRUCT, 0, 194, 135, 11 } // InstrmntLegExecGrp
        , { ETI_VAR_STRUCT, 2, 452, 224, 26 } // OrderEventGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // PartyActionReport@1678
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TRADEDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, REQUESTINGPARTYIDEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDEXECUTINGUNIT_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 4, REQUESTINGPARTYIDEXECUTINGSYSTEM_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, MARKETID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYACTIONTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, REQUESTINGPARTYIDENTERINGFIRM_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // PartyEntitlementsUpdateReport@1690
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TRADEDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYDETAILIDEXECUTINGUNIT_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 4, REQUESTINGPARTYIDEXECUTINGSYSTEM_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, MARKETID_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, LISTUPDATEACTION_FH_IDX, 0 }
        , { ETI_STRING, 0, 9, REQUESTINGPARTYENTERINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 9, REQUESTINGPARTYCLEARINGFIRM_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYDETAILSTATUS_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // PingRequest@1703
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_UINT, 0, 2, PARTITIONID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // PingResponse@1708
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 358, 199, 21 } // NRResponseHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // PreTradeRiskLimitResponse@1712
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 358, 199, 21 } // NRResponseHeaderME
        , { ETI_UINT, 0, 8, RISKLIMITREPORTID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NORISKLIMITS_FH_IDX, 64 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, PARTYDETAILSTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, RISKLIMITPLATFORM_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYDETAILEXECUTINGUNIT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 642, 320, 39 } // RiskLimitsRptGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // PreTradeRiskLimitsDefinitionRequest@1723
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_FIXED_POINT, 4, 8, NETTINGCOEFFICIENT_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, RISKLIMITPLATFORM_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NORISKLIMITSQTY_FH_IDX, 2 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, PARTYDETAILSTATUS_FH_IDX, 0 }
        , { ETI_STRING, 0, 3, RISKLIMITGROUP_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYDETAILEXECUTINGUNIT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 626, 316, 38 } // RiskLimitQtyGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // QuoteActivationNotification@1735
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 568, 286, 34 } // RBCHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, MASSACTIONREPORTID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYIDENTERINGTRADER_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NONOTAFFECTEDSECURITIES_FH_IDX, 500 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, PARTYIDENTERINGFIRM_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MASSACTIONTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MASSACTIONSUBTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MASSACTIONREASON_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 398, 211, 23 } // NotAffectedSecuritiesGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // QuoteActivationRequest@1748
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TARGETPARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MASSACTIONTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MASSACTIONSUBTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // QuoteActivationResponse@1760
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 358, 199, 21 } // NRResponseHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, MASSACTIONREPORTID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NONOTAFFECTEDSECURITIES_FH_IDX, 500 } // <- counter@0
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 398, 211, 23 } // NotAffectedSecuritiesGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // QuoteExecutionReport@1767
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 568, 286, 34 } // RBCHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NOLEGEXECS_FH_IDX, 600 } // <- counter@0
        , { ETI_COUNTER, 1, 1, NOQUOTEEVENTS_FH_IDX, 100 } // <- counter@1
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_VAR_STRUCT, 1, 528, 257, 31 } // QuoteEventGrp
        , { ETI_VAR_STRUCT, 0, 542, 269, 32 } // QuoteLegExecGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // RFQRequest@1777
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, COMPLIANCETEXT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // RFQResponse@1786
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 358, 199, 21 } // NRResponseHeaderME
        , { ETI_TIMESTAMP_NS, 0, 8, EXECID_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // Reject@1790
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 358, 199, 21 } // NRResponseHeaderME
        , { ETI_UINT_ENUM, 0, 4, SESSIONREJECTREASON_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, VARTEXTLEN_FH_IDX, 2000 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, SESSIONSTATUS_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_VAR_STRING, 0, 2000, VARTEXT_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // RetransmitMEMessageRequest@1798
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_UINT, 0, 4, SUBSCRIPTIONSCOPE_FH_IDX, 0 }
        , { ETI_UINT, 0, 2, PARTITIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, REFAPPLID_FH_IDX, 0 }
        , { ETI_STRING, 0, 16, APPLBEGMSGID_FH_IDX, 0 }
        , { ETI_STRING, 0, 16, APPLENDMSGID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // RetransmitMEMessageResponse@1807
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 594, 300, 36 } // ResponseHeader
        , { ETI_UINT, 0, 2, APPLTOTALMESSAGECOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 16, APPLENDMSGID_FH_IDX, 0 }
        , { ETI_STRING, 0, 16, REFAPPLLASTMSGID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // RetransmitRequest@1814
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_UINT, 0, 8, APPLBEGSEQNUM_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, APPLENDSEQNUM_FH_IDX, 0 }
        , { ETI_UINT, 0, 2, PARTITIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, REFAPPLID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 5, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // RetransmitResponse@1822
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 594, 300, 36 } // ResponseHeader
        , { ETI_UINT, 0, 8, APPLENDSEQNUM_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, REFAPPLLASTSEQNUM_FH_IDX, 0 }
        , { ETI_UINT, 0, 2, APPLTOTALMESSAGECOUNT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // ReverseTESTradeRequest@1829
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PACKAGEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TESEXECID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, RELATEDMARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_STRING, 0, 132, REVERSALREASONTEXT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // RiskNotificationBroadcast@1840
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TRADEDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PARTYDETAILIDEXECUTINGUNIT_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 4, REQUESTINGPARTYIDEXECUTINGSYSTEM_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, MARKETID_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, LISTUPDATEACTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, RISKLIMITACTION_FH_IDX, 0 }
        , { ETI_STRING, 0, 9, REQUESTINGPARTYENTERINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 9, REQUESTINGPARTYCLEARINGFIRM_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SRQSCreateDealNotification@1853
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, LASTPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LASTQTY_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXPIRETIME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, UNDERLYINGPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, UNDERLYINGDELTAPERCENTAGE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, UNDERLYINGEFFECTIVEDELTAPERCENTAGE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, UNDERLYINGQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, UNDERLYINGPRICESTIPVALUE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TRADEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ORIGTRADEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRDRPTSTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, MESSAGEEVENTSOURCE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOORDERBOOKITEMS_FH_IDX, 26 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEPUBLISHINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, HEDGINGINSTRUCTION_FH_IDX, 0 }
        , { ETI_COUNTER, 1, 1, NOSRQSTARGETPARTYTRDGRPS_FH_IDX, 30 } // <- counter@1
        , { ETI_STRING, 0, 5, ROOTPARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, ROOTPARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, ROOTPARTYENTERINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIRMTRADEID_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIRMNEGOTIATIONID_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT3_FH_IDX, 0 }
        , { ETI_STRING, 0, 132, FREETEXT5_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, POSITIONEFFECT_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, ACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 9, PARTYIDBENEFICIARY_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, CUSTORDERHANDLINGINST_FH_IDX, 0 }
        , { ETI_STRING, 0, 7, PARTYIDORDERORIGINATIONFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 32, PARTYIDPOSITIONACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, PARTYIDLOCATIONID_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, COMPLIANCETEXT_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYIDTAKEUPTRADINGFIRM_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 435, 215, 25 } // OrderBookItemGrp
        , { ETI_VAR_STRUCT, 1, 710, 340, 43 } // SRQSTargetPartyTrdGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // SRQSDealNotification@1899
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, UNDERLYINGPRICESTIPVALUE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, UNDERLYINGPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, LASTPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LASTQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TRADEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, REQUESTINGPARTYSUBIDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRDRPTSTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEREQUESTRESULT_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, MESSAGEEVENTSOURCE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOSRQSTARGETPARTYTRDGRPS_FH_IDX, 30 } // <- counter@0
        , { ETI_STRING, 0, 5, ROOTPARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, ROOTPARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, ROOTPARTYENTERINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIRMTRADEID_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIRMNEGOTIATIONID_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT3_FH_IDX, 0 }
        , { ETI_STRING, 0, 132, FREETEXT5_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, POSITIONEFFECT_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, ACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 9, PARTYIDBENEFICIARY_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, CUSTORDERHANDLINGINST_FH_IDX, 0 }
        , { ETI_STRING, 0, 7, PARTYIDORDERORIGINATIONFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 32, PARTYIDPOSITIONACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, PARTYIDLOCATIONID_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, COMPLIANCETEXT_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYIDTAKEUPTRADINGFIRM_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 710, 340, 43 } // SRQSTargetPartyTrdGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // SRQSDealResponse@1935
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 594, 300, 36 } // ResponseHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TRADEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SECONDARYTRADEID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOSRQSQUOTEGRPS_FH_IDX, 30 } // <- counter@0
        , { ETI_STRING, 0, 20, FIRMTRADEID_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIRMNEGOTIATIONID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 675, 335, 41 } // SRQSQuoteGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // SRQSEnterQuoteRequest@1947
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_FIXED_POINT, 8, 8, BIDPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, OFFERPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, UNDERLYINGDELTAPERCENTAGE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, BIDSIZE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, OFFERSIZE_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDCLIENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, QUOTEREFPRICE_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, VALIDUNTILTIME_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT3_FH_IDX, 0 }
        , { ETI_STRING, 0, 132, FREETEXT5_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, POSITIONEFFECT_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, ACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 9, PARTYIDBENEFICIARY_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, CUSTORDERHANDLINGINST_FH_IDX, 0 }
        , { ETI_STRING, 0, 7, PARTYIDORDERORIGINATIONFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 32, PARTYIDPOSITIONACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, PARTYIDLOCATIONID_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, COMPLIANCETEXT_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYIDTAKEUPTRADINGFIRM_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SRQSHitQuoteRequest@1982
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_TIMESTAMP_NS, 0, 8, VALIDUNTILTIME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, UNDERLYINGQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, UNDERLYINGPRICESTIPVALUE_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDCLIENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, PARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEPUBLISHINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERORIGINATION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, HEDGINGINSTRUCTION_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOSRQSQUOTEGRPS_FH_IDX, 30 } // <- counter@0
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIRMTRADEID_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT3_FH_IDX, 0 }
        , { ETI_STRING, 0, 132, FREETEXT5_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, POSITIONEFFECT_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, ACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 9, PARTYIDBENEFICIARY_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, CUSTORDERHANDLINGINST_FH_IDX, 0 }
        , { ETI_STRING, 0, 7, PARTYIDORDERORIGINATIONFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 32, PARTYIDPOSITIONACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, PARTYIDLOCATIONID_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, COMPLIANCETEXT_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYIDTAKEUPTRADINGFIRM_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 659, 330, 40 } // SRQSHitQuoteGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // SRQSInquireSmartRespondentRequest@2019
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EUREXVOLUMERANKING_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ENLIGHTRFQAVGRESPTIMERANKING_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ENLIGHTRFQAVGRESPRATERANKING_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADETOQUOTERATIORANKING_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SRQSInquireSmartRespondentResponse@2027
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 594, 300, 36 } // ResponseHeader
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, NOPARTYDETAILS_FH_IDX, 1000 } // <- counter@0
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 804, 407, 49 } // SmartPartyDetailGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // SRQSNegotiationNotification@2034
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, QUOTEREFPRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, UNDERLYINGDELTAPERCENTAGE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, BIDPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, OFFERPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, LASTPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LEAVESQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LASTQTY_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EFFECTIVETIME_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, LASTUPDATETIME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, TRADETOQUOTERATIO_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NUMBEROFRESPONDENTS_FH_IDX, 0 }
        , { ETI_UINT, 0, 2, TRADETOQUOTERATIOPOSITION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTETYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTESUBTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTEINSTRUCTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEAGGREGATIONTRANSTYPE_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, QUOTECONDITION_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYENTERINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, TARGETPARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, TARGETPARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIRMNEGOTIATIONID_FH_IDX, 0 }
        , { ETI_STRING, 0, 132, FREETEXT5_FH_IDX, 0 }
        , { ETI_STRING, 0, 132, PARTYORDERORIGINATIONTRADER_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SRQSNegotiationRequesterNotification@2065
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRDREGTSEXECUTIONTIME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, QUOTEREFPRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, UNDERLYINGDELTAPERCENTAGE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, BIDPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, OFFERPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, LASTPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LEAVESQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LASTQTY_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EFFECTIVETIME_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, LASTUPDATETIME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, TRADETOREQUESTRATIO_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NUMBEROFRESPONDENTS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTETYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTESUBTYPE_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOTARGETPARTYIDS_FH_IDX, 50 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, NUMBEROFRESPDISCLOSUREINSTRUCTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SHOWLASTDEALONCLOSURE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEAGGREGATIONTRANSTYPE_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, QUOTECONDITION_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYENTERINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIRMNEGOTIATIONID_FH_IDX, 0 }
        , { ETI_STRING, 0, 132, FREETEXT5_FH_IDX, 0 }
        , { ETI_STRING, 0, 132, PARTYORDERORIGINATIONTRADER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 824, 411, 50 } // TargetParties
        , { ETI_EOF, 0, 0, 0, 0 }
        // SRQSNegotiationStatusNotification@2099
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EFFECTIVETIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, QUOTECONDITION_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIRMNEGOTIATIONID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SRQSOpenNegotiationNotification@2108
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, NEGOTIATIONSTARTTIME_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, BIDPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, OFFERPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LEAVESQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LASTQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, LASTPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, QUOTEREFPRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, UNDERLYINGDELTAPERCENTAGE_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXPIRETIME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, TRADETOREQUESTRATIO_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, TRADETOQUOTERATIO_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, SECURITYSUBTYPE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NUMBEROFRESPONDENTS_FH_IDX, 0 }
        , { ETI_UINT, 0, 2, TRADETOQUOTERATIOPOSITION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTETYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTESUBTYPE_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOLEGS_FH_IDX, 20 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, RESPONDENTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEAGGREGATIONTRANSTYPE_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, QUOTECONDITION_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYENTERINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, TARGETPARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, TARGETPARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIRMNEGOTIATIONID_FH_IDX, 0 }
        , { ETI_STRING, 0, 132, FREETEXT5_FH_IDX, 0 }
        , { ETI_STRING, 0, 132, PARTYORDERORIGINATIONTRADER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 6, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 482, 237, 28 } // QuotReqLegsGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // SRQSOpenNegotiationRequest@2147
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, BIDPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, OFFERPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, QUOTEREFPRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, UNDERLYINGDELTAPERCENTAGE_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, VALIDUNTILTIME_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, SECURITYSUBTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTETYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTESUBTYPE_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOLEGS_FH_IDX, 20 } // <- counter@0
        , { ETI_COUNTER, 1, 1, NOTARGETPARTYIDS_FH_IDX, 50 } // <- counter@1
        , { ETI_UINT_ENUM, 0, 1, NUMBEROFRESPDISCLOSUREINSTRUCTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, RESPONDENTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SHOWLASTDEALONCLOSURE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, BIDPXISLOCKED_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, OFFERPXISLOCKED_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDEISLOCKED_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERQTYISLOCKED_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEAGGREGATIONTRANSTYPE_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, QUOTECONDITION_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 132, FREETEXT5_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, QUOTEREQID_FH_IDX, 0 }
        , { ETI_STRING, 0, 132, PARTYORDERORIGINATIONTRADER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 482, 237, 28 } // QuotReqLegsGrp
        , { ETI_VAR_STRUCT, 1, 824, 411, 50 } // TargetParties
        , { ETI_EOF, 0, 0, 0, 0 }
        // SRQSOpenNegotiationRequesterNotification@2182
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, BIDPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, OFFERPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, LASTPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LASTQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, QUOTEREFPRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, UNDERLYINGDELTAPERCENTAGE_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXPIRETIME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, TRADETOREQUESTRATIO_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, SECURITYSUBTYPE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NUMBEROFRESPONDENTS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTETYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTESUBTYPE_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOLEGS_FH_IDX, 20 } // <- counter@0
        , { ETI_COUNTER, 1, 1, NOTARGETPARTYIDS_FH_IDX, 50 } // <- counter@1
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, NUMBEROFRESPDISCLOSUREINSTRUCTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, RESPONDENTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SHOWLASTDEALONCLOSURE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, BIDPXISLOCKED_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, OFFERPXISLOCKED_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDEISLOCKED_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERQTYISLOCKED_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEAGGREGATIONTRANSTYPE_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, QUOTECONDITION_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYENTERINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, FIRMNEGOTIATIONID_FH_IDX, 0 }
        , { ETI_STRING, 0, 132, FREETEXT5_FH_IDX, 0 }
        , { ETI_STRING, 0, 132, PARTYORDERORIGINATIONTRADER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 482, 237, 28 } // QuotReqLegsGrp
        , { ETI_VAR_STRUCT, 1, 824, 411, 50 } // TargetParties
        , { ETI_EOF, 0, 0, 0, 0 }
        // SRQSQuoteNotification@2224
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, SECONDARYQUOTEID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, BIDPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, BIDSIZE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, OFFERPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, OFFERSIZE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, UNDERLYINGDELTAPERCENTAGE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, QUOTEREFPRICE_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, EXPIRETIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTINGSTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTECANCELREASON_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_UINT, 0, 4, PARTYIDEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYENTERINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, QUOTEREQID_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT3_FH_IDX, 0 }
        , { ETI_STRING, 0, 132, FREETEXT5_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, POSITIONEFFECT_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, ACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 9, PARTYIDBENEFICIARY_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, CUSTORDERHANDLINGINST_FH_IDX, 0 }
        , { ETI_STRING, 0, 7, PARTYIDORDERORIGINATIONFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 32, PARTYIDPOSITIONACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, PARTYIDLOCATIONID_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, COMPLIANCETEXT_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYIDTAKEUPTRADINGFIRM_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SRQSQuoteResponse@2260
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 594, 300, 36 } // ResponseHeader
        , { ETI_UINT, 0, 8, QUOTEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, QUOTEREQID_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SRQSQuotingStatusRequest@2266
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTINGSTATUS_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 132, FREETEXT5_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SRQSStatusBroadcast@2275
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_UINT, 0, 4, TRADEDATE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADSESEVENT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SRQSUpdateDealStatusRequest@2281
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_FIXED_POINT, 8, 8, UNDERLYINGPRICESTIPVALUE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, UNDERLYINGPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LASTQTY_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TRADEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRDRPTSTATUS_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 132, FREETEXT5_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SRQSUpdateNegotiationRequest@2296
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_FIXED_POINT, 8, 8, QUOTEREFPRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, UNDERLYINGDELTAPERCENTAGE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, BIDPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, OFFERPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ORDERQTY_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOTARGETPARTYIDS_FH_IDX, 50 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, NUMBEROFRESPDISCLOSUREINSTRUCTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SHOWLASTDEALONCLOSURE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTETYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, QUOTESUBTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, RESPONDENTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEAGGREGATIONTRANSTYPE_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, QUOTECONDITION_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 132, FREETEXT5_FH_IDX, 0 }
        , { ETI_STRING, 0, 132, PARTYORDERORIGINATIONTRADER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 824, 411, 50 } // TargetParties
        , { ETI_EOF, 0, 0, 0, 0 }
        // ServiceAvailabilityBroadcast@2321
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 347, 193, 20 } // NRBCHeader
        , { ETI_UINT, 0, 4, MATCHINGENGINETRADEDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TRADEMANAGERTRADEDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, APPLSEQTRADEDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, T7ENTRYSERVICETRADEDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, T7ENTRYSERVICERTMTRADEDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 2, PARTITIONID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MATCHINGENGINESTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEMANAGERSTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, APPLSEQSTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, T7ENTRYSERVICESTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, T7ENTRYSERVICERTMSTATUS_FH_IDX, 0 }
        , { ETI_PADDING, 0, 5, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // ServiceAvailabilityMarketBroadcast@2336
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 347, 193, 20 } // NRBCHeader
        , { ETI_UINT, 0, 4, SELECTIVEREQUESTFORQUOTESERVICETRADEDATE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SELECTIVEREQUESTFORQUOTESERVICESTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SELECTIVEREQUESTFORQUOTERTMSERVICESTATUS_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SubscribeRequest@2343
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_UINT, 0, 4, SUBSCRIPTIONSCOPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, REFAPPLID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // SubscribeResponse@2349
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 594, 300, 36 } // ResponseHeader
        , { ETI_UINT, 0, 4, APPLSUBID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // TESApproveBroadcast@2354
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, LASTPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, ALLOCQTY_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, UNDERLYINGPX_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSBKDTIME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 6, 8, RELATEDCLOSEPRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, RELATEDTRADEQUANTITY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, UNDERLYINGQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, COMPRESSIONID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PACKAGEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TESEXECID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ALLOCID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, UNDERLYINGSETTLEMENTDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, UNDERLYINGMATURITYDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, RELATEDTRADEID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, RELATEDMARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TESENRICHMENTRULEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, AUTOAPPROVALRULEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, VARTEXTLEN_FH_IDX, 2000 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEPUBLISHINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRDRPTSTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDSETTLEMENTLOCATION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEALLOCSTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, HEDGETYPE_FH_IDX, 0 }
        , { ETI_COUNTER, 1, 1, NOLEGS_FH_IDX, 20 } // <- counter@1
        , { ETI_COUNTER, 2, 1, NOEVENTS_FH_IDX, 2 } // <- counter@2
        , { ETI_COUNTER, 3, 1, NOINSTRATTRIB_FH_IDX, 6 } // <- counter@3
        , { ETI_COUNTER, 4, 1, NOUNDERLYINGSTIPS_FH_IDX, 1 } // <- counter@4
        , { ETI_CHAR, 0, 1, MESSAGEEVENTSOURCE_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDENTERINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, PARTYENTERINGTRADER_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, POSITIONEFFECT_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, ROOTPARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, ROOTPARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT3_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, PARTYIDTAKEUPTRADINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, ACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 32, PARTYIDPOSITIONACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 7, PARTYIDORDERORIGINATIONFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 9, PARTYIDBENEFICIARY_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, PARTYIDLOCATIONID_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, CUSTORDERHANDLINGINST_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, COMPLIANCETEXT_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, UNDERLYINGSECURITYID_FH_IDX, 0 }
        , { ETI_STRING, 0, 30, UNDERLYINGSECURITYDESC_FH_IDX, 0 }
        , { ETI_STRING, 0, 3, UNDERLYINGCURRENCY_FH_IDX, 0 }
        , { ETI_STRING, 0, 30, UNDERLYINGISSUER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_VAR_STRUCT, 1, 838, 426, 51 } // TrdInstrmntLegGrp
        , { ETI_VAR_STRUCT, 2, 270, 169, 15 } // InstrumentEventGrp
        , { ETI_VAR_STRUCT, 3, 247, 165, 14 } // InstrumentAttributeGrp
        , { ETI_VAR_STRUCT, 4, 856, 430, 52 } // UnderlyingStipGrp
        , { ETI_VAR_STRING, 0, 2000, VARTEXT_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // TESBroadcast@2423
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, LASTPX_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, UNDERLYINGPX_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSBKDTIME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 6, 8, RELATEDCLOSEPRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, RELATEDTRADEQUANTITY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, UNDERLYINGQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, COMPRESSIONID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PACKAGEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TESEXECID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, UNDERLYINGSETTLEMENTDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, UNDERLYINGMATURITYDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, RELATEDTRADEID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, RELATEDMARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, AUTOAPPROVALRULEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 2, VARTEXTLEN_FH_IDX, 2000 } // <- counter@0
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRDRPTSTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEPUBLISHINDICATOR_FH_IDX, 0 }
        , { ETI_COUNTER, 1, 1, NOEVENTS_FH_IDX, 2 } // <- counter@1
        , { ETI_COUNTER, 2, 1, NOINSTRATTRIB_FH_IDX, 6 } // <- counter@2
        , { ETI_COUNTER, 3, 1, NOUNDERLYINGSTIPS_FH_IDX, 1 } // <- counter@3
        , { ETI_COUNTER, 4, 1, NOSIDEALLOCS_FH_IDX, 99 } // <- counter@4
        , { ETI_COUNTER, 5, 1, NOLEGS_FH_IDX, 20 } // <- counter@5
        , { ETI_UINT_ENUM, 0, 1, PARTYIDSETTLEMENTLOCATION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, HEDGETYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SWAPCLEARER_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, MESSAGEEVENTSOURCE_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTTEXT_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, ROOTPARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, ROOTPARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, UNDERLYINGSECURITYID_FH_IDX, 0 }
        , { ETI_STRING, 0, 30, UNDERLYINGSECURITYDESC_FH_IDX, 0 }
        , { ETI_STRING, 0, 3, UNDERLYINGCURRENCY_FH_IDX, 0 }
        , { ETI_STRING, 0, 30, UNDERLYINGISSUER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_VAR_STRUCT, 4, 773, 392, 46 } // SideAllocGrpBC
        , { ETI_VAR_STRUCT, 5, 838, 426, 51 } // TrdInstrmntLegGrp
        , { ETI_VAR_STRUCT, 1, 270, 169, 15 } // InstrumentEventGrp
        , { ETI_VAR_STRUCT, 2, 247, 165, 14 } // InstrumentAttributeGrp
        , { ETI_VAR_STRUCT, 3, 856, 430, 52 } // UnderlyingStipGrp
        , { ETI_VAR_STRING, 0, 2000, VARTEXT_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // TESCompressionRunStatusBroadcast@2473
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_UINT, 0, 8, COMPRESSIONID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, COMPRESSIONACTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, COMPRESSIONSTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEPUBLISHINDICATOR_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // TESCompressionRunStatusRequest@2482
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_UINT, 0, 8, COMPRESSIONID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, COMPRESSIONACTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEPUBLISHINDICATOR_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // TESCompressionRunStatusResponse@2490
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 594, 300, 36 } // ResponseHeader
        , { ETI_UINT, 0, 8, COMPRESSIONID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, COMPRESSIONACTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, COMPRESSIONSTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEPUBLISHINDICATOR_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // TESDeleteBroadcast@2499
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, COMPRESSIONID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PACKAGEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TESEXECID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, DELETEREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRDRPTSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, MESSAGEEVENTSOURCE_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // TESExecutionBroadcast@2514
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, COMPRESSIONID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PACKAGEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TESEXECID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ALLOCID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRDRPTSTATUS_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, MESSAGEEVENTSOURCE_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // TESResponse@2529
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 594, 300, 36 } // ResponseHeader
        , { ETI_UINT, 0, 4, TESEXECID_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // TESReversalBroadcast@2534
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_TIMESTAMP_NS, 0, 8, REVERSALINITIATIONTIME_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PACKAGEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TESEXECID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, RELATEDMARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRDRPTSTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, REVERSALCANCELLATIONREASON_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOSIDEALLOCS_FH_IDX, 99 } // <- counter@0
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_STRING, 0, 132, REVERSALREASONTEXT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 773, 392, 46 } // SideAllocGrpBC
        , { ETI_EOF, 0, 0, 0, 0 }
        // TESTradeBroadcast@2550
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, LASTPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LASTQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, CLEARINGTRADEPRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CLEARINGTRADEQTY_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_INT, 0, 8, RELATEDSECURITYID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, COMPRESSIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ROOTPARTYIDCLIENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ROOTPARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, BASKETTRDMATCHID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, SIDELASTPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, SIDELASTQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PACKAGEID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TRADEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TRADEDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SIDETRADEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ROOTPARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ORIGTRADEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ROOTPARTYIDEXECUTINGUNIT_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ROOTPARTYIDEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ROOTPARTYIDCLEARINGUNIT_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, STRATEGYLINKID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, RELATEDSYMBOL_FH_IDX, 0 }
        , { ETI_INT, 0, 4, TOTNUMTRADEREPORTS_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, NEGOTIATIONID_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOSRQSRELATEDTRADEIDS_FH_IDX, 12 } // <- counter@0
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_UINT, 0, 4, BASKETPROFILEID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, RELATEDPRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRANSFERREASON_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEPUBLISHINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MULTILEGREPORTINGTYPE_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, POSITIONEFFECT_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MULTILEGPRICEMODEL_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTERISKREDUCTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ROOTPARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERORIGINATION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, REVERSALINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEAGGREGATIONTRANSTYPE_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, ACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 32, ROOTPARTYIDPOSITIONACCOUNT_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, CUSTORDERHANDLINGINST_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT3_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, ROOTPARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, ROOTPARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, ROOTPARTYCLEARINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 4, ROOTPARTYCLEARINGORGANIZATION_FH_IDX, 0 }
        , { ETI_STRING, 0, 9, ROOTPARTYIDBENEFICIARY_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, ROOTPARTYIDTAKEUPTRADINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 7, ROOTPARTYIDORDERORIGINATIONFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 4, ROOTPARTYIDEXECUTIONVENUE_FH_IDX, 0 }
        , { ETI_STRING, 0, 52, REGULATORYTRADEID_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, BASKETPARTYCONTRAFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, BASKETSIDETRADEREPORTID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 688, 337, 42 } // SRQSRelatedTradeIDGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // TESTradingSessionStatusBroadcast@2621
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_UINT, 0, 4, TRADEDATE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADSESEVENT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // TESUploadBroadcast@2627
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, LASTPX_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSBKDTIME_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, UNDERLYINGPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 6, 8, RELATEDCLOSEPRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, RELATEDTRADEQUANTITY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, UNDERLYINGQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, COMPRESSIONID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, PACKAGEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TESEXECID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, UNDERLYINGSETTLEMENTDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, UNDERLYINGMATURITYDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, RELATEDTRADEID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, RELATEDMARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRDRPTSTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEPUBLISHINDICATOR_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEPLATFORM_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOSIDEALLOCS_FH_IDX, 99 } // <- counter@0
        , { ETI_COUNTER, 1, 1, NOLEGS_FH_IDX, 20 } // <- counter@1
        , { ETI_COUNTER, 2, 1, NOEVENTS_FH_IDX, 2 } // <- counter@2
        , { ETI_COUNTER, 3, 1, NOINSTRATTRIB_FH_IDX, 6 } // <- counter@3
        , { ETI_COUNTER, 4, 1, NOUNDERLYINGSTIPS_FH_IDX, 1 } // <- counter@4
        , { ETI_UINT_ENUM, 0, 1, HEDGETYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDSETTLEMENTLOCATION_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, MESSAGEEVENTSOURCE_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, ROOTPARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, ROOTPARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, UNDERLYINGSECURITYID_FH_IDX, 0 }
        , { ETI_STRING, 0, 30, UNDERLYINGSECURITYDESC_FH_IDX, 0 }
        , { ETI_STRING, 0, 3, UNDERLYINGCURRENCY_FH_IDX, 0 }
        , { ETI_STRING, 0, 30, UNDERLYINGISSUER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 3, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 744, 353, 45 } // SideAllocExtGrp
        , { ETI_VAR_STRUCT, 1, 838, 426, 51 } // TrdInstrmntLegGrp
        , { ETI_VAR_STRUCT, 2, 270, 169, 15 } // InstrumentEventGrp
        , { ETI_VAR_STRUCT, 3, 247, 165, 14 } // InstrumentAttributeGrp
        , { ETI_VAR_STRUCT, 4, 856, 430, 52 } // UnderlyingStipGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // TMTradingSessionStatusBroadcast@2673
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_UINT_ENUM, 0, 1, TRADSESEVENT_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // ThrottleUpdateNotification@2678
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 423, 213, 24 } // NotifHeader
        , { ETI_INT, 0, 8, THROTTLETIMEINTERVAL_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, THROTTLENOMSGS_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, THROTTLEDISCONNECTLIMIT_FH_IDX, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // TradeBroadcast@2684
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 558, 277, 33 } // RBCHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_INT, 0, 8, RELATEDSECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, PRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, LASTPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LASTQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, SIDELASTPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, SIDELASTQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, CLEARINGTRADEPRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CLEARINGTRADEQTY_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSACTTIME_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ORDERID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, CLORDID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, LEAVESQTY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, CUMQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ROOTPARTYIDCLIENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, EXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, ROOTPARTYIDINVESTMENTDECISIONMAKER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TRADEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ORIGTRADEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ROOTPARTYIDEXECUTINGUNIT_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ROOTPARTYIDSESSIONID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ROOTPARTYIDEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, ROOTPARTYIDCLEARINGUNIT_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, RELATEDSYMBOL_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, SIDETRADEID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, MATCHDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TRDMATCHID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, STRATEGYLINKID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, TOTNUMTRADEREPORTS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MULTILEGREPORTINGTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRANSFERREASON_FH_IDX, 0 }
        , { ETI_STRING, 0, 9, ROOTPARTYIDBENEFICIARY_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, ROOTPARTYIDTAKEUPTRADINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 7, ROOTPARTYIDORDERORIGINATIONFIRM_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MATCHTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, MATCHSUBTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, SIDELIQUIDITYIND_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADINGCAPACITY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERORIGINATION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERATTRIBUTERISKREDUCTION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, EXECUTINGTRADERQUALIFIER_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ROOTPARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX, 0 }
        , { ETI_STRING, 0, 2, ACCOUNT_FH_IDX, 0 }
        , { ETI_STRING, 0, 32, ROOTPARTYIDPOSITIONACCOUNT_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, POSITIONEFFECT_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, CUSTORDERHANDLINGINST_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT1_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT2_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, FREETEXT3_FH_IDX, 0 }
        , { ETI_CHAR, 0, 1, ORDERCATEGORY_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, RELATEDPRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, ORDERSIDE_FH_IDX, 0 }
        , { ETI_STRING, 0, 4, ROOTPARTYCLEARINGORGANIZATION_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, ROOTPARTYEXECUTINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 6, ROOTPARTYEXECUTINGTRADER_FH_IDX, 0 }
        , { ETI_STRING, 0, 5, ROOTPARTYCLEARINGFIRM_FH_IDX, 0 }
        , { ETI_STRING, 0, 52, REGULATORYTRADEID_FH_IDX, 0 }
        , { ETI_STRING, 0, 4, ROOTPARTYIDEXECUTIONVENUE_FH_IDX, 0 }
        , { ETI_PADDING, 0, 2, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // TradingSessionStatusBroadcast@2751
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 568, 286, 34 } // RBCHeaderME
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, TRADEDATE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADSESEVENT_FH_IDX, 0 }
        , { ETI_STRING, 0, 16, REFAPPLLASTMSGID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 7, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // UnsubscribeRequest@2759
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_UINT, 0, 4, REFAPPLSUBID_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // UnsubscribeResponse@2764
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 594, 300, 36 } // ResponseHeader
        , { ETI_EOF, 0, 0, 0, 0 }
        // UploadTESTradeRequest@2767
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_INT, 0, 8, SECURITYID_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, LASTPX_FH_IDX, 0 }
        , { ETI_TIMESTAMP_NS, 0, 8, TRANSBKDTIME_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 8, 8, UNDERLYINGPX_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 6, 8, RELATEDCLOSEPRICE_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, RELATEDTRADEQUANTITY_FH_IDX, 0 }
        , { ETI_FIXED_POINT, 4, 8, UNDERLYINGQTY_FH_IDX, 0 }
        , { ETI_UINT, 0, 8, COMPRESSIONID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, MARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, UNDERLYINGSETTLEMENTDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, UNDERLYINGMATURITYDATE_FH_IDX, 0 }
        , { ETI_UINT, 0, 4, RELATEDTRADEID_FH_IDX, 0 }
        , { ETI_INT, 0, 4, RELATEDMARKETSEGMENTID_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 2, TRDTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PRODUCTCOMPLEX_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEREPORTTYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEPUBLISHINDICATOR_FH_IDX, 0 }
        , { ETI_COUNTER, 0, 1, NOSIDEALLOCS_FH_IDX, 99 } // <- counter@0
        , { ETI_COUNTER, 1, 1, NOLEGS_FH_IDX, 20 } // <- counter@1
        , { ETI_COUNTER, 2, 1, NOEVENTS_FH_IDX, 2 } // <- counter@2
        , { ETI_COUNTER, 3, 1, NOINSTRATTRIB_FH_IDX, 6 } // <- counter@3
        , { ETI_COUNTER, 4, 1, NOUNDERLYINGSTIPS_FH_IDX, 1 } // <- counter@4
        , { ETI_UINT_ENUM, 0, 1, SKIPVALIDATIONS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRDRPTSTATUS_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, TRADEPLATFORM_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, HEDGETYPE_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, PARTYIDSETTLEMENTLOCATION_FH_IDX, 0 }
        , { ETI_UINT_ENUM, 0, 1, VALUECHECKTYPEMINLOTSIZE_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTID_FH_IDX, 0 }
        , { ETI_STRING, 0, 20, TRADEREPORTTEXT_FH_IDX, 0 }
        , { ETI_STRING, 0, 12, UNDERLYINGSECURITYID_FH_IDX, 0 }
        , { ETI_STRING, 0, 30, UNDERLYINGSECURITYDESC_FH_IDX, 0 }
        , { ETI_STRING, 0, 3, UNDERLYINGCURRENCY_FH_IDX, 0 }
        , { ETI_STRING, 0, 30, UNDERLYINGISSUER_FH_IDX, 0 }
        , { ETI_PADDING, 0, 1, 0, 0 }
        , { ETI_VAR_STRUCT, 0, 744, 353, 45 } // SideAllocExtGrp
        , { ETI_VAR_STRUCT, 1, 838, 426, 51 } // TrdInstrmntLegGrp
        , { ETI_VAR_STRUCT, 2, 270, 169, 15 } // InstrumentEventGrp
        , { ETI_VAR_STRUCT, 3, 247, 165, 14 } // InstrumentAttributeGrp
        , { ETI_VAR_STRUCT, 4, 856, 430, 52 } // UnderlyingStipGrp
        , { ETI_EOF, 0, 0, 0, 0 }
        // UserLoginRequest@2810
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_UINT, 0, 4, USERNAME_FH_IDX, 0 }
        , { ETI_STRING, 0, 32, PASSWORD_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // UserLoginResponse@2816
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 594, 300, 36 } // ResponseHeader
        , { ETI_EOF, 0, 0, 0, 0 }
        // UserLogoutRequest@2819
        , { ETI_STRUCT, 0, 314, 184, 18 } // MessageHeaderIn
        , { ETI_STRUCT, 0, 580, 297, 35 } // RequestHeader
        , { ETI_UINT, 0, 4, USERNAME_FH_IDX, 0 }
        , { ETI_PADDING, 0, 4, 0, 0 }
        , { ETI_EOF, 0, 0, 0, 0 }
        // UserLogoutResponse@2824
        , { ETI_STRUCT, 0, 330, 189, 19 } // MessageHeaderOut
        , { ETI_STRUCT, 0, 594, 300, 36 } // ResponseHeader
        , { ETI_EOF, 0, 0, 0, 0 }
    };
    static const int16_t tid2fidx[] = {
          1075 /* LogonRequest */
        , 1092 /* LogonResponse */
        , 1105 /* LogoutRequest */
        , 1108 /* LogoutResponse */
        , -1
        , 2349 /* SubscribeResponse */
        , 2759 /* UnsubscribeRequest */
        , 2764 /* UnsubscribeResponse */
        , 1814 /* RetransmitRequest */
        , 1822 /* RetransmitResponse */
        , 1790 /* Reject */
        , 1010 /* Heartbeat */
        , 996 /* ForcedLogoutNotification */
        , -1
        , -1
        , -1
        , -1
        , -1
        , 2810 /* UserLoginRequest */
        , 2816 /* UserLoginResponse */
        , -1
        , -1
        , -1
        , 1012 /* HeartbeatNotification */
        , 2824 /* UserLogoutResponse */
        , 2343 /* SubscribeRequest */
        , 1798 /* RetransmitMEMessageRequest */
        , 1807 /* RetransmitMEMessageResponse */
        , 2678 /* ThrottleUpdateNotification */
        , 2819 /* UserLogoutRequest */
        , 2321 /* ServiceAvailabilityBroadcast */
        , 1555 /* NewsBroadcast */
        , 646 /* BroadcastErrorNotification */
        , 1840 /* RiskNotificationBroadcast */
        , 1690 /* PartyEntitlementsUpdateReport */
        , 1047 /* InquireSessionListRequest */
        , 1050 /* InquireSessionListResponse */
        , 1067 /* LegalNotificationBroadcast */
        , 1056 /* InquireUserRequest */
        , 1060 /* InquireUserResponse */
        , 1015 /* InquireEnrichmentRuleIDListRequest */
        , 1019 /* InquireEnrichmentRuleIDListResponse */
        , 1678 /* PartyActionReport */
        , 1002 /* ForcedUserLogoutNotification */
        , 2336 /* ServiceAvailabilityMarketBroadcast */
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , 1488 /* NewOrderSingleRequest */
        , 1467 /* NewOrderResponse */
        , 1448 /* NewOrderNRResponse */
        , 1649 /* OrderExecResponse */
        , 1563 /* OrderExecNotification */
        , -1
        , 1288 /* ModifyOrderSingleRequest */
        , 1266 /* ModifyOrderResponse */
        , 1245 /* ModifyOrderNRResponse */
        , 890 /* DeleteOrderSingleRequest */
        , 874 /* DeleteOrderResponse */
        , 858 /* DeleteOrderNRResponse */
        , 820 /* DeleteOrderBroadcast */
        , 1380 /* NewOrderComplexRequest */
        , 1173 /* ModifyOrderComplexRequest */
        , -1
        , -1
        , 1590 /* OrderExecReportBroadcast */
        , 701 /* CrossRequest */
        , 708 /* CrossRequestResponse */
        , 743 /* DeleteAllOrderRequest */
        , 757 /* DeleteAllOrderResponse */
        , 712 /* DeleteAllOrderBroadcast */
        , 841 /* DeleteOrderComplexRequest */
        , 730 /* DeleteAllOrderNRResponse */
        , 1530 /* NewOrderSingleShortRequest */
        , 1333 /* ModifyOrderSingleShortRequest */
        , -1
        , -1
        , 1421 /* NewOrderComplexShortRequest */
        , 1217 /* ModifyOrderComplexShortRequest */
        , 937 /* EnterCLIPRequest */
        , 808 /* DeleteCLIPRequest */
        , 691 /* CLIPResponse */
        , 656 /* CLIPDeletionNotification */
        , 670 /* CLIPExecutionNotification */
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , 434 /* AddComplexInstrumentRequest */
        , 444 /* AddComplexInstrumentResponse */
        , 1111 /* MMParameterDefinitionRequest */
        , 1122 /* MMParameterDefinitionResponse */
        , 1026 /* InquireMMParameterRequest */
        , 1031 /* InquireMMParameterResponse */
        , 2751 /* TradingSessionStatusBroadcast */
        , 734 /* DeleteAllOrderQuoteEventBroadcast */
        , 460 /* AddFlexibleInstrumentRequest */
        , 473 /* AddFlexibleInstrumentResponse */
        , 1039 /* InquirePreTradeRiskLimitsRequest */
        , 1723 /* PreTradeRiskLimitsDefinitionRequest */
        , 1712 /* PreTradeRiskLimitResponse */
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , 1703 /* PingRequest */
        , 1708 /* PingResponse */
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , 1777 /* RFQRequest */
        , 1786 /* RFQResponse */
        , 1748 /* QuoteActivationRequest */
        , 1760 /* QuoteActivationResponse */
        , 1126 /* MassQuoteRequest */
        , 1145 /* MassQuoteResponse */
        , 1767 /* QuoteExecutionReport */
        , 781 /* DeleteAllQuoteRequest */
        , 791 /* DeleteAllQuoteResponse */
        , 766 /* DeleteAllQuoteBroadcast */
        , 1735 /* QuoteActivationNotification */
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , 2684 /* TradeBroadcast */
        , 2673 /* TMTradingSessionStatusBroadcast */
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , 956 /* EnterTESTradeRequest */
        , 1359 /* ModifyTESTradeRequest */
        , 907 /* DeleteTESTradeRequest */
        , 533 /* ApproveTESTradeRequest */
        , 2423 /* TESBroadcast */
        , -1
        , 2499 /* TESDeleteBroadcast */
        , 2354 /* TESApproveBroadcast */
        , -1
        , -1
        , 2514 /* TESExecutionBroadcast */
        , 2529 /* TESResponse */
        , 2767 /* UploadTESTradeRequest */
        , 2627 /* TESUploadBroadcast */
        , 2550 /* TESTradeBroadcast */
        , 2621 /* TESTradingSessionStatusBroadcast */
        , 2482 /* TESCompressionRunStatusRequest */
        , 2490 /* TESCompressionRunStatusResponse */
        , 2473 /* TESCompressionRunStatusBroadcast */
        , -1
        , 919 /* EnterBasketTradeRequest */
        , 1154 /* ModifyBasketTradeRequest */
        , 798 /* DeleteBasketTradeRequest */
        , 507 /* ApproveBasketTradeRequest */
        , 641 /* BasketResponse */
        , 591 /* BasketBroadcast */
        , 613 /* BasketDeleteBroadcast */
        , 570 /* BasketApproveBroadcast */
        , 626 /* BasketExecutionBroadcast */
        , 488 /* AmendBasketTradeRequest */
        , 1829 /* ReverseTESTradeRequest */
        , 522 /* ApproveReverseTESTradeRequest */
        , 2534 /* TESReversalBroadcast */
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , 2147 /* SRQSOpenNegotiationRequest */
        , 2296 /* SRQSUpdateNegotiationRequest */
        , 1947 /* SRQSEnterQuoteRequest */
        , 2260 /* SRQSQuoteResponse */
        , 1982 /* SRQSHitQuoteRequest */
        , 1935 /* SRQSDealResponse */
        , 2281 /* SRQSUpdateDealStatusRequest */
        , 2224 /* SRQSQuoteNotification */
        , 1853 /* SRQSCreateDealNotification */
        , 1899 /* SRQSDealNotification */
        , 2182 /* SRQSOpenNegotiationRequesterNotification */
        , 2108 /* SRQSOpenNegotiationNotification */
        , 2065 /* SRQSNegotiationRequesterNotification */
        , 2034 /* SRQSNegotiationNotification */
        , 2275 /* SRQSStatusBroadcast */
        , 2099 /* SRQSNegotiationStatusNotification */
        , -1
        , 2266 /* SRQSQuotingStatusRequest */
        , 2019 /* SRQSInquireSmartRespondentRequest */
        , 2027 /* SRQSInquireSmartRespondentResponse */
    };
    static const uint32_t tid2size[720][2] = {
          { 280, 280 } /* LogonRequest */
        , { 96, 96 } /* LogonResponse */
        , { 24, 24 } /* LogoutRequest */
        , { 32, 32 } /* LogoutResponse */
        , { 0, 0}
        , { 40, 40 } /* SubscribeResponse */
        , { 32, 32 } /* UnsubscribeRequest */
        , { 32, 32 } /* UnsubscribeResponse */
        , { 48, 48 } /* RetransmitRequest */
        , { 56, 56 } /* RetransmitResponse */
        , { 64, 2064 } /* Reject */
        , { 16, 16 } /* Heartbeat */
        , { 24, 2024 } /* ForcedLogoutNotification */
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 64, 64 } /* UserLoginRequest */
        , { 32, 32 } /* UserLoginResponse */
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 16, 16 } /* HeartbeatNotification */
        , { 32, 32 } /* UserLogoutResponse */
        , { 32, 32 } /* SubscribeRequest */
        , { 64, 64 } /* RetransmitMEMessageRequest */
        , { 72, 72 } /* RetransmitMEMessageResponse */
        , { 32, 32 } /* ThrottleUpdateNotification */
        , { 32, 32 } /* UserLogoutRequest */
        , { 56, 56 } /* ServiceAvailabilityBroadcast */
        , { 312, 2312 } /* NewsBroadcast */
        , { 32, 2032 } /* BroadcastErrorNotification */
        , { 88, 88 } /* RiskNotificationBroadcast */
        , { 88, 88 } /* PartyEntitlementsUpdateReport */
        , { 24, 24 } /* InquireSessionListRequest */
        , { 48, 8040 } /* InquireSessionListResponse */
        , { 56, 2056 } /* LegalNotificationBroadcast */
        , { 40, 40 } /* InquireUserRequest */
        , { 56, 16056 } /* InquireUserResponse */
        , { 40, 40 } /* InquireEnrichmentRuleIDListRequest */
        , { 56, 25656 } /* InquireEnrichmentRuleIDListResponse */
        , { 72, 72 } /* PartyActionReport */
        , { 24, 2024 } /* ForcedUserLogoutNotification */
        , { 32, 32 } /* ServiceAvailabilityMarketBroadcast */
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 248, 248 } /* NewOrderSingleRequest */
        , { 152, 2552 } /* NewOrderResponse */
        , { 120, 2520 } /* NewOrderNRResponse */
        , { 176, 24976 } /* OrderExecResponse */
        , { 168, 24968 } /* OrderExecNotification */
        , { 0, 0}
        , { 272, 272 } /* ModifyOrderSingleRequest */
        , { 160, 2560 } /* ModifyOrderResponse */
        , { 136, 2536 } /* ModifyOrderNRResponse */
        , { 120, 120 } /* DeleteOrderSingleRequest */
        , { 136, 136 } /* DeleteOrderResponse */
        , { 120, 120 } /* DeleteOrderNRResponse */
        , { 160, 160 } /* DeleteOrderBroadcast */
        , { 240, 400 } /* NewOrderComplexRequest */
        , { 264, 424 } /* ModifyOrderComplexRequest */
        , { 0, 0}
        , { 0, 0}
        , { 352, 25312 } /* OrderExecReportBroadcast */
        , { 64, 64 } /* CrossRequest */
        , { 64, 64 } /* CrossRequestResponse */
        , { 72, 72 } /* DeleteAllOrderRequest */
        , { 88, 12088 } /* DeleteAllOrderResponse */
        , { 112, 12112 } /* DeleteAllOrderBroadcast */
        , { 128, 128 } /* DeleteOrderComplexRequest */
        , { 64, 64 } /* DeleteAllOrderNRResponse */
        , { 120, 120 } /* NewOrderSingleShortRequest */
        , { 128, 128 } /* ModifyOrderSingleShortRequest */
        , { 0, 0}
        , { 0, 0}
        , { 128, 128 } /* NewOrderComplexShortRequest */
        , { 136, 136 } /* ModifyOrderComplexShortRequest */
        , { 240, 720 } /* EnterCLIPRequest */
        , { 72, 72 } /* DeleteCLIPRequest */
        , { 104, 120 } /* CLIPResponse */
        , { 112, 112 } /* CLIPDeletionNotification */
        , { 128, 22528 } /* CLIPExecutionNotification */
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 56, 696 } /* AddComplexInstrumentRequest */
        , { 112, 752 } /* AddComplexInstrumentResponse */
        , { 72, 72 } /* MMParameterDefinitionRequest */
        , { 64, 64 } /* MMParameterDefinitionResponse */
        , { 32, 32 } /* InquireMMParameterRequest */
        , { 72, 432 } /* InquireMMParameterResponse */
        , { 96, 96 } /* TradingSessionStatusBroadcast */
        , { 88, 88 } /* DeleteAllOrderQuoteEventBroadcast */
        , { 72, 72 } /* AddFlexibleInstrumentRequest */
        , { 104, 104 } /* AddFlexibleInstrumentResponse */
        , { 40, 40 } /* InquirePreTradeRiskLimitsRequest */
        , { 48, 80 } /* PreTradeRiskLimitsDefinitionRequest */
        , { 80, 2640 } /* PreTradeRiskLimitResponse */
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 32, 32 } /* PingRequest */
        , { 64, 64 } /* PingResponse */
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 72, 72 } /* RFQRequest */
        , { 64, 64 } /* RFQResponse */
        , { 56, 56 } /* QuoteActivationRequest */
        , { 72, 4072 } /* QuoteActivationResponse */
        , { 72, 4072 } /* MassQuoteRequest */
        , { 80, 4880 } /* MassQuoteResponse */
        , { 128, 24080 } /* QuoteExecutionReport */
        , { 56, 56 } /* DeleteAllQuoteRequest */
        , { 72, 4072 } /* DeleteAllQuoteResponse */
        , { 104, 4104 } /* DeleteAllQuoteBroadcast */
        , { 88, 4088 } /* QuoteActivationNotification */
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 416, 416 } /* TradeBroadcast */
        , { 48, 48 } /* TMTradingSessionStatusBroadcast */
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 272, 4184 } /* EnterTESTradeRequest */
        , { 144, 3760 } /* ModifyTESTradeRequest */
        , { 72, 72 } /* DeleteTESTradeRequest */
        , { 240, 240 } /* ApproveTESTradeRequest */
        , { 328, 7024 } /* TESBroadcast */
        , { 0, 0}
        , { 96, 96 } /* TESDeleteBroadcast */
        , { 424, 3200 } /* TESApproveBroadcast */
        , { 0, 0}
        , { 0, 0}
        , { 80, 80 } /* TESExecutionBroadcast */
        , { 56, 56 } /* TESResponse */
        , { 416, 18440 } /* UploadTESTradeRequest */
        , { 440, 18464 } /* TESUploadBroadcast */
        , { 432, 528 } /* TESTradeBroadcast */
        , { 48, 48 } /* TESTradingSessionStatusBroadcast */
        , { 40, 40 } /* TESCompressionRunStatusRequest */
        , { 48, 48 } /* TESCompressionRunStatusResponse */
        , { 56, 56 } /* TESCompressionRunStatusBroadcast */
        , { 0, 0}
        , { 272, 27232 } /* EnterBasketTradeRequest */
        , { 280, 27240 } /* ModifyBasketTradeRequest */
        , { 64, 64 } /* DeleteBasketTradeRequest */
        , { 296, 73344 } /* ApproveBasketTradeRequest */
        , { 56, 56 } /* BasketResponse */
        , { 352, 27312 } /* BasketBroadcast */
        , { 96, 96 } /* BasketDeleteBroadcast */
        , { 400, 76624 } /* BasketApproveBroadcast */
        , { 112, 3280 } /* BasketExecutionBroadcast */
        , { 280, 27240 } /* AmendBasketTradeRequest */
        , { 200, 200 } /* ReverseTESTradeRequest */
        , { 72, 72 } /* ApproveReverseTESTradeRequest */
        , { 264, 4184 } /* TESReversalBroadcast */
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 0, 0}
        , { 400, 2480 } /* SRQSOpenNegotiationRequest */
        , { 360, 1960 } /* SRQSUpdateNegotiationRequest */
        , { 376, 376 } /* SRQSEnterQuoteRequest */
        , { 64, 64 } /* SRQSQuoteResponse */
        , { 392, 1088 } /* SRQSHitQuoteRequest */
        , { 104, 336 } /* SRQSDealResponse */
        , { 208, 208 } /* SRQSUpdateDealStatusRequest */
        , { 416, 416 } /* SRQSQuoteNotification */
        , { 488, 2896 } /* SRQSCreateDealNotification */
        , { 440, 1600 } /* SRQSDealNotification */
        , { 464, 2544 } /* SRQSOpenNegotiationRequesterNotification */
        , { 488, 968 } /* SRQSOpenNegotiationNotification */
        , { 464, 2064 } /* SRQSNegotiationRequesterNotification */
        , { 456, 456 } /* SRQSNegotiationNotification */
        , { 48, 48 } /* SRQSStatusBroadcast */
        , { 88, 88 } /* SRQSNegotiationStatusNotification */
        , { 0, 0}
        , { 176, 176 } /* SRQSQuotingStatusRequest */
        , { 32, 32 } /* SRQSInquireSmartRespondentRequest */
        , { 40, 16040 } /* SRQSInquireSmartRespondentResponse */
    };
    static const unsigned char usages[] = {
        // AddComplexInstrumentRequest
        //// MessageHeaderInComp
          0 // BodyLen#0
        , 0 // TemplateID#1
        , 2 // NetworkMsgID#2
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#3
        , 0 // SenderSubID#4
        ///
        , 0 // MarketSegmentID#5
        , 1 // SecuritySubType#6
        , 0 // ProductComplex#7
        , 0 // NoLegs#8
        , 1 // ComplianceText#9
        //// InstrmtLegGrpComp
        , 0 // LegSecurityID#10
        , 1 // LegPrice#11
        , 1 // LegSymbol#12
        , 0 // LegRatioQty#13
        , 0 // LegSide#14
        , 0 // LegSecurityType#15
        ///
        // AddComplexInstrumentResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#16
        , 0 // TemplateID#17
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#18
        , 0 // TrdRegTSTimeIn#19
        , 0 // TrdRegTSTimeOut#20
        , 0 // ResponseIn#21
        , 0 // SendingTime#22
        , 0 // MsgSeqNum#23
        , 0 // LastFragment#24
        ///
        , 1 // LowLimitPrice#25
        , 1 // HighLimitPrice#26
        , 0 // SecurityID#27
        , 0 // LastUpdateTime#28
        , 0 // SecurityResponseID#29
        , 0 // MarketSegmentID#30
        , 0 // NumberOfSecurities#31
        , 1 // SecuritySubType#32
        , 0 // MultilegModel#33
        , 0 // ImpliedMarketIndicator#34
        , 0 // ProductComplex#35
        , 0 // NoLegs#36
        //// InstrmtLegGrpComp
        , 0 // LegSecurityID#37
        , 1 // LegPrice#38
        , 1 // LegSymbol#39
        , 0 // LegRatioQty#40
        , 0 // LegSide#41
        , 0 // LegSecurityType#42
        ///
        // AddFlexibleInstrumentRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#43
        , 0 // TemplateID#44
        , 2 // NetworkMsgID#45
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#46
        , 0 // SenderSubID#47
        ///
        , 1 // StrikePrice#48
        , 0 // MarketSegmentID#49
        , 1 // MaturityDate#50
        , 1 // ContractDate#51
        , 0 // SettlMethod#52
        , 1 // OptAttribute#53
        , 1 // PutOrCall#54
        , 1 // ExerciseStyle#55
        , 1 // ComplianceText#56
        // AddFlexibleInstrumentResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#57
        , 0 // TemplateID#58
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#59
        , 0 // TrdRegTSTimeIn#60
        , 0 // TrdRegTSTimeOut#61
        , 0 // ResponseIn#62
        , 0 // SendingTime#63
        , 0 // MsgSeqNum#64
        , 0 // LastFragment#65
        ///
        , 0 // SecurityResponseID#66
        , 0 // SecurityID#67
        , 1 // StrikePrice#68
        , 0 // MarketSegmentID#69
        , 1 // MaturityDate#70
        , 1 // ContractDate#71
        , 1 // ProductComplex#72
        , 0 // SettlMethod#73
        , 1 // OptAttribute#74
        , 1 // PutOrCall#75
        , 1 // ExerciseStyle#76
        // AmendBasketTradeRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#77
        , 0 // TemplateID#78
        , 2 // NetworkMsgID#79
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#80
        , 0 // SenderSubID#81
        ///
        , 0 // BasketTrdMatchID#82
        , 0 // BasketExecID#83
        , 0 // MarketSegmentID#84
        , 0 // MaturityMonthYear#85
        , 1 // BasketProfileID#86
        , 0 // TrdType#87
        , 0 // NoBasketSideAlloc#88
        , 0 // TradeReportType#89
        , 0 // BasketTradeReportType#90
        , 0 // NoBasketRootPartyGrps#91
        , 0 // NoInstrmtMatchSides#92
        , 1 // BasketTradeReportText#93
        , 1 // TradeReportID#94
        //// BasketRootPartyGrpComp
        , 0 // RootPartySubIDType#95
        , 0 // RootPartyContraFirm#96
        , 0 // RootPartyContraTrader#97
        , 1 // BasketSideTradeReportID#98
        ///
        //// InstrmtMatchSideGrpComp
        , 0 // SecurityID#99
        , 0 // LastPx#100
        , 1 // TransBkdTime#101
        , 1 // RelatedClosePrice#102
        , 2 // PackageID#103
        , 0 // SideMarketSegmentID#104
        , 0 // SideTrdSubTyp#105
        , 0 // ProductComplex#106
        , 0 // TradePublishIndicator#107
        , 0 // InstrmtMatchSideID#108
        , 1 // EffectOnBasket#109
        , 1 // TradeReportText#110
        ///
        //// BasketSideAllocGrpComp
        , 0 // AllocQty#111
        , 2 // IndividualAllocID#112
        , 0 // PartySubIDType#113
        , 0 // Side#114
        , 0 // InstrmtMatchSideID#115
        , 2 // TradeAllocStatus#116
        , 0 // PartyExecutingFirm#117
        , 0 // PartyExecutingTrader#118
        ///
        // ApproveBasketTradeRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#119
        , 0 // TemplateID#120
        , 2 // NetworkMsgID#121
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#122
        , 0 // SenderSubID#123
        ///
        , 0 // BasketTrdMatchID#124
        , 0 // BasketExecID#125
        , 0 // MarketSegmentID#126
        , 0 // RootPartySubIDType#127
        , 0 // NoBasketSideAlloc#128
        , 0 // TrdType#129
        , 0 // TradeReportType#130
        , 1 // BasketTradeReportText#131
        , 1 // TradeReportID#132
        , 1 // BasketSideTradeReportID#133
        //// BasketSideAllocExtGrpComp
        , 0 // AllocQty#134
        , 1 // PartyIDClientID#135
        , 1 // PartyIdInvestmentDecisionMaker#136
        , 1 // ExecutingTrader#137
        , 0 // PackageID#138
        , 0 // SideMarketSegmentID#139
        , 0 // AllocID#140
        , 0 // Side#141
        , 0 // PositionEffect#142
        , 0 // TradingCapacity#143
        , 0 // OrderAttributeLiquidityProvision#144
        , 0 // ExecutingTraderQualifier#145
        , 1 // PartyIdInvestmentDecisionMakerQualifier#146
        , 1 // OrderAttributeRiskReduction#147
        , 1 // OrderOrigination#148
        , 0 // PartyExecutingFirm#149
        , 0 // PartyExecutingTrader#150
        , 1 // Account#151
        , 1 // FreeText1#152
        , 1 // FreeText2#153
        , 1 // FreeText3#154
        , 1 // PartyIDTakeUpTradingFirm#155
        , 1 // PartyIDOrderOriginationFirm#156
        , 1 // PartyIDBeneficiary#157
        , 1 // PartyIDPositionAccount#158
        , 1 // PartyIDLocationID#159
        , 1 // CustOrderHandlingInst#160
        , 1 // ComplianceText#161
        ///
        // ApproveReverseTESTradeRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#162
        , 0 // TemplateID#163
        , 2 // NetworkMsgID#164
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#165
        , 0 // SenderSubID#166
        ///
        , 0 // MarketSegmentID#167
        , 0 // PackageID#168
        , 0 // AllocID#169
        , 0 // TESExecID#170
        , 1 // RelatedMarketSegmentID#171
        , 0 // TrdType#172
        , 1 // TradeReportID#173
        // ApproveTESTradeRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#174
        , 0 // TemplateID#175
        , 2 // NetworkMsgID#176
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#177
        , 0 // SenderSubID#178
        ///
        , 1 // PartyIDClientID#179
        , 1 // PartyIdInvestmentDecisionMaker#180
        , 1 // ExecutingTrader#181
        , 0 // AllocQty#182
        , 1 // CompressionID#183
        , 0 // PackageID#184
        , 0 // AllocID#185
        , 0 // TESExecID#186
        , 0 // MarketSegmentID#187
        , 1 // RelatedMarketSegmentID#188
        , 0 // TrdType#189
        , 0 // TradingCapacity#190
        , 0 // TradeReportType#191
        , 0 // Side#192
        , 0 // OrderAttributeLiquidityProvision#193
        , 1 // PartyIdInvestmentDecisionMakerQualifier#194
        , 0 // ExecutingTraderQualifier#195
        , 1 // OrderAttributeRiskReduction#196
        , 1 // OrderOrigination#197
        , 1 // TradeReportID#198
        , 0 // PositionEffect#199
        , 0 // PartyExecutingFirm#200
        , 0 // PartyExecutingTrader#201
        , 1 // Account#202
        , 1 // FreeText1#203
        , 1 // FreeText2#204
        , 1 // FreeText3#205
        , 1 // PartyIDTakeUpTradingFirm#206
        , 1 // PartyIDPositionAccount#207
        , 1 // PartyIDOrderOriginationFirm#208
        , 1 // PartyIDBeneficiary#209
        , 1 // PartyIDLocationID#210
        , 1 // CustOrderHandlingInst#211
        , 1 // ComplianceText#212
        // BasketApproveBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#213
        , 0 // TemplateID#214
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#215
        , 0 // ApplSeqNum#216
        , 1 // ApplSubID#217
        , 0 // PartitionID#218
        , 0 // ApplResendFlag#219
        , 0 // ApplID#220
        , 0 // LastFragment#221
        ///
        , 0 // BasketTrdMatchID#222
        , 0 // TransactTime#223
        , 0 // BasketExecID#224
        , 0 // MarketSegmentID#225
        , 1 // BasketProfileID#226
        , 0 // TrdType#227
        , 0 // NoBasketSideAlloc#228
        , 0 // TradeReportType#229
        , 0 // BasketTradeReportType#230
        , 0 // MessageEventSource#231
        , 0 // NoBasketRootPartyGrps#232
        , 0 // PartyIDEnteringFirm#233
        , 0 // PartyEnteringTrader#234
        , 1 // BasketTradeReportText#235
        , 1 // TradeReportID#236
        //// BasketRootPartyGrpComp
        , 0 // RootPartySubIDType#237
        , 0 // RootPartyContraFirm#238
        , 0 // RootPartyContraTrader#239
        , 1 // BasketSideTradeReportID#240
        ///
        //// BasketSideAllocExtBCGrpComp
        , 0 // AllocQty#241
        , 0 // SecurityID#242
        , 0 // LastPx#243
        , 1 // TransBkdTime#244
        , 1 // RelatedClosePrice#245
        , 0 // PackageID#246
        , 0 // SideMarketSegmentID#247
        , 0 // AllocID#248
        , 0 // SideTrdSubTyp#249
        , 0 // PartySubIDType#250
        , 0 // Side#251
        , 0 // PositionEffect#252
        , 1 // EffectOnBasket#253
        , 0 // TradingCapacity#254
        , 0 // TradeAllocStatus#255
        , 0 // ProductComplex#256
        , 0 // TradePublishIndicator#257
        , 0 // PartyExecutingFirm#258
        , 0 // PartyExecutingTrader#259
        , 1 // Account#260
        , 1 // FreeText1#261
        , 1 // FreeText2#262
        , 1 // FreeText3#263
        , 1 // PartyIDTakeUpTradingFirm#264
        , 1 // PartyIDOrderOriginationFirm#265
        , 1 // PartyIDBeneficiary#266
        , 1 // PartyIDPositionAccount#267
        , 1 // PartyIDLocationID#268
        , 1 // CustOrderHandlingInst#269
        , 1 // ComplianceText#270
        ///
        // BasketBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#271
        , 0 // TemplateID#272
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#273
        , 0 // ApplSeqNum#274
        , 1 // ApplSubID#275
        , 0 // PartitionID#276
        , 0 // ApplResendFlag#277
        , 0 // ApplID#278
        , 0 // LastFragment#279
        ///
        , 0 // BasketTrdMatchID#280
        , 0 // TransactTime#281
        , 0 // BasketExecID#282
        , 0 // MarketSegmentID#283
        , 0 // MaturityMonthYear#284
        , 1 // BasketProfileID#285
        , 0 // NoBasketSideAlloc#286
        , 0 // TrdType#287
        , 0 // TradeReportType#288
        , 0 // BasketTradeReportType#289
        , 0 // MessageEventSource#290
        , 0 // NoBasketRootPartyGrpsBC#291
        , 0 // NoInstrmtMatchSides#292
        , 1 // BasketTradeReportText#293
        , 1 // TradeReportID#294
        //// BasketRootPartyGrpComp
        , 0 // RootPartySubIDType#295
        , 0 // RootPartyContraFirm#296
        , 0 // RootPartyContraTrader#297
        , 1 // BasketSideTradeReportID#298
        ///
        //// InstrmtMatchSideGrpComp
        , 0 // SecurityID#299
        , 0 // LastPx#300
        , 1 // TransBkdTime#301
        , 1 // RelatedClosePrice#302
        , 0 // PackageID#303
        , 0 // SideMarketSegmentID#304
        , 0 // SideTrdSubTyp#305
        , 0 // ProductComplex#306
        , 0 // TradePublishIndicator#307
        , 0 // InstrmtMatchSideID#308
        , 1 // EffectOnBasket#309
        , 1 // TradeReportText#310
        ///
        //// BasketSideAllocGrpComp
        , 0 // AllocQty#311
        , 0 // IndividualAllocID#312
        , 0 // PartySubIDType#313
        , 0 // Side#314
        , 0 // InstrmtMatchSideID#315
        , 0 // TradeAllocStatus#316
        , 0 // PartyExecutingFirm#317
        , 0 // PartyExecutingTrader#318
        ///
        // BasketDeleteBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#319
        , 0 // TemplateID#320
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#321
        , 0 // ApplSeqNum#322
        , 1 // ApplSubID#323
        , 0 // PartitionID#324
        , 0 // ApplResendFlag#325
        , 0 // ApplID#326
        , 0 // LastFragment#327
        ///
        , 0 // BasketTrdMatchID#328
        , 0 // TransactTime#329
        , 0 // MarketSegmentID#330
        , 0 // BasketExecID#331
        , 1 // BasketProfileID#332
        , 0 // TrdType#333
        , 0 // DeleteReason#334
        , 0 // MessageEventSource#335
        , 1 // TradeReportID#336
        // BasketExecutionBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#337
        , 0 // TemplateID#338
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#339
        , 0 // ApplSeqNum#340
        , 1 // ApplSubID#341
        , 0 // PartitionID#342
        , 0 // ApplResendFlag#343
        , 0 // ApplID#344
        , 0 // LastFragment#345
        ///
        , 0 // BasketTrdMatchID#346
        , 0 // TransactTime#347
        , 0 // BasketExecID#348
        , 0 // MarketSegmentID#349
        , 1 // BasketProfileID#350
        , 0 // TrdType#351
        , 0 // TradeReportType#352
        , 0 // NoInstrmtMatchSides#353
        , 0 // MessageEventSource#354
        , 1 // BasketSideTradeReportID#355
        //// BasketExecGrpComp
        , 0 // PackageID#356
        , 0 // SideMarketSegmentID#357
        , 0 // AllocID#358
        , 0 // SideTrdSubTyp#359
        ///
        // BasketResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#360
        , 0 // TemplateID#361
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#362
        , 0 // SendingTime#363
        , 0 // MsgSeqNum#364
        ///
        , 0 // BasketExecID#365
        , 1 // TradeReportID#366
        // BroadcastErrorNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#367
        , 0 // TemplateID#368
        ///
        //// NotifHeaderComp
        , 0 // SendingTime#369
        ///
        , 0 // ApplIDStatus#370
        , 1 // RefApplSubID#371
        , 0 // VarTextLen#372
        , 0 // RefApplID#373
        , 0 // SessionStatus#374
        , 0 // VarText#375
        // CLIPDeletionNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#376
        , 0 // TemplateID#377
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#378
        , 1 // NotificationIn#379
        , 0 // SendingTime#380
        , 2 // ApplSubID#381
        , 0 // PartitionID#382
        , 2 // ApplMsgID#383
        , 0 // ApplID#384
        , 2 // ApplResendFlag#385
        , 0 // LastFragment#386
        ///
        , 0 // OrderID#387
        , 0 // ExecID#388
        , 0 // SecurityID#389
        , 0 // CxlQty#390
        , 0 // MarketSegmentID#391
        , 0 // ExecRestatementReason#392
        , 0 // ProductComplex#393
        , 0 // Side#394
        , 0 // OrdStatus#395
        , 0 // ExecType#396
        // CLIPExecutionNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#397
        , 0 // TemplateID#398
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#399
        , 1 // NotificationIn#400
        , 0 // SendingTime#401
        , 2 // ApplSubID#402
        , 0 // PartitionID#403
        , 0 // ApplMsgID#404
        , 0 // ApplID#405
        , 0 // ApplResendFlag#406
        , 0 // LastFragment#407
        ///
        , 0 // OrderID#408
        , 0 // ExecID#409
        , 0 // SecurityID#410
        , 0 // CxlQty#411
        , 0 // LeavesQty#412
        , 0 // CumQty#413
        , 0 // MarketSegmentID#414
        , 0 // ExecRestatementReason#415
        , 0 // NoLegExecs#416
        , 0 // ProductComplex#417
        , 0 // Side#418
        , 0 // OrdStatus#419
        , 0 // ExecType#420
        , 0 // MatchType#421
        , 0 // NoFills#422
        //// FillsGrpComp
        , 0 // FillPx#423
        , 0 // FillQty#424
        , 0 // FillMatchID#425
        , 0 // FillExecID#426
        , 1 // FillLiquidityInd#427
        ///
        //// InstrmntLegExecGrpComp
        , 0 // LegSecurityID#428
        , 0 // LegLastPx#429
        , 0 // LegLastQty#430
        , 0 // LegExecID#431
        , 0 // LegSide#432
        , 0 // FillRefID#433
        ///
        // CLIPResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#434
        , 0 // TemplateID#435
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#436
        , 0 // TrdRegTSTimeIn#437
        , 0 // TrdRegTSTimeOut#438
        , 0 // ResponseIn#439
        , 0 // SendingTime#440
        , 0 // MsgSeqNum#441
        , 0 // LastFragment#442
        ///
        , 0 // ExecID#443
        , 0 // SecurityID#444
        , 0 // MarketSegmentID#445
        , 1 // CrossRequestID#446
        , 0 // NoSides#447
        //// CrossRequestAckSideGrpComp
        , 0 // OrderID#448
        , 0 // InputSource#449
        , 0 // Side#450
        ///
        // CrossRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#451
        , 0 // TemplateID#452
        , 2 // NetworkMsgID#453
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#454
        , 0 // SenderSubID#455
        ///
        , 0 // SecurityID#456
        , 0 // OrderQty#457
        , 0 // MarketSegmentID#458
        , 1 // ComplianceText#459
        // CrossRequestResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#460
        , 0 // TemplateID#461
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#462
        , 0 // TrdRegTSTimeIn#463
        , 0 // TrdRegTSTimeOut#464
        , 0 // ResponseIn#465
        , 0 // SendingTime#466
        , 0 // MsgSeqNum#467
        , 0 // LastFragment#468
        ///
        , 0 // ExecID#469
        // DeleteAllOrderBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#470
        , 0 // TemplateID#471
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#472
        , 1 // NotificationIn#473
        , 0 // SendingTime#474
        , 1 // ApplSubID#475
        , 0 // PartitionID#476
        , 0 // ApplMsgID#477
        , 0 // ApplID#478
        , 0 // ApplResendFlag#479
        , 0 // LastFragment#480
        ///
        , 0 // MassActionReportID#481
        , 1 // SecurityID#482
        , 1 // Price#483
        , 0 // MarketSegmentID#484
        , 0 // TargetPartyIDSessionID#485
        , 1 // TargetPartyIDExecutingTrader#486
        , 1 // PartyIDEnteringTrader#487
        , 0 // NoNotAffectedOrders#488
        , 0 // NoAffectedOrderRequests#489
        , 1 // PartyIDEnteringFirm#490
        , 0 // MassActionReason#491
        , 0 // ExecInst#492
        , 1 // Side#493
        //// NotAffectedOrdersGrpComp
        , 0 // NotAffectedOrderID#494
        , 1 // NotAffOrigClOrdID#495
        ///
        //// AffectedOrderRequestsGrpComp
        , 0 // AffectedOrderRequestID#496
        ///
        // DeleteAllOrderNRResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#497
        , 0 // TemplateID#498
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#499
        , 0 // TrdRegTSTimeIn#500
        , 0 // TrdRegTSTimeOut#501
        , 0 // ResponseIn#502
        , 0 // SendingTime#503
        , 0 // MsgSeqNum#504
        , 0 // LastFragment#505
        ///
        , 0 // MassActionReportID#506
        // DeleteAllOrderQuoteEventBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#507
        , 0 // TemplateID#508
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#509
        , 1 // NotificationIn#510
        , 0 // SendingTime#511
        , 1 // ApplSubID#512
        , 0 // PartitionID#513
        , 1 // ApplMsgID#514
        , 0 // ApplID#515
        , 0 // ApplResendFlag#516
        , 0 // LastFragment#517
        ///
        , 0 // MassActionReportID#518
        , 1 // SecurityID#519
        , 0 // MarketSegmentID#520
        , 0 // MassActionReason#521
        , 1 // ExecInst#522
        // DeleteAllOrderRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#523
        , 0 // TemplateID#524
        , 2 // NetworkMsgID#525
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#526
        , 0 // SenderSubID#527
        ///
        , 1 // SecurityID#528
        , 1 // Price#529
        , 1 // PartyIdInvestmentDecisionMaker#530
        , 1 // ExecutingTrader#531
        , 0 // MarketSegmentID#532
        , 1 // TargetPartyIDSessionID#533
        , 1 // TargetPartyIDExecutingTrader#534
        , 1 // Side#535
        , 1 // OrderOrigination#536
        , 1 // PartyIdInvestmentDecisionMakerQualifier#537
        , 0 // ExecutingTraderQualifier#538
        // DeleteAllOrderResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#539
        , 0 // TemplateID#540
        ///
        //// ResponseHeaderMEComp
        , 0 // RequestTime#541
        , 0 // TrdRegTSTimeIn#542
        , 0 // TrdRegTSTimeOut#543
        , 0 // ResponseIn#544
        , 0 // SendingTime#545
        , 0 // MsgSeqNum#546
        , 0 // PartitionID#547
        , 0 // ApplID#548
        , 0 // ApplMsgID#549
        , 0 // LastFragment#550
        ///
        , 0 // MassActionReportID#551
        , 0 // NoNotAffectedOrders#552
        , 0 // NoAffectedOrderRequests#553
        //// NotAffectedOrdersGrpComp
        , 0 // NotAffectedOrderID#554
        , 1 // NotAffOrigClOrdID#555
        ///
        //// AffectedOrderRequestsGrpComp
        , 0 // AffectedOrderRequestID#556
        ///
        // DeleteAllQuoteBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#557
        , 0 // TemplateID#558
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#559
        , 1 // NotificationIn#560
        , 0 // SendingTime#561
        , 2 // ApplSubID#562
        , 0 // PartitionID#563
        , 1 // ApplMsgID#564
        , 0 // ApplID#565
        , 0 // ApplResendFlag#566
        , 0 // LastFragment#567
        ///
        , 0 // MassActionReportID#568
        , 2 // SecurityID#569
        , 0 // MarketSegmentID#570
        , 0 // TargetPartyIDSessionID#571
        , 1 // PartyIDEnteringTrader#572
        , 1 // TargetPartyIDExecutingTrader#573
        , 0 // NoNotAffectedSecurities#574
        , 0 // MassActionReason#575
        , 1 // PartyIDEnteringFirm#576
        , 1 // TargetPartyIDDeskID#577
        //// NotAffectedSecuritiesGrpComp
        , 0 // NotAffectedSecurityID#578
        ///
        // DeleteAllQuoteRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#579
        , 0 // TemplateID#580
        , 2 // NetworkMsgID#581
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#582
        , 0 // SenderSubID#583
        ///
        , 1 // PartyIdInvestmentDecisionMaker#584
        , 1 // ExecutingTrader#585
        , 0 // MarketSegmentID#586
        , 1 // TargetPartyIDSessionID#587
        , 1 // PartyIdInvestmentDecisionMakerQualifier#588
        , 0 // ExecutingTraderQualifier#589
        // DeleteAllQuoteResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#590
        , 0 // TemplateID#591
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#592
        , 1 // TrdRegTSTimeIn#593
        , 1 // TrdRegTSTimeOut#594
        , 0 // ResponseIn#595
        , 0 // SendingTime#596
        , 0 // MsgSeqNum#597
        , 0 // LastFragment#598
        ///
        , 0 // MassActionReportID#599
        , 0 // NoNotAffectedSecurities#600
        //// NotAffectedSecuritiesGrpComp
        , 0 // NotAffectedSecurityID#601
        ///
        // DeleteBasketTradeRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#602
        , 0 // TemplateID#603
        , 2 // NetworkMsgID#604
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#605
        , 0 // SenderSubID#606
        ///
        , 0 // BasketTrdMatchID#607
        , 0 // BasketExecID#608
        , 0 // MarketSegmentID#609
        , 0 // TrdType#610
        , 0 // TradeReportType#611
        , 1 // TradeReportID#612
        // DeleteCLIPRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#613
        , 0 // TemplateID#614
        , 2 // NetworkMsgID#615
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#616
        , 0 // SenderSubID#617
        ///
        , 0 // OrderID#618
        , 0 // SecurityID#619
        , 1 // PartyIdInvestmentDecisionMaker#620
        , 1 // ExecutingTrader#621
        , 0 // MarketSegmentID#622
        , 1 // CrossRequestID#623
        , 0 // ExecutingTraderQualifier#624
        , 1 // PartyIdInvestmentDecisionMakerQualifier#625
        // DeleteOrderBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#626
        , 0 // TemplateID#627
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#628
        , 1 // NotificationIn#629
        , 0 // SendingTime#630
        , 1 // ApplSubID#631
        , 0 // PartitionID#632
        , 1 // ApplMsgID#633
        , 1 // ApplID#634
        , 0 // ApplResendFlag#635
        , 0 // LastFragment#636
        ///
        , 0 // OrderID#637
        , 1 // ClOrdID#638
        , 1 // OrigClOrdID#639
        , 0 // SecurityID#640
        , 0 // ExecID#641
        , 0 // CumQty#642
        , 0 // CxlQty#643
        , 0 // MarketSegmentID#644
        , 1 // PartyIDEnteringTrader#645
        , 1 // PartyIDSessionID#646
        , 0 // ExecRestatementReason#647
        , 1 // PartyIDEnteringFirm#648
        , 0 // OrdStatus#649
        , 0 // ExecType#650
        , 0 // ProductComplex#651
        , 0 // Side#652
        , 1 // FIXClOrdID#653
        // DeleteOrderComplexRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#654
        , 0 // TemplateID#655
        , 2 // NetworkMsgID#656
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#657
        , 0 // SenderSubID#658
        ///
        , 1 // OrderID#659
        , 1 // ClOrdID#660
        , 1 // OrigClOrdID#661
        , 0 // SecurityID#662
        , 1 // PartyIdInvestmentDecisionMaker#663
        , 1 // ExecutingTrader#664
        , 0 // MarketSegmentID#665
        , 1 // TargetPartyIDSessionID#666
        , 1 // OrderOrigination#667
        , 1 // PartyIdInvestmentDecisionMakerQualifier#668
        , 0 // ExecutingTraderQualifier#669
        , 1 // FIXClOrdID#670
        , 1 // ComplianceText#671
        // DeleteOrderNRResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#672
        , 0 // TemplateID#673
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#674
        , 0 // TrdRegTSTimeIn#675
        , 0 // TrdRegTSTimeOut#676
        , 0 // ResponseIn#677
        , 0 // SendingTime#678
        , 0 // MsgSeqNum#679
        , 0 // LastFragment#680
        ///
        , 0 // OrderID#681
        , 1 // ClOrdID#682
        , 1 // OrigClOrdID#683
        , 0 // SecurityID#684
        , 0 // ExecID#685
        , 0 // CumQty#686
        , 0 // CxlQty#687
        , 0 // OrdStatus#688
        , 0 // ExecType#689
        , 0 // ExecRestatementReason#690
        , 0 // ProductComplex#691
        , 0 // TransactionDelayIndicator#692
        // DeleteOrderResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#693
        , 0 // TemplateID#694
        ///
        //// ResponseHeaderMEComp
        , 0 // RequestTime#695
        , 0 // TrdRegTSTimeIn#696
        , 0 // TrdRegTSTimeOut#697
        , 0 // ResponseIn#698
        , 0 // SendingTime#699
        , 0 // MsgSeqNum#700
        , 0 // PartitionID#701
        , 0 // ApplID#702
        , 1 // ApplMsgID#703
        , 0 // LastFragment#704
        ///
        , 0 // OrderID#705
        , 1 // ClOrdID#706
        , 1 // OrigClOrdID#707
        , 0 // SecurityID#708
        , 0 // ExecID#709
        , 0 // CumQty#710
        , 0 // CxlQty#711
        , 0 // OrdStatus#712
        , 0 // ExecType#713
        , 0 // ExecRestatementReason#714
        , 0 // ProductComplex#715
        , 0 // TransactionDelayIndicator#716
        // DeleteOrderSingleRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#717
        , 0 // TemplateID#718
        , 2 // NetworkMsgID#719
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#720
        , 0 // SenderSubID#721
        ///
        , 1 // OrderID#722
        , 1 // ClOrdID#723
        , 1 // OrigClOrdID#724
        , 1 // PartyIdInvestmentDecisionMaker#725
        , 1 // ExecutingTrader#726
        , 0 // MarketSegmentID#727
        , 0 // SimpleSecurityID#728
        , 1 // TargetPartyIDSessionID#729
        , 1 // OrderOrigination#730
        , 1 // PartyIdInvestmentDecisionMakerQualifier#731
        , 1 // ExecutingTraderQualifier#732
        , 1 // FIXClOrdID#733
        , 1 // ComplianceText#734
        // DeleteTESTradeRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#735
        , 0 // TemplateID#736
        , 2 // NetworkMsgID#737
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#738
        , 0 // SenderSubID#739
        ///
        , 1 // CompressionID#740
        , 0 // PackageID#741
        , 0 // MarketSegmentID#742
        , 0 // TESExecID#743
        , 1 // RelatedMarketSegmentID#744
        , 0 // TrdType#745
        , 0 // TradeReportType#746
        , 1 // TradeReportID#747
        // EnterBasketTradeRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#748
        , 0 // TemplateID#749
        , 2 // NetworkMsgID#750
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#751
        , 0 // SenderSubID#752
        ///
        , 0 // MarketSegmentID#753
        , 0 // MaturityMonthYear#754
        , 1 // BasketProfileID#755
        , 0 // TrdType#756
        , 0 // NoBasketSideAlloc#757
        , 0 // TradeReportType#758
        , 0 // BasketTradeReportType#759
        , 0 // NoBasketRootPartyGrps#760
        , 0 // NoInstrmtMatchSides#761
        , 1 // BasketTradeReportText#762
        , 1 // TradeReportID#763
        //// BasketRootPartyGrpComp
        , 0 // RootPartySubIDType#764
        , 0 // RootPartyContraFirm#765
        , 0 // RootPartyContraTrader#766
        , 1 // BasketSideTradeReportID#767
        ///
        //// InstrmtMatchSideGrpComp
        , 0 // SecurityID#768
        , 0 // LastPx#769
        , 1 // TransBkdTime#770
        , 1 // RelatedClosePrice#771
        , 2 // PackageID#772
        , 0 // SideMarketSegmentID#773
        , 0 // SideTrdSubTyp#774
        , 0 // ProductComplex#775
        , 0 // TradePublishIndicator#776
        , 0 // InstrmtMatchSideID#777
        , 1 // EffectOnBasket#778
        , 1 // TradeReportText#779
        ///
        //// BasketSideAllocGrpComp
        , 0 // AllocQty#780
        , 2 // IndividualAllocID#781
        , 0 // PartySubIDType#782
        , 0 // Side#783
        , 0 // InstrmtMatchSideID#784
        , 2 // TradeAllocStatus#785
        , 0 // PartyExecutingFirm#786
        , 0 // PartyExecutingTrader#787
        ///
        // EnterCLIPRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#788
        , 0 // TemplateID#789
        , 2 // NetworkMsgID#790
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#791
        , 0 // SenderSubID#792
        ///
        , 0 // SecurityID#793
        , 0 // Price#794
        , 0 // OrderQty#795
        , 0 // MarketSegmentID#796
        , 1 // CrossID#797
        , 1 // CrossRequestID#798
        , 0 // NoSides#799
        , 0 // NoCrossLegs#800
        , 1 // SideDisclosureInstruction#801
        , 1 // PriceDisclosureInstruction#802
        , 1 // OrderQtyDisclosureInstruction#803
        , 1 // RootPartyContraFirm#804
        , 1 // RootPartyContraTrader#805
        //// CrossRequestSideGrpComp
        , 1 // PartyIDClientID#806
        , 1 // PartyIdInvestmentDecisionMaker#807
        , 1 // ExecutingTrader#808
        , 1 // MaximumPrice#809
        , 0 // InputSource#810
        , 0 // Side#811
        , 0 // TradingCapacity#812
        , 0 // ExecutingTraderQualifier#813
        , 0 // OrderAttributeLiquidityProvision#814
        , 1 // PartyIdInvestmentDecisionMakerQualifier#815
        , 1 // PositionEffect#816
        , 1 // CustOrderHandlingInst#817
        , 1 // Account#818
        , 1 // PartyIDPositionAccount#819
        , 1 // FreeText1#820
        , 1 // FreeText2#821
        , 1 // FreeText3#822
        , 1 // PartyIDOrderOriginationFirm#823
        , 1 // PartyIDBeneficiary#824
        , 1 // PartyIDTakeUpTradingFirm#825
        , 1 // SideComplianceText#826
        , 1 // PartyIDLocationID#827
        ///
        //// SideCrossLegGrpComp
        , 0 // LegInputSource#828
        , 0 // LegPositionEffect#829
        , 1 // LegAccount#830
        ///
        // EnterTESTradeRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#831
        , 0 // TemplateID#832
        , 2 // NetworkMsgID#833
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#834
        , 0 // SenderSubID#835
        ///
        , 0 // SecurityID#836
        , 0 // LastPx#837
        , 1 // TransBkdTime#838
        , 1 // UnderlyingPx#839
        , 1 // RelatedClosePrice#840
        , 1 // RelatedTradeQuantity#841
        , 1 // UnderlyingQty#842
        , 1 // CompressionID#843
        , 0 // MarketSegmentID#844
        , 1 // UnderlyingSettlementDate#845
        , 1 // UnderlyingMaturityDate#846
        , 1 // RelatedTradeID#847
        , 1 // RelatedMarketSegmentID#848
        , 0 // TrdType#849
        , 1 // ProductComplex#850
        , 0 // TradeReportType#851
        , 0 // TradePublishIndicator#852
        , 0 // NoSideAllocs#853
        , 0 // NoEvents#854
        , 0 // NoLegs#855
        , 0 // NoInstrAttrib#856
        , 0 // NoUnderlyingStips#857
        , 1 // PartyIDSettlementLocation#858
        , 1 // HedgeType#859
        , 1 // SwapClearer#860
        , 1 // TradeReportText#861
        , 1 // TradeReportID#862
        , 1 // UnderlyingSecurityID#863
        , 1 // UnderlyingSecurityDesc#864
        , 1 // UnderlyingCurrency#865
        , 1 // UnderlyingIssuer#866
        //// SideAllocGrpComp
        , 0 // AllocQty#867
        , 2 // IndividualAllocID#868
        , 1 // TESEnrichmentRuleID#869
        , 0 // Side#870
        , 0 // PartyExecutingFirm#871
        , 0 // PartyExecutingTrader#872
        ///
        //// TrdInstrmntLegGrpComp
        , 0 // LegSecurityID#873
        , 0 // LegPrice#874
        , 2 // LegQty#875
        ///
        //// InstrumentEventGrpComp
        , 0 // EventDate#876
        , 0 // EventType#877
        ///
        //// InstrumentAttributeGrpComp
        , 0 // InstrAttribType#878
        , 0 // InstrAttribValue#879
        ///
        //// UnderlyingStipGrpComp
        , 0 // UnderlyingStipValue#880
        , 0 // UnderlyingStipType#881
        ///
        // ForcedLogoutNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#882
        , 0 // TemplateID#883
        ///
        //// NotifHeaderComp
        , 0 // SendingTime#884
        ///
        , 0 // VarTextLen#885
        , 0 // VarText#886
        // ForcedUserLogoutNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#887
        , 0 // TemplateID#888
        ///
        //// NotifHeaderComp
        , 0 // SendingTime#889
        ///
        , 0 // Username#890
        , 0 // VarTextLen#891
        , 0 // UserStatus#892
        , 0 // VarText#893
        // Heartbeat
        //// MessageHeaderInComp
        , 0 // BodyLen#894
        , 0 // TemplateID#895
        , 2 // NetworkMsgID#896
        ///
        // HeartbeatNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#897
        , 0 // TemplateID#898
        ///
        //// NotifHeaderComp
        , 0 // SendingTime#899
        ///
        // InquireEnrichmentRuleIDListRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#900
        , 0 // TemplateID#901
        , 2 // NetworkMsgID#902
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#903
        , 2 // SenderSubID#904
        ///
        , 1 // LastEntityProcessed#905
        // InquireEnrichmentRuleIDListResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#906
        , 0 // TemplateID#907
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#908
        , 0 // SendingTime#909
        , 0 // MsgSeqNum#910
        ///
        , 1 // LastEntityProcessed#911
        , 0 // NoEnrichmentRules#912
        //// EnrichmentRulesGrpComp
        , 0 // EnrichmentRuleID#913
        , 1 // PartyIDOriginationMarket#914
        , 1 // Account#915
        , 1 // PositionEffect#916
        , 1 // PartyIDTakeUpTradingFirm#917
        , 1 // PartyIDOrderOriginationFirm#918
        , 1 // PartyIDBeneficiary#919
        , 1 // FreeText1#920
        , 1 // FreeText2#921
        , 1 // FreeText3#922
        ///
        // InquireMMParameterRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#923
        , 0 // TemplateID#924
        , 2 // NetworkMsgID#925
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#926
        , 0 // SenderSubID#927
        ///
        , 0 // MarketSegmentID#928
        , 1 // TargetPartyIDSessionID#929
        // InquireMMParameterResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#930
        , 0 // TemplateID#931
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#932
        , 0 // TrdRegTSTimeIn#933
        , 0 // TrdRegTSTimeOut#934
        , 0 // ResponseIn#935
        , 0 // SendingTime#936
        , 0 // MsgSeqNum#937
        , 0 // LastFragment#938
        ///
        , 0 // MMParameterReportID#939
        , 0 // MarketSegmentID#940
        , 0 // NoMMParameters#941
        //// MMParameterGrpComp
        , 0 // ExposureDuration#942
        , 0 // CumQty#943
        , 0 // Delta#944
        , 0 // Vega#945
        , 0 // PctCount#946
        , 1 // TargetPartyIDSessionID#947
        ///
        // InquirePreTradeRiskLimitsRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#948
        , 0 // TemplateID#949
        , 2 // NetworkMsgID#950
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#951
        , 0 // SenderSubID#952
        ///
        , 0 // MarketSegmentID#953
        , 0 // RiskLimitPlatform#954
        , 1 // PartyExecutingUnit#955
        , 1 // RiskLimitGroup#956
        // InquireSessionListRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#957
        , 0 // TemplateID#958
        , 2 // NetworkMsgID#959
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#960
        , 2 // SenderSubID#961
        ///
        // InquireSessionListResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#962
        , 0 // TemplateID#963
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#964
        , 0 // SendingTime#965
        , 0 // MsgSeqNum#966
        ///
        , 0 // NoSessions#967
        //// SessionsGrpComp
        , 0 // PartyIDSessionID#968
        , 0 // SessionMode#969
        , 1 // SessionSubMode#970
        ///
        // InquireUserRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#971
        , 0 // TemplateID#972
        , 2 // NetworkMsgID#973
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#974
        , 2 // SenderSubID#975
        ///
        , 1 // LastEntityProcessed#976
        // InquireUserResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#977
        , 0 // TemplateID#978
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#979
        , 0 // SendingTime#980
        , 0 // MsgSeqNum#981
        ///
        , 1 // LastEntityProcessed#982
        , 0 // NoPartyDetails#983
        //// PartyDetailsGrpComp
        , 0 // PartyDetailIDExecutingTrader#984
        , 0 // PartyDetailExecutingTrader#985
        , 0 // PartyDetailRoleQualifier#986
        , 0 // PartyDetailStatus#987
        , 1 // PartyDetailDeskID#988
        ///
        // LegalNotificationBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#989
        , 0 // TemplateID#990
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#991
        , 0 // ApplSeqNum#992
        , 2 // ApplSubID#993
        , 0 // PartitionID#994
        , 0 // ApplResendFlag#995
        , 0 // ApplID#996
        , 0 // LastFragment#997
        ///
        , 0 // TransactTime#998
        , 0 // VarTextLen#999
        , 0 // UserStatus#1000
        , 0 // VarText#1001
        // LogonRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1002
        , 0 // TemplateID#1003
        , 2 // NetworkMsgID#1004
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1005
        , 2 // SenderSubID#1006
        ///
        , 1 // HeartBtInt#1007
        , 0 // PartyIDSessionID#1008
        , 0 // DefaultCstmApplVerID#1009
        , 0 // Password#1010
        , 0 // ApplUsageOrders#1011
        , 0 // ApplUsageQuotes#1012
        , 0 // OrderRoutingIndicator#1013
        , 1 // FIXEngineName#1014
        , 1 // FIXEngineVersion#1015
        , 1 // FIXEngineVendor#1016
        , 0 // ApplicationSystemName#1017
        , 0 // ApplicationSystemVersion#1018
        , 0 // ApplicationSystemVendor#1019
        // LogonResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1020
        , 0 // TemplateID#1021
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#1022
        , 0 // SendingTime#1023
        , 0 // MsgSeqNum#1024
        ///
        , 0 // ThrottleTimeInterval#1025
        , 0 // ThrottleNoMsgs#1026
        , 0 // ThrottleDisconnectLimit#1027
        , 0 // HeartBtInt#1028
        , 0 // SessionInstanceID#1029
        , 0 // MarketID#1030
        , 0 // TradSesMode#1031
        , 0 // DefaultCstmApplVerID#1032
        , 0 // DefaultCstmApplVerSubID#1033
        // LogoutRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1034
        , 0 // TemplateID#1035
        , 2 // NetworkMsgID#1036
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1037
        , 2 // SenderSubID#1038
        ///
        // LogoutResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1039
        , 0 // TemplateID#1040
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#1041
        , 0 // SendingTime#1042
        , 0 // MsgSeqNum#1043
        ///
        // MMParameterDefinitionRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1044
        , 0 // TemplateID#1045
        , 2 // NetworkMsgID#1046
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1047
        , 0 // SenderSubID#1048
        ///
        , 0 // ExposureDuration#1049
        , 0 // CumQty#1050
        , 0 // Delta#1051
        , 0 // Vega#1052
        , 0 // MarketSegmentID#1053
        , 1 // TargetPartyIDSessionID#1054
        , 0 // PctCount#1055
        // MMParameterDefinitionResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1056
        , 0 // TemplateID#1057
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#1058
        , 0 // TrdRegTSTimeIn#1059
        , 0 // TrdRegTSTimeOut#1060
        , 0 // ResponseIn#1061
        , 0 // SendingTime#1062
        , 0 // MsgSeqNum#1063
        , 0 // LastFragment#1064
        ///
        , 1 // ExecID#1065
        // MassQuoteRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1066
        , 0 // TemplateID#1067
        , 2 // NetworkMsgID#1068
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1069
        , 0 // SenderSubID#1070
        ///
        , 0 // QuoteID#1071
        , 1 // PartyIdInvestmentDecisionMaker#1072
        , 1 // ExecutingTrader#1073
        , 0 // MarketSegmentID#1074
        , 1 // MatchInstCrossID#1075
        , 1 // EnrichmentRuleID#1076
        , 0 // PriceValidityCheckType#1077
        , 0 // ValueCheckTypeValue#1078
        , 0 // QuoteSizeType#1079
        , 0 // QuoteType#1080
        , 0 // OrderAttributeLiquidityProvision#1081
        , 0 // NoQuoteEntries#1082
        , 1 // PartyIdInvestmentDecisionMakerQualifier#1083
        , 0 // ExecutingTraderQualifier#1084
        //// QuoteEntryGrpComp
        , 0 // SecurityID#1085
        , 1 // BidPx#1086
        , 1 // BidSize#1087
        , 1 // OfferPx#1088
        , 1 // OfferSize#1089
        ///
        // MassQuoteResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1090
        , 0 // TemplateID#1091
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#1092
        , 0 // TrdRegTSTimeIn#1093
        , 0 // TrdRegTSTimeOut#1094
        , 0 // ResponseIn#1095
        , 0 // SendingTime#1096
        , 0 // MsgSeqNum#1097
        , 0 // LastFragment#1098
        ///
        , 0 // QuoteID#1099
        , 0 // QuoteResponseID#1100
        , 0 // MarketSegmentID#1101
        , 0 // NoQuoteSideEntries#1102
        //// QuoteEntryAckGrpComp
        , 0 // SecurityID#1103
        , 1 // CxlSize#1104
        , 1 // QuoteEntryRejectReason#1105
        , 0 // QuoteEntryStatus#1106
        , 0 // Side#1107
        ///
        // ModifyBasketTradeRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1108
        , 0 // TemplateID#1109
        , 2 // NetworkMsgID#1110
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1111
        , 0 // SenderSubID#1112
        ///
        , 0 // BasketTrdMatchID#1113
        , 0 // BasketExecID#1114
        , 0 // MarketSegmentID#1115
        , 0 // MaturityMonthYear#1116
        , 1 // BasketProfileID#1117
        , 0 // TrdType#1118
        , 0 // NoBasketSideAlloc#1119
        , 0 // TradeReportType#1120
        , 0 // NoBasketRootPartyGrps#1121
        , 0 // NoInstrmtMatchSides#1122
        , 1 // BasketTradeReportText#1123
        , 1 // TradeReportID#1124
        //// BasketRootPartyGrpComp
        , 0 // RootPartySubIDType#1125
        , 0 // RootPartyContraFirm#1126
        , 0 // RootPartyContraTrader#1127
        , 1 // BasketSideTradeReportID#1128
        ///
        //// InstrmtMatchSideGrpComp
        , 0 // SecurityID#1129
        , 0 // LastPx#1130
        , 1 // TransBkdTime#1131
        , 1 // RelatedClosePrice#1132
        , 1 // PackageID#1133
        , 0 // SideMarketSegmentID#1134
        , 0 // SideTrdSubTyp#1135
        , 0 // ProductComplex#1136
        , 0 // TradePublishIndicator#1137
        , 0 // InstrmtMatchSideID#1138
        , 1 // EffectOnBasket#1139
        , 1 // TradeReportText#1140
        ///
        //// BasketSideAllocGrpComp
        , 0 // AllocQty#1141
        , 1 // IndividualAllocID#1142
        , 0 // PartySubIDType#1143
        , 0 // Side#1144
        , 0 // InstrmtMatchSideID#1145
        , 2 // TradeAllocStatus#1146
        , 0 // PartyExecutingFirm#1147
        , 0 // PartyExecutingTrader#1148
        ///
        // ModifyOrderComplexRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1149
        , 0 // TemplateID#1150
        , 2 // NetworkMsgID#1151
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1152
        , 0 // SenderSubID#1153
        ///
        , 1 // OrderID#1154
        , 1 // ClOrdID#1155
        , 1 // OrigClOrdID#1156
        , 0 // SecurityID#1157
        , 0 // Price#1158
        , 0 // OrderQty#1159
        , 1 // PartyIDClientID#1160
        , 1 // PartyIdInvestmentDecisionMaker#1161
        , 1 // ExecutingTrader#1162
        , 0 // MarketSegmentID#1163
        , 1 // ExpireDate#1164
        , 1 // MatchInstCrossID#1165
        , 1 // TargetPartyIDSessionID#1166
        , 1 // PartyIDTakeUpTradingFirm#1167
        , 1 // PartyIDOrderOriginationFirm#1168
        , 1 // PartyIDBeneficiary#1169
        , 0 // ApplSeqIndicator#1170
        , 0 // ProductComplex#1171
        , 0 // Side#1172
        , 0 // OrdType#1173
        , 0 // PriceValidityCheckType#1174
        , 0 // ValueCheckTypeValue#1175
        , 0 // OrderAttributeLiquidityProvision#1176
        , 0 // ExecInst#1177
        , 0 // TimeInForce#1178
        , 0 // TradingCapacity#1179
        , 0 // OwnershipIndicator#1180
        , 1 // OrderOrigination#1181
        , 1 // PartyIdInvestmentDecisionMakerQualifier#1182
        , 0 // ExecutingTraderQualifier#1183
        , 1 // PartyIDLocationID#1184
        , 1 // CustOrderHandlingInst#1185
        , 1 // ComplianceText#1186
        , 1 // PartyIDPositionAccount#1187
        , 1 // FreeText1#1188
        , 1 // FreeText2#1189
        , 1 // FreeText3#1190
        , 1 // FIXClOrdID#1191
        , 0 // NoLegs#1192
        //// LegOrdGrpComp
        , 1 // LegAccount#1193
        , 0 // LegPositionEffect#1194
        ///
        // ModifyOrderComplexShortRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1195
        , 0 // TemplateID#1196
        , 2 // NetworkMsgID#1197
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1198
        , 0 // SenderSubID#1199
        ///
        , 1 // ClOrdID#1200
        , 0 // OrigClOrdID#1201
        , 0 // SecurityID#1202
        , 0 // Price#1203
        , 0 // OrderQty#1204
        , 1 // PartyIDClientID#1205
        , 1 // PartyIdInvestmentDecisionMaker#1206
        , 1 // ExecutingTrader#1207
        , 0 // MarketSegmentID#1208
        , 1 // MatchInstCrossID#1209
        , 1 // EnrichmentRuleID#1210
        , 0 // ApplSeqIndicator#1211
        , 0 // ProductComplex#1212
        , 0 // Side#1213
        , 0 // PriceValidityCheckType#1214
        , 0 // ValueCheckTypeValue#1215
        , 0 // OrderAttributeLiquidityProvision#1216
        , 0 // ExecInst#1217
        , 0 // TimeInForce#1218
        , 0 // TradingCapacity#1219
        , 1 // OrderOrigination#1220
        , 1 // PartyIdInvestmentDecisionMakerQualifier#1221
        , 0 // ExecutingTraderQualifier#1222
        , 1 // ComplianceText#1223
        // ModifyOrderNRResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1224
        , 0 // TemplateID#1225
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#1226
        , 0 // TrdRegTSTimeIn#1227
        , 0 // TrdRegTSTimeOut#1228
        , 0 // ResponseIn#1229
        , 0 // SendingTime#1230
        , 0 // MsgSeqNum#1231
        , 0 // LastFragment#1232
        ///
        , 0 // OrderID#1233
        , 1 // ClOrdID#1234
        , 1 // OrigClOrdID#1235
        , 0 // SecurityID#1236
        , 0 // ExecID#1237
        , 0 // LeavesQty#1238
        , 0 // CumQty#1239
        , 0 // CxlQty#1240
        , 0 // OrdStatus#1241
        , 0 // ExecType#1242
        , 0 // ExecRestatementReason#1243
        , 0 // CrossedIndicator#1244
        , 0 // ProductComplex#1245
        , 0 // Triggered#1246
        , 0 // TransactionDelayIndicator#1247
        , 0 // NoOrderEvents#1248
        //// OrderEventGrpComp
        , 0 // OrderEventPx#1249
        , 0 // OrderEventQty#1250
        , 0 // OrderEventMatchID#1251
        , 0 // OrderEventReason#1252
        ///
        // ModifyOrderResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1253
        , 0 // TemplateID#1254
        ///
        //// ResponseHeaderMEComp
        , 0 // RequestTime#1255
        , 0 // TrdRegTSTimeIn#1256
        , 0 // TrdRegTSTimeOut#1257
        , 0 // ResponseIn#1258
        , 0 // SendingTime#1259
        , 0 // MsgSeqNum#1260
        , 0 // PartitionID#1261
        , 0 // ApplID#1262
        , 1 // ApplMsgID#1263
        , 0 // LastFragment#1264
        ///
        , 0 // OrderID#1265
        , 1 // ClOrdID#1266
        , 1 // OrigClOrdID#1267
        , 0 // SecurityID#1268
        , 0 // ExecID#1269
        , 0 // LeavesQty#1270
        , 0 // CumQty#1271
        , 0 // CxlQty#1272
        , 0 // TrdRegTSTimePriority#1273
        , 0 // OrdStatus#1274
        , 0 // ExecType#1275
        , 0 // ExecRestatementReason#1276
        , 0 // CrossedIndicator#1277
        , 0 // ProductComplex#1278
        , 0 // Triggered#1279
        , 0 // TransactionDelayIndicator#1280
        , 0 // NoOrderEvents#1281
        //// OrderEventGrpComp
        , 0 // OrderEventPx#1282
        , 0 // OrderEventQty#1283
        , 0 // OrderEventMatchID#1284
        , 0 // OrderEventReason#1285
        ///
        // ModifyOrderSingleRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1286
        , 0 // TemplateID#1287
        , 2 // NetworkMsgID#1288
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1289
        , 0 // SenderSubID#1290
        ///
        , 1 // OrderID#1291
        , 1 // ClOrdID#1292
        , 1 // OrigClOrdID#1293
        , 1 // Price#1294
        , 0 // OrderQty#1295
        , 1 // StopPx#1296
        , 1 // PartyIDClientID#1297
        , 1 // PartyIdInvestmentDecisionMaker#1298
        , 1 // ExecutingTrader#1299
        , 1 // ExpireDate#1300
        , 0 // MarketSegmentID#1301
        , 0 // SimpleSecurityID#1302
        , 1 // MatchInstCrossID#1303
        , 1 // TargetPartyIDSessionID#1304
        , 1 // PartyIDTakeUpTradingFirm#1305
        , 1 // PartyIDOrderOriginationFirm#1306
        , 1 // PartyIDBeneficiary#1307
        , 0 // ApplSeqIndicator#1308
        , 0 // Side#1309
        , 0 // OrdType#1310
        , 0 // PriceValidityCheckType#1311
        , 0 // ValueCheckTypeValue#1312
        , 0 // OrderAttributeLiquidityProvision#1313
        , 0 // TimeInForce#1314
        , 0 // ExecInst#1315
        , 1 // TradingSessionSubID#1316
        , 0 // TradingCapacity#1317
        , 1 // OrderOrigination#1318
        , 1 // PartyIdInvestmentDecisionMakerQualifier#1319
        , 1 // ExecutingTraderQualifier#1320
        , 1 // Account#1321
        , 1 // PartyIDPositionAccount#1322
        , 0 // PositionEffect#1323
        , 0 // OwnershipIndicator#1324
        , 1 // PartyIDLocationID#1325
        , 1 // CustOrderHandlingInst#1326
        , 1 // ComplianceText#1327
        , 1 // FreeText1#1328
        , 1 // FreeText2#1329
        , 1 // FreeText3#1330
        , 1 // FIXClOrdID#1331
        // ModifyOrderSingleShortRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1332
        , 0 // TemplateID#1333
        , 2 // NetworkMsgID#1334
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1335
        , 0 // SenderSubID#1336
        ///
        , 1 // ClOrdID#1337
        , 0 // OrigClOrdID#1338
        , 0 // Price#1339
        , 0 // OrderQty#1340
        , 1 // PartyIDClientID#1341
        , 1 // PartyIdInvestmentDecisionMaker#1342
        , 1 // ExecutingTrader#1343
        , 0 // SimpleSecurityID#1344
        , 1 // MatchInstCrossID#1345
        , 1 // EnrichmentRuleID#1346
        , 0 // Side#1347
        , 0 // PriceValidityCheckType#1348
        , 0 // ValueCheckTypeValue#1349
        , 0 // OrderAttributeLiquidityProvision#1350
        , 0 // TimeInForce#1351
        , 0 // ApplSeqIndicator#1352
        , 0 // ExecInst#1353
        , 0 // TradingCapacity#1354
        , 1 // OrderOrigination#1355
        , 1 // PartyIdInvestmentDecisionMakerQualifier#1356
        , 0 // ExecutingTraderQualifier#1357
        , 1 // ComplianceText#1358
        // ModifyTESTradeRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1359
        , 0 // TemplateID#1360
        , 2 // NetworkMsgID#1361
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1362
        , 0 // SenderSubID#1363
        ///
        , 0 // LastPx#1364
        , 1 // TransBkdTime#1365
        , 1 // CompressionID#1366
        , 0 // MarketSegmentID#1367
        , 0 // PackageID#1368
        , 0 // TESExecID#1369
        , 1 // RelatedMarketSegmentID#1370
        , 0 // TrdType#1371
        , 0 // TradeReportType#1372
        , 0 // TradePublishIndicator#1373
        , 0 // NoSideAllocs#1374
        , 0 // NoLegs#1375
        , 1 // SwapClearer#1376
        , 1 // TradeReportText#1377
        , 1 // TradeReportID#1378
        //// SideAllocGrpComp
        , 0 // AllocQty#1379
        , 1 // IndividualAllocID#1380
        , 1 // TESEnrichmentRuleID#1381
        , 0 // Side#1382
        , 0 // PartyExecutingFirm#1383
        , 0 // PartyExecutingTrader#1384
        ///
        //// TrdInstrmntLegGrpComp
        , 0 // LegSecurityID#1385
        , 0 // LegPrice#1386
        , 2 // LegQty#1387
        ///
        // NewOrderComplexRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1388
        , 0 // TemplateID#1389
        , 2 // NetworkMsgID#1390
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1391
        , 0 // SenderSubID#1392
        ///
        , 1 // ClOrdID#1393
        , 0 // SecurityID#1394
        , 0 // Price#1395
        , 0 // OrderQty#1396
        , 1 // PartyIDClientID#1397
        , 1 // PartyIdInvestmentDecisionMaker#1398
        , 1 // ExecutingTrader#1399
        , 0 // MarketSegmentID#1400
        , 1 // ExpireDate#1401
        , 1 // MatchInstCrossID#1402
        , 1 // PartyIDTakeUpTradingFirm#1403
        , 1 // PartyIDOrderOriginationFirm#1404
        , 1 // PartyIDBeneficiary#1405
        , 0 // ApplSeqIndicator#1406
        , 0 // ProductComplex#1407
        , 0 // Side#1408
        , 0 // OrdType#1409
        , 0 // PriceValidityCheckType#1410
        , 0 // ValueCheckTypeValue#1411
        , 0 // OrderAttributeLiquidityProvision#1412
        , 1 // OrderAttributeRiskReduction#1413
        , 0 // ExecInst#1414
        , 0 // TimeInForce#1415
        , 0 // TradingCapacity#1416
        , 1 // OrderOrigination#1417
        , 1 // PartyIdInvestmentDecisionMakerQualifier#1418
        , 0 // ExecutingTraderQualifier#1419
        , 1 // PartyIDLocationID#1420
        , 1 // ComplianceText#1421
        , 1 // CustOrderHandlingInst#1422
        , 1 // PartyIDPositionAccount#1423
        , 1 // FreeText1#1424
        , 1 // FreeText2#1425
        , 1 // FreeText3#1426
        , 1 // FIXClOrdID#1427
        , 0 // NoLegs#1428
        //// LegOrdGrpComp
        , 1 // LegAccount#1429
        , 0 // LegPositionEffect#1430
        ///
        // NewOrderComplexShortRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1431
        , 0 // TemplateID#1432
        , 2 // NetworkMsgID#1433
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1434
        , 0 // SenderSubID#1435
        ///
        , 0 // SecurityID#1436
        , 0 // Price#1437
        , 0 // OrderQty#1438
        , 0 // ClOrdID#1439
        , 1 // PartyIDClientID#1440
        , 1 // PartyIdInvestmentDecisionMaker#1441
        , 1 // ExecutingTrader#1442
        , 0 // MarketSegmentID#1443
        , 1 // MatchInstCrossID#1444
        , 1 // EnrichmentRuleID#1445
        , 0 // ApplSeqIndicator#1446
        , 0 // ProductComplex#1447
        , 0 // Side#1448
        , 0 // PriceValidityCheckType#1449
        , 0 // ValueCheckTypeValue#1450
        , 0 // OrderAttributeLiquidityProvision#1451
        , 0 // ExecInst#1452
        , 0 // TimeInForce#1453
        , 0 // TradingCapacity#1454
        , 1 // OrderOrigination#1455
        , 1 // PartyIdInvestmentDecisionMakerQualifier#1456
        , 0 // ExecutingTraderQualifier#1457
        , 1 // ComplianceText#1458
        // NewOrderNRResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1459
        , 0 // TemplateID#1460
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#1461
        , 0 // TrdRegTSTimeIn#1462
        , 0 // TrdRegTSTimeOut#1463
        , 0 // ResponseIn#1464
        , 0 // SendingTime#1465
        , 0 // MsgSeqNum#1466
        , 0 // LastFragment#1467
        ///
        , 0 // OrderID#1468
        , 1 // ClOrdID#1469
        , 0 // SecurityID#1470
        , 0 // ExecID#1471
        , 0 // LeavesQty#1472
        , 0 // CxlQty#1473
        , 0 // OrdStatus#1474
        , 0 // ExecType#1475
        , 0 // ExecRestatementReason#1476
        , 0 // CrossedIndicator#1477
        , 0 // ProductComplex#1478
        , 0 // Triggered#1479
        , 0 // TransactionDelayIndicator#1480
        , 0 // NoOrderEvents#1481
        //// OrderEventGrpComp
        , 0 // OrderEventPx#1482
        , 0 // OrderEventQty#1483
        , 0 // OrderEventMatchID#1484
        , 0 // OrderEventReason#1485
        ///
        // NewOrderResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1486
        , 0 // TemplateID#1487
        ///
        //// ResponseHeaderMEComp
        , 0 // RequestTime#1488
        , 0 // TrdRegTSTimeIn#1489
        , 0 // TrdRegTSTimeOut#1490
        , 0 // ResponseIn#1491
        , 0 // SendingTime#1492
        , 0 // MsgSeqNum#1493
        , 0 // PartitionID#1494
        , 0 // ApplID#1495
        , 1 // ApplMsgID#1496
        , 0 // LastFragment#1497
        ///
        , 0 // OrderID#1498
        , 1 // ClOrdID#1499
        , 0 // SecurityID#1500
        , 0 // ExecID#1501
        , 0 // LeavesQty#1502
        , 0 // CxlQty#1503
        , 0 // TrdRegTSEntryTime#1504
        , 0 // TrdRegTSTimePriority#1505
        , 0 // OrdStatus#1506
        , 0 // ExecType#1507
        , 0 // ExecRestatementReason#1508
        , 0 // CrossedIndicator#1509
        , 0 // ProductComplex#1510
        , 0 // Triggered#1511
        , 0 // TransactionDelayIndicator#1512
        , 0 // NoOrderEvents#1513
        //// OrderEventGrpComp
        , 0 // OrderEventPx#1514
        , 0 // OrderEventQty#1515
        , 0 // OrderEventMatchID#1516
        , 0 // OrderEventReason#1517
        ///
        // NewOrderSingleRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1518
        , 0 // TemplateID#1519
        , 2 // NetworkMsgID#1520
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1521
        , 0 // SenderSubID#1522
        ///
        , 1 // Price#1523
        , 0 // OrderQty#1524
        , 1 // StopPx#1525
        , 1 // ClOrdID#1526
        , 1 // PartyIDClientID#1527
        , 1 // PartyIdInvestmentDecisionMaker#1528
        , 1 // ExecutingTrader#1529
        , 1 // ExpireDate#1530
        , 0 // MarketSegmentID#1531
        , 0 // SimpleSecurityID#1532
        , 1 // MatchInstCrossID#1533
        , 1 // PartyIDTakeUpTradingFirm#1534
        , 1 // PartyIDOrderOriginationFirm#1535
        , 1 // PartyIDBeneficiary#1536
        , 0 // ApplSeqIndicator#1537
        , 0 // Side#1538
        , 0 // OrdType#1539
        , 0 // PriceValidityCheckType#1540
        , 0 // ValueCheckTypeValue#1541
        , 0 // OrderAttributeLiquidityProvision#1542
        , 1 // OrderAttributeRiskReduction#1543
        , 0 // TimeInForce#1544
        , 0 // ExecInst#1545
        , 1 // TradingSessionSubID#1546
        , 0 // TradingCapacity#1547
        , 1 // OrderOrigination#1548
        , 1 // PartyIdInvestmentDecisionMakerQualifier#1549
        , 0 // ExecutingTraderQualifier#1550
        , 1 // Account#1551
        , 1 // PartyIDPositionAccount#1552
        , 0 // PositionEffect#1553
        , 1 // PartyIDLocationID#1554
        , 1 // CustOrderHandlingInst#1555
        , 1 // ComplianceText#1556
        , 1 // FreeText1#1557
        , 1 // FreeText2#1558
        , 1 // FreeText3#1559
        , 1 // FIXClOrdID#1560
        // NewOrderSingleShortRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1561
        , 0 // TemplateID#1562
        , 2 // NetworkMsgID#1563
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1564
        , 0 // SenderSubID#1565
        ///
        , 0 // Price#1566
        , 0 // OrderQty#1567
        , 0 // ClOrdID#1568
        , 1 // PartyIDClientID#1569
        , 1 // PartyIdInvestmentDecisionMaker#1570
        , 1 // ExecutingTrader#1571
        , 0 // SimpleSecurityID#1572
        , 1 // MatchInstCrossID#1573
        , 1 // EnrichmentRuleID#1574
        , 0 // Side#1575
        , 0 // ApplSeqIndicator#1576
        , 0 // PriceValidityCheckType#1577
        , 0 // ValueCheckTypeValue#1578
        , 0 // OrderAttributeLiquidityProvision#1579
        , 0 // TimeInForce#1580
        , 0 // ExecInst#1581
        , 0 // TradingCapacity#1582
        , 1 // OrderOrigination#1583
        , 1 // PartyIdInvestmentDecisionMakerQualifier#1584
        , 0 // ExecutingTraderQualifier#1585
        , 1 // ComplianceText#1586
        // NewsBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#1587
        , 0 // TemplateID#1588
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#1589
        , 1 // ApplSeqNum#1590
        , 1 // ApplSubID#1591
        , 0 // PartitionID#1592
        , 0 // ApplResendFlag#1593
        , 0 // ApplID#1594
        , 0 // LastFragment#1595
        ///
        , 0 // OrigTime#1596
        , 0 // VarTextLen#1597
        , 0 // Headline#1598
        , 1 // VarText#1599
        // OrderExecNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#1600
        , 0 // TemplateID#1601
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#1602
        , 1 // NotificationIn#1603
        , 0 // SendingTime#1604
        , 2 // ApplSubID#1605
        , 0 // PartitionID#1606
        , 0 // ApplMsgID#1607
        , 0 // ApplID#1608
        , 0 // ApplResendFlag#1609
        , 0 // LastFragment#1610
        ///
        , 0 // OrderID#1611
        , 1 // ClOrdID#1612
        , 1 // OrigClOrdID#1613
        , 0 // SecurityID#1614
        , 0 // ExecID#1615
        , 0 // LeavesQty#1616
        , 0 // CumQty#1617
        , 0 // CxlQty#1618
        , 0 // MarketSegmentID#1619
        , 0 // NoLegExecs#1620
        , 0 // ExecRestatementReason#1621
        , 0 // Side#1622
        , 0 // ProductComplex#1623
        , 0 // OrdStatus#1624
        , 0 // ExecType#1625
        , 0 // Triggered#1626
        , 0 // CrossedIndicator#1627
        , 1 // FIXClOrdID#1628
        , 0 // NoFills#1629
        , 0 // NoOrderEvents#1630
        //// FillsGrpComp
        , 0 // FillPx#1631
        , 0 // FillQty#1632
        , 0 // FillMatchID#1633
        , 0 // FillExecID#1634
        , 1 // FillLiquidityInd#1635
        ///
        //// InstrmntLegExecGrpComp
        , 0 // LegSecurityID#1636
        , 0 // LegLastPx#1637
        , 0 // LegLastQty#1638
        , 0 // LegExecID#1639
        , 0 // LegSide#1640
        , 0 // FillRefID#1641
        ///
        //// OrderEventGrpComp
        , 0 // OrderEventPx#1642
        , 0 // OrderEventQty#1643
        , 0 // OrderEventMatchID#1644
        , 0 // OrderEventReason#1645
        ///
        // OrderExecReportBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#1646
        , 0 // TemplateID#1647
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#1648
        , 1 // NotificationIn#1649
        , 0 // SendingTime#1650
        , 1 // ApplSubID#1651
        , 0 // PartitionID#1652
        , 1 // ApplMsgID#1653
        , 0 // ApplID#1654
        , 0 // ApplResendFlag#1655
        , 0 // LastFragment#1656
        ///
        , 0 // OrderID#1657
        , 1 // ClOrdID#1658
        , 1 // OrigClOrdID#1659
        , 0 // SecurityID#1660
        , 0 // ExecID#1661
        , 0 // TrdRegTSEntryTime#1662
        , 0 // TrdRegTSTimePriority#1663
        , 1 // Price#1664
        , 0 // LeavesQty#1665
        , 0 // CumQty#1666
        , 0 // CxlQty#1667
        , 0 // OrderQty#1668
        , 1 // StopPx#1669
        , 0 // MarketSegmentID#1670
        , 1 // ExpireDate#1671
        , 1 // MatchInstCrossID#1672
        , 1 // PartyIDExecutingUnit#1673
        , 1 // PartyIDSessionID#1674
        , 1 // PartyIDExecutingTrader#1675
        , 1 // PartyIDEnteringTrader#1676
        , 0 // NoLegExecs#1677
        , 0 // ExecRestatementReason#1678
        , 1 // PartyIDEnteringFirm#1679
        , 0 // ProductComplex#1680
        , 0 // OrdStatus#1681
        , 0 // ExecType#1682
        , 0 // Side#1683
        , 0 // OrdType#1684
        , 0 // TradingCapacity#1685
        , 1 // TimeInForce#1686
        , 1 // ExecInst#1687
        , 1 // TradingSessionSubID#1688
        , 1 // ApplSeqIndicator#1689
        , 1 // Account#1690
        , 1 // PartyIDPositionAccount#1691
        , 1 // PositionEffect#1692
        , 1 // PartyIDTakeUpTradingFirm#1693
        , 1 // PartyIDOrderOriginationFirm#1694
        , 1 // PartyIDBeneficiary#1695
        , 1 // PartyIDLocationID#1696
        , 1 // CustOrderHandlingInst#1697
        , 1 // ComplianceText#1698
        , 1 // FreeText1#1699
        , 1 // FreeText2#1700
        , 1 // FreeText3#1701
        , 1 // FIXClOrdID#1702
        , 0 // NoFills#1703
        , 0 // NoLegs#1704
        , 0 // NoOrderEvents#1705
        , 0 // Triggered#1706
        , 0 // CrossedIndicator#1707
        //// LegOrdGrpComp
        , 1 // LegAccount#1708
        , 0 // LegPositionEffect#1709
        ///
        //// FillsGrpComp
        , 0 // FillPx#1710
        , 1 // FillQty#1711
        , 0 // FillMatchID#1712
        , 0 // FillExecID#1713
        , 1 // FillLiquidityInd#1714
        ///
        //// InstrmntLegExecGrpComp
        , 0 // LegSecurityID#1715
        , 0 // LegLastPx#1716
        , 0 // LegLastQty#1717
        , 0 // LegExecID#1718
        , 0 // LegSide#1719
        , 0 // FillRefID#1720
        ///
        //// OrderEventGrpComp
        , 0 // OrderEventPx#1721
        , 0 // OrderEventQty#1722
        , 0 // OrderEventMatchID#1723
        , 0 // OrderEventReason#1724
        ///
        // OrderExecResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1725
        , 0 // TemplateID#1726
        ///
        //// ResponseHeaderMEComp
        , 0 // RequestTime#1727
        , 0 // TrdRegTSTimeIn#1728
        , 0 // TrdRegTSTimeOut#1729
        , 0 // ResponseIn#1730
        , 0 // SendingTime#1731
        , 0 // MsgSeqNum#1732
        , 0 // PartitionID#1733
        , 0 // ApplID#1734
        , 1 // ApplMsgID#1735
        , 0 // LastFragment#1736
        ///
        , 0 // OrderID#1737
        , 1 // ClOrdID#1738
        , 1 // OrigClOrdID#1739
        , 0 // SecurityID#1740
        , 0 // ExecID#1741
        , 1 // TrdRegTSEntryTime#1742
        , 1 // TrdRegTSTimePriority#1743
        , 0 // LeavesQty#1744
        , 0 // CumQty#1745
        , 0 // CxlQty#1746
        , 0 // MarketSegmentID#1747
        , 0 // NoLegExecs#1748
        , 0 // ExecRestatementReason#1749
        , 0 // Side#1750
        , 0 // ProductComplex#1751
        , 0 // OrdStatus#1752
        , 0 // ExecType#1753
        , 0 // Triggered#1754
        , 0 // CrossedIndicator#1755
        , 0 // TransactionDelayIndicator#1756
        , 0 // NoFills#1757
        , 0 // NoOrderEvents#1758
        //// FillsGrpComp
        , 0 // FillPx#1759
        , 0 // FillQty#1760
        , 0 // FillMatchID#1761
        , 0 // FillExecID#1762
        , 1 // FillLiquidityInd#1763
        ///
        //// InstrmntLegExecGrpComp
        , 0 // LegSecurityID#1764
        , 0 // LegLastPx#1765
        , 0 // LegLastQty#1766
        , 0 // LegExecID#1767
        , 0 // LegSide#1768
        , 0 // FillRefID#1769
        ///
        //// OrderEventGrpComp
        , 0 // OrderEventPx#1770
        , 0 // OrderEventQty#1771
        , 0 // OrderEventMatchID#1772
        , 0 // OrderEventReason#1773
        ///
        // PartyActionReport
        //// MessageHeaderOutComp
        , 0 // BodyLen#1774
        , 0 // TemplateID#1775
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#1776
        , 0 // ApplSeqNum#1777
        , 2 // ApplSubID#1778
        , 0 // PartitionID#1779
        , 0 // ApplResendFlag#1780
        , 0 // ApplID#1781
        , 0 // LastFragment#1782
        ///
        , 0 // TransactTime#1783
        , 1 // TradeDate#1784
        , 1 // RequestingPartyIDExecutingTrader#1785
        , 0 // PartyIDExecutingUnit#1786
        , 1 // PartyIDExecutingTrader#1787
        , 0 // RequestingPartyIDExecutingSystem#1788
        , 1 // MarketID#1789
        , 0 // PartyActionType#1790
        , 0 // RequestingPartyIDEnteringFirm#1791
        // PartyEntitlementsUpdateReport
        //// MessageHeaderOutComp
        , 0 // BodyLen#1792
        , 0 // TemplateID#1793
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#1794
        , 0 // ApplSeqNum#1795
        , 2 // ApplSubID#1796
        , 0 // PartitionID#1797
        , 0 // ApplResendFlag#1798
        , 0 // ApplID#1799
        , 0 // LastFragment#1800
        ///
        , 0 // TransactTime#1801
        , 0 // TradeDate#1802
        , 0 // PartyDetailIDExecutingUnit#1803
        , 0 // RequestingPartyIDExecutingSystem#1804
        , 1 // MarketID#1805
        , 0 // ListUpdateAction#1806
        , 0 // RequestingPartyEnteringFirm#1807
        , 1 // RequestingPartyClearingFirm#1808
        , 0 // PartyDetailStatus#1809
        // PingRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1810
        , 0 // TemplateID#1811
        , 2 // NetworkMsgID#1812
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1813
        , 0 // SenderSubID#1814
        ///
        , 0 // PartitionID#1815
        // PingResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1816
        , 0 // TemplateID#1817
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#1818
        , 0 // TrdRegTSTimeIn#1819
        , 0 // TrdRegTSTimeOut#1820
        , 0 // ResponseIn#1821
        , 0 // SendingTime#1822
        , 0 // MsgSeqNum#1823
        , 0 // LastFragment#1824
        ///
        , 0 // TransactTime#1825
        // PreTradeRiskLimitResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1826
        , 0 // TemplateID#1827
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#1828
        , 1 // TrdRegTSTimeIn#1829
        , 1 // TrdRegTSTimeOut#1830
        , 0 // ResponseIn#1831
        , 0 // SendingTime#1832
        , 0 // MsgSeqNum#1833
        , 0 // LastFragment#1834
        ///
        , 0 // RiskLimitReportID#1835
        , 0 // MarketSegmentID#1836
        , 0 // NoRiskLimits#1837
        , 0 // PartyDetailStatus#1838
        , 0 // RiskLimitPlatform#1839
        , 0 // PartyDetailExecutingUnit#1840
        //// RiskLimitsRptGrpComp
        , 1 // RiskLimitQty#1841
        , 1 // RiskLimitOpenQty#1842
        , 1 // RiskLimitNetPositionQty#1843
        , 1 // NettingCoefficient#1844
        , 0 // RiskLimitType#1845
        , 0 // RiskLimitRequestingPartyRole#1846
        , 1 // RiskLimitViolationIndicator#1847
        , 1 // RiskLimitGroup#1848
        ///
        // PreTradeRiskLimitsDefinitionRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1849
        , 0 // TemplateID#1850
        , 2 // NetworkMsgID#1851
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1852
        , 0 // SenderSubID#1853
        ///
        , 1 // NettingCoefficient#1854
        , 0 // MarketSegmentID#1855
        , 0 // RiskLimitPlatform#1856
        , 0 // NoRiskLimitsQty#1857
        , 1 // PartyDetailStatus#1858
        , 1 // RiskLimitGroup#1859
        , 1 // PartyDetailExecutingUnit#1860
        //// RiskLimitQtyGrpComp
        , 1 // RiskLimitQty#1861
        , 0 // RiskLimitType#1862
        ///
        // QuoteActivationNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#1863
        , 0 // TemplateID#1864
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#1865
        , 1 // NotificationIn#1866
        , 0 // SendingTime#1867
        , 2 // ApplSubID#1868
        , 0 // PartitionID#1869
        , 0 // ApplMsgID#1870
        , 0 // ApplID#1871
        , 0 // ApplResendFlag#1872
        , 0 // LastFragment#1873
        ///
        , 0 // MassActionReportID#1874
        , 0 // MarketSegmentID#1875
        , 1 // PartyIDEnteringTrader#1876
        , 0 // NoNotAffectedSecurities#1877
        , 1 // PartyIDEnteringFirm#1878
        , 0 // MassActionType#1879
        , 1 // MassActionSubType#1880
        , 0 // MassActionReason#1881
        //// NotAffectedSecuritiesGrpComp
        , 0 // NotAffectedSecurityID#1882
        ///
        // QuoteActivationRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1883
        , 0 // TemplateID#1884
        , 2 // NetworkMsgID#1885
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1886
        , 0 // SenderSubID#1887
        ///
        , 1 // PartyIdInvestmentDecisionMaker#1888
        , 1 // ExecutingTrader#1889
        , 0 // MarketSegmentID#1890
        , 0 // TargetPartyIDSessionID#1891
        , 0 // MassActionType#1892
        , 1 // MassActionSubType#1893
        , 1 // PartyIdInvestmentDecisionMakerQualifier#1894
        , 0 // ExecutingTraderQualifier#1895
        // QuoteActivationResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1896
        , 0 // TemplateID#1897
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#1898
        , 1 // TrdRegTSTimeIn#1899
        , 1 // TrdRegTSTimeOut#1900
        , 0 // ResponseIn#1901
        , 0 // SendingTime#1902
        , 0 // MsgSeqNum#1903
        , 0 // LastFragment#1904
        ///
        , 0 // MassActionReportID#1905
        , 0 // NoNotAffectedSecurities#1906
        //// NotAffectedSecuritiesGrpComp
        , 0 // NotAffectedSecurityID#1907
        ///
        // QuoteExecutionReport
        //// MessageHeaderOutComp
        , 0 // BodyLen#1908
        , 0 // TemplateID#1909
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#1910
        , 1 // NotificationIn#1911
        , 0 // SendingTime#1912
        , 2 // ApplSubID#1913
        , 0 // PartitionID#1914
        , 1 // ApplMsgID#1915
        , 0 // ApplID#1916
        , 0 // ApplResendFlag#1917
        , 0 // LastFragment#1918
        ///
        , 0 // ExecID#1919
        , 0 // MarketSegmentID#1920
        , 0 // NoLegExecs#1921
        , 0 // NoQuoteEvents#1922
        //// QuoteEventGrpComp
        , 0 // SecurityID#1923
        , 1 // QuoteEventPx#1924
        , 1 // QuoteEventQty#1925
        , 0 // QuoteMsgID#1926
        , 1 // QuoteEventMatchID#1927
        , 1 // QuoteEventExecID#1928
        , 0 // QuoteEventType#1929
        , 0 // QuoteEventSide#1930
        , 1 // QuoteEventLiquidityInd#1931
        , 1 // QuoteEventReason#1932
        ///
        //// QuoteLegExecGrpComp
        , 0 // LegSecurityID#1933
        , 0 // LegLastPx#1934
        , 0 // LegLastQty#1935
        , 0 // LegExecID#1936
        , 0 // LegSide#1937
        , 0 // NoQuoteEventsIndex#1938
        ///
        // RFQRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1939
        , 0 // TemplateID#1940
        , 2 // NetworkMsgID#1941
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1942
        , 0 // SenderSubID#1943
        ///
        , 0 // SecurityID#1944
        , 1 // OrderQty#1945
        , 0 // MarketSegmentID#1946
        , 1 // Side#1947
        , 1 // ComplianceText#1948
        // RFQResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1949
        , 0 // TemplateID#1950
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#1951
        , 0 // TrdRegTSTimeIn#1952
        , 0 // TrdRegTSTimeOut#1953
        , 0 // ResponseIn#1954
        , 0 // SendingTime#1955
        , 0 // MsgSeqNum#1956
        , 0 // LastFragment#1957
        ///
        , 0 // ExecID#1958
        // Reject
        //// MessageHeaderOutComp
        , 0 // BodyLen#1959
        , 0 // TemplateID#1960
        ///
        //// NRResponseHeaderMEComp
        , 0 // RequestTime#1961
        , 1 // TrdRegTSTimeIn#1962
        , 1 // TrdRegTSTimeOut#1963
        , 1 // ResponseIn#1964
        , 0 // SendingTime#1965
        , 0 // MsgSeqNum#1966
        , 0 // LastFragment#1967
        ///
        , 0 // SessionRejectReason#1968
        , 0 // VarTextLen#1969
        , 0 // SessionStatus#1970
        , 0 // VarText#1971
        // RetransmitMEMessageRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1972
        , 0 // TemplateID#1973
        , 2 // NetworkMsgID#1974
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1975
        , 2 // SenderSubID#1976
        ///
        , 1 // SubscriptionScope#1977
        , 0 // PartitionID#1978
        , 0 // RefApplID#1979
        , 1 // ApplBegMsgID#1980
        , 1 // ApplEndMsgID#1981
        // RetransmitMEMessageResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1982
        , 0 // TemplateID#1983
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#1984
        , 0 // SendingTime#1985
        , 0 // MsgSeqNum#1986
        ///
        , 0 // ApplTotalMessageCount#1987
        , 1 // ApplEndMsgID#1988
        , 1 // RefApplLastMsgID#1989
        // RetransmitRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#1990
        , 0 // TemplateID#1991
        , 2 // NetworkMsgID#1992
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#1993
        , 2 // SenderSubID#1994
        ///
        , 1 // ApplBegSeqNum#1995
        , 1 // ApplEndSeqNum#1996
        , 1 // PartitionID#1997
        , 0 // RefApplID#1998
        // RetransmitResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#1999
        , 0 // TemplateID#2000
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#2001
        , 0 // SendingTime#2002
        , 0 // MsgSeqNum#2003
        ///
        , 1 // ApplEndSeqNum#2004
        , 1 // RefApplLastSeqNum#2005
        , 0 // ApplTotalMessageCount#2006
        // ReverseTESTradeRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#2007
        , 0 // TemplateID#2008
        , 2 // NetworkMsgID#2009
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#2010
        , 0 // SenderSubID#2011
        ///
        , 0 // MarketSegmentID#2012
        , 0 // PackageID#2013
        , 0 // TESExecID#2014
        , 1 // RelatedMarketSegmentID#2015
        , 0 // TrdType#2016
        , 1 // TradeReportID#2017
        , 1 // ReversalReasonText#2018
        // RiskNotificationBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#2019
        , 0 // TemplateID#2020
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#2021
        , 0 // ApplSeqNum#2022
        , 2 // ApplSubID#2023
        , 0 // PartitionID#2024
        , 0 // ApplResendFlag#2025
        , 0 // ApplID#2026
        , 0 // LastFragment#2027
        ///
        , 0 // TransactTime#2028
        , 0 // TradeDate#2029
        , 0 // PartyDetailIDExecutingUnit#2030
        , 0 // RequestingPartyIDExecutingSystem#2031
        , 1 // MarketID#2032
        , 0 // ListUpdateAction#2033
        , 1 // RiskLimitAction#2034
        , 0 // RequestingPartyEnteringFirm#2035
        , 1 // RequestingPartyClearingFirm#2036
        // SRQSCreateDealNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#2037
        , 0 // TemplateID#2038
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#2039
        , 0 // ApplSeqNum#2040
        , 1 // ApplSubID#2041
        , 2 // PartitionID#2042
        , 0 // ApplResendFlag#2043
        , 0 // ApplID#2044
        , 0 // LastFragment#2045
        ///
        , 0 // TransactTime#2046
        , 0 // LastPx#2047
        , 0 // LastQty#2048
        , 1 // SecurityID#2049
        , 1 // ExpireTime#2050
        , 1 // UnderlyingPx#2051
        , 1 // UnderlyingDeltaPercentage#2052
        , 1 // UnderlyingEffectiveDeltaPercentage#2053
        , 1 // UnderlyingQty#2054
        , 1 // UnderlyingPriceStipValue#2055
        , 0 // NegotiationID#2056
        , 0 // TradeID#2057
        , 1 // OrigTradeID#2058
        , 0 // TrdRptStatus#2059
        , 1 // TradeReportType#2060
        , 0 // MessageEventSource#2061
        , 0 // Side#2062
        , 1 // NoOrderBookItems#2063
        , 1 // TradingCapacity#2064
        , 1 // TradePublishIndicator#2065
        , 1 // HedgingInstruction#2066
        , 0 // NoSRQSTargetPartyTrdGrps#2067
        , 0 // RootPartyExecutingFirm#2068
        , 0 // RootPartyExecutingTrader#2069
        , 0 // RootPartyEnteringTrader#2070
        , 1 // FirmTradeID#2071
        , 1 // FirmNegotiationID#2072
        , 1 // FreeText1#2073
        , 1 // FreeText2#2074
        , 1 // FreeText3#2075
        , 1 // FreeText5#2076
        , 1 // PositionEffect#2077
        , 1 // Account#2078
        , 1 // PartyIDBeneficiary#2079
        , 1 // CustOrderHandlingInst#2080
        , 1 // PartyIDOrderOriginationFirm#2081
        , 1 // PartyIDPositionAccount#2082
        , 1 // PartyIDLocationID#2083
        , 1 // ComplianceText#2084
        , 1 // PartyIDTakeUpTradingFirm#2085
        //// OrderBookItemGrpComp
        , 0 // SecurityID#2086
        , 1 // BestBidPx#2087
        , 1 // BestBidSize#2088
        , 1 // BestOfferPx#2089
        , 1 // BestOfferSize#2090
        , 0 // MDBookType#2091
        , 1 // MDSubBookType#2092
        ///
        //// SRQSTargetPartyTrdGrpComp
        , 0 // SideLastQty#2093
        , 0 // QuoteID#2094
        , 1 // TargetPartyIDExecutingTrader#2095
        , 0 // TargetPartyExecutingFirm#2096
        , 0 // TargetPartyExecutingTrader#2097
        , 0 // TargetPartyEnteringTrader#2098
        ///
        // SRQSDealNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#2099
        , 0 // TemplateID#2100
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#2101
        , 0 // ApplSeqNum#2102
        , 1 // ApplSubID#2103
        , 2 // PartitionID#2104
        , 0 // ApplResendFlag#2105
        , 0 // ApplID#2106
        , 0 // LastFragment#2107
        ///
        , 0 // TransactTime#2108
        , 1 // UnderlyingPriceStipValue#2109
        , 1 // UnderlyingPx#2110
        , 1 // LastPx#2111
        , 1 // LastQty#2112
        , 0 // NegotiationID#2113
        , 0 // TradeID#2114
        , 1 // RequestingPartySubIDType#2115
        , 0 // TrdRptStatus#2116
        , 1 // TradeRequestResult#2117
        , 0 // MessageEventSource#2118
        , 1 // TradingCapacity#2119
        , 1 // NoSRQSTargetPartyTrdGrps#2120
        , 1 // RootPartyExecutingFirm#2121
        , 1 // RootPartyExecutingTrader#2122
        , 1 // RootPartyEnteringTrader#2123
        , 1 // FirmTradeID#2124
        , 1 // FirmNegotiationID#2125
        , 1 // FreeText1#2126
        , 1 // FreeText2#2127
        , 1 // FreeText3#2128
        , 1 // FreeText5#2129
        , 1 // PositionEffect#2130
        , 1 // Account#2131
        , 1 // PartyIDBeneficiary#2132
        , 1 // CustOrderHandlingInst#2133
        , 1 // PartyIDOrderOriginationFirm#2134
        , 1 // PartyIDPositionAccount#2135
        , 1 // PartyIDLocationID#2136
        , 1 // ComplianceText#2137
        , 1 // PartyIDTakeUpTradingFirm#2138
        //// SRQSTargetPartyTrdGrpComp
        , 2 // SideLastQty#2139
        , 2 // QuoteID#2140
        , 1 // TargetPartyIDExecutingTrader#2141
        , 1 // TargetPartyExecutingFirm#2142
        , 1 // TargetPartyExecutingTrader#2143
        , 1 // TargetPartyEnteringTrader#2144
        ///
        // SRQSDealResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#2145
        , 0 // TemplateID#2146
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#2147
        , 0 // SendingTime#2148
        , 0 // MsgSeqNum#2149
        ///
        , 1 // SecurityID#2150
        , 0 // NegotiationID#2151
        , 1 // TradeID#2152
        , 1 // SecondaryTradeID#2153
        , 0 // NoSRQSQuoteGrps#2154
        , 1 // FirmTradeID#2155
        , 1 // FirmNegotiationID#2156
        //// SRQSQuoteGrpComp
        , 0 // QuoteID#2157
        ///
        // SRQSEnterQuoteRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#2158
        , 0 // TemplateID#2159
        , 2 // NetworkMsgID#2160
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#2161
        , 0 // SenderSubID#2162
        ///
        , 1 // BidPx#2163
        , 1 // OfferPx#2164
        , 1 // UnderlyingDeltaPercentage#2165
        , 1 // BidSize#2166
        , 1 // OfferSize#2167
        , 1 // PartyIDClientID#2168
        , 1 // PartyIdInvestmentDecisionMaker#2169
        , 1 // ExecutingTrader#2170
        , 1 // QuoteRefPrice#2171
        , 1 // ValidUntilTime#2172
        , 0 // MarketSegmentID#2173
        , 0 // NegotiationID#2174
        , 1 // OrderAttributeLiquidityProvision#2175
        , 1 // ExecutingTraderQualifier#2176
        , 1 // PartyIdInvestmentDecisionMakerQualifier#2177
        , 1 // TradingCapacity#2178
        , 0 // PartyExecutingFirm#2179
        , 0 // PartyExecutingTrader#2180
        , 1 // FreeText1#2181
        , 1 // FreeText2#2182
        , 1 // FreeText3#2183
        , 1 // FreeText5#2184
        , 1 // PositionEffect#2185
        , 1 // Account#2186
        , 1 // PartyIDBeneficiary#2187
        , 1 // CustOrderHandlingInst#2188
        , 1 // PartyIDOrderOriginationFirm#2189
        , 1 // PartyIDPositionAccount#2190
        , 1 // PartyIDLocationID#2191
        , 1 // ComplianceText#2192
        , 1 // PartyIDTakeUpTradingFirm#2193
        // SRQSHitQuoteRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#2194
        , 0 // TemplateID#2195
        , 2 // NetworkMsgID#2196
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#2197
        , 0 // SenderSubID#2198
        ///
        , 1 // ValidUntilTime#2199
        , 1 // UnderlyingQty#2200
        , 1 // UnderlyingPriceStipValue#2201
        , 1 // PartyIDClientID#2202
        , 1 // PartyIdInvestmentDecisionMaker#2203
        , 1 // ExecutingTrader#2204
        , 0 // MarketSegmentID#2205
        , 0 // NegotiationID#2206
        , 1 // OrderAttributeLiquidityProvision#2207
        , 1 // ExecutingTraderQualifier#2208
        , 1 // PartyIdInvestmentDecisionMakerQualifier#2209
        , 1 // TradingCapacity#2210
        , 1 // TradePublishIndicator#2211
        , 1 // OrderOrigination#2212
        , 1 // HedgingInstruction#2213
        , 0 // NoSRQSQuoteGrps#2214
        , 0 // PartyExecutingFirm#2215
        , 0 // PartyExecutingTrader#2216
        , 1 // FirmTradeID#2217
        , 1 // FreeText1#2218
        , 1 // FreeText2#2219
        , 1 // FreeText3#2220
        , 1 // FreeText5#2221
        , 1 // PositionEffect#2222
        , 1 // Account#2223
        , 1 // PartyIDBeneficiary#2224
        , 1 // CustOrderHandlingInst#2225
        , 1 // PartyIDOrderOriginationFirm#2226
        , 1 // PartyIDPositionAccount#2227
        , 1 // PartyIDLocationID#2228
        , 1 // ComplianceText#2229
        , 1 // PartyIDTakeUpTradingFirm#2230
        //// SRQSHitQuoteGrpComp
        , 0 // OrderQty#2231
        , 0 // QuoteID#2232
        , 0 // Side#2233
        ///
        // SRQSInquireSmartRespondentRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#2234
        , 0 // TemplateID#2235
        , 2 // NetworkMsgID#2236
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#2237
        , 0 // SenderSubID#2238
        ///
        , 0 // MarketSegmentID#2239
        , 0 // EurexVolumeRanking#2240
        , 0 // EnlightRFQAvgRespTimeRanking#2241
        , 0 // EnlightRFQAvgRespRateRanking#2242
        , 0 // TradeToQuoteRatioRanking#2243
        // SRQSInquireSmartRespondentResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#2244
        , 0 // TemplateID#2245
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#2246
        , 0 // SendingTime#2247
        , 0 // MsgSeqNum#2248
        ///
        , 0 // MarketSegmentID#2249
        , 0 // NoPartyDetails#2250
        //// SmartPartyDetailGrpComp
        , 0 // PartyDetailExecutingUnit#2251
        , 0 // PartyDetailExecutingTrader#2252
        ///
        // SRQSNegotiationNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#2253
        , 0 // TemplateID#2254
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#2255
        , 0 // ApplSeqNum#2256
        , 1 // ApplSubID#2257
        , 2 // PartitionID#2258
        , 0 // ApplResendFlag#2259
        , 0 // ApplID#2260
        , 0 // LastFragment#2261
        ///
        , 0 // TransactTime#2262
        , 1 // QuoteRefPrice#2263
        , 1 // UnderlyingDeltaPercentage#2264
        , 1 // BidPx#2265
        , 1 // OfferPx#2266
        , 1 // LastPx#2267
        , 1 // LeavesQty#2268
        , 1 // LastQty#2269
        , 1 // EffectiveTime#2270
        , 1 // LastUpdateTime#2271
        , 1 // TradeToQuoteRatio#2272
        , 0 // NegotiationID#2273
        , 1 // NumberOfRespondents#2274
        , 1 // TradeToQuoteRatioPosition#2275
        , 0 // QuoteType#2276
        , 0 // QuoteSubType#2277
        , 0 // QuoteInstruction#2278
        , 1 // Side#2279
        , 1 // TradeAggregationTransType#2280
        , 0 // QuoteCondition#2281
        , 0 // PartyExecutingFirm#2282
        , 0 // PartyExecutingTrader#2283
        , 0 // PartyEnteringTrader#2284
        , 1 // TargetPartyExecutingFirm#2285
        , 1 // TargetPartyExecutingTrader#2286
        , 1 // FirmNegotiationID#2287
        , 1 // FreeText5#2288
        , 1 // PartyOrderOriginationTrader#2289
        // SRQSNegotiationRequesterNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#2290
        , 0 // TemplateID#2291
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#2292
        , 0 // ApplSeqNum#2293
        , 1 // ApplSubID#2294
        , 2 // PartitionID#2295
        , 0 // ApplResendFlag#2296
        , 0 // ApplID#2297
        , 0 // LastFragment#2298
        ///
        , 0 // TransactTime#2299
        , 1 // TrdRegTSExecutionTime#2300
        , 1 // QuoteRefPrice#2301
        , 1 // UnderlyingDeltaPercentage#2302
        , 1 // BidPx#2303
        , 1 // OfferPx#2304
        , 1 // OrderQty#2305
        , 1 // LastPx#2306
        , 1 // LeavesQty#2307
        , 1 // LastQty#2308
        , 1 // EffectiveTime#2309
        , 1 // LastUpdateTime#2310
        , 1 // TradeToRequestRatio#2311
        , 0 // NegotiationID#2312
        , 1 // NumberOfRespondents#2313
        , 0 // QuoteType#2314
        , 0 // QuoteSubType#2315
        , 0 // NoTargetPartyIDs#2316
        , 0 // NumberOfRespDisclosureInstruction#2317
        , 1 // Side#2318
        , 0 // ShowLastDealOnClosure#2319
        , 1 // TradeAggregationTransType#2320
        , 0 // QuoteCondition#2321
        , 0 // PartyExecutingFirm#2322
        , 0 // PartyExecutingTrader#2323
        , 0 // PartyEnteringTrader#2324
        , 1 // FirmNegotiationID#2325
        , 1 // FreeText5#2326
        , 1 // PartyOrderOriginationTrader#2327
        //// TargetPartiesComp
        , 1 // TargetPartyIDExecutingTrader#2328
        , 0 // SideDisclosureInstruction#2329
        , 0 // PriceDisclosureInstruction#2330
        , 0 // LeavesQtyDisclosureInstruction#2331
        , 0 // LastPxDisclosureInstruction#2332
        , 0 // LastQtyDisclosureInstruction#2333
        , 0 // FreeText5DisclosureInstruction#2334
        , 0 // PartyOrderOriginationDisclosureInstruction#2335
        , 0 // QuoteInstruction#2336
        , 1 // TargetPartyExecutingFirm#2337
        , 1 // TargetPartyExecutingTrader#2338
        , 1 // PartyDetailStatus#2339
        , 1 // PartyDetailStatusInformation#2340
        ///
        // SRQSNegotiationStatusNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#2341
        , 0 // TemplateID#2342
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#2343
        , 0 // ApplSeqNum#2344
        , 1 // ApplSubID#2345
        , 2 // PartitionID#2346
        , 0 // ApplResendFlag#2347
        , 0 // ApplID#2348
        , 0 // LastFragment#2349
        ///
        , 0 // TransactTime#2350
        , 1 // EffectiveTime#2351
        , 0 // NegotiationID#2352
        , 0 // QuoteCondition#2353
        , 1 // FirmNegotiationID#2354
        // SRQSOpenNegotiationNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#2355
        , 0 // TemplateID#2356
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#2357
        , 0 // ApplSeqNum#2358
        , 1 // ApplSubID#2359
        , 2 // PartitionID#2360
        , 0 // ApplResendFlag#2361
        , 0 // ApplID#2362
        , 0 // LastFragment#2363
        ///
        , 0 // TransactTime#2364
        , 1 // NegotiationStartTime#2365
        , 1 // SecurityID#2366
        , 1 // BidPx#2367
        , 1 // OfferPx#2368
        , 1 // LeavesQty#2369
        , 1 // LastQty#2370
        , 1 // LastPx#2371
        , 1 // QuoteRefPrice#2372
        , 1 // UnderlyingDeltaPercentage#2373
        , 1 // ExpireTime#2374
        , 1 // TradeToRequestRatio#2375
        , 1 // TradeToQuoteRatio#2376
        , 0 // NegotiationID#2377
        , 0 // MarketSegmentID#2378
        , 1 // SecuritySubType#2379
        , 1 // NumberOfRespondents#2380
        , 1 // TradeToQuoteRatioPosition#2381
        , 0 // QuoteType#2382
        , 0 // QuoteSubType#2383
        , 0 // NoLegs#2384
        , 1 // Side#2385
        , 1 // ProductComplex#2386
        , 0 // RespondentType#2387
        , 1 // TradeAggregationTransType#2388
        , 0 // QuoteCondition#2389
        , 1 // PartyExecutingFirm#2390
        , 1 // PartyExecutingTrader#2391
        , 1 // PartyEnteringTrader#2392
        , 1 // TargetPartyExecutingFirm#2393
        , 1 // TargetPartyExecutingTrader#2394
        , 1 // FirmNegotiationID#2395
        , 1 // FreeText5#2396
        , 1 // PartyOrderOriginationTrader#2397
        //// QuotReqLegsGrpComp
        , 0 // LegSecurityID#2398
        , 1 // LegRatioQty#2399
        , 1 // LegSymbol#2400
        , 0 // LegSecurityType#2401
        , 1 // LegSide#2402
        ///
        // SRQSOpenNegotiationRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#2403
        , 0 // TemplateID#2404
        , 2 // NetworkMsgID#2405
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#2406
        , 0 // SenderSubID#2407
        ///
        , 1 // SecurityID#2408
        , 1 // BidPx#2409
        , 1 // OfferPx#2410
        , 1 // OrderQty#2411
        , 1 // QuoteRefPrice#2412
        , 1 // UnderlyingDeltaPercentage#2413
        , 1 // ValidUntilTime#2414
        , 0 // MarketSegmentID#2415
        , 1 // SecuritySubType#2416
        , 1 // QuoteType#2417
        , 1 // QuoteSubType#2418
        , 1 // NoLegs#2419
        , 0 // NoTargetPartyIDs#2420
        , 1 // NumberOfRespDisclosureInstruction#2421
        , 1 // Side#2422
        , 1 // ProductComplex#2423
        , 1 // RespondentType#2424
        , 1 // ShowLastDealOnClosure#2425
        , 1 // BidPxIsLocked#2426
        , 1 // OfferPxIsLocked#2427
        , 1 // SideIsLocked#2428
        , 1 // OrderQtyIsLocked#2429
        , 1 // TradeAggregationTransType#2430
        , 0 // QuoteCondition#2431
        , 0 // PartyExecutingFirm#2432
        , 0 // PartyExecutingTrader#2433
        , 1 // FreeText5#2434
        , 1 // QuoteReqID#2435
        , 1 // PartyOrderOriginationTrader#2436
        //// QuotReqLegsGrpComp
        , 0 // LegSecurityID#2437
        , 1 // LegRatioQty#2438
        , 1 // LegSymbol#2439
        , 0 // LegSecurityType#2440
        , 1 // LegSide#2441
        ///
        //// TargetPartiesComp
        , 2 // TargetPartyIDExecutingTrader#2442
        , 0 // SideDisclosureInstruction#2443
        , 0 // PriceDisclosureInstruction#2444
        , 0 // LeavesQtyDisclosureInstruction#2445
        , 2 // LastPxDisclosureInstruction#2446
        , 2 // LastQtyDisclosureInstruction#2447
        , 0 // FreeText5DisclosureInstruction#2448
        , 0 // PartyOrderOriginationDisclosureInstruction#2449
        , 2 // QuoteInstruction#2450
        , 0 // TargetPartyExecutingFirm#2451
        , 0 // TargetPartyExecutingTrader#2452
        , 2 // PartyDetailStatus#2453
        , 2 // PartyDetailStatusInformation#2454
        ///
        // SRQSOpenNegotiationRequesterNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#2455
        , 0 // TemplateID#2456
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#2457
        , 0 // ApplSeqNum#2458
        , 1 // ApplSubID#2459
        , 2 // PartitionID#2460
        , 0 // ApplResendFlag#2461
        , 0 // ApplID#2462
        , 0 // LastFragment#2463
        ///
        , 0 // TransactTime#2464
        , 1 // SecurityID#2465
        , 1 // BidPx#2466
        , 1 // OfferPx#2467
        , 1 // OrderQty#2468
        , 1 // LastPx#2469
        , 1 // LastQty#2470
        , 1 // QuoteRefPrice#2471
        , 1 // UnderlyingDeltaPercentage#2472
        , 1 // ExpireTime#2473
        , 1 // TradeToRequestRatio#2474
        , 0 // NegotiationID#2475
        , 0 // MarketSegmentID#2476
        , 1 // SecuritySubType#2477
        , 1 // NumberOfRespondents#2478
        , 0 // QuoteType#2479
        , 0 // QuoteSubType#2480
        , 0 // NoLegs#2481
        , 0 // NoTargetPartyIDs#2482
        , 1 // Side#2483
        , 1 // ProductComplex#2484
        , 0 // NumberOfRespDisclosureInstruction#2485
        , 0 // RespondentType#2486
        , 0 // ShowLastDealOnClosure#2487
        , 1 // BidPxIsLocked#2488
        , 1 // OfferPxIsLocked#2489
        , 1 // SideIsLocked#2490
        , 1 // OrderQtyIsLocked#2491
        , 1 // TradeAggregationTransType#2492
        , 0 // QuoteCondition#2493
        , 0 // PartyExecutingFirm#2494
        , 0 // PartyExecutingTrader#2495
        , 0 // PartyEnteringTrader#2496
        , 1 // FirmNegotiationID#2497
        , 1 // FreeText5#2498
        , 1 // PartyOrderOriginationTrader#2499
        //// QuotReqLegsGrpComp
        , 0 // LegSecurityID#2500
        , 1 // LegRatioQty#2501
        , 1 // LegSymbol#2502
        , 0 // LegSecurityType#2503
        , 1 // LegSide#2504
        ///
        //// TargetPartiesComp
        , 1 // TargetPartyIDExecutingTrader#2505
        , 0 // SideDisclosureInstruction#2506
        , 0 // PriceDisclosureInstruction#2507
        , 0 // LeavesQtyDisclosureInstruction#2508
        , 2 // LastPxDisclosureInstruction#2509
        , 2 // LastQtyDisclosureInstruction#2510
        , 0 // FreeText5DisclosureInstruction#2511
        , 0 // PartyOrderOriginationDisclosureInstruction#2512
        , 2 // QuoteInstruction#2513
        , 1 // TargetPartyExecutingFirm#2514
        , 1 // TargetPartyExecutingTrader#2515
        , 1 // PartyDetailStatus#2516
        , 1 // PartyDetailStatusInformation#2517
        ///
        // SRQSQuoteNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#2518
        , 0 // TemplateID#2519
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#2520
        , 0 // ApplSeqNum#2521
        , 1 // ApplSubID#2522
        , 2 // PartitionID#2523
        , 0 // ApplResendFlag#2524
        , 0 // ApplID#2525
        , 0 // LastFragment#2526
        ///
        , 0 // TransactTime#2527
        , 1 // QuoteID#2528
        , 1 // SecondaryQuoteID#2529
        , 1 // BidPx#2530
        , 1 // BidSize#2531
        , 1 // OfferPx#2532
        , 1 // OfferSize#2533
        , 1 // UnderlyingDeltaPercentage#2534
        , 1 // QuoteRefPrice#2535
        , 1 // ExpireTime#2536
        , 0 // NegotiationID#2537
        , 0 // QuotingStatus#2538
        , 1 // TradingCapacity#2539
        , 1 // QuoteCancelReason#2540
        , 1 // PartyIDExecutingTrader#2541
        , 1 // PartyExecutingFirm#2542
        , 1 // PartyExecutingTrader#2543
        , 1 // PartyEnteringTrader#2544
        , 1 // QuoteReqID#2545
        , 1 // FreeText1#2546
        , 1 // FreeText2#2547
        , 1 // FreeText3#2548
        , 1 // FreeText5#2549
        , 1 // PositionEffect#2550
        , 1 // Account#2551
        , 1 // PartyIDBeneficiary#2552
        , 1 // CustOrderHandlingInst#2553
        , 1 // PartyIDOrderOriginationFirm#2554
        , 1 // PartyIDPositionAccount#2555
        , 1 // PartyIDLocationID#2556
        , 1 // ComplianceText#2557
        , 1 // PartyIDTakeUpTradingFirm#2558
        // SRQSQuoteResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#2559
        , 0 // TemplateID#2560
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#2561
        , 0 // SendingTime#2562
        , 0 // MsgSeqNum#2563
        ///
        , 1 // QuoteID#2564
        , 0 // NegotiationID#2565
        , 1 // QuoteReqID#2566
        // SRQSQuotingStatusRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#2567
        , 0 // TemplateID#2568
        , 2 // NetworkMsgID#2569
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#2570
        , 0 // SenderSubID#2571
        ///
        , 0 // MarketSegmentID#2572
        , 0 // NegotiationID#2573
        , 1 // QuotingStatus#2574
        , 0 // PartyExecutingFirm#2575
        , 0 // PartyExecutingTrader#2576
        , 1 // FreeText5#2577
        // SRQSStatusBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#2578
        , 0 // TemplateID#2579
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#2580
        , 0 // ApplSeqNum#2581
        , 1 // ApplSubID#2582
        , 2 // PartitionID#2583
        , 0 // ApplResendFlag#2584
        , 0 // ApplID#2585
        , 0 // LastFragment#2586
        ///
        , 1 // TradeDate#2587
        , 0 // TradSesEvent#2588
        // SRQSUpdateDealStatusRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#2589
        , 0 // TemplateID#2590
        , 2 // NetworkMsgID#2591
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#2592
        , 0 // SenderSubID#2593
        ///
        , 1 // UnderlyingPriceStipValue#2594
        , 1 // UnderlyingPx#2595
        , 1 // LastQty#2596
        , 0 // MarketSegmentID#2597
        , 0 // NegotiationID#2598
        , 0 // TradeID#2599
        , 0 // TradeReportType#2600
        , 1 // TrdRptStatus#2601
        , 0 // PartyExecutingFirm#2602
        , 0 // PartyExecutingTrader#2603
        , 1 // FreeText5#2604
        // SRQSUpdateNegotiationRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#2605
        , 0 // TemplateID#2606
        , 2 // NetworkMsgID#2607
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#2608
        , 0 // SenderSubID#2609
        ///
        , 1 // QuoteRefPrice#2610
        , 1 // UnderlyingDeltaPercentage#2611
        , 1 // BidPx#2612
        , 1 // OfferPx#2613
        , 1 // OrderQty#2614
        , 0 // MarketSegmentID#2615
        , 0 // NegotiationID#2616
        , 0 // NoTargetPartyIDs#2617
        , 0 // NumberOfRespDisclosureInstruction#2618
        , 1 // Side#2619
        , 0 // ShowLastDealOnClosure#2620
        , 1 // QuoteType#2621
        , 1 // QuoteSubType#2622
        , 1 // RespondentType#2623
        , 1 // TradeAggregationTransType#2624
        , 0 // QuoteCondition#2625
        , 0 // PartyExecutingFirm#2626
        , 0 // PartyExecutingTrader#2627
        , 1 // FreeText5#2628
        , 1 // PartyOrderOriginationTrader#2629
        //// TargetPartiesComp
        , 1 // TargetPartyIDExecutingTrader#2630
        , 0 // SideDisclosureInstruction#2631
        , 0 // PriceDisclosureInstruction#2632
        , 0 // LeavesQtyDisclosureInstruction#2633
        , 0 // LastPxDisclosureInstruction#2634
        , 0 // LastQtyDisclosureInstruction#2635
        , 0 // FreeText5DisclosureInstruction#2636
        , 0 // PartyOrderOriginationDisclosureInstruction#2637
        , 0 // QuoteInstruction#2638
        , 1 // TargetPartyExecutingFirm#2639
        , 1 // TargetPartyExecutingTrader#2640
        , 2 // PartyDetailStatus#2641
        , 2 // PartyDetailStatusInformation#2642
        ///
        // ServiceAvailabilityBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#2643
        , 0 // TemplateID#2644
        ///
        //// NRBCHeaderComp
        , 0 // SendingTime#2645
        , 0 // ApplSubID#2646
        , 0 // ApplID#2647
        , 0 // LastFragment#2648
        ///
        , 1 // MatchingEngineTradeDate#2649
        , 1 // TradeManagerTradeDate#2650
        , 1 // ApplSeqTradeDate#2651
        , 1 // T7EntryServiceTradeDate#2652
        , 1 // T7EntryServiceRtmTradeDate#2653
        , 0 // PartitionID#2654
        , 0 // MatchingEngineStatus#2655
        , 0 // TradeManagerStatus#2656
        , 0 // ApplSeqStatus#2657
        , 0 // T7EntryServiceStatus#2658
        , 0 // T7EntryServiceRtmStatus#2659
        // ServiceAvailabilityMarketBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#2660
        , 0 // TemplateID#2661
        ///
        //// NRBCHeaderComp
        , 0 // SendingTime#2662
        , 0 // ApplSubID#2663
        , 0 // ApplID#2664
        , 0 // LastFragment#2665
        ///
        , 1 // SelectiveRequestForQuoteServiceTradeDate#2666
        , 0 // SelectiveRequestForQuoteServiceStatus#2667
        , 0 // SelectiveRequestForQuoteRtmServiceStatus#2668
        // SubscribeRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#2669
        , 0 // TemplateID#2670
        , 2 // NetworkMsgID#2671
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#2672
        , 2 // SenderSubID#2673
        ///
        , 1 // SubscriptionScope#2674
        , 0 // RefApplID#2675
        // SubscribeResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#2676
        , 0 // TemplateID#2677
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#2678
        , 0 // SendingTime#2679
        , 0 // MsgSeqNum#2680
        ///
        , 0 // ApplSubID#2681
        // TESApproveBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#2682
        , 0 // TemplateID#2683
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#2684
        , 0 // ApplSeqNum#2685
        , 1 // ApplSubID#2686
        , 0 // PartitionID#2687
        , 0 // ApplResendFlag#2688
        , 0 // ApplID#2689
        , 0 // LastFragment#2690
        ///
        , 0 // SecurityID#2691
        , 0 // LastPx#2692
        , 0 // AllocQty#2693
        , 0 // TransactTime#2694
        , 1 // UnderlyingPx#2695
        , 1 // TransBkdTime#2696
        , 1 // RelatedClosePrice#2697
        , 1 // RelatedTradeQuantity#2698
        , 1 // UnderlyingQty#2699
        , 1 // CompressionID#2700
        , 0 // MarketSegmentID#2701
        , 0 // PackageID#2702
        , 0 // TESExecID#2703
        , 0 // AllocID#2704
        , 1 // UnderlyingSettlementDate#2705
        , 1 // UnderlyingMaturityDate#2706
        , 1 // RelatedTradeID#2707
        , 1 // RelatedMarketSegmentID#2708
        , 1 // NegotiationID#2709
        , 1 // TESEnrichmentRuleID#2710
        , 1 // AutoApprovalRuleID#2711
        , 0 // TrdType#2712
        , 1 // VarTextLen#2713
        , 0 // Side#2714
        , 0 // TradePublishIndicator#2715
        , 1 // ProductComplex#2716
        , 0 // TradeReportType#2717
        , 1 // TrdRptStatus#2718
        , 0 // TradingCapacity#2719
        , 1 // PartyIDSettlementLocation#2720
        , 0 // TradeAllocStatus#2721
        , 1 // HedgeType#2722
        , 0 // NoLegs#2723
        , 0 // NoEvents#2724
        , 0 // NoInstrAttrib#2725
        , 0 // NoUnderlyingStips#2726
        , 0 // MessageEventSource#2727
        , 1 // TradeReportID#2728
        , 0 // PartyExecutingFirm#2729
        , 0 // PartyExecutingTrader#2730
        , 0 // PartyIDEnteringFirm#2731
        , 0 // PartyEnteringTrader#2732
        , 0 // PositionEffect#2733
        , 1 // RootPartyExecutingFirm#2734
        , 1 // RootPartyExecutingTrader#2735
        , 1 // FreeText1#2736
        , 1 // FreeText2#2737
        , 1 // FreeText3#2738
        , 1 // PartyIDTakeUpTradingFirm#2739
        , 1 // Account#2740
        , 1 // PartyIDPositionAccount#2741
        , 1 // PartyIDOrderOriginationFirm#2742
        , 1 // PartyIDBeneficiary#2743
        , 1 // PartyIDLocationID#2744
        , 1 // CustOrderHandlingInst#2745
        , 1 // ComplianceText#2746
        , 1 // UnderlyingSecurityID#2747
        , 1 // UnderlyingSecurityDesc#2748
        , 1 // UnderlyingCurrency#2749
        , 1 // UnderlyingIssuer#2750
        //// TrdInstrmntLegGrpComp
        , 0 // LegSecurityID#2751
        , 0 // LegPrice#2752
        , 2 // LegQty#2753
        ///
        //// InstrumentEventGrpComp
        , 0 // EventDate#2754
        , 0 // EventType#2755
        ///
        //// InstrumentAttributeGrpComp
        , 0 // InstrAttribType#2756
        , 0 // InstrAttribValue#2757
        ///
        //// UnderlyingStipGrpComp
        , 0 // UnderlyingStipValue#2758
        , 0 // UnderlyingStipType#2759
        ///
        , 1 // VarText#2760
        // TESBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#2761
        , 0 // TemplateID#2762
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#2763
        , 0 // ApplSeqNum#2764
        , 1 // ApplSubID#2765
        , 0 // PartitionID#2766
        , 0 // ApplResendFlag#2767
        , 0 // ApplID#2768
        , 0 // LastFragment#2769
        ///
        , 0 // SecurityID#2770
        , 0 // LastPx#2771
        , 0 // TransactTime#2772
        , 1 // UnderlyingPx#2773
        , 1 // TransBkdTime#2774
        , 1 // RelatedClosePrice#2775
        , 1 // RelatedTradeQuantity#2776
        , 1 // UnderlyingQty#2777
        , 1 // CompressionID#2778
        , 0 // MarketSegmentID#2779
        , 0 // PackageID#2780
        , 0 // TESExecID#2781
        , 1 // UnderlyingSettlementDate#2782
        , 1 // UnderlyingMaturityDate#2783
        , 1 // RelatedTradeID#2784
        , 1 // RelatedMarketSegmentID#2785
        , 1 // AutoApprovalRuleID#2786
        , 0 // TrdType#2787
        , 1 // VarTextLen#2788
        , 0 // TradeReportType#2789
        , 1 // TrdRptStatus#2790
        , 1 // ProductComplex#2791
        , 0 // TradePublishIndicator#2792
        , 0 // NoEvents#2793
        , 0 // NoInstrAttrib#2794
        , 0 // NoUnderlyingStips#2795
        , 0 // NoSideAllocs#2796
        , 0 // NoLegs#2797
        , 1 // PartyIDSettlementLocation#2798
        , 1 // HedgeType#2799
        , 1 // SwapClearer#2800
        , 0 // MessageEventSource#2801
        , 1 // TradeReportText#2802
        , 1 // TradeReportID#2803
        , 0 // RootPartyExecutingFirm#2804
        , 0 // RootPartyExecutingTrader#2805
        , 1 // UnderlyingSecurityID#2806
        , 1 // UnderlyingSecurityDesc#2807
        , 1 // UnderlyingCurrency#2808
        , 1 // UnderlyingIssuer#2809
        //// SideAllocGrpBCComp
        , 0 // AllocQty#2810
        , 2 // ReversalApprovalTime#2811
        , 0 // IndividualAllocID#2812
        , 1 // TESEnrichmentRuleID#2813
        , 0 // PartyExecutingFirm#2814
        , 0 // PartyExecutingTrader#2815
        , 0 // Side#2816
        , 0 // TradeAllocStatus#2817
        ///
        //// TrdInstrmntLegGrpComp
        , 0 // LegSecurityID#2818
        , 0 // LegPrice#2819
        , 1 // LegQty#2820
        ///
        //// InstrumentEventGrpComp
        , 0 // EventDate#2821
        , 0 // EventType#2822
        ///
        //// InstrumentAttributeGrpComp
        , 0 // InstrAttribType#2823
        , 0 // InstrAttribValue#2824
        ///
        //// UnderlyingStipGrpComp
        , 0 // UnderlyingStipValue#2825
        , 0 // UnderlyingStipType#2826
        ///
        , 1 // VarText#2827
        // TESCompressionRunStatusBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#2828
        , 0 // TemplateID#2829
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#2830
        , 0 // ApplSeqNum#2831
        , 1 // ApplSubID#2832
        , 0 // PartitionID#2833
        , 0 // ApplResendFlag#2834
        , 0 // ApplID#2835
        , 0 // LastFragment#2836
        ///
        , 1 // CompressionID#2837
        , 1 // MarketSegmentID#2838
        , 1 // CompressionAction#2839
        , 1 // CompressionStatus#2840
        , 1 // TradePublishIndicator#2841
        // TESCompressionRunStatusRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#2842
        , 0 // TemplateID#2843
        , 2 // NetworkMsgID#2844
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#2845
        , 0 // SenderSubID#2846
        ///
        , 1 // CompressionID#2847
        , 0 // MarketSegmentID#2848
        , 0 // CompressionAction#2849
        , 1 // TradePublishIndicator#2850
        // TESCompressionRunStatusResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#2851
        , 0 // TemplateID#2852
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#2853
        , 0 // SendingTime#2854
        , 0 // MsgSeqNum#2855
        ///
        , 1 // CompressionID#2856
        , 1 // MarketSegmentID#2857
        , 1 // CompressionAction#2858
        , 1 // CompressionStatus#2859
        , 1 // TradePublishIndicator#2860
        // TESDeleteBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#2861
        , 0 // TemplateID#2862
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#2863
        , 0 // ApplSeqNum#2864
        , 1 // ApplSubID#2865
        , 0 // PartitionID#2866
        , 0 // ApplResendFlag#2867
        , 0 // ApplID#2868
        , 0 // LastFragment#2869
        ///
        , 0 // TransactTime#2870
        , 1 // CompressionID#2871
        , 0 // MarketSegmentID#2872
        , 0 // PackageID#2873
        , 0 // TESExecID#2874
        , 0 // TrdType#2875
        , 0 // DeleteReason#2876
        , 0 // TradeReportType#2877
        , 1 // TrdRptStatus#2878
        , 0 // MessageEventSource#2879
        , 1 // TradeReportID#2880
        // TESExecutionBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#2881
        , 0 // TemplateID#2882
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#2883
        , 0 // ApplSeqNum#2884
        , 1 // ApplSubID#2885
        , 0 // PartitionID#2886
        , 0 // ApplResendFlag#2887
        , 0 // ApplID#2888
        , 0 // LastFragment#2889
        ///
        , 0 // TransactTime#2890
        , 1 // CompressionID#2891
        , 0 // MarketSegmentID#2892
        , 0 // PackageID#2893
        , 0 // TESExecID#2894
        , 0 // AllocID#2895
        , 0 // TrdType#2896
        , 0 // TradeReportType#2897
        , 0 // Side#2898
        , 1 // TrdRptStatus#2899
        , 0 // MessageEventSource#2900
        // TESResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#2901
        , 0 // TemplateID#2902
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#2903
        , 0 // SendingTime#2904
        , 0 // MsgSeqNum#2905
        ///
        , 0 // TESExecID#2906
        , 0 // TradeReportID#2907
        // TESReversalBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#2908
        , 0 // TemplateID#2909
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#2910
        , 0 // ApplSeqNum#2911
        , 1 // ApplSubID#2912
        , 0 // PartitionID#2913
        , 0 // ApplResendFlag#2914
        , 0 // ApplID#2915
        , 0 // LastFragment#2916
        ///
        , 1 // ReversalInitiationTime#2917
        , 0 // MarketSegmentID#2918
        , 0 // PackageID#2919
        , 0 // TESExecID#2920
        , 1 // RelatedMarketSegmentID#2921
        , 0 // TrdType#2922
        , 1 // TrdRptStatus#2923
        , 1 // ReversalCancellationReason#2924
        , 0 // NoSideAllocs#2925
        , 1 // TradeReportID#2926
        , 1 // ReversalReasonText#2927
        //// SideAllocGrpBCComp
        , 2 // AllocQty#2928
        , 1 // ReversalApprovalTime#2929
        , 0 // IndividualAllocID#2930
        , 2 // TESEnrichmentRuleID#2931
        , 2 // PartyExecutingFirm#2932
        , 2 // PartyExecutingTrader#2933
        , 2 // Side#2934
        , 0 // TradeAllocStatus#2935
        ///
        // TESTradeBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#2936
        , 0 // TemplateID#2937
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#2938
        , 0 // ApplSeqNum#2939
        , 1 // ApplSubID#2940
        , 0 // PartitionID#2941
        , 0 // ApplResendFlag#2942
        , 0 // ApplID#2943
        , 0 // LastFragment#2944
        ///
        , 0 // SecurityID#2945
        , 0 // LastPx#2946
        , 0 // LastQty#2947
        , 1 // ClearingTradePrice#2948
        , 1 // ClearingTradeQty#2949
        , 0 // TransactTime#2950
        , 1 // RelatedSecurityID#2951
        , 1 // CompressionID#2952
        , 1 // RootPartyIDClientID#2953
        , 1 // ExecutingTrader#2954
        , 1 // RootPartyIDInvestmentDecisionMaker#2955
        , 1 // BasketTrdMatchID#2956
        , 1 // SideLastPx#2957
        , 1 // SideLastQty#2958
        , 0 // PackageID#2959
        , 0 // MarketSegmentID#2960
        , 0 // TradeID#2961
        , 0 // TradeDate#2962
        , 0 // SideTradeID#2963
        , 1 // RootPartyIDSessionID#2964
        , 1 // OrigTradeID#2965
        , 0 // RootPartyIDExecutingUnit#2966
        , 0 // RootPartyIDExecutingTrader#2967
        , 0 // RootPartyIDClearingUnit#2968
        , 1 // StrategyLinkID#2969
        , 1 // RelatedSymbol#2970
        , 1 // TotNumTradeReports#2971
        , 1 // NegotiationID#2972
        , 1 // NoSRQSRelatedTradeIDs#2973
        , 1 // BasketProfileID#2974
        , 1 // TrdType#2975
        , 1 // ProductComplex#2976
        , 1 // RelatedProductComplex#2977
        , 0 // Side#2978
        , 1 // TradingCapacity#2979
        , 0 // TradeReportType#2980
        , 0 // TransferReason#2981
        , 0 // TradePublishIndicator#2982
        , 1 // MultiLegReportingType#2983
        , 1 // PositionEffect#2984
        , 1 // MultilegPriceModel#2985
        , 1 // OrderAttributeLiquidityProvision#2986
        , 1 // OrderAttributeRiskReduction#2987
        , 1 // ExecutingTraderQualifier#2988
        , 1 // RootPartyIDInvestmentDecisionMakerQualifier#2989
        , 1 // OrderOrigination#2990
        , 1 // ReversalIndicator#2991
        , 1 // TradeAggregationTransType#2992
        , 1 // Account#2993
        , 1 // RootPartyIDPositionAccount#2994
        , 1 // CustOrderHandlingInst#2995
        , 1 // FreeText1#2996
        , 1 // FreeText2#2997
        , 1 // FreeText3#2998
        , 0 // RootPartyExecutingFirm#2999
        , 0 // RootPartyExecutingTrader#3000
        , 0 // RootPartyClearingFirm#3001
        , 0 // RootPartyClearingOrganization#3002
        , 1 // RootPartyIDBeneficiary#3003
        , 1 // RootPartyIDTakeUpTradingFirm#3004
        , 1 // RootPartyIDOrderOriginationFirm#3005
        , 1 // RootPartyIDExecutionVenue#3006
        , 1 // RegulatoryTradeID#3007
        , 1 // BasketPartyContraFirm#3008
        , 1 // BasketSideTradeReportID#3009
        //// SRQSRelatedTradeIDGrpComp
        , 0 // SRQSRelatedTradeID#3010
        ///
        // TESTradingSessionStatusBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#3011
        , 0 // TemplateID#3012
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#3013
        , 0 // ApplSeqNum#3014
        , 1 // ApplSubID#3015
        , 0 // PartitionID#3016
        , 0 // ApplResendFlag#3017
        , 0 // ApplID#3018
        , 0 // LastFragment#3019
        ///
        , 0 // TradeDate#3020
        , 0 // TradSesEvent#3021
        // TESUploadBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#3022
        , 0 // TemplateID#3023
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#3024
        , 0 // ApplSeqNum#3025
        , 1 // ApplSubID#3026
        , 0 // PartitionID#3027
        , 0 // ApplResendFlag#3028
        , 0 // ApplID#3029
        , 0 // LastFragment#3030
        ///
        , 0 // SecurityID#3031
        , 0 // LastPx#3032
        , 1 // TransBkdTime#3033
        , 0 // TransactTime#3034
        , 1 // UnderlyingPx#3035
        , 1 // RelatedClosePrice#3036
        , 1 // RelatedTradeQuantity#3037
        , 1 // UnderlyingQty#3038
        , 1 // CompressionID#3039
        , 0 // MarketSegmentID#3040
        , 0 // PackageID#3041
        , 0 // TESExecID#3042
        , 1 // UnderlyingSettlementDate#3043
        , 1 // UnderlyingMaturityDate#3044
        , 1 // RelatedTradeID#3045
        , 1 // RelatedMarketSegmentID#3046
        , 0 // TrdType#3047
        , 1 // ProductComplex#3048
        , 0 // TradeReportType#3049
        , 1 // TrdRptStatus#3050
        , 0 // TradePublishIndicator#3051
        , 0 // TradePlatform#3052
        , 0 // NoSideAllocs#3053
        , 0 // NoLegs#3054
        , 0 // NoEvents#3055
        , 0 // NoInstrAttrib#3056
        , 0 // NoUnderlyingStips#3057
        , 1 // HedgeType#3058
        , 1 // PartyIDSettlementLocation#3059
        , 0 // MessageEventSource#3060
        , 1 // TradeReportID#3061
        , 1 // RootPartyExecutingFirm#3062
        , 1 // RootPartyExecutingTrader#3063
        , 1 // UnderlyingSecurityID#3064
        , 1 // UnderlyingSecurityDesc#3065
        , 1 // UnderlyingCurrency#3066
        , 1 // UnderlyingIssuer#3067
        //// SideAllocExtGrpComp
        , 0 // AllocQty#3068
        , 1 // PartyIDClientID#3069
        , 1 // PartyIdInvestmentDecisionMaker#3070
        , 1 // ExecutingTrader#3071
        , 0 // IndividualAllocID#3072
        , 0 // PartyExecutingFirm#3073
        , 0 // PartyExecutingTrader#3074
        , 1 // TESEnrichmentRuleID#3075
        , 0 // Side#3076
        , 0 // TradeAllocStatus#3077
        , 0 // TradingCapacity#3078
        , 0 // PositionEffect#3079
        , 1 // OrderAttributeLiquidityProvision#3080
        , 1 // ExecutingTraderQualifier#3081
        , 1 // PartyIdInvestmentDecisionMakerQualifier#3082
        , 1 // OrderAttributeRiskReduction#3083
        , 1 // OrderOrigination#3084
        , 1 // Account#3085
        , 1 // PartyIDPositionAccount#3086
        , 1 // PartyIDTakeUpTradingFirm#3087
        , 1 // FreeText1#3088
        , 1 // FreeText2#3089
        , 1 // FreeText3#3090
        , 1 // PartyIDOrderOriginationFirm#3091
        , 1 // PartyIDBeneficiary#3092
        , 1 // PartyIDLocationID#3093
        , 1 // CustOrderHandlingInst#3094
        , 1 // ComplianceText#3095
        ///
        //// TrdInstrmntLegGrpComp
        , 0 // LegSecurityID#3096
        , 0 // LegPrice#3097
        , 1 // LegQty#3098
        ///
        //// InstrumentEventGrpComp
        , 0 // EventDate#3099
        , 0 // EventType#3100
        ///
        //// InstrumentAttributeGrpComp
        , 0 // InstrAttribType#3101
        , 0 // InstrAttribValue#3102
        ///
        //// UnderlyingStipGrpComp
        , 0 // UnderlyingStipValue#3103
        , 0 // UnderlyingStipType#3104
        ///
        // TMTradingSessionStatusBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#3105
        , 0 // TemplateID#3106
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#3107
        , 0 // ApplSeqNum#3108
        , 1 // ApplSubID#3109
        , 0 // PartitionID#3110
        , 0 // ApplResendFlag#3111
        , 0 // ApplID#3112
        , 0 // LastFragment#3113
        ///
        , 0 // TradSesEvent#3114
        // ThrottleUpdateNotification
        //// MessageHeaderOutComp
        , 0 // BodyLen#3115
        , 0 // TemplateID#3116
        ///
        //// NotifHeaderComp
        , 0 // SendingTime#3117
        ///
        , 0 // ThrottleTimeInterval#3118
        , 0 // ThrottleNoMsgs#3119
        , 0 // ThrottleDisconnectLimit#3120
        // TradeBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#3121
        , 0 // TemplateID#3122
        ///
        //// RBCHeaderComp
        , 0 // SendingTime#3123
        , 0 // ApplSeqNum#3124
        , 1 // ApplSubID#3125
        , 0 // PartitionID#3126
        , 0 // ApplResendFlag#3127
        , 0 // ApplID#3128
        , 0 // LastFragment#3129
        ///
        , 0 // SecurityID#3130
        , 1 // RelatedSecurityID#3131
        , 1 // Price#3132
        , 0 // LastPx#3133
        , 0 // LastQty#3134
        , 1 // SideLastPx#3135
        , 1 // SideLastQty#3136
        , 1 // ClearingTradePrice#3137
        , 1 // ClearingTradeQty#3138
        , 0 // TransactTime#3139
        , 1 // OrderID#3140
        , 1 // ClOrdID#3141
        , 1 // LeavesQty#3142
        , 1 // CumQty#3143
        , 1 // RootPartyIDClientID#3144
        , 1 // ExecutingTrader#3145
        , 1 // RootPartyIDInvestmentDecisionMaker#3146
        , 0 // TradeID#3147
        , 1 // OrigTradeID#3148
        , 0 // RootPartyIDExecutingUnit#3149
        , 1 // RootPartyIDSessionID#3150
        , 1 // RootPartyIDExecutingTrader#3151
        , 0 // RootPartyIDClearingUnit#3152
        , 0 // MarketSegmentID#3153
        , 1 // RelatedSymbol#3154
        , 0 // SideTradeID#3155
        , 0 // MatchDate#3156
        , 0 // TrdMatchID#3157
        , 1 // StrategyLinkID#3158
        , 1 // TotNumTradeReports#3159
        , 1 // MultiLegReportingType#3160
        , 0 // TradeReportType#3161
        , 0 // TransferReason#3162
        , 1 // RootPartyIDBeneficiary#3163
        , 1 // RootPartyIDTakeUpTradingFirm#3164
        , 1 // RootPartyIDOrderOriginationFirm#3165
        , 1 // MatchType#3166
        , 1 // MatchSubType#3167
        , 0 // Side#3168
        , 1 // SideLiquidityInd#3169
        , 0 // TradingCapacity#3170
        , 1 // OrderOrigination#3171
        , 1 // OrderAttributeLiquidityProvision#3172
        , 1 // OrderAttributeRiskReduction#3173
        , 1 // ExecutingTraderQualifier#3174
        , 1 // RootPartyIDInvestmentDecisionMakerQualifier#3175
        , 1 // Account#3176
        , 1 // RootPartyIDPositionAccount#3177
        , 1 // PositionEffect#3178
        , 1 // CustOrderHandlingInst#3179
        , 1 // FreeText1#3180
        , 1 // FreeText2#3181
        , 1 // FreeText3#3182
        , 1 // OrderCategory#3183
        , 1 // OrdType#3184
        , 1 // RelatedProductComplex#3185
        , 1 // OrderSide#3186
        , 0 // RootPartyClearingOrganization#3187
        , 0 // RootPartyExecutingFirm#3188
        , 1 // RootPartyExecutingTrader#3189
        , 0 // RootPartyClearingFirm#3190
        , 1 // RegulatoryTradeID#3191
        , 1 // RootPartyIDExecutionVenue#3192
        // TradingSessionStatusBroadcast
        //// MessageHeaderOutComp
        , 0 // BodyLen#3193
        , 0 // TemplateID#3194
        ///
        //// RBCHeaderMEComp
        , 1 // TrdRegTSTimeOut#3195
        , 1 // NotificationIn#3196
        , 0 // SendingTime#3197
        , 1 // ApplSubID#3198
        , 0 // PartitionID#3199
        , 0 // ApplMsgID#3200
        , 0 // ApplID#3201
        , 0 // ApplResendFlag#3202
        , 0 // LastFragment#3203
        ///
        , 1 // MarketSegmentID#3204
        , 1 // TradeDate#3205
        , 0 // TradSesEvent#3206
        , 1 // RefApplLastMsgID#3207
        // UnsubscribeRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#3208
        , 0 // TemplateID#3209
        , 2 // NetworkMsgID#3210
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#3211
        , 2 // SenderSubID#3212
        ///
        , 0 // RefApplSubID#3213
        // UnsubscribeResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#3214
        , 0 // TemplateID#3215
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#3216
        , 0 // SendingTime#3217
        , 0 // MsgSeqNum#3218
        ///
        // UploadTESTradeRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#3219
        , 0 // TemplateID#3220
        , 2 // NetworkMsgID#3221
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#3222
        , 0 // SenderSubID#3223
        ///
        , 0 // SecurityID#3224
        , 0 // LastPx#3225
        , 1 // TransBkdTime#3226
        , 1 // UnderlyingPx#3227
        , 1 // RelatedClosePrice#3228
        , 1 // RelatedTradeQuantity#3229
        , 1 // UnderlyingQty#3230
        , 1 // CompressionID#3231
        , 0 // MarketSegmentID#3232
        , 1 // UnderlyingSettlementDate#3233
        , 1 // UnderlyingMaturityDate#3234
        , 1 // RelatedTradeID#3235
        , 1 // RelatedMarketSegmentID#3236
        , 0 // TrdType#3237
        , 1 // ProductComplex#3238
        , 0 // TradeReportType#3239
        , 0 // TradePublishIndicator#3240
        , 0 // NoSideAllocs#3241
        , 0 // NoLegs#3242
        , 0 // NoEvents#3243
        , 0 // NoInstrAttrib#3244
        , 0 // NoUnderlyingStips#3245
        , 0 // SkipValidations#3246
        , 1 // TrdRptStatus#3247
        , 1 // TradePlatform#3248
        , 1 // HedgeType#3249
        , 1 // PartyIDSettlementLocation#3250
        , 1 // ValueCheckTypeMinLotSize#3251
        , 1 // TradeReportID#3252
        , 1 // TradeReportText#3253
        , 1 // UnderlyingSecurityID#3254
        , 1 // UnderlyingSecurityDesc#3255
        , 1 // UnderlyingCurrency#3256
        , 1 // UnderlyingIssuer#3257
        //// SideAllocExtGrpComp
        , 0 // AllocQty#3258
        , 1 // PartyIDClientID#3259
        , 1 // PartyIdInvestmentDecisionMaker#3260
        , 1 // ExecutingTrader#3261
        , 2 // IndividualAllocID#3262
        , 0 // PartyExecutingFirm#3263
        , 0 // PartyExecutingTrader#3264
        , 1 // TESEnrichmentRuleID#3265
        , 0 // Side#3266
        , 2 // TradeAllocStatus#3267
        , 1 // TradingCapacity#3268
        , 1 // PositionEffect#3269
        , 1 // OrderAttributeLiquidityProvision#3270
        , 1 // ExecutingTraderQualifier#3271
        , 1 // PartyIdInvestmentDecisionMakerQualifier#3272
        , 1 // OrderAttributeRiskReduction#3273
        , 1 // OrderOrigination#3274
        , 1 // Account#3275
        , 1 // PartyIDPositionAccount#3276
        , 1 // PartyIDTakeUpTradingFirm#3277
        , 1 // FreeText1#3278
        , 1 // FreeText2#3279
        , 1 // FreeText3#3280
        , 1 // PartyIDOrderOriginationFirm#3281
        , 1 // PartyIDBeneficiary#3282
        , 1 // PartyIDLocationID#3283
        , 1 // CustOrderHandlingInst#3284
        , 1 // ComplianceText#3285
        ///
        //// TrdInstrmntLegGrpComp
        , 0 // LegSecurityID#3286
        , 0 // LegPrice#3287
        , 2 // LegQty#3288
        ///
        //// InstrumentEventGrpComp
        , 0 // EventDate#3289
        , 0 // EventType#3290
        ///
        //// InstrumentAttributeGrpComp
        , 0 // InstrAttribType#3291
        , 0 // InstrAttribValue#3292
        ///
        //// UnderlyingStipGrpComp
        , 0 // UnderlyingStipValue#3293
        , 0 // UnderlyingStipType#3294
        ///
        // UserLoginRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#3295
        , 0 // TemplateID#3296
        , 2 // NetworkMsgID#3297
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#3298
        , 2 // SenderSubID#3299
        ///
        , 0 // Username#3300
        , 0 // Password#3301
        // UserLoginResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#3302
        , 0 // TemplateID#3303
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#3304
        , 0 // SendingTime#3305
        , 0 // MsgSeqNum#3306
        ///
        // UserLogoutRequest
        //// MessageHeaderInComp
        , 0 // BodyLen#3307
        , 0 // TemplateID#3308
        , 2 // NetworkMsgID#3309
        ///
        //// RequestHeaderComp
        , 0 // MsgSeqNum#3310
        , 2 // SenderSubID#3311
        ///
        , 0 // Username#3312
        // UserLogoutResponse
        //// MessageHeaderOutComp
        , 0 // BodyLen#3313
        , 0 // TemplateID#3314
        ///
        //// ResponseHeaderComp
        , 0 // RequestTime#3315
        , 0 // SendingTime#3316
        , 0 // MsgSeqNum#3317
        ///
        , 0 // filler
    };
    static const int16_t tid2uidx[] = {
        1002 /* LogonRequest */
        , 1020 /* LogonResponse */
        , 1034 /* LogoutRequest */
        , 1039 /* LogoutResponse */
        , -1
        , 2676 /* SubscribeResponse */
        , 3208 /* UnsubscribeRequest */
        , 3214 /* UnsubscribeResponse */
        , 1990 /* RetransmitRequest */
        , 1999 /* RetransmitResponse */
        , 1959 /* Reject */
        , 894 /* Heartbeat */
        , 882 /* ForcedLogoutNotification */
        , -1
        , -1
        , -1
        , -1
        , -1
        , 3295 /* UserLoginRequest */
        , 3302 /* UserLoginResponse */
        , -1
        , -1
        , -1
        , 897 /* HeartbeatNotification */
        , 3313 /* UserLogoutResponse */
        , 2669 /* SubscribeRequest */
        , 1972 /* RetransmitMEMessageRequest */
        , 1982 /* RetransmitMEMessageResponse */
        , 3115 /* ThrottleUpdateNotification */
        , 3307 /* UserLogoutRequest */
        , 2643 /* ServiceAvailabilityBroadcast */
        , 1587 /* NewsBroadcast */
        , 367 /* BroadcastErrorNotification */
        , 2019 /* RiskNotificationBroadcast */
        , 1792 /* PartyEntitlementsUpdateReport */
        , 957 /* InquireSessionListRequest */
        , 962 /* InquireSessionListResponse */
        , 989 /* LegalNotificationBroadcast */
        , 971 /* InquireUserRequest */
        , 977 /* InquireUserResponse */
        , 900 /* InquireEnrichmentRuleIDListRequest */
        , 906 /* InquireEnrichmentRuleIDListResponse */
        , 1774 /* PartyActionReport */
        , 887 /* ForcedUserLogoutNotification */
        , 2660 /* ServiceAvailabilityMarketBroadcast */
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , 1518 /* NewOrderSingleRequest */
        , 1486 /* NewOrderResponse */
        , 1459 /* NewOrderNRResponse */
        , 1725 /* OrderExecResponse */
        , 1600 /* OrderExecNotification */
        , -1
        , 1286 /* ModifyOrderSingleRequest */
        , 1253 /* ModifyOrderResponse */
        , 1224 /* ModifyOrderNRResponse */
        , 717 /* DeleteOrderSingleRequest */
        , 693 /* DeleteOrderResponse */
        , 672 /* DeleteOrderNRResponse */
        , 626 /* DeleteOrderBroadcast */
        , 1388 /* NewOrderComplexRequest */
        , 1149 /* ModifyOrderComplexRequest */
        , -1
        , -1
        , 1646 /* OrderExecReportBroadcast */
        , 451 /* CrossRequest */
        , 460 /* CrossRequestResponse */
        , 523 /* DeleteAllOrderRequest */
        , 539 /* DeleteAllOrderResponse */
        , 470 /* DeleteAllOrderBroadcast */
        , 654 /* DeleteOrderComplexRequest */
        , 497 /* DeleteAllOrderNRResponse */
        , 1561 /* NewOrderSingleShortRequest */
        , 1332 /* ModifyOrderSingleShortRequest */
        , -1
        , -1
        , 1431 /* NewOrderComplexShortRequest */
        , 1195 /* ModifyOrderComplexShortRequest */
        , 788 /* EnterCLIPRequest */
        , 613 /* DeleteCLIPRequest */
        , 434 /* CLIPResponse */
        , 376 /* CLIPDeletionNotification */
        , 397 /* CLIPExecutionNotification */
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , 0 /* AddComplexInstrumentRequest */
        , 16 /* AddComplexInstrumentResponse */
        , 1044 /* MMParameterDefinitionRequest */
        , 1056 /* MMParameterDefinitionResponse */
        , 923 /* InquireMMParameterRequest */
        , 930 /* InquireMMParameterResponse */
        , 3193 /* TradingSessionStatusBroadcast */
        , 507 /* DeleteAllOrderQuoteEventBroadcast */
        , 43 /* AddFlexibleInstrumentRequest */
        , 57 /* AddFlexibleInstrumentResponse */
        , 948 /* InquirePreTradeRiskLimitsRequest */
        , 1849 /* PreTradeRiskLimitsDefinitionRequest */
        , 1826 /* PreTradeRiskLimitResponse */
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , 1810 /* PingRequest */
        , 1816 /* PingResponse */
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , 1939 /* RFQRequest */
        , 1949 /* RFQResponse */
        , 1883 /* QuoteActivationRequest */
        , 1896 /* QuoteActivationResponse */
        , 1066 /* MassQuoteRequest */
        , 1090 /* MassQuoteResponse */
        , 1908 /* QuoteExecutionReport */
        , 579 /* DeleteAllQuoteRequest */
        , 590 /* DeleteAllQuoteResponse */
        , 557 /* DeleteAllQuoteBroadcast */
        , 1863 /* QuoteActivationNotification */
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , 3121 /* TradeBroadcast */
        , 3105 /* TMTradingSessionStatusBroadcast */
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , 831 /* EnterTESTradeRequest */
        , 1359 /* ModifyTESTradeRequest */
        , 735 /* DeleteTESTradeRequest */
        , 174 /* ApproveTESTradeRequest */
        , 2761 /* TESBroadcast */
        , -1
        , 2861 /* TESDeleteBroadcast */
        , 2682 /* TESApproveBroadcast */
        , -1
        , -1
        , 2881 /* TESExecutionBroadcast */
        , 2901 /* TESResponse */
        , 3219 /* UploadTESTradeRequest */
        , 3022 /* TESUploadBroadcast */
        , 2936 /* TESTradeBroadcast */
        , 3011 /* TESTradingSessionStatusBroadcast */
        , 2842 /* TESCompressionRunStatusRequest */
        , 2851 /* TESCompressionRunStatusResponse */
        , 2828 /* TESCompressionRunStatusBroadcast */
        , -1
        , 748 /* EnterBasketTradeRequest */
        , 1108 /* ModifyBasketTradeRequest */
        , 602 /* DeleteBasketTradeRequest */
        , 119 /* ApproveBasketTradeRequest */
        , 360 /* BasketResponse */
        , 271 /* BasketBroadcast */
        , 319 /* BasketDeleteBroadcast */
        , 213 /* BasketApproveBroadcast */
        , 337 /* BasketExecutionBroadcast */
        , 77 /* AmendBasketTradeRequest */
        , 2007 /* ReverseTESTradeRequest */
        , 162 /* ApproveReverseTESTradeRequest */
        , 2908 /* TESReversalBroadcast */
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , -1
        , 2403 /* SRQSOpenNegotiationRequest */
        , 2605 /* SRQSUpdateNegotiationRequest */
        , 2158 /* SRQSEnterQuoteRequest */
        , 2559 /* SRQSQuoteResponse */
        , 2194 /* SRQSHitQuoteRequest */
        , 2145 /* SRQSDealResponse */
        , 2589 /* SRQSUpdateDealStatusRequest */
        , 2518 /* SRQSQuoteNotification */
        , 2037 /* SRQSCreateDealNotification */
        , 2099 /* SRQSDealNotification */
        , 2455 /* SRQSOpenNegotiationRequesterNotification */
        , 2355 /* SRQSOpenNegotiationNotification */
        , 2290 /* SRQSNegotiationRequesterNotification */
        , 2253 /* SRQSNegotiationNotification */
        , 2578 /* SRQSStatusBroadcast */
        , 2341 /* SRQSNegotiationStatusNotification */
        , -1
        , 2567 /* SRQSQuotingStatusRequest */
        , 2234 /* SRQSInquireSmartRespondentRequest */
        , 2244 /* SRQSInquireSmartRespondentResponse */
    };
    static int * const dscp_bits[] = {
        &hf_eti_dscp_exec_summary,
        &hf_eti_dscp_improved,
        &hf_eti_dscp_widened,
        NULL
    };
    if (templateid < 10000 || templateid > 10719) {
        proto_tree_add_expert_format(root, pinfo, &ei_eti_invalid_template, tvb, 4, 4,
            "Template ID out of range: %" PRIu16, templateid);
        return tvb_captured_length(tvb);
    }
    int fidx = tid2fidx[templateid - 10000];
    if (fidx == -1) {
        proto_tree_add_expert_format(root, pinfo, &ei_eti_invalid_template, tvb, 4, 4,
            "Unallocated Template ID: %" PRIu16, templateid);
        return tvb_captured_length(tvb);
    }
    if (bodylen < tid2size[templateid - 10000][0] || bodylen > tid2size[templateid - 10000][1]) {
        if (tid2size[templateid - 10000][0] != tid2size[templateid - 10000][1])
            proto_tree_add_expert_format(root, pinfo, &ei_eti_invalid_length, tvb, 0, 4,
                    "Unexpected BodyLen value of %" PRIu32 ", expected:  %" PRIu32 "..%" PRIu32, bodylen, tid2size[templateid - 10000][0], tid2size[templateid - 10000][1]);
        else
            proto_tree_add_expert_format(root, pinfo, &ei_eti_invalid_length, tvb, 0, 4,
                    "Unexpected BodyLen value of %" PRIu32 ", expected:  %" PRIu32, bodylen, tid2size[templateid - 10000][0]);
    }
    if (bodylen % 8)
        proto_tree_add_expert_format(root, pinfo, &ei_eti_unaligned, tvb, 0, 4,
                "BodyLen value of %" PRIu32 " is not divisible by 8", bodylen);

    int uidx = tid2uidx[templateid - 10000];
    DISSECTOR_ASSERT_CMPINT(uidx, >=, 0);
    DISSECTOR_ASSERT_CMPUINT(((size_t)uidx), <, array_length(usages));

    int old_fidx = 0;
    int old_uidx = 0;
    unsigned top = 1;
    unsigned counter[8] = {0};
    unsigned off = 0;
    unsigned struct_off = 0;
    unsigned repeats = 0;
    proto_tree *t = root;
    while (top) {
        DISSECTOR_ASSERT_CMPINT(fidx, >=, 0);
        DISSECTOR_ASSERT_CMPUINT(((size_t)fidx), <, array_length(fields));
        DISSECTOR_ASSERT_CMPINT(uidx, >=, 0);
        DISSECTOR_ASSERT_CMPUINT(((size_t)uidx), <, array_length(usages));

        switch (fields[fidx].type) {
            case ETI_EOF:
                DISSECTOR_ASSERT_CMPUINT(top, >=, 1);
                DISSECTOR_ASSERT_CMPUINT(top, <=, 2);
                if (t != root)
                    proto_item_set_len(t, off - struct_off);
                if (repeats) {
                    --repeats;
                    fidx = fields[old_fidx].field_handle_idx;
                    uidx = old_uidx;
                    t = proto_tree_add_subtree(root, tvb, off, -1, ett_eti[fields[old_fidx].ett_idx], NULL, &struct_names[fields[old_fidx].size]);
                    struct_off = off;
                } else {
                    fidx = old_fidx + 1;
                    t = root;
                    --top;
                }
                break;
            case ETI_VAR_STRUCT:
            case ETI_STRUCT:
                DISSECTOR_ASSERT_CMPUINT(fields[fidx].counter_off, <, array_length(counter));
                repeats = fields[fidx].type == ETI_VAR_STRUCT ? counter[fields[fidx].counter_off] : 1;
                if (repeats) {
                    --repeats;
                    t = proto_tree_add_subtree(root, tvb, off, -1, ett_eti[fields[fidx].ett_idx], NULL, &struct_names[fields[fidx].size]);
                    struct_off = off;
                    old_fidx = fidx;
                    old_uidx = uidx;
                    fidx = fields[fidx].field_handle_idx;
                    DISSECTOR_ASSERT_CMPUINT(top, ==, 1);
                    ++top;
                } else {
                    ++fidx;
                }
                break;
            case ETI_PADDING:
                off += fields[fidx].size;
                ++fidx;
                break;
            case ETI_CHAR:
                proto_tree_add_item(t, hf_eti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, ENC_ASCII);
                off += fields[fidx].size;
                ++fidx;
                ++uidx;
                break;
            case ETI_STRING:
                {
                    guint8 c = tvb_get_guint8(tvb, off);
                    if (c)
                        proto_tree_add_item(t, hf_eti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, ENC_ASCII);
                    else {
                        proto_item *e = proto_tree_add_string(t, hf_eti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, "NO_VALUE ('0x00...')");
                        if (!usages[uidx])
                            expert_add_info_format(pinfo, e, &ei_eti_missing, "required value is missing");
                    }
                }
                off += fields[fidx].size;
                ++fidx;
                ++uidx;
                break;
            case ETI_VAR_STRING:
                DISSECTOR_ASSERT_CMPUINT(fields[fidx].counter_off, <, array_length(counter));
                proto_tree_add_item(t, hf_eti[fields[fidx].field_handle_idx], tvb, off, counter[fields[fidx].counter_off], ENC_ASCII);
                off += counter[fields[fidx].counter_off];
                ++fidx;
                ++uidx;
                break;
            case ETI_COUNTER:
                DISSECTOR_ASSERT_CMPUINT(fields[fidx].counter_off, <, array_length(counter));
                DISSECTOR_ASSERT_CMPUINT(fields[fidx].size, <=, 2);
                {
                    switch (fields[fidx].size) {
                        case 1:
                            {
                                guint8 x = tvb_get_guint8(tvb, off);
                                if (x == UINT8_MAX) {
                                    proto_tree_add_uint_format_value(t, hf_eti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "NO_VALUE (0xff)");
                                    counter[fields[fidx].counter_off] = 0;
                                } else {
                                    proto_item *e = proto_tree_add_uint_format_value(t, hf_eti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "%" PRIu8, x);
                                    if (x > fields[fidx].ett_idx) {
                                        counter[fields[fidx].counter_off] = fields[fidx].ett_idx;
                                        expert_add_info_format(pinfo, e, &ei_eti_counter_overflow, "Counter overflow: %" PRIu8 " > %" PRIu16, x, fields[fidx].ett_idx);
                                    } else {
                                        counter[fields[fidx].counter_off] = x;
                                    }
                                }
                            }
                            break;
                        case 2:
                            {
                                guint16 x = tvb_get_letohs(tvb, off);
                                if (x == UINT16_MAX) {
                                    proto_tree_add_uint_format_value(t, hf_eti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "NO_VALUE (0xffff)");
                                    counter[fields[fidx].counter_off] = 0;
                                } else {
                                    proto_item *e = proto_tree_add_uint_format_value(t, hf_eti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "%" PRIu16, x);
                                    if (x > fields[fidx].ett_idx) {
                                        counter[fields[fidx].counter_off] = fields[fidx].ett_idx;
                                        expert_add_info_format(pinfo, e, &ei_eti_counter_overflow, "Counter overflow: %" PRIu16 " > %" PRIu16, x, fields[fidx].ett_idx);
                                    } else {
                                        counter[fields[fidx].counter_off] = x;
                                    }
                                }
                            }
                            break;
                    }
                }
                off += fields[fidx].size;
                ++fidx;
                ++uidx;
                break;
            case ETI_UINT:
                switch (fields[fidx].size) {
                    case 1:
                        {
                            guint8 x = tvb_get_guint8(tvb, off);
                            if (x == UINT8_MAX) {
                                proto_item *e = proto_tree_add_uint_format_value(t, hf_eti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "NO_VALUE (0xff)");
                                if (!usages[uidx])
                                    expert_add_info_format(pinfo, e, &ei_eti_missing, "required value is missing");
                            } else {
                                proto_item *e = proto_tree_add_uint_format_value(t, hf_eti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "%" PRIu8, x);
                                if (usages[uidx] == 2)
                                    expert_add_info_format(pinfo, e, &ei_eti_overused, "unused value is set");
                            }
                        }
                        break;
                    case 2:
                        {
                            guint16 x = tvb_get_letohs(tvb, off);
                            if (x == UINT16_MAX) {
                                proto_item *e = proto_tree_add_uint_format_value(t, hf_eti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "NO_VALUE (0xffff)");
                                if (!usages[uidx])
                                    expert_add_info_format(pinfo, e, &ei_eti_missing, "required value is missing");
                            } else {
                                proto_item *e = proto_tree_add_uint_format_value(t, hf_eti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "%" PRIu16, x);
                                if (usages[uidx] == 2)
                                    expert_add_info_format(pinfo, e, &ei_eti_overused, "unused value is set");
                            }
                        }
                        break;
                    case 4:
                        {
                            guint32 x = tvb_get_letohl(tvb, off);
                            if (x == UINT32_MAX) {
                                proto_item *e = proto_tree_add_uint_format_value(t, hf_eti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "NO_VALUE (0xffffffff)");
                                if (!usages[uidx])
                                    expert_add_info_format(pinfo, e, &ei_eti_missing, "required value is missing");
                            } else {
                                proto_item *e = proto_tree_add_uint_format_value(t, hf_eti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "%" PRIu32, x);
                                if (usages[uidx] == 2)
                                    expert_add_info_format(pinfo, e, &ei_eti_overused, "unused value is set");
                            }
                        }
                        break;
                    case 8:
                        {
                            guint64 x = tvb_get_letoh64(tvb, off);
                            if (x == UINT64_MAX) {
                                proto_item *e = proto_tree_add_uint64_format_value(t, hf_eti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "NO_VALUE (0xffffffffffffffff)");
                                if (!usages[uidx])
                                    expert_add_info_format(pinfo, e, &ei_eti_missing, "required value is missing");
                            } else {
                                proto_item *e = proto_tree_add_uint64_format_value(t, hf_eti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "%" PRIu64, x);
                                if (usages[uidx] == 2)
                                    expert_add_info_format(pinfo, e, &ei_eti_overused, "unused value is set");
                            }
                        }
                        break;
                }
                off += fields[fidx].size;
                ++fidx;
                ++uidx;
                break;
            case ETI_INT:
                switch (fields[fidx].size) {
                    case 1:
                        {
                            gint8 x = tvb_get_gint8(tvb, off);
                            if (x == INT8_MIN) {
                                proto_item *e = proto_tree_add_int_format_value(t, hf_eti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "NO_VALUE (0x80)");
                                if (!usages[uidx])
                                    expert_add_info_format(pinfo, e, &ei_eti_missing, "required value is missing");
                            } else {
                                proto_item *e = proto_tree_add_int_format_value(t, hf_eti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "%" PRIi8, x);
                                if (usages[uidx] == 2)
                                    expert_add_info_format(pinfo, e, &ei_eti_overused, "unused value is set");
                            }
                        }
                        break;
                    case 2:
                        {
                            gint16 x = tvb_get_letohis(tvb, off);
                            if (x == INT16_MIN) {
                                proto_item *e = proto_tree_add_int_format_value(t, hf_eti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "NO_VALUE (0x8000)");
                                if (!usages[uidx])
                                    expert_add_info_format(pinfo, e, &ei_eti_missing, "required value is missing");
                            } else {
                                proto_item *e = proto_tree_add_int_format_value(t, hf_eti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "%" PRIi16, x);
                                if (usages[uidx] == 2)
                                    expert_add_info_format(pinfo, e, &ei_eti_overused, "unused value is set");
                            }
                        }
                        break;
                    case 4:
                        {
                            gint32 x = tvb_get_letohil(tvb, off);
                            if (x == INT32_MIN) {
                                proto_item *e = proto_tree_add_int_format_value(t, hf_eti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "NO_VALUE (0x80000000)");
                                if (!usages[uidx])
                                    expert_add_info_format(pinfo, e, &ei_eti_missing, "required value is missing");
                            } else {
                                proto_item *e = proto_tree_add_int_format_value(t, hf_eti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "%" PRIi32, x);
                                if (usages[uidx] == 2)
                                    expert_add_info_format(pinfo, e, &ei_eti_overused, "unused value is set");
                            }
                        }
                        break;
                    case 8:
                        {
                            gint64 x = tvb_get_letohi64(tvb, off);
                            if (x == INT64_MIN) {
                                proto_item *e = proto_tree_add_int64_format_value(t, hf_eti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "NO_VALUE (0x8000000000000000)");
                                if (!usages[uidx])
                                    expert_add_info_format(pinfo, e, &ei_eti_missing, "required value is missing");
                            } else {
                                proto_item *e = proto_tree_add_int64_format_value(t, hf_eti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "%" PRIi64, x);
                                if (usages[uidx] == 2)
                                    expert_add_info_format(pinfo, e, &ei_eti_overused, "unused value is set");
                            }
                        }
                        break;
                }
                off += fields[fidx].size;
                ++fidx;
                ++uidx;
                break;
            case ETI_UINT_ENUM:
            case ETI_INT_ENUM:
                proto_tree_add_item(t, hf_eti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, ENC_LITTLE_ENDIAN);
                off += fields[fidx].size;
                ++fidx;
                ++uidx;
                break;
            case ETI_FIXED_POINT:
                DISSECTOR_ASSERT_CMPUINT(fields[fidx].size, ==, 8);
                DISSECTOR_ASSERT_CMPUINT(fields[fidx].counter_off, >, 0);
                DISSECTOR_ASSERT_CMPUINT(fields[fidx].counter_off, <=, 16);
                {
                    gint64 x = tvb_get_letohi64(tvb, off);
                    if (x == INT64_MIN) {
                        proto_item *e = proto_tree_add_int64_format_value(t, hf_eti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "NO_VALUE (0x8000000000000000)");
                        if (!usages[uidx])
                            expert_add_info_format(pinfo, e, &ei_eti_missing, "required value is missing");
                    } else {
                        unsigned slack = fields[fidx].counter_off + 1;
                        if (x < 0)
                            slack += 1;
                        char s[21];
                        int n = snprintf(s, sizeof s, "%0*" PRIi64, slack, x);
                        DISSECTOR_ASSERT_CMPUINT(n, >, 0);
                        unsigned k = n - fields[fidx].counter_off;
                        proto_tree_add_int64_format_value(t, hf_eti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, x, "%.*s.%s", k, s, s + k);
                    }
                }
                off += fields[fidx].size;
                ++fidx;
                ++uidx;
                break;
            case ETI_TIMESTAMP_NS:
                DISSECTOR_ASSERT_CMPUINT(fields[fidx].size, ==, 8);
                proto_tree_add_item(t, hf_eti[fields[fidx].field_handle_idx], tvb, off, fields[fidx].size, ENC_LITTLE_ENDIAN | ENC_TIME_NSECS);
                off += fields[fidx].size;
                ++fidx;
                ++uidx;
                break;
            case ETI_DSCP:
                DISSECTOR_ASSERT_CMPUINT(fields[fidx].size, ==, 1);
                proto_tree_add_bitmask(t, tvb, off, hf_eti[fields[fidx].field_handle_idx], ett_eti_dscp, dscp_bits, ENC_LITTLE_ENDIAN);
                off += fields[fidx].size;
                ++fidx;
                ++uidx;
                break;
        }
    }

    return tvb_captured_length(tvb);
}

/* determine PDU length of protocol ETI */
static guint
get_eti_message_len(packet_info *pinfo _U_, tvbuff_t *tvb, int offset, void *data _U_)
{
    return (guint)tvb_get_letohl(tvb, offset);
}

static int
dissect_eti(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree,
        void *data)
{
    tcp_dissect_pdus(tvb, pinfo, tree, TRUE, 4 /* bytes to read for bodylen */,
            get_eti_message_len, dissect_eti_message, data);
    return tvb_captured_length(tvb);
}

void
proto_register_eti(void)
{
    static hf_register_info hf[] ={
          { &hf_eti[ACCOUNT_FH_IDX],
              { "Account", "eti.account",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[AFFECTEDORDERREQUESTID_FH_IDX],
              { "AffectedOrderRequestID", "eti.affectedorderrequestid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ALLOCID_FH_IDX],
              { "AllocID", "eti.allocid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ALLOCQTY_FH_IDX],
              { "AllocQty", "eti.allocqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[APPLBEGMSGID_FH_IDX],
              { "ApplBegMsgID", "eti.applbegmsgid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[APPLBEGSEQNUM_FH_IDX],
              { "ApplBegSeqNum", "eti.applbegseqnum",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[APPLENDMSGID_FH_IDX],
              { "ApplEndMsgID", "eti.applendmsgid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[APPLENDSEQNUM_FH_IDX],
              { "ApplEndSeqNum", "eti.applendseqnum",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[APPLID_FH_IDX],
              { "ApplID", "eti.applid",
                FT_UINT8, BASE_DEC| BASE_EXT_STRING, &appl_id_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[APPLIDSTATUS_FH_IDX],
              { "ApplIDStatus", "eti.applidstatus",
                FT_UINT32, BASE_DEC, VALS(appl_idstatus_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[APPLMSGID_FH_IDX],
              { "ApplMsgID", "eti.applmsgid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[APPLRESENDFLAG_FH_IDX],
              { "ApplResendFlag", "eti.applresendflag",
                FT_UINT8, BASE_DEC, VALS(appl_resend_flag_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[APPLSEQINDICATOR_FH_IDX],
              { "ApplSeqIndicator", "eti.applseqindicator",
                FT_UINT8, BASE_DEC, VALS(appl_seq_indicator_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[APPLSEQNUM_FH_IDX],
              { "ApplSeqNum", "eti.applseqnum",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[APPLSEQSTATUS_FH_IDX],
              { "ApplSeqStatus", "eti.applseqstatus",
                FT_UINT8, BASE_DEC, VALS(appl_seq_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[APPLSEQTRADEDATE_FH_IDX],
              { "ApplSeqTradeDate", "eti.applseqtradedate",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[APPLSUBID_FH_IDX],
              { "ApplSubID", "eti.applsubid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[APPLTOTALMESSAGECOUNT_FH_IDX],
              { "ApplTotalMessageCount", "eti.appltotalmessagecount",
                FT_UINT16, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[APPLUSAGEORDERS_FH_IDX],
              { "ApplUsageOrders", "eti.applusageorders",
                FT_CHAR, BASE_HEX, VALS(appl_usage_orders_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[APPLUSAGEQUOTES_FH_IDX],
              { "ApplUsageQuotes", "eti.applusagequotes",
                FT_CHAR, BASE_HEX, VALS(appl_usage_orders_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[APPLICATIONSYSTEMNAME_FH_IDX],
              { "ApplicationSystemName", "eti.applicationsystemname",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[APPLICATIONSYSTEMVENDOR_FH_IDX],
              { "ApplicationSystemVendor", "eti.applicationsystemvendor",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[APPLICATIONSYSTEMVERSION_FH_IDX],
              { "ApplicationSystemVersion", "eti.applicationsystemversion",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[AUTOAPPROVALRULEID_FH_IDX],
              { "AutoApprovalRuleID", "eti.autoapprovalruleid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[BASKETEXECID_FH_IDX],
              { "BasketExecID", "eti.basketexecid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[BASKETPARTYCONTRAFIRM_FH_IDX],
              { "BasketPartyContraFirm", "eti.basketpartycontrafirm",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[BASKETPROFILEID_FH_IDX],
              { "BasketProfileID", "eti.basketprofileid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[BASKETSIDETRADEREPORTID_FH_IDX],
              { "BasketSideTradeReportID", "eti.basketsidetradereportid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[BASKETTRADEREPORTTEXT_FH_IDX],
              { "BasketTradeReportText", "eti.baskettradereporttext",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[BASKETTRADEREPORTTYPE_FH_IDX],
              { "BasketTradeReportType", "eti.baskettradereporttype",
                FT_UINT8, BASE_DEC, VALS(basket_trade_report_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[BASKETTRDMATCHID_FH_IDX],
              { "BasketTrdMatchID", "eti.baskettrdmatchid",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[BESTBIDPX_FH_IDX],
              { "BestBidPx", "eti.bestbidpx",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[BESTBIDSIZE_FH_IDX],
              { "BestBidSize", "eti.bestbidsize",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[BESTOFFERPX_FH_IDX],
              { "BestOfferPx", "eti.bestofferpx",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[BESTOFFERSIZE_FH_IDX],
              { "BestOfferSize", "eti.bestoffersize",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[BIDPX_FH_IDX],
              { "BidPx", "eti.bidpx",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[BIDPXISLOCKED_FH_IDX],
              { "BidPxIsLocked", "eti.bidpxislocked",
                FT_UINT8, BASE_DEC, VALS(bid_px_is_locked_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[BIDSIZE_FH_IDX],
              { "BidSize", "eti.bidsize",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[BODYLEN_FH_IDX],
              { "BodyLen", "eti.bodylen",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[CLORDID_FH_IDX],
              { "ClOrdID", "eti.clordid",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[CLEARINGTRADEPRICE_FH_IDX],
              { "ClearingTradePrice", "eti.clearingtradeprice",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[CLEARINGTRADEQTY_FH_IDX],
              { "ClearingTradeQty", "eti.clearingtradeqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[COMPLIANCETEXT_FH_IDX],
              { "ComplianceText", "eti.compliancetext",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[COMPRESSIONACTION_FH_IDX],
              { "CompressionAction", "eti.compressionaction",
                FT_UINT8, BASE_DEC, VALS(compression_action_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[COMPRESSIONID_FH_IDX],
              { "CompressionID", "eti.compressionid",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[COMPRESSIONSTATUS_FH_IDX],
              { "CompressionStatus", "eti.compressionstatus",
                FT_UINT8, BASE_DEC, VALS(compression_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[CONTRACTDATE_FH_IDX],
              { "ContractDate", "eti.contractdate",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[CROSSID_FH_IDX],
              { "CrossID", "eti.crossid",
                FT_INT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[CROSSREQUESTID_FH_IDX],
              { "CrossRequestID", "eti.crossrequestid",
                FT_INT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[CROSSEDINDICATOR_FH_IDX],
              { "CrossedIndicator", "eti.crossedindicator",
                FT_UINT8, BASE_DEC, VALS(crossed_indicator_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[CUMQTY_FH_IDX],
              { "CumQty", "eti.cumqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[CUSTORDERHANDLINGINST_FH_IDX],
              { "CustOrderHandlingInst", "eti.custorderhandlinginst",
                FT_CHAR, BASE_HEX, VALS(cust_order_handling_inst_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[CXLQTY_FH_IDX],
              { "CxlQty", "eti.cxlqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[CXLSIZE_FH_IDX],
              { "CxlSize", "eti.cxlsize",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[DEFAULTCSTMAPPLVERID_FH_IDX],
              { "DefaultCstmApplVerID", "eti.defaultcstmapplverid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[DEFAULTCSTMAPPLVERSUBID_FH_IDX],
              { "DefaultCstmApplVerSubID", "eti.defaultcstmapplversubid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[DELETEREASON_FH_IDX],
              { "DeleteReason", "eti.deletereason",
                FT_UINT8, BASE_DEC| BASE_EXT_STRING, &delete_reason_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[DELTA_FH_IDX],
              { "Delta", "eti.delta",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[EFFECTONBASKET_FH_IDX],
              { "EffectOnBasket", "eti.effectonbasket",
                FT_UINT8, BASE_DEC, VALS(effect_on_basket_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[EFFECTIVETIME_FH_IDX],
              { "EffectiveTime", "eti.effectivetime",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ENLIGHTRFQAVGRESPRATERANKING_FH_IDX],
              { "EnlightRFQAvgRespRateRanking", "eti.enlightrfqavgresprateranking",
                FT_UINT8, BASE_DEC, VALS(enlight_rfqavg_resp_rate_ranking_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ENLIGHTRFQAVGRESPTIMERANKING_FH_IDX],
              { "EnlightRFQAvgRespTimeRanking", "eti.enlightrfqavgresptimeranking",
                FT_UINT8, BASE_DEC, VALS(enlight_rfqavg_resp_rate_ranking_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ENRICHMENTRULEID_FH_IDX],
              { "EnrichmentRuleID", "eti.enrichmentruleid",
                FT_UINT16, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[EUREXVOLUMERANKING_FH_IDX],
              { "EurexVolumeRanking", "eti.eurexvolumeranking",
                FT_UINT8, BASE_DEC, VALS(enlight_rfqavg_resp_rate_ranking_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[EVENTDATE_FH_IDX],
              { "EventDate", "eti.eventdate",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[EVENTTYPE_FH_IDX],
              { "EventType", "eti.eventtype",
                FT_UINT8, BASE_DEC, VALS(event_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[EXECID_FH_IDX],
              { "ExecID", "eti.execid",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[EXECINST_FH_IDX],
              { "ExecInst", "eti.execinst",
                FT_UINT8, BASE_DEC, VALS(exec_inst_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[EXECRESTATEMENTREASON_FH_IDX],
              { "ExecRestatementReason", "eti.execrestatementreason",
                FT_UINT16, BASE_DEC| BASE_EXT_STRING, &exec_restatement_reason_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[EXECTYPE_FH_IDX],
              { "ExecType", "eti.exectype",
                FT_CHAR, BASE_HEX| BASE_EXT_STRING, &exec_type_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[EXECUTINGTRADER_FH_IDX],
              { "ExecutingTrader", "eti.executingtrader",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[EXECUTINGTRADERQUALIFIER_FH_IDX],
              { "ExecutingTraderQualifier", "eti.executingtraderqualifier",
                FT_UINT8, BASE_DEC, VALS(executing_trader_qualifier_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[EXERCISESTYLE_FH_IDX],
              { "ExerciseStyle", "eti.exercisestyle",
                FT_UINT8, BASE_DEC, VALS(exercise_style_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[EXPIREDATE_FH_IDX],
              { "ExpireDate", "eti.expiredate",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[EXPIRETIME_FH_IDX],
              { "ExpireTime", "eti.expiretime",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[EXPOSUREDURATION_FH_IDX],
              { "ExposureDuration", "eti.exposureduration",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[FIXCLORDID_FH_IDX],
              { "FIXClOrdID", "eti.fixclordid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[FIXENGINENAME_FH_IDX],
              { "FIXEngineName", "eti.fixenginename",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[FIXENGINEVENDOR_FH_IDX],
              { "FIXEngineVendor", "eti.fixenginevendor",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[FIXENGINEVERSION_FH_IDX],
              { "FIXEngineVersion", "eti.fixengineversion",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[FILLEXECID_FH_IDX],
              { "FillExecID", "eti.fillexecid",
                FT_INT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[FILLLIQUIDITYIND_FH_IDX],
              { "FillLiquidityInd", "eti.fillliquidityind",
                FT_UINT8, BASE_DEC, VALS(fill_liquidity_ind_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[FILLMATCHID_FH_IDX],
              { "FillMatchID", "eti.fillmatchid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[FILLPX_FH_IDX],
              { "FillPx", "eti.fillpx",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[FILLQTY_FH_IDX],
              { "FillQty", "eti.fillqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[FILLREFID_FH_IDX],
              { "FillRefID", "eti.fillrefid",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[FIRMNEGOTIATIONID_FH_IDX],
              { "FirmNegotiationID", "eti.firmnegotiationid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[FIRMTRADEID_FH_IDX],
              { "FirmTradeID", "eti.firmtradeid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[FREETEXT1_FH_IDX],
              { "FreeText1", "eti.freetext1",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[FREETEXT2_FH_IDX],
              { "FreeText2", "eti.freetext2",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[FREETEXT3_FH_IDX],
              { "FreeText3", "eti.freetext3",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[FREETEXT5_FH_IDX],
              { "FreeText5", "eti.freetext5",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[FREETEXT5DISCLOSUREINSTRUCTION_FH_IDX],
              { "FreeText5DisclosureInstruction", "eti.freetext5disclosureinstruction",
                FT_UINT8, BASE_DEC, VALS(bid_px_is_locked_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[HEADLINE_FH_IDX],
              { "Headline", "eti.headline",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[HEARTBTINT_FH_IDX],
              { "HeartBtInt", "eti.heartbtint",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[HEDGETYPE_FH_IDX],
              { "HedgeType", "eti.hedgetype",
                FT_UINT8, BASE_DEC, VALS(hedge_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[HEDGINGINSTRUCTION_FH_IDX],
              { "HedgingInstruction", "eti.hedginginstruction",
                FT_UINT8, BASE_DEC, VALS(hedging_instruction_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[HIGHLIMITPRICE_FH_IDX],
              { "HighLimitPrice", "eti.highlimitprice",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[IMPLIEDMARKETINDICATOR_FH_IDX],
              { "ImpliedMarketIndicator", "eti.impliedmarketindicator",
                FT_UINT8, BASE_DEC, VALS(implied_market_indicator_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[INDIVIDUALALLOCID_FH_IDX],
              { "IndividualAllocID", "eti.individualallocid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[INPUTSOURCE_FH_IDX],
              { "InputSource", "eti.inputsource",
                FT_UINT8, BASE_DEC, VALS(input_source_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[INSTRATTRIBTYPE_FH_IDX],
              { "InstrAttribType", "eti.instrattribtype",
                FT_UINT8, BASE_DEC, VALS(instr_attrib_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[INSTRATTRIBVALUE_FH_IDX],
              { "InstrAttribValue", "eti.instrattribvalue",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[INSTRMTMATCHSIDEID_FH_IDX],
              { "InstrmtMatchSideID", "eti.instrmtmatchsideid",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[LASTENTITYPROCESSED_FH_IDX],
              { "LastEntityProcessed", "eti.lastentityprocessed",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[LASTFRAGMENT_FH_IDX],
              { "LastFragment", "eti.lastfragment",
                FT_UINT8, BASE_DEC, VALS(last_fragment_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[LASTPX_FH_IDX],
              { "LastPx", "eti.lastpx",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[LASTPXDISCLOSUREINSTRUCTION_FH_IDX],
              { "LastPxDisclosureInstruction", "eti.lastpxdisclosureinstruction",
                FT_UINT8, BASE_DEC, VALS(bid_px_is_locked_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[LASTQTY_FH_IDX],
              { "LastQty", "eti.lastqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[LASTQTYDISCLOSUREINSTRUCTION_FH_IDX],
              { "LastQtyDisclosureInstruction", "eti.lastqtydisclosureinstruction",
                FT_UINT8, BASE_DEC, VALS(bid_px_is_locked_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[LASTUPDATETIME_FH_IDX],
              { "LastUpdateTime", "eti.lastupdatetime",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[LEAVESQTY_FH_IDX],
              { "LeavesQty", "eti.leavesqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[LEAVESQTYDISCLOSUREINSTRUCTION_FH_IDX],
              { "LeavesQtyDisclosureInstruction", "eti.leavesqtydisclosureinstruction",
                FT_UINT8, BASE_DEC, VALS(bid_px_is_locked_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[LEGACCOUNT_FH_IDX],
              { "LegAccount", "eti.legaccount",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[LEGEXECID_FH_IDX],
              { "LegExecID", "eti.legexecid",
                FT_INT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[LEGINPUTSOURCE_FH_IDX],
              { "LegInputSource", "eti.leginputsource",
                FT_UINT8, BASE_DEC, VALS(input_source_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[LEGLASTPX_FH_IDX],
              { "LegLastPx", "eti.leglastpx",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[LEGLASTQTY_FH_IDX],
              { "LegLastQty", "eti.leglastqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[LEGPOSITIONEFFECT_FH_IDX],
              { "LegPositionEffect", "eti.legpositioneffect",
                FT_CHAR, BASE_HEX, VALS(leg_position_effect_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[LEGPRICE_FH_IDX],
              { "LegPrice", "eti.legprice",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[LEGQTY_FH_IDX],
              { "LegQty", "eti.legqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[LEGRATIOQTY_FH_IDX],
              { "LegRatioQty", "eti.legratioqty",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[LEGSECURITYID_FH_IDX],
              { "LegSecurityID", "eti.legsecurityid",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[LEGSECURITYTYPE_FH_IDX],
              { "LegSecurityType", "eti.legsecuritytype",
                FT_UINT8, BASE_DEC, VALS(leg_security_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[LEGSIDE_FH_IDX],
              { "LegSide", "eti.legside",
                FT_UINT8, BASE_DEC, VALS(leg_side_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[LEGSYMBOL_FH_IDX],
              { "LegSymbol", "eti.legsymbol",
                FT_INT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[LISTUPDATEACTION_FH_IDX],
              { "ListUpdateAction", "eti.listupdateaction",
                FT_CHAR, BASE_HEX, VALS(list_update_action_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[LOWLIMITPRICE_FH_IDX],
              { "LowLimitPrice", "eti.lowlimitprice",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[MDBOOKTYPE_FH_IDX],
              { "MDBookType", "eti.mdbooktype",
                FT_UINT8, BASE_DEC, VALS(mdbook_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[MDSUBBOOKTYPE_FH_IDX],
              { "MDSubBookType", "eti.mdsubbooktype",
                FT_UINT8, BASE_DEC, VALS(mdsub_book_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[MMPARAMETERREPORTID_FH_IDX],
              { "MMParameterReportID", "eti.mmparameterreportid",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[MARKETID_FH_IDX],
              { "MarketID", "eti.marketid",
                FT_UINT16, BASE_DEC, VALS(market_id_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[MARKETSEGMENTID_FH_IDX],
              { "MarketSegmentID", "eti.marketsegmentid",
                FT_INT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[MASSACTIONREASON_FH_IDX],
              { "MassActionReason", "eti.massactionreason",
                FT_UINT8, BASE_DEC| BASE_EXT_STRING, &mass_action_reason_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[MASSACTIONREPORTID_FH_IDX],
              { "MassActionReportID", "eti.massactionreportid",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[MASSACTIONSUBTYPE_FH_IDX],
              { "MassActionSubType", "eti.massactionsubtype",
                FT_UINT8, BASE_DEC, VALS(mass_action_sub_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[MASSACTIONTYPE_FH_IDX],
              { "MassActionType", "eti.massactiontype",
                FT_UINT8, BASE_DEC, VALS(mass_action_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[MATCHDATE_FH_IDX],
              { "MatchDate", "eti.matchdate",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[MATCHINSTCROSSID_FH_IDX],
              { "MatchInstCrossID", "eti.matchinstcrossid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[MATCHSUBTYPE_FH_IDX],
              { "MatchSubType", "eti.matchsubtype",
                FT_UINT8, BASE_DEC, VALS(match_sub_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[MATCHTYPE_FH_IDX],
              { "MatchType", "eti.matchtype",
                FT_UINT8, BASE_DEC, VALS(match_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[MATCHINGENGINESTATUS_FH_IDX],
              { "MatchingEngineStatus", "eti.matchingenginestatus",
                FT_UINT8, BASE_DEC, VALS(appl_seq_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[MATCHINGENGINETRADEDATE_FH_IDX],
              { "MatchingEngineTradeDate", "eti.matchingenginetradedate",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[MATURITYDATE_FH_IDX],
              { "MaturityDate", "eti.maturitydate",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[MATURITYMONTHYEAR_FH_IDX],
              { "MaturityMonthYear", "eti.maturitymonthyear",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[MAXIMUMPRICE_FH_IDX],
              { "MaximumPrice", "eti.maximumprice",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[MESSAGEEVENTSOURCE_FH_IDX],
              { "MessageEventSource", "eti.messageeventsource",
                FT_CHAR, BASE_HEX, VALS(message_event_source_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[MSGSEQNUM_FH_IDX],
              { "MsgSeqNum", "eti.msgseqnum",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[MULTILEGREPORTINGTYPE_FH_IDX],
              { "MultiLegReportingType", "eti.multilegreportingtype",
                FT_UINT8, BASE_DEC, VALS(multi_leg_reporting_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[MULTILEGMODEL_FH_IDX],
              { "MultilegModel", "eti.multilegmodel",
                FT_UINT8, BASE_DEC, VALS(multileg_model_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[MULTILEGPRICEMODEL_FH_IDX],
              { "MultilegPriceModel", "eti.multilegpricemodel",
                FT_UINT8, BASE_DEC, VALS(multileg_price_model_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NEGOTIATIONID_FH_IDX],
              { "NegotiationID", "eti.negotiationid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NEGOTIATIONSTARTTIME_FH_IDX],
              { "NegotiationStartTime", "eti.negotiationstarttime",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NETTINGCOEFFICIENT_FH_IDX],
              { "NettingCoefficient", "eti.nettingcoefficient",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NETWORKMSGID_FH_IDX],
              { "NetworkMsgID", "eti.networkmsgid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOAFFECTEDORDERREQUESTS_FH_IDX],
              { "NoAffectedOrderRequests", "eti.noaffectedorderrequests",
                FT_UINT16, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOBASKETROOTPARTYGRPS_FH_IDX],
              { "NoBasketRootPartyGrps", "eti.nobasketrootpartygrps",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOBASKETROOTPARTYGRPSBC_FH_IDX],
              { "NoBasketRootPartyGrpsBC", "eti.nobasketrootpartygrpsbc",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOBASKETSIDEALLOC_FH_IDX],
              { "NoBasketSideAlloc", "eti.nobasketsidealloc",
                FT_UINT16, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOCROSSLEGS_FH_IDX],
              { "NoCrossLegs", "eti.nocrosslegs",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOENRICHMENTRULES_FH_IDX],
              { "NoEnrichmentRules", "eti.noenrichmentrules",
                FT_UINT16, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOEVENTS_FH_IDX],
              { "NoEvents", "eti.noevents",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOFILLS_FH_IDX],
              { "NoFills", "eti.nofills",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOINSTRATTRIB_FH_IDX],
              { "NoInstrAttrib", "eti.noinstrattrib",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOINSTRMTMATCHSIDES_FH_IDX],
              { "NoInstrmtMatchSides", "eti.noinstrmtmatchsides",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOLEGEXECS_FH_IDX],
              { "NoLegExecs", "eti.nolegexecs",
                FT_UINT16, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOLEGS_FH_IDX],
              { "NoLegs", "eti.nolegs",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOMMPARAMETERS_FH_IDX],
              { "NoMMParameters", "eti.nommparameters",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NONOTAFFECTEDORDERS_FH_IDX],
              { "NoNotAffectedOrders", "eti.nonotaffectedorders",
                FT_UINT16, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NONOTAFFECTEDSECURITIES_FH_IDX],
              { "NoNotAffectedSecurities", "eti.nonotaffectedsecurities",
                FT_UINT16, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOORDERBOOKITEMS_FH_IDX],
              { "NoOrderBookItems", "eti.noorderbookitems",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOORDEREVENTS_FH_IDX],
              { "NoOrderEvents", "eti.noorderevents",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOPARTYDETAILS_FH_IDX],
              { "NoPartyDetails", "eti.nopartydetails",
                FT_UINT16, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOQUOTEENTRIES_FH_IDX],
              { "NoQuoteEntries", "eti.noquoteentries",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOQUOTEEVENTS_FH_IDX],
              { "NoQuoteEvents", "eti.noquoteevents",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOQUOTEEVENTSINDEX_FH_IDX],
              { "NoQuoteEventsIndex", "eti.noquoteeventsindex",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOQUOTESIDEENTRIES_FH_IDX],
              { "NoQuoteSideEntries", "eti.noquotesideentries",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NORISKLIMITS_FH_IDX],
              { "NoRiskLimits", "eti.norisklimits",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NORISKLIMITSQTY_FH_IDX],
              { "NoRiskLimitsQty", "eti.norisklimitsqty",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOSRQSQUOTEGRPS_FH_IDX],
              { "NoSRQSQuoteGrps", "eti.nosrqsquotegrps",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOSRQSRELATEDTRADEIDS_FH_IDX],
              { "NoSRQSRelatedTradeIDs", "eti.nosrqsrelatedtradeids",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOSRQSTARGETPARTYTRDGRPS_FH_IDX],
              { "NoSRQSTargetPartyTrdGrps", "eti.nosrqstargetpartytrdgrps",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOSESSIONS_FH_IDX],
              { "NoSessions", "eti.nosessions",
                FT_UINT16, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOSIDEALLOCS_FH_IDX],
              { "NoSideAllocs", "eti.nosideallocs",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOSIDES_FH_IDX],
              { "NoSides", "eti.nosides",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOTARGETPARTYIDS_FH_IDX],
              { "NoTargetPartyIDs", "eti.notargetpartyids",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOUNDERLYINGSTIPS_FH_IDX],
              { "NoUnderlyingStips", "eti.nounderlyingstips",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOTAFFORIGCLORDID_FH_IDX],
              { "NotAffOrigClOrdID", "eti.notafforigclordid",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOTAFFECTEDORDERID_FH_IDX],
              { "NotAffectedOrderID", "eti.notaffectedorderid",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOTAFFECTEDSECURITYID_FH_IDX],
              { "NotAffectedSecurityID", "eti.notaffectedsecurityid",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NOTIFICATIONIN_FH_IDX],
              { "NotificationIn", "eti.notificationin",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NUMBEROFRESPDISCLOSUREINSTRUCTION_FH_IDX],
              { "NumberOfRespDisclosureInstruction", "eti.numberofrespdisclosureinstruction",
                FT_UINT8, BASE_DEC, VALS(bid_px_is_locked_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NUMBEROFRESPONDENTS_FH_IDX],
              { "NumberOfRespondents", "eti.numberofrespondents",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[NUMBEROFSECURITIES_FH_IDX],
              { "NumberOfSecurities", "eti.numberofsecurities",
                FT_INT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[OFFERPX_FH_IDX],
              { "OfferPx", "eti.offerpx",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[OFFERPXISLOCKED_FH_IDX],
              { "OfferPxIsLocked", "eti.offerpxislocked",
                FT_UINT8, BASE_DEC, VALS(bid_px_is_locked_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[OFFERSIZE_FH_IDX],
              { "OfferSize", "eti.offersize",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[OPTATTRIBUTE_FH_IDX],
              { "OptAttribute", "eti.optattribute",
                FT_UINT8, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ORDSTATUS_FH_IDX],
              { "OrdStatus", "eti.ordstatus",
                FT_CHAR, BASE_HEX, VALS(ord_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ORDTYPE_FH_IDX],
              { "OrdType", "eti.ordtype",
                FT_UINT8, BASE_DEC, VALS(ord_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ORDERATTRIBUTELIQUIDITYPROVISION_FH_IDX],
              { "OrderAttributeLiquidityProvision", "eti.orderattributeliquidityprovision",
                FT_UINT8, BASE_DEC, VALS(order_attribute_liquidity_provision_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ORDERATTRIBUTERISKREDUCTION_FH_IDX],
              { "OrderAttributeRiskReduction", "eti.orderattributeriskreduction",
                FT_UINT8, BASE_DEC, VALS(order_attribute_liquidity_provision_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ORDERCATEGORY_FH_IDX],
              { "OrderCategory", "eti.ordercategory",
                FT_CHAR, BASE_HEX, VALS(order_category_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ORDEREVENTMATCHID_FH_IDX],
              { "OrderEventMatchID", "eti.ordereventmatchid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ORDEREVENTPX_FH_IDX],
              { "OrderEventPx", "eti.ordereventpx",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ORDEREVENTQTY_FH_IDX],
              { "OrderEventQty", "eti.ordereventqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ORDEREVENTREASON_FH_IDX],
              { "OrderEventReason", "eti.ordereventreason",
                FT_UINT8, BASE_DEC, VALS(order_event_reason_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ORDERID_FH_IDX],
              { "OrderID", "eti.orderid",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ORDERORIGINATION_FH_IDX],
              { "OrderOrigination", "eti.orderorigination",
                FT_UINT8, BASE_DEC, VALS(order_origination_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ORDERQTY_FH_IDX],
              { "OrderQty", "eti.orderqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ORDERQTYDISCLOSUREINSTRUCTION_FH_IDX],
              { "OrderQtyDisclosureInstruction", "eti.orderqtydisclosureinstruction",
                FT_UINT8, BASE_DEC, VALS(bid_px_is_locked_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ORDERQTYISLOCKED_FH_IDX],
              { "OrderQtyIsLocked", "eti.orderqtyislocked",
                FT_UINT8, BASE_DEC, VALS(bid_px_is_locked_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ORDERROUTINGINDICATOR_FH_IDX],
              { "OrderRoutingIndicator", "eti.orderroutingindicator",
                FT_CHAR, BASE_HEX, VALS(order_routing_indicator_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ORDERSIDE_FH_IDX],
              { "OrderSide", "eti.orderside",
                FT_UINT8, BASE_DEC, VALS(leg_side_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ORIGCLORDID_FH_IDX],
              { "OrigClOrdID", "eti.origclordid",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ORIGTIME_FH_IDX],
              { "OrigTime", "eti.origtime",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ORIGTRADEID_FH_IDX],
              { "OrigTradeID", "eti.origtradeid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[OWNERSHIPINDICATOR_FH_IDX],
              { "OwnershipIndicator", "eti.ownershipindicator",
                FT_UINT8, BASE_DEC, VALS(ownership_indicator_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PACKAGEID_FH_IDX],
              { "PackageID", "eti.packageid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTITIONID_FH_IDX],
              { "PartitionID", "eti.partitionid",
                FT_UINT16, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYACTIONTYPE_FH_IDX],
              { "PartyActionType", "eti.partyactiontype",
                FT_UINT8, BASE_DEC, VALS(party_action_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYDETAILDESKID_FH_IDX],
              { "PartyDetailDeskID", "eti.partydetaildeskid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYDETAILEXECUTINGTRADER_FH_IDX],
              { "PartyDetailExecutingTrader", "eti.partydetailexecutingtrader",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYDETAILEXECUTINGUNIT_FH_IDX],
              { "PartyDetailExecutingUnit", "eti.partydetailexecutingunit",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYDETAILIDEXECUTINGTRADER_FH_IDX],
              { "PartyDetailIDExecutingTrader", "eti.partydetailidexecutingtrader",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYDETAILIDEXECUTINGUNIT_FH_IDX],
              { "PartyDetailIDExecutingUnit", "eti.partydetailidexecutingunit",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYDETAILROLEQUALIFIER_FH_IDX],
              { "PartyDetailRoleQualifier", "eti.partydetailrolequalifier",
                FT_UINT8, BASE_DEC, VALS(party_detail_role_qualifier_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYDETAILSTATUS_FH_IDX],
              { "PartyDetailStatus", "eti.partydetailstatus",
                FT_UINT8, BASE_DEC, VALS(party_detail_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYDETAILSTATUSINFORMATION_FH_IDX],
              { "PartyDetailStatusInformation", "eti.partydetailstatusinformation",
                FT_UINT8, BASE_DEC, VALS(party_detail_status_information_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYENTERINGTRADER_FH_IDX],
              { "PartyEnteringTrader", "eti.partyenteringtrader",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYEXECUTINGFIRM_FH_IDX],
              { "PartyExecutingFirm", "eti.partyexecutingfirm",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYEXECUTINGTRADER_FH_IDX],
              { "PartyExecutingTrader", "eti.partyexecutingtrader",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYEXECUTINGUNIT_FH_IDX],
              { "PartyExecutingUnit", "eti.partyexecutingunit",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYIDBENEFICIARY_FH_IDX],
              { "PartyIDBeneficiary", "eti.partyidbeneficiary",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYIDCLIENTID_FH_IDX],
              { "PartyIDClientID", "eti.partyidclientid",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYIDENTERINGFIRM_FH_IDX],
              { "PartyIDEnteringFirm", "eti.partyidenteringfirm",
                FT_UINT8, BASE_DEC, VALS(party_identering_firm_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYIDENTERINGTRADER_FH_IDX],
              { "PartyIDEnteringTrader", "eti.partyidenteringtrader",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYIDEXECUTINGTRADER_FH_IDX],
              { "PartyIDExecutingTrader", "eti.partyidexecutingtrader",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYIDEXECUTINGUNIT_FH_IDX],
              { "PartyIDExecutingUnit", "eti.partyidexecutingunit",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYIDLOCATIONID_FH_IDX],
              { "PartyIDLocationID", "eti.partyidlocationid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYIDORDERORIGINATIONFIRM_FH_IDX],
              { "PartyIDOrderOriginationFirm", "eti.partyidorderoriginationfirm",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYIDORIGINATIONMARKET_FH_IDX],
              { "PartyIDOriginationMarket", "eti.partyidoriginationmarket",
                FT_UINT8, BASE_DEC, VALS(party_idorigination_market_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYIDPOSITIONACCOUNT_FH_IDX],
              { "PartyIDPositionAccount", "eti.partyidpositionaccount",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYIDSESSIONID_FH_IDX],
              { "PartyIDSessionID", "eti.partyidsessionid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYIDSETTLEMENTLOCATION_FH_IDX],
              { "PartyIDSettlementLocation", "eti.partyidsettlementlocation",
                FT_UINT8, BASE_DEC, VALS(party_idsettlement_location_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYIDTAKEUPTRADINGFIRM_FH_IDX],
              { "PartyIDTakeUpTradingFirm", "eti.partyidtakeuptradingfirm",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYIDINVESTMENTDECISIONMAKER_FH_IDX],
              { "PartyIdInvestmentDecisionMaker", "eti.partyidinvestmentdecisionmaker",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX],
              { "PartyIdInvestmentDecisionMakerQualifier", "eti.partyidinvestmentdecisionmakerqualifier",
                FT_UINT8, BASE_DEC, VALS(executing_trader_qualifier_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYORDERORIGINATIONDISCLOSUREINSTRUCTION_FH_IDX],
              { "PartyOrderOriginationDisclosureInstruction", "eti.partyorderoriginationdisclosureinstruction",
                FT_UINT8, BASE_DEC, VALS(bid_px_is_locked_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYORDERORIGINATIONTRADER_FH_IDX],
              { "PartyOrderOriginationTrader", "eti.partyorderoriginationtrader",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PARTYSUBIDTYPE_FH_IDX],
              { "PartySubIDType", "eti.partysubidtype",
                FT_UINT16, BASE_DEC, VALS(party_sub_idtype_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PASSWORD_FH_IDX],
              { "Password", "eti.password",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PCTCOUNT_FH_IDX],
              { "PctCount", "eti.pctcount",
                FT_INT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[POSITIONEFFECT_FH_IDX],
              { "PositionEffect", "eti.positioneffect",
                FT_CHAR, BASE_HEX, VALS(leg_position_effect_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PRICE_FH_IDX],
              { "Price", "eti.price",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PRICEDISCLOSUREINSTRUCTION_FH_IDX],
              { "PriceDisclosureInstruction", "eti.pricedisclosureinstruction",
                FT_UINT8, BASE_DEC, VALS(bid_px_is_locked_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PRICEVALIDITYCHECKTYPE_FH_IDX],
              { "PriceValidityCheckType", "eti.pricevaliditychecktype",
                FT_UINT8, BASE_DEC, VALS(price_validity_check_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PRODUCTCOMPLEX_FH_IDX],
              { "ProductComplex", "eti.productcomplex",
                FT_UINT8, BASE_DEC| BASE_EXT_STRING, &product_complex_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[PUTORCALL_FH_IDX],
              { "PutOrCall", "eti.putorcall",
                FT_UINT8, BASE_DEC, VALS(put_or_call_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[QUOTECANCELREASON_FH_IDX],
              { "QuoteCancelReason", "eti.quotecancelreason",
                FT_UINT8, BASE_DEC, VALS(quote_cancel_reason_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[QUOTECONDITION_FH_IDX],
              { "QuoteCondition", "eti.quotecondition",
                FT_CHAR, BASE_HEX, VALS(quote_condition_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[QUOTEENTRYREJECTREASON_FH_IDX],
              { "QuoteEntryRejectReason", "eti.quoteentryrejectreason",
                FT_UINT32, BASE_DEC| BASE_EXT_STRING, &quote_entry_reject_reason_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[QUOTEENTRYSTATUS_FH_IDX],
              { "QuoteEntryStatus", "eti.quoteentrystatus",
                FT_UINT8, BASE_DEC, VALS(quote_entry_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[QUOTEEVENTEXECID_FH_IDX],
              { "QuoteEventExecID", "eti.quoteeventexecid",
                FT_INT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[QUOTEEVENTLIQUIDITYIND_FH_IDX],
              { "QuoteEventLiquidityInd", "eti.quoteeventliquidityind",
                FT_UINT8, BASE_DEC, VALS(quote_event_liquidity_ind_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[QUOTEEVENTMATCHID_FH_IDX],
              { "QuoteEventMatchID", "eti.quoteeventmatchid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[QUOTEEVENTPX_FH_IDX],
              { "QuoteEventPx", "eti.quoteeventpx",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[QUOTEEVENTQTY_FH_IDX],
              { "QuoteEventQty", "eti.quoteeventqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[QUOTEEVENTREASON_FH_IDX],
              { "QuoteEventReason", "eti.quoteeventreason",
                FT_UINT8, BASE_DEC, VALS(quote_event_reason_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[QUOTEEVENTSIDE_FH_IDX],
              { "QuoteEventSide", "eti.quoteeventside",
                FT_UINT8, BASE_DEC, VALS(leg_side_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[QUOTEEVENTTYPE_FH_IDX],
              { "QuoteEventType", "eti.quoteeventtype",
                FT_UINT8, BASE_DEC, VALS(quote_event_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[QUOTEID_FH_IDX],
              { "QuoteID", "eti.quoteid",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[QUOTEINSTRUCTION_FH_IDX],
              { "QuoteInstruction", "eti.quoteinstruction",
                FT_UINT8, BASE_DEC, VALS(quote_instruction_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[QUOTEMSGID_FH_IDX],
              { "QuoteMsgID", "eti.quotemsgid",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[QUOTEREFPRICE_FH_IDX],
              { "QuoteRefPrice", "eti.quoterefprice",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[QUOTEREQID_FH_IDX],
              { "QuoteReqID", "eti.quotereqid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[QUOTERESPONSEID_FH_IDX],
              { "QuoteResponseID", "eti.quoteresponseid",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[QUOTESIZETYPE_FH_IDX],
              { "QuoteSizeType", "eti.quotesizetype",
                FT_UINT8, BASE_DEC, VALS(quote_size_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[QUOTESUBTYPE_FH_IDX],
              { "QuoteSubType", "eti.quotesubtype",
                FT_UINT8, BASE_DEC, VALS(quote_sub_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[QUOTETYPE_FH_IDX],
              { "QuoteType", "eti.quotetype",
                FT_UINT8, BASE_DEC, VALS(quote_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[QUOTINGSTATUS_FH_IDX],
              { "QuotingStatus", "eti.quotingstatus",
                FT_UINT8, BASE_DEC, VALS(quoting_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[REFAPPLID_FH_IDX],
              { "RefApplID", "eti.refapplid",
                FT_UINT8, BASE_DEC| BASE_EXT_STRING, &appl_id_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[REFAPPLLASTMSGID_FH_IDX],
              { "RefApplLastMsgID", "eti.refappllastmsgid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[REFAPPLLASTSEQNUM_FH_IDX],
              { "RefApplLastSeqNum", "eti.refappllastseqnum",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[REFAPPLSUBID_FH_IDX],
              { "RefApplSubID", "eti.refapplsubid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[REGULATORYTRADEID_FH_IDX],
              { "RegulatoryTradeID", "eti.regulatorytradeid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[RELATEDCLOSEPRICE_FH_IDX],
              { "RelatedClosePrice", "eti.relatedcloseprice",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[RELATEDMARKETSEGMENTID_FH_IDX],
              { "RelatedMarketSegmentID", "eti.relatedmarketsegmentid",
                FT_INT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[RELATEDPRODUCTCOMPLEX_FH_IDX],
              { "RelatedProductComplex", "eti.relatedproductcomplex",
                FT_UINT8, BASE_DEC| BASE_EXT_STRING, &related_product_complex_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[RELATEDSECURITYID_FH_IDX],
              { "RelatedSecurityID", "eti.relatedsecurityid",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[RELATEDSYMBOL_FH_IDX],
              { "RelatedSymbol", "eti.relatedsymbol",
                FT_INT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[RELATEDTRADEID_FH_IDX],
              { "RelatedTradeID", "eti.relatedtradeid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[RELATEDTRADEQUANTITY_FH_IDX],
              { "RelatedTradeQuantity", "eti.relatedtradequantity",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[REQUESTTIME_FH_IDX],
              { "RequestTime", "eti.requesttime",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[REQUESTINGPARTYCLEARINGFIRM_FH_IDX],
              { "RequestingPartyClearingFirm", "eti.requestingpartyclearingfirm",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[REQUESTINGPARTYENTERINGFIRM_FH_IDX],
              { "RequestingPartyEnteringFirm", "eti.requestingpartyenteringfirm",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[REQUESTINGPARTYIDENTERINGFIRM_FH_IDX],
              { "RequestingPartyIDEnteringFirm", "eti.requestingpartyidenteringfirm",
                FT_UINT8, BASE_DEC, VALS(party_identering_firm_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[REQUESTINGPARTYIDEXECUTINGSYSTEM_FH_IDX],
              { "RequestingPartyIDExecutingSystem", "eti.requestingpartyidexecutingsystem",
                FT_UINT32, BASE_DEC, VALS(requesting_party_idexecuting_system_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[REQUESTINGPARTYIDEXECUTINGTRADER_FH_IDX],
              { "RequestingPartyIDExecutingTrader", "eti.requestingpartyidexecutingtrader",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[REQUESTINGPARTYSUBIDTYPE_FH_IDX],
              { "RequestingPartySubIDType", "eti.requestingpartysubidtype",
                FT_UINT16, BASE_DEC, VALS(requesting_party_sub_idtype_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[RESPONDENTTYPE_FH_IDX],
              { "RespondentType", "eti.respondenttype",
                FT_UINT8, BASE_DEC, VALS(respondent_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[RESPONSEIN_FH_IDX],
              { "ResponseIn", "eti.responsein",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[REVERSALAPPROVALTIME_FH_IDX],
              { "ReversalApprovalTime", "eti.reversalapprovaltime",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[REVERSALCANCELLATIONREASON_FH_IDX],
              { "ReversalCancellationReason", "eti.reversalcancellationreason",
                FT_UINT8, BASE_DEC, VALS(reversal_cancellation_reason_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[REVERSALINDICATOR_FH_IDX],
              { "ReversalIndicator", "eti.reversalindicator",
                FT_UINT8, BASE_DEC, VALS(bid_px_is_locked_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[REVERSALINITIATIONTIME_FH_IDX],
              { "ReversalInitiationTime", "eti.reversalinitiationtime",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[REVERSALREASONTEXT_FH_IDX],
              { "ReversalReasonText", "eti.reversalreasontext",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[RISKLIMITACTION_FH_IDX],
              { "RiskLimitAction", "eti.risklimitaction",
                FT_UINT8, BASE_DEC, VALS(risk_limit_action_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[RISKLIMITGROUP_FH_IDX],
              { "RiskLimitGroup", "eti.risklimitgroup",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[RISKLIMITNETPOSITIONQTY_FH_IDX],
              { "RiskLimitNetPositionQty", "eti.risklimitnetpositionqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[RISKLIMITOPENQTY_FH_IDX],
              { "RiskLimitOpenQty", "eti.risklimitopenqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[RISKLIMITPLATFORM_FH_IDX],
              { "RiskLimitPlatform", "eti.risklimitplatform",
                FT_UINT8, BASE_DEC, VALS(risk_limit_platform_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[RISKLIMITQTY_FH_IDX],
              { "RiskLimitQty", "eti.risklimitqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[RISKLIMITREPORTID_FH_IDX],
              { "RiskLimitReportID", "eti.risklimitreportid",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[RISKLIMITREQUESTINGPARTYROLE_FH_IDX],
              { "RiskLimitRequestingPartyRole", "eti.risklimitrequestingpartyrole",
                FT_UINT8, BASE_DEC, VALS(risk_limit_requesting_party_role_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[RISKLIMITTYPE_FH_IDX],
              { "RiskLimitType", "eti.risklimittype",
                FT_UINT8, BASE_DEC, VALS(risk_limit_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[RISKLIMITVIOLATIONINDICATOR_FH_IDX],
              { "RiskLimitViolationIndicator", "eti.risklimitviolationindicator",
                FT_UINT8, BASE_DEC, VALS(bid_px_is_locked_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ROOTPARTYCLEARINGFIRM_FH_IDX],
              { "RootPartyClearingFirm", "eti.rootpartyclearingfirm",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ROOTPARTYCLEARINGORGANIZATION_FH_IDX],
              { "RootPartyClearingOrganization", "eti.rootpartyclearingorganization",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ROOTPARTYCONTRAFIRM_FH_IDX],
              { "RootPartyContraFirm", "eti.rootpartycontrafirm",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ROOTPARTYCONTRATRADER_FH_IDX],
              { "RootPartyContraTrader", "eti.rootpartycontratrader",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ROOTPARTYENTERINGTRADER_FH_IDX],
              { "RootPartyEnteringTrader", "eti.rootpartyenteringtrader",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ROOTPARTYEXECUTINGFIRM_FH_IDX],
              { "RootPartyExecutingFirm", "eti.rootpartyexecutingfirm",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ROOTPARTYEXECUTINGTRADER_FH_IDX],
              { "RootPartyExecutingTrader", "eti.rootpartyexecutingtrader",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ROOTPARTYIDBENEFICIARY_FH_IDX],
              { "RootPartyIDBeneficiary", "eti.rootpartyidbeneficiary",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ROOTPARTYIDCLEARINGUNIT_FH_IDX],
              { "RootPartyIDClearingUnit", "eti.rootpartyidclearingunit",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ROOTPARTYIDCLIENTID_FH_IDX],
              { "RootPartyIDClientID", "eti.rootpartyidclientid",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ROOTPARTYIDEXECUTINGTRADER_FH_IDX],
              { "RootPartyIDExecutingTrader", "eti.rootpartyidexecutingtrader",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ROOTPARTYIDEXECUTINGUNIT_FH_IDX],
              { "RootPartyIDExecutingUnit", "eti.rootpartyidexecutingunit",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ROOTPARTYIDEXECUTIONVENUE_FH_IDX],
              { "RootPartyIDExecutionVenue", "eti.rootpartyidexecutionvenue",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ROOTPARTYIDINVESTMENTDECISIONMAKER_FH_IDX],
              { "RootPartyIDInvestmentDecisionMaker", "eti.rootpartyidinvestmentdecisionmaker",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ROOTPARTYIDINVESTMENTDECISIONMAKERQUALIFIER_FH_IDX],
              { "RootPartyIDInvestmentDecisionMakerQualifier", "eti.rootpartyidinvestmentdecisionmakerqualifier",
                FT_UINT8, BASE_DEC, VALS(executing_trader_qualifier_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ROOTPARTYIDORDERORIGINATIONFIRM_FH_IDX],
              { "RootPartyIDOrderOriginationFirm", "eti.rootpartyidorderoriginationfirm",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ROOTPARTYIDPOSITIONACCOUNT_FH_IDX],
              { "RootPartyIDPositionAccount", "eti.rootpartyidpositionaccount",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ROOTPARTYIDSESSIONID_FH_IDX],
              { "RootPartyIDSessionID", "eti.rootpartyidsessionid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ROOTPARTYIDTAKEUPTRADINGFIRM_FH_IDX],
              { "RootPartyIDTakeUpTradingFirm", "eti.rootpartyidtakeuptradingfirm",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[ROOTPARTYSUBIDTYPE_FH_IDX],
              { "RootPartySubIDType", "eti.rootpartysubidtype",
                FT_UINT16, BASE_DEC, VALS(root_party_sub_idtype_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SRQSRELATEDTRADEID_FH_IDX],
              { "SRQSRelatedTradeID", "eti.srqsrelatedtradeid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SECONDARYQUOTEID_FH_IDX],
              { "SecondaryQuoteID", "eti.secondaryquoteid",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SECONDARYTRADEID_FH_IDX],
              { "SecondaryTradeID", "eti.secondarytradeid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SECURITYID_FH_IDX],
              { "SecurityID", "eti.securityid",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SECURITYRESPONSEID_FH_IDX],
              { "SecurityResponseID", "eti.securityresponseid",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SECURITYSUBTYPE_FH_IDX],
              { "SecuritySubType", "eti.securitysubtype",
                FT_INT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SELECTIVEREQUESTFORQUOTERTMSERVICESTATUS_FH_IDX],
              { "SelectiveRequestForQuoteRtmServiceStatus", "eti.selectiverequestforquotertmservicestatus",
                FT_UINT8, BASE_DEC, VALS(appl_seq_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SELECTIVEREQUESTFORQUOTESERVICESTATUS_FH_IDX],
              { "SelectiveRequestForQuoteServiceStatus", "eti.selectiverequestforquoteservicestatus",
                FT_UINT8, BASE_DEC, VALS(appl_seq_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SELECTIVEREQUESTFORQUOTESERVICETRADEDATE_FH_IDX],
              { "SelectiveRequestForQuoteServiceTradeDate", "eti.selectiverequestforquoteservicetradedate",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SENDERSUBID_FH_IDX],
              { "SenderSubID", "eti.sendersubid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SENDINGTIME_FH_IDX],
              { "SendingTime", "eti.sendingtime",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SESSIONINSTANCEID_FH_IDX],
              { "SessionInstanceID", "eti.sessioninstanceid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SESSIONMODE_FH_IDX],
              { "SessionMode", "eti.sessionmode",
                FT_UINT8, BASE_DEC, VALS(session_mode_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SESSIONREJECTREASON_FH_IDX],
              { "SessionRejectReason", "eti.sessionrejectreason",
                FT_UINT32, BASE_DEC| BASE_EXT_STRING, &session_reject_reason_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SESSIONSTATUS_FH_IDX],
              { "SessionStatus", "eti.sessionstatus",
                FT_UINT8, BASE_DEC, VALS(session_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SESSIONSUBMODE_FH_IDX],
              { "SessionSubMode", "eti.sessionsubmode",
                FT_UINT8, BASE_DEC, VALS(session_sub_mode_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SETTLMETHOD_FH_IDX],
              { "SettlMethod", "eti.settlmethod",
                FT_CHAR, BASE_HEX, VALS(settl_method_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SHOWLASTDEALONCLOSURE_FH_IDX],
              { "ShowLastDealOnClosure", "eti.showlastdealonclosure",
                FT_UINT8, BASE_DEC, VALS(bid_px_is_locked_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SIDE_FH_IDX],
              { "Side", "eti.side",
                FT_UINT8, BASE_DEC, VALS(leg_side_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SIDECOMPLIANCETEXT_FH_IDX],
              { "SideComplianceText", "eti.sidecompliancetext",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SIDEDISCLOSUREINSTRUCTION_FH_IDX],
              { "SideDisclosureInstruction", "eti.sidedisclosureinstruction",
                FT_UINT8, BASE_DEC, VALS(bid_px_is_locked_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SIDEISLOCKED_FH_IDX],
              { "SideIsLocked", "eti.sideislocked",
                FT_UINT8, BASE_DEC, VALS(bid_px_is_locked_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SIDELASTPX_FH_IDX],
              { "SideLastPx", "eti.sidelastpx",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SIDELASTQTY_FH_IDX],
              { "SideLastQty", "eti.sidelastqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SIDELIQUIDITYIND_FH_IDX],
              { "SideLiquidityInd", "eti.sideliquidityind",
                FT_UINT8, BASE_DEC, VALS(quote_event_liquidity_ind_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SIDEMARKETSEGMENTID_FH_IDX],
              { "SideMarketSegmentID", "eti.sidemarketsegmentid",
                FT_INT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SIDETRADEID_FH_IDX],
              { "SideTradeID", "eti.sidetradeid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SIDETRDSUBTYP_FH_IDX],
              { "SideTrdSubTyp", "eti.sidetrdsubtyp",
                FT_UINT16, BASE_DEC, VALS(side_trd_sub_typ_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SIMPLESECURITYID_FH_IDX],
              { "SimpleSecurityID", "eti.simplesecurityid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SKIPVALIDATIONS_FH_IDX],
              { "SkipValidations", "eti.skipvalidations",
                FT_UINT8, BASE_DEC, VALS(appl_resend_flag_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[STOPPX_FH_IDX],
              { "StopPx", "eti.stoppx",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[STRATEGYLINKID_FH_IDX],
              { "StrategyLinkID", "eti.strategylinkid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[STRIKEPRICE_FH_IDX],
              { "StrikePrice", "eti.strikeprice",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SUBSCRIPTIONSCOPE_FH_IDX],
              { "SubscriptionScope", "eti.subscriptionscope",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[SWAPCLEARER_FH_IDX],
              { "SwapClearer", "eti.swapclearer",
                FT_UINT8, BASE_DEC, VALS(swap_clearer_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[T7ENTRYSERVICERTMSTATUS_FH_IDX],
              { "T7EntryServiceRtmStatus", "eti.t7entryservicertmstatus",
                FT_UINT8, BASE_DEC, VALS(appl_seq_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[T7ENTRYSERVICERTMTRADEDATE_FH_IDX],
              { "T7EntryServiceRtmTradeDate", "eti.t7entryservicertmtradedate",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[T7ENTRYSERVICESTATUS_FH_IDX],
              { "T7EntryServiceStatus", "eti.t7entryservicestatus",
                FT_UINT8, BASE_DEC, VALS(appl_seq_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[T7ENTRYSERVICETRADEDATE_FH_IDX],
              { "T7EntryServiceTradeDate", "eti.t7entryservicetradedate",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TESENRICHMENTRULEID_FH_IDX],
              { "TESEnrichmentRuleID", "eti.tesenrichmentruleid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TESEXECID_FH_IDX],
              { "TESExecID", "eti.tesexecid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TARGETPARTYENTERINGTRADER_FH_IDX],
              { "TargetPartyEnteringTrader", "eti.targetpartyenteringtrader",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TARGETPARTYEXECUTINGFIRM_FH_IDX],
              { "TargetPartyExecutingFirm", "eti.targetpartyexecutingfirm",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TARGETPARTYEXECUTINGTRADER_FH_IDX],
              { "TargetPartyExecutingTrader", "eti.targetpartyexecutingtrader",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TARGETPARTYIDDESKID_FH_IDX],
              { "TargetPartyIDDeskID", "eti.targetpartyiddeskid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TARGETPARTYIDEXECUTINGTRADER_FH_IDX],
              { "TargetPartyIDExecutingTrader", "eti.targetpartyidexecutingtrader",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TARGETPARTYIDSESSIONID_FH_IDX],
              { "TargetPartyIDSessionID", "eti.targetpartyidsessionid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TEMPLATEID_FH_IDX],
              { "TemplateID", "eti.templateid",
                FT_UINT16, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[THROTTLEDISCONNECTLIMIT_FH_IDX],
              { "ThrottleDisconnectLimit", "eti.throttledisconnectlimit",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[THROTTLENOMSGS_FH_IDX],
              { "ThrottleNoMsgs", "eti.throttlenomsgs",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[THROTTLETIMEINTERVAL_FH_IDX],
              { "ThrottleTimeInterval", "eti.throttletimeinterval",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TIMEINFORCE_FH_IDX],
              { "TimeInForce", "eti.timeinforce",
                FT_UINT8, BASE_DEC, VALS(time_in_force_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TOTNUMTRADEREPORTS_FH_IDX],
              { "TotNumTradeReports", "eti.totnumtradereports",
                FT_INT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRADSESEVENT_FH_IDX],
              { "TradSesEvent", "eti.tradsesevent",
                FT_UINT8, BASE_DEC, VALS(trad_ses_event_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRADSESMODE_FH_IDX],
              { "TradSesMode", "eti.tradsesmode",
                FT_UINT8, BASE_DEC, VALS(trad_ses_mode_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRADEAGGREGATIONTRANSTYPE_FH_IDX],
              { "TradeAggregationTransType", "eti.tradeaggregationtranstype",
                FT_UINT8, BASE_DEC, VALS(trade_aggregation_trans_type_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRADEALLOCSTATUS_FH_IDX],
              { "TradeAllocStatus", "eti.tradeallocstatus",
                FT_UINT8, BASE_DEC| BASE_EXT_STRING, &trade_alloc_status_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRADEDATE_FH_IDX],
              { "TradeDate", "eti.tradedate",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRADEID_FH_IDX],
              { "TradeID", "eti.tradeid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRADEMANAGERSTATUS_FH_IDX],
              { "TradeManagerStatus", "eti.trademanagerstatus",
                FT_UINT8, BASE_DEC, VALS(appl_seq_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRADEMANAGERTRADEDATE_FH_IDX],
              { "TradeManagerTradeDate", "eti.trademanagertradedate",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRADEPLATFORM_FH_IDX],
              { "TradePlatform", "eti.tradeplatform",
                FT_UINT8, BASE_DEC, VALS(trade_platform_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRADEPUBLISHINDICATOR_FH_IDX],
              { "TradePublishIndicator", "eti.tradepublishindicator",
                FT_UINT8, BASE_DEC, VALS(trade_publish_indicator_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRADEREPORTID_FH_IDX],
              { "TradeReportID", "eti.tradereportid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRADEREPORTTEXT_FH_IDX],
              { "TradeReportText", "eti.tradereporttext",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRADEREPORTTYPE_FH_IDX],
              { "TradeReportType", "eti.tradereporttype",
                FT_UINT8, BASE_DEC| BASE_EXT_STRING, &trade_report_type_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRADEREQUESTRESULT_FH_IDX],
              { "TradeRequestResult", "eti.traderequestresult",
                FT_UINT8, BASE_DEC, VALS(trade_request_result_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRADETOQUOTERATIO_FH_IDX],
              { "TradeToQuoteRatio", "eti.tradetoquoteratio",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRADETOQUOTERATIOPOSITION_FH_IDX],
              { "TradeToQuoteRatioPosition", "eti.tradetoquoteratioposition",
                FT_UINT16, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRADETOQUOTERATIORANKING_FH_IDX],
              { "TradeToQuoteRatioRanking", "eti.tradetoquoteratioranking",
                FT_UINT8, BASE_DEC, VALS(enlight_rfqavg_resp_rate_ranking_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRADETOREQUESTRATIO_FH_IDX],
              { "TradeToRequestRatio", "eti.tradetorequestratio",
                FT_UINT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRADINGCAPACITY_FH_IDX],
              { "TradingCapacity", "eti.tradingcapacity",
                FT_UINT8, BASE_DEC, VALS(trading_capacity_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRADINGSESSIONSUBID_FH_IDX],
              { "TradingSessionSubID", "eti.tradingsessionsubid",
                FT_UINT8, BASE_DEC, VALS(trading_session_sub_id_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRANSBKDTIME_FH_IDX],
              { "TransBkdTime", "eti.transbkdtime",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRANSACTTIME_FH_IDX],
              { "TransactTime", "eti.transacttime",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRANSACTIONDELAYINDICATOR_FH_IDX],
              { "TransactionDelayIndicator", "eti.transactiondelayindicator",
                FT_UINT8, BASE_DEC, VALS(transaction_delay_indicator_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRANSFERREASON_FH_IDX],
              { "TransferReason", "eti.transferreason",
                FT_UINT8, BASE_DEC, VALS(transfer_reason_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRDMATCHID_FH_IDX],
              { "TrdMatchID", "eti.trdmatchid",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRDREGTSENTRYTIME_FH_IDX],
              { "TrdRegTSEntryTime", "eti.trdregtsentrytime",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRDREGTSEXECUTIONTIME_FH_IDX],
              { "TrdRegTSExecutionTime", "eti.trdregtsexecutiontime",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRDREGTSTIMEIN_FH_IDX],
              { "TrdRegTSTimeIn", "eti.trdregtstimein",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRDREGTSTIMEOUT_FH_IDX],
              { "TrdRegTSTimeOut", "eti.trdregtstimeout",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRDREGTSTIMEPRIORITY_FH_IDX],
              { "TrdRegTSTimePriority", "eti.trdregtstimepriority",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRDRPTSTATUS_FH_IDX],
              { "TrdRptStatus", "eti.trdrptstatus",
                FT_UINT8, BASE_DEC| BASE_EXT_STRING, &trd_rpt_status_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRDTYPE_FH_IDX],
              { "TrdType", "eti.trdtype",
                FT_UINT16, BASE_DEC| BASE_EXT_STRING, &trd_type_vals_ext, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[TRIGGERED_FH_IDX],
              { "Triggered", "eti.triggered",
                FT_UINT8, BASE_DEC, VALS(triggered_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[UNDERLYINGCURRENCY_FH_IDX],
              { "UnderlyingCurrency", "eti.underlyingcurrency",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[UNDERLYINGDELTAPERCENTAGE_FH_IDX],
              { "UnderlyingDeltaPercentage", "eti.underlyingdeltapercentage",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[UNDERLYINGEFFECTIVEDELTAPERCENTAGE_FH_IDX],
              { "UnderlyingEffectiveDeltaPercentage", "eti.underlyingeffectivedeltapercentage",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[UNDERLYINGISSUER_FH_IDX],
              { "UnderlyingIssuer", "eti.underlyingissuer",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[UNDERLYINGMATURITYDATE_FH_IDX],
              { "UnderlyingMaturityDate", "eti.underlyingmaturitydate",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[UNDERLYINGPRICESTIPVALUE_FH_IDX],
              { "UnderlyingPriceStipValue", "eti.underlyingpricestipvalue",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[UNDERLYINGPX_FH_IDX],
              { "UnderlyingPx", "eti.underlyingpx",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[UNDERLYINGQTY_FH_IDX],
              { "UnderlyingQty", "eti.underlyingqty",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[UNDERLYINGSECURITYDESC_FH_IDX],
              { "UnderlyingSecurityDesc", "eti.underlyingsecuritydesc",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[UNDERLYINGSECURITYID_FH_IDX],
              { "UnderlyingSecurityID", "eti.underlyingsecurityid",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[UNDERLYINGSETTLEMENTDATE_FH_IDX],
              { "UnderlyingSettlementDate", "eti.underlyingsettlementdate",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[UNDERLYINGSTIPTYPE_FH_IDX],
              { "UnderlyingStipType", "eti.underlyingstiptype",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[UNDERLYINGSTIPVALUE_FH_IDX],
              { "UnderlyingStipValue", "eti.underlyingstipvalue",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[USERSTATUS_FH_IDX],
              { "UserStatus", "eti.userstatus",
                FT_UINT8, BASE_DEC, VALS(user_status_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[USERNAME_FH_IDX],
              { "Username", "eti.username",
                FT_UINT32, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[VALIDUNTILTIME_FH_IDX],
              { "ValidUntilTime", "eti.validuntiltime",
                FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[VALUECHECKTYPEMINLOTSIZE_FH_IDX],
              { "ValueCheckTypeMinLotSize", "eti.valuechecktypeminlotsize",
                FT_UINT8, BASE_DEC, VALS(value_check_type_min_lot_size_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[VALUECHECKTYPEVALUE_FH_IDX],
              { "ValueCheckTypeValue", "eti.valuechecktypevalue",
                FT_UINT8, BASE_DEC, VALS(value_check_type_min_lot_size_vals), 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[VARTEXT_FH_IDX],
              { "VarText", "eti.vartext",
                FT_STRINGZTRUNC, BASE_NONE, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[VARTEXTLEN_FH_IDX],
              { "VarTextLen", "eti.vartextlen",
                FT_UINT16, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti[VEGA_FH_IDX],
              { "Vega", "eti.vega",
                FT_INT64, BASE_DEC, NULL, 0x0,
                NULL, HFILL }
          }
        , { &hf_eti_dscp_exec_summary,
              { "DSCP_ExecSummary", "eti.dscp_execsummary",
                FT_BOOLEAN, 8, NULL, 0x10,
                NULL, HFILL }
          }
        , { &hf_eti_dscp_improved,
              { "DSCP_Improved", "eti.dscp_improved",
                FT_BOOLEAN, 8, NULL, 0x20,
                NULL, HFILL }
          }
        , { &hf_eti_dscp_widened,
              { "DSCP_Widened", "eti.dscp_widened",
                FT_BOOLEAN, 8, NULL, 0x40,
                NULL, HFILL }
          }
    };
    static ei_register_info ei[] = {
        {
            &ei_eti_counter_overflow,
            { "eti.counter_overflow", PI_PROTOCOL, PI_WARN, "Counter Overflow", EXPFILL }
        },
        {
            &ei_eti_invalid_template,
            { "eti.invalid_template", PI_PROTOCOL, PI_ERROR, "Invalid Template ID", EXPFILL }
        },
        {
            &ei_eti_invalid_length,
            { "eti.invalid_length", PI_PROTOCOL, PI_ERROR, "Invalid Body Length", EXPFILL }
        },
        {
            &ei_eti_unaligned,
            { "eti.unaligned", PI_PROTOCOL, PI_ERROR, "A Body Length not divisible by 8 leads to unaligned followup messages", EXPFILL }
        },
        {
            &ei_eti_missing,
            { "eti.missing", PI_PROTOCOL, PI_WARN, "A required value is missing", EXPFILL }
        },
        {
            &ei_eti_overused,
            { "eti.overused", PI_PROTOCOL, PI_WARN, "An unused value is set", EXPFILL }
        }
    };
    proto_eti = proto_register_protocol("Enhanced Trading Interface 10.0",
            "ETI", "eti");
    expert_module_t *expert_eti = expert_register_protocol(proto_eti);
    expert_register_field_array(expert_eti, ei, array_length(ei));
    proto_register_field_array(proto_eti, hf, array_length(hf));
    static gint * const ett[] = { &ett_eti[0], &ett_eti[1], &ett_eti[2], &ett_eti[3], &ett_eti[4], &ett_eti[5], &ett_eti[6], &ett_eti[7], &ett_eti[8], &ett_eti[9], &ett_eti[10], &ett_eti[11], &ett_eti[12], &ett_eti[13], &ett_eti[14], &ett_eti[15], &ett_eti[16], &ett_eti[17], &ett_eti[18], &ett_eti[19], &ett_eti[20], &ett_eti[21], &ett_eti[22], &ett_eti[23], &ett_eti[24], &ett_eti[25], &ett_eti[26], &ett_eti[27], &ett_eti[28], &ett_eti[29], &ett_eti[30], &ett_eti[31], &ett_eti[32], &ett_eti[33], &ett_eti[34], &ett_eti[35], &ett_eti[36], &ett_eti[37], &ett_eti[38], &ett_eti[39], &ett_eti[40], &ett_eti[41], &ett_eti[42], &ett_eti[43], &ett_eti[44], &ett_eti[45], &ett_eti[46], &ett_eti[47], &ett_eti[48], &ett_eti[49], &ett_eti[50], &ett_eti[51], &ett_eti[52], &ett_eti_dscp };
    proto_register_subtree_array(ett, array_length(ett));

    eti_handle = register_dissector("eti", dissect_eti, proto_eti);
}

void
proto_reg_handoff_eti(void)
{
    // cf. N7 Network Access Guide, e.g.
    // https://www.xetra.com/xetra-en/technology/t7/system-documentation/release10-0/Release-10.0-2692700?frag=2692724
    // https://www.xetra.com/resource/blob/2762078/388b727972b5122945eedf0e63c36920/data/N7-Network-Access-Guide-v2.0.59.pdf


    // NB: can only be called once for a port/handle pair ...
    // dissector_add_uint_with_preference("tcp.port", 19006 /* LF PROD */, eti_handle);

    dissector_add_uint("tcp.port", 19006 /* LF PROD */, eti_handle);
    dissector_add_uint("tcp.port", 19043 /* PS PROD */, eti_handle);
    dissector_add_uint("tcp.port", 19506 /* LF SIMU */, eti_handle);
    dissector_add_uint("tcp.port", 19543 /* PS SIMU */, eti_handle);
}
