/*  This file is autogenerated from ./taps by ./make-taps.py */
/* DO NOT EDIT! */

#include "config.h"

#include "wslua.h"

#include <wsutil/nstime.h>

#include "../dissectors/packet-ip.h"
static void wslua_ip_to_table(lua_State* L, const void* p) {
	const ws_ip4* v;

	v = (const ws_ip4*)p;
	lua_newtable(L);

	lua_pushstring(L,"ip_dst");
	{ Address a = (Address)g_malloc(sizeof(address)); copy_address(a, &(v->ip_dst)); pushAddress(L,a); }
	lua_settable(L,-3);
	lua_pushstring(L,"ip_id");
	lua_pushinteger(L,(lua_Integer)v->ip_id);
	lua_settable(L,-3);
	lua_pushstring(L,"ip_len");
	lua_pushinteger(L,(lua_Integer)v->ip_len);
	lua_settable(L,-3);
	lua_pushstring(L,"ip_off");
	lua_pushinteger(L,(lua_Integer)v->ip_off);
	lua_settable(L,-3);
	lua_pushstring(L,"ip_proto");
	lua_pushinteger(L,(lua_Integer)v->ip_proto);
	lua_settable(L,-3);
	lua_pushstring(L,"ip_src");
	{ Address a = (Address)g_malloc(sizeof(address)); copy_address(a, &(v->ip_src)); pushAddress(L,a); }
	lua_settable(L,-3);
	lua_pushstring(L,"ip_stream");
	lua_pushinteger(L,(lua_Integer)v->ip_stream);
	lua_settable(L,-3);
	lua_pushstring(L,"ip_sum");
	lua_pushinteger(L,(lua_Integer)v->ip_sum);
	lua_settable(L,-3);
	lua_pushstring(L,"ip_tos");
	lua_pushinteger(L,(lua_Integer)v->ip_tos);
	lua_settable(L,-3);
	lua_pushstring(L,"ip_ttl");
	lua_pushinteger(L,(lua_Integer)v->ip_ttl);
	lua_settable(L,-3);
	lua_pushstring(L,"ip_ver");
	lua_pushinteger(L,(lua_Integer)v->ip_ver);
	lua_settable(L,-3);
}

#include "../dissectors/packet-udp.h"
static void wslua_udp_to_table(lua_State* L, const void* p) {
	const e_udphdr* v;

	v = (const e_udphdr*)p;
	lua_newtable(L);

	lua_pushstring(L,"ip_dst");
	{ Address a = (Address)g_malloc(sizeof(address)); copy_address(a, &(v->ip_dst)); pushAddress(L,a); }
	lua_settable(L,-3);
	lua_pushstring(L,"ip_src");
	{ Address a = (Address)g_malloc(sizeof(address)); copy_address(a, &(v->ip_src)); pushAddress(L,a); }
	lua_settable(L,-3);
	lua_pushstring(L,"uh_dport");
	lua_pushinteger(L,(lua_Integer)v->uh_dport);
	lua_settable(L,-3);
	lua_pushstring(L,"uh_sport");
	lua_pushinteger(L,(lua_Integer)v->uh_sport);
	lua_settable(L,-3);
	lua_pushstring(L,"uh_stream");
	lua_pushinteger(L,(lua_Integer)v->uh_stream);
	lua_settable(L,-3);
	lua_pushstring(L,"uh_sum");
	lua_pushinteger(L,(lua_Integer)v->uh_sum);
	lua_settable(L,-3);
	lua_pushstring(L,"uh_sum_cov");
	lua_pushinteger(L,(lua_Integer)v->uh_sum_cov);
	lua_settable(L,-3);
	lua_pushstring(L,"uh_ulen");
	lua_pushinteger(L,(lua_Integer)v->uh_ulen);
	lua_settable(L,-3);
}

#include "../dissectors/packet-http.h"
static void wslua_http_to_table(lua_State* L, const void* p) {
	const http_info_value_t* v;

	v = (const http_info_value_t*)p;
	lua_newtable(L);

	lua_pushstring(L,"framenum");
	lua_pushinteger(L,(lua_Integer)v->framenum);
	lua_settable(L,-3);
	lua_pushstring(L,"full_uri");
	lua_pushstring(L,(const char*)v->full_uri);
	lua_settable(L,-3);
	lua_pushstring(L,"http_host");
	lua_pushstring(L,(const char*)v->http_host);
	lua_settable(L,-3);
	lua_pushstring(L,"location_base_uri");
	lua_pushstring(L,(const char*)v->location_base_uri);
	lua_settable(L,-3);
	lua_pushstring(L,"location_target");
	lua_pushstring(L,(const char*)v->location_target);
	lua_settable(L,-3);
	lua_pushstring(L,"referer_uri");
	lua_pushstring(L,(const char*)v->referer_uri);
	lua_settable(L,-3);
	lua_pushstring(L,"request_method");
	lua_pushstring(L,(const char*)v->request_method);
	lua_settable(L,-3);
	lua_pushstring(L,"request_uri");
	lua_pushstring(L,(const char*)v->request_uri);
	lua_settable(L,-3);
	lua_pushstring(L,"response_code");
	lua_pushinteger(L,(lua_Integer)v->response_code);
	lua_settable(L,-3);
}

#include "../dissectors/packet-bacapp.h"
static void wslua_bacapp_to_table(lua_State* L, const void* p) {
	const bacapp_info_value_t* v;

	v = (const bacapp_info_value_t*)p;
	lua_newtable(L);

	lua_pushstring(L,"instance_ident");
	lua_pushstring(L,(const char*)v->instance_ident);
	lua_settable(L,-3);
	lua_pushstring(L,"invoke_id");
	lua_pushstring(L,(const char*)v->invoke_id);
	lua_settable(L,-3);
	lua_pushstring(L,"object_ident");
	lua_pushstring(L,(const char*)v->object_ident);
	lua_settable(L,-3);
	lua_pushstring(L,"service_type");
	lua_pushstring(L,(const char*)v->service_type);
	lua_settable(L,-3);
}

#include "../dissectors/packet-h225.h"
static void wslua_h225_to_table(lua_State* L, const void* p) {
	const h225_packet_info* v;

	v = (const h225_packet_info*)p;
	lua_newtable(L);

	lua_pushstring(L,"cs_type");
	lua_pushinteger(L,(lua_Integer)v->cs_type); /* h225_cs_type */
	lua_settable(L,-3);
	lua_pushstring(L,"delta_time");
	lua_pushnumber(L,(lua_Number)nstime_to_sec(&(v->delta_time)));
	lua_settable(L,-3);
	lua_pushstring(L,"dialedDigits");
	lua_pushstring(L,(const char*)v->dialedDigits);
	lua_settable(L,-3);
	lua_pushstring(L,"frame_label");
	lua_pushstring(L,(const char*)v->frame_label);
	lua_settable(L,-3);
	lua_pushstring(L,"h245_address");
	lua_pushinteger(L,(lua_Integer)v->h245_address);
	lua_settable(L,-3);
	lua_pushstring(L,"h245_port");
	lua_pushinteger(L,(lua_Integer)v->h245_port);
	lua_settable(L,-3);
	lua_pushstring(L,"is_destinationInfo");
	lua_pushboolean(L,(int)v->is_destinationInfo);
	lua_settable(L,-3);
	lua_pushstring(L,"is_duplicate");
	lua_pushboolean(L,(int)v->is_duplicate);
	lua_settable(L,-3);
	lua_pushstring(L,"is_faststart");
	lua_pushboolean(L,(int)v->is_faststart);
	lua_settable(L,-3);
	lua_pushstring(L,"is_h245");
	lua_pushboolean(L,(int)v->is_h245);
	lua_settable(L,-3);
	lua_pushstring(L,"msg_tag");
	lua_pushinteger(L,(lua_Integer)v->msg_tag);
	lua_settable(L,-3);
	lua_pushstring(L,"msg_type");
	lua_pushinteger(L,(lua_Integer)v->msg_type); /* h225_msg_type */
	lua_settable(L,-3);
	lua_pushstring(L,"reason");
	lua_pushinteger(L,(lua_Integer)v->reason);
	lua_settable(L,-3);
	lua_pushstring(L,"requestSeqNum");
	lua_pushinteger(L,(lua_Integer)v->requestSeqNum);
	lua_settable(L,-3);
	lua_pushstring(L,"request_available");
	lua_pushboolean(L,(int)v->request_available);
	lua_settable(L,-3);
}

#include "../dissectors/packet-actrace.h"
static void wslua_actrace_to_table(lua_State* L, const void* p) {
	const actrace_info_t* v;

	v = (const actrace_info_t*)p;
	lua_newtable(L);

	lua_pushstring(L,"cas_bchannel");
	lua_pushinteger(L,(lua_Integer)v->cas_bchannel);
	lua_settable(L,-3);
	lua_pushstring(L,"cas_frame_label");
	lua_pushstring(L,(const char*)v->cas_frame_label);
	lua_settable(L,-3);
	lua_pushstring(L,"direction");
	lua_pushinteger(L,(lua_Integer)v->direction);
	lua_settable(L,-3);
	lua_pushstring(L,"trunk");
	lua_pushinteger(L,(lua_Integer)v->trunk);
	lua_settable(L,-3);
	lua_pushstring(L,"type");
	lua_pushinteger(L,(lua_Integer)v->type);
	lua_settable(L,-3);
}

#include "../dissectors/packet-ansi_a.h"
static void wslua_ansi_a_to_table(lua_State* L, const void* p) {
	const ansi_a_tap_rec_t* v;

	v = (const ansi_a_tap_rec_t*)p;
	lua_newtable(L);

	lua_pushstring(L,"message_type");
	lua_pushinteger(L,(lua_Integer)v->message_type);
	lua_settable(L,-3);
	lua_pushstring(L,"pdu_type");
	lua_pushinteger(L,(lua_Integer)v->pdu_type);
	lua_settable(L,-3);
}

#include "../dissectors/packet-ansi_map.h"
static void wslua_ansi_map_to_table(lua_State* L, const void* p) {
	const ansi_map_tap_rec_t* v;

	v = (const ansi_map_tap_rec_t*)p;
	lua_newtable(L);

	lua_pushstring(L,"message_type");
	lua_pushinteger(L,(lua_Integer)v->message_type);
	lua_settable(L,-3);
	lua_pushstring(L,"size");
	lua_pushinteger(L,(lua_Integer)v->size);
	lua_settable(L,-3);
}

#include "../dissectors/packet-eth.h"
static void wslua_eth_to_table(lua_State* L, const void* p) {
	const eth_hdr* v;

	v = (const eth_hdr*)p;
	lua_newtable(L);

	lua_pushstring(L,"dst");
	{ Address a = (Address)g_malloc(sizeof(address)); copy_address(a, &(v->dst)); pushAddress(L,a); }
	lua_settable(L,-3);
	lua_pushstring(L,"src");
	{ Address a = (Address)g_malloc(sizeof(address)); copy_address(a, &(v->src)); pushAddress(L,a); }
	lua_settable(L,-3);
	lua_pushstring(L,"stream");
	lua_pushinteger(L,(lua_Integer)v->stream);
	lua_settable(L,-3);
	lua_pushstring(L,"type");
	lua_pushinteger(L,(lua_Integer)v->type);
	lua_settable(L,-3);
}

#include "../dissectors/packet-ldap.h"
static void wslua_ldap_to_table(lua_State* L, const void* p) {
	const ldap_call_response_t* v;

	v = (const ldap_call_response_t*)p;
	lua_newtable(L);

	lua_pushstring(L,"is_request");
	lua_pushboolean(L,(int)v->is_request);
	lua_settable(L,-3);
	lua_pushstring(L,"messageId");
	lua_pushinteger(L,(lua_Integer)v->messageId);
	lua_settable(L,-3);
	lua_pushstring(L,"protocolOpTag");
	lua_pushinteger(L,(lua_Integer)v->protocolOpTag);
	lua_settable(L,-3);
	lua_pushstring(L,"rep_frame");
	lua_pushinteger(L,(lua_Integer)v->rep_frame);
	lua_settable(L,-3);
	lua_pushstring(L,"req_frame");
	lua_pushinteger(L,(lua_Integer)v->req_frame);
	lua_settable(L,-3);
	lua_pushstring(L,"req_time");
	lua_pushnumber(L,(lua_Number)nstime_to_sec(&(v->req_time)));
	lua_settable(L,-3);
}

#include "../dissectors/packet-smb.h"
static void wslua_smb_to_table(lua_State* L, const void* p) {
	const smb_info_t* v;

	v = (const smb_info_t*)p;
	lua_newtable(L);

	lua_pushstring(L,"cmd");
	lua_pushinteger(L,(lua_Integer)v->cmd);
	lua_settable(L,-3);
	lua_pushstring(L,"info_count");
	lua_pushinteger(L,(lua_Integer)v->info_count);
	lua_settable(L,-3);
	lua_pushstring(L,"info_level");
	lua_pushinteger(L,(lua_Integer)v->info_level);
	lua_settable(L,-3);
	lua_pushstring(L,"nt_status");
	lua_pushinteger(L,(lua_Integer)v->nt_status);
	lua_settable(L,-3);
	lua_pushstring(L,"request");
	lua_pushboolean(L,(int)v->request);
	lua_settable(L,-3);
	lua_pushstring(L,"unicode");
	lua_pushboolean(L,(int)v->unicode);
	lua_settable(L,-3);
	lua_pushstring(L,"unidir");
	lua_pushboolean(L,(int)v->unidir);
	lua_settable(L,-3);
}

#include "../dissectors/packet-smb2.h"
static void wslua_smb2_to_table(lua_State* L, const void* p) {
	const smb2_info_t* v;

	v = (const smb2_info_t*)p;
	lua_newtable(L);

	lua_pushstring(L,"flags");
	lua_pushinteger(L,(lua_Integer)v->flags);
	lua_settable(L,-3);
	lua_pushstring(L,"ioctl_function");
	lua_pushinteger(L,(lua_Integer)v->ioctl_function);
	lua_settable(L,-3);
	lua_pushstring(L,"opcode");
	lua_pushinteger(L,(lua_Integer)v->opcode);
	lua_settable(L,-3);
	lua_pushstring(L,"status");
	lua_pushinteger(L,(lua_Integer)v->status);
	lua_settable(L,-3);
	lua_pushstring(L,"tid");
	lua_pushinteger(L,(lua_Integer)v->tid);
	lua_settable(L,-3);
}

#include "../dissectors/packet-tcp.h"
static void wslua_tcp_to_table(lua_State* L, const void* p) {
	const tcp_info_t* v;

	v = (const tcp_info_t*)p;
	lua_newtable(L);

	lua_pushstring(L,"ip_dst");
	{ Address a = (Address)g_malloc(sizeof(address)); copy_address(a, &(v->ip_dst)); pushAddress(L,a); }
	lua_settable(L,-3);
	lua_pushstring(L,"ip_src");
	{ Address a = (Address)g_malloc(sizeof(address)); copy_address(a, &(v->ip_src)); pushAddress(L,a); }
	lua_settable(L,-3);
	lua_pushstring(L,"num_sack_ranges");
	lua_pushinteger(L,(lua_Integer)v->num_sack_ranges);
	lua_settable(L,-3);
	lua_pushstring(L,"th_ack");
	lua_pushinteger(L,(lua_Integer)v->th_ack);
	lua_settable(L,-3);
	lua_pushstring(L,"th_dport");
	lua_pushinteger(L,(lua_Integer)v->th_dport);
	lua_settable(L,-3);
	lua_pushstring(L,"th_flags");
	lua_pushinteger(L,(lua_Integer)v->th_flags);
	lua_settable(L,-3);
	lua_pushstring(L,"th_have_seglen");
	lua_pushboolean(L,(int)v->th_have_seglen);
	lua_settable(L,-3);
	lua_pushstring(L,"th_hlen");
	lua_pushinteger(L,(lua_Integer)v->th_hlen);
	lua_settable(L,-3);
	lua_pushstring(L,"th_rawack");
	lua_pushinteger(L,(lua_Integer)v->th_rawack);
	lua_settable(L,-3);
	lua_pushstring(L,"th_rawseq");
	lua_pushinteger(L,(lua_Integer)v->th_rawseq);
	lua_settable(L,-3);
	lua_pushstring(L,"th_seglen");
	lua_pushinteger(L,(lua_Integer)v->th_seglen);
	lua_settable(L,-3);
	lua_pushstring(L,"th_seq");
	lua_pushinteger(L,(lua_Integer)v->th_seq);
	lua_settable(L,-3);
	lua_pushstring(L,"th_sport");
	lua_pushinteger(L,(lua_Integer)v->th_sport);
	lua_settable(L,-3);
	lua_pushstring(L,"th_stream");
	lua_pushinteger(L,(lua_Integer)v->th_stream);
	lua_settable(L,-3);
	lua_pushstring(L,"th_use_ace");
	lua_pushboolean(L,(int)v->th_use_ace);
	lua_settable(L,-3);
	lua_pushstring(L,"th_win");
	lua_pushinteger(L,(lua_Integer)v->th_win);
	lua_settable(L,-3);
}

#include "../dissectors/packet-ieee80211.h"
static void wslua_wlan_to_table(lua_State* L, const void* p) {
	const wlan_hdr_t* v;

	v = (const wlan_hdr_t*)p;
	lua_newtable(L);

	lua_pushstring(L,"bssid");
	{ Address a = (Address)g_malloc(sizeof(address)); copy_address(a, &(v->bssid)); pushAddress(L,a); }
	lua_settable(L,-3);
	lua_pushstring(L,"dst");
	{ Address a = (Address)g_malloc(sizeof(address)); copy_address(a, &(v->dst)); pushAddress(L,a); }
	lua_settable(L,-3);
	lua_pushstring(L,"src");
	{ Address a = (Address)g_malloc(sizeof(address)); copy_address(a, &(v->src)); pushAddress(L,a); }
	lua_settable(L,-3);
	lua_pushstring(L,"type");
	lua_pushinteger(L,(lua_Integer)v->type);
	lua_settable(L,-3);
}

static tappable_t tappables[] =  {
	{"actrace", wslua_actrace_to_table },
	{"ansi_a", wslua_ansi_a_to_table },
	{"ansi_map", wslua_ansi_map_to_table },
	{"bacapp", wslua_bacapp_to_table },
	{"eth", wslua_eth_to_table },
	{"h225", wslua_h225_to_table },
	{"http", wslua_http_to_table },
	{"ip", wslua_ip_to_table },
	{"ldap", wslua_ldap_to_table },
	{"smb", wslua_smb_to_table },
	{"smb2", wslua_smb2_to_table },
	{"tcp", wslua_tcp_to_table },
	{"udp", wslua_udp_to_table },
	{"wlan", wslua_wlan_to_table },
	{"frame",NULL},
	{NULL,NULL}
};

int wslua_set_tap_enums(lua_State* L) {

	/*
	 * h225_cs_type
	 */
	lua_newtable(L);
	lua_pushinteger(L,(lua_Integer)H225_SETUP);
	lua_setglobal(L,"H225_SETUP");
	lua_pushinteger(L,(lua_Integer)H225_SETUP);
	lua_pushstring(L,"H225_SETUP");
	lua_settable(L,-3);
	lua_pushinteger(L,(lua_Integer)H225_CALL_PROCEDING);
	lua_setglobal(L,"H225_CALL_PROCEDING");
	lua_pushinteger(L,(lua_Integer)H225_CALL_PROCEDING);
	lua_pushstring(L,"H225_CALL_PROCEDING");
	lua_settable(L,-3);
	lua_pushinteger(L,(lua_Integer)H225_CONNECT);
	lua_setglobal(L,"H225_CONNECT");
	lua_pushinteger(L,(lua_Integer)H225_CONNECT);
	lua_pushstring(L,"H225_CONNECT");
	lua_settable(L,-3);
	lua_pushinteger(L,(lua_Integer)H225_ALERTING);
	lua_setglobal(L,"H225_ALERTING");
	lua_pushinteger(L,(lua_Integer)H225_ALERTING);
	lua_pushstring(L,"H225_ALERTING");
	lua_settable(L,-3);
	lua_pushinteger(L,(lua_Integer)H225_INFORMATION);
	lua_setglobal(L,"H225_INFORMATION");
	lua_pushinteger(L,(lua_Integer)H225_INFORMATION);
	lua_pushstring(L,"H225_INFORMATION");
	lua_settable(L,-3);
	lua_pushinteger(L,(lua_Integer)H225_RELEASE_COMPLET);
	lua_setglobal(L,"H225_RELEASE_COMPLET");
	lua_pushinteger(L,(lua_Integer)H225_RELEASE_COMPLET);
	lua_pushstring(L,"H225_RELEASE_COMPLET");
	lua_settable(L,-3);
	lua_pushinteger(L,(lua_Integer)H225_FACILITY);
	lua_setglobal(L,"H225_FACILITY");
	lua_pushinteger(L,(lua_Integer)H225_FACILITY);
	lua_pushstring(L,"H225_FACILITY");
	lua_settable(L,-3);
	lua_pushinteger(L,(lua_Integer)H225_PROGRESS);
	lua_setglobal(L,"H225_PROGRESS");
	lua_pushinteger(L,(lua_Integer)H225_PROGRESS);
	lua_pushstring(L,"H225_PROGRESS");
	lua_settable(L,-3);
	lua_pushinteger(L,(lua_Integer)H225_EMPTY);
	lua_setglobal(L,"H225_EMPTY");
	lua_pushinteger(L,(lua_Integer)H225_EMPTY);
	lua_pushstring(L,"H225_EMPTY");
	lua_settable(L,-3);
	lua_pushinteger(L,(lua_Integer)H225_STATUS);
	lua_setglobal(L,"H225_STATUS");
	lua_pushinteger(L,(lua_Integer)H225_STATUS);
	lua_pushstring(L,"H225_STATUS");
	lua_settable(L,-3);
	lua_pushinteger(L,(lua_Integer)H225_STATUS_INQUIRY);
	lua_setglobal(L,"H225_STATUS_INQUIRY");
	lua_pushinteger(L,(lua_Integer)H225_STATUS_INQUIRY);
	lua_pushstring(L,"H225_STATUS_INQUIRY");
	lua_settable(L,-3);
	lua_pushinteger(L,(lua_Integer)H225_SETUP_ACK);
	lua_setglobal(L,"H225_SETUP_ACK");
	lua_pushinteger(L,(lua_Integer)H225_SETUP_ACK);
	lua_pushstring(L,"H225_SETUP_ACK");
	lua_settable(L,-3);
	lua_pushinteger(L,(lua_Integer)H225_NOTIFY);
	lua_setglobal(L,"H225_NOTIFY");
	lua_pushinteger(L,(lua_Integer)H225_NOTIFY);
	lua_pushstring(L,"H225_NOTIFY");
	lua_settable(L,-3);
	lua_pushinteger(L,(lua_Integer)H225_OTHER);
	lua_setglobal(L,"H225_OTHER");
	lua_pushinteger(L,(lua_Integer)H225_OTHER);
	lua_pushstring(L,"H225_OTHER");
	lua_settable(L,-3);
	lua_setglobal(L,"h225_cs_type");

	/*
	 * h225_msg_type
	 */
	lua_newtable(L);
	lua_pushinteger(L,(lua_Integer)H225_RAS);
	lua_setglobal(L,"H225_RAS");
	lua_pushinteger(L,(lua_Integer)H225_RAS);
	lua_pushstring(L,"H225_RAS");
	lua_settable(L,-3);
	lua_pushinteger(L,(lua_Integer)H225_CS);
	lua_setglobal(L,"H225_CS");
	lua_pushinteger(L,(lua_Integer)H225_CS);
	lua_pushstring(L,"H225_CS");
	lua_settable(L,-3);
	lua_pushinteger(L,(lua_Integer)H225_OTHERS);
	lua_setglobal(L,"H225_OTHERS");
	lua_pushinteger(L,(lua_Integer)H225_OTHERS);
	lua_pushstring(L,"H225_OTHERS");
	lua_settable(L,-3);
	lua_setglobal(L,"h225_msg_type");
	return 0;
}


tap_extractor_t wslua_get_tap_extractor(const gchar* name) {
	tappable_t* t;
	for(t = tappables; t->name; t++ ) {
		if (g_str_equal(t->name,name)) return t->extractor;
	}

	return NULL;
}
