from saleae.data import AnalogData
from .measurer import Measurer

class AnalogMeasurer(Measurer):
    sample_count: int

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.processed_sample_count = 0

    def _process_data(self, data: AnalogData):
        self.process_data(data)
        self.processed_sample_count += data.sample_count

    def process_data(self, data: AnalogData):
        for sample, n in zip(data, range(self.processed_sample_count, self.processed_sample_count + data.sample_count)):
            self.process_sample(sample, n)

    def process_sample(self, sample: float, index: int):
        raise NotImplementedError('process_sample must be implemented')