import * as ts from "typescript/lib/tsserverlibrary"

import type {GetElementTypeResponse, GetSymbolTypeResponse, Range} from "./protocol"
import {ReverseMapper} from "./ide-get-element-type"

declare global {
  type RegularMap<K, V> = Map<K, V>
}

declare module "typescript/lib/tsserverlibrary" {

  interface TypeChecker {
    webStormCacheInfo?: {
      ideTypeCheckerId: number,
      requestedTypeIds: Set<number>,
      seenTypeIds: RegularMap<number, Type>,
      seenSymbolIds: RegularMap<number, Symbol>,
    }
  }

  interface Type {
    id: number | undefined // internal
  }

  interface LanguageService {

    webStormGetElementType(
      ts: typeof import("typescript/lib/tsserverlibrary"),
      fileName: string,
      startOffset: number,
      endOffset: number,
      forceReturnType: boolean,
      reverseMapper?: ReverseMapper,
    ): GetElementTypeResponse

    webStormGetSymbolType(
      ts: typeof import("typescript/lib/tsserverlibrary"),
      symbolId: number,
      reverseMapper?: ReverseMapper,
    ): GetSymbolTypeResponse

    webStormGetTypeProperties(
      ts: typeof import("typescript/lib/tsserverlibrary"),
      typeId: number,
      reverseMapper?: ReverseMapper,
    ): GetElementTypeResponse
  }
}

export = ts;