"use strict";
exports.__esModule = true;
exports.getTypePropertiesTsServer = exports.getSymbolTypeTsServer = exports.getElementTypeTsServer = exports.decorateLanguageService = void 0;
var ide_get_element_type_1 = require("./ide-get-element-type");
var decoratedLanguageServices = new WeakSet();
function decorateLanguageService(languageService) {
    if (decoratedLanguageServices.has(languageService)) {
        return;
    }
    decoratedLanguageServices.add(languageService);
    languageService.webStormGetElementType = function (ts, fileName, startOffset, endOffset, forceReturnType, reverseMapper) {
        // see getQuickInfoAtPosition
        var program = languageService.getProgram();
        if (!program) {
            return undefined;
        }
        var sourceFile = program.getSourceFile(fileName);
        if (!sourceFile) {
            return undefined;
        }
        return (0, ide_get_element_type_1.getElementTypeByOffsets)(ts, program, sourceFile, startOffset, endOffset, forceReturnType, reverseMapper);
    };
    languageService.webStormGetSymbolType = function (ts, symbolId, reverseMapper) {
        var program = languageService.getProgram();
        if (!program) {
            return undefined;
        }
        return (0, ide_get_element_type_1.getSymbolType)(ts, program, symbolId, reverseMapper);
    };
    languageService.webStormGetTypeProperties = function (ts, typeId, reverseMapper) {
        var program = languageService.getProgram();
        if (!program) {
            return undefined;
        }
        return (0, ide_get_element_type_1.getTypeProperties)(ts, program, typeId, reverseMapper);
    };
}
exports.decorateLanguageService = decorateLanguageService;
function getElementTypeTsServer(ts, projectService, request) {
    var _a;
    var requestArguments = request.arguments;
    var fileName = ts.server.toNormalizedPath(requestArguments.file);
    var evalLocationPath = ts.server.toNormalizedPath(requestArguments.evalLocation);
    var project = projectService.getDefaultProjectForFile(evalLocationPath, true);
    if (!project) {
        return undefined;
    }
    var range = requestArguments.range;
    var sourceFile = (_a = project.getLanguageService(true).getProgram()) === null || _a === void 0 ? void 0 : _a.getSourceFile(fileName);
    if (!sourceFile)
        return undefined;
    var startOffset = ts.getPositionOfLineAndCharacter(sourceFile, range.start.line, range.start.character);
    var endOffset = ts.getPositionOfLineAndCharacter(sourceFile, range.end.line, range.end.character);
    return project.getLanguageService().webStormGetElementType(ts, fileName, startOffset, endOffset, requestArguments.forceReturnType);
}
exports.getElementTypeTsServer = getElementTypeTsServer;
function getSymbolTypeTsServer(ts, projectService, request) {
    var requestArguments = request.arguments;
    var languageService = findLanguageService(projectService, requestArguments.ideTypeCheckerId);
    if (!languageService) {
        return undefined;
    }
    return languageService.webStormGetSymbolType(ts, requestArguments.symbolId);
}
exports.getSymbolTypeTsServer = getSymbolTypeTsServer;
function getTypePropertiesTsServer(ts, projectService, request) {
    var requestArguments = request.arguments;
    var languageService = findLanguageService(projectService, requestArguments.ideTypeCheckerId);
    if (!languageService) {
        return undefined;
    }
    return languageService.webStormGetTypeProperties(ts, requestArguments.typeId);
}
exports.getTypePropertiesTsServer = getTypePropertiesTsServer;
function findLanguageService(projectService, ideTypeCheckerId) {
    var _a, _b, _c, _d, _e, _f;
    var configuredProjects = projectService.configuredProjects.values();
    while (true) {
        var next = configuredProjects.next();
        if (next.done) {
            break;
        }
        else {
            var program = next.value.getLanguageService().getProgram();
            if (((_b = (_a = program === null || program === void 0 ? void 0 : program.getTypeChecker()) === null || _a === void 0 ? void 0 : _a.webStormCacheInfo) === null || _b === void 0 ? void 0 : _b.ideTypeCheckerId) == ideTypeCheckerId) {
                return next.value.getLanguageService();
            }
        }
    }
    for (var _i = 0, _g = projectService.inferredProjects; _i < _g.length; _i++) {
        var inferredProject = _g[_i];
        var program = inferredProject.getLanguageService().getProgram();
        if (((_d = (_c = program === null || program === void 0 ? void 0 : program.getTypeChecker()) === null || _c === void 0 ? void 0 : _c.webStormCacheInfo) === null || _d === void 0 ? void 0 : _d.ideTypeCheckerId) == ideTypeCheckerId) {
            return inferredProject.getLanguageService();
        }
    }
    for (var _h = 0, _j = projectService.externalProjects; _h < _j.length; _h++) {
        var externalProject = _j[_h];
        var program = externalProject.getLanguageService().getProgram();
        if (((_f = (_e = program === null || program === void 0 ? void 0 : program.getTypeChecker()) === null || _e === void 0 ? void 0 : _e.webStormCacheInfo) === null || _f === void 0 ? void 0 : _f.ideTypeCheckerId) == ideTypeCheckerId) {
            return externalProject.getLanguageService();
        }
    }
}
//# sourceMappingURL=get-element-type-ts-server.js.map