function scrollToElement(className, requestedElementCoordinates) {
  const items = document.getElementsByClassName(className);
  for (let itemIndex = 0; itemIndex < items.length; itemIndex++) {
    const navigationTarget = items.item(itemIndex);
    const elementData = processModel(navigationTarget, className) || processEndpoint(navigationTarget, className);

    if (elementData && elementData === requestedElementCoordinates) {
      window.scrollTo({
                        top: computeAbsoluteOffset(navigationTarget),
                        behavior: 'smooth'
                      });
      return;
    }
  }
}

function computeAbsoluteOffset(element) {
  let offset = 0
  do {
    offset += element.offsetTop || 0;
    element = element.offsetParent;
  }
  while (element);

  // add a half of viewport's height so that element will appear in the middle of the screen
  offset = Math.max(0, offset - Math.trunc(window.innerHeight / 2))
  return offset
}