/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.watcher;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Consumer;
import com.intellij.util.indexing.FileContent;
import com.jetbrains.plugins.jade.JadeToPugTransitionHelper;
import com.jetbrains.plugins.jade.psi.JadeElementTypes;
import com.jetbrains.plugins.jade.psi.JadeFileImpl;
import com.jetbrains.plugins.jade.psi.JadeFileType;
import com.jetbrains.plugins.jade.psi.impl.JadeIncludeStatementImpl;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JadeFileIncludeProvider
extends FileIncludeProvider {
    @NotNull
    public String getId() {
        return "jade";
    }

    public boolean acceptFile(@NotNull VirtualFile file) {
        if (file == null) {
            JadeFileIncludeProvider.$$$reportNull$$$0(0);
        }
        return file.getFileType() instanceof JadeFileType;
    }

    public void registerFileTypesUsedForIndexing(@NotNull Consumer<? super FileType> fileTypeSink) {
        if (fileTypeSink == null) {
            JadeFileIncludeProvider.$$$reportNull$$$0(1);
        }
        fileTypeSink.consume((Object)JadeFileType.INSTANCE);
    }

    public FileIncludeInfo @NotNull [] getIncludeInfos(@NotNull FileContent content) {
        PsiFile psiFile;
        if (content == null) {
            JadeFileIncludeProvider.$$$reportNull$$$0(2);
        }
        if ((psiFile = content.getPsiFile()) instanceof JadeFileImpl) {
            FileIncludeInfo[] fileIncludeInfoArray = JadeFileIncludeProvider.getIncludeInfos((JadeFileImpl)psiFile);
            if (fileIncludeInfoArray == null) {
                JadeFileIncludeProvider.$$$reportNull$$$0(3);
            }
            return fileIncludeInfoArray;
        }
        if (FileIncludeInfo.EMPTY == null) {
            JadeFileIncludeProvider.$$$reportNull$$$0(4);
        }
        return FileIncludeInfo.EMPTY;
    }

    private static FileIncludeInfo[] getIncludeInfos(final JadeFileImpl file) {
        final ArrayList result = new ArrayList();
        final String fileExtension = "." + JadeToPugTransitionHelper.getExtension((PsiFile)file);
        file.acceptChildren((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element == PsiUtilCore.NULL_PSI_ELEMENT) {
                    throw new IllegalStateException("file " + file + " (" + ((Object)((Object)file)).getClass() + ") must not have " + element + " among its children");
                }
                if (element instanceof JadeIncludeStatementImpl) {
                    String path = JadeFileIncludeProvider.extractPath(fileExtension, (JadeIncludeStatementImpl)element);
                    if (path != null) {
                        result.add(new FileIncludeInfo(path));
                    }
                } else {
                    super.visitElement(element);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/plugins/jade/watcher/JadeFileIncludeProvider$1", "visitElement"));
            }
        });
        return result.toArray(FileIncludeInfo.EMPTY);
    }

    @Nullable
    private static String extractPath(@NotNull String fileExtension, @NotNull JadeIncludeStatementImpl includeStatement) {
        PsiElement[] children;
        if (fileExtension == null) {
            JadeFileIncludeProvider.$$$reportNull$$$0(5);
        }
        if (includeStatement == null) {
            JadeFileIncludeProvider.$$$reportNull$$$0(6);
        }
        for (PsiElement child : children = includeStatement.getChildren()) {
            ASTNode node;
            if (!(child instanceof ASTNode) || (node = (ASTNode)child).getElementType() != JadeElementTypes.FILE_PATH) continue;
            Object path = child.getText();
            if (!((String)path).endsWith(fileExtension)) {
                path = (String)path + fileExtension;
            }
            return path;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeSink";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/jade/watcher/JadeFileIncludeProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileExtension";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/jade/watcher/JadeFileIncludeProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludeInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerFileTypesUsedForIndexing";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIncludeInfos";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "extractPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

