/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.js;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.ecmascript6.parsing.ES6ExpressionParser;
import com.intellij.lang.ecmascript6.parsing.ES6FunctionParser;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.ecmascript6.parsing.ES6StatementParser;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.psi.tree.IElementType;
import com.intellij.xml.psi.XmlPsiBundle;
import com.jetbrains.plugins.jade.JadeBundle;
import com.jetbrains.plugins.jade.js.JavaScriptInJadeLanguageDialect;
import com.jetbrains.plugins.jade.psi.JadeElementTypes;
import com.jetbrains.plugins.jade.psi.JadeTokenTypes;

public class JavaScriptInJadeParser
extends ES6Parser<ES6ExpressionParser, JavaScriptInJadeStatementParser, ES6FunctionParser, JSPsiTypeParser> {
    public JavaScriptInJadeParser(PsiBuilder builder) {
        super((JSLanguageDialect)JavaScriptInJadeLanguageDialect.INSTANCE, builder);
        this.myStatementParser = new JavaScriptInJadeStatementParser(this);
        this.myExpressionParser = new JavaScriptInJadeExpressionParser(this);
    }

    public void parseExpression() {
        PsiBuilder.Marker marker = this.builder.mark();
        ((ES6ExpressionParser)this.getExpressionParser()).parseExpression();
        this.closeWrapperMarker(marker);
    }

    public void parseForeach() {
        PsiBuilder.Marker marker = this.builder.mark();
        ((JavaScriptInJadeStatementParser)this.getStatementParser()).parseEachStatement(false);
        this.closeWrapperMarker(marker);
    }

    public void parseMixinParams() {
        PsiBuilder.Marker marker = this.builder.mark();
        ((JavaScriptInJadeStatementParser)this.getStatementParser()).parseMixinParameterList(true);
        this.closeWrapperMarker(marker);
    }

    public void parseMixinParamsValues() {
        PsiBuilder.Marker marker = this.builder.mark();
        ((JavaScriptInJadeStatementParser)this.getStatementParser()).parseMixinParameterList(false);
        this.closeWrapperMarker(marker);
    }

    private void closeWrapperMarker(PsiBuilder.Marker marker) {
        PsiBuilder.Marker errorMarker = this.builder.mark();
        boolean somethingLeft = this.flushTokens();
        if (somethingLeft) {
            errorMarker.error(XmlPsiBundle.message((String)"xml.parsing.unexpected.tokens", (Object[])new Object[0]));
            marker.done(JadeElementTypes.EMBEDDED_STATEMENT_WRAPPER);
        } else {
            errorMarker.drop();
            marker.drop();
        }
    }

    private boolean flushTokens() {
        if (this.builder.eof()) {
            return false;
        }
        while (!this.builder.eof()) {
            this.builder.advanceLexer();
        }
        return true;
    }

    public boolean isIdentifierToken(IElementType tokenType) {
        if (tokenType == JSTokenTypes.EACH_KEYWORD) {
            return false;
        }
        return super.isIdentifierToken(tokenType);
    }

    static class JavaScriptInJadeStatementParser
    extends ES6StatementParser<JavaScriptInJadeParser> {
        protected JavaScriptInJadeStatementParser(JavaScriptInJadeParser parser) {
            super((ES6Parser)parser);
        }

        public boolean parseBlock() {
            PsiBuilder.Marker mark = this.builder.mark();
            this.parseBlockAndAttachStatementsDirectly();
            mark.done((IElementType)JSElementTypes.BLOCK_STATEMENT_EAGER);
            return true;
        }

        public void parseStatement() {
            IElementType firstToken = this.builder.getTokenType();
            if (firstToken == null) {
                this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.statement", (Object[])new Object[0]));
                return;
            }
            if (firstToken == JSTokenTypes.WHILE_KEYWORD || firstToken == JSTokenTypes.FOR_KEYWORD || firstToken == JSTokenTypes.EACH_KEYWORD) {
                this.parseMyIterationStatement();
                return;
            }
            super.parseStatement();
        }

        private void parseEachStatement(boolean canGoFurther) {
            LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.EACH_KEYWORD || this.builder.getTokenType() == JSTokenTypes.FOR_KEYWORD);
            PsiBuilder.Marker statement = this.builder.mark();
            this.builder.advanceLexer();
            if (!this.markVariable()) {
                this.builder.mark().error(JavaScriptBundle.message((String)"javascript.parser.message.expected.variable.name", (Object[])new Object[0]));
                statement.done(JadeTokenTypes.EACH_EXPR);
                return;
            }
            if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
                if (!this.markVariable()) {
                    this.builder.mark().error(JavaScriptBundle.message((String)"javascript.parser.message.expected.variable.name", (Object[])new Object[0]));
                    statement.done(JadeTokenTypes.EACH_EXPR);
                    return;
                }
            }
            JavaScriptInJadeStatementParser.checkMatches((PsiBuilder)this.builder, (IElementType)JSTokenTypes.IN_KEYWORD, (String)"javascript.parser.message.expected.forloop.in.or.semicolon");
            ((ES6ExpressionParser)((JavaScriptInJadeParser)this.myJavaScriptParser).getExpressionParser()).parseExpression();
            if (canGoFurther && !this.isEndReached()) {
                this.parseStatement();
                if (this.builder.getTokenType() == JSTokenTypes.ELSE_KEYWORD) {
                    this.builder.advanceLexer();
                    this.parseStatement();
                }
            } else if (!canGoFurther && !this.isEndReached()) {
                this.builder.mark().error(JadeBundle.message("pug.parser.error.indent-expected", new Object[0]));
            }
            statement.done(JadeTokenTypes.EACH_EXPR);
        }

        private void parseMixinParameterList(boolean isDeclaration) {
            PsiBuilder.Marker statement = this.builder.mark();
            boolean lParPassed = JavaScriptInJadeStatementParser.checkMatches((PsiBuilder)this.builder, (IElementType)JSTokenTypes.LPAR, (String)"javascript.parser.message.expected.lparen");
            LOG.assertTrue(lParPassed);
            boolean isFirst = true;
            boolean seenRest = false;
            while (!this.builder.eof()) {
                IElementType tokenType = this.builder.getTokenType();
                if (tokenType == JSTokenTypes.RPAR) {
                    this.builder.advanceLexer();
                    break;
                }
                if (seenRest) {
                    this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.rparen", (Object[])new Object[0]));
                }
                if (isFirst) {
                    isFirst = false;
                } else {
                    boolean commaPassed = JavaScriptInJadeStatementParser.checkMatches((PsiBuilder)this.builder, (IElementType)JSTokenTypes.COMMA, (String)"javascript.parser.message.expected.comma.or.rparen");
                    if (!commaPassed) break;
                }
                if (isDeclaration) {
                    seenRest |= this.passRest();
                    boolean variableMarked = this.markVariable();
                    if (variableMarked) continue;
                    break;
                }
                boolean expressionParsed = ((ES6ExpressionParser)((JavaScriptInJadeParser)this.myJavaScriptParser).getExpressionParser()).parseAssignmentExpression(false);
                if (expressionParsed) continue;
                this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
                break;
            }
            statement.done(isDeclaration ? JadeElementTypes.MIXIN_PARAMETERS : JadeElementTypes.MIXIN_PARAMETERS_VALUES);
        }

        private boolean passRest() {
            if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
                this.builder.advanceLexer();
                return true;
            }
            return false;
        }

        private boolean markVariable() {
            PsiBuilder.Marker varStatement = this.builder.mark();
            PsiBuilder.Marker varMarker = this.builder.mark();
            if (!this.parseVarName(varMarker)) {
                varStatement.drop();
                return false;
            }
            ((JavaScriptInJadeParser)this.myJavaScriptParser).getTypeParser().tryParseType();
            varMarker.done(this.getVariableElementType());
            varMarker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
            varStatement.done((IElementType)JSStubElementTypes.VAR_STATEMENT);
            return true;
        }

        private void parseMyIterationStatement() {
            IElementType tokenType = this.builder.getTokenType();
            if (tokenType == JSTokenTypes.WHILE_KEYWORD) {
                this.parseMyWhileStatement();
            } else if (tokenType == JSTokenTypes.EACH_KEYWORD || tokenType == JSTokenTypes.FOR_KEYWORD && this.builder.lookAhead(1) != JSTokenTypes.EACH_KEYWORD && this.builder.lookAhead(1) != JSTokenTypes.LPAR) {
                this.parseEachStatement(true);
            } else if (tokenType == JSTokenTypes.FOR_KEYWORD) {
                this.parseMyForStatement();
            }
        }

        private void parseMyForStatement() {
            LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.FOR_KEYWORD);
            PsiBuilder.Marker statement = this.builder.mark();
            boolean forin = this.parseForLoopHeader();
            if (!this.isEndReached()) {
                this.parseStatement();
                if (this.builder.getTokenType() == JSTokenTypes.ELSE_KEYWORD) {
                    this.builder.advanceLexer();
                    this.parseStatement();
                }
            }
            statement.done(forin ? JSElementTypes.FOR_IN_STATEMENT : JSElementTypes.FOR_STATEMENT);
        }

        private void parseMyWhileStatement() {
            LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.WHILE_KEYWORD);
            PsiBuilder.Marker statement = this.builder.mark();
            this.builder.advanceLexer();
            JavaScriptInJadeStatementParser.checkMatches((PsiBuilder)this.builder, (IElementType)JSTokenTypes.LPAR, (String)"javascript.parser.message.expected.lparen");
            ((ES6ExpressionParser)((JavaScriptInJadeParser)this.myJavaScriptParser).getExpressionParser()).parseExpression();
            JavaScriptInJadeStatementParser.checkMatches((PsiBuilder)this.builder, (IElementType)JSTokenTypes.RPAR, (String)"javascript.parser.message.expected.rparen");
            if (!this.isEndReached()) {
                this.parseStatement();
            }
            statement.done(JSElementTypes.WHILE_STATEMENT);
        }

        private boolean isEndReached() {
            return this.builder.getTokenType() == null;
        }
    }

    static class JavaScriptInJadeExpressionParser
    extends ES6ExpressionParser<JavaScriptInJadeParser> {
        protected JavaScriptInJadeExpressionParser(JavaScriptInJadeParser parser) {
            super((JavaScriptParser)parser);
        }

        public boolean parsePrimaryExpression() {
            IElementType firstToken = this.builder.getTokenType();
            if (firstToken == JadeTokenTypes.INTERPOLATED_STRING_START) {
                this.parseInterpolatedString();
                return true;
            }
            if (firstToken == JSTokenTypes.IDENTIFIER && "attributes".equals(this.builder.getTokenText())) {
                return ((JavaScriptInJadeStatementParser)((JavaScriptInJadeParser)this.myJavaScriptParser).getStatementParser()).markVariable();
            }
            return super.parsePrimaryExpression();
        }

        private void parseInterpolatedString() {
            IElementType tokenType;
            LOG.assertTrue(this.builder.getTokenType() == JadeTokenTypes.INTERPOLATED_STRING_START);
            PsiBuilder.Marker string = this.builder.mark();
            this.builder.advanceLexer();
            while ((tokenType = this.builder.getTokenType()) != null) {
                boolean parseSuccessful;
                if (tokenType == JadeTokenTypes.INTERPOLATED_STRING_END) {
                    this.builder.advanceLexer();
                    break;
                }
                if (JavaScriptInJadeExpressionParser.isTokenInterpolatedStringPart(tokenType)) {
                    this.builder.advanceLexer();
                    continue;
                }
                PsiBuilder.Marker expression = this.builder.mark();
                boolean bl = parseSuccessful = !this.parseExpressionOptional();
                if (parseSuccessful) {
                    this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
                    this.builder.advanceLexer();
                }
                expression.done(JadeTokenTypes.INTERPOLATED_EXPRESSION);
            }
            string.done(JSElementTypes.PARENTHESIZED_EXPRESSION);
        }

        private static boolean isTokenInterpolatedStringPart(IElementType token) {
            return token == JadeTokenTypes.INTERPOLATED_STRING_START || token == JadeTokenTypes.INTERPOLATED_STRING_END || token == JadeTokenTypes.INTERPOLATED_STRING_PART;
        }
    }
}

