/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.util.BitHacksKt;
import java.security.MessageDigest;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/utils/UUIDUtils;", "", "()V", "createFromString", "Ljava/util/UUID;", "value", "", "parseCurlyBracketsValue", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nUUIDUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UUIDUtils.kt\ncom/jetbrains/rider/utils/UUIDUtils\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,38:1\n13#2:39\n*S KotlinDebug\n*F\n+ 1 UUIDUtils.kt\ncom/jetbrains/rider/utils/UUIDUtils\n*L\n14#1:39\n*E\n"})
public final class UUIDUtils {
    @NotNull
    public static final UUIDUtils INSTANCE = new UUIDUtils();

    private UUIDUtils() {
    }

    @NotNull
    public final UUID parseCurlyBracketsValue(@NotNull String value2) {
        UUID uUID;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        try {
            uUID = UUID.fromString(StringsKt.removeSuffix((String)StringsKt.removePrefix((String)value2, (CharSequence)"{"), (CharSequence)"}"));
            Intrinsics.checkNotNull((Object)uUID);
        }
        catch (Exception exception) {
            boolean bl = false;
            Logger logger = Logger.getInstance(UUIDUtils.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn((Throwable)exception);
            uUID = new UUID(0L, 0L);
        }
        return uUID;
    }

    @NotNull
    public final UUID createFromString(@Nullable String value2) {
        Object object = value2;
        if (object == null || object.length() == 0) {
            return new UUID(0L, 0L);
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(...)");
        object = messageDigest;
        Object object2 = value2;
        byte[] byArray = ((String)object2).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = ((MessageDigest)object).digest(byArray);
        byte[] byArray3 = new byte[]{byArray2[3], byArray2[2], byArray2[1], byArray2[0], byArray2[5], byArray2[4], byArray2[7], byArray2[6], byArray2[8], byArray2[9], byArray2[10], byArray2[11], byArray2[12], byArray2[13], byArray2[14], byArray2[15]};
        object2 = byArray3;
        return new UUID(BitHacksKt.parseLong((byte[])object2, (int)0), BitHacksKt.parseLong((byte[])object2, (int)8));
    }
}

