/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.utils;

import com.intellij.execution.process.OSProcessUtil;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Alarm;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rider.NetCoreUtil;
import com.jetbrains.rider.RiderEnvironment;
import com.jetbrains.rider.clrmd.ClrProcessThreadDumpUtilKt;
import com.jetbrains.rider.clrmd.CollectThreadDumpRequest;
import com.jetbrains.rider.inTests.PerformancePlaybackTestsKt;
import com.jetbrains.rider.projectView.SolutionLifecycleHost;
import com.jetbrains.rider.protocol.IProtocolHostWithBackend;
import com.jetbrains.rider.protocol.ProtocolKeys;
import com.jetbrains.rider.protocol.ReSharperProcessBase;
import com.jetbrains.rider.utils.PerfWatcherRequest;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 32\u00020\u0001:\u00013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J.\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J1\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u001cJ\r\u0010\u001d\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u001eJ\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!H\u0002J\u0017\u0010\"\u001a\u00020\u00142\b\u0010#\u001a\u0004\u0018\u00010\u0014H\u0002\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020\u0014H\u0002J\b\u0010&\u001a\u00020\u0014H\u0002J\b\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020!H\u0002J3\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020.2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00142\u0006\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u0011H\u0000\u00a2\u0006\u0004\b1\u00102R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/jetbrains/rider/utils/BackendPerformanceWatcher;", "Lcom/intellij/openapi/Disposable;", "()V", "alarm", "Lcom/intellij/util/Alarm;", "lastRequest", "Lcom/jetbrains/rider/utils/PerfWatcherRequest;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "retrySampling", "Ljava/util/concurrent/atomic/AtomicBoolean;", "dispose", "", "j", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "info", "", "pids", "", "", "samplingInterval", "j", "", "Ljava/io/File;", "children", "expectedStartTime", "expectedNumbersOfFiles", "([Ljava/io/File;Ljava/lang/String;I)[Ljava/io/File;", "finishBackendPerformanceWatcher", "finishBackendPerformanceWatcher$intellij_rider_rdclient_dotnet", "j", "timeMs", "", "j", "customMaxAllowedTimeMs", "(Ljava/lang/Integer;)I", "w", "j", "j", "", "j", "request", "spentTimeMs", "startBackendPerformanceWatcher", "project", "Lcom/intellij/openapi/project/Project;", "activityDescription", "activityId", "startBackendPerformanceWatcher$intellij_rider_rdclient_dotnet", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;)Z", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nBackendPerformanceWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendPerformanceWatcher.kt\ncom/jetbrains/rider/utils/BackendPerformanceWatcher\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,287:1\n13#2:288\n13#3:289\n13309#4,2:290\n*S KotlinDebug\n*F\n+ 1 BackendPerformanceWatcher.kt\ncom/jetbrains/rider/utils/BackendPerformanceWatcher\n*L\n74#1:288\n74#1:289\n210#1:290,2\n*E\n"})
public final class BackendPerformanceWatcher
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final Alarm alarm;
    @NotNull
    private final AtomicBoolean retrySampling;
    @Nullable
    private PerfWatcherRequest lastRequest;
    @NotNull
    private static final String descriptionFileName = "description.txt";
    @NotNull
    private static final String threadDumpExtensionWithDot = ".tdump";
    @NotNull
    private static final String isEnabledKey = "rider.backend.performance.watcher.isEnabled";
    @NotNull
    private static final String maxAllowedTimeMsKey = "rider.backend.performance.watcher.maxAllowedTimeMs";
    private static final int maxAllowedTimeMsDefault = 500;
    @NotNull
    private static final String delayTimeMsKey = "rider.backend.performance.watcher.delayTimeMs";
    private static final int delayTimeMsDefault = 500;
    @NotNull
    private static final String samplingIntervalMsKey = "rider.backend.performance.watcher.samplingIntervalMs";
    private static final int samplingIntervalMsDefault = 500;
    @NotNull
    private static final String openThreadDumpFolderKey = "rider.backend.performance.watcher.openFolder";

    public BackendPerformanceWatcher() {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getInstance(BackendPerformanceWatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.retrySampling = new AtomicBoolean(false);
        ApplicationKt.getApplication().executeOnPooledThread(BackendPerformanceWatcher::j);
    }

    public final boolean startBackendPerformanceWatcher$intellij_rider_rdclient_dotnet(@NotNull Project project2, @Nullable Integer customMaxAllowedTimeMs, @NotNull String activityDescription, @NotNull String activityId) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)activityDescription, (String)"activityDescription");
        Intrinsics.checkNotNullParameter((Object)activityId, (String)"activityId");
        ApplicationKt.getApplication().assertIsDispatchThread();
        if (this.j()) {
            return false;
        }
        this.logger.info("Start backend performance monitor");
        Object object = project2.getUserData(ProtocolKeys.Companion.getProtocolHostKey());
        IProtocolHostWithBackend iProtocolHostWithBackend = object instanceof IProtocolHostWithBackend ? (IProtocolHostWithBackend)object : null;
        if (iProtocolHostWithBackend == null) {
            BackendPerformanceWatcher backendPerformanceWatcher = this;
            boolean bl = false;
            backendPerformanceWatcher.logger.info("Current backend is not supported.");
            return false;
        }
        IProtocolHostWithBackend iProtocolHostWithBackend2 = iProtocolHostWithBackend;
        SolutionLifecycleHost solutionLifecycleHost = SolutionLifecycleHost.Companion.getInstance(project2);
        if (!((Boolean)solutionLifecycleHost.isBackendLoaded().getValue()).booleanValue()) {
            this.logger.info("Backend isn't loaded.");
            return false;
        }
        Object object2 = iProtocolHostWithBackend2.getResharperProcess();
        if (object2 == null || (object2 = ((ReSharperProcessBase)object2).getResharperProcessHandler()) == null || (object2 = object2.getProcess()) == null) {
            BackendPerformanceWatcher backendPerformanceWatcher = this;
            boolean bl = false;
            backendPerformanceWatcher.logger.error("resharperProcess == null");
            return false;
        }
        object = object2;
        Lifetime lifetime2 = iProtocolHostWithBackend2.getLifetime();
        if (RLifetimeKt.isNotAlive((Lifetime)lifetime2)) {
            this.logger.warn("Backend is already terminated.");
            return false;
        }
        int n2 = OSProcessUtil.getProcessID((Process)object);
        if (this.lastRequest != null) {
            this.logger.error("The previous request is still processing (skip activity=" + activityDescription + ").");
            return false;
        }
        int n3 = this.w();
        int n4 = this.j();
        int n5 = this.j(customMaxAllowedTimeMs);
        long l2 = System.nanoTime();
        this.lastRequest = new PerfWatcherRequest(l2, activityDescription, activityId, n5, n3, System.currentTimeMillis());
        this.alarm.addRequest(() -> BackendPerformanceWatcher.j(this, lifetime2, activityId, activityDescription, n2, n4), n3);
        this.retrySampling.set(true);
        return true;
    }

    public static /* synthetic */ boolean startBackendPerformanceWatcher$intellij_rider_rdclient_dotnet$default(BackendPerformanceWatcher backendPerformanceWatcher, Project project2, Integer n2, String string, String string2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = null;
        }
        return backendPerformanceWatcher.startBackendPerformanceWatcher$intellij_rider_rdclient_dotnet(project2, n2, string, string2);
    }

    private final boolean j() {
        return NetCoreUtil.INSTANCE.runOnNetCore() || PerformancePlaybackTestsKt.getApplicationIsPlayBackTestMode() || ApplicationKt.getApplication().isUnitTestMode() || !Registry.is((String)isEnabledKey) && !ApplicationInfoEx.getInstanceEx().isEAP();
    }

    private final int j(Integer n2) {
        int n3;
        Integer n4 = n2;
        int n5 = n3 = n4 != null ? n4 : Registry.intValue((String)maxAllowedTimeMsKey);
        if (n3 <= 0) {
            this.logger.warn("Flag `maxAllowedTimeMs` must be more then zero. Using default value...");
            n3 = 500;
        }
        return n3;
    }

    private final int j() {
        int n2 = Registry.intValue((String)samplingIntervalMsKey);
        if (n2 <= 0) {
            this.logger.warn("Flag `samplingIntervalMs` must be greater than zero. Using default value...");
            n2 = 500;
        }
        return n2;
    }

    private final int w() {
        int n2 = Registry.intValue((String)delayTimeMsKey);
        if (n2 <= 0) {
            this.logger.warn("Flag `delayTimeMs` must be greater than zero. Using default value...");
            n2 = 500;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void finishBackendPerformanceWatcher$intellij_rider_rdclient_dotnet() {
        ApplicationKt.getApplication().assertIsDispatchThread();
        if (this.j()) {
            return;
        }
        PerfWatcherRequest perfWatcherRequest = this.lastRequest;
        if (perfWatcherRequest == null) {
            return;
        }
        PerfWatcherRequest perfWatcherRequest2 = perfWatcherRequest;
        try {
            long l2 = System.nanoTime();
            long l3 = (l2 - perfWatcherRequest2.getStartTimeNano()) / (long)1000000;
            if (l3 >= (long)perfWatcherRequest2.getMaxAllowedTimeMs()) {
                this.alarm.addRequest(() -> BackendPerformanceWatcher.j(this, perfWatcherRequest2, l3), 0);
            } else {
                this.alarm.cancelAllRequests();
            }
            this.logger.info("Finish backend performance monitor.");
        }
        finally {
            this.lastRequest = null;
            this.retrySampling.set(false);
        }
    }

    private final void j(PerfWatcherRequest perfWatcherRequest, long l2) {
        String string = this.j(perfWatcherRequest.getStartTimeMs());
        String string2 = string + threadDumpExtensionWithDot;
        int n2 = (int)((float)l2 / (float)this.j() + 0.5f);
        File[] fileArray = RiderEnvironment.INSTANCE.getBackendThreadDumpDir().listFiles(BackendPerformanceWatcher::j);
        if (fileArray == null) {
            BackendPerformanceWatcher backendPerformanceWatcher = this;
            boolean bl = false;
            backendPerformanceWatcher.logger.warn("Can't enumerate thread dumps into " + RiderEnvironment.INSTANCE.getBackendThreadDumpDir() + " folder.");
            return;
        }
        File[] fileArray2 = fileArray;
        if (!((fileArray = this.j(fileArray2, string2, n2)).length == 0)) {
            Comparable<File> comparable;
            File file2 = FilesKt.resolve((File)RiderEnvironment.INSTANCE.getBackendThreadDumpDir(), (String)(perfWatcherRequest.getActivityId() + "_" + string));
            file2.mkdir();
            this.logger.trace("Moving files to " + file2);
            File[] object = fileArray;
            boolean string4 = false;
            for (File n4 : object) {
                comparable = n4;
                boolean bl = false;
                ((File)comparable).renameTo(new File(file2, ((File)comparable).getName()));
                ((File)comparable).delete();
            }
            String string3 = new SimpleDateFormat("HH:mm:ss.SSS").format(new Date(perfWatcherRequest.getStartTimeMs() + (long)perfWatcherRequest.getDelayMs()));
            StringBuilder stringBuilder = new StringBuilder().append("activityDescription:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            StringBuilder stringBuilder2 = stringBuilder;
            StringBuilder stringBuilder3 = stringBuilder2.append(perfWatcherRequest.getActivityDescription());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            StringBuilder stringBuilder4 = stringBuilder3.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
            StringBuilder stringBuilder5 = stringBuilder4.append("elapsed time:").append(l2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
            StringBuilder stringBuilder6 = stringBuilder5.append("ms");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
            StringBuilder stringBuilder7 = stringBuilder6.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
            comparable = stringBuilder7.append("start threads dump time:");
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"append(...)");
            StringBuilder stringBuilder8 = ((StringBuilder)comparable).append(string3);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
            StringBuilder stringBuilder9 = stringBuilder8.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(...)");
            comparable = stringBuilder9;
            StringBuilder stringBuilder10 = ((StringBuilder)comparable).append("Run parameters:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(...)");
            StringBuilder stringBuilder11 = stringBuilder10.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(...)");
            StringBuilder stringBuilder12 = stringBuilder11.append("  maxAllowedTimeMs:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12, (String)"append(...)");
            StringBuilder stringBuilder13 = stringBuilder12;
            int n3 = perfWatcherRequest.getMaxAllowedTimeMs();
            StringBuilder stringBuilder14 = stringBuilder13.append(n3);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14, (String)"append(...)");
            StringBuilder stringBuilder15 = stringBuilder14.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder15, (String)"append(...)");
            StringBuilder stringBuilder16 = stringBuilder15.append("  startDelayMs:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder16, (String)"append(...)");
            int n4 = perfWatcherRequest.getDelayMs();
            StringBuilder stringBuilder17 = stringBuilder16.append(n4);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder17, (String)"append(...)");
            StringBuilder stringBuilder18 = stringBuilder17.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder18, (String)"append(...)");
            String string5 = stringBuilder18.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
            String string6 = string5;
            FilesKt.writeText$default((File)new File(file2, descriptionFileName), (String)string6, null, (int)2, null);
            this.logger.warn("Backend `" + perfWatcherRequest.getActivityDescription() + "` activity took more than " + perfWatcherRequest.getMaxAllowedTimeMs() + " ms. Please report a bug (see " + file2 + " for details).");
            if (Registry.is((String)openThreadDumpFolderKey)) {
                RevealFileAction.openDirectory((File)file2);
            }
        } else {
            this.logger.error("ThreadDumps are not found.");
        }
    }

    private final File[] j(File[] fileArray, String string, int n2) {
        Arrays.sort(fileArray);
        int n3 = CollectionsKt.binarySearch$default((List)ArraysKt.asList((Object[])fileArray), (int)0, (int)0, (Function1)((Function1)new Function1<File, Integer>(string){
            final /* synthetic */ String $expectedStartTime;
            {
                this.$expectedStartTime = $expectedStartTime;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull File file2) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                return FilesKt.getNameWithoutExtension((File)file2).compareTo(this.$expectedStartTime);
            }
        }), (int)3, null);
        int n4 = n3 < 0 ? -n3 - 1 : n3;
        IntRange intRange = RangesKt.until((int)Math.min(n4, fileArray.length), (int)Math.min(n4 + n2, fileArray.length));
        return (File[])ArraysKt.sliceArray((Object[])fileArray, (IntRange)intRange);
    }

    private final String j(long l2) {
        String string = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS").format(new Date(l2));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    private final void j(Lifetime lifetime2, String string, List<Integer> list, int n2) {
        RdCoroutinesUtilKt.launchBackground$default((Lifetime)lifetime2, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(string, list, null){
            int label;
            final /* synthetic */ String $info;
            final /* synthetic */ List<Integer> $pids;
            {
                this.$info = $info;
                this.$pids = $pids;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        int[] nArray = CollectionsKt.toIntArray((Collection)this.$pids);
                        this.label = 1;
                        Object object3 = ClrProcessThreadDumpUtilKt.requestThreadDumpForClrProcesses$default(CollectThreadDumpRequest.Companion.automaticDiagnostics(this.$info), Arrays.copyOf(nArray, nArray.length), null, (Continuation)this, 4, null);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        if (this.retrySampling.get()) {
            this.alarm.addRequest(() -> BackendPerformanceWatcher.j(this, lifetime2, string, list, n2), n2);
        }
    }

    public void dispose() {
    }

    private static final void j() {
        BackendPerformanceWatcher.Companion.j(RiderEnvironment.INSTANCE.getBackendThreadDumpDir());
    }

    private static final void j(BackendPerformanceWatcher backendPerformanceWatcher, Lifetime lifetime2, String string, String string2, int n2, int n3) {
        Intrinsics.checkNotNullParameter((Object)backendPerformanceWatcher, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"$lifetime");
        Intrinsics.checkNotNullParameter((Object)string, (String)"$activityId");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"$activityDescription");
        backendPerformanceWatcher.j(lifetime2, string + ": " + string2, CollectionsKt.listOf((Object)n2), n3);
    }

    private static final void j(BackendPerformanceWatcher backendPerformanceWatcher, PerfWatcherRequest perfWatcherRequest, long l2) {
        Intrinsics.checkNotNullParameter((Object)backendPerformanceWatcher, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)perfWatcherRequest, (String)"$request");
        backendPerformanceWatcher.j(perfWatcherRequest, l2);
    }

    private static final boolean j(File file2, String string) {
        Intrinsics.checkNotNull((Object)string);
        return StringsKt.endsWith$default((String)string, (String)threadDumpExtensionWithDot, (boolean)false, (int)2, null);
    }

    private static final void j(BackendPerformanceWatcher backendPerformanceWatcher, Lifetime lifetime2, String string, List list, int n2) {
        Intrinsics.checkNotNullParameter((Object)backendPerformanceWatcher, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"$lifetime");
        Intrinsics.checkNotNullParameter((Object)string, (String)"$info");
        Intrinsics.checkNotNullParameter((Object)list, (String)"$pids");
        backendPerformanceWatcher.j(lifetime2, string, list, n2);
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/utils/BackendPerformanceWatcher$Companion;", "", "()V", "delayTimeMsDefault", "", "delayTimeMsKey", "", "descriptionFileName", "isEnabledKey", "maxAllowedTimeMsDefault", "maxAllowedTimeMsKey", "openThreadDumpFolderKey", "samplingIntervalMsDefault", "samplingIntervalMsKey", "threadDumpExtensionWithDot", "j", "", "file", "Ljava/io/File;", "j", "", "dir", "getInstance", "Lcom/jetbrains/rider/utils/BackendPerformanceWatcher;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nBackendPerformanceWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendPerformanceWatcher.kt\ncom/jetbrains/rider/utils/BackendPerformanceWatcher$Companion\n+ 2 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n*L\n1#1,287:1\n17#2,2:288\n*S KotlinDebug\n*F\n+ 1 BackendPerformanceWatcher.kt\ncom/jetbrains/rider/utils/BackendPerformanceWatcher$Companion\n*L\n56#1:288,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BackendPerformanceWatcher getInstance() {
            ComponentManager componentManager = (ComponentManager)ApplicationKt.getApplication();
            boolean bl = false;
            Object object = componentManager.getService(BackendPerformanceWatcher.class);
            if (object == null) {
                throw new IllegalStateException("Service " + BackendPerformanceWatcher.class + " not found in container " + componentManager);
            }
            return (BackendPerformanceWatcher)object;
        }

        private final void j(File file2) {
            Object[] objectArray = file2.listFiles();
            if (objectArray == null) {
                return;
            }
            Object[] objectArray2 = objectArray;
            Arrays.sort(objectArray2);
            int n2 = objectArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = objectArray2[i2];
                if (i2 >= objectArray2.length - 100) {
                    Intrinsics.checkNotNull((Object)object);
                    if (this.j((File)object) <= 10L) continue;
                }
                FileUtil.delete((File)object);
            }
        }

        private final long j(File file2) {
            return TimeUnit.DAYS.convert(System.currentTimeMillis() - file2.lastModified(), TimeUnit.MILLISECONDS);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

