/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.util.idea;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ'\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f\u00a2\u0006\u0002\u0010\u0010R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/util/idea/TimeLogger;", "", "()V", "sections", "Ljava/util/ArrayList;", "Lcom/jetbrains/rider/util/idea/TimeLogger$Section;", "Lkotlin/collections/ArrayList;", "start", "", "complete", "", "name", "section", "R", "action", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Section", "intellij.rider.rdclient.dotnet"})
public final class TimeLogger {
    private final long start = System.currentTimeMillis();
    @NotNull
    private final ArrayList<Section> sections = new ArrayList();

    public final <R> R section(@NotNull String name, @NotNull Function0<? extends R> action2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        long startMillis = System.currentTimeMillis();
        Object result2 = action2.invoke();
        long endMillis = System.currentTimeMillis();
        this.sections.add(new Section(name, endMillis - startMillis));
        return (R)result2;
    }

    @NotNull
    public final String complete(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        long end = System.currentTimeMillis();
        long total = end - this.start;
        String time = new SimpleDateFormat("HH:mm:ss:SS").format(new Date());
        StringBuilder sectionTimes = new StringBuilder();
        for (Section section : this.sections) {
            sectionTimes.append("\t" + section.getName() + " for " + section.getTime() + " ms");
            if (total > 0L) {
                int p2 = (int)((float)section.getTime() / (float)total * (float)100);
                sectionTimes.append(" " + p2 + "%");
            }
            Intrinsics.checkNotNullExpressionValue((Object)sectionTimes.append('\n'), (String)"append(...)");
        }
        return time + " " + name + " for " + total + " ms, details:\n" + sectionTimes;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/util/idea/TimeLogger$Section;", "", "name", "", "time", "", "(Ljava/lang/String;J)V", "getName", "()Ljava/lang/String;", "getTime", "()J", "intellij.rider.rdclient.dotnet"})
    private static final class Section {
        @NotNull
        private final String name;
        private final long time;

        public Section(@NotNull String name, long time) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.time = time;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final long getTime() {
            return this.time;
        }
    }
}

