/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.util;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u001c\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bJ\"\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004J0\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bJ\u0017\u0010\r\u001a\u00020\u000e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/util/NetUtils;", "", "()V", "FIND_PORT_ATTEMPTS_COUNT", "", "findFreePort", "port", "bannedPorts", "", "findFreePorts", "Lkotlin/Pair;", "senderPort", "receiverPort", "isPortFree", "", "(Ljava/lang/Integer;)Z", "intellij.rider.rdclient.dotnet"})
public final class NetUtils {
    @NotNull
    public static final NetUtils INSTANCE = new NetUtils();
    private static final int FIND_PORT_ATTEMPTS_COUNT = 5;

    private NetUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isPortFree(Integer port) {
        if (port == null) {
            return true;
        }
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(port, 0, InetAddress.getByName("127.0.0.1"));
            socket.setReuseAddress(true);
            boolean bl = true;
            socket.close();
            return bl;
        }
        catch (Exception e2) {
            boolean bl = false;
            return bl;
        }
        finally {
            block6: {
                ServerSocket serverSocket = socket;
                if (serverSocket == null) break block6;
                serverSocket.close();
            }
        }
    }

    public final int findFreePort(int port) {
        if (port > 0 && this.isPortFree(port)) {
            return port;
        }
        ServerSocket socket1 = new ServerSocket(0, 0, InetAddress.getByName("127.0.0.1"));
        int result2 = socket1.getLocalPort();
        socket1.setReuseAddress(true);
        socket1.close();
        return result2;
    }

    public final int findFreePort(int port, @NotNull Set<Integer> bannedPorts) {
        Intrinsics.checkNotNullParameter(bannedPorts, (String)"bannedPorts");
        if (port > 0 && this.isPortFree(port) && !bannedPorts.contains(port)) {
            return port;
        }
        for (int attempt = 0; attempt < 5; ++attempt) {
            ServerSocket socket1 = new ServerSocket(0, 0, InetAddress.getByName("127.0.0.1"));
            int result2 = socket1.getLocalPort();
            socket1.setReuseAddress(true);
            socket1.close();
            if (bannedPorts.contains(result2)) continue;
            return result2;
        }
        throw new IllegalStateException("Failed to find free ports (base port " + port + ") using 5 attempts");
    }

    @NotNull
    public final Pair<Integer, Integer> findFreePorts(int senderPort, int receiverPort) {
        return new Pair((Object)this.findFreePort(senderPort), (Object)this.findFreePort(receiverPort));
    }

    @NotNull
    public final Pair<Integer, Integer> findFreePorts(int senderPort, int receiverPort, @NotNull Set<Integer> bannedPorts) {
        Intrinsics.checkNotNullParameter(bannedPorts, (String)"bannedPorts");
        int port1 = this.findFreePort(senderPort, bannedPorts);
        int port2 = this.findFreePort(receiverPort, CollectionsKt.union((Iterable)bannedPorts, (Iterable)CollectionsKt.listOf((Object)port1)));
        return new Pair((Object)port1, (Object)port2);
    }
}

