/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.PathKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/util/FileCleanupUtil;", "", "()V", "cleanupFile", "", "path", "Ljava/nio/file/Path;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
public final class FileCleanupUtil {
    @NotNull
    public static final FileCleanupUtil INSTANCE = new FileCleanupUtil();

    private FileCleanupUtil() {
    }

    public final void cleanupFile(@NotNull Path path, @Nullable Logger logger) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            try {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block5;
                PathKt.delete((Path)path, (boolean)false);
            }
            catch (Exception e2) {
                Logger logger2 = logger;
                if (logger2 != null) {
                    logger2.warn("Can not delete file '" + path + "', try to rename it instead", (Throwable)e2);
                }
                try {
                    Path path2 = path.getParent().resolve(PathsKt.getName((Path)path) + ".tmp");
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                    PathKt.move((Path)path, (Path)path2);
                }
                catch (Exception e3) {
                    Logger logger3 = logger;
                    if (logger3 == null) break block5;
                    logger3.warn((Throwable)e3);
                }
            }
        }
    }
}

