/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.spellChecker.rename;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spellchecker.SpellCheckerManager;
import com.jetbrains.rdclient.actions.base.BackendActionDelegationKt;
import com.jetbrains.rider.settings.RdClientDotnetBundle;
import com.jetbrains.rider.spellChecker.rename.RiderGrammarAndSpellingDataKeys;
import icons.SpellcheckerIcons;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/spellChecker/rename/BackendRenameTo;", "Lcom/intellij/codeInspection/LocalQuickFix;", "Lcom/intellij/openapi/util/Iconable;", "Lcom/intellij/codeInsight/intention/PriorityAction;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "getFamilyName", "", "getIcon", "Ljavax/swing/Icon;", "flags", "", "getPriority", "Lcom/intellij/codeInsight/intention/PriorityAction$Priority;", "intellij.rider.rdclient.dotnet"})
public final class BackendRenameTo
implements LocalQuickFix,
Iconable,
PriorityAction {
    @NotNull
    public String getFamilyName() {
        return RdClientDotnetBundle.INSTANCE.message("spellchecker.rename.to", new Object[0]);
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiFile psiFile = descriptor.getPsiElement().getContainingFile();
        if (psiFile == null) {
            throw new AssertionError((Object)"file != null");
        }
        PsiFile psiFile2 = psiFile;
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project2).getSelectedEditor(psiFile2.getVirtualFile());
        if (!(fileEditor instanceof TextEditor)) {
            return;
        }
        Editor editor = ((TextEditor)fileEditor).getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        PsiElement psiElement = descriptor.getPsiElement().findElementAt(descriptor.getTextRangeInElement().getStartOffset());
        SpellCheckerManager spellCheckerManager = SpellCheckerManager.Companion.getInstance(project2);
        PsiElement psiElement2 = psiElement;
        String string = psiElement2 != null ? psiElement2.getText() : null;
        if (string == null) {
            string = "";
        }
        List list = spellCheckerManager.getSuggestions(string);
        DataContext dataContext2 = SimpleDataContext.builder().add(CommonDataKeys.EDITOR, (Object)editor2).add(CommonDataKeys.PROJECT, (Object)project2).add(RiderGrammarAndSpellingDataKeys.INSTANCE.getFIX_TYPO_WITH_RENAME_DATA(), (Object)list).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"build(...)");
        DataContext dataContext3 = dataContext2;
        AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext3);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromDataContext(...)");
        AnActionEvent anActionEvent2 = anActionEvent;
        BackendActionDelegationKt.backendActionPerformed((String)"RenameElement", (AnActionEvent)anActionEvent2);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project2, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    @NotNull
    public Icon getIcon(int flags) {
        Icon icon = SpellcheckerIcons.Spellcheck;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Spellcheck");
        return icon;
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        return PriorityAction.Priority.TOP;
    }
}

