/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.spellChecker;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.Alarm;
import com.intellij.util.ApplicationKt;
import com.intellij.util.SingleAlarm;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.spellChecker.RiderFrontendInspectionTarget;
import com.jetbrains.rider.spellChecker.RiderFrontendInspectionTargetsService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002 !B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001b\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J\u001e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00172\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u000bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Lcom/jetbrains/rider/spellChecker/RiderFrontendInspectionTargetsService;", "TTarget", "Lcom/jetbrains/rider/spellChecker/RiderFrontendInspectionTarget;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "myPerDocumentAlarms", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/editor/Document;", "Lcom/intellij/util/SingleAlarm;", "myPerDocumentServices", "Lcom/jetbrains/rider/spellChecker/RiderFrontendInspectionTargetsService$DocumentTargets;", "getProject", "()Lcom/intellij/openapi/project/Project;", "addOrUpdate", "", "document", "range", "(Lcom/intellij/openapi/editor/Document;Lcom/jetbrains/rider/spellChecker/RiderFrontendInspectionTarget;)V", "getTargets", "", "Lcom/intellij/openapi/util/TextRange;", "remove", "id", "", "j", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "startForDocument", "DocumentTargets", "Point", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderFrontendInspectionTargetsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderFrontendInspectionTargetsService.kt\ncom/jetbrains/rider/spellChecker/RiderFrontendInspectionTargetsService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n23#2:201\n72#3,2:202\n72#3,2:205\n1#4:204\n1#4:207\n*S KotlinDebug\n*F\n+ 1 RiderFrontendInspectionTargetsService.kt\ncom/jetbrains/rider/spellChecker/RiderFrontendInspectionTargetsService\n*L\n101#1:201\n104#1:202,2\n126#1:205,2\n104#1:204\n126#1:207\n*E\n"})
public abstract class RiderFrontendInspectionTargetsService<TTarget extends RiderFrontendInspectionTarget>
extends LifetimedService {
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentMap<Document, DocumentTargets<TTarget>> myPerDocumentServices;
    @NotNull
    private final ConcurrentMap<Document, SingleAlarm> myPerDocumentAlarms;
    @NotNull
    private final Logger myLogger;

    public RiderFrontendInspectionTargetsService(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.myPerDocumentServices = new ConcurrentHashMap();
        this.myPerDocumentAlarms = new ConcurrentHashMap();
        RiderFrontendInspectionTargetsService riderFrontendInspectionTargetsService = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(RiderFrontendInspectionTargetsService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.myLogger = logger;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void startForDocument(@NotNull Lifetime lifetime2, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        ConcurrentMap<Document, DocumentTargets<TTarget>> concurrentMap = this.myPerDocumentServices;
        boolean bl = false;
        Object object = concurrentMap.get(document);
        if (object == null) {
            boolean bl2 = false;
            lifetime2.onTermination((Function0)new Function0<Unit>(this, document){
                final /* synthetic */ RiderFrontendInspectionTargetsService<TTarget> this$0;
                final /* synthetic */ Document $document;
                {
                    this.this$0 = $receiver;
                    this.$document = $document;
                    super(0);
                }

                public final void invoke() {
                    RiderFrontendInspectionTargetsService.access$getMyPerDocumentServices$p(this.this$0).remove(this.$document);
                }
            });
            DocumentTargets documentTargets = new DocumentTargets(lifetime2);
            boolean bl3 = false;
            object = concurrentMap.putIfAbsent(document, documentTargets);
            if (object == null) {
                object = documentTargets;
            }
        }
    }

    public final void addOrUpdate(@NotNull Document document, @NotNull TTarget range) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(range, (String)"range");
        DocumentTargets documentTargets = (DocumentTargets)this.myPerDocumentServices.get(document);
        if (documentTargets == null) {
            return;
        }
        DocumentTargets documentTargets2 = documentTargets;
        documentTargets2.add(range);
        this.j(document, documentTargets2.getLifetime());
    }

    public final void remove(@NotNull Document document, long id) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        DocumentTargets documentTargets = (DocumentTargets)this.myPerDocumentServices.get(document);
        if (documentTargets == null) {
            return;
        }
        DocumentTargets documentTargets2 = documentTargets;
        documentTargets2.remove(id);
        this.j(document, documentTargets2.getLifetime());
    }

    private final void j(Document document, Lifetime lifetime2) {
        this.myLogger.trace("Scheduling restart");
        ConcurrentMap<Document, SingleAlarm> concurrentMap = this.myPerDocumentAlarms;
        boolean bl = false;
        Object object = concurrentMap.get(document);
        if (object == null) {
            boolean bl2 = false;
            SingleAlarm singleAlarm = new SingleAlarm(() -> RiderFrontendInspectionTargetsService.j(this, document), 500, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime2, null, (int)1, null), Alarm.ThreadToUse.POOLED_THREAD, null, 16, null);
            boolean bl3 = false;
            object = concurrentMap.putIfAbsent(document, singleAlarm);
            if (object == null) {
                object = singleAlarm;
            }
        }
        SingleAlarm.cancelAndRequest$default((SingleAlarm)((SingleAlarm)object), (boolean)false, (int)1, null);
    }

    @Nullable
    public final List<TTarget> getTargets(@NotNull Document document, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if ((SingleAlarm)this.myPerDocumentAlarms.get(document) == null) {
            return null;
        }
        DocumentTargets documentTargets = (DocumentTargets)this.myPerDocumentServices.get(document);
        return documentTargets != null ? documentTargets.getAtRange(range) : null;
    }

    private static final void N(RiderFrontendInspectionTargetsService riderFrontendInspectionTargetsService, Document document) {
        Intrinsics.checkNotNullParameter((Object)((Object)riderFrontendInspectionTargetsService), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)document, (String)"$document");
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)riderFrontendInspectionTargetsService.project);
        PsiFile psiFile = psiDocumentManager.getPsiFile(document);
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        riderFrontendInspectionTargetsService.myLogger.trace("Restarting daemon");
        DaemonCodeAnalyzer.getInstance((Project)riderFrontendInspectionTargetsService.project).restart(psiFile2);
        riderFrontendInspectionTargetsService.myLogger.trace("Daemon restarted");
    }

    private static final void j(RiderFrontendInspectionTargetsService riderFrontendInspectionTargetsService, Document document) {
        Intrinsics.checkNotNullParameter((Object)((Object)riderFrontendInspectionTargetsService), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)document, (String)"$document");
        ApplicationKt.getApplication().runReadAction(() -> RiderFrontendInspectionTargetsService.N(riderFrontendInspectionTargetsService, document));
    }

    public static final /* synthetic */ ConcurrentMap access$getMyPerDocumentServices$p(RiderFrontendInspectionTargetsService $this) {
        return $this.myPerDocumentServices;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0013J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\tR\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/spellChecker/RiderFrontendInspectionTargetsService$DocumentTargets;", "TTarget", "Lcom/jetbrains/rider/spellChecker/RiderFrontendInspectionTarget;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "idToTarget", "Ljava/util/concurrent/ConcurrentMap;", "", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "lock", "targetsSet", "Ljava/util/TreeSet;", "Lcom/intellij/openapi/util/Segment;", "add", "", "target", "(Lcom/jetbrains/rider/spellChecker/RiderFrontendInspectionTarget;)V", "getAtRange", "", "range", "Lcom/intellij/openapi/util/TextRange;", "remove", "id", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nRiderFrontendInspectionTargetsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderFrontendInspectionTargetsService.kt\ncom/jetbrains/rider/spellChecker/RiderFrontendInspectionTargetsService$DocumentTargets\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n1549#2:201\n1620#2,3:202\n*S KotlinDebug\n*F\n+ 1 RiderFrontendInspectionTargetsService.kt\ncom/jetbrains/rider/spellChecker/RiderFrontendInspectionTargetsService$DocumentTargets\n*L\n189#1:201\n189#1:202,3\n*E\n"})
    private static final class DocumentTargets<TTarget extends RiderFrontendInspectionTarget> {
        @NotNull
        private final Lifetime lifetime;
        @NotNull
        private final ConcurrentMap<Long, TTarget> idToTarget;
        @NotNull
        private final Object lock;
        @NotNull
        private final TreeSet<Segment> targetsSet;

        public DocumentTargets(@NotNull Lifetime lifetime2) {
            Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
            this.lifetime = lifetime2;
            this.idToTarget = new ConcurrentHashMap();
            this.lock = new Object();
            this.targetsSet = new TreeSet((arg_0, arg_1) -> DocumentTargets.j(targetsSet.1.INSTANCE, arg_0, arg_1));
        }

        @NotNull
        public final Lifetime getLifetime() {
            return this.lifetime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void remove(long id) {
            RiderFrontendInspectionTarget riderFrontendInspectionTarget = (RiderFrontendInspectionTarget)this.idToTarget.remove(id);
            Object object = this.lock;
            synchronized (object) {
                boolean bl = false;
                if (riderFrontendInspectionTarget != null) {
                    this.targetsSet.remove(riderFrontendInspectionTarget);
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void add(@NotNull TTarget target) {
            Intrinsics.checkNotNullParameter(target, (String)"target");
            RiderFrontendInspectionTarget riderFrontendInspectionTarget = (RiderFrontendInspectionTarget)this.idToTarget.put(((RiderFrontendInspectionTarget)target).getId(), target);
            Object object = this.lock;
            synchronized (object) {
                boolean bl = false;
                if (riderFrontendInspectionTarget != null) {
                    this.targetsSet.remove(riderFrontendInspectionTarget);
                }
                bl = this.targetsSet.add((Segment)target);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final List<TTarget> getAtRange(@NotNull TextRange range) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            List list = new ArrayList();
            Object object = this.lock;
            synchronized (object) {
                Segment segment;
                boolean bl = false;
                Iterator<Segment> iterator = this.targetsSet.subSet(new Point(0), true, new Point(range.getStartOffset()), false).descendingIterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"descendingIterator(...)");
                Object object2 = iterator;
                while (object2.hasNext() && range.intersects(segment = object2.next())) {
                    Intrinsics.checkNotNull((Object)segment, (String)"null cannot be cast to non-null type TTarget of com.jetbrains.rider.spellChecker.RiderFrontendInspectionTargetsService.DocumentTargets.getAtRange$lambda$4");
                    list.add((RiderFrontendInspectionTarget)segment);
                }
                NavigableSet<Segment> navigableSet = this.targetsSet.subSet(new Point(range.getStartOffset()), true, new Point(range.getEndOffset()), false);
                Intrinsics.checkNotNullExpressionValue(navigableSet, (String)"subSet(...)");
                object2 = navigableSet;
                List list2 = list;
                boolean bl2 = false;
                Object object3 = object2;
                Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
                boolean bl3 = false;
                Iterator iterator2 = object3.iterator();
                while (iterator2.hasNext()) {
                    Object t10 = iterator2.next();
                    Segment segment2 = (Segment)t10;
                    Collection collection2 = collection;
                    boolean bl4 = false;
                    Intrinsics.checkNotNull((Object)segment2, (String)"null cannot be cast to non-null type TTarget of com.jetbrains.rider.spellChecker.RiderFrontendInspectionTargetsService.DocumentTargets.getAtRange$lambda$4$lambda$3");
                    collection2.add((RiderFrontendInspectionTarget)segment2);
                }
                bl = list2.addAll((List)collection);
            }
            return list;
        }

        private static final int j(Function2 function2, Object object, Object object2) {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"$tmp0");
            return ((Number)function2.invoke(object, object2)).intValue();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/spellChecker/RiderFrontendInspectionTargetsService$Point;", "Lcom/intellij/openapi/util/Segment;", "from", "", "(I)V", "getFrom", "()I", "getEndOffset", "getStartOffset", "intellij.rider.rdclient.dotnet"})
    private static final class Point
    implements Segment {
        private final int from;

        public Point(int from) {
            this.from = from;
        }

        public final int getFrom() {
            return this.from;
        }

        public int getStartOffset() {
            return this.from;
        }

        public int getEndOffset() {
            return this.from;
        }
    }
}

