/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.spellChecker;

import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.AddRemove;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rider.model.RdDictionary;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\t\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fH\u0016J\b\u0010\u001c\u001a\u00020\u0003H\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fH\u0016J\u0012\u0010\u001e\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u0010\u001f\u001a\u00020\u00142\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0017H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u000e\u001a(\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u0010 \u0012*\u0012\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u00100\u0011\u00a2\u0006\u0002\b\u00100\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/rider/spellChecker/BackendDictionary;", "Lcom/intellij/spellchecker/dictionary/EditableDictionary;", "name", "", "rdDictionary", "Lcom/jetbrains/rider/model/RdDictionary;", "engineUpdateSink", "Lcom/jetbrains/rd/util/reactive/ISignal;", "", "spellCheckerManager", "Lcom/intellij/spellchecker/SpellCheckerManager;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "(Ljava/lang/String;Lcom/jetbrains/rider/model/RdDictionary;Lcom/jetbrains/rd/util/reactive/ISignal;Lcom/intellij/spellchecker/SpellCheckerManager;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "transformedWords", "", "Lorg/jetbrains/annotations/NotNull;", "", "kotlin.jvm.PlatformType", "addToDictionary", "", "word", "words", "", "clear", "contains", "(Ljava/lang/String;)Ljava/lang/Boolean;", "getEditableWords", "getName", "getWords", "removeFromDictionary", "replaceAll", "intellij.rider.rdclient.dotnet"})
public final class BackendDictionary
implements EditableDictionary {
    @NotNull
    private final String name;
    @NotNull
    private final RdDictionary rdDictionary;
    @NotNull
    private final ISignal<Boolean> engineUpdateSink;
    @NotNull
    private final SpellCheckerManager spellCheckerManager;
    @NotNull
    private final Set<String> transformedWords;

    public BackendDictionary(@NotNull String name, @NotNull RdDictionary rdDictionary, @NotNull ISignal<Boolean> engineUpdateSink, @NotNull SpellCheckerManager spellCheckerManager, @NotNull Lifetime lifetime2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)rdDictionary), (String)"rdDictionary");
        Intrinsics.checkNotNullParameter(engineUpdateSink, (String)"engineUpdateSink");
        Intrinsics.checkNotNullParameter((Object)spellCheckerManager, (String)"spellCheckerManager");
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        this.name = name;
        this.rdDictionary = rdDictionary;
        this.engineUpdateSink = engineUpdateSink;
        this.spellCheckerManager = spellCheckerManager;
        Set set = ContainerUtil.newConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"newConcurrentSet(...)");
        this.transformedWords = set;
        this.rdDictionary.getContent().advise(lifetime2, (Function2)new Function2<AddRemove, String, Unit>(){

            public final void invoke(@NotNull AddRemove addRemove, @NotNull String word) {
                Intrinsics.checkNotNullParameter((Object)addRemove, (String)"addRemove");
                Intrinsics.checkNotNullParameter((Object)word, (String)"word");
                switch (WhenMappings.$EnumSwitchMapping$0[addRemove.ordinal()]) {
                    case 1: {
                        Object object = spellCheckerManager.getSpellChecker();
                        if (object == null || (object = object.getTransformation()) == null || (object = object.transform(word)) == null) {
                            return;
                        }
                        Object object2 = object;
                        transformedWords.add(object2);
                        break;
                    }
                    case 2: {
                        Object object = spellCheckerManager.getSpellChecker();
                        if (object == null || (object = object.getTransformation()) == null || (object = object.transform(word)) == null) {
                            return;
                        }
                        Object object3 = object;
                        transformedWords.remove(object3);
                    }
                }
                engineUpdateSink.fire((Object)true);
            }

            @Metadata(mv={1, 9, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[AddRemove.values().length];
                    try {
                        nArray[AddRemove.Add.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[AddRemove.Remove.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        });
    }

    @Nullable
    public Boolean contains(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        return this.transformedWords.contains(word) ? Boolean.valueOf(true) : null;
    }

    public void clear() {
        this.transformedWords.clear();
        this.rdDictionary.getContent().clear();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void replaceAll(@Nullable Collection<String> words) {
        this.transformedWords.clear();
        this.rdDictionary.getContent().clear();
        if (words != null) {
            this.transformedWords.addAll(words);
            this.rdDictionary.getContent().addAll(words);
        }
    }

    @NotNull
    public Set<String> getWords() {
        return this.transformedWords;
    }

    @NotNull
    public Set<String> getEditableWords() {
        return this.transformedWords;
    }

    public void removeFromDictionary(@Nullable String word) {
        if (word != null) {
            this.transformedWords.remove(word);
            this.rdDictionary.getContent().remove((Object)word);
        }
    }

    public void addToDictionary(@Nullable String word) {
        if (word != null) {
            this.transformedWords.add(word);
            this.rdDictionary.getContent().add((Object)word);
        }
    }

    public void addToDictionary(@Nullable Collection<String> words) {
        if (words != null) {
            this.transformedWords.addAll(words);
            this.rdDictionary.getContent().addAll(words);
        }
    }
}

