/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.tree.renderers;

import com.intellij.ui.components.JBComboBoxLabel;
import com.jetbrains.rider.model.EnumWithValue;
import com.jetbrains.rider.model.RdColor;
import com.jetbrains.rider.model.Severity;
import com.jetbrains.rider.model.SeverityElement;
import com.jetbrains.rider.settings.RiderSettingsBundle;
import com.jetbrains.rider.settings.util.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J8\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/settings/tree/renderers/NodeNotifyRenderer;", "Ljavax/swing/table/TableCellRenderer;", "()V", "colorUtil", "Lcom/jetbrains/rider/settings/util/ColorUtil;", "myEmptyLabel", "Ljavax/swing/JPanel;", "myEnumRenderer", "Lcom/intellij/ui/components/JBComboBoxLabel;", "myReadonlyRenderer", "j", "Ljava/awt/Component;", "value", "", "background", "Ljava/awt/Color;", "j", "Lcom/jetbrains/rider/model/SeverityElement;", "severity", "Lcom/jetbrains/rider/model/Severity;", "getTableCellRendererComponent", "table", "Ljavax/swing/JTable;", "isSelected", "", "hasFocus", "row", "", "column", "intellij.rider.rdclient.dotnet"})
public final class NodeNotifyRenderer
implements TableCellRenderer {
    @NotNull
    private final JBComboBoxLabel myEnumRenderer = new JBComboBoxLabel();
    @NotNull
    private final JBComboBoxLabel myReadonlyRenderer = new JBComboBoxLabel();
    @NotNull
    private final JPanel myEmptyLabel = new JPanel();
    @NotNull
    private final ColorUtil colorUtil = new ColorUtil();

    public NodeNotifyRenderer() {
        this.myEnumRenderer.setEnabled(true);
        this.myEnumRenderer.setHorizontalAlignment(0);
        this.myEnumRenderer.setRegularIcon();
        this.myReadonlyRenderer.setEnabled(false);
        this.myReadonlyRenderer.setHorizontalAlignment(0);
        this.myReadonlyRenderer.setSelectionIcon();
        Color color = this.myReadonlyRenderer.getForeground();
        this.myReadonlyRenderer.setForeground(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)Math.round((double)color.getAlpha() * 0.5)));
    }

    @Override
    @NotNull
    public Component getTableCellRendererComponent(@NotNull JTable table2, @NotNull Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Color color = table2.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackground(...)");
        Component component = this.j(value2, color);
        return component;
    }

    private final Component j(Object object, Color color) {
        if (object instanceof Severity) {
            SeverityElement severityElement = this.j((Severity)((Object)object));
            if (severityElement != null) {
                String string = severityElement.getValue().getPresentation();
                RdColor rdColor = severityElement.getColor();
                Color color2 = new Color(rdColor.getR(), rdColor.getG(), rdColor.getB(), rdColor.getA());
                if (((Severity)((Object)object)).isEnabled()) {
                    this.myEnumRenderer.setText(string);
                    this.myEnumRenderer.setBackground(ColorUtil.convertColor$default(this.colorUtil, color2, 0.0, 2, null));
                    return (Component)this.myEnumRenderer;
                }
                this.myReadonlyRenderer.setText(string);
                this.myReadonlyRenderer.setBackground(this.colorUtil.convertColor(color2, 0.5));
                return (Component)this.myReadonlyRenderer;
            }
            this.myReadonlyRenderer.setText(RiderSettingsBundle.Companion.message("label.unknown", new Object[0]));
            return (Component)this.myReadonlyRenderer;
        }
        this.myEmptyLabel.setBackground(color);
        return this.myEmptyLabel;
    }

    private final SeverityElement j(Severity severity) {
        Integer n2 = (Integer)severity.getValue().getValueOrNull();
        for (SeverityElement severityElement : severity.getPossibleValues()) {
            EnumWithValue enumWithValue = severityElement.getValue();
            Integer n3 = n2;
            if (n3 == null || enumWithValue.getValue() != n3.intValue()) continue;
            return severityElement;
        }
        return null;
    }
}

