/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.tree.editors;

import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.IconUtil;
import com.jetbrains.rd.ide.model.CodeStyleOrderedCollectionOption;
import com.jetbrains.rd.ide.model.OrderedCollection;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.settings.tree.editors.DirectionButtonListener;
import com.jetbrains.rider.settings.tree.editors.MyListSelectionListener;
import com.jetbrains.rider.settings.tree.editors.OptionEditorExKt;
import com.jetbrains.rider.settings.tree.renderers.CodeStyleOrderedCollectionRenderer;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bJB\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\n\b\u0001\u0010\"\u001a\u0004\u0018\u00010\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/rider/settings/tree/editors/OrderedCollectionEditor;", "", "()V", "downButton", "Ljavax/swing/JButton;", "initialValues", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "listView", "Lcom/intellij/ui/components/JBList;", "model", "Ljavax/swing/DefaultListModel;", "panel", "Ljavax/swing/JPanel;", "panelWithButtons", "selectedValuePanel", "Lcom/jetbrains/rider/settings/tree/renderers/CodeStyleOrderedCollectionRenderer;", "getSelectedValuePanel", "()Lcom/jetbrains/rider/settings/tree/renderers/CodeStyleOrderedCollectionRenderer;", "upButton", "getValue", "reset", "", "option", "Lcom/jetbrains/rd/ide/model/CodeStyleOrderedCollectionOption;", "table", "Ljavax/swing/JTable;", "row", "", "column", "isEnabled", "", "isHighlighted", "tooltip", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nOrderedCollectionEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrderedCollectionEditor.kt\ncom/jetbrains/rider/settings/tree/editors/OrderedCollectionEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,157:1\n1855#2,2:158\n32#3,2:160\n*S KotlinDebug\n*F\n+ 1 OrderedCollectionEditor.kt\ncom/jetbrains/rider/settings/tree/editors/OrderedCollectionEditor\n*L\n59#1:158,2\n92#1:160,2\n*E\n"})
public final class OrderedCollectionEditor {
    @NotNull
    private final CodeStyleOrderedCollectionRenderer selectedValuePanel = new CodeStyleOrderedCollectionRenderer();
    @NotNull
    private final DefaultListModel<String> model = new DefaultListModel();
    @NotNull
    private ArrayList<String> initialValues = new ArrayList();
    @NotNull
    private final JBList<String> listView = new JBList((ListModel)this.model);
    @NotNull
    private final JPanel panel = new JPanel();
    @NotNull
    private final JButton upButton = new JButton();
    @NotNull
    private final JButton downButton = new JButton();
    @NotNull
    private final JPanel panelWithButtons = new JPanel();

    public OrderedCollectionEditor() {
        this.upButton.addActionListener(new DirectionButtonListener(this.model, this.listView, true));
        this.downButton.addActionListener(new DirectionButtonListener(this.model, this.listView, false));
        this.upButton.setIcon(IconUtil.getMoveUpIcon());
        this.downButton.setIcon(IconUtil.getMoveDownIcon());
        this.panelWithButtons.setLayout(new GridLayout(2, 1));
        this.panelWithButtons.add(this.upButton);
        this.panelWithButtons.add(this.downButton);
        this.listView.addListSelectionListener((ListSelectionListener)new MyListSelectionListener(this.model, this.listView, this.upButton, this.downButton));
        this.panel.add((Component)this.listView);
        this.panel.add(this.panelWithButtons);
    }

    @NotNull
    public final CodeStyleOrderedCollectionRenderer getSelectedValuePanel() {
        return this.selectedValuePanel;
    }

    public final void reset(@NotNull CodeStyleOrderedCollectionOption option, @NotNull JTable table2, int row, int column, boolean isEnabled, boolean isHighlighted, @NlsContexts.Tooltip @Nullable String tooltip2) {
        String string;
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        this.model.removeAllElements();
        this.initialValues.clear();
        this.selectedValuePanel.reset(option, isEnabled, isHighlighted, tooltip2);
        Object object2 = ((OrderedCollection)((Object)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)option.getValue())))).getItems();
        boolean bl = false;
        RelativePoint relativePoint = object2.iterator();
        while (relativePoint.hasNext()) {
            object = relativePoint.next();
            string = (String)object;
            boolean bl2 = false;
            this.model.addElement(string);
            this.initialValues.add(string);
        }
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        object2 = table2.getCellRect(row, column, true);
        Point point = new Point(((Rectangle)object2).x, ((Rectangle)object2).y + table2.getRowHeight());
        relativePoint = new RelativePoint((Component)table2, point);
        ComponentPopupBuilder componentPopupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.panel, (JComponent)this.panel).setRequestFocus(true).setFocusable(true);
        Intrinsics.checkNotNullExpressionValue((Object)componentPopupBuilder, (String)"setFocusable(...)");
        string = OptionEditorExKt.disableSurrenderFocusOnKeystroke(componentPopupBuilder, table2).setResizable(false).setMovable(false).setModalContext(false).setShowShadow(true).setShowBorder(true).setCancelKeyEnabled(true).setCancelOnClickOutside(true).setCancelOnOtherWindowOpen(true).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"createPopup(...)");
        object = string;
        object.show(relativePoint);
    }

    @NotNull
    public final ArrayList<String> getValue() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<String> enumeration = this.model.elements();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"elements(...)");
        Iterator iterator = CollectionsKt.iterator(enumeration);
        boolean bl = false;
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e2 = iterator2.next();
            String string = (String)e2;
            boolean bl2 = false;
            arrayList.add(string);
        }
        return arrayList;
    }
}

