/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.naming;

import com.intellij.util.ui.ItemRemovable;
import com.jetbrains.rider.settings.RiderSettingsBundle;
import com.jetbrains.rider.settings.naming.MutableNamingRule;
import com.jetbrains.rider.settings.naming.NamingStyleKindsConverter;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\fH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\fH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\fH\u0016J\"\u0010\u001b\u001a\u00020\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/settings/naming/NamingRulesTableModel;", "Ljavax/swing/table/AbstractTableModel;", "Lcom/intellij/util/ui/ItemRemovable;", "myPatterns", "", "Lcom/jetbrains/rider/settings/naming/MutableNamingRule;", "(Ljava/util/List;)V", "styleConverter", "Lcom/jetbrains/rider/settings/naming/NamingStyleKindsConverter;", "getColumnClass", "Ljava/lang/Class;", "column", "", "getColumnCount", "getColumnName", "", "getRowCount", "getValueAt", "", "row", "isCellEditable", "", "rowIndex", "columnIndex", "removeRow", "", "index", "setValueAt", "value", "intellij.rider.rdclient.dotnet"})
public final class NamingRulesTableModel
extends AbstractTableModel
implements ItemRemovable {
    @NotNull
    private final List<MutableNamingRule> myPatterns;
    @NotNull
    private final NamingStyleKindsConverter styleConverter;

    public NamingRulesTableModel(@NotNull List<MutableNamingRule> myPatterns) {
        Intrinsics.checkNotNullParameter(myPatterns, (String)"myPatterns");
        this.myPatterns = myPatterns;
        this.styleConverter = new NamingStyleKindsConverter();
    }

    @Override
    @NotNull
    public String getColumnName(int column) {
        return RiderSettingsBundle.Companion.message("NamingRulesTableModel.column.name.rules", new Object[0]);
    }

    @Override
    @NotNull
    public Class<?> getColumnClass(int column) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        return this.myPatterns.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    @NotNull
    public Object getValueAt(int row, int column) {
        MutableNamingRule mutableNamingRule = this.myPatterns.get(row);
        String string = this.styleConverter.convert(mutableNamingRule.getKind());
        Object object = mutableNamingRule.getPrefix() + string + mutableNamingRule.getSuffix();
        if (row == 0) {
            Object[] objectArray = new Object[]{object};
            object = RiderSettingsBundle.Companion.message("NamingRulesTableModel.default.wrapper.for.naming.rule", objectArray);
        }
        return object;
    }

    @Override
    public void setValueAt(@Nullable Object value2, int row, int column) {
    }

    public void removeRow(int index2) {
        this.myPatterns.remove(index2);
        this.fireTableRowsDeleted(index2, index2);
    }
}

