/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.naming;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.jetbrains.rd.util.reactive.IMutablePropertyBase;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rider.model.NamingPolicy;
import com.jetbrains.rider.model.NamingRule;
import com.jetbrains.rider.model.NamingStyleKinds;
import com.jetbrains.rider.settings.RiderSettingsBundle;
import com.jetbrains.rider.settings.naming.ICurrentPolicyProvider;
import com.jetbrains.rider.settings.naming.MutableNamingRule;
import com.jetbrains.rider.settings.naming.NamingChangeTracker;
import com.jetbrains.rider.settings.naming.NamingRuleEditor;
import com.jetbrains.rider.settings.naming.NamingRulesTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0014\u001a\u00020\u000bH\u0002J\b\u0010\u0015\u001a\u00020\u000bH\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\rH\u0002J\u001c\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0$J\b\u0010%\u001a\u00020\"H\u0016J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u0019H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/jetbrains/rider/settings/naming/NamingPolicyEditor;", "Ljavax/swing/JPanel;", "Lcom/jetbrains/rider/settings/naming/ICurrentPolicyProvider;", "namingRuleEditor", "Lcom/jetbrains/rider/settings/naming/NamingRuleEditor;", "namingChangeTracker", "Lcom/jetbrains/rider/settings/naming/NamingChangeTracker;", "(Lcom/jetbrains/rider/settings/naming/NamingRuleEditor;Lcom/jetbrains/rider/settings/naming/NamingChangeTracker;)V", "inspectionsEnabled", "Ljavax/swing/JCheckBox;", "myRuleSelected", "", "myTable", "Lcom/intellij/ui/table/JBTable;", "rules", "Ljava/util/ArrayList;", "Lcom/jetbrains/rider/settings/naming/MutableNamingRule;", "Lkotlin/collections/ArrayList;", "tableSelectionModel", "Ljavax/swing/ListSelectionModel;", "N", "j", "j", "", "from", "", "to", "j", "rule", "Lcom/jetbrains/rider/model/NamingRule;", "j", "table", "fillFromPolicy", "initialValue", "Lcom/jetbrains/rider/model/NamingPolicy;", "policy", "Lcom/jetbrains/rd/util/reactive/IOptProperty;", "get", "j", "k", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nNamingPolicyEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamingPolicyEditor.kt\ncom/jetbrains/rider/settings/naming/NamingPolicyEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n1864#2,3:187\n1855#2,2:190\n*S KotlinDebug\n*F\n+ 1 NamingPolicyEditor.kt\ncom/jetbrains/rider/settings/naming/NamingPolicyEditor\n*L\n79#1:187,3\n100#1:190,2\n*E\n"})
public final class NamingPolicyEditor
extends JPanel
implements ICurrentPolicyProvider {
    @NotNull
    private final NamingRuleEditor namingRuleEditor;
    @NotNull
    private final NamingChangeTracker namingChangeTracker;
    @NotNull
    private final JCheckBox inspectionsEnabled;
    @NotNull
    private final ArrayList<MutableNamingRule> rules;
    @NotNull
    private final ListSelectionModel tableSelectionModel;
    private boolean myRuleSelected;
    @NotNull
    private final JBTable myTable;

    public NamingPolicyEditor(@NotNull NamingRuleEditor namingRuleEditor, @NotNull NamingChangeTracker namingChangeTracker) {
        Intrinsics.checkNotNullParameter((Object)namingRuleEditor, (String)"namingRuleEditor");
        Intrinsics.checkNotNullParameter((Object)namingChangeTracker, (String)"namingChangeTracker");
        this.namingRuleEditor = namingRuleEditor;
        this.namingChangeTracker = namingChangeTracker;
        this.inspectionsEnabled = new JCheckBox();
        this.rules = new ArrayList();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        this.inspectionsEnabled.setText(RiderSettingsBundle.Companion.message("NamingPolicyEditor.checkbox.enable.inspection", new Object[0]));
        this.inspectionsEnabled.setAlignmentX(0.0f);
        jPanel.setAlignmentX(0.0f);
        jPanel.add(this.inspectionsEnabled);
        this.add((Component)jPanel, "Last");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.namingRuleEditor, "Last");
        NamingRulesTableModel namingRulesTableModel = new NamingRulesTableModel((List<MutableNamingRule>)this.rules);
        this.myTable = new JBTable((TableModel)namingRulesTableModel);
        ListSelectionModel listSelectionModel = this.myTable.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)listSelectionModel, (String)"getSelectionModel(...)");
        this.tableSelectionModel = listSelectionModel;
        this.tableSelectionModel.setSelectionMode(0);
        this.tableSelectionModel.addListSelectionListener(arg_0 -> NamingPolicyEditor.j(this, arg_0));
        JPanel jPanel3 = this.j(this.myTable);
        jPanel2.add(jPanel3);
        this.add(jPanel2);
        this.inspectionsEnabled.addActionListener(arg_0 -> NamingPolicyEditor.j(this, arg_0));
        this.inspectionsEnabled.setEnabled(false);
    }

    @Override
    @NotNull
    public NamingPolicy get() {
        boolean bl = this.inspectionsEnabled.isSelected();
        ArrayList<NamingRule> arrayList = new ArrayList<NamingRule>();
        MutableNamingRule mutableNamingRule = (MutableNamingRule)CollectionsKt.first((List)this.rules);
        NamingRule namingRule = new NamingRule(mutableNamingRule.getKind(), mutableNamingRule.getPrefix(), mutableNamingRule.getSuffix());
        Iterable iterable = this.rules;
        boolean bl2 = false;
        int n2 = 0;
        for (Object t10 : iterable) {
            int n3;
            if ((n3 = n2++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            MutableNamingRule mutableNamingRule2 = (MutableNamingRule)t10;
            int n4 = n3;
            boolean bl3 = false;
            if (n4 == 0) continue;
            NamingRule namingRule2 = new NamingRule(mutableNamingRule2.getKind(), mutableNamingRule2.getPrefix(), mutableNamingRule2.getSuffix());
            arrayList.add(namingRule2);
        }
        return new NamingPolicy(namingRule, (List<NamingRule>)arrayList, bl);
    }

    public final void fillFromPolicy(@NotNull NamingPolicy initialValue, @NotNull IOptProperty<NamingPolicy> policy) {
        Intrinsics.checkNotNullParameter((Object)((Object)initialValue), (String)"initialValue");
        Intrinsics.checkNotNullParameter(policy, (String)"policy");
        int n2 = this.tableSelectionModel.getLeadSelectionIndex();
        this.tableSelectionModel.clearSelection();
        this.namingChangeTracker.stopTracking();
        NamingPolicy namingPolicy = initialValue;
        this.inspectionsEnabled.setSelected(namingPolicy.getEnableInspection());
        this.inspectionsEnabled.setEnabled(true);
        this.myRuleSelected = true;
        this.rules.clear();
        this.rules.add(this.j(namingPolicy.getRule()));
        Iterable iterable = namingPolicy.getExtraRules();
        boolean bl = false;
        for (Object t10 : iterable) {
            NamingRule namingRule = (NamingRule)t10;
            boolean bl2 = false;
            this.rules.add(this.j(namingRule));
        }
        if (n2 >= 0 && n2 < ((Collection)this.rules).size()) {
            this.j(n2);
        } else {
            this.j(0);
        }
        this.validate();
        this.repaint();
        this.namingChangeTracker.startTracking((IMutablePropertyBase<NamingPolicy>)((IMutablePropertyBase)policy));
    }

    private final JPanel j(JBTable jBTable) {
        AnActionButtonRunnable anActionButtonRunnable = arg_0 -> NamingPolicyEditor.j(this, arg_0);
        AnActionButtonRunnable anActionButtonRunnable2 = arg_0 -> NamingPolicyEditor.w(this, arg_0);
        AnActionButtonRunnable anActionButtonRunnable3 = arg_0 -> NamingPolicyEditor.v(this, arg_0);
        AnActionButtonRunnable anActionButtonRunnable4 = arg_0 -> NamingPolicyEditor.N(this, arg_0);
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)((JTable)jBTable)).setAddAction(anActionButtonRunnable).setAddActionUpdater(arg_0 -> NamingPolicyEditor.N(this, arg_0)).setRemoveAction(anActionButtonRunnable2).setRemoveActionUpdater(arg_0 -> NamingPolicyEditor.j(this, arg_0)).setMoveUpAction(anActionButtonRunnable3).setMoveDownAction(anActionButtonRunnable4).createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        return jPanel;
    }

    private final MutableNamingRule j(NamingRule namingRule) {
        return new MutableNamingRule(namingRule.getKind(), namingRule.getPrefix(), namingRule.getSuffix());
    }

    private final void j(int n2, int n3) {
        MutableNamingRule mutableNamingRule = this.rules.get(n2);
        Intrinsics.checkNotNullExpressionValue((Object)mutableNamingRule, (String)"get(...)");
        MutableNamingRule mutableNamingRule2 = mutableNamingRule;
        MutableNamingRule mutableNamingRule3 = this.rules.get(n3);
        Intrinsics.checkNotNullExpressionValue((Object)mutableNamingRule3, (String)"get(...)");
        MutableNamingRule mutableNamingRule4 = mutableNamingRule3;
        this.rules.set(n3, mutableNamingRule2);
        this.rules.set(n2, mutableNamingRule4);
        this.tableSelectionModel.clearSelection();
        this.j(n3);
        this.namingChangeTracker.handleDataChanged();
    }

    private final void j(int n2) {
        this.tableSelectionModel.setSelectionInterval(n2, n2);
    }

    private final boolean N() {
        return this.myRuleSelected;
    }

    private final boolean j() {
        return ((Collection)this.rules).size() > 1;
    }

    private static final void j(NamingPolicyEditor namingPolicyEditor, ListSelectionEvent listSelectionEvent) {
        Intrinsics.checkNotNullParameter((Object)namingPolicyEditor, (String)"this$0");
        int n2 = namingPolicyEditor.tableSelectionModel.getLeadSelectionIndex();
        namingPolicyEditor.tableSelectionModel.getMaxSelectionIndex();
        if (n2 >= 0) {
            MutableNamingRule mutableNamingRule = namingPolicyEditor.rules.get(n2);
            Intrinsics.checkNotNullExpressionValue((Object)mutableNamingRule, (String)"get(...)");
            MutableNamingRule mutableNamingRule2 = mutableNamingRule;
            namingPolicyEditor.namingChangeTracker.stopTracking();
            namingPolicyEditor.namingRuleEditor.fillFromRule(mutableNamingRule2);
            NamingChangeTracker.startTracking$default(namingPolicyEditor.namingChangeTracker, null, 1, null);
            TableUtil.updateScroller((JTable)((JTable)namingPolicyEditor.myTable));
            TableUtil.scrollSelectionToVisible((JTable)((JTable)namingPolicyEditor.myTable));
        }
    }

    private static final void j(NamingPolicyEditor namingPolicyEditor, ActionEvent actionEvent) {
        Intrinsics.checkNotNullParameter((Object)namingPolicyEditor, (String)"this$0");
        namingPolicyEditor.namingChangeTracker.handleDataChanged();
    }

    private static final void j(NamingPolicyEditor namingPolicyEditor, AnActionButton anActionButton) {
        Intrinsics.checkNotNullParameter((Object)namingPolicyEditor, (String)"this$0");
        namingPolicyEditor.tableSelectionModel.clearSelection();
        MutableNamingRule mutableNamingRule = new MutableNamingRule(NamingStyleKinds.AaBb, "", "");
        namingPolicyEditor.rules.add(mutableNamingRule);
        int n2 = ((Collection)namingPolicyEditor.rules).size() - 1;
        namingPolicyEditor.j(n2);
        namingPolicyEditor.namingChangeTracker.handleDataChanged();
    }

    private static final void w(NamingPolicyEditor namingPolicyEditor, AnActionButton anActionButton) {
        Intrinsics.checkNotNullParameter((Object)namingPolicyEditor, (String)"this$0");
        if (((Collection)namingPolicyEditor.rules).size() <= 1) {
            return;
        }
        int n2 = namingPolicyEditor.tableSelectionModel.getLeadSelectionIndex();
        if (n2 >= 0) {
            namingPolicyEditor.tableSelectionModel.clearSelection();
            namingPolicyEditor.rules.remove(n2);
            int n3 = n2 > 0 ? n2 - 1 : 0;
            namingPolicyEditor.j(n3);
            namingPolicyEditor.namingChangeTracker.handleDataChanged();
        }
    }

    private static final void v(NamingPolicyEditor namingPolicyEditor, AnActionButton anActionButton) {
        Intrinsics.checkNotNullParameter((Object)namingPolicyEditor, (String)"this$0");
        int n2 = namingPolicyEditor.tableSelectionModel.getLeadSelectionIndex();
        if (n2 > 0) {
            namingPolicyEditor.j(n2, n2 - 1);
        }
    }

    private static final void N(NamingPolicyEditor namingPolicyEditor, AnActionButton anActionButton) {
        Intrinsics.checkNotNullParameter((Object)namingPolicyEditor, (String)"this$0");
        int n2 = namingPolicyEditor.tableSelectionModel.getLeadSelectionIndex();
        if (n2 < ((Collection)namingPolicyEditor.rules).size() - 1) {
            namingPolicyEditor.j(n2, n2 + 1);
        }
    }

    private static final boolean N(NamingPolicyEditor namingPolicyEditor, AnActionEvent anActionEvent) {
        Intrinsics.checkNotNullParameter((Object)namingPolicyEditor, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)anActionEvent, (String)"it");
        return namingPolicyEditor.N();
    }

    private static final boolean j(NamingPolicyEditor namingPolicyEditor, AnActionEvent anActionEvent) {
        Intrinsics.checkNotNullParameter((Object)namingPolicyEditor, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)anActionEvent, (String)"it");
        return namingPolicyEditor.j();
    }
}

