/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.codeStyle;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 +2\u00020\u0001:\u0001+B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010!\u001a\u0004\u0018\u00010\"J\b\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\tH\u0002J\u0010\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020\tH\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006,"}, d2={"Lcom/jetbrains/rider/settings/codeStyle/DialogPositionProvider;", "", "myEditor", "Lcom/intellij/openapi/editor/Editor;", "size", "Ljava/awt/Dimension;", "myDocument", "Lcom/intellij/openapi/editor/Document;", "selectionStartOffset", "", "selectionEndOffset", "parent", "Ljava/awt/Component;", "(Lcom/intellij/openapi/editor/Editor;Ljava/awt/Dimension;Lcom/intellij/openapi/editor/Document;IILjava/awt/Component;)V", "myContentComponent", "Ljavax/swing/JComponent;", "getMyDocument", "()Lcom/intellij/openapi/editor/Document;", "getMyEditor", "()Lcom/intellij/openapi/editor/Editor;", "myEditorComponent", "myEditorComponentHeight", "myEditorComponentWidth", "mySelectionEndY", "mySelectionStartY", "myTextRangeMaxColumnX", "getParent", "()Ljava/awt/Component;", "getSelectionEndOffset", "()I", "getSelectionStartOffset", "getSize", "()Ljava/awt/Dimension;", "calculateLocation", "Ljava/awt/Point;", "j", "", "j", "Lcom/intellij/openapi/editor/VisualPosition;", "startOffset", "endOffset", "j", "dialogHeight", "Companion", "intellij.rider.rdclient.dotnet"})
public final class DialogPositionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final Dimension size;
    @NotNull
    private final Document myDocument;
    private final int selectionStartOffset;
    private final int selectionEndOffset;
    @NotNull
    private final Component parent;
    @NotNull
    private final JComponent myEditorComponent;
    @NotNull
    private final JComponent myContentComponent;
    private int mySelectionStartY;
    private int mySelectionEndY;
    private int myTextRangeMaxColumnX;
    private final int myEditorComponentWidth;
    private final int myEditorComponentHeight;
    private static final int PREFERRED_PADDING = 100;

    public DialogPositionProvider(@NotNull Editor myEditor, @NotNull Dimension size, @NotNull Document myDocument, int selectionStartOffset, int selectionEndOffset, @NotNull Component parent) {
        Intrinsics.checkNotNullParameter((Object)myEditor, (String)"myEditor");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)myDocument, (String)"myDocument");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.myEditor = myEditor;
        this.size = size;
        this.myDocument = myDocument;
        this.selectionStartOffset = selectionStartOffset;
        this.selectionEndOffset = selectionEndOffset;
        this.parent = parent;
        JComponent jComponent = this.myEditor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        this.myContentComponent = jComponent;
        JComponent jComponent2 = this.myEditor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"getComponent(...)");
        this.myEditorComponent = jComponent2;
        this.myEditorComponentWidth = this.myEditorComponent.getWidth();
        this.myEditorComponentHeight = this.myEditorComponent.getHeight();
    }

    @NotNull
    public final Editor getMyEditor() {
        return this.myEditor;
    }

    @NotNull
    public final Dimension getSize() {
        return this.size;
    }

    @NotNull
    public final Document getMyDocument() {
        return this.myDocument;
    }

    public final int getSelectionStartOffset() {
        return this.selectionStartOffset;
    }

    public final int getSelectionEndOffset() {
        return this.selectionEndOffset;
    }

    @NotNull
    public final Component getParent() {
        return this.parent;
    }

    @Nullable
    public final Point calculateLocation() {
        this.j();
        int n2 = this.size.width;
        int n3 = this.size.height;
        int n4 = this.myEditorComponentWidth - (this.myTextRangeMaxColumnX + n2);
        Integer n5 = null;
        Integer n6 = null;
        if (n4 > -100) {
            int n7 = n4 > 100 ? 100 : n4 / 2;
            n5 = this.myTextRangeMaxColumnX + n7;
            n6 = this.mySelectionEndY - this.mySelectionStartY > n3 ? Integer.valueOf((this.myEditorComponentHeight - n3) / 2) : Integer.valueOf(this.j(n3));
        } else if (this.mySelectionStartY > n3) {
            n5 = (this.myEditorComponentWidth - n2) / 2;
            n6 = this.mySelectionStartY - n3;
        } else if (this.mySelectionEndY + n3 < this.myEditorComponentHeight) {
            n5 = (this.myEditorComponentWidth - n2) / 2;
            n6 = this.mySelectionEndY;
        }
        if (n5 != null && n6 != null) {
            Point point = new Point(n5, n6);
            SwingUtilities.convertPointToScreen(point, this.myEditor.getComponent());
            return point;
        }
        return null;
    }

    private final int j(int n2) {
        int n3;
        int n4 = (this.mySelectionStartY + this.mySelectionEndY) / 2;
        int n5 = n4 - n2 / 2;
        int n6 = n4 + n2 / 2;
        if (n5 >= 0 && n6 <= this.myEditorComponentHeight) {
            return n5;
        }
        if (n5 < 0) {
            int n7 = -n5;
            if (n6 + n7 <= this.myEditorComponentHeight) {
                return 0;
            }
        } else if (n6 > this.myEditorComponentHeight && n5 - (n3 = n6 - this.myEditorComponentHeight) >= 0) {
            return n5 - n3;
        }
        return 0;
    }

    private final void j() {
        VisualPosition visualPosition = this.j(this.selectionStartOffset, this.selectionEndOffset);
        Point point = this.myEditor.visualPositionToXY(visualPosition);
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"visualPositionToXY(...)");
        Point point2 = point;
        Point point3 = this.myEditor.visualPositionToXY(this.myEditor.offsetToVisualPosition(this.selectionStartOffset));
        Intrinsics.checkNotNullExpressionValue((Object)point3, (String)"visualPositionToXY(...)");
        Point point4 = point3;
        Point point5 = this.myEditor.visualPositionToXY(this.myEditor.offsetToVisualPosition(this.selectionEndOffset));
        Intrinsics.checkNotNullExpressionValue((Object)point5, (String)"visualPositionToXY(...)");
        Point point6 = point5;
        Point point7 = SwingUtilities.convertPoint(this.myContentComponent, point4, this.parent);
        Intrinsics.checkNotNullExpressionValue((Object)point7, (String)"convertPoint(...)");
        point4 = point7;
        Point point8 = SwingUtilities.convertPoint(this.myContentComponent, point6, this.parent);
        Intrinsics.checkNotNullExpressionValue((Object)point8, (String)"convertPoint(...)");
        point6 = point8;
        Point point9 = SwingUtilities.convertPoint(this.myContentComponent, point2, this.parent);
        Intrinsics.checkNotNullExpressionValue((Object)point9, (String)"convertPoint(...)");
        point2 = point9;
        this.mySelectionStartY = point4.y;
        this.mySelectionEndY = point6.y;
        this.myTextRangeMaxColumnX = point2.x;
    }

    private final VisualPosition j(int n2, int n3) {
        int n4 = this.myDocument.getLineNumber(n2);
        int n5 = this.myDocument.getLineNumber(n3);
        VisualPosition visualPosition = new VisualPosition(0, 0);
        int n6 = n4;
        if (n6 <= n5) {
            while (true) {
                VisualPosition visualPosition2;
                int n7 = this.myDocument.getLineEndOffset(n6);
                Intrinsics.checkNotNullExpressionValue((Object)this.myEditor.offsetToVisualPosition(n7), (String)"offsetToVisualPosition(...)");
                if (visualPosition2.getColumn() > visualPosition.getColumn()) {
                    visualPosition = visualPosition2;
                }
                if (n6 == n5) break;
                ++n6;
            }
        }
        return visualPosition;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/settings/codeStyle/DialogPositionProvider$Companion;", "", "()V", "PREFERRED_PADDING", "", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

