/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.codeStyle;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rd.ide.model.CategoryGroup;
import com.jetbrains.rd.ide.model.CodeStyleGroupOption;
import com.jetbrains.rd.ide.model.CodeStyleOptionBase;
import com.jetbrains.rd.ide.model.ConfigureFormattingRdModel;
import com.jetbrains.rd.ide.model.RdTextRange;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHost;
import com.jetbrains.rider.editors.TextControlUtilsKt;
import com.jetbrains.rider.model.SettingsLayer;
import com.jetbrains.rider.settings.OptionsUtilsHost;
import com.jetbrains.rider.settings.RiderSettingsBundle;
import com.jetbrains.rider.settings.codeStyle.ConfigureFormattingDialog;
import com.jetbrains.rider.settings.codeStyle.DialogPositionProvider;
import com.jetbrains.rider.settings.tree.CodeStyleTreeFactory;
import com.jetbrains.rider.settings.tree.CodeStyleTreeNode;
import com.jetbrains.rider.settings.tree.CodeStyleTreeNodeSection;
import com.jetbrains.rider.settings.tree.CodeStyleTreeTable;
import com.jetbrains.rider.settings.tree.renderers.Common;
import com.jetbrains.rider.settings.util.TreeUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.FocusManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000y\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u001e\u0018\u0000 12\u00020\u0001:\u000212B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0015\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018H\u0014\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0014J\r\u0010\u001d\u001a\u00020\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\u001cH\u0014J\b\u0010!\u001a\u00020\u0016H\u0016J\b\u0010\"\u001a\u00020\u0016H\u0014JD\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0$2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)2\u0016\u0010*\u001a\u0012\u0012\u0004\u0012\u00020,0+j\b\u0012\u0004\u0012\u00020,`-H\u0002J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020\u001cH\u0016R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00063"}, d2={"Lcom/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "model", "Lcom/jetbrains/rd/ide/model/ConfigureFormattingRdModel;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/jetbrains/rd/ide/model/ConfigureFormattingRdModel;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;)V", "editor", "Lcom/intellij/openapi/editor/Editor;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "mainPanel", "Ljavax/swing/JPanel;", "getMainPanel", "()Ljavax/swing/JPanel;", "getModel", "()Lcom/jetbrains/rd/ide/model/ConfigureFormattingRdModel;", "beforeSave", "", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createCenterPanel", "Ljavax/swing/JComponent;", "j", "com/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog$createSaveAsCommentsAction$1", "()Lcom/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog$createSaveAsCommentsAction$1;", "createTitlePane", "doCancelAction", "doOKAction", "j", "", "Lcom/jetbrains/rider/settings/tree/CodeStyleTreeNode;", "options", "Lcom/jetbrains/rd/ide/model/CodeStyleOptionBase;", "refresher", "Lcom/jetbrains/rider/settings/tree/CodeStyleTreeFactory$Refresher;", "filter", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "getInitialSize", "Ljava/awt/Dimension;", "getPreferredFocusedComponent", "Companion", "SaveAction", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nConfigureFormattingDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigureFormattingDialog.kt\ncom/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,310:1\n1549#2:311\n1620#2,2:312\n1855#2,2:314\n1622#2:316\n*S KotlinDebug\n*F\n+ 1 ConfigureFormattingDialog.kt\ncom/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog\n*L\n116#1:311\n116#1:312,2\n126#1:314,2\n116#1:316\n*E\n"})
public final class ConfigureFormattingDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConfigureFormattingRdModel model;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final JPanel mainPanel;
    @Nullable
    private final Editor editor;
    @NlsSafe
    @NotNull
    private static final String ClangFormatFileName = ".clang-format";
    @NlsSafe
    @NotNull
    private static final String EditorConfigFileName = ".editorconfig";

    public ConfigureFormattingDialog(@NotNull ConfigureFormattingRdModel model, @NotNull Lifetime lifetime2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(project2, false, DialogWrapper.IdeModalityType.IDE);
        this.model = model;
        this.lifetime = lifetime2;
        this.mainPanel = new JPanel((LayoutManager)new MigLayout("novisualpadding, fill, ins 0", "[fill]", "[fill]"));
        TextControlId textControlId = this.model.getTextControl();
        this.editor = textControlId != null ? TextControlUtilsKt.tryGetEditor(textControlId, FrontendTextControlHost.Companion.getInstance(project2)) : null;
        this.myOKAction = new SaveAction();
        this.setTitle(this.model.getTitle());
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        CodeStyleTreeFactory codeStyleTreeFactory = new CodeStyleTreeFactory(disposable);
        final CodeStyleTreeTable codeStyleTreeTable = codeStyleTreeFactory.createTree((Function2<? super DefaultMutableTreeNode, ? super CodeStyleTreeFactory.Refresher, Boolean>)((Function2)treeTable.1.INSTANCE));
        codeStyleTreeTable.setTableHeader(null);
        JBScrollPane jBScrollPane = new JBScrollPane((Component)((Object)codeStyleTreeTable));
        jBScrollPane.setMinimumSize(new Dimension(JBUIScale.scale((int)10), JBUIScale.scale((int)100)));
        jBScrollPane.setPreferredSize(new Dimension(JBUIScale.scale((int)50), JBUIScale.scale((int)500)));
        jBScrollPane.setBorder(IdeBorderFactory.createBorder());
        this.mainPanel.add((Component)jBScrollPane);
        this.model.getFilteredEntries().advise(this.lifetime, (Function1)new Function1<List<? extends Integer>, Unit>(){

            public final void invoke(@NotNull List<Integer> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
                List list = (List)this.getModel().getFilteredEntries().getValueOrNull();
                if (list == null) {
                    return;
                }
                List list2 = list;
                HashSet hashSet = CollectionsKt.toHashSet((Iterable)list2);
                CodeStyleTreeFactory.Refresher refresher = new CodeStyleTreeFactory.Refresher();
                refresher.setTreeTable(codeStyleTreeTable);
                Iterable iterable = this.getModel().getSettings();
                ConfigureFormattingDialog configureFormattingDialog = this;
                boolean bl = false;
                for (Object t10 : iterable) {
                    CategoryGroup categoryGroup = (CategoryGroup)((Object)t10);
                    boolean bl2 = false;
                    List list3 = configureFormattingDialog.j(categoryGroup.getOptions(), configureFormattingDialog.getLifetime(), refresher, hashSet);
                    if (!CollectionsKt.any((Iterable)list3)) continue;
                    CodeStyleTreeNodeSection codeStyleTreeNodeSection = new CodeStyleTreeNodeSection(categoryGroup);
                    Iterable iterable2 = list3;
                    boolean bl3 = false;
                    for (Object t11 : iterable2) {
                        CodeStyleTreeNode codeStyleTreeNode = (CodeStyleTreeNode)t11;
                        boolean bl4 = false;
                        codeStyleTreeNodeSection.add(codeStyleTreeNode);
                    }
                    defaultMutableTreeNode.add(codeStyleTreeNodeSection);
                }
                TreeTableModel treeTableModel = codeStyleTreeTable.getTableModel();
                Intrinsics.checkNotNull((Object)treeTableModel, (String)"null cannot be cast to non-null type com.intellij.ui.treeStructure.treetable.ListTreeTableModel");
                iterable = (ListTreeTableModel)treeTableModel;
                iterable.setRoot(defaultMutableTreeNode);
                TreeUtil.INSTANCE.fitColumnWidthPercent(0, codeStyleTreeTable, (int)(1.2 * (double)(100 / codeStyleTreeTable.getColumnCount())), true);
                TreeTableTree treeTableTree = codeStyleTreeTable.getTree();
                Intrinsics.checkNotNullExpressionValue((Object)treeTableTree, (String)"getTree(...)");
                TreeUtil.INSTANCE.expandTree((JTree)treeTableTree);
            }
        });
        this.lifetime.onTermination((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.close(1);
            }
        });
        RdTextRange rdTextRange = this.model.getSelectedRange();
        if (this.editor != null && rdTextRange != null) {
            this.setInitialLocationCallback(() -> ConfigureFormattingDialog.j(this, rdTextRange));
        }
        this.init();
    }

    @NotNull
    public final ConfigureFormattingRdModel getModel() {
        return this.model;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final JPanel getMainPanel() {
        return this.mainPanel;
    }

    @Nullable
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public Dimension getInitialSize() {
        int n2 = SwingUtilities.getRootPane(this.getWindow().getParent()).getWidth() / 5;
        int n3 = JBUIScale.scale((int)540);
        int n4 = JBUIScale.scale((int)1000);
        if (n2 < n3) {
            n2 = n3;
        } else if (n2 > n4) {
            n2 = n4;
        }
        return new Dimension(n2, 0);
    }

    private final List<CodeStyleTreeNode> j(List<? extends CodeStyleOptionBase> list, Lifetime lifetime2, CodeStyleTreeFactory.Refresher refresher, HashSet<Integer> hashSet) {
        Iterable iterable = list;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t10 : iterable2) {
            CodeStyleTreeNode codeStyleTreeNode;
            List<CodeStyleTreeNode> list2;
            CodeStyleOptionBase codeStyleOptionBase = (CodeStyleOptionBase)((Object)t10);
            Collection collection2 = collection;
            boolean bl3 = false;
            List<CodeStyleTreeNode> list3 = list2 = codeStyleOptionBase instanceof CodeStyleGroupOption ? this.j(((CodeStyleGroupOption)codeStyleOptionBase).getChildren(), lifetime2, refresher, hashSet) : CollectionsKt.emptyList();
            if (hashSet.contains(codeStyleOptionBase.getId()) || CollectionsKt.any((Iterable)list2)) {
                CodeStyleTreeNode codeStyleTreeNode2 = new CodeStyleTreeNode(codeStyleOptionBase);
                Iterable iterable3 = list2;
                boolean bl4 = false;
                for (Object t11 : iterable3) {
                    CodeStyleTreeNode codeStyleTreeNode3 = (CodeStyleTreeNode)t11;
                    boolean bl5 = false;
                    codeStyleTreeNode2.add(codeStyleTreeNode3);
                }
                codeStyleTreeNode = codeStyleTreeNode2;
            } else {
                codeStyleTreeNode = null;
            }
            collection2.add(codeStyleTreeNode);
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.filterNotNull((Iterable)((List)collection)));
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return this.mainPanel;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return this.mainPanel;
    }

    public void doCancelAction() {
        InterfacesKt.fire(this.model.getCancel());
        this.close(1);
    }

    @NotNull
    protected JComponent createTitlePane() {
        JComponent jComponent;
        Object object;
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("novisualpadding, fillx, ins 0", "", "[min!]"));
        if (this.model.getShouldShowEditorConfigWarning()) {
            object = new JBLabel("");
            object.setBackground(Common.Resources.getHighlightedBackgroundColor());
            object.setOpaque(true);
            jComponent = new JPanel();
            jComponent.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)0, (int)0));
            jComponent.setLayout((LayoutManager)new MigLayout("insets 3 5 3 5", "[]"));
            jComponent.setBackground(Common.Resources.getHighlightedBackgroundColor());
            jComponent.setOpaque(true);
            jComponent.add((Component)object, "grow");
            String string = this.model.getShouldShowEditorConfigSaveSuggestion() ? RiderSettingsBundle.Companion.message("ConfigureFormattingDialog.to.save.them.select.saveto.editorconfig", new Object[0]) : RiderSettingsBundle.Companion.message("ConfigureFormattingDialog.all.changes.to.them.would.be.lost", new Object[0]);
            Object[] objectArray = new Object[]{this.model.getConfigFileName()};
            object.setText(new HtmlBuilder().append(HtmlChunk.text((String)RiderSettingsBundle.Companion.message("ConfigureFormattingDialog.overrides.some.code.style.settings", objectArray))).br().append(HtmlChunk.text((String)string)).wrapWith(HtmlChunk.body()).style("white-space:normal").wrapWith(HtmlChunk.html()).toString());
            object.setBackground(Common.Resources.getHighlightedBackgroundColor());
            jComponent.setVisible(true);
            jPanel.add((Component)jComponent, "dock north");
        }
        if (this.model.getShowCheckBoxes()) {
            object = new JCheckBox(RiderSettingsBundle.Companion.message("ConfigureFormattingDialog.checkbox.preview.formatting", new Object[0]), (boolean)((Boolean)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this.model.getPreviewFormatting()))));
            ((AbstractButton)object).addChangeListener(arg_0 -> ConfigureFormattingDialog.N(this, (JCheckBox)object, arg_0));
            jPanel.add((Component)object);
            jComponent = new JCheckBox(RiderSettingsBundle.Companion.message("ConfigureFormattingDialog.checkbox.only.show.changed.values", new Object[0]), (boolean)((Boolean)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this.model.getOnlyShowChanged()))));
            ((AbstractButton)jComponent).addChangeListener(arg_0 -> ConfigureFormattingDialog.j(this, (JCheckBox)jComponent, arg_0));
            jPanel.add(jComponent);
        }
        return jPanel;
    }

    public final void beforeSave() {
        TableCellEditor tableCellEditor;
        Container container2;
        Component component = FocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component instanceof JFormattedTextField) {
            ((JFormattedTextField)component).commitEdit();
        }
        Component component2 = component;
        Container container3 = container2 = component2 != null ? component2.getParent() : null;
        if (container2 instanceof JTable && (tableCellEditor = ((JTable)container2).getCellEditor()) != null && !tableCellEditor.stopCellEditing()) {
            throw new ConfigurationException(RiderSettingsBundle.Companion.message("ConfigureFormattingDialog.dialog.message.editing.cannot.be.stopped", new Object[0]));
        }
    }

    private final createSaveAsCommentsAction.1 j() {
        String string = RiderSettingsBundle.Companion.message("ConfigureFormattingDialog.button.save.as.comments", new Object[0]);
        return new DialogWrapper.DialogWrapperAction(this, string){
            final /* synthetic */ ConfigureFormattingDialog this$0;
            {
                this.this$0 = $receiver;
                super((DialogWrapper)$receiver, $super_call_param$1);
                this.setEnabled((Boolean)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)$receiver.getModel().getSaveEnabled())));
                $receiver.getModel().getSaveEnabled().advise($receiver.getLifetime(), (Function1)new Function1<Boolean, Unit>(this, $receiver){
                    final /* synthetic */ createSaveAsCommentsAction.1 this$0;
                    final /* synthetic */ ConfigureFormattingDialog this$1;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        super(1);
                    }

                    public final void invoke(boolean it) {
                        this.this$0.setEnabled((Boolean)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this.this$1.getModel().getSaveEnabled())));
                    }
                });
            }

            protected void doAction(@Nullable ActionEvent e2) {
                this.this$0.beforeSave();
                InterfacesKt.fire(this.this$0.getModel().getSaveToComments());
                this.this$0.close(1);
            }
        };
    }

    @NotNull
    protected Action[] createActions() {
        if (this.model.getCanSaveAsComments() && !this.model.getPresentSaveAsCommentAsLayer()) {
            Action[] actionArray = new Action[3];
            Intrinsics.checkNotNullExpressionValue((Object)this.getOKAction(), (String)"getOKAction(...)");
            actionArray[1] = this.j();
            Intrinsics.checkNotNullExpressionValue((Object)this.getCancelAction(), (String)"getCancelAction(...)");
            return actionArray;
        }
        Action[] actionArray = new Action[2];
        Intrinsics.checkNotNullExpressionValue((Object)this.getOKAction(), (String)"getOKAction(...)");
        Intrinsics.checkNotNullExpressionValue((Object)this.getCancelAction(), (String)"getCancelAction(...)");
        return actionArray;
    }

    protected void doOKAction() {
        this.beforeSave();
        InterfacesKt.fire(this.model.getSave());
        this.close(1);
    }

    private static final Point j(ConfigureFormattingDialog configureFormattingDialog, RdTextRange rdTextRange) {
        Intrinsics.checkNotNullParameter((Object)((Object)configureFormattingDialog), (String)"this$0");
        Editor editor = configureFormattingDialog.editor;
        Dimension dimension = configureFormattingDialog.getSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
        Document document = configureFormattingDialog.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        int n2 = rdTextRange.getStartOffset();
        int n3 = rdTextRange.getEndOffset();
        JRootPane jRootPane = SwingUtilities.getRootPane(configureFormattingDialog.getWindow().getParent());
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"getRootPane(...)");
        return new DialogPositionProvider(editor, dimension, document, n2, n3, jRootPane).calculateLocation();
    }

    private static final void N(ConfigureFormattingDialog configureFormattingDialog, JCheckBox jCheckBox, ChangeEvent changeEvent) {
        Intrinsics.checkNotNullParameter((Object)((Object)configureFormattingDialog), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)jCheckBox, (String)"$previewFormattingCheckBox");
        configureFormattingDialog.model.getPreviewFormatting().set((Object)jCheckBox.isSelected());
    }

    private static final void j(ConfigureFormattingDialog configureFormattingDialog, JCheckBox jCheckBox, ChangeEvent changeEvent) {
        Intrinsics.checkNotNullParameter((Object)((Object)configureFormattingDialog), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)jCheckBox, (String)"$onlyShowChangedCheckBox");
        configureFormattingDialog.model.getOnlyShowChanged().set((Object)jCheckBox.isSelected());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog$Companion;", "", "()V", "ClangFormatFileName", "", "EditorConfigFileName", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog$SaveAction;", "Ljavax/swing/AbstractAction;", "Lcom/intellij/openapi/ui/OptionAction;", "(Lcom/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog;)V", "myOptions", "", "Ljavax/swing/Action;", "[Ljavax/swing/Action;", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "getOptions", "()[Ljavax/swing/Action;", "setEnabled", "value", "", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nConfigureFormattingDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigureFormattingDialog.kt\ncom/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog$SaveAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,310:1\n766#2:311\n857#2,2:312\n1549#2:314\n1620#2,3:315\n37#3,2:318\n*S KotlinDebug\n*F\n+ 1 ConfigureFormattingDialog.kt\ncom/jetbrains/rider/settings/codeStyle/ConfigureFormattingDialog$SaveAction\n*L\n272#1:311\n272#1:312,2\n281#1:314\n281#1:315,3\n302#1:318,2\n*E\n"})
    private final class SaveAction
    extends AbstractAction
    implements OptionAction {
        @NotNull
        private final Action[] myOptions;

        public SaveAction() {
            List list;
            List list2;
            Object object;
            Object object2;
            Iterable iterable;
            super(IdeBundle.message((String)"button.save", (Object[])new Object[0]));
            this.putValue("DefaultAction", true);
            List list3 = ConfigureFormattingDialog.this.getModel().getSettingsLayerCollection().getLayers();
            if (OptionsUtilsHost.Companion.getLayer() != null) {
                iterable = list3;
                boolean bl = false;
                object2 = iterable;
                Collection collection = new ArrayList();
                boolean bl2 = false;
                for (Object e2 : object2) {
                    SettingsLayer settingsLayer = (SettingsLayer)e2;
                    boolean bl3 = false;
                    object = settingsLayer.getDisplayName();
                    if (!((Intrinsics.areEqual((Object)object, (Object)ConfigureFormattingDialog.ClangFormatFileName) ? true : Intrinsics.areEqual((Object)object, (Object)ConfigureFormattingDialog.EditorConfigFileName)) | Intrinsics.areEqual((Object)settingsLayer, (Object)OptionsUtilsHost.Companion.getLayer()))) continue;
                    collection.add(e2);
                }
                list2 = (List)collection;
            } else {
                list2 = list3;
            }
            List list4 = list2;
            Iterable iterable2 = list4;
            object2 = ConfigureFormattingDialog.this;
            boolean bl = false;
            Iterable iterable3 = iterable2;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
            boolean bl4 = false;
            for (Object e3 : iterable3) {
                object = (SettingsLayer)e3;
                Object object3 = collection;
                boolean bl5 = false;
                String string = Intrinsics.areEqual((Object)object, (Object)OptionsUtilsHost.Companion.getLowPriorityIdeaSettingsLayer()) ? RiderSettingsBundle.Companion.message("ConfigureFormattingDialog.button.save.to.lowPriorityIdeaLayer", new Object[0]) : ((SettingsLayer)object).getDisplayName();
                object3.add(new AbstractAction(string, (ConfigureFormattingDialog)((Object)object2), (SettingsLayer)object){
                    final /* synthetic */ ConfigureFormattingDialog this$0;
                    final /* synthetic */ SettingsLayer $it;
                    {
                        this.this$0 = $receiver;
                        this.$it = $it;
                        super($displayName);
                    }

                    public void actionPerformed(@Nullable ActionEvent e2) {
                        this.this$0.beforeSave();
                        this.this$0.getModel().getSaveTo().fire((Object)this.$it);
                        this.this$0.close(1);
                    }
                });
            }
            iterable = (List)collection;
            if (ConfigureFormattingDialog.this.getModel().getCanSaveAsComments() && ConfigureFormattingDialog.this.getModel().getPresentSaveAsCommentAsLayer()) {
                object2 = ConfigureFormattingDialog.this.j();
                list = CollectionsKt.listOf((Object)object2);
            } else {
                list = CollectionsKt.emptyList();
            }
            iterable2 = list;
            object2 = CollectionsKt.union((Iterable)iterable, (Iterable)iterable2);
            bl = false;
            iterable3 = object2;
            this.myOptions = iterable3.toArray(new Action[0]);
            this.setEnabled((Boolean)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)ConfigureFormattingDialog.this.getModel().getSaveEnabled())));
            ConfigureFormattingDialog.this.getModel().getSaveEnabled().advise(ConfigureFormattingDialog.this.getLifetime(), (Function1)new Function1<Boolean, Unit>(){

                public final void invoke(boolean it) {
                    this.setEnabled((Boolean)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)ConfigureFormattingDialog.this.getModel().getSaveEnabled())));
                }
            });
        }

        @Override
        public void setEnabled(boolean value2) {
            super.setEnabled(value2);
            for (Action action2 : this.myOptions) {
                action2.setEnabled(value2);
            }
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e2) {
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            ConfigureFormattingDialog.this.doOKAction();
        }

        @NotNull
        public Action[] getOptions() {
            return this.myOptions;
        }
    }
}

