/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.newEditor.SettingsFilter;
import com.intellij.openapi.options.newEditor.SettingsTreeView;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeUICustomization;
import com.jetbrains.rider.settings.ReSharperConfigurableUtilKt;
import com.jetbrains.rider.settings.RiderSettingsBundle;
import icons.RiderIcons;
import java.util.List;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J,\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/settings/RiderSettingsTreeView;", "Lcom/intellij/openapi/options/newEditor/SettingsTreeView;", "filter", "Lcom/intellij/openapi/options/newEditor/SettingsFilter;", "groups", "", "Lcom/intellij/openapi/options/ConfigurableGroup;", "(Lcom/intellij/openapi/options/newEditor/SettingsFilter;Ljava/util/List;)V", "setProjectIcon", "", "projectIcon", "Ljavax/swing/JLabel;", "myConfigurable", "Lcom/intellij/openapi/options/Configurable;", "project", "Lcom/intellij/openapi/project/Project;", "selected", "", "intellij.rider.rdclient.dotnet"})
public final class RiderSettingsTreeView
extends SettingsTreeView {
    public RiderSettingsTreeView(@NotNull SettingsFilter filter2, @NotNull List<? extends ConfigurableGroup> groups) {
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Intrinsics.checkNotNullParameter(groups, (String)"groups");
        super(filter2, groups);
    }

    protected void setProjectIcon(@NotNull JLabel projectIcon, @Nullable Configurable myConfigurable, @Nullable Project project2, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)projectIcon, (String)"projectIcon");
        boolean bl = ReSharperConfigurableUtilKt.checkIsConfigurableFromReSharper(myConfigurable);
        if (bl) {
            projectIcon.setIcon(RiderIcons.CodeStyle.ConfigurableLayer);
            projectIcon.setToolTipText(RiderSettingsBundle.Companion.message("RiderSettingsTreeView.tooltip.text.options.can.be.shared.via.resharper.settings.layers", new Object[0]));
            projectIcon.setVisible(true);
        } else if (project2 != null) {
            projectIcon.setIcon(RiderIcons.CodeStyle.ConfigurableProject);
            projectIcon.setToolTipText(IdeUICustomization.getInstance().projectMessage(project2.isDefault() ? "configurable.default.project.tooltip" : "configurable.current.project.tooltip", new Object[0]));
            projectIcon.setVisible(true);
        } else {
            projectIcon.setVisible(false);
        }
    }
}

