/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.editor.EditorSynchronizerKt;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rider.document.TextBufferDocumentSynchronizer;
import com.jetbrains.rider.editorActions.FrontendTypedHandler;
import com.jetbrains.rider.editorActions.RiderTypedHandlersSupport;
import com.jetbrains.rider.model.IndentSettings;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.settings.RiderPrefetchedIndentOptions;
import com.jetbrains.rider.settings.RiderSmartTabsBackendSynchronizer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/settings/RiderFileIndentOptionsProvider;", "Lcom/intellij/psi/codeStyle/FileIndentOptionsProvider;", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getIndentOptions", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "psiFile", "Lcom/intellij/psi/PsiFile;", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderFileIndentOptionsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderFileIndentOptionsProvider.kt\ncom/jetbrains/rider/settings/RiderFileIndentOptionsProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,121:1\n65#2,4:122\n65#2,4:126\n65#2,4:130\n65#2,4:134\n*S KotlinDebug\n*F\n+ 1 RiderFileIndentOptionsProvider.kt\ncom/jetbrains/rider/settings/RiderFileIndentOptionsProvider\n*L\n28#1:122,4\n44#1:126,4\n64#1:130,4\n107#1:134,4\n*E\n"})
public final class RiderFileIndentOptionsProvider
extends FileIndentOptionsProvider {
    @NotNull
    private final Logger logger;

    public RiderFileIndentOptionsProvider() {
        Logger logger = Logger.getInstance(RiderFileIndentOptionsProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull CodeStyleSettings settings, @NotNull PsiFile psiFile) {
        EditorSynchronizer editorSynchronizer;
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        ApplicationKt.getApplication().assertReadAccessAllowed();
        Object object = this.logger;
        boolean bl = false;
        if (object.isTraceEnabled()) {
            logger = object;
            boolean bl2 = false;
            logger.trace("RiderFileIndentOptionsProvider.getIndentOptions for `" + psiFile.getName() + "` start");
        }
        Language language = psiFile.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        FrontendTypedHandler frontendTypedHandler = RiderTypedHandlersSupport.forLanguage(language);
        if (frontendTypedHandler == null) {
            return null;
        }
        object = frontendTypedHandler;
        if (!((FrontendTypedHandler)object).isAvailable(psiFile)) {
            return null;
        }
        Project project2 = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        if (project3.isDisposed()) {
            return null;
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project3);
        Document document = psiDocumentManager.getDocument(psiFile);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        Object object2 = settings.getIndentOptions(psiFile.getFileType()).clone();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.psi.codeStyle.CommonCodeStyleSettings.IndentOptions");
        CommonCodeStyleSettings.IndentOptions indentOptions = (CommonCodeStyleSettings.IndentOptions)object2;
        Editor[] editorArray = EditorFactory.getInstance().getEditors(document2, project3);
        Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getEditors(...)");
        Editor editor = (Editor)ArraysKt.firstOrNull((Object[])editorArray);
        Object object3 = editorSynchronizer = editor != null ? DocumentExKt.getEditorSynchronizer((Editor)editor) : null;
        if (editorSynchronizer != null) {
            boolean bl3;
            boolean bl4;
            int n2;
            int n3;
            Integer n4 = EditorSynchronizerKt.getTabSize((EditorSynchronizer)editorSynchronizer);
            int n5 = n4 != null ? n4 : indentOptions.TAB_SIZE;
            Logger logger2 = this.logger;
            boolean bl5 = false;
            if (logger2.isTraceEnabled()) {
                logger = logger2;
                n3 = 0;
                logger.trace("RiderFileIndentOptionsProvider.getIndentOptions for `" + psiFile.getName() + "`. Tab size is `" + n5 + "`.");
            }
            int n6 = n2 = n5 >= 0 ? 1 : 0;
            if (_Assertions.ENABLED && n2 == 0) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Integer n7 = EditorSynchronizerKt.getIndentSize((EditorSynchronizer)editorSynchronizer);
            n2 = n7 != null ? n7 : indentOptions.INDENT_SIZE;
            boolean bl6 = bl5 = n2 >= 0;
            if (_Assertions.ENABLED && !bl5) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Boolean bl7 = EditorSynchronizerKt.getUseTab((EditorSynchronizer)editorSynchronizer);
            bl5 = bl7 != null ? bl7 : indentOptions.USE_TAB_CHARACTER;
            Integer n8 = EditorSynchronizerKt.getContinuousIndentSize((EditorSynchronizer)editorSynchronizer);
            n3 = n8 != null ? n8 : indentOptions.CONTINUATION_INDENT_SIZE;
            boolean bl8 = bl4 = n3 >= 0;
            if (_Assertions.ENABLED && !bl4) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            bl4 = RiderSmartTabsBackendSynchronizer.Companion.shouldSynchronize(psiFile);
            if (bl4) {
                Boolean bl9 = EditorSynchronizerKt.getSmartTabs((EditorSynchronizer)editorSynchronizer);
                v16 = bl9 != null ? bl9 : indentOptions.SMART_TABS;
            } else {
                v16 = bl3 = indentOptions.SMART_TABS;
            }
            if (indentOptions.TAB_SIZE != n5 || n2 != indentOptions.INDENT_SIZE || bl5 != indentOptions.USE_TAB_CHARACTER || n3 != indentOptions.CONTINUATION_INDENT_SIZE || bl3 != indentOptions.SMART_TABS || !indentOptions.isOverrideLanguageOptions()) {
                Logger logger3 = this.logger;
                boolean bl10 = false;
                if (logger3.isTraceEnabled()) {
                    logger = logger3;
                    boolean bl11 = false;
                    logger.trace("RiderFileIndentOptionsProvider.getIndentOptions for `" + psiFile.getName() + "`: overriding settings");
                }
                indentOptions.setOverrideLanguageOptions(true);
                indentOptions.TAB_SIZE = n5;
                indentOptions.INDENT_SIZE = n2;
                indentOptions.USE_TAB_CHARACTER = bl5;
                indentOptions.CONTINUATION_INDENT_SIZE = n3;
                if (bl4) {
                    indentOptions.SMART_TABS = bl3;
                }
                return indentOptions;
            }
        } else {
            VirtualFile virtualFile2;
            VirtualFile virtualFile3 = psiFile.getVirtualFile();
            VirtualFile virtualFile4 = virtualFile2 = virtualFile3 instanceof LightVirtualFile ? ((LightVirtualFile)virtualFile3).getOriginalFile() : virtualFile3;
            if (virtualFile2 == null) {
                return null;
            }
            if (!PatchEngineRegistryKt.isPatchEngineEnabled() && TextBufferDocumentSynchronizer.Companion.isBackendUpdateInProgress(document2, FrontendSessionsUtilKt.getFrontendProjectSession((Project)project3).getAppSession())) {
                return null;
            }
            WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project3);
            if (workspaceModel == null) {
                return null;
            }
            WorkspaceModel workspaceModel2 = workspaceModel;
            int n9 = com.jetbrains.rider.document.DocumentExKt.findBestProjectModelIdForDocument(WorkspaceModelExtensionsKt.getProjectModelEntities(workspaceModel2, virtualFile2, project3), project3);
            if (n9 == 0) {
                return null;
            }
            RiderPrefetchedIndentOptions riderPrefetchedIndentOptions = RiderPrefetchedIndentOptions.Companion.getInstance(project3);
            IndentSettings indentSettings = riderPrefetchedIndentOptions.getIndentSettings(n9);
            if (indentSettings == null) {
                return null;
            }
            boolean bl12 = RiderSmartTabsBackendSynchronizer.Companion.shouldSynchronize(psiFile);
            if (indentOptions.TAB_SIZE != indentSettings.getTabSize() || indentSettings.getIndentSize() != indentOptions.INDENT_SIZE || indentSettings.getUseTabs() != indentOptions.USE_TAB_CHARACTER || indentSettings.getContinuationIndentSize() != indentOptions.CONTINUATION_INDENT_SIZE || indentSettings.getSmartTabs() != indentOptions.SMART_TABS && bl12 || !indentOptions.isOverrideLanguageOptions()) {
                Logger logger4 = this.logger;
                boolean bl13 = false;
                if (logger4.isTraceEnabled()) {
                    logger = logger4;
                    boolean bl14 = false;
                    logger.trace("RiderFileIndentOptionsProvider.getIndentOptions for `" + psiFile.getName() + "`: overriding settings");
                }
                indentOptions.setOverrideLanguageOptions(true);
                indentOptions.TAB_SIZE = indentSettings.getTabSize();
                indentOptions.INDENT_SIZE = indentSettings.getIndentSize();
                indentOptions.USE_TAB_CHARACTER = indentSettings.getUseTabs();
                indentOptions.CONTINUATION_INDENT_SIZE = indentSettings.getContinuationIndentSize();
                if (bl12) {
                    indentOptions.SMART_TABS = indentSettings.getSmartTabs();
                }
                return indentOptions;
            }
        }
        return null;
    }
}

