/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.jetbrains.rd.ide.model.KeyPathComponents;
import com.jetbrains.rd.ide.model.PredefinedValue;
import com.jetbrains.rd.ide.model.SettingsModel;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import com.jetbrains.rider.protocol.ProtocolComponent;
import com.jetbrains.rider.settings.OptionsUtilsHost;
import com.jetbrains.rider.settings.RiderCustomCodeStyleSettings;
import com.jetbrains.rider.settings.SettingsSynchronizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/settings/RiderCustomCodeStyleSettingsSynchronizer;", "Lcom/intellij/psi/codeStyle/CodeStyleSettingsListener;", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "codeStyleSettingsChanged", "", "event", "Lcom/intellij/psi/codeStyle/CodeStyleSettingsChangeEvent;", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderCodeStyleSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderCodeStyleSettings.kt\ncom/jetbrains/rider/settings/RiderCustomCodeStyleSettingsSynchronizer\n+ 2 IProtocolHost.kt\ncom/jetbrains/rider/protocol/IProtocolHostKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n24#2:149\n800#3,11:150\n1855#3,2:161\n*S KotlinDebug\n*F\n+ 1 RiderCodeStyleSettings.kt\ncom/jetbrains/rider/settings/RiderCustomCodeStyleSettingsSynchronizer\n*L\n20#1:149\n20#1:150,11\n24#1:161,2\n*E\n"})
public final class RiderCustomCodeStyleSettingsSynchronizer
implements CodeStyleSettingsListener {
    @NotNull
    private final Logger logger;

    public RiderCustomCodeStyleSettingsSynchronizer() {
        Logger logger = Logger.getInstance(RiderCustomCodeStyleSettingsSynchronizer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    public void codeStyleSettingsChanged(@NotNull CodeStyleSettingsChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = ApplicationProtocolKt.getProtocolHost(event.getProject());
        boolean bl = false;
        Iterable iterable = object.getComponents();
        boolean bl2 = false;
        Iterable iterable22 = iterable;
        Collection collection = new ArrayList();
        boolean bl3 = false;
        for (Object t10 : iterable22) {
            if (!(t10 instanceof SettingsSynchronizer)) continue;
            collection.add(t10);
        }
        SettingsModel settingsModel2 = ((SettingsSynchronizer)((ProtocolComponent)CollectionsKt.single((List)((List)collection)))).getSettingsModel();
        if (event.getVirtualFile() == null && OptionsUtilsHost.Companion.getAllowSchemeSupport()) {
            CustomCodeStyleSettings customCodeStyleSettings = CodeStyle.getSettings((Project)event.getProject()).getCustomSettings(RiderCustomCodeStyleSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
            object = (RiderCustomCodeStyleSettings)customCodeStyleSettings;
            Iterable iterable3 = CollectionsKt.union((Iterable)((RiderCustomCodeStyleSettings)((Object)object)).getData().keySet(), (Iterable)settingsModel2.getLowPriorityProtocolStorage().keySet());
            boolean bl4 = false;
            for (Iterable iterable22 : iterable3) {
                boolean bl5;
                collection = (KeyPathComponents)iterable22;
                bl3 = false;
                String string = collection.getRawKey();
                boolean bl6 = bl5 = StringsKt.startsWith$default((String)string, (String)"/Default/CodeStyle", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)string, (String)"/Default/CodeInspection/CppInitialization", (boolean)false, (int)2, null);
                if (bl5) {
                    PredefinedValue predefinedValue = ((RiderCustomCodeStyleSettings)((Object)object)).getData().getOrDefault(collection, null);
                    if (predefinedValue != null) {
                        ((Map)settingsModel2.getLowPriorityProtocolStorage()).put(collection, predefinedValue);
                        continue;
                    }
                    this.logger.warn("Remove code-style option " + (String)string);
                    settingsModel2.getLowPriorityProtocolStorage().remove((Object)collection);
                    continue;
                }
                this.logger.trace("Keeping non code-style option " + (String)string);
            }
        }
    }
}

