/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.lang.Language;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.jetbrains.rider.settings.OptionsUtilsHost;
import com.jetbrains.rider.settings.RiderCodeStyleMainPanel;
import com.jetbrains.rider.settings.RiderCodeStyleSettings;
import com.jetbrains.rider.settings.RiderCustomCodeStyleSettings;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BJ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\n0\b\u0012\b\b\u0001\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\t\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\b\u0010\u0016\u001a\u00020\tH\u0016R\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\"\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/settings/RiderCodeStyleConfigurable;", "Lcom/intellij/application/options/CodeStyleAbstractConfigurable;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "originalSettings", "language", "Lcom/intellij/lang/Language;", "pageIds", "", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "displayName", "helpTopicId", "(Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lcom/intellij/lang/Language;Ljava/util/Map;Ljava/lang/String;Ljava/lang/String;)V", "getHelpTopicId", "()Ljava/lang/String;", "getLanguage", "()Lcom/intellij/lang/Language;", "getPageIds", "()Ljava/util/Map;", "createPanel", "Lcom/intellij/application/options/CodeStyleAbstractPanel;", "getHelpTopic", "intellij.rider.rdclient.dotnet"})
public final class RiderCodeStyleConfigurable
extends CodeStyleAbstractConfigurable {
    @Nullable
    private final Language language;
    @NotNull
    private final Map<String, String> pageIds;
    @NotNull
    private final String helpTopicId;

    public RiderCodeStyleConfigurable(@NotNull CodeStyleSettings settings, @NotNull CodeStyleSettings originalSettings, @Nullable Language language, @NotNull Map<String, String> pageIds, @NlsContexts.ConfigurableName @NotNull String displayName2, @NotNull String helpTopicId) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)originalSettings, (String)"originalSettings");
        Intrinsics.checkNotNullParameter(pageIds, (String)"pageIds");
        Intrinsics.checkNotNullParameter((Object)displayName2, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)helpTopicId, (String)"helpTopicId");
        super(settings, originalSettings, displayName2);
        this.language = language;
        this.pageIds = pageIds;
        this.helpTopicId = helpTopicId;
    }

    @Nullable
    public final Language getLanguage() {
        return this.language;
    }

    @NotNull
    public final Map<String, String> getPageIds() {
        return this.pageIds;
    }

    @NotNull
    public final String getHelpTopicId() {
        return this.helpTopicId;
    }

    @NotNull
    protected CodeStyleAbstractPanel createPanel(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (OptionsUtilsHost.Companion.getAllowSchemeSupport()) {
            CustomCodeStyleSettings customCodeStyleSettings = this.getCurrentSettings().getCustomSettings(RiderCustomCodeStyleSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
            RiderCustomCodeStyleSettings riderCustomCodeStyleSettings = (RiderCustomCodeStyleSettings)customCodeStyleSettings;
            riderCustomCodeStyleSettings.setPages(this.pageIds);
            CustomCodeStyleSettings customCodeStyleSettings2 = settings.getCustomSettings(RiderCustomCodeStyleSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings2, (String)"getCustomSettings(...)");
            RiderCustomCodeStyleSettings riderCustomCodeStyleSettings2 = (RiderCustomCodeStyleSettings)customCodeStyleSettings2;
            riderCustomCodeStyleSettings2.setPages(this.pageIds);
            CodeStyleSettings codeStyleSettings = this.getCurrentSettings();
            Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getCurrentSettings(...)");
            return (CodeStyleAbstractPanel)new RiderCodeStyleMainPanel(this.language, codeStyleSettings, settings);
        }
        RiderCodeStyleSettings riderCodeStyleSettings = new RiderCodeStyleSettings(this.pageIds);
        riderCodeStyleSettings.copyFrom(this.getCurrentSettings());
        RiderCodeStyleSettings riderCodeStyleSettings2 = new RiderCodeStyleSettings(this.pageIds);
        riderCodeStyleSettings2.copyFrom(settings);
        return (CodeStyleAbstractPanel)new RiderCodeStyleMainPanel(this.language, riderCodeStyleSettings, riderCodeStyleSettings2);
    }

    @NotNull
    public String getHelpTopic() {
        return this.helpTopicId;
    }
}

