/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.services.popups.nova.ui;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.popup.WizardPopup;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rider.services.popups.nova.PopupMenus;
import com.jetbrains.rider.services.popups.nova.PopupViewModel;
import com.jetbrains.rider.services.popups.nova.layouter.HackPopupLayouter;
import com.jetbrains.rider.services.popups.nova.layouter.LayoutResult;
import com.jetbrains.rider.services.popups.nova.layouter.PopupLayouter;
import com.jetbrains.rider.services.popups.nova.layouter.PopupLayouterKt;
import com.jetbrains.rider.services.popups.nova.layouter.PopupLayouterSource;
import java.awt.Component;
import java.awt.Dimension;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0004J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/services/popups/nova/ui/UiPopupMenus;", "Lcom/jetbrains/rider/services/popups/nova/PopupMenus;", "()V", "showErrorHint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "viewModel", "Lcom/jetbrains/rider/services/popups/nova/PopupViewModel;", "showNoItemsBanner", "showPopup", "popup", "Lcom/intellij/ui/popup/WizardPopup;", "intellij.rider.rdclient.dotnet"})
@ApiStatus.Internal
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nUiPopupMenus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UiPopupMenus.kt\ncom/jetbrains/rider/services/popups/nova/ui/UiPopupMenus\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,71:1\n13#2:72\n*S KotlinDebug\n*F\n+ 1 UiPopupMenus.kt\ncom/jetbrains/rider/services/popups/nova/ui/UiPopupMenus\n*L\n61#1:72\n*E\n"})
public class UiPopupMenus
extends PopupMenus {
    @Override
    protected void showPopup(@NotNull PopupViewModel viewModel, @NotNull WizardPopup popup2) {
        Component component;
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)popup2, (String)"popup");
        PopupLayouterSource popupLayouterSource = viewModel.getPopupLayouterSource();
        Intrinsics.checkNotNull((Object)popupLayouterSource);
        PopupLayouter popupLayouter = popupLayouterSource.createLayouter(viewModel.getLifetime());
        if (popupLayouter instanceof HackPopupLayouter) {
            popup2.showInBestPositionFor(((HackPopupLayouter)popupLayouter).getDataContext());
            return;
        }
        if (popupLayouter.getProject().isDefault()) {
            viewModel.terminateModel();
            return;
        }
        IOptProperty<Dimension> iOptProperty = popupLayouter.getSize();
        Dimension dimension = popup2.getPreferredContentSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredContentSize(...)");
        iOptProperty.set((Object)dimension);
        LayoutResult layoutResult = (LayoutResult)popupLayouter.getLayout().getValue();
        if (layoutResult == null) {
            UiPopupMenus uiPopupMenus = this;
            boolean bl = false;
            viewModel.terminateModel();
            return;
        }
        LayoutResult layoutResult2 = layoutResult;
        Component component2 = WindowManagerEx.getInstanceEx().getFocusedComponent(popupLayouter.getProject());
        if (component2 == null) {
            IdeFrame ideFrame = WindowManagerEx.getInstanceEx().findFrameFor(popupLayouter.getProject());
            component2 = ideFrame != null ? ideFrame.getComponent() : null;
        }
        if ((component = component2) == null) {
            viewModel.terminateModel();
            return;
        }
        try {
            popup2.show(component, PopupLayouterKt.getLocation((LayoutResult)layoutResult2).x, PopupLayouterKt.getLocation((LayoutResult)layoutResult2).y, true);
        }
        catch (Throwable throwable) {
            viewModel.terminateModel();
            throw throwable;
        }
    }

    @Override
    protected void showNoItemsBanner(@NotNull PopupViewModel viewModel) {
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        DataManager.getInstance().getDataContextFromFocus().doWhenDone(arg_0 -> UiPopupMenus.j(this, viewModel, arg_0));
    }

    protected final void showErrorHint(@NotNull Editor editor, @NotNull PopupViewModel viewModel) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        HintManager hintManager = HintManager.getInstance();
        String string = viewModel.getNoItemsBannerText();
        if (string == null) {
            string = "No items to show";
        }
        hintManager.showErrorHint(editor, string);
    }

    private static final void j(UiPopupMenus uiPopupMenus, PopupViewModel popupViewModel, DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)uiPopupMenus, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)popupViewModel, (String)"$viewModel");
        Intrinsics.checkNotNull((Object)dataContext2);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        if (editor == null) {
            boolean bl = false;
            Logger logger = Logger.getInstance(UiPopupMenus.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("context is not editor");
            return;
        }
        uiPopupMenus.showErrorHint(editor, popupViewModel);
    }
}

