/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.services.popups.nova.layouter;

import com.intellij.ui.awt.RelativePoint;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rider.services.popups.nova.layouter.AnchoringRect;
import com.jetbrains.rider.services.popups.nova.layouter.GutterMarkMenuLayoterKt;
import com.jetbrains.rider.services.popups.nova.layouter.RectangleUtilsKt;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/services/popups/nova/layouter/StaticAnchoringRect;", "Lcom/jetbrains/rider/services/popups/nova/layouter/AnchoringRect;", "point", "Ljava/awt/Point;", "(Ljava/awt/Point;)V", "rectangle", "Ljava/awt/Rectangle;", "(Ljava/awt/Rectangle;)V", "Lcom/jetbrains/rd/util/reactive/IProperty;", "getRectangle", "()Lcom/jetbrains/rd/util/reactive/IProperty;", "Companion", "intellij.rider.rdclient.dotnet"})
public final class StaticAnchoringRect
implements AnchoringRect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IProperty<Rectangle> rectangle;

    public StaticAnchoringRect(@NotNull Rectangle rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        this.rectangle = (IProperty)new Property((Object)rectangle);
    }

    @NotNull
    public IProperty<Rectangle> getRectangle() {
        return this.rectangle;
    }

    public StaticAnchoringRect(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this(new Rectangle(point, new Dimension(0, 0)));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/services/popups/nova/layouter/StaticAnchoringRect$Companion;", "", "()V", "fromComponent", "Lcom/jetbrains/rider/services/popups/nova/layouter/AnchoringRect;", "component", "Ljavax/swing/JComponent;", "fromCurrentMousePosition", "fromPoint", "point", "Lcom/intellij/ui/awt/RelativePoint;", "fromWindow", "window", "Ljava/awt/Window;", "j", "Ljava/awt/Component;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        private final JComponent j(Component component) {
            if (component instanceof JComponent) {
                return (JComponent)component;
            }
            if (component instanceof RootPaneContainer) {
                return ((RootPaneContainer)((Object)component)).getRootPane();
            }
            return null;
        }

        @NotNull
        public final AnchoringRect fromComponent(@NotNull JComponent component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Rectangle rectangle = component.getVisibleRect();
            Point point = rectangle.getLocation();
            SwingUtilities.convertPointToScreen(point, component);
            rectangle.setLocation(point);
            Intrinsics.checkNotNull((Object)rectangle);
            return new StaticAnchoringRect(rectangle);
        }

        @NotNull
        public final AnchoringRect fromWindow(@NotNull Window window) {
            Intrinsics.checkNotNullParameter((Object)window, (String)"window");
            JComponent jComponent = this.j(window);
            Rectangle rectangle = jComponent != null ? jComponent.getVisibleRect() : new Rectangle(window.getSize());
            Point point = rectangle.getLocation();
            JComponent jComponent2 = jComponent;
            SwingUtilities.convertPointToScreen(point, jComponent2 != null ? (Container)jComponent2 : (Container)window);
            rectangle.setLocation(point);
            Intrinsics.checkNotNull((Object)rectangle);
            return new StaticAnchoringRect(rectangle);
        }

        @NotNull
        public final AnchoringRect fromCurrentMousePosition() {
            Point point = MouseInfo.getPointerInfo().getLocation();
            Rectangle rectangle = new Rectangle(point, new Dimension(16, 16));
            Intrinsics.checkNotNull((Object)point);
            rectangle = RectangleUtilsKt.smartClip(rectangle, GutterMarkMenuLayoterKt.getScreenRectangle(point));
            return new StaticAnchoringRect(rectangle);
        }

        @NotNull
        public final AnchoringRect fromPoint(@NotNull RelativePoint point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            Point point2 = point.getScreenPoint();
            Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"getScreenPoint(...)");
            Point point3 = point2;
            Rectangle rectangle = new Rectangle(point3, new Dimension(16, 16));
            rectangle = RectangleUtilsKt.smartClip(rectangle, GutterMarkMenuLayoterKt.getScreenRectangle(point3));
            return new StaticAnchoringRect(rectangle);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

