/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.services.popups.nova.layouter;

import com.jetbrains.rider.services.popups.nova.layouter.Anchoring;
import com.jetbrains.rider.services.popups.nova.layouter.Anchoring2D;
import com.jetbrains.rider.services.popups.nova.layouter.AnchoringRectKt;
import com.jetbrains.rider.services.popups.nova.layouter.LayoutResult;
import com.jetbrains.rider.services.popups.nova.layouter.RectangleUtilsKt;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\bH\u0002J\u0018\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\bH\u0002J\u0018\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\bH\u0002J\u0018\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J \u0010#\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\bH\u0002J\b\u0010&\u001a\u0004\u0018\u00010'R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/jetbrains/rider/services/popups/nova/layouter/RectangleDocker;", "", "anchor", "Ljava/awt/Rectangle;", "size", "Ljava/awt/Dimension;", "myAllowedDispositions", "", "Lcom/jetbrains/rider/services/popups/nova/layouter/Anchoring2D;", "myScreen", "myPadding", "", "(Ljava/awt/Rectangle;Ljava/awt/Dimension;Ljava/util/List;Ljava/awt/Rectangle;I)V", "myAnchorRect", "myCandidateDisposition", "myCandidateRatio", "myCandidateRect", "myCandidateRoom", "mySize", "j", "", "center", "Ljava/awt/Point;", "rect", "N", "j", "", "rectCandidate", "rectRoom", "disposition", "j", "anchorRect", "N", "anchorRectPadded", "j", "j", "mangledDisposition", "originalDisposition", "layout", "Lcom/jetbrains/rider/services/popups/nova/layouter/LayoutResult;", "intellij.rider.rdclient.dotnet"})
public final class RectangleDocker {
    @NotNull
    private final List<Anchoring2D> myAllowedDispositions;
    @NotNull
    private final Rectangle myScreen;
    private final int myPadding;
    @NotNull
    private final Rectangle myAnchorRect;
    @NotNull
    private final Dimension mySize;
    @NotNull
    private Rectangle myCandidateRect;
    @NotNull
    private Rectangle myCandidateRoom;
    @Nullable
    private Anchoring2D myCandidateDisposition;
    private int myCandidateRatio;

    public RectangleDocker(@NotNull Rectangle anchor, @NotNull Dimension size, @NotNull List<Anchoring2D> myAllowedDispositions, @NotNull Rectangle myScreen, int myPadding) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter(myAllowedDispositions, (String)"myAllowedDispositions");
        Intrinsics.checkNotNullParameter((Object)myScreen, (String)"myScreen");
        this.myAllowedDispositions = myAllowedDispositions;
        this.myScreen = myScreen;
        this.myPadding = myPadding;
        this.myAnchorRect = RectangleUtilsKt.smartClip(anchor, this.myScreen);
        this.mySize = new Dimension(Math.min(this.myScreen.width, size.width), Math.min(this.myScreen.height, size.height));
        this.myCandidateRect = new Rectangle();
        this.myCandidateRoom = new Rectangle();
        this.myCandidateRatio = Integer.MAX_VALUE;
    }

    @Nullable
    public final LayoutResult layout() {
        LayoutResult layoutResult;
        for (Anchoring2D anchoring2D : this.myAllowedDispositions) {
            if (this.j(this.myAnchorRect, anchoring2D)) break;
        }
        if (this.myCandidateDisposition == null) {
            layoutResult = null;
        } else {
            Anchoring2D anchoring2D = this.myCandidateDisposition;
            Intrinsics.checkNotNull((Object)anchoring2D);
            layoutResult = new LayoutResult(this.myCandidateRoom, this.myCandidateRect, this.myAnchorRect, anchoring2D);
        }
        return layoutResult;
    }

    private final boolean j(Rectangle rectangle, Anchoring2D anchoring2D) {
        if (AnchoringRectKt.isInside(anchoring2D)) {
            if (Intrinsics.areEqual((Object)anchoring2D, (Object)new Anchoring2D(Anchoring.MiddleInside, Anchoring.MiddleInside))) {
                return this.j(anchoring2D, rectangle);
            }
            Rectangle rectangle2 = RectangleUtilsKt.inflate(rectangle, new Dimension(-this.myPadding, -this.myPadding));
            Rectangle rectangle3 = rectangle2.intersection(this.myScreen);
            Intrinsics.checkNotNull((Object)rectangle3);
            return this.N(rectangle3, anchoring2D);
        }
        Rectangle rectangle4 = RectangleUtilsKt.inflate(rectangle, new Dimension(this.myPadding, this.myPadding));
        Rectangle rectangle5 = rectangle4.intersection(this.myScreen);
        Intrinsics.checkNotNull((Object)rectangle5);
        return this.j(rectangle5, anchoring2D, anchoring2D);
    }

    private final boolean j(Rectangle rectangle, Anchoring2D anchoring2D, Anchoring2D anchoring2D2) {
        Rectangle rectangle2 = new Rectangle(this.mySize);
        Rectangle rectangle3 = new Rectangle(this.myScreen);
        switch (WhenMappings.$EnumSwitchMapping$0[anchoring2D.getHorizontal().ordinal()]) {
            case 1: {
                rectangle2.x = RectangleUtilsKt.getLeft(rectangle) - this.mySize.width;
                RectangleUtilsKt.setRight(rectangle3, RectangleUtilsKt.getLeft(rectangle));
                break;
            }
            case 2: {
                rectangle2.x = RectangleUtilsKt.getLeft(rectangle);
                RectangleUtilsKt.setLeft(rectangle3, RectangleUtilsKt.getLeft(rectangle));
                break;
            }
            case 3: {
                this.j(RectangleUtilsKt.getCenter(rectangle), rectangle2);
                break;
            }
            case 4: {
                rectangle2.x = RectangleUtilsKt.getRight(rectangle) - this.mySize.width;
                RectangleUtilsKt.setRight(rectangle3, RectangleUtilsKt.getRight(rectangle));
                break;
            }
            case 5: {
                rectangle2.x = RectangleUtilsKt.getRight(rectangle);
                RectangleUtilsKt.setLeft(rectangle3, RectangleUtilsKt.getRight(rectangle));
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$0[anchoring2D.getVertical().ordinal()]) {
            case 1: {
                rectangle2.y = RectangleUtilsKt.getTop(rectangle) - this.mySize.height;
                RectangleUtilsKt.setBottom(rectangle3, RectangleUtilsKt.getTop(rectangle));
                break;
            }
            case 2: {
                rectangle2.y = RectangleUtilsKt.getTop(rectangle);
                RectangleUtilsKt.setTop(rectangle3, RectangleUtilsKt.getTop(rectangle));
                break;
            }
            case 3: {
                this.N(RectangleUtilsKt.getCenter(rectangle), rectangle2);
                break;
            }
            case 4: {
                rectangle2.y = RectangleUtilsKt.getBottom(rectangle) - this.mySize.height;
                RectangleUtilsKt.setBottom(rectangle3, RectangleUtilsKt.getBottom(rectangle));
                break;
            }
            case 5: {
                rectangle2.y = RectangleUtilsKt.getBottom(rectangle);
                RectangleUtilsKt.setTop(rectangle2, RectangleUtilsKt.getBottom(rectangle));
            }
        }
        Rectangle rectangle4 = rectangle2.intersection(this.myScreen);
        Intrinsics.checkNotNullExpressionValue((Object)rectangle4, (String)"intersection(...)");
        rectangle2 = rectangle4;
        return this.j(rectangle2, rectangle3, anchoring2D2);
    }

    private final boolean N(Rectangle rectangle, Anchoring2D anchoring2D) {
        Anchoring anchoring = anchoring2D.component1();
        Anchoring anchoring2 = anchoring2D.component2();
        switch (WhenMappings.$EnumSwitchMapping$0[anchoring2D.getHorizontal().ordinal()]) {
            case 2: {
                anchoring = Anchoring.FarOutside;
                rectangle.x -= rectangle.width;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                anchoring = Anchoring.NearOutside;
                rectangle.x += rectangle.width;
                break;
            }
            default: {
                throw new IllegalArgumentException("Expect only *Inside disposition here: disposition = " + anchoring2D.getHorizontal() + ".");
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$0[anchoring2D.getVertical().ordinal()]) {
            case 2: {
                anchoring2 = Anchoring.FarOutside;
                rectangle.y -= rectangle.height;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                anchoring2 = Anchoring.NearOutside;
                rectangle.y += rectangle.height;
                break;
            }
            default: {
                throw new IllegalArgumentException("Expect only *Inside disposition here: disposition = " + anchoring2D.getVertical() + ".");
            }
        }
        return this.j(rectangle, new Anchoring2D(anchoring, anchoring2), anchoring2D);
    }

    private final boolean j(Anchoring2D anchoring2D, Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(this.mySize);
        Point point = RectangleUtilsKt.getCenter(rectangle);
        this.j(point, rectangle2);
        this.N(point, rectangle2);
        return this.j(rectangle2, this.myScreen, anchoring2D);
    }

    private final boolean j(Rectangle rectangle, Rectangle rectangle2, Anchoring2D anchoring2D) {
        if (rectangle.width > this.mySize.width) {
            throw new IllegalStateException("The candidate is wider than needed.");
        }
        if (rectangle.height > this.mySize.height) {
            throw new IllegalStateException("The candidate is higher than needed.");
        }
        if (rectangle.width == this.mySize.width && rectangle.height == this.mySize.height) {
            this.myCandidateRect = rectangle;
            this.myCandidateRoom = rectangle2;
            this.myCandidateDisposition = anchoring2D;
            this.myCandidateRatio = 0;
            return true;
        }
        int n2 = this.mySize.width - rectangle.width;
        int n3 = this.mySize.height - rectangle.height;
        int n4 = n2 * n2 + n3 * n3;
        if (n4 < this.myCandidateRatio) {
            this.myCandidateRect = rectangle;
            this.myCandidateRoom = rectangle2;
            this.myCandidateDisposition = anchoring2D;
            this.myCandidateRatio = n4;
        }
        return false;
    }

    private final void j(Point point, Rectangle rectangle) {
        rectangle.x = point.x - rectangle.width / 2;
        if (RectangleUtilsKt.getLeft(rectangle) < RectangleUtilsKt.getLeft(this.myScreen)) {
            rectangle.x += RectangleUtilsKt.getLeft(this.myScreen) - RectangleUtilsKt.getLeft(rectangle);
        }
        if (RectangleUtilsKt.getRight(rectangle) > RectangleUtilsKt.getRight(this.myScreen)) {
            rectangle.x -= RectangleUtilsKt.getRight(rectangle) - RectangleUtilsKt.getRight(this.myScreen);
        }
    }

    private final void N(Point point, Rectangle rectangle) {
        rectangle.y = point.y - rectangle.height / 2;
        if (RectangleUtilsKt.getTop(rectangle) < RectangleUtilsKt.getTop(this.myScreen)) {
            rectangle.y += RectangleUtilsKt.getTop(this.myScreen) - RectangleUtilsKt.getTop(rectangle);
        }
        if (RectangleUtilsKt.getBottom(rectangle) > RectangleUtilsKt.getBottom(this.myScreen)) {
            rectangle.y -= RectangleUtilsKt.getBottom(rectangle) - RectangleUtilsKt.getBottom(this.myScreen);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Anchoring.values().length];
            try {
                nArray[Anchoring.NearOutside.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Anchoring.NearInside.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Anchoring.MiddleInside.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Anchoring.FarInside.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Anchoring.FarOutside.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

