/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.protocol;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.system.CpuArch;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\rJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/protocol/RuntimeSpecificAssemblyResolver;", "", "()V", "currentArch", "", "currentPlatformRid", "getCurrentPlatformRid", "()Ljava/lang/String;", "w", "", "arch", "enumerateRuntimeSpecificAssemblies", "", "Ljava/nio/file/Path;", "runtimesDir", "j", "", "tfm", "j", "platform", "N", "rid", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRuntimeSpecificAssemblyResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuntimeSpecificAssemblyResolver.kt\ncom/jetbrains/rider/protocol/RuntimeSpecificAssemblyResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n766#2:79\n857#2,2:80\n766#2:82\n857#2,2:83\n1054#2:85\n766#2:86\n857#2,2:87\n*S KotlinDebug\n*F\n+ 1 RuntimeSpecificAssemblyResolver.kt\ncom/jetbrains/rider/protocol/RuntimeSpecificAssemblyResolver\n*L\n66#1:79\n66#1:80,2\n72#1:82\n72#1:83,2\n72#1:85\n73#1:86\n73#1:87,2\n*E\n"})
public final class RuntimeSpecificAssemblyResolver {
    @NotNull
    public static final RuntimeSpecificAssemblyResolver INSTANCE = new RuntimeSpecificAssemblyResolver();
    @NotNull
    private static final String currentArch;

    private RuntimeSpecificAssemblyResolver() {
    }

    private final double j(String string) {
        return StringsKt.startsWith$default((String)string, (String)"net4", (boolean)false, (int)2, null) ? 70.0 + Double.parseDouble(StringsKt.substringAfter$default((String)string, (String)"net", null, (int)2, null)) : (StringsKt.startsWith$default((String)string, (String)"netcoreapp", (boolean)false, (int)2, null) ? 90.0 + Double.parseDouble(StringsKt.substringAfter$default((String)string, (String)"netcoreapp", null, (int)2, null)) : (StringsKt.startsWith$default((String)string, (String)"netstandard", (boolean)false, (int)2, null) ? 80.0 + Double.parseDouble(StringsKt.substringAfter$default((String)string, (String)"netstandard", null, (int)2, null)) : (StringsKt.startsWith$default((String)string, (String)"net", (boolean)false, (int)2, null) ? 100.0 + Double.parseDouble(StringsKt.substringAfter$default((String)string, (String)"net", null, (int)2, null)) : 0.0)));
    }

    @NotNull
    public final String getCurrentPlatformRid() {
        String string;
        if (SystemInfo.isLinux) {
            string = "linux";
        } else if (SystemInfo.isMac) {
            string = "osx";
        } else if (SystemInfo.isWindows) {
            string = "win";
        } else {
            throw new IllegalStateException(("Unknown platform: " + SystemInfoRt.OS_NAME).toString());
        }
        String string2 = string;
        return string2 + "-" + currentArch;
    }

    private final boolean j(String string) {
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return switch (string2) {
            case "any" -> true;
            case "linux" -> SystemInfo.isLinux;
            case "osx" -> SystemInfo.isMac;
            case "unix" -> SystemInfo.isUnix;
            case "win" -> SystemInfo.isWindows;
            default -> false;
        };
    }

    private final boolean w(String string) {
        return Intrinsics.areEqual((Object)string, (Object)currentArch);
    }

    private final boolean N(String string) {
        if (!StringsKt.contains$default((CharSequence)string, (char)'-', (boolean)false, (int)2, null)) {
            return this.j(string);
        }
        Object object = new char[]{'-'};
        List list = StringsKt.split$default((CharSequence)string, (char[])object, (boolean)false, (int)0, (int)6, null);
        if (list.size() != 2) {
            return false;
        }
        object = (String)list.get(0);
        String string2 = (String)list.get(1);
        return this.j((String)object) && this.w(string2);
    }

    @NotNull
    public final List<Path> enumerateRuntimeSpecificAssemblies(@NotNull Path runtimesDir) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)runtimesDir, (String)"runtimesDir");
        List list = new ArrayList();
        Iterable iterable = PathsKt.listDirectoryEntries$default((Path)runtimesDir, null, (int)1, null);
        boolean bl = false;
        Iterable iterable2 = iterable;
        Iterable iterable3 = new ArrayList();
        boolean bl2 = false;
        for (Object t10 : iterable2) {
            object = (Path)t10;
            boolean bl3 = false;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!(Files.isDirectory((Path)object, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && INSTANCE.N(PathsKt.getName((Path)object)))) continue;
            iterable3.add(t10);
        }
        List list2 = (List)iterable3;
        for (Path path : list2) {
            Object object2;
            iterable2 = path.resolve("lib");
            Intrinsics.checkNotNull((Object)iterable2);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isDirectory((Path)iterable2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            Object object3 = PathsKt.listDirectoryEntries$default((Path)iterable2, null, (int)1, null);
            boolean bl4 = false;
            object = object3;
            Collection collection = new ArrayList();
            boolean bl5 = false;
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                object2 = iterator2.next();
                Path path2 = (Path)object2;
                boolean bl6 = false;
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (!Files.isDirectory(path2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) continue;
                collection.add(object2);
            }
            object3 = (List)collection;
            bl4 = false;
            if ((Path)CollectionsKt.firstOrNull((List)CollectionsKt.sortedWith((Iterable)object3, (Comparator)new Comparator(){

                public final int compare(T a2, T b2) {
                    Path path = (Path)b2;
                    boolean bl = false;
                    Comparable comparable = Double.valueOf(RuntimeSpecificAssemblyResolver.access$getCompatScore(RuntimeSpecificAssemblyResolver.INSTANCE, PathsKt.getName((Path)path)));
                    path = (Path)a2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(RuntimeSpecificAssemblyResolver.access$getCompatScore(RuntimeSpecificAssemblyResolver.INSTANCE, PathsKt.getName((Path)path))));
                }
            })) == null) continue;
            Iterable iterable4 = PathsKt.listDirectoryEntries$default((Path)iterable3, null, (int)1, null);
            List list3 = list;
            boolean bl7 = false;
            Iterable iterable5 = iterable4;
            object = new ArrayList();
            boolean bl8 = false;
            for (Iterator iterator2 : iterable5) {
                object2 = (Path)((Object)iterator2);
                boolean bl9 = false;
                LinkOption[] linkOptionArray3 = new LinkOption[]{};
                if (!(Files.isRegularFile(object2, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length)) && StringsKt.equals((String)PathsKt.getExtension(object2), (String)"dll", (boolean)true))) continue;
                object.add(iterator2);
            }
            list3.addAll((List)object);
        }
        return list;
    }

    public static final /* synthetic */ double access$getCompatScore(RuntimeSpecificAssemblyResolver $this, String tfm) {
        return $this.j(tfm);
    }

    static {
        CpuArch cpuArch = CpuArch.CURRENT;
        currentArch = switch (cpuArch == null ? -1 : WhenMappings.$EnumSwitchMapping$0[cpuArch.ordinal()]) {
            case 1 -> "arm";
            case 2 -> "arm64";
            case 3 -> "x86";
            case 4 -> "x64";
            default -> throw new IllegalStateException(("Unknown CPU architecture: " + CpuArch.CURRENT).toString());
        };
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CpuArch.values().length];
            try {
                nArray[CpuArch.ARM32.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArch.ARM64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArch.X86.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArch.X86_64.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

