/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.protocol;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.RiderEnvironment;
import com.jetbrains.rider.protocol.ReSharperProcess;
import com.jetbrains.rider.protocol.ReSharperProcessBase;
import com.jetbrains.rider.protocol.RuntimeSpecificAssemblyResolver;
import com.jetbrains.rider.utils.XMLStreamHelpers;
import java.io.File;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0014\u0010\u000e\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/protocol/ReSharperProcess;", "Lcom/jetbrains/rider/protocol/ReSharperProcessBase;", "application", "Lcom/intellij/openapi/application/Application;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "serverPort", "", "killedEbs", "", "(Lcom/intellij/openapi/application/Application;Lcom/jetbrains/rd/util/lifetime/Lifetime;ILjava/lang/Long;)V", "isInternal", "", "()Z", "isUnitTesting", "getDotNetPluginsExtraDirs", "", "getDotNetPluginsXmlDescriptor", "getExtraEnvVars", "", "getExtraFlags", "", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nReSharperProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReSharperProcess.kt\ncom/jetbrains/rider/protocol/ReSharperProcess\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,318:1\n13#2:319\n13#3:320\n*S KotlinDebug\n*F\n+ 1 ReSharperProcess.kt\ncom/jetbrains/rider/protocol/ReSharperProcess\n*L\n41#1:319\n41#1:320\n*E\n"})
public final class ReSharperProcess
extends ReSharperProcessBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Application application;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Lazy<Companion.AdditionalInfo> additionalInfo$delegate;

    public ReSharperProcess(@NotNull Application application, @NotNull Lifetime lifetime2, int serverPort, @Nullable Long killedEbs) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        super(lifetime2, serverPort, killedEbs);
        this.application = application;
        this.start();
    }

    @Override
    @NotNull
    public String getDotNetPluginsXmlDescriptor() {
        return Companion.getAdditionalInfo().isEmpty() ? "" : Companion.getDotNetPluginsXmlDescriptor(Companion.getAdditionalInfo());
    }

    @Override
    public boolean isInternal() {
        return this.application.isInternal();
    }

    @Override
    public boolean isUnitTesting() {
        return this.application.isUnitTestMode();
    }

    @Override
    @NotNull
    public String getDotNetPluginsExtraDirs() {
        return Companion.getAdditionalInfo().isEmpty() ? "" : Companion.getAllDotNetBinDirectoriesAsSortedString(Companion.getAdditionalInfo());
    }

    @Override
    @NotNull
    public List<String> getExtraFlags() {
        return Companion.getAdditionalInfo().getExtraFlags();
    }

    @Override
    @NotNull
    public Map<String, String> getExtraEnvVars() {
        return Companion.getAdditionalInfo().getExtraEnvVars();
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getInstance(ReSharperProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ReSharperProcess.logger = logger;
        additionalInfo$delegate = LazyKt.lazy((Function0)Companion.additionalInfo.2.INSTANCE);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/protocol/ReSharperProcess$Companion;", "", "()V", "additionalInfo", "Lcom/jetbrains/rider/protocol/ReSharperProcess$Companion$AdditionalInfo;", "getAdditionalInfo", "()Lcom/jetbrains/rider/protocol/ReSharperProcess$Companion$AdditionalInfo;", "additionalInfo$delegate", "Lkotlin/Lazy;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getAllDotNetBinDirectoriesAsSortedString", "", "info", "j", "Ljava/util/SortedSet;", "Ljava/io/File;", "j", "plugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "getDotNetPluginsXmlDescriptor", "N", "AdditionalInfo", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nReSharperProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReSharperProcess.kt\ncom/jetbrains/rider/protocol/ReSharperProcess$Companion\n+ 2 XMLStreamHelpers.kt\ncom/jetbrains/rider/utils/XMLStreamHelpers\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,318:1\n7#2:319\n11#2,2:320\n11#2,4:323\n11#2,4:329\n11#2,2:340\n11#2,4:343\n13#2,2:348\n11#2,2:360\n11#2,4:363\n13#2,2:368\n13#2,2:371\n8#2:373\n1855#3:322\n1856#3:327\n1855#3:328\n1856#3:333\n1045#3:334\n1855#3:335\n1549#3:336\n1620#3,3:337\n1855#3:342\n1856#3:347\n1856#3:350\n1045#3:351\n1855#3:352\n766#3:353\n857#3,2:354\n1549#3:356\n1620#3,3:357\n1855#3:362\n1856#3:367\n1856#3:370\n1549#3:374\n1620#3,3:375\n1549#3:378\n1620#3,3:379\n*S KotlinDebug\n*F\n+ 1 ReSharperProcess.kt\ncom/jetbrains/rider/protocol/ReSharperProcess$Companion\n*L\n78#1:319\n79#1:320,2\n99#1:323,4\n105#1:329,4\n124#1:340,2\n132#1:343,4\n124#1:348,2\n162#1:360,2\n170#1:363,4\n162#1:368,2\n79#1:371,2\n78#1:373\n98#1:322\n98#1:327\n104#1:328\n104#1:333\n110#1:334\n110#1:335\n121#1:336\n121#1:337,3\n131#1:342\n131#1:347\n110#1:350\n142#1:351\n142#1:352\n153#1:353\n153#1:354,2\n159#1:356\n159#1:357,3\n169#1:362\n169#1:367\n142#1:370\n193#1:374\n193#1:375,3\n194#1:378\n194#1:379,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String j(IdeaPluginDescriptor ideaPluginDescriptor) {
            String string = ideaPluginDescriptor.getPluginId().getIdString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdString(...)");
            int n2 = StringsKt.lastIndexOf$default((CharSequence)string, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (n2 == -1) {
                String string2 = ideaPluginDescriptor.getVendor();
                if (string2 == null) {
                    throw new IllegalStateException("Company name not found".toString());
                }
                return string2;
            }
            String string3 = ideaPluginDescriptor.getPluginId().getIdString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getIdString(...)");
            String string4 = string3;
            int n3 = 0;
            String string5 = string4.substring(n3, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            return string5;
        }

        private final String N(IdeaPluginDescriptor ideaPluginDescriptor) {
            String string = ideaPluginDescriptor.getPluginId().getIdString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdString(...)");
            int n2 = StringsKt.lastIndexOf$default((CharSequence)string, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (n2 == -1) {
                String string2 = ideaPluginDescriptor.getPluginId().getIdString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdString(...)");
                return string2;
            }
            String string3 = ideaPluginDescriptor.getPluginId().getIdString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getIdString(...)");
            String string4 = string3;
            int n3 = n2 + 1;
            int n4 = ideaPluginDescriptor.getPluginId().getIdString().length();
            String string5 = string4.substring(n3, n4);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            return string5;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String getDotNetPluginsXmlDescriptor(@NotNull AdditionalInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Regex regex = new Regex("^(\\d+(\\s*\\.\\s*\\d+){0,3})(-(([-a-zA-Z0-9])([-a-zA-Z0-9\\\\.](?<!\\.{2}))*(?<!\\.)))?(\\+(?<Build>[0-9a-z\\-\\\\.]*))?$", RegexOption.IGNORE_CASE);
            StringWriter stringWriter = new StringWriter();
            XMLStreamWriter xMLStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(stringWriter);
            Intrinsics.checkNotNullExpressionValue((Object)xMLStreamWriter, (String)"createXMLStreamWriter(...)");
            try (XMLStreamWriter xMLStreamWriter2 = xMLStreamWriter;){
                boolean bl;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                boolean bl2;
                Object object7;
                boolean bl3;
                String string;
                Object object8;
                XMLStreamHelpers xMLStreamHelpers;
                boolean bl4;
                Path path;
                XMLStreamHelpers xMLStreamHelpers2 = XMLStreamHelpers.INSTANCE;
                boolean bl5 = false;
                XMLStreamWriter xMLStreamWriter3 = xMLStreamWriter2;
                boolean bl6 = false;
                XMLStreamHelpers xMLStreamHelpers3 = XMLStreamHelpers.INSTANCE;
                XMLStreamWriter xMLStreamWriter4 = xMLStreamWriter3;
                String string2 = "Packages";
                boolean bl7 = false;
                xMLStreamWriter4.writeStartElement(string2);
                XMLStreamWriter xMLStreamWriter5 = xMLStreamWriter4;
                boolean bl8 = false;
                Iterable iterable = CollectionsKt.sorted((Iterable)info.getNugetPackages());
                boolean bl9 = false;
                for (Object t10 : iterable) {
                    path = (Path)t10;
                    bl4 = false;
                    xMLStreamHelpers = XMLStreamHelpers.INSTANCE;
                    object8 = xMLStreamWriter5;
                    string = "File";
                    bl3 = false;
                    object8.writeStartElement(string);
                    object7 = object8;
                    bl2 = false;
                    XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)object7, "Path", ((Object)path).toString());
                    object8.writeEndElement();
                }
                iterable = CollectionsKt.sorted((Iterable)info.getDirsExpanded());
                bl9 = false;
                for (Object t10 : iterable) {
                    path = (Path)t10;
                    bl4 = false;
                    xMLStreamHelpers = XMLStreamHelpers.INSTANCE;
                    object8 = xMLStreamWriter5;
                    string = "Folder";
                    bl3 = false;
                    object8.writeStartElement(string);
                    object7 = object8;
                    bl2 = false;
                    XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)object7, "Path", ((Object)path).toString());
                    object8.writeEndElement();
                }
                iterable = info.getDirsAdHoc();
                bl9 = false;
                iterable = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)new Comparator(){

                    public final int compare(T a2, T b2) {
                        Pair pair2 = (Pair)a2;
                        boolean bl = false;
                        Comparable comparable = (Path)pair2.getSecond();
                        pair2 = (Pair)b2;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Path)pair2.getSecond()));
                    }
                });
                bl9 = false;
                for (Object t10 : iterable) {
                    Instant instant;
                    Object object9;
                    path = (Pair)t10;
                    bl4 = false;
                    xMLStreamHelpers = (IdeaPluginDescriptor)path.component1();
                    object8 = (Path)path.component2();
                    String string3 = xMLStreamHelpers.getVersion();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getVersion(...)");
                    string = regex.matches((CharSequence)string3) ? xMLStreamHelpers.getVersion() : "999.999.999";
                    List list = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)PathsKt.walk((Path)object8, (PathWalkOption[])new PathWalkOption[0]), (Function1)getDotNetPluginsXmlDescriptor.1.1.4.files.1.INSTANCE));
                    Intrinsics.checkNotNullExpressionValue((Object)xMLStreamHelpers.getPluginId().getIdString(), (String)"getIdString(...)");
                    if (list.isEmpty()) {
                        logger.warn("Backend/ReSharper dotnet part of plugin " + (String)object7 + " was skipped since plugin folder does not contain any dlls: " + (Path)object8);
                        continue;
                    }
                    Object object10 = list;
                    boolean bl10 = false;
                    object6 = object10;
                    Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object10, (int)10));
                    boolean bl11 = false;
                    object5 = object6.iterator();
                    while (object5.hasNext()) {
                        object9 = object5.next();
                        Path path2 = (Path)object9;
                        Collection collection2 = collection;
                        boolean bl12 = false;
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        FileTime fileTime = Files.getLastModifiedTime(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
                        collection2.add(fileTime.toInstant());
                    }
                    if ((Instant)CollectionsKt.maxOrNull((Iterable)((List)collection)) == null) continue;
                    object4 = ZonedDateTime.ofInstant(instant, ZoneId.systemDefault()).format(DateTimeFormatter.ISO_INSTANT);
                    object10 = XMLStreamHelpers.INSTANCE;
                    XMLStreamWriter xMLStreamWriter6 = xMLStreamWriter5;
                    object6 = "AdHocMetadata";
                    boolean bl13 = false;
                    xMLStreamWriter6.writeStartElement((String)object6);
                    XMLStreamWriter xMLStreamWriter7 = xMLStreamWriter6;
                    boolean bl14 = false;
                    XMLStreamHelpers.INSTANCE.attribute(xMLStreamWriter7, "BaseDir", ((Object)object8.toAbsolutePath()).toString());
                    Intrinsics.checkNotNull((Object)string);
                    XMLStreamHelpers.INSTANCE.attribute(xMLStreamWriter7, "Version", string);
                    Intrinsics.checkNotNull((Object)object4);
                    XMLStreamHelpers.INSTANCE.attribute(xMLStreamWriter7, "BuiltOn", (String)object4);
                    XMLStreamHelpers.INSTANCE.attribute(xMLStreamWriter7, "CompanyNameHuman", Companion.j((IdeaPluginDescriptor)xMLStreamHelpers));
                    XMLStreamHelpers.INSTANCE.attribute(xMLStreamWriter7, "SubplatformName", Companion.N((IdeaPluginDescriptor)xMLStreamHelpers));
                    object9 = CollectionsKt.sorted((Iterable)list);
                    boolean bl15 = false;
                    Iterator iterator = object9.iterator();
                    while (iterator.hasNext()) {
                        Object t11 = iterator.next();
                        Path path3 = (Path)t11;
                        boolean bl16 = false;
                        object3 = XMLStreamHelpers.INSTANCE;
                        XMLStreamWriter xMLStreamWriter8 = xMLStreamWriter7;
                        object2 = "PackageFile";
                        boolean bl17 = false;
                        xMLStreamWriter8.writeStartElement((String)object2);
                        object = xMLStreamWriter8;
                        bl = false;
                        XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)object, "RelativePath", ((Object)PathsKt.relativeTo((Path)path3, (Path)object8)).toString());
                        if (StringsKt.endsWith((String)PathsKt.getName((Path)path3), (String)".dll", (boolean)true)) {
                            XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)object, "AssemblyName", "*");
                        }
                        xMLStreamWriter8.writeEndElement();
                    }
                    xMLStreamWriter6.writeEndElement();
                }
                iterable = info.getDirsAdHocV2();
                bl9 = false;
                iterable = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)new Comparator(){

                    public final int compare(T a2, T b2) {
                        Pair pair2 = (Pair)a2;
                        boolean bl = false;
                        Comparable comparable = (Path)pair2.getSecond();
                        pair2 = (Pair)b2;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Path)pair2.getSecond()));
                    }
                });
                bl9 = false;
                for (Object t10 : iterable) {
                    Instant instant;
                    path = (Pair)t10;
                    bl4 = false;
                    xMLStreamHelpers = (IdeaPluginDescriptor)path.component1();
                    object8 = (Path)path.component2();
                    String string4 = xMLStreamHelpers.getVersion();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getVersion(...)");
                    string = regex.matches((CharSequence)string4) ? xMLStreamHelpers.getVersion() : "999.999.999";
                    Set set = new LinkedHashSet();
                    object7 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)PathsKt.walk((Path)object8, (PathWalkOption[])new PathWalkOption[0]), (Function1)getDotNetPluginsXmlDescriptor.1.1.6.files.1.INSTANCE));
                    Intrinsics.checkNotNullExpressionValue((Object)xMLStreamHelpers.getPluginId().getIdString(), (String)"getIdString(...)");
                    if (object7.isEmpty()) {
                        String string5;
                        logger.warn("Backend/ReSharper net-v2 part of plugin " + string5 + " was skipped since plugin folder does not contain any dlls: " + (Path)object8);
                        continue;
                    }
                    Iterable iterable2 = PathsKt.listDirectoryEntries$default((Path)object8, null, (int)1, null);
                    object6 = set;
                    boolean bl18 = false;
                    Object object11 = iterable2;
                    object5 = new ArrayList();
                    boolean bl19 = false;
                    Object object12 = object11.iterator();
                    while (object12.hasNext()) {
                        Object t12 = object12.next();
                        Path path4 = (Path)t12;
                        boolean bl20 = false;
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        if (!(Files.isRegularFile(path4, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && StringsKt.equals((String)PathsKt.getExtension((Path)path4), (String)"dll", (boolean)true))) continue;
                        object5.add(t12);
                    }
                    object6.addAll((List)object5);
                    iterable2 = object8.resolve("runtimes");
                    Intrinsics.checkNotNull((Object)iterable2);
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (Files.isDirectory((Path)iterable2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        set.addAll((Collection)RuntimeSpecificAssemblyResolver.INSTANCE.enumerateRuntimeSpecificAssemblies((Path)iterable2));
                    }
                    object5 = (Iterable)object7;
                    bl19 = false;
                    object12 = object5;
                    Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object5, (int)10));
                    boolean bl21 = false;
                    Iterator iterator = object12.iterator();
                    while (iterator.hasNext()) {
                        object4 = iterator.next();
                        Path path5 = (Path)object4;
                        object6 = collection;
                        boolean bl22 = false;
                        LinkOption[] linkOptionArray2 = new LinkOption[]{};
                        FileTime fileTime = Files.getLastModifiedTime(path5, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length));
                        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
                        object6.add(fileTime.toInstant());
                    }
                    if ((Instant)CollectionsKt.maxOrNull((Iterable)((List)collection)) == null) continue;
                    object11 = ZonedDateTime.ofInstant(instant, ZoneId.systemDefault()).format(DateTimeFormatter.ISO_INSTANT);
                    object5 = XMLStreamHelpers.INSTANCE;
                    XMLStreamWriter xMLStreamWriter9 = xMLStreamWriter5;
                    object12 = "AdHocMetadata";
                    boolean bl23 = false;
                    xMLStreamWriter9.writeStartElement((String)object12);
                    XMLStreamWriter xMLStreamWriter10 = xMLStreamWriter9;
                    boolean bl24 = false;
                    XMLStreamHelpers.INSTANCE.attribute(xMLStreamWriter10, "BaseDir", ((Object)object8.toAbsolutePath()).toString());
                    Intrinsics.checkNotNull((Object)string);
                    XMLStreamHelpers.INSTANCE.attribute(xMLStreamWriter10, "Version", string);
                    Intrinsics.checkNotNull((Object)object11);
                    XMLStreamHelpers.INSTANCE.attribute(xMLStreamWriter10, "BuiltOn", (String)object11);
                    XMLStreamHelpers.INSTANCE.attribute(xMLStreamWriter10, "CompanyNameHuman", Companion.j((IdeaPluginDescriptor)xMLStreamHelpers));
                    XMLStreamHelpers.INSTANCE.attribute(xMLStreamWriter10, "SubplatformName", Companion.N((IdeaPluginDescriptor)xMLStreamHelpers));
                    object4 = CollectionsKt.sorted((Iterable)((Iterable)object7));
                    boolean bl25 = false;
                    Iterator iterator2 = object4.iterator();
                    while (iterator2.hasNext()) {
                        Object t13 = iterator2.next();
                        object3 = (Path)t13;
                        boolean bl26 = false;
                        object2 = XMLStreamHelpers.INSTANCE;
                        XMLStreamWriter xMLStreamWriter11 = xMLStreamWriter10;
                        object = "PackageFile";
                        bl = false;
                        xMLStreamWriter11.writeStartElement((String)object);
                        XMLStreamWriter xMLStreamWriter12 = xMLStreamWriter11;
                        boolean bl27 = false;
                        Path path6 = PathsKt.relativeTo((Path)object3, (Path)object8);
                        XMLStreamHelpers.INSTANCE.attribute(xMLStreamWriter12, "RelativePath", ((Object)path6).toString());
                        if (set.contains(object3)) {
                            XMLStreamHelpers.INSTANCE.attribute(xMLStreamWriter12, "AssemblyName", "*");
                        }
                        xMLStreamWriter11.writeEndElement();
                    }
                    xMLStreamWriter9.writeEndElement();
                }
                xMLStreamWriter4.writeEndElement();
            }
            logger.info("Additional packages: " + stringWriter);
            String string = stringWriter.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final SortedSet<File> j(AdditionalInfo additionalInfo2) {
            boolean bl;
            Collection collection;
            Object object;
            Iterable iterable = additionalInfo2.getDirsAdHoc();
            Collection collection2 = CollectionsKt.listOf((Object)RiderEnvironment.INSTANCE.getRiderBackendDirectory());
            boolean bl2 = false;
            Iterable iterable2 = iterable;
            Collection collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl3 = false;
            for (Object t10 : iterable2) {
                object = (Pair)t10;
                collection = collection3;
                bl = false;
                collection.add(((Path)object.getSecond()).toFile());
            }
            iterable = additionalInfo2.getDirsExpanded();
            collection2 = CollectionsKt.plus((Collection)collection2, (Iterable)((List)collection3));
            bl2 = false;
            iterable2 = iterable;
            collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            bl3 = false;
            for (Object t10 : iterable2) {
                object = (Path)t10;
                collection = collection3;
                bl = false;
                collection.add(object.toFile());
            }
            List list = CollectionsKt.plus((Collection)collection2, (Iterable)((List)collection3));
            return CollectionsKt.toSortedSet((Iterable)list, (arg_0, arg_1) -> Companion.j(getAllDotNetBinDirectoriesSorted.1.INSTANCE, arg_0, arg_1));
        }

        @NotNull
        public final String getAllDotNetBinDirectoriesAsSortedString(@NotNull AdditionalInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            return CollectionsKt.joinToString$default((Iterable)this.j(info), (CharSequence)";", null, null, (int)0, null, null, (int)62, null);
        }

        @NotNull
        public final AdditionalInfo getAdditionalInfo() {
            Lazy lazy = additionalInfo$delegate;
            return (AdditionalInfo)lazy.getValue();
        }

        private static final int j(Function2 function2, Object object, Object object2) {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"$tmp0");
            return ((Number)function2.invoke(object, object2)).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u009f\u0001\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u0003\u0012\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u0003\u0012\u0018\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u0003\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000f\u00a2\u0006\u0002\u0010\u0010J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u001b\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u0003H\u00c6\u0003J\u001b\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u0003H\u00c6\u0003J\u001b\u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u0003H\u00c6\u0003J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010$\u001a\b\u0012\u0004\u0012\u00020\r0\u0003H\u00c6\u0003J\u0015\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000fH\u00c6\u0003J\u00b3\u0001\u0010&\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u001a\b\u0002\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u00032\u001a\b\u0002\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u00032\u001a\b\u0002\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u00032\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00032\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000fH\u00c6\u0001J\u0013\u0010'\u001a\u00020\u001a2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020*H\u00d6\u0001J\t\u0010+\u001a\u00020\rH\u00d6\u0001R#\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R#\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R#\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0012R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0012\u00a8\u0006,"}, d2={"Lcom/jetbrains/rider/protocol/ReSharperProcess$Companion$AdditionalInfo;", "", "nugetPackages", "", "Ljava/nio/file/Path;", "dirsAdHoc", "Lkotlin/Pair;", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "dirsAdHocV2", "debuggerDirs", "dirsExpanded", "projectTemplateDirs", "extraFlags", "", "extraEnvVars", "", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/Map;)V", "getDebuggerDirs", "()Ljava/util/List;", "getDirsAdHoc", "getDirsAdHocV2", "getDirsExpanded", "getExtraEnvVars", "()Ljava/util/Map;", "getExtraFlags", "isEmpty", "", "()Z", "getNugetPackages", "getProjectTemplateDirs", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "", "toString", "intellij.rider.rdclient.dotnet"})
        public static final class AdditionalInfo {
            @NotNull
            private final List<Path> nugetPackages;
            @NotNull
            private final List<Pair<IdeaPluginDescriptor, Path>> dirsAdHoc;
            @NotNull
            private final List<Pair<IdeaPluginDescriptor, Path>> dirsAdHocV2;
            @NotNull
            private final List<Pair<IdeaPluginDescriptor, Path>> debuggerDirs;
            @NotNull
            private final List<Path> dirsExpanded;
            @NotNull
            private final List<Path> projectTemplateDirs;
            @NotNull
            private final List<String> extraFlags;
            @NotNull
            private final Map<String, String> extraEnvVars;

            public AdditionalInfo(@NotNull List<? extends Path> nugetPackages, @NotNull List<? extends Pair<? extends IdeaPluginDescriptor, ? extends Path>> dirsAdHoc, @NotNull List<? extends Pair<? extends IdeaPluginDescriptor, ? extends Path>> dirsAdHocV2, @NotNull List<? extends Pair<? extends IdeaPluginDescriptor, ? extends Path>> debuggerDirs, @NotNull List<? extends Path> dirsExpanded, @NotNull List<? extends Path> projectTemplateDirs, @NotNull List<String> extraFlags, @NotNull Map<String, String> extraEnvVars) {
                Intrinsics.checkNotNullParameter(nugetPackages, (String)"nugetPackages");
                Intrinsics.checkNotNullParameter(dirsAdHoc, (String)"dirsAdHoc");
                Intrinsics.checkNotNullParameter(dirsAdHocV2, (String)"dirsAdHocV2");
                Intrinsics.checkNotNullParameter(debuggerDirs, (String)"debuggerDirs");
                Intrinsics.checkNotNullParameter(dirsExpanded, (String)"dirsExpanded");
                Intrinsics.checkNotNullParameter(projectTemplateDirs, (String)"projectTemplateDirs");
                Intrinsics.checkNotNullParameter(extraFlags, (String)"extraFlags");
                Intrinsics.checkNotNullParameter(extraEnvVars, (String)"extraEnvVars");
                this.nugetPackages = nugetPackages;
                this.dirsAdHoc = dirsAdHoc;
                this.dirsAdHocV2 = dirsAdHocV2;
                this.debuggerDirs = debuggerDirs;
                this.dirsExpanded = dirsExpanded;
                this.projectTemplateDirs = projectTemplateDirs;
                this.extraFlags = extraFlags;
                this.extraEnvVars = extraEnvVars;
            }

            @NotNull
            public final List<Path> getNugetPackages() {
                return this.nugetPackages;
            }

            @NotNull
            public final List<Pair<IdeaPluginDescriptor, Path>> getDirsAdHoc() {
                return this.dirsAdHoc;
            }

            @NotNull
            public final List<Pair<IdeaPluginDescriptor, Path>> getDirsAdHocV2() {
                return this.dirsAdHocV2;
            }

            @NotNull
            public final List<Pair<IdeaPluginDescriptor, Path>> getDebuggerDirs() {
                return this.debuggerDirs;
            }

            @NotNull
            public final List<Path> getDirsExpanded() {
                return this.dirsExpanded;
            }

            @NotNull
            public final List<Path> getProjectTemplateDirs() {
                return this.projectTemplateDirs;
            }

            @NotNull
            public final List<String> getExtraFlags() {
                return this.extraFlags;
            }

            @NotNull
            public final Map<String, String> getExtraEnvVars() {
                return this.extraEnvVars;
            }

            public final boolean isEmpty() {
                return this.nugetPackages.isEmpty() && this.dirsAdHoc.isEmpty() && this.dirsExpanded.isEmpty() && this.projectTemplateDirs.isEmpty();
            }

            @NotNull
            public final List<Path> component1() {
                return this.nugetPackages;
            }

            @NotNull
            public final List<Pair<IdeaPluginDescriptor, Path>> component2() {
                return this.dirsAdHoc;
            }

            @NotNull
            public final List<Pair<IdeaPluginDescriptor, Path>> component3() {
                return this.dirsAdHocV2;
            }

            @NotNull
            public final List<Pair<IdeaPluginDescriptor, Path>> component4() {
                return this.debuggerDirs;
            }

            @NotNull
            public final List<Path> component5() {
                return this.dirsExpanded;
            }

            @NotNull
            public final List<Path> component6() {
                return this.projectTemplateDirs;
            }

            @NotNull
            public final List<String> component7() {
                return this.extraFlags;
            }

            @NotNull
            public final Map<String, String> component8() {
                return this.extraEnvVars;
            }

            @NotNull
            public final AdditionalInfo copy(@NotNull List<? extends Path> nugetPackages, @NotNull List<? extends Pair<? extends IdeaPluginDescriptor, ? extends Path>> dirsAdHoc, @NotNull List<? extends Pair<? extends IdeaPluginDescriptor, ? extends Path>> dirsAdHocV2, @NotNull List<? extends Pair<? extends IdeaPluginDescriptor, ? extends Path>> debuggerDirs, @NotNull List<? extends Path> dirsExpanded, @NotNull List<? extends Path> projectTemplateDirs, @NotNull List<String> extraFlags, @NotNull Map<String, String> extraEnvVars) {
                Intrinsics.checkNotNullParameter(nugetPackages, (String)"nugetPackages");
                Intrinsics.checkNotNullParameter(dirsAdHoc, (String)"dirsAdHoc");
                Intrinsics.checkNotNullParameter(dirsAdHocV2, (String)"dirsAdHocV2");
                Intrinsics.checkNotNullParameter(debuggerDirs, (String)"debuggerDirs");
                Intrinsics.checkNotNullParameter(dirsExpanded, (String)"dirsExpanded");
                Intrinsics.checkNotNullParameter(projectTemplateDirs, (String)"projectTemplateDirs");
                Intrinsics.checkNotNullParameter(extraFlags, (String)"extraFlags");
                Intrinsics.checkNotNullParameter(extraEnvVars, (String)"extraEnvVars");
                return new AdditionalInfo(nugetPackages, dirsAdHoc, dirsAdHocV2, debuggerDirs, dirsExpanded, projectTemplateDirs, extraFlags, extraEnvVars);
            }

            public static /* synthetic */ AdditionalInfo copy$default(AdditionalInfo additionalInfo2, List list, List list2, List list3, List list4, List list5, List list6, List list7, Map map, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    list = additionalInfo2.nugetPackages;
                }
                if ((n2 & 2) != 0) {
                    list2 = additionalInfo2.dirsAdHoc;
                }
                if ((n2 & 4) != 0) {
                    list3 = additionalInfo2.dirsAdHocV2;
                }
                if ((n2 & 8) != 0) {
                    list4 = additionalInfo2.debuggerDirs;
                }
                if ((n2 & 0x10) != 0) {
                    list5 = additionalInfo2.dirsExpanded;
                }
                if ((n2 & 0x20) != 0) {
                    list6 = additionalInfo2.projectTemplateDirs;
                }
                if ((n2 & 0x40) != 0) {
                    list7 = additionalInfo2.extraFlags;
                }
                if ((n2 & 0x80) != 0) {
                    map = additionalInfo2.extraEnvVars;
                }
                return additionalInfo2.copy(list, list2, list3, list4, list5, list6, list7, map);
            }

            @NotNull
            public String toString() {
                return "AdditionalInfo(nugetPackages=" + this.nugetPackages + ", dirsAdHoc=" + this.dirsAdHoc + ", dirsAdHocV2=" + this.dirsAdHocV2 + ", debuggerDirs=" + this.debuggerDirs + ", dirsExpanded=" + this.dirsExpanded + ", projectTemplateDirs=" + this.projectTemplateDirs + ", extraFlags=" + this.extraFlags + ", extraEnvVars=" + this.extraEnvVars + ")";
            }

            public int hashCode() {
                int n2 = ((Object)this.nugetPackages).hashCode();
                n2 = n2 * 31 + ((Object)this.dirsAdHoc).hashCode();
                n2 = n2 * 31 + ((Object)this.dirsAdHocV2).hashCode();
                n2 = n2 * 31 + ((Object)this.debuggerDirs).hashCode();
                n2 = n2 * 31 + ((Object)this.dirsExpanded).hashCode();
                n2 = n2 * 31 + ((Object)this.projectTemplateDirs).hashCode();
                n2 = n2 * 31 + ((Object)this.extraFlags).hashCode();
                n2 = n2 * 31 + ((Object)this.extraEnvVars).hashCode();
                return n2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AdditionalInfo)) {
                    return false;
                }
                AdditionalInfo additionalInfo2 = (AdditionalInfo)other;
                if (!Intrinsics.areEqual(this.nugetPackages, additionalInfo2.nugetPackages)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.dirsAdHoc, additionalInfo2.dirsAdHoc)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.dirsAdHocV2, additionalInfo2.dirsAdHocV2)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.debuggerDirs, additionalInfo2.debuggerDirs)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.dirsExpanded, additionalInfo2.dirsExpanded)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.projectTemplateDirs, additionalInfo2.projectTemplateDirs)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.extraFlags, additionalInfo2.extraFlags)) {
                    return false;
                }
                return Intrinsics.areEqual(this.extraEnvVars, additionalInfo2.extraEnvVars);
            }
        }
    }
}

