/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.protocol;

import com.intellij.DynamicBundle;
import com.intellij.diagnostic.LoadingState;
import com.intellij.l10n.LocalizationUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004J\b\u0010\b\u001a\u0004\u0018\u00010\u0004J\u0006\u0010\t\u001a\u00020\nJ\n\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0002J\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/protocol/LocaleHelper;", "", "()V", "localizationFileName", "", "getCachedLocaleFile", "Ljava/io/File;", "getCurrentLocale", "getLocale", "isLocaleReady", "", "j", "writeCachedLocaleValue", "", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nReSharperProcessBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReSharperProcessBase.kt\ncom/jetbrains/rider/protocol/LocaleHelper\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,919:1\n23#2:920\n86#2,3:921\n23#2:924\n23#2:925\n23#2:926\n23#2:928\n1#3:927\n*S KotlinDebug\n*F\n+ 1 ReSharperProcessBase.kt\ncom/jetbrains/rider/protocol/LocaleHelper\n*L\n869#1:920\n869#1:921,3\n890#1:924\n894#1:925\n901#1:926\n911#1:928\n*E\n"})
public final class LocaleHelper {
    @NotNull
    public static final LocaleHelper INSTANCE = new LocaleHelper();
    @NotNull
    private static final String localizationFileName = "rider_locale_cache.txt";

    private LocaleHelper() {
    }

    public final boolean isLocaleReady() {
        return LoadingState.CONFIGURATION_STORE_INITIALIZED.isOccurred();
    }

    @NotNull
    public final File getCachedLocaleFile() {
        String string = PathManager.getSystemPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSystemPath(...)");
        String string2 = string;
        File file2 = new File(string2, "caches");
        return FilesKt.resolve((File)file2, (String)localizationFileName);
    }

    public final void writeCachedLocaleValue() {
        Object object;
        LocaleHelper localeHelper = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(LocaleHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        localeHelper = logger;
        bl = false;
        LocaleHelper localeHelper2 = localeHelper;
        try {
            Boolean bl2;
            object = localeHelper2;
            boolean bl3 = false;
            boolean bl4 = false;
            String string = INSTANCE.getLocale();
            File file2 = INSTANCE.getCachedLocaleFile();
            if (string == null) {
                bl2 = FileUtil.delete((File)file2);
            } else {
                FilesKt.writeText$default((File)file2, (String)string, null, (int)2, null);
                bl2 = Unit.INSTANCE;
            }
            object = Result.constructor-impl((Object)bl2);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        LoggerKt.getOrLogException((Object)object, (Logger)localeHelper);
    }

    @Nullable
    public final String getLocale() {
        return this.isLocaleReady() ? this.getCurrentLocale() : this.j();
    }

    private final String j() {
        try {
            return FilesKt.readText$default((File)this.getCachedLocaleFile(), null, (int)1, null);
        }
        catch (Throwable throwable) {
            if (throwable instanceof FileNotFoundException) {
                LocaleHelper localeHelper = this;
                boolean bl = false;
                Logger logger = Logger.getInstance(LocaleHelper.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("Cache locale file doesn't exist. return default value");
                return null;
            }
            LocaleHelper localeHelper = this;
            boolean bl = false;
            Logger logger = Logger.getInstance(LocaleHelper.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Failed to read rider_locale_cache.txt file", throwable);
            return null;
        }
    }

    @Nullable
    public final String getCurrentLocale() {
        String string;
        block22: {
            block20: {
                if (!LoadingState.CONFIGURATION_STORE_INITIALIZED.isOccurred()) {
                    LocaleHelper localeHelper = this;
                    boolean bl = false;
                    Logger logger = Logger.getInstance(LocaleHelper.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("getLocale is called too early");
                    return null;
                }
                Object object = LocalizationUtil.findLanguageBundle$default((LocalizationUtil)LocalizationUtil.INSTANCE, null, (int)1, null);
                if (object == null) break block20;
                DynamicBundle.LanguageBundleEP languageBundleEP = object;
                boolean bl = false;
                String string2 = Locale.forLanguageTag(languageBundleEP.locale).toLanguageTag();
                object = string2;
                if (string2 == null) break block20;
                languageBundleEP = object;
                bl = false;
                switch (languageBundleEP) {
                    case "ja": 
                    case "ja-JP": {
                        string = "ja-JP";
                        break;
                    }
                    case "ko": 
                    case "ko-KR": {
                        string = "ko-KR";
                        break;
                    }
                    case "zh-CN": 
                    case "zh": {
                        string = "zh-CN";
                        break;
                    }
                    default: {
                        LocaleHelper localeHelper = INSTANCE;
                        boolean bl2 = false;
                        Logger logger = Logger.getInstance(LocaleHelper.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.warn("Locale " + (String)languageBundleEP + " is not well known.");
                        return languageBundleEP;
                    }
                }
                break block22;
            }
            string = null;
        }
        return string;
    }
}

