/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.workspace.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.impl.VersionedStorageChangeInternal;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rider.projectView.ProjectModelViewUpdaterAsync;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.impl.WorkspaceModelUpdater;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u001a\u0010\u001a\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u001b\u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u001dH\u0002R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceModelDirectoryIndex;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "index", "", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "", "manager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "j", "", "url", "shouldUpdate", "Ljava/util/concurrent/atomic/AtomicBoolean;", "j", "entity", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "inIndex", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "N", "j", "action", "Lkotlin/Function0;", "Companion", "intellij.rider.rdclient.dotnet"})
public final class WorkspaceModelDirectoryIndex
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<VirtualFileUrl, Integer> index;
    @NotNull
    private final VirtualFileUrlManager manager;
    @NotNull
    private final ExecutorService executor;

    public WorkspaceModelDirectoryIndex(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.index = new LinkedHashMap();
        this.manager = WorkspaceModel.Companion.getInstance(this.project).getVirtualFileUrlManager();
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"WorkspaceModelDirectoryIndex", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        this.executor = executorService;
        final List list = new ArrayList();
        CollectionsKt.addAll((Collection)list, (Sequence)WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot().entities(ProjectModelEntity.class));
        CollectionsKt.addAll((Collection)list, (Sequence)WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot().entities(ContentRootEntity.class));
        this.j((Function0<Boolean>)((Function0)new Function0<Boolean>(){

            @NotNull
            public final Boolean invoke() {
                for (WorkspaceEntity workspaceEntity : list) {
                    this.j(this.j(workspaceEntity), new AtomicBoolean());
                }
                return false;
            }
        }));
        WorkspaceModelChangeListener workspaceModelChangeListener = new WorkspaceModelChangeListener(this){
            final /* synthetic */ WorkspaceModelDirectoryIndex this$0;
            {
                this.this$0 = $receiver;
            }

            public void changed(@NotNull VersionedStorageChange event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Sequence sequence = ((VersionedStorageChangeInternal)event).getAllChanges();
                if (SequencesKt.none((Sequence)sequence)) {
                    return;
                }
                WorkspaceModelDirectoryIndex.access$updateIndex(this.this$0, (Function0)new Function0<Boolean>(sequence, this.this$0){
                    final /* synthetic */ Sequence<EntityChange<?>> $changes;
                    final /* synthetic */ WorkspaceModelDirectoryIndex this$0;
                    {
                        this.$changes = $changes;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
                        for (EntityChange entityChange : this.$changes) {
                            VirtualFileUrl virtualFileUrl;
                            VirtualFileUrl virtualFileUrl2;
                            if (entityChange instanceof EntityChange.Added) {
                                WorkspaceModelDirectoryIndex.access$addToIndex(this.this$0, WorkspaceModelDirectoryIndex.access$getDirectoryUrl(this.this$0, ((EntityChange.Added)entityChange).getNewEntity()), atomicBoolean);
                            }
                            if (entityChange instanceof EntityChange.Removed) {
                                WorkspaceModelDirectoryIndex.access$removeFromIndex(this.this$0, WorkspaceModelDirectoryIndex.access$getDirectoryUrl(this.this$0, ((EntityChange.Removed)entityChange).getOldEntity()), atomicBoolean);
                            }
                            if (!(entityChange instanceof EntityChange.Replaced) || Intrinsics.areEqual((Object)(virtualFileUrl2 = WorkspaceModelDirectoryIndex.access$getDirectoryUrl(this.this$0, ((EntityChange.Replaced)entityChange).getOldEntity())), (Object)(virtualFileUrl = WorkspaceModelDirectoryIndex.access$getDirectoryUrl(this.this$0, ((EntityChange.Replaced)entityChange).getNewEntity())))) continue;
                            WorkspaceModelDirectoryIndex.access$removeFromIndex(this.this$0, virtualFileUrl2, atomicBoolean);
                            WorkspaceModelDirectoryIndex.access$addToIndex(this.this$0, virtualFileUrl, atomicBoolean);
                        }
                        return atomicBoolean.get();
                    }
                });
            }
        };
        this.project.getMessageBus().connect((Disposable)this).subscribe(WorkspaceModelTopics.CHANGED, (Object)workspaceModelChangeListener);
    }

    private final VirtualFileUrl j(WorkspaceEntity workspaceEntity) {
        WorkspaceEntity workspaceEntity2 = workspaceEntity;
        VirtualFileUrl virtualFileUrl = workspaceEntity2 instanceof ProjectModelEntity ? ProjectModelEntityExtensionsKt.getContentRootUrl((ProjectModelEntity)workspaceEntity, this.manager) : (workspaceEntity2 instanceof ContentRootEntity ? ((ContentRootEntity)workspaceEntity).getUrl() : null);
        if (virtualFileUrl == null) {
            return null;
        }
        VirtualFileUrl virtualFileUrl2 = virtualFileUrl;
        return virtualFileUrl2.getParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean inIndex(@NotNull VirtualFile virtualFile2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Map<VirtualFileUrl, Integer> map = this.index;
        synchronized (map) {
            bl = false;
            Integer n2 = this.index.get(VirtualFileUrls.toVirtualFileUrl((VirtualFile)virtualFile2, (VirtualFileUrlManager)this.manager));
            bl = n2 != null && n2 > 0;
        }
        return bl;
    }

    private final void j(Function0<Boolean> function0) {
        this.executor.submit(() -> WorkspaceModelDirectoryIndex.j(this, function0));
    }

    private final void j(VirtualFileUrl virtualFileUrl, AtomicBoolean atomicBoolean) {
        int n2;
        if (virtualFileUrl == null) {
            return;
        }
        Integer n3 = this.index.get(virtualFileUrl);
        int n4 = n2 = n3 != null ? n3 : 0;
        if (n2 == 0) {
            this.index.put(virtualFileUrl, 1);
            atomicBoolean.set(true);
        } else {
            this.index.put(virtualFileUrl, n2 + 1);
        }
        this.j(virtualFileUrl.getParent(), atomicBoolean);
    }

    private final void N(VirtualFileUrl virtualFileUrl, AtomicBoolean atomicBoolean) {
        if (virtualFileUrl == null) {
            return;
        }
        Integer n2 = this.index.get(virtualFileUrl);
        int n3 = n2 != null ? n2 : 0;
        switch (n3) {
            case 0: {
                break;
            }
            case 1: {
                this.index.remove(virtualFileUrl);
                atomicBoolean.set(true);
                break;
            }
            default: {
                this.index.put(virtualFileUrl, n3 - 1);
            }
        }
        this.N(virtualFileUrl.getParent(), atomicBoolean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void j(WorkspaceModelDirectoryIndex workspaceModelDirectoryIndex, Function0 function0) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)((Object)workspaceModelDirectoryIndex), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)function0, (String)"$action");
        Map<VirtualFileUrl, Integer> map = workspaceModelDirectoryIndex.index;
        synchronized (map) {
            bl2 = false;
            bl2 = (Boolean)function0.invoke();
        }
        boolean bl3 = bl2;
        boolean bl4 = bl = !bl3 || (Boolean)((WorkspaceModelUpdater)((Object)workspaceModelDirectoryIndex.project.getService(WorkspaceModelUpdater.class))).isLiveMode().getValue() == false;
        if (bl) {
            return;
        }
        ProjectModelViewUpdaterAsync.Companion.getInstance(workspaceModelDirectoryIndex.project).requestUpdatePresentation();
    }

    public static final /* synthetic */ void access$updateIndex(WorkspaceModelDirectoryIndex $this, Function0 action2) {
        $this.j((Function0<Boolean>)action2);
    }

    public static final /* synthetic */ void access$removeFromIndex(WorkspaceModelDirectoryIndex $this, VirtualFileUrl url2, AtomicBoolean shouldUpdate) {
        $this.N(url2, shouldUpdate);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceModelDirectoryIndex$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceModelDirectoryIndex;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nWorkspaceModelDirectoryIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceModelDirectoryIndex.kt\ncom/jetbrains/rider/projectView/workspace/impl/WorkspaceModelDirectoryIndex$Companion\n+ 2 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n*L\n1#1,130:1\n17#2,2:131\n*S KotlinDebug\n*F\n+ 1 WorkspaceModelDirectoryIndex.kt\ncom/jetbrains/rider/projectView/workspace/impl/WorkspaceModelDirectoryIndex$Companion\n*L\n26#1:131,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WorkspaceModelDirectoryIndex getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager componentManager = (ComponentManager)project2;
            boolean bl = false;
            Object object = componentManager.getService(WorkspaceModelDirectoryIndex.class);
            if (object == null) {
                throw new IllegalStateException("Service " + WorkspaceModelDirectoryIndex.class + " not found in container " + componentManager);
            }
            return (WorkspaceModelDirectoryIndex)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

