/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.workspace.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.util.Alarm;
import com.intellij.util.ApplicationKt;
import com.intellij.util.SingleAlarm;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rider.projectView.ProjectModelViewUpdaterAsync;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityReference;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.projectView.workspace.impl.WorkspaceEntityErrorsSupport;
import com.jetbrains.rider.projectView.workspace.impl.WorkspaceModelUpdater;
import com.jetbrains.rider.solutionAnalysis.SolutionAnalysisHost;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\u0018\u0000  2\u00020\u0001:\u0004 !\"#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0006\u0010\u001b\u001a\u00020\u0015J\u000e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u001d\u001a\u00020\u0015H\u0002J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "alarm", "Lcom/intellij/util/SingleAlarm;", "errors", "Ljava/util/HashMap;", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntityReference;", "Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport$EntityErrorData;", "Lkotlin/collections/HashMap;", "isReady", "", "()Z", "queue", "", "Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport$Event;", "workspaceModel", "Lcom/intellij/platform/backend/workspace/WorkspaceModel;", "j", "", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "j", "count", "", "forceUpdate", "hasErrors", "j", "N", "N", "Companion", "EntityErrorData", "Event", "EventType", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nWorkspaceEntityErrorsSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceEntityErrorsSupport.kt\ncom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,184:1\n372#2,7:185\n372#2,7:192\n13#3:199\n*S KotlinDebug\n*F\n+ 1 WorkspaceEntityErrorsSupport.kt\ncom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport\n*L\n143#1:185,7\n153#1:192,7\n26#1:199\n*E\n"})
public final class WorkspaceEntityErrorsSupport
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final HashMap<ProjectModelEntityReference, EntityErrorData> errors;
    @NotNull
    private final WorkspaceModel workspaceModel;
    @NotNull
    private final List<Event> queue;
    @NotNull
    private final SingleAlarm alarm;
    @NotNull
    private static final Logger logger;

    public WorkspaceEntityErrorsSupport(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.errors = new HashMap();
        this.workspaceModel = WorkspaceModel.Companion.getInstance(this.project);
        this.queue = new ArrayList();
        this.alarm = new SingleAlarm(() -> WorkspaceEntityErrorsSupport.N(this), 100, Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        ApplicationKt.getApplication().invokeLater(() -> WorkspaceEntityErrorsSupport.j(this));
    }

    public final boolean isReady() {
        ApplicationKt.getApplication().assertIsDispatchThread();
        return this.queue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasErrors(@NotNull ProjectModelEntity entity2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)entity2, (String)"entity");
        HashMap<ProjectModelEntityReference, EntityErrorData> hashMap = this.errors;
        synchronized (hashMap) {
            bl = false;
            EntityErrorData entityErrorData = this.errors.get(ProjectModelEntityExtensionsKt.toReference(entity2));
            bl = entityErrorData != null && (entityErrorData.getHasErrors() || entityErrorData.getChildrenErrors() > 0);
        }
        return bl;
    }

    public final void forceUpdate() {
        this.alarm.cancelAndRequest(true);
    }

    private final void j() {
        ApplicationKt.getApplication().assertIsDispatchThread();
        WorkspaceModelUpdater workspaceModelUpdater = WorkspaceModelUpdater.Companion.getInstance(this.project);
        workspaceModelUpdater.doWhenReady((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ WorkspaceEntityErrorsSupport this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                if (WorkspaceEntityErrorsSupport.access$getQueue$p(this.this$0).isEmpty()) {
                    return;
                }
                HashMap hashMap = WorkspaceEntityErrorsSupport.access$getErrors$p(this.this$0);
                WorkspaceEntityErrorsSupport workspaceEntityErrorsSupport = this.this$0;
                HashMap hashMap2 = hashMap;
                synchronized (hashMap2) {
                    boolean bl = false;
                    for (Event event : WorkspaceEntityErrorsSupport.access$getQueue$p(workspaceEntityErrorsSupport)) {
                        ProjectModelEntity projectModelEntity;
                        if (WorkspaceModelExtensionsKt.getProjectModelEntity(WorkspaceEntityErrorsSupport.access$getWorkspaceModel$p(workspaceEntityErrorsSupport), event.getId()) == null) continue;
                        Logger logger = WorkspaceEntityErrorsSupport.access$getLogger$cp();
                        boolean bl2 = false;
                        if (logger.isTraceEnabled()) {
                            Logger logger2 = logger;
                            boolean bl3 = false;
                            logger2.trace("Update " + event.getId() + " " + projectModelEntity.getName());
                        }
                        switch (performUpdate.WhenMappings.$EnumSwitchMapping$0[event.getEventType().ordinal()]) {
                            case 1: {
                                WorkspaceEntityErrorsSupport.access$addErrorMark(workspaceEntityErrorsSupport, projectModelEntity);
                                break;
                            }
                            case 2: {
                                WorkspaceEntityErrorsSupport.access$removeErrorMark(workspaceEntityErrorsSupport, projectModelEntity);
                            }
                        }
                    }
                    WorkspaceEntityErrorsSupport.access$getQueue$p(workspaceEntityErrorsSupport).clear();
                    Unit unit = Unit.INSTANCE;
                }
                hashMap = WorkspaceEntityErrorsSupport.access$getLogger$cp();
                boolean bl = false;
                if (hashMap.isTraceEnabled()) {
                    HashMap hashMap3 = hashMap;
                    boolean bl4 = false;
                    hashMap3.trace("Errors were updated");
                }
                ProjectModelViewUpdaterAsync.Companion.getInstance(WorkspaceEntityErrorsSupport.access$getProject$p(this.this$0)).requestUpdatePresentation();
            }
        }));
    }

    private final void j(ProjectModelEntity projectModelEntity) {
        EntityErrorData entityErrorData;
        Object object;
        Map map = this.errors;
        ProjectModelEntityReference projectModelEntityReference = ProjectModelEntityExtensionsKt.toReference(projectModelEntity);
        boolean bl = false;
        Object v10 = map.get(projectModelEntityReference);
        if (v10 == null) {
            boolean bl2 = false;
            EntityErrorData entityErrorData2 = new EntityErrorData();
            map.put(projectModelEntityReference, entityErrorData2);
            object = entityErrorData2;
        } else {
            object = v10;
        }
        if ((entityErrorData = (EntityErrorData)object).getHasErrors()) {
            return;
        }
        entityErrorData.setHasErrors(true);
        this.j(projectModelEntity, 1);
    }

    private final void j(ProjectModelEntity projectModelEntity, int n2) {
        for (ProjectModelEntity projectModelEntity2 = projectModelEntity.getParentEntity(); projectModelEntity2 != null; projectModelEntity2 = projectModelEntity2.getParentEntity()) {
            Object object;
            Map map = this.errors;
            ProjectModelEntityReference projectModelEntityReference = ProjectModelEntityExtensionsKt.toReference(projectModelEntity2);
            boolean bl = false;
            Object v10 = map.get(projectModelEntityReference);
            if (v10 == null) {
                boolean bl2 = false;
                EntityErrorData entityErrorData = new EntityErrorData();
                map.put(projectModelEntityReference, entityErrorData);
                object = entityErrorData;
            } else {
                object = v10;
            }
            EntityErrorData entityErrorData = (EntityErrorData)object;
            entityErrorData.setChildrenErrors(entityErrorData.getChildrenErrors() + n2);
        }
    }

    private final void N(ProjectModelEntity projectModelEntity) {
        EntityErrorData entityErrorData = this.errors.remove(ProjectModelEntityExtensionsKt.toReference(projectModelEntity));
        if (entityErrorData == null) {
            return;
        }
        EntityErrorData entityErrorData2 = entityErrorData;
        int n2 = entityErrorData2.getTotalErrors();
        if (n2 == 0) {
            return;
        }
        this.N(projectModelEntity, n2);
    }

    private final void N(ProjectModelEntity projectModelEntity, int n2) {
        for (ProjectModelEntity projectModelEntity2 = projectModelEntity.getParentEntity(); projectModelEntity2 != null; projectModelEntity2 = projectModelEntity2.getParentEntity()) {
            EntityErrorData entityErrorData = this.errors.get(ProjectModelEntityExtensionsKt.toReference(projectModelEntity2));
            if (entityErrorData == null) continue;
            entityErrorData.setChildrenErrors(entityErrorData.getChildrenErrors() - n2);
        }
    }

    private static final void N(WorkspaceEntityErrorsSupport workspaceEntityErrorsSupport) {
        Intrinsics.checkNotNullParameter((Object)((Object)workspaceEntityErrorsSupport), (String)"this$0");
        workspaceEntityErrorsSupport.j();
    }

    private static final void j(WorkspaceEntityErrorsSupport workspaceEntityErrorsSupport) {
        Intrinsics.checkNotNullParameter((Object)((Object)workspaceEntityErrorsSupport), (String)"this$0");
        if (workspaceEntityErrorsSupport.project.isDisposed()) {
            return;
        }
        SolutionAnalysisHost solutionAnalysisHost = SolutionAnalysisHost.Companion.getInstance(workspaceEntityErrorsSupport.project);
        solutionAnalysisHost.getErrorsRegistered().advise(workspaceEntityErrorsSupport.getServiceLifetime(), (Function1)new Function1<Integer, Unit>(workspaceEntityErrorsSupport){
            final /* synthetic */ WorkspaceEntityErrorsSupport this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(int it) {
                ApplicationKt.getApplication().assertIsDispatchThread();
                Logger logger = WorkspaceEntityErrorsSupport.access$getLogger$cp();
                boolean bl = false;
                if (logger.isTraceEnabled()) {
                    Logger logger2 = logger;
                    boolean bl2 = false;
                    logger2.trace("Register error for " + it + "...");
                }
                WorkspaceEntityErrorsSupport.access$getQueue$p(this.this$0).add(new Event(it, EventType.Add));
                SingleAlarm.cancelAndRequest$default((SingleAlarm)WorkspaceEntityErrorsSupport.access$getAlarm$p(this.this$0), (boolean)false, (int)1, null);
            }
        });
        solutionAnalysisHost.getErrorsUnregistered().advise(workspaceEntityErrorsSupport.getServiceLifetime(), (Function1)new Function1<Integer, Unit>(workspaceEntityErrorsSupport){
            final /* synthetic */ WorkspaceEntityErrorsSupport this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(int it) {
                ApplicationKt.getApplication().assertIsDispatchThread();
                Logger logger = WorkspaceEntityErrorsSupport.access$getLogger$cp();
                boolean bl = false;
                if (logger.isTraceEnabled()) {
                    Logger logger2 = logger;
                    boolean bl2 = false;
                    logger2.trace("Unregister error for " + it + "...");
                }
                WorkspaceEntityErrorsSupport.access$getQueue$p(this.this$0).add(new Event(it, EventType.Remove));
                SingleAlarm.cancelAndRequest$default((SingleAlarm)WorkspaceEntityErrorsSupport.access$getAlarm$p(this.this$0), (boolean)false, (int)1, null);
            }
        });
        WorkspaceModelChangeListener workspaceModelChangeListener = new WorkspaceModelChangeListener(workspaceEntityErrorsSupport){
            final /* synthetic */ WorkspaceEntityErrorsSupport this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void changed(@NotNull VersionedStorageChange event) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Object object2 = WorkspaceEntityErrorsSupport.access$getErrors$p(this.this$0);
                Object object3 = this.this$0;
                Object object4 = object2;
                synchronized (object4) {
                    boolean bl = false;
                    if (WorkspaceEntityErrorsSupport.access$getErrors$p(object3).isEmpty()) {
                        return;
                    }
                    object = Unit.INSTANCE;
                }
                object2 = event.getChanges(ProjectModelEntity.class);
                if (!CollectionsKt.any((Iterable)((Iterable)object2))) {
                    return;
                }
                object3 = WorkspaceEntityErrorsSupport.access$getErrors$p(this.this$0);
                object4 = this.this$0;
                object = object3;
                synchronized (object) {
                    boolean bl = false;
                    Iterator<E> iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        EntityChange entityChange = (EntityChange)iterator.next();
                        if (entityChange instanceof EntityChange.Removed) {
                            WorkspaceEntityErrorsSupport.access$removeErrorMark((WorkspaceEntityErrorsSupport)((Object)object4), (ProjectModelEntity)((EntityChange.Removed)entityChange).getOldEntity());
                        }
                        if (!(entityChange instanceof EntityChange.Replaced)) continue;
                        ProjectModelEntityReference projectModelEntityReference = ProjectModelEntityExtensionsKt.toReference((ProjectModelEntity)((EntityChange.Replaced)entityChange).getOldEntity());
                        EntityErrorData entityErrorData = (EntityErrorData)WorkspaceEntityErrorsSupport.access$getErrors$p((WorkspaceEntityErrorsSupport)((Object)object4)).get(projectModelEntityReference);
                        if (entityErrorData == null || entityErrorData.getTotalErrors() <= 0) continue;
                        WorkspaceEntityErrorsSupport.access$removeErrorMarkForParents((WorkspaceEntityErrorsSupport)((Object)object4), (ProjectModelEntity)((EntityChange.Replaced)entityChange).getOldEntity(), entityErrorData.getTotalErrors());
                        WorkspaceEntityErrorsSupport.access$addErrorMarkForParents((WorkspaceEntityErrorsSupport)((Object)object4), (ProjectModelEntity)((EntityChange.Replaced)entityChange).getNewEntity(), entityErrorData.getTotalErrors());
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        };
        workspaceEntityErrorsSupport.project.getMessageBus().connect((Disposable)workspaceEntityErrorsSupport).subscribe(WorkspaceModelTopics.CHANGED, (Object)workspaceModelChangeListener);
    }

    public static final /* synthetic */ List access$getQueue$p(WorkspaceEntityErrorsSupport $this) {
        return $this.queue;
    }

    public static final /* synthetic */ HashMap access$getErrors$p(WorkspaceEntityErrorsSupport $this) {
        return $this.errors;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ Project access$getProject$p(WorkspaceEntityErrorsSupport $this) {
        return $this.project;
    }

    public static final /* synthetic */ WorkspaceModel access$getWorkspaceModel$p(WorkspaceEntityErrorsSupport $this) {
        return $this.workspaceModel;
    }

    public static final /* synthetic */ void access$addErrorMark(WorkspaceEntityErrorsSupport $this, ProjectModelEntity entity2) {
        $this.j(entity2);
    }

    public static final /* synthetic */ void access$removeErrorMark(WorkspaceEntityErrorsSupport $this, ProjectModelEntity entity2) {
        $this.N(entity2);
    }

    public static final /* synthetic */ SingleAlarm access$getAlarm$p(WorkspaceEntityErrorsSupport $this) {
        return $this.alarm;
    }

    public static final /* synthetic */ void access$removeErrorMarkForParents(WorkspaceEntityErrorsSupport $this, ProjectModelEntity entity2, int count) {
        $this.N(entity2, count);
    }

    public static final /* synthetic */ void access$addErrorMarkForParents(WorkspaceEntityErrorsSupport $this, ProjectModelEntity entity2, int count) {
        $this.j(entity2, count);
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(WorkspaceEntityErrorsSupport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        WorkspaceEntityErrorsSupport.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WorkspaceEntityErrorsSupport getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Object object = project2.getService(WorkspaceEntityErrorsSupport.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (WorkspaceEntityErrorsSupport)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport$EntityErrorData;", "", "()V", "childrenErrors", "", "getChildrenErrors", "()I", "setChildrenErrors", "(I)V", "hasErrors", "", "getHasErrors", "()Z", "setHasErrors", "(Z)V", "totalErrors", "getTotalErrors", "intellij.rider.rdclient.dotnet"})
    private static final class EntityErrorData {
        private boolean hasErrors;
        private int childrenErrors;

        public final boolean getHasErrors() {
            return this.hasErrors;
        }

        public final void setHasErrors(boolean bl) {
            this.hasErrors = bl;
        }

        public final int getChildrenErrors() {
            return this.childrenErrors;
        }

        public final void setChildrenErrors(int n2) {
            this.childrenErrors = n2;
        }

        public final int getTotalErrors() {
            return this.childrenErrors + (this.hasErrors ? 1 : 0);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport$Event;", "", "id", "", "eventType", "Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport$EventType;", "(ILcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport$EventType;)V", "getEventType", "()Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport$EventType;", "getId", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.rider.rdclient.dotnet"})
    private static final class Event {
        private final int id;
        @NotNull
        private final EventType eventType;

        public Event(int id, @NotNull EventType eventType) {
            Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"eventType");
            this.id = id;
            this.eventType = eventType;
        }

        public final int getId() {
            return this.id;
        }

        @NotNull
        public final EventType getEventType() {
            return this.eventType;
        }

        public final int component1() {
            return this.id;
        }

        @NotNull
        public final EventType component2() {
            return this.eventType;
        }

        @NotNull
        public final Event copy(int id, @NotNull EventType eventType) {
            Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"eventType");
            return new Event(id, eventType);
        }

        public static /* synthetic */ Event copy$default(Event event, int n2, EventType eventType, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n2 = event.id;
            }
            if ((n3 & 2) != 0) {
                eventType = event.eventType;
            }
            return event.copy(n2, eventType);
        }

        @NotNull
        public String toString() {
            return "Event(id=" + this.id + ", eventType=" + this.eventType + ")";
        }

        public int hashCode() {
            int n2 = Integer.hashCode(this.id);
            n2 = n2 * 31 + this.eventType.hashCode();
            return n2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Event)) {
                return false;
            }
            Event event = (Event)other;
            if (this.id != event.id) {
                return false;
            }
            return this.eventType == event.eventType;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport$EventType;", "", "(Ljava/lang/String;I)V", "Add", "Remove", "intellij.rider.rdclient.dotnet"})
    private static final class EventType
    extends Enum<EventType> {
        public static final /* enum */ EventType Add = new EventType();
        public static final /* enum */ EventType Remove = new EventType();
        private static final /* synthetic */ EventType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static EventType[] values() {
            return (EventType[])$VALUES.clone();
        }

        public static EventType valueOf(String value2) {
            return Enum.valueOf(EventType.class, value2);
        }

        @NotNull
        public static EnumEntries<EventType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = eventTypeArray = new EventType[]{EventType.Add, EventType.Remove};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

