/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.workspace;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.projectView.workspace.impl.WorkspaceModelUpdater;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0004\u001a\u001b\u001c\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\t\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/projectView/workspace/WorkspaceModelEvents;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "addSignal", "Lcom/jetbrains/rd/util/reactive/ISignal;", "Lcom/jetbrains/rider/projectView/workspace/WorkspaceModelEvents$AddEntityEvent;", "getAddSignal", "()Lcom/jetbrains/rd/util/reactive/ISignal;", "changeSignal", "Lcom/jetbrains/rd/util/reactive/Signal;", "", "getChangeSignal", "()Lcom/jetbrains/rd/util/reactive/Signal;", "removeSignal", "Lcom/jetbrains/rider/projectView/workspace/WorkspaceModelEvents$RemoveEntityEvent;", "getRemoveSignal", "synced", "Lcom/jetbrains/rd/util/reactive/Property;", "", "getSynced", "()Lcom/jetbrains/rd/util/reactive/Property;", "updateSignal", "Lcom/jetbrains/rider/projectView/workspace/WorkspaceModelEvents$UpdateEntityEvent;", "getUpdateSignal", "AddEntityEvent", "Companion", "RemoveEntityEvent", "UpdateEntityEvent", "intellij.rider.rdclient.dotnet"})
public final class WorkspaceModelEvents
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ISignal<AddEntityEvent> addSignal;
    @NotNull
    private final ISignal<RemoveEntityEvent> removeSignal;
    @NotNull
    private final ISignal<UpdateEntityEvent> updateSignal;
    @NotNull
    private final Property<Boolean> synced;
    @NotNull
    private final Signal<Unit> changeSignal;

    public WorkspaceModelEvents(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.addSignal = (ISignal)new Signal();
        this.removeSignal = (ISignal)new Signal();
        this.updateSignal = (ISignal)new Signal();
        this.synced = new Property((Object)false);
        this.changeSignal = new Signal();
        WorkspaceModelChangeListener workspaceModelChangeListener = new WorkspaceModelChangeListener(this){
            final /* synthetic */ WorkspaceModelEvents this$0;
            {
                this.this$0 = $receiver;
            }

            public void changed(@NotNull VersionedStorageChange event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                List list = event.getChanges(ProjectModelEntity.class);
                boolean bl = false;
                for (EntityChange entityChange : list) {
                    Integer n2;
                    if (entityChange instanceof EntityChange.Added) {
                        n2 = WorkspaceModelExtensionsKt.getProjectModelId((EntityStorage)event.getStorageAfter(), (ProjectModelEntity)((EntityChange.Added)entityChange).getNewEntity());
                        this.this$0.getAddSignal().fire((Object)new AddEntityEvent(n2, (ProjectModelEntity)((EntityChange.Added)entityChange).getNewEntity()));
                        bl = true;
                    }
                    if (entityChange instanceof EntityChange.Removed) {
                        n2 = WorkspaceModelExtensionsKt.getProjectModelId((EntityStorage)event.getStorageBefore(), (ProjectModelEntity)((EntityChange.Removed)entityChange).getOldEntity());
                        this.this$0.getRemoveSignal().fire((Object)new RemoveEntityEvent(n2, (ProjectModelEntity)((EntityChange.Removed)entityChange).getOldEntity()));
                        bl = true;
                    }
                    if (!(entityChange instanceof EntityChange.Replaced)) continue;
                    n2 = WorkspaceModelExtensionsKt.getProjectModelId((EntityStorage)event.getStorageBefore(), (ProjectModelEntity)((EntityChange.Replaced)entityChange).getOldEntity());
                    Integer n3 = WorkspaceModelExtensionsKt.getProjectModelId((EntityStorage)event.getStorageAfter(), (ProjectModelEntity)((EntityChange.Replaced)entityChange).getNewEntity());
                    if (n2 != null && !Intrinsics.areEqual((Object)n2, (Object)n3)) {
                        boolean bl2 = false;
                        boolean bl3 = false;
                        Logger logger = Logger.getInstance(WorkspaceModelEvents.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.error("Entity ID was changed during update. Rider does not handle this situation well. OldId = " + n2 + "; NewId = " + n3 + "; Entity = " + ((ProjectModelEntity)((EntityChange.Replaced)entityChange).getNewEntity()).getName());
                    }
                    this.this$0.getUpdateSignal().fire((Object)new UpdateEntityEvent(n3, (ProjectModelEntity)((EntityChange.Replaced)entityChange).getOldEntity(), (ProjectModelEntity)((EntityChange.Replaced)entityChange).getNewEntity()));
                    bl = true;
                }
                if (bl && ((Boolean)this.this$0.getSynced().getValue()).booleanValue()) {
                    InterfacesKt.fire((ISignal)((ISignal)this.this$0.getChangeSignal()));
                }
            }
        };
        project2.getMessageBus().connect((Disposable)this).subscribe(WorkspaceModelTopics.CHANGED, (Object)workspaceModelChangeListener);
        BoolPropertyExKt.whenTrue((IViewable)((IViewable)WorkspaceModelUpdater.Companion.getInstance(project2).isLiveMode()), (Lifetime)this.getServiceLifetime(), (Function1)((Function1)new Function1<Lifetime, Unit>(){

            public final void invoke(@NotNull Lifetime it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.getSynced().set((Object)true);
                InterfacesKt.fire((ISignal)((ISignal)this.getChangeSignal()));
            }
        }));
    }

    @NotNull
    public final ISignal<AddEntityEvent> getAddSignal() {
        return this.addSignal;
    }

    @NotNull
    public final ISignal<RemoveEntityEvent> getRemoveSignal() {
        return this.removeSignal;
    }

    @NotNull
    public final ISignal<UpdateEntityEvent> getUpdateSignal() {
        return this.updateSignal;
    }

    @NotNull
    public final Property<Boolean> getSynced() {
        return this.synced;
    }

    @NotNull
    public final Signal<Unit> getChangeSignal() {
        return this.changeSignal;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J$\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/projectView/workspace/WorkspaceModelEvents$AddEntityEvent;", "", "id", "", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "(Ljava/lang/Integer;Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;)V", "getEntity", "()Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "getId", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "component1", "component2", "copy", "(Ljava/lang/Integer;Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;)Lcom/jetbrains/rider/projectView/workspace/WorkspaceModelEvents$AddEntityEvent;", "equals", "", "other", "hashCode", "toString", "", "intellij.rider.rdclient.dotnet"})
    public static final class AddEntityEvent {
        @Nullable
        private final Integer id;
        @NotNull
        private final ProjectModelEntity entity;

        public AddEntityEvent(@Nullable Integer id, @NotNull ProjectModelEntity entity2) {
            Intrinsics.checkNotNullParameter((Object)entity2, (String)"entity");
            this.id = id;
            this.entity = entity2;
        }

        @Nullable
        public final Integer getId() {
            return this.id;
        }

        @NotNull
        public final ProjectModelEntity getEntity() {
            return this.entity;
        }

        @Nullable
        public final Integer component1() {
            return this.id;
        }

        @NotNull
        public final ProjectModelEntity component2() {
            return this.entity;
        }

        @NotNull
        public final AddEntityEvent copy(@Nullable Integer id, @NotNull ProjectModelEntity entity2) {
            Intrinsics.checkNotNullParameter((Object)entity2, (String)"entity");
            return new AddEntityEvent(id, entity2);
        }

        public static /* synthetic */ AddEntityEvent copy$default(AddEntityEvent addEntityEvent, Integer n2, ProjectModelEntity projectModelEntity, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n2 = addEntityEvent.id;
            }
            if ((n3 & 2) != 0) {
                projectModelEntity = addEntityEvent.entity;
            }
            return addEntityEvent.copy(n2, projectModelEntity);
        }

        @NotNull
        public String toString() {
            return "AddEntityEvent(id=" + this.id + ", entity=" + this.entity + ")";
        }

        public int hashCode() {
            int n2 = this.id == null ? 0 : ((Object)this.id).hashCode();
            n2 = n2 * 31 + this.entity.hashCode();
            return n2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AddEntityEvent)) {
                return false;
            }
            AddEntityEvent addEntityEvent = (AddEntityEvent)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)addEntityEvent.id)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.entity, (Object)addEntityEvent.entity);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/projectView/workspace/WorkspaceModelEvents$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/rider/projectView/workspace/WorkspaceModelEvents;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WorkspaceModelEvents getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Object object = project2.getService(WorkspaceModelEvents.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (WorkspaceModelEvents)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J$\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/projectView/workspace/WorkspaceModelEvents$RemoveEntityEvent;", "", "id", "", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "(Ljava/lang/Integer;Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;)V", "getEntity", "()Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "getId", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "component1", "component2", "copy", "(Ljava/lang/Integer;Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;)Lcom/jetbrains/rider/projectView/workspace/WorkspaceModelEvents$RemoveEntityEvent;", "equals", "", "other", "hashCode", "toString", "", "intellij.rider.rdclient.dotnet"})
    public static final class RemoveEntityEvent {
        @Nullable
        private final Integer id;
        @NotNull
        private final ProjectModelEntity entity;

        public RemoveEntityEvent(@Nullable Integer id, @NotNull ProjectModelEntity entity2) {
            Intrinsics.checkNotNullParameter((Object)entity2, (String)"entity");
            this.id = id;
            this.entity = entity2;
        }

        @Nullable
        public final Integer getId() {
            return this.id;
        }

        @NotNull
        public final ProjectModelEntity getEntity() {
            return this.entity;
        }

        @Nullable
        public final Integer component1() {
            return this.id;
        }

        @NotNull
        public final ProjectModelEntity component2() {
            return this.entity;
        }

        @NotNull
        public final RemoveEntityEvent copy(@Nullable Integer id, @NotNull ProjectModelEntity entity2) {
            Intrinsics.checkNotNullParameter((Object)entity2, (String)"entity");
            return new RemoveEntityEvent(id, entity2);
        }

        public static /* synthetic */ RemoveEntityEvent copy$default(RemoveEntityEvent removeEntityEvent, Integer n2, ProjectModelEntity projectModelEntity, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n2 = removeEntityEvent.id;
            }
            if ((n3 & 2) != 0) {
                projectModelEntity = removeEntityEvent.entity;
            }
            return removeEntityEvent.copy(n2, projectModelEntity);
        }

        @NotNull
        public String toString() {
            return "RemoveEntityEvent(id=" + this.id + ", entity=" + this.entity + ")";
        }

        public int hashCode() {
            int n2 = this.id == null ? 0 : ((Object)this.id).hashCode();
            n2 = n2 * 31 + this.entity.hashCode();
            return n2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RemoveEntityEvent)) {
                return false;
            }
            RemoveEntityEvent removeEntityEvent = (RemoveEntityEvent)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)removeEntityEvent.id)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.entity, (Object)removeEntityEvent.entity);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J.\u0010\u0011\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/projectView/workspace/WorkspaceModelEvents$UpdateEntityEvent;", "", "id", "", "oldEntity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "newEntity", "(Ljava/lang/Integer;Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;)V", "getId", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getNewEntity", "()Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "getOldEntity", "component1", "component2", "component3", "copy", "(Ljava/lang/Integer;Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;)Lcom/jetbrains/rider/projectView/workspace/WorkspaceModelEvents$UpdateEntityEvent;", "equals", "", "other", "hashCode", "toString", "", "intellij.rider.rdclient.dotnet"})
    public static final class UpdateEntityEvent {
        @Nullable
        private final Integer id;
        @NotNull
        private final ProjectModelEntity oldEntity;
        @NotNull
        private final ProjectModelEntity newEntity;

        public UpdateEntityEvent(@Nullable Integer id, @NotNull ProjectModelEntity oldEntity, @NotNull ProjectModelEntity newEntity) {
            Intrinsics.checkNotNullParameter((Object)oldEntity, (String)"oldEntity");
            Intrinsics.checkNotNullParameter((Object)newEntity, (String)"newEntity");
            this.id = id;
            this.oldEntity = oldEntity;
            this.newEntity = newEntity;
        }

        @Nullable
        public final Integer getId() {
            return this.id;
        }

        @NotNull
        public final ProjectModelEntity getOldEntity() {
            return this.oldEntity;
        }

        @NotNull
        public final ProjectModelEntity getNewEntity() {
            return this.newEntity;
        }

        @Nullable
        public final Integer component1() {
            return this.id;
        }

        @NotNull
        public final ProjectModelEntity component2() {
            return this.oldEntity;
        }

        @NotNull
        public final ProjectModelEntity component3() {
            return this.newEntity;
        }

        @NotNull
        public final UpdateEntityEvent copy(@Nullable Integer id, @NotNull ProjectModelEntity oldEntity, @NotNull ProjectModelEntity newEntity) {
            Intrinsics.checkNotNullParameter((Object)oldEntity, (String)"oldEntity");
            Intrinsics.checkNotNullParameter((Object)newEntity, (String)"newEntity");
            return new UpdateEntityEvent(id, oldEntity, newEntity);
        }

        public static /* synthetic */ UpdateEntityEvent copy$default(UpdateEntityEvent updateEntityEvent, Integer n2, ProjectModelEntity projectModelEntity, ProjectModelEntity projectModelEntity2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n2 = updateEntityEvent.id;
            }
            if ((n3 & 2) != 0) {
                projectModelEntity = updateEntityEvent.oldEntity;
            }
            if ((n3 & 4) != 0) {
                projectModelEntity2 = updateEntityEvent.newEntity;
            }
            return updateEntityEvent.copy(n2, projectModelEntity, projectModelEntity2);
        }

        @NotNull
        public String toString() {
            return "UpdateEntityEvent(id=" + this.id + ", oldEntity=" + this.oldEntity + ", newEntity=" + this.newEntity + ")";
        }

        public int hashCode() {
            int n2 = this.id == null ? 0 : ((Object)this.id).hashCode();
            n2 = n2 * 31 + this.oldEntity.hashCode();
            n2 = n2 * 31 + this.newEntity.hashCode();
            return n2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UpdateEntityEvent)) {
                return false;
            }
            UpdateEntityEvent updateEntityEvent = (UpdateEntityEvent)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)updateEntityEvent.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.oldEntity, (Object)updateEntityEvent.oldEntity)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.newEntity, (Object)updateEntityEvent.newEntity);
        }
    }
}

