/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.workspace;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.EntityPointer;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.jetbrains.rd.platform.util.DataContextKt;
import com.jetbrains.rider.editors.TextControlUtilsKt;
import com.jetbrains.rider.model.RdAnalyzerReferenceDescriptor;
import com.jetbrains.rider.model.RdAssemblyReferenceDescriptor;
import com.jetbrains.rider.model.RdCustomLocation;
import com.jetbrains.rider.model.RdDependencyDescriptor;
import com.jetbrains.rider.model.RdDependencyFolderDescriptor;
import com.jetbrains.rider.model.RdDependencyFolderDescriptorType;
import com.jetbrains.rider.model.RdDependencyType;
import com.jetbrains.rider.model.RdImportDescriptor;
import com.jetbrains.rider.model.RdImportFolderDescriptor;
import com.jetbrains.rider.model.RdProjectDescriptor;
import com.jetbrains.rider.model.RdProjectFileDescriptor;
import com.jetbrains.rider.model.RdProjectFolderDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.model.RdProjectReferenceDescriptor;
import com.jetbrains.rider.model.RdProjectType;
import com.jetbrains.rider.model.RdRoslynAnalyzerDiagnosticDescriptor;
import com.jetbrains.rider.model.RdSolutionDescriptor;
import com.jetbrains.rider.model.RdSolutionFolderDescriptor;
import com.jetbrains.rider.model.RdSourceGeneratorFileDescriptor;
import com.jetbrains.rider.model.RdSourceGeneratorFolderDescriptor;
import com.jetbrains.rider.model.RdTargetFrameworkFolderDescriptor;
import com.jetbrains.rider.model.RdUnloadProjectDescriptor;
import com.jetbrains.rider.model.RdUnloadProjectState;
import com.jetbrains.rider.model.RdUnresolvedReferenceDescriptor;
import com.jetbrains.rider.model.RdWebReferenceDescriptor;
import com.jetbrains.rider.model.RdWebReferenceDescriptorType;
import com.jetbrains.rider.projectView.ProjectModelDataKeys;
import com.jetbrains.rider.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.rider.projectView.workspace.ListNodeData;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityReference;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.util.idea.DataContextExKt;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0096\u0001\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\u001a2\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0005j\b\u0012\u0004\u0012\u00020\u0003`\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0002\u001a\f\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u0003\u001a\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u0003*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\f\u0010\u000f\u001a\u0004\u0018\u00010\u0003*\u00020\u0003\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0003\u001a*\u0010\u0012\u001a\u00020\u0001*\u00020\u00032\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\f0\u0005j\b\u0012\u0004\u0012\u00020\f`\u00062\u0006\u0010\u0013\u001a\u00020\b\u001a\f\u0010\u0014\u001a\u0004\u0018\u00010\u0003*\u00020\u0015\u001a\u001a\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\f0\u0005j\b\u0012\u0004\u0012\u00020\f`\u0006*\u00020\u0003\u001a\u0010\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018*\u00020\u0003\u001a\u0010\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018*\u00020\u0003\u001a\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001d\u001a\f\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u00020\u0003\u001a\u0019\u0010 \u001a\u0004\u0018\u00010!*\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\"\u001a\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018*\u00020$2\b\b\u0002\u0010%\u001a\u00020\b\u001a\u0016\u0010&\u001a\u0004\u0018\u00010\u0003*\u00020$2\b\b\u0002\u0010%\u001a\u00020\b\u001a\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018*\b\u0012\u0004\u0012\u00020\u00030(\u001a\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u0018*\b\u0012\u0004\u0012\u00020*0(\u001a\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\f0\u0018*\b\u0012\u0004\u0012\u00020\f0(\u001a4\u0010,\u001a\b\u0012\u0004\u0012\u0002H-0\u0018\"\u0004\b\u0000\u0010-*\b\u0012\u0004\u0012\u0002H-0(2\u0014\u0010.\u001a\u0010\u0012\u0004\u0012\u0002H-\u0012\u0006\u0012\u0004\u0018\u0001H-0/H\u0002\u001a\f\u00100\u001a\u0004\u0018\u00010\f*\u00020\u0003\u001a\f\u00101\u001a\u0004\u0018\u00010\f*\u00020\u0003\u001a\n\u00102\u001a\u00020\b*\u00020\u0003\u001a\n\u00103\u001a\u00020\b*\u00020\u0003\u001a\n\u00104\u001a\u00020\b*\u00020\u0003\u001a\n\u00105\u001a\u00020\b*\u00020\u0003\u001a\n\u00106\u001a\u00020\b*\u00020\u0003\u001a\u0012\u00107\u001a\u00020\b*\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e\u001a\n\u00108\u001a\u00020\b*\u00020\u0003\u001a\n\u00109\u001a\u00020\b*\u00020\u0003\u001a\n\u0010:\u001a\u00020\b*\u00020\u0003\u001a\n\u0010;\u001a\u00020\b*\u00020\u0003\u001a\n\u0010<\u001a\u00020\b*\u00020\u0003\u001a\n\u0010=\u001a\u00020\b*\u00020\u0003\u001a\u0011\u0010>\u001a\u0004\u0018\u00010\b*\u00020\u0003\u00a2\u0006\u0002\u0010?\u001a\n\u0010@\u001a\u00020\b*\u00020\u0003\u001a\n\u0010A\u001a\u00020\b*\u00020\u0003\u001a\n\u0010B\u001a\u00020\b*\u00020\u0003\u001a\u0012\u0010C\u001a\u00020\b*\u00020D2\u0006\u0010E\u001a\u00020!\u001a\n\u0010C\u001a\u00020\b*\u00020\u0003\u001a\n\u0010F\u001a\u00020\b*\u00020\u0003\u001a\n\u0010G\u001a\u00020\b*\u00020\u0003\u001a\n\u0010H\u001a\u00020\b*\u00020\u0003\u001a\n\u0010I\u001a\u00020\b*\u00020\u0003\u001a\n\u0010J\u001a\u00020\b*\u00020\u0003\u001a\f\u0010K\u001a\u00020\b*\u00020\u0003H\u0002\u001a\n\u0010L\u001a\u00020\b*\u00020\u0003\u001a\n\u0010M\u001a\u00020\b*\u00020\u0003\u001a\n\u0010N\u001a\u00020\b*\u00020\u0003\u001a\u0012\u0010O\u001a\u00020\b*\u00020\u00032\u0006\u0010P\u001a\u00020\u0003\u001a\n\u0010Q\u001a\u00020\b*\u00020\u0003\u001a\n\u0010R\u001a\u00020\b*\u00020\u0003\u001a\n\u0010S\u001a\u00020\b*\u00020\u0003\u001a\n\u0010T\u001a\u00020\b*\u00020\u0003\u001a\n\u0010U\u001a\u00020\b*\u00020\u0003\u001a\n\u0010V\u001a\u00020\b*\u00020\u0003\u001a\n\u0010W\u001a\u00020\b*\u00020\u0003\u001a\n\u0010X\u001a\u00020\b*\u00020\u0003\u001a\n\u0010Y\u001a\u00020\b*\u00020\u0003\u001a\n\u0010Z\u001a\u00020\b*\u00020\u0003\u001a\n\u0010[\u001a\u00020\b*\u00020\u0003\u001a\n\u0010\\\u001a\u00020\b*\u00020\u0003\u001a\n\u0010]\u001a\u00020\b*\u00020\u0003\u001a\n\u0010^\u001a\u00020\b*\u00020\u0003\u001a\n\u0010_\u001a\u00020\b*\u00020\u0003\u001a\n\u0010`\u001a\u00020\b*\u00020\u0003\u001a\n\u0010a\u001a\u00020\b*\u00020\u0003\u001a\n\u0010b\u001a\u00020\b*\u00020\u0003\u001a\n\u0010c\u001a\u00020\b*\u00020\u0003\u001a\n\u0010d\u001a\u00020\b*\u00020\u0003\u001a\n\u0010e\u001a\u00020\b*\u00020\u0003\u001a\n\u0010f\u001a\u00020\b*\u00020\u0003\u001a\n\u0010g\u001a\u00020h*\u00020\u0003\u001a$\u0010i\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00110j*\b\u0012\u0004\u0012\u00020\u00030\u00182\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006k"}, d2={"j", "", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "set", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "onlyNestedFiles", "", "asRoslynAnalyzerDiagnostic", "Lcom/jetbrains/rider/model/RdRoslynAnalyzerDiagnosticDescriptor;", "containingEntity", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "containingProjectEntity", "containingTargetFrameworkId", "", "fillAffectedVirtualFilesRecursive", "withInternalItems", "findProjectModelEntity", "Lcom/intellij/psi/PsiDirectory;", "getAffectedVirtualFiles", "getAllChildrenAndThis", "", "getAllNestedFilesAndThis", "getContentRootUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "manager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "getFile", "Ljava/io/File;", "getId", "", "(Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;Lcom/intellij/openapi/project/Project;)Ljava/lang/Integer;", "getProjectModelEntities", "Lcom/intellij/openapi/actionSystem/DataContext;", "takeNodeFromEditor", "getProjectModelEntity", "getRootEntities", "", "getRootPaths", "Ljava/nio/file/Path;", "getRootVirtualFiles", "j", "T", "getParent", "Lkotlin/Function1;", "getVirtualFileAsContentRoot", "getVirtualFileAsParent", "isAnalyzerReference", "isAnalyzersFolder", "isAnyDependencyFolder", "isAssembliesFolder", "isAssemblyReference", "isConnectedToBackend", "isDependenciesFolder", "isDependency", "isDependencyPackage", "isDependencyProjectReference", "isDependencyReference", "isDirectory", "isDirectoryAwareEntity", "(Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;)Ljava/lang/Boolean;", "isExistingSolution", "isFilteredProject", "isFrameworkReferencesFolder", "isFromSharedProject", "Lcom/intellij/platform/backend/workspace/WorkspaceModel;", "id", "isFromVcxProject", "isHiddenInSolutionFilter", "isImplicitAssembliesFolder", "isImportFolder", "isImportItem", "j", "isLinkedProjectFile", "isLinkedProjectFolder", "isPackagesFolder", "isParentOf", "child", "isProject", "isProjectFile", "isProjectFolder", "isProjectReference", "isProjectsFolder", "isReference", "isRoslynAnalyzerDiagnostic", "isSDKFolder", "isSolution", "isSolutionFolder", "isSourceGeneratorFile", "isSourceGeneratorFolder", "isSourceGeneratorsFolder", "isTargetFrameworkFolder", "isUnloadedProject", "isUnresolvedReference", "isVirtualSolution", "isWebReference", "isWebReferenceFolder", "isWebReferenceItem", "isXcAssetItemFolder", "isXcAssetsFolder", "toReference", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntityReference;", "withUniqueNames", "", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nProjectModelEntityExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectModelEntityExtensions.kt\ncom/jetbrains/rider/projectView/workspace/ProjectModelEntityExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,413:1\n819#2:414\n847#2,2:415\n1726#2,3:436\n372#3,7:417\n372#3,7:424\n125#4:431\n152#4,3:432\n1#5:435\n*S KotlinDebug\n*F\n+ 1 ProjectModelEntityExtensions.kt\ncom/jetbrains/rider/projectView/workspace/ProjectModelEntityExtensionsKt\n*L\n186#1:414\n186#1:415,2\n410#1:436,3\n263#1:417,7\n285#1:424,7\n297#1:431\n297#1:432,3\n*E\n"})
public final class ProjectModelEntityExtensionsKt {
    @Nullable
    public static final Integer getId(@NotNull ProjectModelEntity $this$getId, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)$this$getId, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return WorkspaceModelExtensionsKt.getProjectModelId(WorkspaceModel.Companion.getInstance(project2), $this$getId);
    }

    public static final boolean isConnectedToBackend(@NotNull ProjectModelEntity $this$isConnectedToBackend, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)$this$isConnectedToBackend, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Integer n2 = ProjectModelEntityExtensionsKt.getId($this$isConnectedToBackend, project2);
        return n2 != null && n2 > 0;
    }

    @NotNull
    public static final ProjectModelEntityReference toReference(@NotNull ProjectModelEntity $this$toReference) {
        Intrinsics.checkNotNullParameter((Object)$this$toReference, (String)"<this>");
        return new ProjectModelEntityReference((EntityPointer<? extends ProjectModelEntity>)$this$toReference.createPointer());
    }

    @Nullable
    public static final ProjectModelEntity containingProjectEntity(@NotNull ProjectModelEntity $this$containingProjectEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$containingProjectEntity, (String)"<this>");
        if (ProjectModelEntityExtensionsKt.isProject($this$containingProjectEntity) || ProjectModelEntityExtensionsKt.isUnloadedProject($this$containingProjectEntity)) {
            return $this$containingProjectEntity;
        }
        ProjectModelEntity projectModelEntity = $this$containingProjectEntity.getParentEntity();
        if (projectModelEntity == null) {
            return null;
        }
        ProjectModelEntity projectModelEntity2 = projectModelEntity;
        return ProjectModelEntityExtensionsKt.containingProjectEntity(projectModelEntity2);
    }

    @Nullable
    public static final String containingTargetFrameworkId(@NotNull ProjectModelEntity $this$containingTargetFrameworkId) {
        Intrinsics.checkNotNullParameter((Object)$this$containingTargetFrameworkId, (String)"<this>");
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = $this$containingTargetFrameworkId.getDescriptor();
        if (rdProjectModelItemDescriptor instanceof RdTargetFrameworkFolderDescriptor) {
            return ((RdTargetFrameworkFolderDescriptor)rdProjectModelItemDescriptor).getTargetFrameworkId();
        }
        if (ProjectModelEntityExtensionsKt.isProject($this$containingTargetFrameworkId) || ProjectModelEntityExtensionsKt.isUnloadedProject($this$containingTargetFrameworkId)) {
            return null;
        }
        ProjectModelEntity projectModelEntity = $this$containingTargetFrameworkId.getParentEntity();
        if (projectModelEntity == null) {
            return null;
        }
        ProjectModelEntity projectModelEntity2 = projectModelEntity;
        return ProjectModelEntityExtensionsKt.containingTargetFrameworkId(projectModelEntity2);
    }

    @Nullable
    public static final ProjectModelEntity containingEntity(@NotNull VirtualFile $this$containingEntity, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)$this$containingEntity, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project2);
        VirtualFile virtualFile2 = $this$containingEntity;
        while (virtualFile2.getParent() != null) {
            List<ProjectModelEntity> list = WorkspaceModelExtensionsKt.getProjectModelEntities(workspaceModel, virtualFile2, project2);
            if (CollectionsKt.any((Iterable)list)) {
                return ProjectModelEntityExtensionsKt.containingProjectEntity((ProjectModelEntity)CollectionsKt.first(list));
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2.getParent(), (String)"getParent(...)");
        }
        return null;
    }

    public static final boolean isParentOf(@NotNull ProjectModelEntity $this$isParentOf, @NotNull ProjectModelEntity child) {
        Intrinsics.checkNotNullParameter((Object)$this$isParentOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        ProjectModelEntity projectModelEntity = child.getParentEntity();
        if (Intrinsics.areEqual((Object)projectModelEntity, (Object)$this$isParentOf)) {
            return true;
        }
        if (projectModelEntity == null) {
            return false;
        }
        return ProjectModelEntityExtensionsKt.isParentOf($this$isParentOf, projectModelEntity);
    }

    @NotNull
    public static final List<ProjectModelEntity> getAllChildrenAndThis(@NotNull ProjectModelEntity $this$getAllChildrenAndThis) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllChildrenAndThis, (String)"<this>");
        HashSet hashSet = new HashSet();
        ProjectModelEntityExtensionsKt.collectAllChildrenAndThis$default($this$getAllChildrenAndThis, hashSet, false, 4, null);
        return CollectionsKt.toList((Iterable)hashSet);
    }

    @NotNull
    public static final List<ProjectModelEntity> getAllNestedFilesAndThis(@NotNull ProjectModelEntity $this$getAllNestedFilesAndThis) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllNestedFilesAndThis, (String)"<this>");
        HashSet<ProjectModelEntity> hashSet = new HashSet<ProjectModelEntity>();
        ProjectModelEntityExtensionsKt.j($this$getAllNestedFilesAndThis, hashSet, true);
        return CollectionsKt.toList((Iterable)hashSet);
    }

    private static final void j(ProjectModelEntity projectModelEntity, HashSet<ProjectModelEntity> hashSet, boolean bl) {
        hashSet.add(projectModelEntity);
        if (!bl || ProjectModelEntityExtensionsKt.isProjectFile(projectModelEntity)) {
            for (ProjectModelEntity projectModelEntity2 : projectModelEntity.getChildrenEntities()) {
                ProjectModelEntityExtensionsKt.j(projectModelEntity2, hashSet, bl);
            }
        }
    }

    static /* synthetic */ void collectAllChildrenAndThis$default(ProjectModelEntity projectModelEntity, HashSet hashSet, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        ProjectModelEntityExtensionsKt.j(projectModelEntity, hashSet, bl);
    }

    @Nullable
    public static final File getFile(@NotNull ProjectModelEntity $this$getFile) {
        Intrinsics.checkNotNullParameter((Object)$this$getFile, (String)"<this>");
        Object object = $this$getFile.getUrl();
        return object != null && (object = VirtualFileUrlManagerUtil.toPath((VirtualFileUrl)object)) != null ? object.toFile() : null;
    }

    public static final boolean isDirectory(@NotNull ProjectModelEntity $this$isDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$isDirectory, (String)"<this>");
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = $this$isDirectory.getDescriptor();
        return rdProjectModelItemDescriptor instanceof RdProjectFolderDescriptor ? true : (rdProjectModelItemDescriptor instanceof RdSolutionFolderDescriptor ? true : (rdProjectModelItemDescriptor instanceof RdWebReferenceDescriptor ? true : (rdProjectModelItemDescriptor instanceof RdProjectDescriptor ? ((RdProjectDescriptor)rdProjectModelItemDescriptor).getDirectoryBased() : (rdProjectModelItemDescriptor instanceof RdUnloadProjectDescriptor ? ((RdUnloadProjectDescriptor)rdProjectModelItemDescriptor).getDirectoryBased() : (rdProjectModelItemDescriptor instanceof RdSolutionDescriptor ? ((RdSolutionDescriptor)rdProjectModelItemDescriptor).isVirtual() : false)))));
    }

    @Nullable
    public static final VirtualFile getVirtualFileAsContentRoot(@NotNull ProjectModelEntity $this$getVirtualFileAsContentRoot) {
        VirtualFile virtualFile2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getVirtualFileAsContentRoot, (String)"<this>");
        VirtualFileUrl virtualFileUrl = $this$getVirtualFileAsContentRoot.getUrl();
        if (virtualFileUrl == null || (virtualFileUrl = VirtualFileUrls.getVirtualFile((VirtualFileUrl)virtualFileUrl)) == null) {
            return null;
        }
        VirtualFileUrl virtualFileUrl2 = virtualFileUrl;
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = $this$getVirtualFileAsContentRoot.getDescriptor();
        if (rdProjectModelItemDescriptor instanceof RdProjectDescriptor && (object = ((RdProjectDescriptor)rdProjectModelItemDescriptor).getBaseDirectory()) != null) {
            return VfsUtil.findFileByIoFile((File)new File((String)object), (boolean)false);
        }
        object = ProjectModelEntityExtensionsKt.isDirectoryAwareEntity($this$getVirtualFileAsContentRoot);
        if (Intrinsics.areEqual((Object)object, (Object)true)) {
            virtualFile2 = virtualFileUrl2.getParent();
        } else if (Intrinsics.areEqual((Object)object, (Object)false)) {
            virtualFile2 = virtualFileUrl2;
        } else if (object == null) {
            virtualFile2 = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return virtualFile2;
    }

    @Nullable
    public static final VirtualFileUrl getContentRootUrl(@NotNull ProjectModelEntity $this$getContentRootUrl, @NotNull VirtualFileUrlManager manager) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getContentRootUrl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        VirtualFileUrl virtualFileUrl = $this$getContentRootUrl.getUrl();
        if (virtualFileUrl == null) {
            return null;
        }
        VirtualFileUrl virtualFileUrl2 = virtualFileUrl;
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = $this$getContentRootUrl.getDescriptor();
        if (rdProjectModelItemDescriptor instanceof RdSolutionDescriptor) {
            object = ((RdSolutionDescriptor)rdProjectModelItemDescriptor).isVirtual() ? virtualFileUrl2 : virtualFileUrl2.getParent();
        } else if (rdProjectModelItemDescriptor instanceof RdProjectDescriptor) {
            String string;
            String string2 = string = ((RdProjectDescriptor)rdProjectModelItemDescriptor).getBaseDirectory();
            object = string2 != null ? manager.getOrCreateFromUrl(string2) : (((RdProjectDescriptor)rdProjectModelItemDescriptor).getDirectoryBased() ? virtualFileUrl2 : virtualFileUrl2.getParent());
        } else {
            object = rdProjectModelItemDescriptor instanceof RdUnloadProjectDescriptor ? (((RdUnloadProjectDescriptor)rdProjectModelItemDescriptor).getDirectoryBased() ? virtualFileUrl2 : virtualFileUrl2.getParent()) : null;
        }
        return object;
    }

    @Nullable
    public static final Boolean isDirectoryAwareEntity(@NotNull ProjectModelEntity $this$isDirectoryAwareEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$isDirectoryAwareEntity, (String)"<this>");
        return ProjectModelNodeExtensionKt.isDirectoryAware($this$isDirectoryAwareEntity.getDescriptor());
    }

    @Nullable
    public static final VirtualFile getVirtualFileAsParent(@NotNull ProjectModelEntity $this$getVirtualFileAsParent) {
        Intrinsics.checkNotNullParameter((Object)$this$getVirtualFileAsParent, (String)"<this>");
        VirtualFile virtualFile2 = ProjectModelEntityExtensionsKt.getVirtualFileAsContentRoot($this$getVirtualFileAsParent);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile virtualFile3 = virtualFile2;
        if (virtualFile3.isDirectory()) {
            return virtualFile3;
        }
        return virtualFile3.getParent();
    }

    @NotNull
    public static final List<Path> getRootPaths(@NotNull Collection<? extends Path> $this$getRootPaths) {
        Intrinsics.checkNotNullParameter($this$getRootPaths, (String)"<this>");
        return ProjectModelEntityExtensionsKt.j($this$getRootPaths, getRootPaths.1.INSTANCE);
    }

    @NotNull
    public static final List<VirtualFile> getRootVirtualFiles(@NotNull Collection<? extends VirtualFile> $this$getRootVirtualFiles) {
        Intrinsics.checkNotNullParameter($this$getRootVirtualFiles, (String)"<this>");
        return ProjectModelEntityExtensionsKt.j($this$getRootVirtualFiles, getRootVirtualFiles.1.INSTANCE);
    }

    @NotNull
    public static final List<ProjectModelEntity> getRootEntities(@NotNull Collection<? extends ProjectModelEntity> $this$getRootEntities) {
        Intrinsics.checkNotNullParameter($this$getRootEntities, (String)"<this>");
        return ProjectModelEntityExtensionsKt.j($this$getRootEntities, getRootEntities.1.INSTANCE);
    }

    private static final <T> List<T> j(Collection<? extends T> collection, Function1<? super T, ? extends T> function1) {
        Object object;
        HashSet<T> hashSet = new HashSet<T>();
        HashSet hashSet2 = CollectionsKt.toHashSet((Iterable)collection);
        block0: for (T t10 : collection) {
            object = function1.invoke(t10);
            while (object != null) {
                if (hashSet2.contains(object)) {
                    hashSet.add(t10);
                    continue block0;
                }
                object = function1.invoke(object);
            }
        }
        Iterable iterable = collection;
        boolean bl = false;
        object = iterable;
        Collection collection2 = new ArrayList();
        boolean bl2 = false;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Object t11;
            Object t12 = t11 = iterator.next();
            boolean bl3 = false;
            if (hashSet.contains(t12)) continue;
            collection2.add(t11);
        }
        return (List)collection2;
    }

    @NotNull
    public static final HashSet<VirtualFile> getAffectedVirtualFiles(@NotNull ProjectModelEntity $this$getAffectedVirtualFiles) {
        Intrinsics.checkNotNullParameter((Object)$this$getAffectedVirtualFiles, (String)"<this>");
        VirtualFileUrl virtualFileUrl = $this$getAffectedVirtualFiles.getUrl();
        if (virtualFileUrl == null || (virtualFileUrl = VirtualFileUrls.getVirtualFile((VirtualFileUrl)virtualFileUrl)) == null) {
            return new HashSet<VirtualFile>();
        }
        VirtualFileUrl virtualFileUrl2 = virtualFileUrl;
        if (Intrinsics.areEqual((Object)ProjectModelEntityExtensionsKt.isDirectoryAwareEntity($this$getAffectedVirtualFiles), (Object)true)) {
            Object[] objectArray = new VirtualFile[2];
            objectArray[0] = virtualFileUrl2;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileUrl2.getParent(), (String)"getParent(...)");
            return SetsKt.hashSetOf((Object[])objectArray);
        }
        Object[] objectArray = new VirtualFile[]{virtualFileUrl2};
        return SetsKt.hashSetOf((Object[])objectArray);
    }

    public static final void fillAffectedVirtualFilesRecursive(@NotNull ProjectModelEntity $this$fillAffectedVirtualFilesRecursive, @NotNull HashSet<VirtualFile> set, boolean withInternalItems) {
        Intrinsics.checkNotNullParameter((Object)$this$fillAffectedVirtualFilesRecursive, (String)"<this>");
        Intrinsics.checkNotNullParameter(set, (String)"set");
        set.addAll((Collection<VirtualFile>)ProjectModelEntityExtensionsKt.getAffectedVirtualFiles($this$fillAffectedVirtualFilesRecursive));
        if (ProjectModelEntityExtensionsKt.isProjectFile($this$fillAffectedVirtualFilesRecursive)) {
            for (ProjectModelEntity projectModelEntity : $this$fillAffectedVirtualFilesRecursive.getChildrenEntities()) {
                ProjectModelEntityExtensionsKt.fillAffectedVirtualFilesRecursive(projectModelEntity, set, withInternalItems);
            }
        }
    }

    @Nullable
    public static final ProjectModelEntity findProjectModelEntity(@NotNull PsiDirectory $this$findProjectModelEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$findProjectModelEntity, (String)"<this>");
        Project project2 = $this$findProjectModelEntity.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project2);
        VirtualFile virtualFile2 = $this$findProjectModelEntity.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        Project project3 = $this$findProjectModelEntity.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        ProjectModelEntity projectModelEntity = (ProjectModelEntity)CollectionsKt.singleOrNull(WorkspaceModelExtensionsKt.getProjectModelEntities(workspaceModel, virtualFile2, project3));
        if (projectModelEntity != null && ProjectModelEntityExtensionsKt.isVirtualSolution(projectModelEntity)) {
            return null;
        }
        return projectModelEntity;
    }

    @NotNull
    public static final List<ProjectModelEntity> getProjectModelEntities(@NotNull DataContext $this$getProjectModelEntities, boolean takeNodeFromEditor) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)$this$getProjectModelEntities, (String)"<this>");
        Object[] objectArray2 = (ProjectModelEntity[])ProjectModelDataKeys.INSTANCE.getPROJECT_MODEL_ENTITY_ARRAY().getData($this$getProjectModelEntities);
        if (objectArray2 == null) {
            objectArray2 = new ProjectModelEntity[]{};
        }
        if ((objectArray = objectArray2).length == 0 && takeNodeFromEditor) {
            Integer n2;
            Project project2 = DataContextKt.getProject((DataContext)$this$getProjectModelEntities);
            if (project2 == null) {
                return CollectionsKt.emptyList();
            }
            Project project3 = project2;
            Editor editor = DataContextExKt.getEditor($this$getProjectModelEntities);
            Integer n3 = n2 = editor != null ? Integer.valueOf(TextControlUtilsKt.getProjectModelId(editor)) : null;
            if (n2 == null) {
                FileEditor fileEditor = (FileEditor)PlatformCoreDataKeys.FILE_EDITOR.getData($this$getProjectModelEntities);
                if (fileEditor == null) {
                    return CollectionsKt.emptyList();
                }
                FileEditor fileEditor2 = fileEditor;
                WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project3);
                VirtualFile virtualFile2 = fileEditor2.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
                return WorkspaceModelExtensionsKt.getProjectModelEntities(workspaceModel, virtualFile2, project3);
            }
            ProjectModelEntity projectModelEntity = WorkspaceModelExtensionsKt.getProjectModelEntity(WorkspaceModel.Companion.getInstance(project3), n2);
            if (projectModelEntity == null) {
                return CollectionsKt.emptyList();
            }
            ProjectModelEntity projectModelEntity2 = projectModelEntity;
            return CollectionsKt.listOf((Object)projectModelEntity2);
        }
        return ArraysKt.toList((Object[])objectArray);
    }

    public static /* synthetic */ List getProjectModelEntities$default(DataContext dataContext2, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        return ProjectModelEntityExtensionsKt.getProjectModelEntities(dataContext2, bl);
    }

    @Nullable
    public static final ProjectModelEntity getProjectModelEntity(@NotNull DataContext $this$getProjectModelEntity, boolean takeNodeFromEditor) {
        Intrinsics.checkNotNullParameter((Object)$this$getProjectModelEntity, (String)"<this>");
        return (ProjectModelEntity)CollectionsKt.singleOrNull(ProjectModelEntityExtensionsKt.getProjectModelEntities($this$getProjectModelEntity, takeNodeFromEditor));
    }

    public static /* synthetic */ ProjectModelEntity getProjectModelEntity$default(DataContext dataContext2, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        return ProjectModelEntityExtensionsKt.getProjectModelEntity(dataContext2, bl);
    }

    public static final boolean isFromSharedProject(@NotNull WorkspaceModel $this$isFromSharedProject, int id) {
        Intrinsics.checkNotNullParameter((Object)$this$isFromSharedProject, (String)"<this>");
        ProjectModelEntity projectModelEntity = WorkspaceModelExtensionsKt.getProjectModelEntity($this$isFromSharedProject, id);
        return projectModelEntity != null ? ProjectModelEntityExtensionsKt.isFromSharedProject(projectModelEntity) : false;
    }

    public static final boolean isFromSharedProject(@NotNull ProjectModelEntity $this$isFromSharedProject) {
        Intrinsics.checkNotNullParameter((Object)$this$isFromSharedProject, (String)"<this>");
        Object object = ProjectModelEntityExtensionsKt.containingProjectEntity($this$isFromSharedProject);
        return object != null && (object = object.getUrl()) != null && (object = VirtualFileUrls.getVirtualFile((VirtualFileUrl)object)) != null && (object = object.getExtension()) != null ? StringsKt.equals((String)object, (String)"shproj", (boolean)true) : false;
    }

    public static final boolean isFromVcxProject(@NotNull ProjectModelEntity $this$isFromVcxProject) {
        Intrinsics.checkNotNullParameter((Object)$this$isFromVcxProject, (String)"<this>");
        Object object = ProjectModelEntityExtensionsKt.containingProjectEntity($this$isFromVcxProject);
        return object != null && (object = object.getUrl()) != null && (object = VirtualFileUrls.getVirtualFile((VirtualFileUrl)object)) != null && (object = object.getExtension()) != null ? StringsKt.equals((String)object, (String)"vcxproj", (boolean)true) : false;
    }

    public static final boolean isLinkedProjectFile(@NotNull ProjectModelEntity $this$isLinkedProjectFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isLinkedProjectFile, (String)"<this>");
        return ProjectModelEntityExtensionsKt.isProjectFile($this$isLinkedProjectFile) && ProjectModelEntityExtensionsKt.j($this$isLinkedProjectFile);
    }

    public static final boolean isLinkedProjectFolder(@NotNull ProjectModelEntity $this$isLinkedProjectFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isLinkedProjectFolder, (String)"<this>");
        return ProjectModelEntityExtensionsKt.isProjectFolder($this$isLinkedProjectFolder) && ProjectModelEntityExtensionsKt.j($this$isLinkedProjectFolder);
    }

    private static final boolean j(ProjectModelEntity projectModelEntity) {
        return projectModelEntity.getDescriptor().getLocation() instanceof RdCustomLocation;
    }

    @NotNull
    public static final Map<ProjectModelEntity, String> withUniqueNames(@NotNull List<? extends ProjectModelEntity> $this$withUniqueNames, @NotNull Project project2) {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Intrinsics.checkNotNullParameter($this$withUniqueNames, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        HashMap hashMap = new HashMap();
        for (ProjectModelEntity object6 : $this$withUniqueNames) {
            Object object5;
            object4 = hashMap;
            String string = object6.getName();
            boolean bl2 = false;
            object3 = object4.get(string);
            if (object3 == null) {
                boolean bl3 = false;
                object2 = new ArrayList();
                object4.put(string, object2);
                object5 = object2;
            } else {
                object5 = object3;
            }
            object = (List)object5;
            object.add(new ListNodeData(object6, object6));
        }
        do {
            bl = false;
            HashSet<String> hashSet = new HashSet<String>();
            object = new HashMap();
            for (Map.Entry entry2 : ((Map)hashMap).entrySet()) {
                String string = (String)entry2.getKey();
                object3 = (List)entry2.getValue();
                if (((Collection)object3).size() == 1) continue;
                bl = true;
                hashSet.add(string);
                for (ListNodeData listNodeData : object3) {
                    Object object6;
                    Object object7;
                    ProjectModelEntity projectModelEntity = listNodeData.component1();
                    ProjectModelEntity projectModelEntity2 = listNodeData.component2();
                    ProjectModelEntity projectModelEntity3 = projectModelEntity.getParentEntity();
                    if (projectModelEntity3 != null) {
                        object7 = projectModelEntity3.getName() + "/" + string;
                    } else {
                        object7 = ProjectModelEntityExtensionsKt.getId(projectModelEntity2, project2);
                        if (object7 == null || (object7 = ((Integer)object7).toString()) == null) {
                            object7 = "NULL/" + string;
                        }
                    }
                    Object object8 = object7;
                    Map map = (Map)object;
                    boolean bl4 = false;
                    Object v10 = map.get(object8);
                    if (v10 == null) {
                        boolean bl5 = false;
                        List list = new ArrayList();
                        map.put(object8, list);
                        object6 = list;
                    } else {
                        object6 = v10;
                    }
                    List list = (List)object6;
                    ProjectModelEntity projectModelEntity4 = projectModelEntity3;
                    if (projectModelEntity4 == null) {
                        projectModelEntity4 = projectModelEntity;
                    }
                    list.add(new ListNodeData(projectModelEntity4, projectModelEntity2));
                }
            }
            for (String string : hashSet) {
                hashMap.remove(string);
            }
            hashMap.putAll((Map)object);
        } while (bl);
        Map map = hashMap;
        boolean bl6 = false;
        object = map;
        object4 = new ArrayList(map.size());
        boolean bl7 = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            object2 = object3 = iterator.next();
            Object object9 = object4;
            boolean bl8 = false;
            object9.add(new Pair((Object)((ListNodeData)CollectionsKt.single((List)((List)object2.getValue()))).getOriginal(), object2.getKey()));
        }
        return MapsKt.toMap((Iterable)((List)object4));
    }

    public static final boolean isSolution(@NotNull ProjectModelEntity $this$isSolution) {
        Intrinsics.checkNotNullParameter((Object)$this$isSolution, (String)"<this>");
        return $this$isSolution.getDescriptor() instanceof RdSolutionDescriptor;
    }

    public static final boolean isExistingSolution(@NotNull ProjectModelEntity $this$isExistingSolution) {
        Intrinsics.checkNotNullParameter((Object)$this$isExistingSolution, (String)"<this>");
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = $this$isExistingSolution.getDescriptor();
        boolean bl = false;
        return rdProjectModelItemDescriptor instanceof RdSolutionDescriptor && !((RdSolutionDescriptor)rdProjectModelItemDescriptor).isVirtual();
    }

    public static final boolean isVirtualSolution(@NotNull ProjectModelEntity $this$isVirtualSolution) {
        Intrinsics.checkNotNullParameter((Object)$this$isVirtualSolution, (String)"<this>");
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = $this$isVirtualSolution.getDescriptor();
        boolean bl = false;
        return rdProjectModelItemDescriptor instanceof RdSolutionDescriptor && ((RdSolutionDescriptor)rdProjectModelItemDescriptor).isVirtual();
    }

    public static final boolean isSolutionFolder(@NotNull ProjectModelEntity $this$isSolutionFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isSolutionFolder, (String)"<this>");
        return $this$isSolutionFolder.getDescriptor() instanceof RdSolutionFolderDescriptor;
    }

    public static final boolean isProject(@NotNull ProjectModelEntity $this$isProject) {
        Intrinsics.checkNotNullParameter((Object)$this$isProject, (String)"<this>");
        return $this$isProject.getDescriptor() instanceof RdProjectDescriptor;
    }

    public static final boolean isUnloadedProject(@NotNull ProjectModelEntity $this$isUnloadedProject) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnloadedProject, (String)"<this>");
        return $this$isUnloadedProject.getDescriptor() instanceof RdUnloadProjectDescriptor;
    }

    public static final boolean isFilteredProject(@NotNull ProjectModelEntity $this$isFilteredProject) {
        Intrinsics.checkNotNullParameter((Object)$this$isFilteredProject, (String)"<this>");
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = $this$isFilteredProject.getDescriptor();
        boolean bl = false;
        return rdProjectModelItemDescriptor instanceof RdUnloadProjectDescriptor && ((RdUnloadProjectDescriptor)rdProjectModelItemDescriptor).getState() == RdUnloadProjectState.Filtered;
    }

    public static final boolean isProjectFile(@NotNull ProjectModelEntity $this$isProjectFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isProjectFile, (String)"<this>");
        return $this$isProjectFile.getDescriptor() instanceof RdProjectFileDescriptor;
    }

    public static final boolean isProjectFolder(@NotNull ProjectModelEntity $this$isProjectFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isProjectFolder, (String)"<this>");
        return $this$isProjectFolder.getDescriptor() instanceof RdProjectFolderDescriptor;
    }

    public static final boolean isProjectReference(@NotNull ProjectModelEntity $this$isProjectReference) {
        Intrinsics.checkNotNullParameter((Object)$this$isProjectReference, (String)"<this>");
        return $this$isProjectReference.getDescriptor() instanceof RdProjectReferenceDescriptor;
    }

    public static final boolean isAssemblyReference(@NotNull ProjectModelEntity $this$isAssemblyReference) {
        Intrinsics.checkNotNullParameter((Object)$this$isAssemblyReference, (String)"<this>");
        return $this$isAssemblyReference.getDescriptor() instanceof RdAssemblyReferenceDescriptor;
    }

    public static final boolean isReference(@NotNull ProjectModelEntity $this$isReference) {
        Intrinsics.checkNotNullParameter((Object)$this$isReference, (String)"<this>");
        return ProjectModelEntityExtensionsKt.isProjectReference($this$isReference) || ProjectModelEntityExtensionsKt.isAssemblyReference($this$isReference);
    }

    public static final boolean isWebReference(@NotNull ProjectModelEntity $this$isWebReference) {
        Intrinsics.checkNotNullParameter((Object)$this$isWebReference, (String)"<this>");
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = $this$isWebReference.getDescriptor();
        boolean bl = false;
        return rdProjectModelItemDescriptor instanceof RdWebReferenceDescriptor && ((RdWebReferenceDescriptor)rdProjectModelItemDescriptor).getType() == RdWebReferenceDescriptorType.Reference;
    }

    public static final boolean isWebReferenceItem(@NotNull ProjectModelEntity $this$isWebReferenceItem) {
        Intrinsics.checkNotNullParameter((Object)$this$isWebReferenceItem, (String)"<this>");
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = $this$isWebReferenceItem.getDescriptor();
        boolean bl = false;
        return rdProjectModelItemDescriptor instanceof RdWebReferenceDescriptor && ((RdWebReferenceDescriptor)rdProjectModelItemDescriptor).getType() != RdWebReferenceDescriptorType.Reference;
    }

    public static final boolean isUnresolvedReference(@NotNull ProjectModelEntity $this$isUnresolvedReference) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnresolvedReference, (String)"<this>");
        return $this$isUnresolvedReference.getDescriptor() instanceof RdUnresolvedReferenceDescriptor;
    }

    public static final boolean isAnalyzerReference(@NotNull ProjectModelEntity $this$isAnalyzerReference) {
        Intrinsics.checkNotNullParameter((Object)$this$isAnalyzerReference, (String)"<this>");
        return $this$isAnalyzerReference.getDescriptor() instanceof RdAnalyzerReferenceDescriptor;
    }

    public static final boolean isImportFolder(@NotNull ProjectModelEntity $this$isImportFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isImportFolder, (String)"<this>");
        return $this$isImportFolder.getDescriptor() instanceof RdImportFolderDescriptor;
    }

    public static final boolean isImportItem(@NotNull ProjectModelEntity $this$isImportItem) {
        Intrinsics.checkNotNullParameter((Object)$this$isImportItem, (String)"<this>");
        return $this$isImportItem.getDescriptor() instanceof RdImportDescriptor;
    }

    public static final boolean isSourceGeneratorFolder(@NotNull ProjectModelEntity $this$isSourceGeneratorFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isSourceGeneratorFolder, (String)"<this>");
        return $this$isSourceGeneratorFolder.getDescriptor() instanceof RdSourceGeneratorFolderDescriptor;
    }

    public static final boolean isSourceGeneratorFile(@NotNull ProjectModelEntity $this$isSourceGeneratorFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isSourceGeneratorFile, (String)"<this>");
        return $this$isSourceGeneratorFile.getDescriptor() instanceof RdSourceGeneratorFileDescriptor;
    }

    public static final boolean isTargetFrameworkFolder(@NotNull ProjectModelEntity $this$isTargetFrameworkFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isTargetFrameworkFolder, (String)"<this>");
        return $this$isTargetFrameworkFolder.getDescriptor() instanceof RdTargetFrameworkFolderDescriptor;
    }

    public static final boolean isRoslynAnalyzerDiagnostic(@NotNull ProjectModelEntity $this$isRoslynAnalyzerDiagnostic) {
        Intrinsics.checkNotNullParameter((Object)$this$isRoslynAnalyzerDiagnostic, (String)"<this>");
        return ProjectModelEntityExtensionsKt.asRoslynAnalyzerDiagnostic($this$isRoslynAnalyzerDiagnostic) != null;
    }

    @Nullable
    public static final RdRoslynAnalyzerDiagnosticDescriptor asRoslynAnalyzerDiagnostic(@NotNull ProjectModelEntity $this$asRoslynAnalyzerDiagnostic) {
        Intrinsics.checkNotNullParameter((Object)$this$asRoslynAnalyzerDiagnostic, (String)"<this>");
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = $this$asRoslynAnalyzerDiagnostic.getDescriptor();
        boolean bl = false;
        return rdProjectModelItemDescriptor instanceof RdRoslynAnalyzerDiagnosticDescriptor ? (RdRoslynAnalyzerDiagnosticDescriptor)rdProjectModelItemDescriptor : null;
    }

    public static final boolean isDependency(@NotNull ProjectModelEntity $this$isDependency) {
        Intrinsics.checkNotNullParameter((Object)$this$isDependency, (String)"<this>");
        return $this$isDependency.getDescriptor() instanceof RdDependencyDescriptor;
    }

    public static final boolean isDependencyReference(@NotNull ProjectModelEntity $this$isDependencyReference) {
        Intrinsics.checkNotNullParameter((Object)$this$isDependencyReference, (String)"<this>");
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = $this$isDependencyReference.getDescriptor();
        boolean bl = false;
        return rdProjectModelItemDescriptor instanceof RdDependencyDescriptor && ((RdDependencyDescriptor)rdProjectModelItemDescriptor).getType() == RdDependencyType.Reference;
    }

    public static final boolean isDependencyPackage(@NotNull ProjectModelEntity $this$isDependencyPackage) {
        Intrinsics.checkNotNullParameter((Object)$this$isDependencyPackage, (String)"<this>");
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = $this$isDependencyPackage.getDescriptor();
        boolean bl = false;
        return rdProjectModelItemDescriptor instanceof RdDependencyDescriptor && ((RdDependencyDescriptor)rdProjectModelItemDescriptor).getType() == RdDependencyType.Package;
    }

    public static final boolean isDependencyProjectReference(@NotNull ProjectModelEntity $this$isDependencyProjectReference) {
        Intrinsics.checkNotNullParameter((Object)$this$isDependencyProjectReference, (String)"<this>");
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = $this$isDependencyProjectReference.getDescriptor();
        boolean bl = false;
        return rdProjectModelItemDescriptor instanceof RdDependencyDescriptor && ((RdDependencyDescriptor)rdProjectModelItemDescriptor).getType() == RdDependencyType.Project;
    }

    public static final boolean isAnyDependencyFolder(@NotNull ProjectModelEntity $this$isAnyDependencyFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isAnyDependencyFolder, (String)"<this>");
        return $this$isAnyDependencyFolder.getDescriptor() instanceof RdDependencyFolderDescriptor;
    }

    public static final boolean isDependenciesFolder(@NotNull ProjectModelEntity $this$isDependenciesFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isDependenciesFolder, (String)"<this>");
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = $this$isDependenciesFolder.getDescriptor();
        boolean bl = false;
        return rdProjectModelItemDescriptor instanceof RdDependencyFolderDescriptor && ((RdDependencyFolderDescriptor)rdProjectModelItemDescriptor).getType() == RdDependencyFolderDescriptorType.Dependencies;
    }

    public static final boolean isWebReferenceFolder(@NotNull ProjectModelEntity $this$isWebReferenceFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isWebReferenceFolder, (String)"<this>");
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = $this$isWebReferenceFolder.getDescriptor();
        boolean bl = false;
        return rdProjectModelItemDescriptor instanceof RdDependencyFolderDescriptor && ((RdDependencyFolderDescriptor)rdProjectModelItemDescriptor).getType() == RdDependencyFolderDescriptorType.WebReference;
    }

    public static final boolean isFrameworkReferencesFolder(@NotNull ProjectModelEntity $this$isFrameworkReferencesFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isFrameworkReferencesFolder, (String)"<this>");
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = $this$isFrameworkReferencesFolder.getDescriptor();
        boolean bl = false;
        return rdProjectModelItemDescriptor instanceof RdDependencyFolderDescriptor && ((RdDependencyFolderDescriptor)rdProjectModelItemDescriptor).getType() == RdDependencyFolderDescriptorType.FrameworkReferences;
    }

    public static final boolean isAssembliesFolder(@NotNull ProjectModelEntity $this$isAssembliesFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isAssembliesFolder, (String)"<this>");
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = $this$isAssembliesFolder.getDescriptor();
        boolean bl = false;
        return rdProjectModelItemDescriptor instanceof RdDependencyFolderDescriptor && ((RdDependencyFolderDescriptor)rdProjectModelItemDescriptor).getType() == RdDependencyFolderDescriptorType.Assemblies;
    }

    public static final boolean isImplicitAssembliesFolder(@NotNull ProjectModelEntity $this$isImplicitAssembliesFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isImplicitAssembliesFolder, (String)"<this>");
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = $this$isImplicitAssembliesFolder.getDescriptor();
        boolean bl = false;
        return rdProjectModelItemDescriptor instanceof RdDependencyFolderDescriptor && ((RdDependencyFolderDescriptor)rdProjectModelItemDescriptor).getType() == RdDependencyFolderDescriptorType.ImplicitAssemblies;
    }

    public static final boolean isProjectsFolder(@NotNull ProjectModelEntity $this$isProjectsFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isProjectsFolder, (String)"<this>");
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = $this$isProjectsFolder.getDescriptor();
        boolean bl = false;
        return rdProjectModelItemDescriptor instanceof RdDependencyFolderDescriptor && ((RdDependencyFolderDescriptor)rdProjectModelItemDescriptor).getType() == RdDependencyFolderDescriptorType.Projects;
    }

    public static final boolean isSDKFolder(@NotNull ProjectModelEntity $this$isSDKFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isSDKFolder, (String)"<this>");
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = $this$isSDKFolder.getDescriptor();
        boolean bl = false;
        return rdProjectModelItemDescriptor instanceof RdDependencyFolderDescriptor && ((RdDependencyFolderDescriptor)rdProjectModelItemDescriptor).getType() == RdDependencyFolderDescriptorType.SDK;
    }

    public static final boolean isAnalyzersFolder(@NotNull ProjectModelEntity $this$isAnalyzersFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isAnalyzersFolder, (String)"<this>");
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = $this$isAnalyzersFolder.getDescriptor();
        boolean bl = false;
        return rdProjectModelItemDescriptor instanceof RdDependencyFolderDescriptor && ((RdDependencyFolderDescriptor)rdProjectModelItemDescriptor).getType() == RdDependencyFolderDescriptorType.Analyzers;
    }

    public static final boolean isSourceGeneratorsFolder(@NotNull ProjectModelEntity $this$isSourceGeneratorsFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isSourceGeneratorsFolder, (String)"<this>");
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = $this$isSourceGeneratorsFolder.getDescriptor();
        boolean bl = false;
        return rdProjectModelItemDescriptor instanceof RdDependencyFolderDescriptor && ((RdDependencyFolderDescriptor)rdProjectModelItemDescriptor).getType() == RdDependencyFolderDescriptorType.SourceGenerator;
    }

    public static final boolean isPackagesFolder(@NotNull ProjectModelEntity $this$isPackagesFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isPackagesFolder, (String)"<this>");
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = $this$isPackagesFolder.getDescriptor();
        boolean bl = false;
        return rdProjectModelItemDescriptor instanceof RdDependencyFolderDescriptor && ((RdDependencyFolderDescriptor)rdProjectModelItemDescriptor).getType() == RdDependencyFolderDescriptorType.Packages;
    }

    public static final boolean isXcAssetsFolder(@NotNull ProjectModelEntity $this$isXcAssetsFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isXcAssetsFolder, (String)"<this>");
        if (!ProjectModelEntityExtensionsKt.isProjectFolder($this$isXcAssetsFolder)) {
            return false;
        }
        if (!StringsKt.endsWith((String)$this$isXcAssetsFolder.getName(), (String)".xcassets", (boolean)true)) {
            return false;
        }
        ProjectModelEntity projectModelEntity = ProjectModelEntityExtensionsKt.containingProjectEntity($this$isXcAssetsFolder);
        if (projectModelEntity == null) {
            return false;
        }
        ProjectModelEntity projectModelEntity2 = projectModelEntity;
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = projectModelEntity2.getDescriptor();
        if (rdProjectModelItemDescriptor instanceof RdProjectDescriptor) {
            return ((RdProjectDescriptor)rdProjectModelItemDescriptor).getSpecificType() == RdProjectType.Macios;
        }
        return false;
    }

    public static final boolean isXcAssetItemFolder(@NotNull ProjectModelEntity $this$isXcAssetItemFolder) {
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)$this$isXcAssetItemFolder, (String)"<this>");
                if (!ProjectModelEntityExtensionsKt.isProjectFolder($this$isXcAssetItemFolder)) break block3;
                ProjectModelEntity projectModelEntity = $this$isXcAssetItemFolder.getParentEntity();
                if (projectModelEntity != null ? ProjectModelEntityExtensionsKt.isXcAssetsFolder(projectModelEntity) : false) break block4;
            }
            return false;
        }
        String string = StringsKt.substringAfterLast((String)$this$isXcAssetItemFolder.getName(), (String)".", (String)"");
        return StringsKt.equals((String)string, (String)"appiconset", (boolean)true) || StringsKt.equals((String)string, (String)"colorset", (boolean)true) || StringsKt.equals((String)string, (String)"imageset", (boolean)true);
    }

    public static final boolean isHiddenInSolutionFilter(@NotNull ProjectModelEntity $this$isHiddenInSolutionFilter) {
        Intrinsics.checkNotNullParameter((Object)$this$isHiddenInSolutionFilter, (String)"<this>");
        if (ProjectModelEntityExtensionsKt.isSolutionFolder($this$isHiddenInSolutionFilter)) {
            boolean bl;
            block5: {
                List list = CollectionsKt.toList((Iterable)$this$isHiddenInSolutionFilter.getChildrenEntities());
                if (list.isEmpty()) {
                    return false;
                }
                Iterable iterable = list;
                boolean bl2 = false;
                if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                    bl = true;
                } else {
                    for (Object t10 : iterable) {
                        ProjectModelEntity projectModelEntity = (ProjectModelEntity)t10;
                        boolean bl3 = false;
                        if (ProjectModelEntityExtensionsKt.isHiddenInSolutionFilter(projectModelEntity)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            return bl;
        }
        return ProjectModelEntityExtensionsKt.isFilteredProject($this$isHiddenInSolutionFilter);
    }
}

