/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.solutionStructure.definitions;

import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.util.text.CharSequenceReader;
import com.jetbrains.rider.projectView.solutionStructure.definitions.DefinitionItem;
import com.jetbrains.rider.projectView.solutionStructure.definitions.GlobalDefinition;
import com.jetbrains.rider.projectView.solutionStructure.definitions.LineDefinition;
import com.jetbrains.rider.projectView.solutionStructure.definitions.PropertyDefinition;
import com.jetbrains.rider.projectView.solutionStructure.definitions.RegularProjectDefinition;
import com.jetbrains.rider.projectView.solutionStructure.definitions.SectionDefinition;
import com.jetbrains.rider.projectView.solutionStructure.definitions.SectionDefinitionType;
import com.jetbrains.rider.projectView.solutionStructure.definitions.SolutionFolderDefinition;
import com.jetbrains.rider.utils.UUIDUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J2\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0019\u001a\u00020\u000e2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u000eH\u0002J\u0006\u0010\u001b\u001a\u00020\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u000eH\u0002J\u001e\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/projectView/solutionStructure/definitions/SolutionDefinitionReader;", "", "location", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "globalMatcher", "Lkotlin/text/Regex;", "headerMatcher", "items", "", "Lcom/jetbrains/rider/projectView/solutionStructure/definitions/DefinitionItem;", "getItems", "()Ljava/util/List;", "lineForRollback", "", "projectMatcher", "propertyMatcher", "sectionMatcher", "j", "reader", "Ljava/io/BufferedReader;", "j", "", "name", "j", "owner", "nextOwner", "read", "j", "line", "j", "intellij.rider.rdclient.dotnet"})
public final class SolutionDefinitionReader {
    @NotNull
    private final Path location;
    @NotNull
    private final Regex headerMatcher;
    @NotNull
    private final Regex projectMatcher;
    @NotNull
    private final Regex globalMatcher;
    @NotNull
    private final Regex sectionMatcher;
    @NotNull
    private final Regex propertyMatcher;
    @Nullable
    private String lineForRollback;
    @NotNull
    private final List<DefinitionItem> items;

    public SolutionDefinitionReader(@NotNull Path location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.location = location;
        this.headerMatcher = new Regex("Microsoft Visual Studio Solution File, Format Version (?<formatVersion>\\d+\\.\\d+)");
        this.projectMatcher = new Regex("Project\\(\"(?<package>\\{.*?\\})\".*?\"(?<name>.*?)\".*?\"(?<project>.*?)\".*?\"(?<guid>.*?)\"");
        this.globalMatcher = new Regex("Global");
        this.sectionMatcher = new Regex("(?<type>Project|Global)Section\\((?<name>[^)]*)\\)\\s*=\\s*(?<value>.*)");
        this.propertyMatcher = new Regex("^(?<name>[^=]+?)\\s*=\\s*(?<value>.*)$");
        this.items = new ArrayList();
    }

    @NotNull
    public final List<DefinitionItem> getItems() {
        return this.items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void read() {
        this.items.clear();
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(this.location, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return;
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.isRegularFile(this.location, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            return;
        }
        byte[] byArray = Files.readAllBytes(this.location);
        CharSequence charSequence = LoadTextUtil.getTextByBinaryPresentation((byte[])byArray, (Charset)Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getTextByBinaryPresentation(...)");
        CharSequence charSequence2 = charSequence;
        Closeable closeable = new BufferedReader((Reader)new CharSequenceReader(charSequence2));
        Throwable throwable = null;
        try {
            BufferedReader bufferedReader = (BufferedReader)closeable;
            boolean bl = false;
            this.j(bufferedReader, this.items);
            while (true) {
                List list;
                List list2;
                String string;
                if (this.j(bufferedReader, this.items) == null) {
                    return;
                }
                String string2 = string;
                MatchResult matchResult = this.projectMatcher.matchEntire((CharSequence)string2);
                if (matchResult != null) {
                    list2 = new ArrayList();
                    this.j(bufferedReader, list2, "Project", "Global");
                    list = matchResult.getDestructured();
                    String string3 = (String)list.getMatch().getGroupValues().get(1);
                    String string4 = (String)list.getMatch().getGroupValues().get(2);
                    String string5 = (String)list.getMatch().getGroupValues().get(3);
                    String string6 = (String)list.getMatch().getGroupValues().get(4);
                    UUID uUID = UUIDUtils.INSTANCE.parseCurlyBracketsValue(string6);
                    UUID uUID2 = UUIDUtils.INSTANCE.parseCurlyBracketsValue(string3);
                    if (Intrinsics.areEqual((Object)uUID2, (Object)SolutionFolderDefinition.Companion.getTypeGuid())) {
                        this.items.add(new SolutionFolderDefinition(string4, string5, uUID, list2));
                        continue;
                    }
                    this.items.add(new RegularProjectDefinition(string4, string5, uUID, uUID2, list2));
                    continue;
                }
                list2 = this.globalMatcher.matchEntire((CharSequence)string2);
                if (list2 != null) {
                    list = new ArrayList();
                    SolutionDefinitionReader.parseSectionOwner$default(this, bufferedReader, list, "Global", null, 8, null);
                    this.items.add(new GlobalDefinition(list));
                    continue;
                }
                list = this.propertyMatcher.matchEntire((CharSequence)string2);
                if (list != null) {
                    this.items.add(new LineDefinition(string2));
                }
                this.items.add(new LineDefinition(string2));
                continue;
                break;
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void j(BufferedReader bufferedReader, List<DefinitionItem> list, String string, String string2) {
        while (this.j(bufferedReader, list) != null) {
            String string3;
            String string4 = "End" + string;
            if (StringsKt.equals((String)string3, (String)string4, (boolean)true)) {
                return;
            }
            MatchResult matchResult = this.sectionMatcher.matchEntire((CharSequence)string3);
            if (matchResult != null) {
                List list2 = new ArrayList();
                MatchResult.Destructured destructured = matchResult.getDestructured();
                String string5 = (String)destructured.getMatch().getGroupValues().get(1);
                String string6 = (String)destructured.getMatch().getGroupValues().get(2);
                String string7 = (String)destructured.getMatch().getGroupValues().get(3);
                this.j(bufferedReader, list2, string5);
                SectionDefinitionType sectionDefinitionType = SectionDefinitionType.valueOf(string5);
                list.add(new SectionDefinition(string6, string7, sectionDefinitionType, list2));
                continue;
            }
            if (StringsKt.startsWith((String)string3, (String)string4, (boolean)true)) {
                this.j(StringsKt.removePrefix((String)string3, (CharSequence)string4));
                return;
            }
            if (StringsKt.startsWith((String)string3, (String)string, (boolean)true) || string2 != null && StringsKt.startsWith((String)string3, (String)string2, (boolean)true)) {
                this.j(string3);
                return;
            }
            list.add(new LineDefinition(string3));
        }
        return;
    }

    static /* synthetic */ void parseSectionOwner$default(SolutionDefinitionReader solutionDefinitionReader, BufferedReader bufferedReader, List list, String string, String string2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            string2 = null;
        }
        solutionDefinitionReader.j(bufferedReader, list, string, string2);
    }

    private final void j(BufferedReader bufferedReader, List<DefinitionItem> list, String string) {
        String string2 = string + "Section";
        String string3 = "End" + string2;
        String string4 = "End" + string;
        while (this.j(bufferedReader, list) != null) {
            String string5;
            if (StringsKt.equals((String)string5, (String)string3, (boolean)true)) {
                return;
            }
            MatchResult matchResult = this.propertyMatcher.matchEntire((CharSequence)string5);
            if (matchResult != null) {
                MatchResult.Destructured destructured = matchResult.getDestructured();
                String string6 = (String)destructured.getMatch().getGroupValues().get(1);
                String string7 = (String)destructured.getMatch().getGroupValues().get(2);
                list.add(new PropertyDefinition(string6, string7));
                continue;
            }
            if (StringsKt.startsWith((String)string5, (String)string3, (boolean)true)) {
                this.j(StringsKt.removePrefix((String)string5, (CharSequence)string3));
                return;
            }
            if (StringsKt.startsWith((String)string5, (String)string2, (boolean)true) || StringsKt.startsWith((String)string5, (String)string4, (boolean)true)) {
                this.j(string5);
                return;
            }
            list.add(new LineDefinition(string5));
        }
        return;
    }

    private final void j(BufferedReader bufferedReader, List<DefinitionItem> list) {
        String string = this.j(bufferedReader, list);
        if (string == null) {
            return;
        }
        String string2 = string;
        MatchResult matchResult = this.headerMatcher.matchEntire((CharSequence)string2);
        if (matchResult != null) {
            list.add(new LineDefinition(string2));
            return;
        }
        this.j(string2);
    }

    private final String j(BufferedReader bufferedReader, List<DefinitionItem> list) {
        String string;
        String string2 = this.lineForRollback;
        if (string2 != null) {
            this.lineForRollback = null;
            return string2;
        }
        while (true) {
            String string3;
            if ((string3 = bufferedReader.readLine()) == null || (string3 = ((Object)StringsKt.trim((CharSequence)string3)).toString()) == null) {
                return null;
            }
            string = string3;
            if (!(((CharSequence)string).length() == 0) && !StringsKt.startsWith$default((String)string, (String)"#", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)string, (String)">>>>>>>", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)string, (String)"<<<<<<<", (boolean)false, (int)2, null)) break;
            list.add(new LineDefinition(string));
        }
        return string;
    }

    private final void j(String string) {
        this.lineForRollback = string;
    }
}

