/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.nuget;

import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rider.model.RdNuGetFeed;
import com.jetbrains.rider.model.RdNuGetImplicitPackageIdentity;
import com.jetbrains.rider.model.RdNuGetImplicitVersion;
import com.jetbrains.rider.model.RdNuGetLogLevel;
import com.jetbrains.rider.model.RdNuGetLogMessage;
import com.jetbrains.rider.model.RdNuGetPackageIdentity;
import com.jetbrains.rider.model.RdNuGetSmartMetadata;
import com.jetbrains.rider.model.RdNuGetStateInfo;
import com.jetbrains.rider.nuget.RiderNuGetExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0017\u001a\u00020\u0018*\u00020\u0019\u001a\n\u0010\u001a\u001a\u00020\u0005*\u00020\u001b\"2\u0010\u0000\u001a&\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u0002 \u0003*\u0012\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u0002\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u001b\u0010\t\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0015\u0010\u000e\u001a\u00020\u000f*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0011\"\u0015\u0010\u0012\u001a\u00020\u000f*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u0015\u0010\u0014\u001a\u00020\u000f*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\"\u0015\u0010\u0016\u001a\u00020\u000f*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0011\u00a8\u0006\u001c"}, d2={"RdNuGetLogLevelErrors", "Ljava/util/EnumSet;", "Lcom/jetbrains/rider/model/RdNuGetLogLevel;", "kotlin.jvm.PlatformType", "fullText", "", "Lcom/jetbrains/rider/model/RdNuGetLogMessage;", "getFullText", "(Lcom/jetbrains/rider/model/RdNuGetLogMessage;)Ljava/lang/String;", "hashString", "", "Lcom/jetbrains/rider/model/RdNuGetFeed;", "getHashString", "(Ljava/util/List;)Ljava/lang/String;", "isAvailable", "", "Lcom/jetbrains/rider/model/RdNuGetSmartMetadata;", "(Lcom/jetbrains/rider/model/RdNuGetSmartMetadata;)Z", "isEmpty", "(Lcom/jetbrains/rider/model/RdNuGetLogMessage;)Z", "isError", "(Lcom/jetbrains/rider/model/RdNuGetLogLevel;)Z", "isInstalled", "toImplicitVersion", "Lcom/jetbrains/rider/model/RdNuGetImplicitVersion;", "Lcom/jetbrains/rider/model/RdNuGetImplicitPackageIdentity;", "toUserString", "Lcom/jetbrains/rider/model/RdNuGetStateInfo;", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderNuGetExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderNuGetExtensions.kt\ncom/jetbrains/rider/nuget/RiderNuGetExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n1549#2:42\n1620#2,3:43\n*S KotlinDebug\n*F\n+ 1 RiderNuGetExtensions.kt\ncom/jetbrains/rider/nuget/RiderNuGetExtensionsKt\n*L\n41#1:42\n41#1:43,3\n*E\n"})
public final class RiderNuGetExtensionsKt {
    private static final EnumSet<RdNuGetLogLevel> RdNuGetLogLevelErrors = EnumSet.of((Enum)RdNuGetLogLevel.Error, (Enum)RdNuGetLogLevel.Warning);

    @NotNull
    public static final String getFullText(@NotNull RdNuGetLogMessage $this$fullText) {
        Intrinsics.checkNotNullParameter((Object)$this$fullText, (String)"<this>");
        String string = $this$fullText.getLevel().toString().toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return string + ": " + ((Object)StringsKt.trim((CharSequence)$this$fullText.getText())).toString();
    }

    public static final boolean isEmpty(@NotNull RdNuGetLogMessage $this$isEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isEmpty, (String)"<this>");
        return StringsKt.isBlank((CharSequence)$this$isEmpty.getText());
    }

    public static final boolean isError(@NotNull RdNuGetLogLevel $this$isError) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$isError), (String)"<this>");
        return RdNuGetLogLevelErrors.contains((Object)$this$isError);
    }

    public static final boolean isInstalled(@NotNull RdNuGetSmartMetadata $this$isInstalled) {
        Intrinsics.checkNotNullParameter((Object)$this$isInstalled, (String)"<this>");
        return CollectionsKt.any((Iterable)$this$isInstalled.getInstalledVersions());
    }

    public static final boolean isAvailable(@NotNull RdNuGetSmartMetadata $this$isAvailable) {
        Intrinsics.checkNotNullParameter((Object)$this$isAvailable, (String)"<this>");
        return $this$isAvailable.getInstalledVersions().isEmpty();
    }

    @NotNull
    public static final String getHashString(@NotNull List<RdNuGetFeed> $this$hashString) {
        Intrinsics.checkNotNullParameter($this$hashString, (String)"<this>");
        return CollectionsKt.joinToString$default((Iterable)$this$hashString, (CharSequence)"+", null, null, (int)0, null, (Function1)hashString.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public static final String toUserString(@NotNull RdNuGetStateInfo $this$toUserString) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toUserString), (String)"<this>");
        StringBuilder stringBuilder = new StringBuilder();
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = true;
        RiderNuGetExtensionsKt.j(booleanRef, stringBuilder, "IsFetching", $this$toUserString.isFetching());
        RiderNuGetExtensionsKt.j(booleanRef, stringBuilder, "TotalFetched", $this$toUserString.getTotalFetched());
        RiderNuGetExtensionsKt.j(booleanRef, stringBuilder, "PackageReferenceTrackerIsBusy", $this$toUserString.getPackageReferenceTrackerIsBusy());
        RiderNuGetExtensionsKt.j(booleanRef, stringBuilder, "OperatorIsBusy", $this$toUserString.getOperatorIsBusy());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final RdNuGetImplicitVersion toImplicitVersion(@NotNull RdNuGetImplicitPackageIdentity $this$toImplicitVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$toImplicitVersion, (String)"<this>");
        Iterable iterable = $this$toImplicitVersion.getOrigins();
        String string = $this$toImplicitVersion.getIdentity().getVersion();
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t10 : iterable2) {
            RdNuGetPackageIdentity rdNuGetPackageIdentity = (RdNuGetPackageIdentity)t10;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(rdNuGetPackageIdentity.getId());
        }
        List list = (List)collection;
        String string2 = string;
        return new RdNuGetImplicitVersion(string2, list);
    }

    private static final <T> void j(Ref.BooleanRef booleanRef, StringBuilder stringBuilder, String string, IOptProperty<T> iOptProperty) {
        Object object;
        if (!booleanRef.element) {
            stringBuilder.append(", ");
        }
        if ((object = iOptProperty.getValueOrNull()) == null || (object = object.toString()) == null) {
            object = "NA";
        }
        stringBuilder.append(string + ": " + (String)object);
        booleanRef.element = false;
    }
}

