/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.intentions.altEnter;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.rider.intentions.altEnter.GotoActionMenuListener;
import com.jetbrains.rider.intentions.altEnter.RiderAltEnterUsageCollector;
import com.jetbrains.rider.intentions.altEnter.SearchEndType;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u000eH\u0016J\b\u0010\u001b\u001a\u00020\u000eH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/intentions/altEnter/GotoActionMenuTracker;", "Lcom/jetbrains/rider/intentions/altEnter/GotoActionMenuListener;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/ex/EditorEx;)V", "currentSearchSessionInfo", "Lcom/jetbrains/rider/intentions/altEnter/GotoActionMenuTracker$GotoActionSearchInfo;", "language", "Lcom/intellij/lang/Language;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "itemListUpdated", "", "timeMs", "", "patternChanged", "previousPattern", "", "currentPattern", "searchEnded", "type", "Lcom/jetbrains/rider/intentions/altEnter/SearchEndType;", "selectedIndex", "", "searchStarted", "selectionChanged", "GotoActionSearchInfo", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nGotoActionMenuTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GotoActionMenuTracker.kt\ncom/jetbrains/rider/intentions/altEnter/GotoActionMenuTracker\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,73:1\n13#2:74\n*S KotlinDebug\n*F\n+ 1 GotoActionMenuTracker.kt\ncom/jetbrains/rider/intentions/altEnter/GotoActionMenuTracker\n*L\n13#1:74\n*E\n"})
public final class GotoActionMenuTracker
implements GotoActionMenuListener {
    @NotNull
    private final Project project;
    @Nullable
    private GotoActionSearchInfo currentSearchSessionInfo;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Language language;

    public GotoActionMenuTracker(@NotNull Project project2, @NotNull EditorEx editor) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.project = project2;
        boolean bl = false;
        Logger logger = Logger.getInstance(GotoActionMenuTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.project);
        PsiFile psiFile = psiDocumentManager.getPsiFile((Document)editor.getDocument());
        Object object = psiFile != null ? psiFile.getLanguage() : null;
        if (object == null) {
            Language language = Language.ANY;
            object = language;
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"ANY");
        }
        this.language = object;
    }

    @Override
    public void searchStarted() {
        GotoActionSearchInfo gotoActionSearchInfo;
        this.currentSearchSessionInfo = gotoActionSearchInfo = new GotoActionSearchInfo();
    }

    @Override
    public void searchEnded(@NotNull SearchEndType type, int selectedIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        GotoActionSearchInfo gotoActionSearchInfo = this.currentSearchSessionInfo;
        if (gotoActionSearchInfo == null) {
            return;
        }
        GotoActionSearchInfo gotoActionSearchInfo2 = gotoActionSearchInfo;
        this.currentSearchSessionInfo = null;
        long l2 = TimeUnit.MILLISECONDS.convert(System.nanoTime() - gotoActionSearchInfo2.getSessionStartTime(), TimeUnit.NANOSECONDS);
        RiderAltEnterUsageCollector.INSTANCE.logSearchEnded(this.project, type, selectedIndex, l2, gotoActionSearchInfo2);
    }

    @Override
    public void selectionChanged() {
        GotoActionSearchInfo gotoActionSearchInfo = this.currentSearchSessionInfo;
        if (gotoActionSearchInfo == null) {
            return;
        }
        GotoActionSearchInfo gotoActionSearchInfo2 = gotoActionSearchInfo;
        int n2 = gotoActionSearchInfo2.getSelectionChanged();
        gotoActionSearchInfo2.setSelectionChanged(n2 + 1);
    }

    @Override
    public void patternChanged(@NotNull String previousPattern, @NotNull String currentPattern) {
        Intrinsics.checkNotNullParameter((Object)previousPattern, (String)"previousPattern");
        Intrinsics.checkNotNullParameter((Object)currentPattern, (String)"currentPattern");
        GotoActionSearchInfo gotoActionSearchInfo = this.currentSearchSessionInfo;
        if (gotoActionSearchInfo == null) {
            boolean bl = false;
            this.logger.error("No currentSearchSessionInfo during prefix change");
            return;
        }
        GotoActionSearchInfo gotoActionSearchInfo2 = gotoActionSearchInfo;
        if (previousPattern.length() < currentPattern.length()) {
            int n2 = gotoActionSearchInfo2.getTypingCount();
            gotoActionSearchInfo2.setTypingCount(n2 + 1);
        } else {
            int n3 = gotoActionSearchInfo2.getBackspacesCount();
            gotoActionSearchInfo2.setBackspacesCount(n3 + 1);
        }
        gotoActionSearchInfo2.setQueryLength(currentPattern.length());
    }

    @Override
    public void itemListUpdated(long timeMs) {
        GotoActionSearchInfo gotoActionSearchInfo = this.currentSearchSessionInfo;
        if (gotoActionSearchInfo == null) {
            boolean bl = false;
            this.logger.error("No currentSearchSessionInfo during list update");
            return;
        }
        GotoActionSearchInfo gotoActionSearchInfo2 = gotoActionSearchInfo;
        gotoActionSearchInfo2.setLastSearchStartTime(timeMs);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0010\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR\u0011\u0010\u0015\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\fR\u001a\u0010\u0017\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0006\"\u0004\b\u0019\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/intentions/altEnter/GotoActionMenuTracker$GotoActionSearchInfo;", "", "()V", "backspacesCount", "", "getBackspacesCount", "()I", "setBackspacesCount", "(I)V", "lastSearchStartTime", "", "getLastSearchStartTime", "()J", "setLastSearchStartTime", "(J)V", "queryLength", "getQueryLength", "setQueryLength", "selectionChanged", "getSelectionChanged", "setSelectionChanged", "sessionStartTime", "getSessionStartTime", "typingCount", "getTypingCount", "setTypingCount", "intellij.rider.rdclient.dotnet"})
    public static final class GotoActionSearchInfo {
        private final long sessionStartTime = System.nanoTime();
        private long lastSearchStartTime;
        private int typingCount;
        private int backspacesCount;
        private int selectionChanged;
        private int queryLength;

        public final long getSessionStartTime() {
            return this.sessionStartTime;
        }

        public final long getLastSearchStartTime() {
            return this.lastSearchStartTime;
        }

        public final void setLastSearchStartTime(long l2) {
            this.lastSearchStartTime = l2;
        }

        public final int getTypingCount() {
            return this.typingCount;
        }

        public final void setTypingCount(int n2) {
            this.typingCount = n2;
        }

        public final int getBackspacesCount() {
            return this.backspacesCount;
        }

        public final void setBackspacesCount(int n2) {
            this.backspacesCount = n2;
        }

        public final int getSelectionChanged() {
            return this.selectionChanged;
        }

        public final void setSelectionChanged(int n2) {
            this.selectionChanged = n2;
        }

        public final int getQueryLength() {
            return this.queryLength;
        }

        public final void setQueryLength(int n2) {
            this.queryLength = n2;
        }
    }
}

