/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ideaInterop.vfs.structure;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rider.ideaInterop.vfs.structure.FilePathComponentComparator;
import com.jetbrains.rider.ideaInterop.vfs.structure.FilePathTreeVisitor;
import com.jetbrains.rider.ideaInterop.vfs.structure.VisitResult;
import java.io.File;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 3*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u000234B\u001f\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0007JE\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00028\u00002\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0017\u001a\u00020\u001d\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010\u001c\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u001fJ\u001d\u0010 \u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010!\u001a\u00020\n\u00a2\u0006\u0002\u0010\"J\u0013\u0010#\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u001fJ\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00180\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\u0015\u0010%\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0019\u001a\u00028\u0000\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\nH\u0002J\u001b\u0010)\u001a\u00020*2\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010+J\u000e\u0010)\u001a\u00020*2\u0006\u0010\u0017\u001a\u00020\u0018J2\u0010,\u001a\u00020*2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\u001c\b\u0002\u0010-\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\u0013\u0018\u00010.Jm\u0010/\u001a\u00020*2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00028\u00002\b\u0010\u001a\u001a\u0004\u0018\u00010\u00032\u0018\u00100\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n010\u000b2\u001a\u0010-\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\u0013\u0018\u00010.H\u0002\u00a2\u0006\u0002\u00102R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u000bj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u0000`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000bj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u00065"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree;", "T", "Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;", "", "entryFactory", "Lkotlin/Function2;", "", "(Lkotlin/jvm/functions/Function2;)V", "childrenMap", "Ljava/util/TreeMap;", "", "Ljava/util/HashMap;", "entryMap", "Lkotlin/collections/HashMap;", "nextId", "parentCountMap", "root", "Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;", "j", "Lkotlin/Pair;", "Lcom/jetbrains/rider/ideaInterop/vfs/structure/VisitResult;", "visitor", "Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTreeVisitor;", "file", "Ljava/io/File;", "entry", "context", "(Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTreeVisitor;Ljava/io/File;Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;Ljava/lang/Object;)Lkotlin/Pair;", "get", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;", "(Ljava/io/File;)Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;", "getChild", "pathComponent", "(Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;Ljava/lang/String;)Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;", "getOrCreate", "getOrFindExistingParent", "getParent", "(Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;)Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;", "j", "part", "removeIfEmpty", "", "(Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;Ljava/io/File;)V", "visit", "comparator", "Ljava/util/Comparator;", "j", "allChildren", "Ljava/util/ArrayList;", "(Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTreeVisitor;Ljava/io/File;Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;Ljava/lang/Object;Ljava/util/HashMap;Ljava/util/Comparator;)V", "Companion", "Entry", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nFilePathTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilePathTree.kt\ncom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,194:1\n372#2,7:195\n372#2,7:202\n*S KotlinDebug\n*F\n+ 1 FilePathTree.kt\ncom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree\n*L\n76#1:195,7\n119#1:202,7\n*E\n"})
public final class FilePathTree<T extends Entry> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function2<Integer, Integer, T> entryFactory;
    private int nextId;
    @NotNull
    private final T root;
    @NotNull
    private final TreeMap<String, HashMap<Integer, T>> childrenMap;
    @NotNull
    private final HashMap<Integer, T> entryMap;
    @NotNull
    private final HashMap<Integer, Integer> parentCountMap;
    private static final int RootId;

    public FilePathTree(@NotNull Function2<? super Integer, ? super Integer, ? extends T> entryFactory) {
        Intrinsics.checkNotNullParameter(entryFactory, (String)"entryFactory");
        this.entryFactory = entryFactory;
        this.nextId = RootId + 1;
        this.root = (Entry)this.entryFactory.invoke((Object)RootId, (Object)(RootId - 1));
        this.childrenMap = new TreeMap(FilePathComponentComparator.INSTANCE);
        this.entryMap = new HashMap();
        this.parentCountMap = new HashMap();
        this.entryMap.put(((Entry)this.root).getId(), this.root);
    }

    @Nullable
    public final T get(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        File file3 = VfsUtil.virtualToIoFile((VirtualFile)file2);
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"virtualToIoFile(...)");
        return this.get(file3);
    }

    @Nullable
    public final T get(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        List list = FileUtil.splitPath((String)file2.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"splitPath(...)");
        List list2 = list;
        T t10 = this.root;
        for (String string : list2) {
            Intrinsics.checkNotNull((Object)string);
            if (this.getChild(t10, string) != null) continue;
            return null;
        }
        return t10;
    }

    @NotNull
    public final Pair<T, File> getOrFindExistingParent(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        List list = FileUtil.splitPath((String)file2.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"splitPath(...)");
        List list2 = list;
        T t10 = this.root;
        Iterator iterator = list2.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            int n3 = n2++;
            String string = (String)iterator.next();
            Intrinsics.checkNotNull((Object)string);
            T t11 = this.getChild(t10, string);
            if (t11 == null) {
                File file3 = file2;
                int n4 = ((Collection)list2).size() - n3;
                for (int i2 = 0; i2 < n4; ++i2) {
                    File file4 = file3.getParentFile();
                    if (file4 == null) continue;
                    file3 = file4;
                }
                return new Pair(t10, (Object)file3);
            }
            t10 = t11;
        }
        return new Pair(t10, (Object)file2);
    }

    @NotNull
    public final T getOrCreate(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        List list = FileUtil.splitPath((String)file2.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"splitPath(...)");
        List list2 = list;
        T t10 = this.root;
        for (String string : list2) {
            Intrinsics.checkNotNull((Object)string);
            Object object = this.getChild(t10, string);
            if (object == null) {
                Object object2;
                int n2 = this.nextId;
                this.nextId = n2 + 1;
                object = (Entry)this.entryFactory.invoke((Object)n2, (Object)((Entry)t10).getId());
                this.entryMap.put(((Entry)object).getId(), object);
                Integer n3 = this.parentCountMap.getOrDefault(((Entry)t10).getId(), 0);
                Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"getOrDefault(...)");
                n2 = ((Number)n3).intValue();
                ((Map)this.parentCountMap).put(((Entry)t10).getId(), n2 + 1);
                String string2 = this.j(string);
                Map map = this.childrenMap;
                boolean bl = false;
                Object v10 = map.get(string2);
                if (v10 == null) {
                    boolean bl2 = false;
                    HashMap hashMap = new HashMap();
                    map.put(string2, hashMap);
                    object2 = hashMap;
                } else {
                    object2 = v10;
                }
                HashMap hashMap = (HashMap)object2;
                hashMap.put(((Entry)t10).getId(), object);
            }
            t10 = object;
        }
        return t10;
    }

    public final void removeIfEmpty(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        T t10 = this.get(file2);
        if (t10 == null) {
            return;
        }
        T t11 = t10;
        this.removeIfEmpty(t11, file2);
    }

    public final void removeIfEmpty(@NotNull T entry2, @NotNull File file2) {
        Intrinsics.checkNotNullParameter(entry2, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!this.entryMap.containsKey(((Entry)entry2).getId())) {
            return;
        }
        if (!((Entry)entry2).isEmpty()) {
            return;
        }
        if (this.parentCountMap.containsKey(((Entry)entry2).getId())) {
            return;
        }
        this.entryMap.remove(((Entry)entry2).getId());
        HashMap<Integer, T> hashMap = this.childrenMap.get(file2.getName());
        if (hashMap != null) {
            Entry cfr_ignored_0 = (Entry)hashMap.remove(((Entry)entry2).getParentId());
        }
        Integer n2 = this.parentCountMap.getOrDefault(((Entry)entry2).getParentId(), 0);
        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"getOrDefault(...)");
        int n3 = ((Number)n2).intValue();
        if (n3 == 1) {
            this.parentCountMap.remove(((Entry)entry2).getParentId());
        } else if (n3 > 1) {
            ((Map)this.parentCountMap).put(((Entry)entry2).getParentId(), n3 - 1);
        }
        T t10 = this.getParent(entry2);
        if (t10 == null) {
            return;
        }
        T t11 = t10;
        File file3 = file2.getParentFile();
        if (file3 == null) {
            return;
        }
        File file4 = file3;
        this.removeIfEmpty(t11, file4);
    }

    public final void visit(@NotNull FilePathTreeVisitor<? super T> visitor2, @Nullable Comparator<Pair<String, T>> comparator) {
        Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
        HashMap<Integer, ArrayList<String>> hashMap = new HashMap<Integer, ArrayList<String>>();
        for (Map.Entry entry2 : ((Map)this.childrenMap).entrySet()) {
            String string = (String)entry2.getKey();
            HashMap hashMap2 = (HashMap)entry2.getValue();
            Iterator iterator = ((Map)hashMap2).entrySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                int n2 = ((Number)iterator.next().getKey()).intValue();
                Map map = hashMap;
                Integer n3 = n2;
                boolean bl = false;
                Object v10 = map.get(n3);
                if (v10 == null) {
                    boolean bl2 = false;
                    ArrayList arrayList = new ArrayList();
                    map.put(n3, arrayList);
                    object = arrayList;
                } else {
                    object = v10;
                }
                ArrayList arrayList = (ArrayList)object;
                arrayList.add(string);
            }
        }
        this.j(visitor2, null, this.root, null, hashMap, comparator);
    }

    public static /* synthetic */ void visit$default(FilePathTree filePathTree, FilePathTreeVisitor filePathTreeVisitor, Comparator comparator, int n2, Object object) {
        if ((n2 & 2) != 0) {
            comparator = null;
        }
        filePathTree.visit(filePathTreeVisitor, comparator);
    }

    private final void j(FilePathTreeVisitor<? super T> filePathTreeVisitor, File file2, T t10, Object object, HashMap<Integer, ArrayList<String>> hashMap, Comparator<Pair<String, T>> comparator) {
        Object object2;
        ProgressManager.checkCanceled();
        Pair<VisitResult, Object> pair2 = this.j(filePathTreeVisitor, file2, t10, object);
        VisitResult visitResult = (VisitResult)((Object)pair2.component1());
        Object object3 = pair2.component2();
        if (visitResult == VisitResult.Stop) {
            return;
        }
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<String> arrayList2 = hashMap.get(((Entry)t10).getId());
        if (arrayList2 == null) {
            return;
        }
        ArrayList<String> arrayList3 = arrayList2;
        for (String string : arrayList3) {
            Intrinsics.checkNotNull((Object)string);
            object2 = this.getChild(t10, string);
            if (object2 == null) continue;
            arrayList.add(new Pair((Object)string, object2));
        }
        if (comparator != null) {
            CollectionsKt.sortWith((List)arrayList, comparator);
        }
        for (Pair pair3 : arrayList) {
            object2 = (String)pair3.component1();
            Entry entry2 = (Entry)pair3.component2();
            File file3 = new File(file2, (String)object2);
            this.j(filePathTreeVisitor, file3, entry2, object3, hashMap, comparator);
        }
    }

    private final Pair<VisitResult, Object> j(FilePathTreeVisitor<? super T> filePathTreeVisitor, File file2, T t10, Object object) {
        if (file2 == null) {
            return new Pair((Object)VisitResult.Continue, object);
        }
        return filePathTreeVisitor.visitEntry(file2, t10, object);
    }

    @Nullable
    public final T getParent(@NotNull T entry2) {
        Intrinsics.checkNotNullParameter(entry2, (String)"entry");
        ProgressManager.checkCanceled();
        return (T)((Entry)this.entryMap.get(((Entry)entry2).getParentId()));
    }

    @Nullable
    public final T getChild(@NotNull T entry2, @NotNull String pathComponent) {
        Intrinsics.checkNotNullParameter(entry2, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)pathComponent, (String)"pathComponent");
        ProgressManager.checkCanceled();
        String string = this.j(pathComponent);
        HashMap<Integer, T> hashMap = this.childrenMap.get(string);
        if (hashMap == null) {
            return null;
        }
        HashMap<Integer, T> hashMap2 = hashMap;
        return (T)((Entry)hashMap2.get(((Entry)entry2).getId()));
    }

    private final String j(String string) {
        if (SystemInfo.isMac) {
            String string2 = Normalizer.normalize(string, Normalizer.Form.NFC);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"normalize(...)");
            return string2;
        }
        if (SystemInfo.isWindows && StringsKt.endsWith$default((String)string, (String)":", (boolean)false, (int)2, null)) {
            return string + "\\";
        }
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Companion;", "", "()V", "RootId", "", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\nH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;", "", "id", "", "parentId", "(II)V", "getId", "()I", "getParentId", "isEmpty", "", "intellij.rider.rdclient.dotnet"})
    public static abstract class Entry {
        private final int id;
        private final int parentId;

        public Entry(int id, int parentId) {
            this.id = id;
            this.parentId = parentId;
        }

        public final int getId() {
            return this.id;
        }

        public final int getParentId() {
            return this.parentId;
        }

        public abstract boolean isEmpty();
    }
}

