/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ideaInterop.vfs;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.jetbrains.rd.platform.util.ApplicationKt;
import com.jetbrains.rider.ideaInterop.vfs.VfsWatchRootFilter;
import com.jetbrains.rider.ideaInterop.vfs.VfsWatchRootHost;
import com.jetbrains.rider.model.RdWatchRootInfo;
import com.jetbrains.rider.util.idea.TimeLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 \u00162\u00020\u0001:\u0004\u0016\u0017\u0018\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\tJ\u0006\u0010\u0015\u001a\u00020\u0010R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager;", "", "localFileSystem", "Lcom/intellij/openapi/vfs/LocalFileSystem;", "filter", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootFilter;", "(Lcom/intellij/openapi/vfs/LocalFileSystem;Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootFilter;)V", "queue", "Lkotlin/collections/ArrayDeque;", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager$QueueItem;", "watchRequests", "Ljava/util/HashMap;", "Ljava/io/File;", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager$WatchRequestInfo;", "Lkotlin/collections/HashMap;", "cleanup", "", "dump", "", "register", "queueItem", "update", "Companion", "QueueFileItem", "QueueItem", "WatchRequestInfo", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nVfsWatchRootManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VfsWatchRootManager.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,163:1\n135#2,9:164\n215#2:173\n216#2:175\n144#2:176\n1#3:174\n1045#4:177\n13#5:178\n13#6:179\n*S KotlinDebug\n*F\n+ 1 VfsWatchRootManager.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager\n*L\n32#1:164,9\n32#1:173\n32#1:175\n32#1:176\n32#1:174\n135#1:177\n16#1:178\n16#1:179\n*E\n"})
public final class VfsWatchRootManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalFileSystem localFileSystem;
    @Nullable
    private final VfsWatchRootFilter filter;
    @NotNull
    private final HashMap<File, WatchRequestInfo> watchRequests;
    @NotNull
    private final ArrayDeque<QueueItem> queue;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final StringBuilder eventLog;

    public VfsWatchRootManager(@NotNull LocalFileSystem localFileSystem, @Nullable VfsWatchRootFilter filter2) {
        Intrinsics.checkNotNullParameter((Object)localFileSystem, (String)"localFileSystem");
        this.localFileSystem = localFileSystem;
        this.filter = filter2;
        this.watchRequests = new HashMap();
        this.queue = new ArrayDeque(20);
    }

    public final void register(@NotNull QueueItem queueItem) {
        Intrinsics.checkNotNullParameter((Object)queueItem, (String)"queueItem");
        Application application = ApplicationKt.getApplicationOrNull();
        if (application != null) {
            application.assertIsDispatchThread();
        }
        this.queue.addLast((Object)queueItem);
    }

    public final void cleanup() {
        Application application = ApplicationKt.getApplicationOrNull();
        if (application != null) {
            application.assertIsDispatchThread();
        }
        Map map = this.watchRequests;
        boolean bl = false;
        Map map2 = map;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        Map map3 = map2;
        boolean bl3 = false;
        Iterator iterator = map3.entrySet().iterator();
        while (iterator.hasNext()) {
            LocalFileSystem.WatchRequest watchRequest;
            Map.Entry entry2;
            Map.Entry entry3 = entry2 = iterator.next();
            boolean bl4 = false;
            Map.Entry entry4 = entry3;
            boolean bl5 = false;
            if (((WatchRequestInfo)entry4.getValue()).getRequest() == null) continue;
            boolean bl6 = false;
            collection.add(watchRequest);
        }
        List list = (List)collection;
        this.localFileSystem.removeWatchedRoots((Collection)list);
        this.queue.clear();
        this.watchRequests.clear();
    }

    public final void update() {
        String string;
        logger.trace("update(): start");
        Application application = ApplicationKt.getApplicationOrNull();
        if (application != null) {
            application.assertIsDispatchThread();
        }
        if (this.queue.isEmpty()) {
            logger.trace("update(): return because queue.isEmpty");
            return;
        }
        TimeLogger timeLogger = new TimeLogger();
        ArrayList<LocalFileSystem.WatchRequest> arrayList = new ArrayList<LocalFileSystem.WatchRequest>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        Function2 function2 = (Function2)new Function2<File, Boolean, Unit>(this, arrayList2, arrayList3){
            final /* synthetic */ VfsWatchRootManager this$0;
            final /* synthetic */ ArrayList<String> $recursiveRoots;
            final /* synthetic */ ArrayList<String> $flatRoots;
            {
                this.this$0 = $receiver;
                this.$recursiveRoots = $recursiveRoots;
                this.$flatRoots = $flatRoots;
                super(2);
            }

            public final void invoke(@NotNull File file2, boolean isRecursive) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                if (VfsWatchRootManager.access$getFilter$p(this.this$0) == null || VfsWatchRootManager.access$getFilter$p(this.this$0).shouldWatch(file2)) {
                    if (isRecursive) {
                        this.$recursiveRoots.add(file2.getPath());
                    } else {
                        this.$flatRoots.add(file2.getPath());
                    }
                }
            }
        };
        Function1 function1 = (Function1)new Function1<LocalFileSystem.WatchRequest, Unit>(arrayList){
            final /* synthetic */ ArrayList<LocalFileSystem.WatchRequest> $oldWatchRequests;
            {
                this.$oldWatchRequests = $oldWatchRequests;
                super(1);
            }

            public final void invoke(@Nullable LocalFileSystem.WatchRequest request) {
                if (request != null) {
                    this.$oldWatchRequests.add(request);
                }
            }
        };
        logger.trace("update(): Prepare watch requests / START");
        timeLogger.section("Prepare watch requests", (Function0)new Function0<Unit>(this, (Function1<? super LocalFileSystem.WatchRequest, Unit>)function1, (Function2<? super File, ? super Boolean, Unit>)function2){
            final /* synthetic */ VfsWatchRootManager this$0;
            final /* synthetic */ Function1<LocalFileSystem.WatchRequest, Unit> $removeWatchRoot;
            final /* synthetic */ Function2<File, Boolean, Unit> $addWatchRoot;
            {
                this.this$0 = $receiver;
                this.$removeWatchRoot = $removeWatchRoot;
                this.$addWatchRoot = $addWatchRoot;
                super(0);
            }

            public final void invoke() {
                while (!VfsWatchRootManager.access$getQueue$p(this.this$0).isEmpty()) {
                    boolean bl;
                    WatchRequestInfo watchRequestInfo;
                    QueueItem queueItem = (QueueItem)VfsWatchRootManager.access$getQueue$p(this.this$0).removeFirst();
                    File file2 = queueItem.getRequestedFile();
                    if (queueItem.getOld() != null && (watchRequestInfo = (WatchRequestInfo)VfsWatchRootManager.access$getWatchRequests$p(this.this$0).get(queueItem.getOld().getFile())) != null) {
                        bl = watchRequestInfo.isRecursive();
                        watchRequestInfo.getRequestedFiles().remove(file2);
                        if (watchRequestInfo.getRequestedFiles().isEmpty()) {
                            this.$removeWatchRoot.invoke((Object)watchRequestInfo.getRequest());
                            VfsWatchRootManager.access$getWatchRequests$p(this.this$0).remove(queueItem.getOld().getFile());
                        } else if (bl != watchRequestInfo.isRecursive()) {
                            this.$removeWatchRoot.invoke((Object)watchRequestInfo.getRequest());
                            this.$addWatchRoot.invoke((Object)queueItem.getOld().getFile(), (Object)watchRequestInfo.isRecursive());
                        }
                    }
                    if (queueItem.getNew() == null) continue;
                    watchRequestInfo = (WatchRequestInfo)VfsWatchRootManager.access$getWatchRequests$p(this.this$0).get(queueItem.getNew().getFile());
                    if (watchRequestInfo != null) {
                        bl = watchRequestInfo.isRecursive();
                        ((Map)watchRequestInfo.getRequestedFiles()).put(file2, queueItem.getNew().isRecursive());
                        if (bl == watchRequestInfo.isRecursive()) continue;
                        this.$removeWatchRoot.invoke((Object)watchRequestInfo.getRequest());
                        this.$addWatchRoot.invoke((Object)queueItem.getNew().getFile(), (Object)watchRequestInfo.isRecursive());
                        continue;
                    }
                    Pair[] pairArray = new Pair[]{new Pair((Object)file2, (Object)queueItem.getNew().isRecursive())};
                    WatchRequestInfo watchRequestInfo2 = new WatchRequestInfo(MapsKt.hashMapOf((Pair[])pairArray), null, 2, null);
                    ((Map)VfsWatchRootManager.access$getWatchRequests$p(this.this$0)).put(queueItem.getNew().getFile(), watchRequestInfo2);
                    this.$addWatchRoot.invoke((Object)queueItem.getNew().getFile(), (Object)watchRequestInfo2.isRecursive());
                }
            }
        });
        logger.trace("update(): Prepare watch requests / FINISH");
        logger.trace("update(): Replace watched roots in VFS / START");
        timeLogger.section("Replace watched roots in VFS", (Function0)new Function0<Unit>(this, arrayList, arrayList2, arrayList3){
            final /* synthetic */ VfsWatchRootManager this$0;
            final /* synthetic */ ArrayList<LocalFileSystem.WatchRequest> $oldWatchRequests;
            final /* synthetic */ ArrayList<String> $recursiveRoots;
            final /* synthetic */ ArrayList<String> $flatRoots;
            {
                this.this$0 = $receiver;
                this.$oldWatchRequests = $oldWatchRequests;
                this.$recursiveRoots = $recursiveRoots;
                this.$flatRoots = $flatRoots;
                super(0);
            }

            public final void invoke() {
                Set set = VfsWatchRootManager.access$getLocalFileSystem$p(this.this$0).replaceWatchedRoots((Collection)this.$oldWatchRequests, (Collection)this.$recursiveRoots, (Collection)this.$flatRoots);
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"replaceWatchedRoots(...)");
                Set set2 = set;
                for (LocalFileSystem.WatchRequest watchRequest : CollectionsKt.filterNotNull((Iterable)set2)) {
                    WatchRequestInfo watchRequestInfo = (WatchRequestInfo)VfsWatchRootManager.access$getWatchRequests$p(this.this$0).get(new File(watchRequest.getRootPath()));
                    if (watchRequestInfo == null) continue;
                    watchRequestInfo.setRequest(watchRequest);
                }
            }
        });
        logger.trace("update(): Replace watched roots in VFS / FINISH");
        String string2 = string = timeLogger.complete(arrayList2.size() + " recursive and " + arrayList3.size() + " flat roots updated");
        boolean bl = false;
        logger.trace(string2);
        Application application2 = ApplicationKt.getApplicationOrNull();
        boolean bl2 = application2 != null ? application2.isInternal() : false;
        if (bl2) {
            StringBuilder stringBuilder = eventLog.append(string2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        }
        logger.trace("update(): finish");
    }

    @NotNull
    public final String dump() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("External roots: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        Object object2 = ((Map)this.watchRequests).entrySet();
        boolean bl = false;
        for (Object object2 : CollectionsKt.sortedWith((Iterable)object2, (Comparator)new Comparator(){

            public final int compare(T a2, T b2) {
                Map.Entry entry2 = (Map.Entry)a2;
                boolean bl = false;
                Comparable comparable = (File)entry2.getKey();
                entry2 = (Map.Entry)b2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((File)entry2.getKey()));
            }
        })) {
            File file2 = (File)object2.getKey();
            WatchRequestInfo watchRequestInfo = (WatchRequestInfo)object2.getValue();
            StringBuilder stringBuilder3 = stringBuilder.append(file2 + " Recursive: " + watchRequestInfo.isRecursive());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        }
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder4 = stringBuilder.append("Log: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        stringBuilder.append((CharSequence)eventLog);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static final /* synthetic */ VfsWatchRootFilter access$getFilter$p(VfsWatchRootManager $this) {
        return $this.filter;
    }

    public static final /* synthetic */ ArrayDeque access$getQueue$p(VfsWatchRootManager $this) {
        return $this.queue;
    }

    public static final /* synthetic */ HashMap access$getWatchRequests$p(VfsWatchRootManager $this) {
        return $this.watchRequests;
    }

    public static final /* synthetic */ LocalFileSystem access$getLocalFileSystem$p(VfsWatchRootManager $this) {
        return $this.localFileSystem;
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getInstance(VfsWatchRootHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        VfsWatchRootManager.logger = logger;
        eventLog = new StringBuilder();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager$Companion;", "", "()V", "eventLog", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\t\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager$QueueFileItem;", "", "file", "Ljava/io/File;", "isRecursive", "", "(Ljava/io/File;Z)V", "getFile", "()Ljava/io/File;", "()Z", "Companion", "intellij.rider.rdclient.dotnet"})
    public static final class QueueFileItem {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final File file;
        private final boolean isRecursive;

        private QueueFileItem(File file2, boolean isRecursive) {
            this.file = file2;
            this.isRecursive = isRecursive;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        public final boolean isRecursive() {
            return this.isRecursive;
        }

        public /* synthetic */ QueueFileItem(File file2, boolean isRecursive, DefaultConstructorMarker $constructor_marker) {
            this(file2, isRecursive);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager$QueueFileItem$Companion;", "", "()V", "create", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager$QueueFileItem;", "file", "Ljava/io/File;", "info", "Lcom/jetbrains/rider/model/RdWatchRootInfo;", "intellij.rider.rdclient.dotnet"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final QueueFileItem create(@NotNull File file2, @NotNull RdWatchRootInfo info) {
                QueueFileItem queueFileItem;
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                if (info.isDirectory()) {
                    queueFileItem = new QueueFileItem(file2, info.isRecursive(), null);
                } else {
                    File file3 = file2.getParentFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getParentFile(...)");
                    queueFileItem = new QueueFileItem(file3, false, null);
                }
                return queueFileItem;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager$QueueItem;", "", "requestedFile", "Ljava/io/File;", "old", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager$QueueFileItem;", "new", "(Ljava/io/File;Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager$QueueFileItem;Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager$QueueFileItem;)V", "getNew", "()Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager$QueueFileItem;", "getOld", "getRequestedFile", "()Ljava/io/File;", "intellij.rider.rdclient.dotnet"})
    public static final class QueueItem {
        @NotNull
        private final File requestedFile;
        @Nullable
        private final QueueFileItem old;
        @Nullable
        private final QueueFileItem new;

        public QueueItem(@NotNull File requestedFile, @Nullable QueueFileItem old, @Nullable QueueFileItem queueFileItem) {
            Intrinsics.checkNotNullParameter((Object)requestedFile, (String)"requestedFile");
            this.requestedFile = requestedFile;
            this.old = old;
            this.new = queueFileItem;
        }

        @NotNull
        public final File getRequestedFile() {
            return this.requestedFile;
        }

        @Nullable
        public final QueueFileItem getOld() {
            return this.old;
        }

        @Nullable
        public final QueueFileItem getNew() {
            return this.new;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B5\u0012\"\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR-\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager$WatchRequestInfo;", "", "requestedFiles", "Ljava/util/HashMap;", "Ljava/io/File;", "", "Lkotlin/collections/HashMap;", "request", "Lcom/intellij/openapi/vfs/LocalFileSystem$WatchRequest;", "(Ljava/util/HashMap;Lcom/intellij/openapi/vfs/LocalFileSystem$WatchRequest;)V", "isRecursive", "()Z", "getRequest", "()Lcom/intellij/openapi/vfs/LocalFileSystem$WatchRequest;", "setRequest", "(Lcom/intellij/openapi/vfs/LocalFileSystem$WatchRequest;)V", "getRequestedFiles", "()Ljava/util/HashMap;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nVfsWatchRootManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VfsWatchRootManager.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager$WatchRequestInfo\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,163:1\n187#2,3:164\n*S KotlinDebug\n*F\n+ 1 VfsWatchRootManager.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager$WatchRequestInfo\n*L\n161#1:164,3\n*E\n"})
    public static final class WatchRequestInfo {
        @NotNull
        private final HashMap<File, Boolean> requestedFiles;
        @Nullable
        private LocalFileSystem.WatchRequest request;
        private final boolean isRecursive;

        public WatchRequestInfo(@NotNull HashMap<File, Boolean> requestedFiles, @Nullable LocalFileSystem.WatchRequest request) {
            boolean bl;
            boolean bl2;
            block3: {
                Intrinsics.checkNotNullParameter(requestedFiles, (String)"requestedFiles");
                this.requestedFiles = requestedFiles;
                this.request = request;
                Map map = this.requestedFiles;
                WatchRequestInfo watchRequestInfo = this;
                boolean bl3 = false;
                if (map.isEmpty()) {
                    bl2 = false;
                } else {
                    Iterator iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry2;
                        Map.Entry entry3 = entry2 = iterator.next();
                        boolean bl4 = false;
                        if (!((Boolean)entry3.getValue()).booleanValue()) continue;
                        bl2 = true;
                        break block3;
                    }
                    bl2 = false;
                }
            }
            watchRequestInfo.isRecursive = bl = bl2;
        }

        public /* synthetic */ WatchRequestInfo(HashMap hashMap, LocalFileSystem.WatchRequest watchRequest, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                watchRequest = null;
            }
            this(hashMap, watchRequest);
        }

        @NotNull
        public final HashMap<File, Boolean> getRequestedFiles() {
            return this.requestedFiles;
        }

        @Nullable
        public final LocalFileSystem.WatchRequest getRequest() {
            return this.request;
        }

        public final void setRequest(@Nullable LocalFileSystem.WatchRequest watchRequest) {
            this.request = watchRequest;
        }

        public final boolean isRecursive() {
            return this.isRecursive;
        }
    }
}

