/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ideaInterop.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.Alarm;
import com.intellij.util.ApplicationKt;
import com.intellij.util.SingleAlarm;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.IViewableMap;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.ideaInterop.vfs.VfsWarmQueue;
import com.jetbrains.rider.ideaInterop.vfs.VfsWatchRootFilter;
import com.jetbrains.rider.ideaInterop.vfs.VfsWatchRootManager;
import com.jetbrains.rider.model.RdSyncRequest;
import com.jetbrains.rider.model.RdWatchRootInfo;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelEvents;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018J\u001a\u0010\u0019\u001a\u00020\u00142\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001c0\u001bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "alarm", "Lcom/intellij/util/SingleAlarm;", "filter", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootFilter;", "initialized", "", "isReady", "()Z", "manager", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager;", "warmQueue", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWarmQueue;", "dump", "", "startup", "", "sync", "syncRequestHandler", "request", "Lcom/jetbrains/rider/model/RdSyncRequest;", "watchRootsHandler", "event", "Lcom/jetbrains/rd/util/reactive/IViewableMap$Event;", "Lcom/jetbrains/rider/model/RdWatchRootInfo;", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nVfsWatchRootHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VfsWatchRootHost.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootHost\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,106:1\n13#2:107\n13#3:108\n*S KotlinDebug\n*F\n+ 1 VfsWatchRootHost.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootHost\n*L\n25#1:107\n25#1:108\n*E\n"})
public final class VfsWatchRootHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VfsWatchRootFilter filter;
    @NotNull
    private final VfsWarmQueue warmQueue;
    @NotNull
    private final VfsWatchRootManager manager;
    @NotNull
    private final SingleAlarm alarm;
    private boolean initialized;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final StringBuilder eventLog;

    public VfsWatchRootHost(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.filter = new VfsWatchRootFilter(this.project);
        this.warmQueue = new VfsWarmQueue(this.project, this.filter, (Disposable)this);
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        this.manager = new VfsWatchRootManager(localFileSystem, this.filter);
        this.alarm = new SingleAlarm(() -> VfsWatchRootHost.j(this), 100, Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        BoolPropertyExKt.whenTrue((IViewable)((IViewable)WorkspaceModelEvents.Companion.getInstance(this.project).getSynced()), (Lifetime)ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)), (Function1)((Function1)new Function1<Lifetime, Unit>(){

            public final void invoke(@NotNull Lifetime it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                initialized = true;
                this.sync();
            }
        }));
        this.getServiceLifetime().onTermination((Function0)new Function0<Unit>(){

            public final void invoke() {
                manager.cleanup();
            }
        });
    }

    public final boolean isReady() {
        return this.warmQueue.isReady();
    }

    @NotNull
    public final String dump() {
        return this.manager.dump();
    }

    public final void sync() {
        this.manager.update();
    }

    public final void startup() {
        this.warmQueue.startup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void syncRequestHandler(@NotNull RdSyncRequest request) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        try {
            this.sync();
        }
        finally {
            InterfacesKt.fire(request.getReady());
        }
    }

    public final void watchRootsHandler(@NotNull IViewableMap.Event<String, RdWatchRootInfo> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        ApplicationKt.getApplication().assertIsDispatchThread();
        if (!this.project.isOpen()) {
            return;
        }
        File file2 = new File((String)event.getKey());
        VfsWatchRootManager.QueueFileItem queueFileItem = null;
        VfsWatchRootManager.QueueFileItem queueFileItem2 = null;
        IViewableMap.Event<String, RdWatchRootInfo> event2 = event;
        if (event2 instanceof IViewableMap.Event.Add) {
            VfsWatchRootManager.QueueFileItem queueFileItem3;
            logger.trace("Add '" + file2 + "'$");
            queueFileItem = null;
            VfsWatchRootManager.QueueFileItem queueFileItem4 = queueFileItem3 = VfsWatchRootManager.QueueFileItem.Companion.create(file2, (RdWatchRootInfo)((IViewableMap.Event.Add)event).getNewValue());
            boolean bl = false;
            this.warmQueue.enqueue(queueFileItem4.getFile(), queueFileItem4.isRecursive());
            queueFileItem2 = queueFileItem3;
        } else if (event2 instanceof IViewableMap.Event.Update) {
            logger.trace("Update '" + file2 + "'$");
            queueFileItem = VfsWatchRootManager.QueueFileItem.Companion.create(file2, (RdWatchRootInfo)((IViewableMap.Event.Update)event).getOldValue());
            queueFileItem2 = VfsWatchRootManager.QueueFileItem.Companion.create(file2, (RdWatchRootInfo)((IViewableMap.Event.Update)event).getNewValue());
        } else if (event2 instanceof IViewableMap.Event.Remove) {
            logger.trace("Remove '" + file2 + "'$");
            queueFileItem = VfsWatchRootManager.QueueFileItem.Companion.create(file2, (RdWatchRootInfo)((IViewableMap.Event.Remove)event).getOldValue());
            queueFileItem2 = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.manager.register(new VfsWatchRootManager.QueueItem(file2, queueFileItem, queueFileItem2));
        if (this.initialized) {
            SingleAlarm.cancelAndRequest$default((SingleAlarm)this.alarm, (boolean)false, (int)1, null);
        }
    }

    private static final void j(VfsWatchRootHost vfsWatchRootHost) {
        Intrinsics.checkNotNullParameter((Object)((Object)vfsWatchRootHost), (String)"this$0");
        vfsWatchRootHost.sync();
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getInstance(VfsWatchRootHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        VfsWatchRootHost.logger = logger;
        eventLog = new StringBuilder();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootHost$Companion;", "", "()V", "eventLog", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootHost;", "project", "Lcom/intellij/openapi/project/Project;", "reportEventLog", "", "message", "", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nVfsWatchRootHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VfsWatchRootHost.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,106:1\n31#2,2:107\n*S KotlinDebug\n*F\n+ 1 VfsWatchRootHost.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootHost$Companion\n*L\n28#1:107,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VfsWatchRootHost getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager componentManager = (ComponentManager)project2;
            boolean bl = false;
            Class<VfsWatchRootHost> clazz = VfsWatchRootHost.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (VfsWatchRootHost)((Object)object);
        }

        public final void reportEventLog(@NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            if (!ApplicationKt.getApplication().isInternal()) {
                return;
            }
            StringBuilder stringBuilder = eventLog.append(message2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

