/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ideaInterop.vfs;

import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rider.ideaInterop.vfs.VfsWatchPathTree;
import com.jetbrains.rider.ideaInterop.vfs.VfsWatchRootEntry;
import com.jetbrains.rider.ideaInterop.vfs.VfsWatchRootType;
import com.jetbrains.rider.ideaInterop.vfs.structure.FilePathTree;
import com.jetbrains.rider.ideaInterop.vfs.structure.FilePathTreeOperationsKt;
import com.jetbrains.rider.ideaInterop.vfs.structure.FilePathTreeVisitor;
import com.jetbrains.rider.ideaInterop.vfs.structure.VisitResult;
import java.io.File;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0005J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0005J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u0011J\u000e\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bR\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchPathTree;", "", "()V", "requestedFiles", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "tree", "Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree;", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootEntry;", "addRequestedFile", "", "file", "Ljava/io/File;", "containsRequestedFile", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "dump", "findWatchRoot", "getChildEntry", "entry", "childName", "getEntry", "removeRequestedFile", "setWatchRoot", "type", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootType;", "intellij.rider.rdclient.dotnet"})
public final class VfsWatchPathTree {
    @NotNull
    private final HashSet<String> requestedFiles = new HashSet();
    @NotNull
    private final FilePathTree<VfsWatchRootEntry> tree = new FilePathTree(tree.1.INSTANCE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addRequestedFile(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        HashSet<String> hashSet = this.requestedFiles;
        synchronized (hashSet) {
            boolean bl = false;
            bl = this.requestedFiles.add(FileUtilKt.getSystemIndependentPath((File)file2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeRequestedFile(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        HashSet<String> hashSet = this.requestedFiles;
        synchronized (hashSet) {
            boolean bl = false;
            bl = this.requestedFiles.remove(FileUtilKt.getSystemIndependentPath((File)file2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean containsRequestedFile(@NotNull VirtualFile virtualFile2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        HashSet<String> hashSet = this.requestedFiles;
        synchronized (hashSet) {
            bl = false;
            bl = this.requestedFiles.contains(virtualFile2.getPath());
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final VfsWatchRootEntry findWatchRoot(@NotNull VirtualFile virtualFile2) {
        VfsWatchRootEntry vfsWatchRootEntry;
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        FilePathTree<VfsWatchRootEntry> filePathTree = this.tree;
        synchronized (filePathTree) {
            boolean bl = false;
            File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile2);
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"virtualToIoFile(...)");
            File file3 = file2;
            Pair<VfsWatchRootEntry, File> pair2 = FilePathTreeOperationsKt.findRecursiveToRoot(this.tree, file3, findWatchRoot.1.1.INSTANCE);
            vfsWatchRootEntry = pair2 != null ? (VfsWatchRootEntry)pair2.getFirst() : null;
        }
        return vfsWatchRootEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setWatchRoot(@NotNull File file2, @NotNull VfsWatchRootType type) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        FilePathTree<VfsWatchRootEntry> filePathTree = this.tree;
        synchronized (filePathTree) {
            boolean bl = false;
            VfsWatchRootEntry vfsWatchRootEntry = this.tree.getOrCreate(file2);
            vfsWatchRootEntry.setType(type);
            this.tree.removeIfEmpty((VfsWatchRootEntry)((FilePathTree.Entry)vfsWatchRootEntry), file2);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final VfsWatchRootEntry getEntry(@NotNull VirtualFile file2) {
        VfsWatchRootEntry vfsWatchRootEntry;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        FilePathTree<VfsWatchRootEntry> filePathTree = this.tree;
        synchronized (filePathTree) {
            boolean bl = false;
            vfsWatchRootEntry = this.tree.get(file2);
        }
        return vfsWatchRootEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final VfsWatchRootEntry getChildEntry(@NotNull VfsWatchRootEntry entry2, @NotNull String childName) {
        VfsWatchRootEntry vfsWatchRootEntry;
        Intrinsics.checkNotNullParameter((Object)entry2, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)childName, (String)"childName");
        FilePathTree<VfsWatchRootEntry> filePathTree = this.tree;
        synchronized (filePathTree) {
            boolean bl = false;
            vfsWatchRootEntry = this.tree.getChild((VfsWatchRootEntry)((FilePathTree.Entry)entry2), childName);
        }
        return vfsWatchRootEntry;
    }

    @NotNull
    public final String dump() {
        var var1_1 = new FilePathTreeVisitor<VfsWatchRootEntry>(){
            @NotNull
            private final StringBuilder builder;
            {
                this.builder = new StringBuilder();
            }

            @NotNull
            public final StringBuilder getBuilder() {
                return this.builder;
            }

            @NotNull
            public Pair<VisitResult, Object> visitEntry(@NotNull File file2, @NotNull VfsWatchRootEntry entry2, @Nullable Object context2) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                Intrinsics.checkNotNullParameter((Object)entry2, (String)"entry");
                String string = !Intrinsics.areEqual((Object)file2.getName(), (Object)"") ? file2.getName() : file2.getPath();
                Integer n2 = context2 instanceof Integer ? (Integer)context2 : null;
                int n3 = n2 != null ? n2 : 1;
                Intrinsics.checkNotNull((Object)string);
                this.j(string, entry2, n3);
                return new Pair((Object)((Object)VisitResult.Continue), (Object)(n3 + 1));
            }

            private final void j(String string, VfsWatchRootEntry vfsWatchRootEntry, int n2) {
                int n3 = 1;
                if (n3 <= n2) {
                    while (true) {
                        this.builder.append(" ");
                        if (n3 == n2) break;
                        ++n3;
                    }
                }
                this.builder.append(string);
                if (vfsWatchRootEntry.getType() == VfsWatchRootType.Recursive) {
                    this.builder.append(" [Recursive]");
                }
                if (vfsWatchRootEntry.getType() == VfsWatchRootType.Flat) {
                    this.builder.append(" [Flat]");
                }
                Intrinsics.checkNotNullExpressionValue((Object)this.builder.append('\n'), (String)"append(...)");
            }
        };
        FilePathTree.visit$default(this.tree, var1_1, null, 2, null);
        String string = var1_1.getBuilder().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

