/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ideaInterop.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rider.ideaInterop.vfs.VfsIterator;
import com.jetbrains.rider.ideaInterop.vfs.VfsWatchRootFilter;
import com.jetbrains.rider.ideaInterop.vfs.VfsWatchRootHost;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.utils.threading.BackgroundProcessQueue;
import java.io.File;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0003\u0018\u0019\u001aB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\nJ\u0006\u0010\u0017\u001a\u00020\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsWarmQueue;", "", "project", "Lcom/intellij/openapi/project/Project;", "filter", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootFilter;", "parent", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootFilter;Lcom/intellij/openapi/Disposable;)V", "isReady", "", "()Z", "queue", "Lcom/jetbrains/rider/utils/threading/BackgroundProcessQueue;", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWarmQueue$Item;", "warmedFiles", "Ljava/util/HashSet;", "Ljava/io/File;", "Lkotlin/collections/HashSet;", "enqueue", "", "rootFile", "isRecursive", "startup", "Companion", "Item", "VfsWarmQueueStartupActivity", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nVfsWarmQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VfsWarmQueue.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsWarmQueue\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,85:1\n13#2:86\n*S KotlinDebug\n*F\n+ 1 VfsWarmQueue.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsWarmQueue\n*L\n24#1:86\n*E\n"})
public final class VfsWarmQueue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VfsWatchRootFilter filter;
    @NotNull
    private final Disposable parent;
    @NotNull
    private final BackgroundProcessQueue<Item> queue;
    @NotNull
    private final HashSet<File> warmedFiles;
    @NotNull
    private static final Logger logger;

    public VfsWarmQueue(@NotNull Project project2, @NotNull VfsWatchRootFilter filter2, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.project = project2;
        this.filter = filter2;
        this.parent = parent;
        this.queue = new BackgroundProcessQueue((Function1)new Function1<Item, Unit>(this){
            final /* synthetic */ VfsWarmQueue this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Item item) {
                Object object;
                String string;
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                if (ApplicationKt.getApplication().isInternal() || VfsWarmQueue.access$getLogger$cp().isTraceEnabled()) {
                    string = item.getWarmRecursive() ? "recursive" : "flat";
                    object = "Warm '" + item.getWarmFile().getPath() + "' " + string;
                    VfsWatchRootHost.Companion.reportEventLog((String)object);
                    VfsWarmQueue.access$getLogger$cp().trace((String)object);
                }
                VirtualFile virtualFile2 = VfsUtil.findFileByIoFile((File)item.getWarmFile(), (boolean)true);
                if (virtualFile2 == null) {
                    return;
                }
                object = virtualFile2;
                string = object;
                if (item.getWarmRecursive()) {
                    VfsIterator vfsIterator = VfsIterator.Companion.create(VfsWarmQueue.access$getProject$p(this.this$0));
                    if (vfsIterator != null) {
                        vfsIterator.visitChildrenRecursively((VirtualFile)string);
                    }
                } else {
                    try {
                        string.getChildren();
                    }
                    catch (InvalidVirtualFileAccessException invalidVirtualFileAccessException) {
                        // empty catch block
                    }
                }
            }
        });
        this.warmedFiles = new HashSet();
    }

    public final boolean isReady() {
        return this.queue.isReady();
    }

    public final void startup() {
        ApplicationKt.getApplication().assertIsDispatchThread();
        this.queue.enqueue(new Item(SolutionHostExtensionsKt.getSolutionDirectory(this.project), true));
    }

    public final void enqueue(@NotNull File rootFile, boolean isRecursive) {
        Intrinsics.checkNotNullParameter((Object)rootFile, (String)"rootFile");
        ApplicationKt.getApplication().assertIsDispatchThread();
        if (!this.filter.shouldWatch(rootFile) || !this.warmedFiles.add(rootFile)) {
            return;
        }
        if (ApplicationKt.getApplication().isUnitTestMode()) {
            String[] stringArray = new String[]{rootFile.getPath()};
            VfsRootAccess.allowRootAccess((Disposable)this.parent, (String[])stringArray);
        }
        this.queue.enqueue(new Item(rootFile, isRecursive));
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ Project access$getProject$p(VfsWarmQueue $this) {
        return $this.project;
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(VfsWarmQueue.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        VfsWarmQueue.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsWarmQueue$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsWarmQueue$Item;", "", "warmFile", "Ljava/io/File;", "warmRecursive", "", "(Ljava/io/File;Z)V", "getWarmFile", "()Ljava/io/File;", "getWarmRecursive", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.rider.rdclient.dotnet"})
    private static final class Item {
        @NotNull
        private final File warmFile;
        private final boolean warmRecursive;

        public Item(@NotNull File warmFile, boolean warmRecursive) {
            Intrinsics.checkNotNullParameter((Object)warmFile, (String)"warmFile");
            this.warmFile = warmFile;
            this.warmRecursive = warmRecursive;
        }

        @NotNull
        public final File getWarmFile() {
            return this.warmFile;
        }

        public final boolean getWarmRecursive() {
            return this.warmRecursive;
        }

        @NotNull
        public final File component1() {
            return this.warmFile;
        }

        public final boolean component2() {
            return this.warmRecursive;
        }

        @NotNull
        public final Item copy(@NotNull File warmFile, boolean warmRecursive) {
            Intrinsics.checkNotNullParameter((Object)warmFile, (String)"warmFile");
            return new Item(warmFile, warmRecursive);
        }

        public static /* synthetic */ Item copy$default(Item item, File file2, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                file2 = item.warmFile;
            }
            if ((n2 & 2) != 0) {
                bl = item.warmRecursive;
            }
            return item.copy(file2, bl);
        }

        @NotNull
        public String toString() {
            return "Item(warmFile=" + this.warmFile + ", warmRecursive=" + this.warmRecursive + ")";
        }

        public int hashCode() {
            int n2 = this.warmFile.hashCode();
            n2 = n2 * 31 + Boolean.hashCode(this.warmRecursive);
            return n2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Item)) {
                return false;
            }
            Item item = (Item)other;
            if (!Intrinsics.areEqual((Object)this.warmFile, (Object)item.warmFile)) {
                return false;
            }
            return this.warmRecursive == item.warmRecursive;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsWarmQueue$VfsWarmQueueStartupActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rider.rdclient.dotnet"})
    public static final class VfsWarmQueueStartupActivity
    implements ProjectActivity,
    DumbAware {
        @Nullable
        public Object execute(@NotNull Project project2, @NotNull Continuation<? super Unit> $completion) {
            Object object = RdCoroutinesUtilKt.withUiContext$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project2, null){
                int label;
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            VfsWatchRootHost.Companion.getInstance(this.$project).startup();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion, (int)1, null);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
    }
}

