/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ideaInterop.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IViewableMap;
import com.jetbrains.rider.ideaInterop.vfs.VfsDeltaCollector;
import com.jetbrains.rider.ideaInterop.vfs.VfsListener;
import com.jetbrains.rider.ideaInterop.vfs.VfsWatchPathTree;
import com.jetbrains.rider.ideaInterop.vfs.VfsWatchRootType;
import com.jetbrains.rider.model.FileSystemModel;
import com.jetbrains.rider.model.FileSystemModel_PregeneratedKt;
import com.jetbrains.rider.model.RdDelta;
import com.jetbrains.rider.model.RdDeltaBatch;
import com.jetbrains.rider.model.RdDeltaType;
import com.jetbrains.rider.model.RdWatchRootInfo;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0003\u0018\u0019\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u001a\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsListener;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "fileSystemModel", "Lcom/jetbrains/rider/model/FileSystemModel;", "j", "()Lcom/jetbrains/rider/model/FileSystemModel;", "index", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchPathTree;", "listener", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsListener$VfsAsyncListener;", "dump", "", "finishRefreshRequest", "", "file", "Ljava/io/File;", "startRefreshRequest", "j", "path", "rootInfo", "Lcom/jetbrains/rider/model/RdWatchRootInfo;", "Companion", "FileSystemModelListener", "VfsAsyncListener", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nVfsListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VfsListener.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsListener\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,147:1\n13#2:148\n13#3:149\n*S KotlinDebug\n*F\n+ 1 VfsListener.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsListener\n*L\n32#1:148\n32#1:149\n*E\n"})
public final class VfsListener
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VfsWatchPathTree index;
    @NotNull
    private final VfsAsyncListener listener;
    @NotNull
    private static final Logger logger;

    public VfsListener(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.index = new VfsWatchPathTree();
        this.listener = new VfsAsyncListener((Lazy<FileSystemModel>)LazyKt.lazy((Function0)((Function0)new Function0<FileSystemModel>(this){
            final /* synthetic */ VfsListener this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final FileSystemModel invoke() {
                return VfsListener.access$getFileSystemModel(this.this$0);
            }
        })), this.index);
        Disposable disposable = LifetimeDisposableExKt.createNestedDisposable((Lifetime)this.getServiceLifetime(), (String)"VfsListener");
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance(...)");
        VirtualFileManager virtualFileManager2 = virtualFileManager;
        virtualFileManager2.addAsyncFileListener((AsyncFileListener)this.listener, disposable);
        virtualFileManager2.addVirtualFileManagerListener((VirtualFileManagerListener)this.listener, disposable);
    }

    private final FileSystemModel j() {
        return FileSystemModel_PregeneratedKt.getFileSystemModel(SolutionHostExtensionsKt.getSolution(this.project));
    }

    @NotNull
    public final String dump() {
        return this.index.dump();
    }

    public final void startRefreshRequest(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        logger.trace("StartRefreshRequest: " + file2);
        this.index.addRequestedFile(file2);
    }

    public final void finishRefreshRequest(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        logger.trace("FinishRefreshRequest: " + file2);
        this.index.removeRequestedFile(file2);
    }

    private final void j(String string, RdWatchRootInfo rdWatchRootInfo) {
        ApplicationKt.getApplication().assertIsDispatchThread();
        if (!this.project.isOpen()) {
            return;
        }
        File file2 = new File(string);
        VfsWatchRootType vfsWatchRootType = rdWatchRootInfo == null ? VfsWatchRootType.None : (rdWatchRootInfo.isRecursive() ? VfsWatchRootType.Recursive : VfsWatchRootType.Flat);
        this.index.setWatchRoot(file2, vfsWatchRootType);
    }

    public static final /* synthetic */ void access$watchRootsHandler(VfsListener $this, String path, RdWatchRootInfo rootInfo) {
        $this.j(path, rootInfo);
    }

    public static final /* synthetic */ FileSystemModel access$getFileSystemModel(VfsListener $this) {
        return $this.j();
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getInstance(VfsListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        VfsListener.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsListener$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsListener;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nVfsListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VfsListener.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsListener$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,147:1\n31#2,2:148\n*S KotlinDebug\n*F\n+ 1 VfsListener.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsListener$Companion\n*L\n31#1:148,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VfsListener getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager componentManager = (ComponentManager)project2;
            boolean bl = false;
            Class<VfsListener> clazz = VfsListener.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (VfsListener)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsListener$FileSystemModelListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rider/model/FileSystemModel;", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.rider.rdclient.dotnet"})
    public static final class FileSystemModelListener
    implements SolutionExtListener<FileSystemModel> {
        public void extensionCreated(@NotNull Lifetime lifetime2, @NotNull ClientProjectSession session2, @NotNull FileSystemModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
            model.getWatchRoots().advise(lifetime2, (Function1)new Function1<IViewableMap.Event<String, ? extends RdWatchRootInfo>, Unit>(session2){
                final /* synthetic */ ClientProjectSession $session;
                {
                    this.$session = $session;
                    super(1);
                }

                public final void invoke(@NotNull IViewableMap.Event<String, RdWatchRootInfo> e2) {
                    Intrinsics.checkNotNullParameter(e2, (String)"e");
                    VfsListener.access$watchRootsHandler(VfsListener.Companion.getInstance(this.$session.getProject()), (String)e2.getKey(), (RdWatchRootInfo)e2.getNewValueOpt());
                }
            });
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\nH\u0016J\u0016\u0010\u0015\u001a\u00020\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0017H\u0002R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsListener$VfsAsyncListener;", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "Lcom/intellij/openapi/vfs/VirtualFileManagerListener;", "fileSystemModel", "Lkotlin/Lazy;", "Lcom/jetbrains/rider/model/FileSystemModel;", "index", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchPathTree;", "(Lkotlin/Lazy;Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchPathTree;)V", "accumulator", "", "Lcom/jetbrains/rider/model/RdDelta;", "afterRefreshFinish", "", "asynchronous", "", "beforeRefreshStart", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "j", "batchChanges", "", "intellij.rider.rdclient.dotnet"})
    public static final class VfsAsyncListener
    implements AsyncFileListener,
    VirtualFileManagerListener {
        @NotNull
        private final Lazy<FileSystemModel> fileSystemModel;
        @NotNull
        private final VfsWatchPathTree index;
        @Nullable
        private List<RdDelta> accumulator;

        public VfsAsyncListener(@NotNull Lazy<FileSystemModel> fileSystemModel2, @NotNull VfsWatchPathTree index2) {
            Intrinsics.checkNotNullParameter(fileSystemModel2, (String)"fileSystemModel");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            this.fileSystemModel = fileSystemModel2;
            this.index = index2;
        }

        @NotNull
        public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            VfsDeltaCollector vfsDeltaCollector = new VfsDeltaCollector(this.index);
            BulkVirtualFileListenerAdapter bulkVirtualFileListenerAdapter = new BulkVirtualFileListenerAdapter((VirtualFileListener)vfsDeltaCollector);
            bulkVirtualFileListenerAdapter.before(events);
            return new AsyncFileListener.ChangeApplier(bulkVirtualFileListenerAdapter, events, vfsDeltaCollector, this){
                final /* synthetic */ BulkVirtualFileListenerAdapter $bulkListener;
                final /* synthetic */ List<? extends VFileEvent> $events;
                final /* synthetic */ VfsDeltaCollector $collector;
                final /* synthetic */ VfsAsyncListener this$0;
                {
                    this.$bulkListener = $bulkListener;
                    this.$events = $events;
                    this.$collector = $collector;
                    this.this$0 = $receiver;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterVfsChange() {
                    Object object;
                    ApplicationKt.getApplication().assertIsDispatchThread();
                    this.$bulkListener.after(this.$events);
                    List list = new ArrayList<E>();
                    for (Map.Entry<K, V> object22 : ((Map)this.$collector.getDeltas()).entrySet()) {
                        String bl = (String)object22.getKey();
                        object = (RdDeltaType)((Object)object22.getValue());
                        list.add(new RdDelta(bl, (RdDeltaType)((Object)object)));
                    }
                    VfsAsyncListener vfsAsyncListener = this.this$0;
                    prepareChange.1 var3_4 = this;
                    synchronized (var3_4) {
                        Object object2;
                        boolean object4 = false;
                        object = VfsAsyncListener.access$getAccumulator$p(vfsAsyncListener);
                        if (object != null) {
                            object2 = object.addAll(list);
                        } else {
                            VfsAsyncListener.access$send(vfsAsyncListener, list);
                            object2 = Unit.INSTANCE;
                        }
                        Object object3 = object2;
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeRefreshStart(boolean asynchronous) {
            ApplicationKt.getApplication().assertIsDispatchThread();
            VfsAsyncListener vfsAsyncListener = this;
            synchronized (vfsAsyncListener) {
                boolean bl = false;
                if (this.accumulator == null) {
                    this.accumulator = new ArrayList();
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterRefreshFinish(boolean asynchronous) {
            ApplicationKt.getApplication().assertIsDispatchThread();
            VfsAsyncListener vfsAsyncListener = this;
            synchronized (vfsAsyncListener) {
                boolean bl = false;
                List list = this.accumulator;
                if (list == null) {
                    list = new ArrayList();
                }
                List list2 = list;
                this.j(list2);
                this.accumulator = null;
                Unit unit = Unit.INSTANCE;
            }
        }

        private final void j(List<RdDelta> list) {
            if (!CollectionsKt.any((Iterable)list)) {
                return;
            }
            if (logger.isTraceEnabled()) {
                for (RdDelta rdDelta : list) {
                    logger.trace(rdDelta.getType() + " '" + rdDelta.getPath() + "'");
                }
            }
            RdDeltaBatch rdDeltaBatch = new RdDeltaBatch(list);
            ((FileSystemModel)((Object)this.fileSystemModel.getValue())).getChange().fire((Object)rdDeltaBatch);
        }

        public static final /* synthetic */ List access$getAccumulator$p(VfsAsyncListener $this) {
            return $this.accumulator;
        }

        public static final /* synthetic */ void access$send(VfsAsyncListener $this, List batchChanges) {
            $this.j(batchChanges);
        }
    }
}

