/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ideaInterop.vfs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rider.ideaInterop.vfs.VfsWatchPathTree;
import com.jetbrains.rider.ideaInterop.vfs.VfsWatchRootEntry;
import com.jetbrains.rider.ideaInterop.vfs.VfsWatchRootType;
import com.jetbrains.rider.model.RdDeltaType;
import com.jetbrains.rider.vfs.VfsIgnoreChangesRequester;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u0000 )2\u00020\u0001:\u0001)B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0019H\u0016J\u0018\u0010!\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J \u0010\"\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u001bH\u0016J\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00110'*\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010(R-\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006*"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsDeltaCollector;", "Lcom/intellij/openapi/vfs/VirtualFileListener;", "index", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchPathTree;", "(Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchPathTree;)V", "deltas", "Ljava/util/LinkedHashMap;", "", "Lcom/jetbrains/rider/model/RdDeltaType;", "Lkotlin/collections/LinkedHashMap;", "getDeltas", "()Ljava/util/LinkedHashMap;", "getIndex", "()Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchPathTree;", "N", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "type", "v", "j", "beforeFileDeletion", "event", "Lcom/intellij/openapi/vfs/VirtualFileEvent;", "beforeFileMovement", "Lcom/intellij/openapi/vfs/VirtualFileMoveEvent;", "beforePropertyChange", "Lcom/intellij/openapi/vfs/VirtualFilePropertyEvent;", "contentsChanged", "fileCopied", "Lcom/intellij/openapi/vfs/VirtualFileCopyEvent;", "fileCreated", "fileMoved", "w", "j", "entry", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootEntry;", "propertyChanged", "j", "", "(Lcom/intellij/openapi/vfs/VirtualFile;)[Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nVfsDeltaCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VfsDeltaCollector.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsDeltaCollector\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,209:1\n65#2,4:210\n65#2,4:214\n65#2,4:218\n13#2:223\n13#3:222\n*S KotlinDebug\n*F\n+ 1 VfsDeltaCollector.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsDeltaCollector\n*L\n75#1:210,4\n79#1:214,4\n84#1:218,4\n13#1:223\n13#1:222\n*E\n"})
public final class VfsDeltaCollector
implements VirtualFileListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VfsWatchPathTree index;
    @NotNull
    private final LinkedHashMap<String, RdDeltaType> deltas;
    @NotNull
    private static final Logger logger;

    public VfsDeltaCollector(@NotNull VfsWatchPathTree index2) {
        Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
        this.index = index2;
        this.deltas = new LinkedHashMap();
    }

    @NotNull
    public final VfsWatchPathTree getIndex() {
        return this.index;
    }

    @NotNull
    public final LinkedHashMap<String, RdDeltaType> getDeltas() {
        return this.deltas;
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getRequestor() instanceof VfsIgnoreChangesRequester) {
            return;
        }
        VirtualFile virtualFile2 = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
        this.j(virtualFile2, RdDeltaType.Created);
    }

    public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getRequestor() instanceof VfsIgnoreChangesRequester) {
            return;
        }
        VirtualFile virtualFile2 = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
        this.j(virtualFile2, RdDeltaType.Deleted);
    }

    public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getRequestor() instanceof VfsIgnoreChangesRequester) {
            return;
        }
        VirtualFile virtualFile2 = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
        this.j(virtualFile2, RdDeltaType.Deleted);
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getRequestor() instanceof VfsIgnoreChangesRequester) {
            return;
        }
        VirtualFile virtualFile2 = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
        this.j(virtualFile2, RdDeltaType.Created);
    }

    public void fileCopied(@NotNull VirtualFileCopyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getRequestor() instanceof VfsIgnoreChangesRequester) {
            return;
        }
        VirtualFile virtualFile2 = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
        this.j(virtualFile2, RdDeltaType.Created);
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getRequestor() instanceof VfsIgnoreChangesRequester) {
            return;
        }
        VirtualFile virtualFile2 = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
        this.N(virtualFile2, RdDeltaType.Changed);
    }

    public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getRequestor() instanceof VfsIgnoreChangesRequester) {
            return;
        }
        if (Intrinsics.areEqual((Object)event.getPropertyName(), (Object)"name")) {
            VirtualFile virtualFile2 = event.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
            this.N(virtualFile2, RdDeltaType.Deleted);
        }
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getRequestor() instanceof VfsIgnoreChangesRequester) {
            return;
        }
        VirtualFile virtualFile2 = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
        VirtualFile virtualFile3 = virtualFile2;
        if (Intrinsics.areEqual((Object)event.getPropertyName(), (Object)"name")) {
            if (virtualFile3.isDirectory()) {
                this.j(virtualFile3, RdDeltaType.Created);
            } else {
                this.N(virtualFile3, RdDeltaType.Created);
            }
        } else {
            this.N(virtualFile3, RdDeltaType.Changed);
        }
    }

    private final void N(VirtualFile virtualFile2, RdDeltaType rdDeltaType) {
        if (this.index.findWatchRoot(virtualFile2) != null || this.index.containsRequestedFile(virtualFile2)) {
            Logger logger = VfsDeltaCollector.logger;
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("Process " + virtualFile2 + " with type " + rdDeltaType.name());
            }
            this.v(virtualFile2, rdDeltaType);
        } else {
            Logger logger = VfsDeltaCollector.logger;
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger3 = logger;
                boolean bl3 = false;
                logger3.trace("Skip " + virtualFile2 + " with type " + rdDeltaType.name() + ", no watch root found");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void j(VirtualFile virtualFile2, RdDeltaType rdDeltaType) {
        Logger logger = VfsDeltaCollector.logger;
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace("Recursively process " + virtualFile2);
        }
        long l2 = System.currentTimeMillis();
        try {
            VfsWatchRootEntry vfsWatchRootEntry;
            VfsWatchRootEntry vfsWatchRootEntry2 = this.index.findWatchRoot(virtualFile2);
            if (vfsWatchRootEntry2 != null && vfsWatchRootEntry2.getType() == VfsWatchRootType.Recursive) {
                this.v(virtualFile2, rdDeltaType);
                this.w(virtualFile2, rdDeltaType);
                return;
            }
            if (vfsWatchRootEntry2 != null && vfsWatchRootEntry2.getType() == VfsWatchRootType.Flat) {
                this.v(virtualFile2, rdDeltaType);
            }
            if (this.index.getEntry(virtualFile2) == null) {
                return;
            }
            VfsWatchRootEntry vfsWatchRootEntry3 = vfsWatchRootEntry;
            this.j(virtualFile2, rdDeltaType, vfsWatchRootEntry3);
        }
        finally {
            int n2 = 200;
            long l3 = System.currentTimeMillis() - l2;
            if (l3 > (long)n2 && !ApplicationKt.getApplication().isUnitTestMode()) {
                VfsDeltaCollector.logger.warn("Recursively process " + virtualFile2 + " took " + l3 + " ms, threshold " + n2 + " ms");
            }
        }
    }

    private final void j(VirtualFile virtualFile2, RdDeltaType rdDeltaType, VfsWatchRootEntry vfsWatchRootEntry) {
        if (this.index.containsRequestedFile(virtualFile2)) {
            this.v(virtualFile2, rdDeltaType);
        }
        for (VirtualFile virtualFile3 : this.j(virtualFile2)) {
            VfsWatchRootEntry vfsWatchRootEntry2;
            if (vfsWatchRootEntry.getType() == VfsWatchRootType.Flat) {
                this.v(virtualFile3, rdDeltaType);
            }
            String string = virtualFile3.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (this.index.getChildEntry(vfsWatchRootEntry, string) == null) continue;
            if (vfsWatchRootEntry2.getType() == VfsWatchRootType.Recursive) {
                this.v(virtualFile3, rdDeltaType);
                this.w(virtualFile3, rdDeltaType);
                continue;
            }
            if (vfsWatchRootEntry2.getType() == VfsWatchRootType.Flat) {
                this.v(virtualFile3, rdDeltaType);
            }
            this.j(virtualFile3, rdDeltaType, vfsWatchRootEntry2);
        }
    }

    private final void w(VirtualFile virtualFile2, RdDeltaType rdDeltaType) {
        for (VirtualFile virtualFile3 : this.j(virtualFile2)) {
            this.v(virtualFile3, rdDeltaType);
            this.w(virtualFile3, rdDeltaType);
        }
    }

    private final VirtualFile[] j(VirtualFile virtualFile2) {
        VirtualFile[] virtualFileArray;
        try {
            virtualFileArray = virtualFile2.getChildren();
            Intrinsics.checkNotNull((Object)virtualFileArray);
        }
        catch (InvalidVirtualFileAccessException invalidVirtualFileAccessException) {
            virtualFileArray = new VirtualFile[]{};
        }
        return virtualFileArray;
    }

    private final void v(VirtualFile virtualFile2, RdDeltaType rdDeltaType) {
        String string = virtualFile2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String string2 = string;
        RdDeltaType rdDeltaType2 = this.deltas.get(string2);
        if (rdDeltaType2 == RdDeltaType.Created) {
            switch (WhenMappings.$EnumSwitchMapping$0[rdDeltaType.ordinal()]) {
                case 1: {
                    this.deltas.remove(string2);
                }
            }
            return;
        }
        if (rdDeltaType2 == RdDeltaType.Deleted) {
            switch (WhenMappings.$EnumSwitchMapping$0[rdDeltaType.ordinal()]) {
                case 3: {
                    ((Map)this.deltas).put(string2, RdDeltaType.Changed);
                }
            }
            return;
        }
        if (rdDeltaType2 == RdDeltaType.Changed) {
            switch (WhenMappings.$EnumSwitchMapping$0[rdDeltaType.ordinal()]) {
                case 3: {
                    break;
                }
                case 1: {
                    ((Map)this.deltas).put(string2, RdDeltaType.Deleted);
                }
            }
            return;
        }
        ((Map)this.deltas).put(string2, rdDeltaType);
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getInstance(VfsDeltaCollector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        VfsDeltaCollector.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsDeltaCollector$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RdDeltaType.values().length];
            try {
                nArray[RdDeltaType.Deleted.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdDeltaType.Changed.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdDeltaType.Created.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

