/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.encoding;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.encoding.EncodingManagerListener;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.ide.model.SettingsModel;
import com.jetbrains.rd.ide.model.SettingsModel_GeneratedKt;
import com.jetbrains.rd.platform.util.idea.ProtocolSubscribedProjectComponent;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rider.encoding.FileEncodingSyncKt;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\u00020\u000f2\u0014\u0010\u0015\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00130\u0016H\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/encoding/FileEncodingSync;", "Lcom/jetbrains/rd/platform/util/idea/ProtocolSubscribedProjectComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "encodingMgr", "Lcom/intellij/openapi/vfs/encoding/EncodingProjectManager;", "kotlin.jvm.PlatformType", "settingsModel", "Lcom/jetbrains/rd/ide/model/SettingsModel;", "j", "()Lcom/jetbrains/rd/ide/model/SettingsModel;", "settingsModel$delegate", "Lkotlin/Lazy;", "j", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "encoding", "Ljava/nio/charset/Charset;", "j", "encodings", "", "DefaultEncodingChangeListener", "EncodingChangeListener", "intellij.rider.rdclient.dotnet"})
public final class FileEncodingSync
extends ProtocolSubscribedProjectComponent {
    @NotNull
    private final Lazy settingsModel$delegate;
    private final EncodingProjectManager encodingMgr;

    public FileEncodingSync(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(project2);
        this.settingsModel$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SettingsModel>(project2){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(0);
            }

            @NotNull
            public final SettingsModel invoke() {
                return SettingsModel_GeneratedKt.getSettingsModel((IProtocol)ApplicationProtocolKt.getProtocolHost(this.$project).getProtocol());
            }
        }));
        this.encodingMgr = EncodingProjectManager.getInstance((Project)project2);
        EncodingProjectManager encodingProjectManager = this.encodingMgr;
        EncodingProjectManagerImpl encodingProjectManagerImpl = encodingProjectManager instanceof EncodingProjectManagerImpl ? (EncodingProjectManagerImpl)encodingProjectManager : null;
        Map map = encodingProjectManagerImpl != null ? encodingProjectManagerImpl.getAllMappings() : null;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map map2 = map;
        IOptProperty iOptProperty = this.j().getDefaultEncoding();
        Charset charset = this.encodingMgr.getDefaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getDefaultCharset(...)");
        iOptProperty.set((Object)FileEncodingSyncKt.access$convert(charset, false));
        this.j(map2);
        MessageBusConnection messageBusConnection = project2.getMessageBus().connect((Disposable)this);
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        EncodingProjectManager encodingProjectManager2 = this.encodingMgr;
        Intrinsics.checkNotNullExpressionValue((Object)encodingProjectManager2, (String)"encodingMgr");
        messageBusConnection.subscribe(topic, (Object)new BulkVirtualFileListenerAdapter((VirtualFileListener)new EncodingChangeListener(encodingProjectManager2)));
        MessageBusConnection messageBusConnection2 = project2.getMessageBus().connect((Disposable)this);
        Topic topic2 = EncodingManagerListener.ENCODING_MANAGER_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"ENCODING_MANAGER_CHANGES");
        messageBusConnection2.subscribe(topic2, (Object)new DefaultEncodingChangeListener());
    }

    private final SettingsModel j() {
        Lazy lazy = this.settingsModel$delegate;
        return (SettingsModel)lazy.getValue();
    }

    private final void j(VirtualFile virtualFile2, Charset charset) {
        String string = FileUtil.toSystemDependentName((String)virtualFile2.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
        String string2 = string;
        ((Map)this.j().getFileEncodings()).put(string2, FileEncodingSyncKt.access$convert(charset, virtualFile2.getBOM() != null));
    }

    private final void j(Map<? extends VirtualFile, ? extends Charset> map) {
        for (Map.Entry<? extends VirtualFile, ? extends Charset> entry2 : map.entrySet()) {
            VirtualFile virtualFile2 = entry2.getKey();
            Charset charset = entry2.getValue();
            VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
            VfsUtilCore.visitChildrenRecursively((VirtualFile)virtualFile2, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Unit>(this, charset, optionArray){
                final /* synthetic */ FileEncodingSync this$0;
                final /* synthetic */ Charset $encoding;
                {
                    this.this$0 = $receiver;
                    this.$encoding = $encoding;
                    super($super_call_param$1);
                }

                public boolean visitFile(@NotNull VirtualFile file2) {
                    Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                    if (VirtualFileUtil.isFile((VirtualFile)file2)) {
                        FileEncodingSync.access$synchronizeEncoding(this.this$0, file2, this.$encoding);
                    }
                    return true;
                }
            }));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/encoding/FileEncodingSync$DefaultEncodingChangeListener;", "Lcom/intellij/openapi/vfs/encoding/EncodingManagerListener;", "(Lcom/jetbrains/rider/encoding/FileEncodingSync;)V", "propertyChanged", "", "document", "Lcom/intellij/openapi/editor/Document;", "propertyName", "", "oldValue", "", "newValue", "intellij.rider.rdclient.dotnet"})
    private final class DefaultEncodingChangeListener
    implements EncodingManagerListener {
        public void propertyChanged(@Nullable Document document, @NotNull String propertyName, @Nullable Object oldValue, @Nullable Object newValue) {
            Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
            if (Intrinsics.areEqual((Object)"defaultFilesEncoding", (Object)propertyName)) {
                IOptProperty iOptProperty = FileEncodingSync.this.j().getDefaultEncoding();
                Charset charset = FileEncodingSync.this.encodingMgr.getDefaultCharset();
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getDefaultCharset(...)");
                iOptProperty.set((Object)FileEncodingSyncKt.access$convert(charset, false));
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/encoding/FileEncodingSync$EncodingChangeListener;", "Lcom/intellij/openapi/vfs/VirtualFileListener;", "encodingMgr", "Lcom/intellij/openapi/vfs/encoding/EncodingProjectManager;", "(Lcom/jetbrains/rider/encoding/FileEncodingSync;Lcom/intellij/openapi/vfs/encoding/EncodingProjectManager;)V", "fileCopied", "", "event", "Lcom/intellij/openapi/vfs/VirtualFileCopyEvent;", "fileDeleted", "Lcom/intellij/openapi/vfs/VirtualFileEvent;", "propertyChanged", "Lcom/intellij/openapi/vfs/VirtualFilePropertyEvent;", "j", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.rider.rdclient.dotnet"})
    private final class EncodingChangeListener
    implements VirtualFileListener {
        @NotNull
        private final EncodingProjectManager encodingMgr;

        public EncodingChangeListener(EncodingProjectManager encodingMgr) {
            Intrinsics.checkNotNullParameter((Object)encodingMgr, (String)"encodingMgr");
            this.encodingMgr = encodingMgr;
        }

        private final void j(VirtualFile virtualFile2) {
            String string = FileUtil.toSystemDependentName((String)virtualFile2.getPath());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
            String string2 = string;
            FileEncodingSync.this.j().getFileEncodings().remove((Object)string2);
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (Intrinsics.areEqual((Object)"encoding", (Object)event.getPropertyName())) {
                Object object = event.getNewValue();
                Charset charset = object instanceof Charset ? (Charset)object : null;
                if (charset == null) {
                    return;
                }
                Charset charset2 = charset;
                VirtualFile virtualFile2 = event.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
                FileEncodingSync.this.j(virtualFile2, charset2);
            }
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            VirtualFile virtualFile2 = event.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
            VirtualFile virtualFile3 = virtualFile2;
            if (!VirtualFileUtil.isFile((VirtualFile)virtualFile3)) {
                return;
            }
            Charset charset = this.encodingMgr.getEncoding(virtualFile3, false);
            if (charset == null) {
                return;
            }
            Charset charset2 = charset;
            FileEncodingSync.this.j(virtualFile3, charset2);
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            VirtualFile virtualFile2 = event.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
            this.j(virtualFile2);
        }
    }
}

