/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editors.virtualFormat;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.CachingPainter;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ObjectUtils;
import com.jetbrains.rdclient.daemon.util.StringUtilKt;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u0017\u001a\u00020\u00052\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0016J\u0014\u0010\u001a\u001a\u00020\u00052\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0016J,\u0010\u001b\u001a\u00020\u001c2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/rider/editors/virtualFormat/RiderVirtualWhitespaceRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "indentWidthInSpaces", "", "vfiAlignmentBaseOffset", "vfiEndOffset", "dots", "(Lcom/intellij/openapi/editor/Editor;IIII)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "editorFontMetrics", "Ljava/awt/FontMetrics;", "j", "()Ljava/awt/FontMetrics;", "editorFontMetrics$delegate", "Lkotlin/Lazy;", "getIndentWidthInSpaces", "()I", "myDotCacheKey", "", "Lorg/jetbrains/annotations/NotNull;", "calcHeightInPixels", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "calcWidthInPixels", "paint", "", "g", "Ljava/awt/Graphics2D;", "targetRegion", "Ljava/awt/geom/Rectangle2D;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "j", "", "value", "", "scaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderVirtualFormatterSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderVirtualFormatterSupport.kt\ncom/jetbrains/rider/editors/virtualFormat/RiderVirtualWhitespaceRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n1#2:199\n1747#3,3:200\n*S KotlinDebug\n*F\n+ 1 RiderVirtualFormatterSupport.kt\ncom/jetbrains/rider/editors/virtualFormat/RiderVirtualWhitespaceRenderer\n*L\n84#1:200,3\n*E\n"})
public final class RiderVirtualWhitespaceRenderer
implements EditorCustomElementRenderer {
    @NotNull
    private final Editor editor;
    private final int indentWidthInSpaces;
    private final int vfiAlignmentBaseOffset;
    private final int vfiEndOffset;
    private final int dots;
    @NotNull
    private final Object myDotCacheKey;
    @NotNull
    private final Lazy editorFontMetrics$delegate;

    public RiderVirtualWhitespaceRenderer(@NotNull Editor editor, int indentWidthInSpaces, int vfiAlignmentBaseOffset, int vfiEndOffset, int dots) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        this.indentWidthInSpaces = indentWidthInSpaces;
        this.vfiAlignmentBaseOffset = vfiAlignmentBaseOffset;
        this.vfiEndOffset = vfiEndOffset;
        this.dots = dots;
        Object object = ObjectUtils.sentinel((String)"inlay space symbol");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sentinel(...)");
        this.myDotCacheKey = object;
        this.editorFontMetrics$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FontMetrics>(this){
            final /* synthetic */ RiderVirtualWhitespaceRenderer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final FontMetrics invoke() {
                Font font = EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN);
                Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
                Font font2 = font;
                FontMetrics fontMetrics = this.this$0.getEditor().getContentComponent().getFontMetrics(font2);
                if (fontMetrics == null) {
                    String string = font2.getFontName();
                    Document document = this.this$0.getEditor().getDocument();
                    Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                    throw new IllegalArgumentException("Font metrics of the font " + string + " on the editor " + StringUtilKt.presentableName((Document)document) + " are null!");
                }
                return fontMetrics;
            }
        }));
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    public final int getIndentWidthInSpaces() {
        return this.indentWidthInSpaces;
    }

    private final FontMetrics j() {
        Lazy lazy = this.editorFontMetrics$delegate;
        return (FontMetrics)lazy.getValue();
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        int n2;
        int n3;
        int n4;
        Serializable serializable;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        int n5 = 0;
        if (this.vfiAlignmentBaseOffset > 0) {
            InlayModel inlayModel = this.editor.getInlayModel();
            Intrinsics.checkNotNullExpressionValue((Object)inlayModel, (String)"getInlayModel(...)");
            stringBuilder = inlayModel;
            Point point = this.editor.offsetToXY(this.vfiAlignmentBaseOffset, true, false);
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"offsetToXY(...)");
            serializable = point;
            n4 = ((Point)serializable).x;
            List list = stringBuilder.getInlineElementsInRange(this.vfiEndOffset - 1, this.vfiEndOffset);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInlineElementsInRange(...)");
            Iterable iterable = list;
            n3 = 0;
            for (Object t10 : iterable) {
                Inlay inlay2 = (Inlay)t10;
                int n6 = n3;
                boolean bl = false;
                Rectangle rectangle = inlay2.getBounds();
                int n7 = rectangle != null ? rectangle.width : 0;
                n3 = n6 + n7;
            }
            n2 = n3;
            n5 = n4 - n2;
        }
        stringBuilder = new StringBuilder();
        serializable = stringBuilder;
        FontMetrics fontMetrics = this.j();
        n4 = 0;
        n2 = this.indentWidthInSpaces;
        int n8 = 0;
        while (n8 < n2) {
            n3 = n8++;
            boolean bl = false;
            ((StringBuilder)serializable).append(' ');
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return fontMetrics.stringWidth(string) + n5;
    }

    public int calcHeightInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        return this.j().getHeight();
    }

    private final float j(double d2, ScaleContext scaleContext) {
        double d3 = 1.0 / PaintUtil.devValue((double)1.0, (ScaleContext)scaleContext);
        return (float)(PaintUtil.alignToInt((double)d2, (ScaleContext)scaleContext, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR, null) + d3 / (double)2);
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics2D g2, @NotNull Rectangle2D targetRegion, @NotNull TextAttributes textAttributes) {
        boolean bl;
        int n2;
        Iterable iterable;
        block5: {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Intrinsics.checkNotNullParameter((Object)g2, (String)"g");
            Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
            Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
            int n3 = this.editor.getDocument().getLineNumber(inlay.getOffset() + 1);
            List list = this.editor.getCaretModel().getAllCarets();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
            iterable = list;
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                v1 = false;
            } else {
                for (Object t10 : iterable) {
                    Caret caret = (Caret)t10;
                    n2 = 0;
                    if (!(this.editor.getDocument().getLineNumber(caret.getOffset()) == n3)) continue;
                    v1 = true;
                    break block5;
                }
                v1 = bl = false;
            }
        }
        if (bl) {
            iterable = ScaleContext.Companion.create();
            Color color = this.editor.getColorsScheme().getColor(EditorColors.WHITESPACES_COLOR);
            float f2 = (float)this.editor.getColorsScheme().getEditorFontSize() / (float)FontPreferences.DEFAULT_FONT_SIZE;
            double d2 = targetRegion.getWidth() / (double)this.dots;
            int n4 = this.dots;
            for (n2 = 0; n2 < n4; ++n2) {
                double d3 = targetRegion.getX() + (double)n2 * d2;
                double d4 = targetRegion.getX() + (double)(n2 + 1) * d2;
                float f3 = this.j((d3 + d4) / 2.0, (ScaleContext)iterable) - f2 / (float)2;
                float f4 = this.j(targetRegion.getY() + targetRegion.getHeight() / 2.0, (ScaleContext)iterable) - f2 / (float)2;
                Object[] objectArray = new Object[]{color};
                CachingPainter.paint((Graphics2D)g2, (float)f3, (float)f4, (float)f2, (float)f2, arg_0 -> RiderVirtualWhitespaceRenderer.j((Function1)new Function1<Graphics2D, Unit>(targetRegion, color, f2){
                    final /* synthetic */ Rectangle2D $targetRegion;
                    final /* synthetic */ Color $whitespacesColor;
                    final /* synthetic */ float $fontSizeDotScale;
                    {
                        this.$targetRegion = $targetRegion;
                        this.$whitespacesColor = $whitespacesColor;
                        this.$fontSizeDotScale = $fontSizeDotScale;
                        super(1);
                    }

                    public final void invoke(Graphics2D it) {
                        it.setColor(new Color(0, 0, 0, 0));
                        it.fill(this.$targetRegion);
                        it.setColor(this.$whitespacesColor);
                        it.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        it.fill(new Ellipse2D.Float(0.0f, 0.0f, this.$fontSizeDotScale, this.$fontSizeDotScale));
                    }
                }, arg_0), (Object)this.myDotCacheKey, (Object[])objectArray);
            }
        }
    }

    private static final void j(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        function1.invoke(object);
    }
}

