/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editors.virtualFormat;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapterListener;
import com.jetbrains.rdclient.editors.FrontendTextControlHost;
import com.jetbrains.rider.editors.virtualFormat.RiderVirtualFormatterListenerAggregatorKt;
import com.jetbrains.rider.editors.virtualFormat.RiderVirtualFormatterModelAdapter;
import com.jetbrains.rider.editors.virtualFormat.RiderVirtualFormatting;
import com.jetbrains.rider.editors.virtualFormat.VirtualFormattingApplicationStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000C\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006*\u0001\f\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J(\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001bH\u0016J\u0016\u0010\u001f\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0016J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/rider/editors/virtualFormat/RiderVirtualFormatterModelAdapter;", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapterListener;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "myUpdateVirtualFormatterTask", "com/jetbrains/rider/editors/virtualFormat/RiderVirtualFormatterModelAdapter$myUpdateVirtualFormatterTask$1", "Lcom/jetbrains/rider/editors/virtualFormat/RiderVirtualFormatterModelAdapter$myUpdateVirtualFormatterTask$1;", "myVirtualFormatterAlarm", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "afterAdded", "", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "afterBulkAdd", "highlighters", "", "afterRemoved", "afterUpdated", "attributesChanged", "renderersChanged", "", "fontStyleOrColorChanged", "fontStyleChanged", "foregroundColorChanged", "beforeBulkRemove", "beforeRemoved", "intellij.rider.rdclient.dotnet"})
public final class RiderVirtualFormatterModelAdapter
implements FrontendMarkupAdapterListener {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final MergingUpdateQueue myVirtualFormatterAlarm;
    @NotNull
    private final myUpdateVirtualFormatterTask.1 myUpdateVirtualFormatterTask;

    public RiderVirtualFormatterModelAdapter(@NotNull Lifetime lifetime2, @NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.lifetime = lifetime2;
        this.editor = editor;
        this.myVirtualFormatterAlarm = new MergingUpdateQueue("RiderVirtualFormatterAdapterUpdates", 100, true, MergingUpdateQueue.ANY_COMPONENT, LifetimeDisposableExKt.createNestedDisposable((Lifetime)this.lifetime, (String)"RiderVirtualFormatterQueue"), null, Alarm.ThreadToUse.POOLED_THREAD);
        this.myUpdateVirtualFormatterTask = new Update(this){
            final /* synthetic */ RiderVirtualFormatterModelAdapter this$0;
            {
                this.this$0 = $receiver;
                super((Object)"Rider Virtual formatter update");
            }

            public void run() {
                RiderVirtualFormatterListenerAggregatorKt.getLOG().trace("Update alarm fired");
                Project project2 = this.this$0.getEditor().getProject();
                if (project2 == null) {
                    throw new IllegalArgumentException("Project cannot be null!");
                }
                Project project3 = project2;
                ReadAction.run(() -> myUpdateVirtualFormatterTask.1.j(project3, this.this$0));
            }

            private static final void j(Editor editor, VirtualFormattingApplicationStrategy virtualFormattingApplicationStrategy, RiderVirtualFormatterModelAdapter riderVirtualFormatterModelAdapter) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"$it");
                Intrinsics.checkNotNullParameter((Object)virtualFormattingApplicationStrategy, (String)"$regions");
                Intrinsics.checkNotNullParameter((Object)riderVirtualFormatterModelAdapter, (String)"this$0");
                if (Intrinsics.areEqual((Object)RiderVirtualFormatterListenerAggregatorKt.isRiderVirtualFormattingEnabled(editor), (Object)true) && !virtualFormattingApplicationStrategy.isEmpty()) {
                    RiderVirtualFormatting.applyVirtualFormattingToEditor((EditorImpl)editor, virtualFormattingApplicationStrategy);
                } else {
                    RiderVirtualFormatting.dropAllVirtualFormatting((Editor)riderVirtualFormatterModelAdapter.getEditor());
                }
            }

            private static final void j(Project project2, RiderVirtualFormatterModelAdapter riderVirtualFormatterModelAdapter) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)project2, (String)"$project");
                Intrinsics.checkNotNullParameter((Object)riderVirtualFormatterModelAdapter, (String)"this$0");
                Iterable iterable = FrontendTextControlHost.Companion.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession((Project)project2).getAppSession()).getEditors();
                boolean bl = false;
                Iterable iterable2 = iterable;
                Collection<T> collection2 = new ArrayList<E>();
                boolean bl2 = false;
                Iterator<T> iterator = iterable2.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    Editor editor = (Editor)object;
                    boolean bl3 = false;
                    if (!(Intrinsics.areEqual((Object)editor.getDocument(), (Object)riderVirtualFormatterModelAdapter.getEditor().getDocument()) && editor instanceof EditorImpl)) continue;
                    collection2.add(object);
                }
                iterable = (List)collection2;
                bl = false;
                for (Collection<T> collection2 : iterable) {
                    Editor editor = (Editor)collection2;
                    boolean bl4 = false;
                    Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
                    EditorImpl cfr_ignored_0 = (EditorImpl)editor;
                    object = RiderVirtualFormatting.calculateVirtualFormattingRegions((EditorImpl)editor);
                    ApplicationManager.getApplication().invokeLater(() -> myUpdateVirtualFormatterTask.1.j(editor, object, riderVirtualFormatterModelAdapter), project2.getDisposed());
                }
            }
        };
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    public void afterBulkAdd(@NotNull List<? extends RangeHighlighterEx> highlighters) {
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        this.myVirtualFormatterAlarm.queue((Update)this.myUpdateVirtualFormatterTask);
    }

    public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        this.myVirtualFormatterAlarm.queue((Update)this.myUpdateVirtualFormatterTask);
    }

    public void afterUpdated(@NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        this.myVirtualFormatterAlarm.queue((Update)this.myUpdateVirtualFormatterTask);
    }

    public void afterRemoved(@NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        this.myVirtualFormatterAlarm.queue((Update)this.myUpdateVirtualFormatterTask);
    }

    public void attributesChanged(@NotNull RangeHighlighterEx highlighter, boolean renderersChanged, boolean fontStyleChanged, boolean foregroundColorChanged) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        this.myVirtualFormatterAlarm.queue((Update)this.myUpdateVirtualFormatterTask);
    }

    public void attributesChanged(@NotNull RangeHighlighterEx highlighter, boolean renderersChanged, boolean fontStyleOrColorChanged) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        this.myVirtualFormatterAlarm.queue((Update)this.myUpdateVirtualFormatterTask);
    }

    public void beforeRemoved(@NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        this.myVirtualFormatterAlarm.queue((Update)this.myUpdateVirtualFormatterTask);
    }

    public void beforeBulkRemove(@NotNull List<? extends RangeHighlighterEx> highlighters) {
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        this.myVirtualFormatterAlarm.queue((Update)this.myUpdateVirtualFormatterTask);
    }
}

