/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editors;

import com.intellij.codeWithMe.ClientId;
import com.intellij.codeWithMe.ClientIdExKt;
import com.intellij.concurrency.client.ClientIdPropagation;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.util.ExceptionUtil;
import com.jetbrains.rd.framework.impl.RdOptionalProperty;
import com.jetbrains.rd.ide.Suppressor;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.editor.EditorSynchronizerBase;
import com.jetbrains.rd.ide.model.RdCaretModelChange;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RiderTextControlModel;
import com.jetbrains.rd.ide.model.ScrollingInfo;
import com.jetbrains.rd.ide.model.SelectionRange;
import com.jetbrains.rd.ide.model.SelectionRangeWithVersion;
import com.jetbrains.rd.ide.model.SelectionVersion;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.rdtext.ITypingSession;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHost;
import com.jetbrains.rider.document.TextBufferDocumentSynchronizer;
import com.jetbrains.rider.editors.PlatformTextControlUtilsKt;
import com.jetbrains.rider.editors.SelectionVersionExKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RiderOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 <2\u00020\u00012\u00020\u0002:\u0003<=>B/\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0011H\u0002J\u0006\u0010%\u001a\u00020#J\u0010\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020\u0018H\u0002J\u0010\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020#H\u0002J\b\u0010,\u001a\u00020#H\u0002J\b\u0010-\u001a\u00020#H\u0002J\b\u0010.\u001a\u00020#H\u0014J\u0010\u0010/\u001a\u00020#2\u0006\u0010'\u001a\u00020\u0018H\u0002J\u0010\u00100\u001a\u00020#2\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020#2\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020#2\u0006\u00107\u001a\u000208H\u0014J\u0014\u00109\u001a\b\u0012\u0004\u0012\u00020\u00110:2\u0006\u0010;\u001a\u00020\u0006R\u0014\u0010\u000e\u001a\b\u0018\u00010\u000fR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006?"}, d2={"Lcom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession;", "Lcom/jetbrains/rd/ide/editor/EditorSynchronizerBase;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "textControlLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/Editor;", "textControlId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "editorModel", "Lcom/jetbrains/rd/ide/model/RiderTextControlModel;", "(Lcom/intellij/openapi/client/ClientAppSession;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rd/ide/model/TextControlId;Lcom/jetbrains/rd/ide/model/RiderTextControlModel;)V", "activeTypingSession", "Lcom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession$FrontendEditorTypingSession;", "currentSelection", "Lcom/jetbrains/rd/ide/model/SelectionRange;", "dontReceiveChanges", "", "getEditorModel", "()Lcom/jetbrains/rd/ide/model/RiderTextControlModel;", "queuedChanges", "", "Lcom/jetbrains/rd/ide/model/SelectionRangeWithVersion;", "suppressor", "Lcom/jetbrains/rd/ide/Suppressor;", "getSuppressor", "()Lcom/jetbrains/rd/ide/Suppressor;", "<set-?>", "Lcom/jetbrains/rd/ide/model/SelectionVersion;", "version", "getVersion", "()Lcom/jetbrains/rd/ide/model/SelectionVersion;", "j", "", "backendSelection", "assertEmptyChangesQueue", "j", "model", "documentChanged", "e", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "t", "w", "v", "init", "N", "receiveScrollingRequest", "request", "Lcom/jetbrains/rd/ide/model/ScrollingInfo;", "receiveSelection", "change", "Lcom/jetbrains/rd/ide/model/RdCaretModelChange;", "sendCaretStateChange", "reason", "", "startTypingSession", "Lcom/jetbrains/rd/rdtext/ITypingSession;", "lifetime", "Companion", "FrontendEditorTypingSession", "State", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nEditorSynchronizerWithTypingSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorSynchronizerWithTypingSession.kt\ncom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession\n+ 2 ClientId.kt\ncom/intellij/codeWithMe/ClientId$Companion\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,307:1\n231#2:308\n233#2,8:313\n241#2,10:325\n231#2:335\n233#2,8:356\n241#2,7:368\n250#2:379\n231#2,10:421\n241#2,10:435\n65#3,4:309\n65#3,4:321\n65#3,4:336\n65#3,4:340\n65#3,4:344\n65#3,4:348\n65#3,4:352\n65#3,4:364\n65#3,4:375\n65#3,4:380\n65#3,4:384\n65#3,4:388\n65#3,4:392\n65#3,4:396\n65#3,4:400\n58#3,5:404\n65#3,4:409\n65#3,4:413\n65#3,4:417\n65#3,4:431\n1#4:445\n*S KotlinDebug\n*F\n+ 1 EditorSynchronizerWithTypingSession.kt\ncom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession\n*L\n98#1:308\n98#1:313,8\n98#1:325,10\n111#1:335\n111#1:356,8\n111#1:368,7\n111#1:379\n220#1:421,10\n220#1:435,10\n101#1:309,4\n98#1:321,4\n112#1:336,4\n114#1:340,4\n118#1:344,4\n124#1:348,4\n135#1:352,4\n111#1:364,4\n114#1:375,4\n118#1:380,4\n124#1:384,4\n135#1:388,4\n147#1:392,4\n154#1:396,4\n166#1:400,4\n169#1:404,5\n182#1:409,4\n189#1:413,4\n198#1:417,4\n220#1:431,4\n*E\n"})
public class EditorSynchronizerWithTypingSession
extends EditorSynchronizerBase
implements DocumentListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RiderTextControlModel editorModel;
    @NotNull
    private final Suppressor suppressor;
    private boolean dontReceiveChanges;
    @NotNull
    private final List<SelectionRangeWithVersion> queuedChanges;
    @NotNull
    private SelectionVersion version;
    @NotNull
    private SelectionRange currentSelection;
    @Nullable
    private FrontendEditorTypingSession activeTypingSession;
    @NotNull
    public static final String PARANOID_CATEGORY = "#com.jetbrains.rider.editors@paranoid";
    @NotNull
    private static final Logger paranoidLogger;

    protected EditorSynchronizerWithTypingSession(@NotNull ClientAppSession session2, @NotNull Lifetime textControlLifetime, @NotNull Editor editor, @NotNull TextControlId textControlId, @NotNull RiderTextControlModel editorModel) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)textControlLifetime, (String)"textControlLifetime");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
        Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
        super(session2, textControlLifetime, textControlId, (TextControlModel)editorModel, editor);
        this.editorModel = editorModel;
        this.suppressor = new Suppressor();
        this.queuedChanges = new ArrayList();
        this.version = SelectionVersionExKt.getInitVersion();
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        this.currentSelection = PlatformTextControlUtilsKt.createSelectionRange(caretModel);
    }

    @NotNull
    public RiderTextControlModel getEditorModel() {
        return this.editorModel;
    }

    @NotNull
    public final Suppressor getSuppressor() {
        return this.suppressor;
    }

    @NotNull
    public final SelectionVersion getVersion() {
        return this.version;
    }

    protected void init() {
        ClientIdExKt.assertClientIdConsistency((ClientId)new ClientId(this.getTextControlId().getClientId()), (String)"FrontendEditorSynchronizer");
        IOptProperty iOptProperty = this.getEditorModel().getSelection();
        Intrinsics.checkNotNull((Object)iOptProperty, (String)"null cannot be cast to non-null type com.jetbrains.rd.framework.impl.RdOptionalProperty<*>");
        ((RdOptionalProperty)iOptProperty).slave();
        super.init();
        this.suppressor.onRelease(this.getTextControlLifetime(), (Function0)new Function0<Unit>(this){
            final /* synthetic */ EditorSynchronizerWithTypingSession this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                EditorSynchronizerWithTypingSession.access$flushSuppressedChanges(this.this$0);
            }
        });
        this.getEditorModel().getSelection().advise(this.getTextControlLifetime(), (Function1)new Function1<SelectionRangeWithVersion, Unit>(this){
            final /* synthetic */ EditorSynchronizerWithTypingSession this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull SelectionRangeWithVersion it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.receiveSelection((RdCaretModelChange)it);
            }
        });
        this.getEditorModel().getScrolling().advise(this.getTextControlLifetime(), (Function1)new Function1<ScrollingInfo, Unit>(this){
            final /* synthetic */ EditorSynchronizerWithTypingSession this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ScrollingInfo it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.receiveScrollingRequest(it);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void w() {
        ClientId.Companion companion = ClientId.Companion;
        ClientId clientId = this.getClientId();
        boolean bl = false;
        ClientSessionsManager clientSessionsManager = companion.getCachedService();
        if (clientSessionsManager == null) {
            boolean bl2 = false;
            if (this.queuedChanges.isEmpty()) {
                return;
            }
            Logger logger = this.getLogger();
            boolean bl3 = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl4 = false;
                logger2.trace("Flushing queued selection changes (" + this.queuedChanges.size() + "), the last is " + PlatformTextControlUtilsKt.toDebugString((SelectionRangeWithVersion)CollectionsKt.last(this.queuedChanges)) + ".");
            }
            for (SelectionRangeWithVersion selectionRangeWithVersion : this.queuedChanges) {
                this.N(selectionRangeWithVersion);
            }
            this.queuedChanges.clear();
        } else {
            Object object;
            String string;
            ClientSessionsManager clientSessionsManager2 = clientSessionsManager;
            if (clientId == null || clientSessionsManager2.isValid(clientId)) {
                if (clientId != null && companion.isFakeLocalId(clientId)) {
                    string = companion.getLocalId().getValue();
                } else {
                    ClientId clientId2 = clientId;
                    string = clientId2 != null ? clientId2.getValue() : null;
                }
            } else {
                object = companion.getClientIdLogger();
                boolean bl5 = false;
                if (object.isTraceEnabled()) {
                    Object object2 = object;
                    boolean bl6 = false;
                    object2.trace("Invalid ClientId " + clientId + " replaced with null at " + new Throwable().fillInStackTrace());
                }
                string = null;
            }
            String string2 = string;
            object = ClientIdPropagation.getCurrentClientIdString();
            try {
                ClientIdPropagation.setCurrentClientIdString((String)string2);
                boolean bl7 = false;
                if (this.queuedChanges.isEmpty()) {
                    return;
                }
                Logger logger = this.getLogger();
                boolean bl8 = false;
                if (logger.isTraceEnabled()) {
                    Logger logger3 = logger;
                    boolean bl9 = false;
                    logger3.trace("Flushing queued selection changes (" + this.queuedChanges.size() + "), the last is " + PlatformTextControlUtilsKt.toDebugString((SelectionRangeWithVersion)CollectionsKt.last(this.queuedChanges)) + ".");
                }
                for (SelectionRangeWithVersion selectionRangeWithVersion : this.queuedChanges) {
                    this.N(selectionRangeWithVersion);
                }
                this.queuedChanges.clear();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                ClientIdPropagation.setCurrentClientIdString((String)object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendCaretStateChange(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        ClientId.Companion companion = ClientId.Companion;
        ClientId clientId = this.getClientId();
        boolean bl = false;
        ClientSessionsManager clientSessionsManager = companion.getCachedService();
        if (clientSessionsManager == null) {
            boolean bl2;
            Logger logger;
            boolean bl3 = false;
            Logger logger2 = this.getLogger();
            boolean bl4 = false;
            if (logger2.isTraceEnabled()) {
                logger = logger2;
                bl2 = false;
                CaretModel caretModel = this.getEditor().getCaretModel();
                Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
                logger.trace(reason + ". Selection is " + PlatformTextControlUtilsKt.toDebugString(PlatformTextControlUtilsKt.createSelectionRange(caretModel)) + ".");
            }
            if (this.getDontSendChange()) {
                logger2 = this.getLogger();
                bl4 = false;
                if (logger2.isTraceEnabled()) {
                    logger = logger2;
                    bl2 = false;
                    logger.trace("Updating from backend is going.");
                }
                return;
            }
            logger2 = paranoidLogger;
            bl4 = false;
            if (logger2.isTraceEnabled()) {
                logger = logger2;
                bl2 = false;
                String string = ExceptionUtil.currentStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentStackTrace(...)");
                logger.trace(string);
            }
            CaretModel caretModel = this.getEditor().getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
            logger2 = PlatformTextControlUtilsKt.createSelectionRange(caretModel);
            FrontendEditorTypingSession frontendEditorTypingSession = this.activeTypingSession;
            if (frontendEditorTypingSession != null && frontendEditorTypingSession.isCommitting()) {
                Logger logger3 = this.getLogger();
                boolean bl5 = false;
                if (logger3.isTraceEnabled()) {
                    logger = logger3;
                    boolean bl6 = false;
                    logger.trace("Don't send selection because of committing: " + PlatformTextControlUtilsKt.toDebugString((SelectionRange)logger2) + ".");
                }
                return;
            }
            this.v();
            this.currentSelection = logger2;
            SelectionRangeWithVersion selectionRangeWithVersion = new SelectionRangeWithVersion((SelectionRange)logger2, this.version);
            FrontendEditorTypingSession frontendEditorTypingSession2 = frontendEditorTypingSession;
            if (frontendEditorTypingSession2 != null) {
                frontendEditorTypingSession2.tryPushLocalChange((SelectionRange)logger2);
            }
            if (this.suppressor.shouldSuppress()) {
                Logger logger4 = this.getLogger();
                boolean bl7 = false;
                if (logger4.isTraceEnabled()) {
                    logger = logger4;
                    boolean bl8 = false;
                    logger.trace("Suppressing selection: " + PlatformTextControlUtilsKt.toDebugString((SelectionRange)logger2) + ".");
                }
                this.queuedChanges.add(selectionRangeWithVersion);
            } else {
                this.N(selectionRangeWithVersion);
            }
        } else {
            Object object;
            String string;
            ClientSessionsManager clientSessionsManager2 = clientSessionsManager;
            if (clientId == null || clientSessionsManager2.isValid(clientId)) {
                if (clientId != null && companion.isFakeLocalId(clientId)) {
                    string = companion.getLocalId().getValue();
                } else {
                    ClientId clientId2 = clientId;
                    string = clientId2 != null ? clientId2.getValue() : null;
                }
            } else {
                object = companion.getClientIdLogger();
                boolean bl9 = false;
                if (object.isTraceEnabled()) {
                    Object object2 = object;
                    boolean bl10 = false;
                    object2.trace("Invalid ClientId " + clientId + " replaced with null at " + new Throwable().fillInStackTrace());
                }
                string = null;
            }
            String string2 = string;
            object = ClientIdPropagation.getCurrentClientIdString();
            try {
                Object object3;
                boolean bl11;
                Logger logger;
                ClientIdPropagation.setCurrentClientIdString((String)string2);
                boolean bl12 = false;
                Logger logger5 = this.getLogger();
                boolean bl13 = false;
                if (logger5.isTraceEnabled()) {
                    logger = logger5;
                    bl11 = false;
                    CaretModel caretModel = this.getEditor().getCaretModel();
                    Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
                    logger.trace(reason + ". Selection is " + PlatformTextControlUtilsKt.toDebugString(PlatformTextControlUtilsKt.createSelectionRange(caretModel)) + ".");
                }
                if (this.getDontSendChange()) {
                    logger5 = this.getLogger();
                    bl13 = false;
                    if (logger5.isTraceEnabled()) {
                        logger = logger5;
                        bl11 = false;
                        logger.trace("Updating from backend is going.");
                    }
                    return;
                }
                logger5 = paranoidLogger;
                bl13 = false;
                if (logger5.isTraceEnabled()) {
                    logger = logger5;
                    bl11 = false;
                    String string3 = ExceptionUtil.currentStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"currentStackTrace(...)");
                    logger.trace(string3);
                }
                CaretModel caretModel = this.getEditor().getCaretModel();
                Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
                logger5 = PlatformTextControlUtilsKt.createSelectionRange(caretModel);
                FrontendEditorTypingSession frontendEditorTypingSession = this.activeTypingSession;
                if (frontendEditorTypingSession != null && frontendEditorTypingSession.isCommitting()) {
                    Logger logger6 = this.getLogger();
                    boolean bl14 = false;
                    if (logger6.isTraceEnabled()) {
                        logger = logger6;
                        boolean bl15 = false;
                        logger.trace("Don't send selection because of committing: " + PlatformTextControlUtilsKt.toDebugString((SelectionRange)logger5) + ".");
                    }
                    return;
                }
                this.v();
                this.currentSelection = logger5;
                SelectionRangeWithVersion selectionRangeWithVersion = new SelectionRangeWithVersion((SelectionRange)logger5, this.version);
                FrontendEditorTypingSession frontendEditorTypingSession3 = frontendEditorTypingSession;
                if (frontendEditorTypingSession3 != null) {
                    frontendEditorTypingSession3.tryPushLocalChange((SelectionRange)logger5);
                }
                if (this.suppressor.shouldSuppress()) {
                    Logger logger7 = this.getLogger();
                    boolean bl16 = false;
                    if (logger7.isTraceEnabled()) {
                        logger = logger7;
                        boolean bl17 = false;
                        logger.trace("Suppressing selection: " + PlatformTextControlUtilsKt.toDebugString((SelectionRange)logger5) + ".");
                    }
                    object3 = this.queuedChanges.add(selectionRangeWithVersion);
                } else {
                    this.N(selectionRangeWithVersion);
                    object3 = Unit.INSTANCE;
                }
                Unit unit = object3;
            }
            finally {
                ClientIdPropagation.setCurrentClientIdString((String)object);
            }
        }
    }

    private final void v() {
        Document document = this.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        boolean bl = !TextBufferDocumentSynchronizer.Companion.isBackendUpdateInProgress(document, this.getSession());
        this.version = SelectionVersionExKt.incrementMaster(this.version, bl);
        Logger logger = this.getLogger();
        boolean bl2 = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl3 = false;
            logger2.trace("Incrementing version: Current " + this.version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void N(SelectionRangeWithVersion selectionRangeWithVersion) {
        ClientIdExKt.assertClientIdConsistency((ClientId)this.getClientId(), (String)"performSend");
        try {
            this.dontReceiveChanges = true;
            Logger logger = this.getLogger();
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("Sending selection " + PlatformTextControlUtilsKt.toDebugString(selectionRangeWithVersion));
            }
            this.getEditorModel().getSelection().set((Object)selectionRangeWithVersion);
        }
        finally {
            this.dontReceiveChanges = false;
        }
    }

    public void receiveSelection(@NotNull RdCaretModelChange change) {
        boolean bl;
        Object object;
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        SelectionRangeWithVersion cfr_ignored_0 = (SelectionRangeWithVersion)change;
        if (this.dontReceiveChanges) {
            return;
        }
        Object object2 = this.getLogger();
        boolean bl2 = false;
        if (object2.isTraceEnabled()) {
            object = object2;
            bl = false;
            object.trace("Receiving selection " + PlatformTextControlUtilsKt.toDebugString((SelectionRangeWithVersion)change) + ".");
        }
        if (this.suppressor.shouldSuppress()) {
            object2 = this.getLogger();
            Throwable throwable = null;
            bl = false;
            if (object2.isDebugEnabled()) {
                object = object2;
                boolean bl3 = false;
                object.debug("Editor changes is suppressed.", throwable);
            }
        }
        if ((object2 = this.activeTypingSession) != null && ((FrontendEditorTypingSession)object2).tryPushRemoteChange((SelectionRangeWithVersion)change)) {
            return;
        }
        this.j((SelectionRangeWithVersion)change);
    }

    private final void j(SelectionRangeWithVersion selectionRangeWithVersion) {
        if (SelectionVersionExKt.compareTo(this.version, selectionRangeWithVersion.getVersion()) > 0) {
            Logger logger = this.getLogger();
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("Rejecting: local: " + PlatformTextControlUtilsKt.toDebugString(this.version) + " > remote: " + PlatformTextControlUtilsKt.toDebugString(selectionRangeWithVersion.getVersion()) + ".");
            }
            return;
        }
        this.version = selectionRangeWithVersion.getVersion();
        SelectionRange selectionRange = selectionRangeWithVersion.getSelection();
        CaretModel caretModel = this.getEditor().getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        if (Intrinsics.areEqual((Object)PlatformTextControlUtilsKt.createSelectionRange(caretModel), (Object)selectionRange)) {
            Logger logger = this.getLogger();
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger3 = logger;
                boolean bl3 = false;
                logger3.trace("Skipping equal selection.");
            }
            return;
        }
        this.j(selectionRange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void j(SelectionRange selectionRange) {
        try {
            Logger logger = this.getLogger();
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("Applying backend selection change.");
            }
            this.setDontSendChange(true);
            this.currentSelection = selectionRange;
            PlatformTextControlUtilsKt.applyTo(selectionRange, this.getEditor());
        }
        finally {
            this.setDontSendChange(false);
        }
    }

    public void receiveScrollingRequest(@NotNull ScrollingInfo request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.activeTypingSession != null) {
            return;
        }
        super.receiveScrollingRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void documentChanged(@NotNull DocumentEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        if (this.getEditor().isDisposed()) {
            Unit unit;
            Editor editor = this.getEditor();
            EditorImpl editorImpl = editor instanceof EditorImpl ? (EditorImpl)editor : null;
            if (editorImpl != null) {
                editorImpl.throwDisposalError("Editor is already disposed");
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                this.getLogger().error("Editor is already disposed.");
            }
        }
        ClientId.Companion companion = ClientId.Companion;
        ClientId clientId = this.getClientId();
        boolean bl = false;
        ClientSessionsManager clientSessionsManager = companion.getCachedService();
        if (clientSessionsManager == null) {
            boolean bl2 = false;
            this.sendCaretStateChange("Document was changed");
        } else {
            Object object;
            String string;
            ClientSessionsManager clientSessionsManager2 = clientSessionsManager;
            if (clientId == null || clientSessionsManager2.isValid(clientId)) {
                if (clientId != null && companion.isFakeLocalId(clientId)) {
                    string = companion.getLocalId().getValue();
                } else {
                    ClientId clientId2 = clientId;
                    string = clientId2 != null ? clientId2.getValue() : null;
                }
            } else {
                object = companion.getClientIdLogger();
                boolean bl3 = false;
                if (object.isTraceEnabled()) {
                    Object object2 = object;
                    boolean bl4 = false;
                    object2.trace("Invalid ClientId " + clientId + " replaced with null at " + new Throwable().fillInStackTrace());
                }
                string = null;
            }
            String string2 = string;
            object = ClientIdPropagation.getCurrentClientIdString();
            try {
                ClientIdPropagation.setCurrentClientIdString((String)string2);
                boolean bl5 = false;
                this.sendCaretStateChange("Document was changed");
                Unit unit = Unit.INSTANCE;
            }
            finally {
                ClientIdPropagation.setCurrentClientIdString((String)object);
            }
        }
    }

    @NotNull
    public final ITypingSession<SelectionRange> startTypingSession(@NotNull Lifetime lifetime2) {
        FrontendEditorTypingSession frontendEditorTypingSession;
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        ClientIdExKt.assertClientIdConsistency((ClientId)this.getClientId(), (String)"FrontendEditorSynchronizer.startTypingSession");
        if (!(this.activeTypingSession == null)) {
            boolean bl = false;
            String string = "activeTypingSession == null";
            throw new IllegalArgumentException(string.toString());
        }
        if (!RLifetimeKt.isAlive((Lifetime)lifetime2)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.activeTypingSession = frontendEditorTypingSession = new FrontendEditorTypingSession();
        lifetime2.onTermination((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                EditorSynchronizerWithTypingSession.access$finishTypingSession((EditorSynchronizerWithTypingSession)((Object)this.receiver));
            }
        });
        return frontendEditorTypingSession;
    }

    private final void t() {
        if (!(this.activeTypingSession != null)) {
            boolean bl = false;
            String string = "activeTypingSession != null";
            throw new IllegalArgumentException(string.toString());
        }
        this.activeTypingSession = null;
    }

    public final void assertEmptyChangesQueue() {
        this.getLogger().assertTrue(this.queuedChanges.isEmpty(), (Object)"queuedChanges.isEmpty()");
    }

    public static final /* synthetic */ void access$flushSuppressedChanges(EditorSynchronizerWithTypingSession $this) {
        $this.w();
    }

    public static final /* synthetic */ void access$finishTypingSession(EditorSynchronizerWithTypingSession $this) {
        $this.t();
    }

    static {
        Logger logger = Logger.getInstance((String)PARANOID_CATEGORY);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        paranoidLogger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession$Companion;", "", "()V", "PARANOID_CATEGORY", "", "paranoidLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "create", "Lcom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "textControlLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/Editor;", "textControlId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "editorModel", "Lcom/jetbrains/rd/ide/model/RiderTextControlModel;", "recoverEditorsSynchronization", "", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nEditorSynchronizerWithTypingSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorSynchronizerWithTypingSession.kt\ncom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,307:1\n1549#2:308\n1620#2,3:309\n*S KotlinDebug\n*F\n+ 1 EditorSynchronizerWithTypingSession.kt\ncom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession$Companion\n*L\n54#1:308\n54#1:309,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EditorSynchronizerWithTypingSession create(@NotNull ClientAppSession session2, @NotNull Lifetime textControlLifetime, @NotNull Editor editor, @NotNull TextControlId textControlId, @NotNull RiderTextControlModel editorModel) {
            EditorSynchronizerWithTypingSession editorSynchronizerWithTypingSession;
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)textControlLifetime, (String)"textControlLifetime");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
            Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
            EditorSynchronizerWithTypingSession editorSynchronizerWithTypingSession2 = editorSynchronizerWithTypingSession = new EditorSynchronizerWithTypingSession(session2, textControlLifetime, editor, textControlId, editorModel);
            boolean bl = false;
            editorSynchronizerWithTypingSession2.init();
            return editorSynchronizerWithTypingSession;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void recoverEditorsSynchronization(@NotNull RdDocumentId documentId, @NotNull ClientAppSession session2) {
            Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            FrontendTextControlHost frontendTextControlHost = FrontendTextControlHost.Companion.getInstance(session2);
            List list = frontendTextControlHost.getEditorsIds(documentId);
            Iterable iterable = list;
            boolean bl = false;
            Iterable iterable22 = iterable;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            int n2 = 0;
            for (Object object : iterable22) {
                Editor editor = (Editor)object;
                Collection collection2 = collection;
                boolean bl2 = false;
                collection2.add(TuplesKt.to((Object)editor, (Object)editor.getCaretModel().getOffset()));
            }
            List list2 = (List)collection;
            try {
                TextBufferDocumentSynchronizer.Companion.recoverDocumentModelSynchronization(documentId, session2);
            }
            catch (Throwable throwable) {
                for (Iterable iterable22 : list2) {
                    Object object;
                    collection = (Editor)iterable22.component1();
                    n2 = ((Number)iterable22.component2()).intValue();
                    collection.getCaretModel().moveToOffset(n2);
                    object = DocumentExKt.getEditorSynchronizer((Editor)collection);
                    EditorSynchronizerWithTypingSession editorSynchronizerWithTypingSession = object instanceof EditorSynchronizerWithTypingSession ? (EditorSynchronizerWithTypingSession)((Object)object) : null;
                    if (editorSynchronizerWithTypingSession == null) continue;
                    editorSynchronizerWithTypingSession.sendCaretStateChange("Recovering");
                }
                throw throwable;
            }
            for (Pair pair2 : list2) {
                iterable22 = (Editor)pair2.component1();
                int n3 = ((Number)pair2.component2()).intValue();
                iterable22.getCaretModel().moveToOffset(n3);
                EditorSynchronizer editorSynchronizer = DocumentExKt.getEditorSynchronizer((Editor)iterable22);
                EditorSynchronizerWithTypingSession editorSynchronizerWithTypingSession = editorSynchronizer instanceof EditorSynchronizerWithTypingSession ? (EditorSynchronizerWithTypingSession)editorSynchronizer : null;
                if (editorSynchronizerWithTypingSession == null) continue;
                editorSynchronizerWithTypingSession.sendCaretStateChange("Recovering");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\u000e\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0002J\u000e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\bR\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession$FrontendEditorTypingSession;", "Lcom/jetbrains/rd/rdtext/ITypingSession;", "Lcom/jetbrains/rd/ide/model/SelectionRange;", "(Lcom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession;)V", "isCommitting", "", "()Z", "lastRemoteChange", "Lcom/jetbrains/rd/ide/model/SelectionRangeWithVersion;", "onLocalChange", "Lcom/jetbrains/rd/util/reactive/Signal;", "getOnLocalChange", "()Lcom/jetbrains/rd/util/reactive/Signal;", "onRemoteChange", "getOnRemoteChange", "selectionBeforeOpening", "state", "Lcom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession$State;", "versionBeforeOpening", "Lcom/jetbrains/rd/ide/model/SelectionVersion;", "finishCommitRemoteVersion", "", "rollbackRemoteVersion", "startCommitRemoteVersion", "tryPushLocalChange", "selection", "tryPushRemoteChange", "selectionWithVersion", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nEditorSynchronizerWithTypingSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorSynchronizerWithTypingSession.kt\ncom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession$FrontendEditorTypingSession\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,307:1\n65#2,4:308\n65#2,4:312\n65#2,4:316\n1#3:320\n*S KotlinDebug\n*F\n+ 1 EditorSynchronizerWithTypingSession.kt\ncom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession$FrontendEditorTypingSession\n*L\n256#1:308,4\n262#1:312,4\n271#1:316,4\n*E\n"})
    private final class FrontendEditorTypingSession
    implements ITypingSession<SelectionRange> {
        @NotNull
        private final SelectionVersion versionBeforeOpening;
        @NotNull
        private final SelectionRange selectionBeforeOpening;
        @NotNull
        private State state;
        @Nullable
        private SelectionRangeWithVersion lastRemoteChange;
        @NotNull
        private final Signal<SelectionRange> onRemoteChange;
        @NotNull
        private final Signal<SelectionRange> onLocalChange;

        public FrontendEditorTypingSession() {
            this.versionBeforeOpening = EditorSynchronizerWithTypingSession.this.getVersion();
            this.selectionBeforeOpening = EditorSynchronizerWithTypingSession.this.currentSelection;
            this.state = State.Opened;
            this.onRemoteChange = new Signal();
            this.onLocalChange = new Signal();
            EditorSynchronizerWithTypingSession.this.getEditorModel().getVersionBeforeTypingSession().set((Object)this.versionBeforeOpening);
            Logger logger = EditorSynchronizerWithTypingSession.this.getLogger();
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("VersionBeforeTypingSession is " + PlatformTextControlUtilsKt.toDebugString(this.versionBeforeOpening));
            }
        }

        @NotNull
        public Signal<SelectionRange> getOnRemoteChange() {
            return this.onRemoteChange;
        }

        @NotNull
        public Signal<SelectionRange> getOnLocalChange() {
            return this.onLocalChange;
        }

        public final boolean isCommitting() {
            return this.state == State.Committing;
        }

        public final boolean tryPushLocalChange(@NotNull SelectionRange selection) {
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            if (this.state != State.Opened) {
                return false;
            }
            Logger logger = EditorSynchronizerWithTypingSession.this.getLogger();
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("Put local change into typing session.");
            }
            this.getOnLocalChange().fire((Object)selection);
            return true;
        }

        public final boolean tryPushRemoteChange(@NotNull SelectionRangeWithVersion selectionWithVersion) {
            Intrinsics.checkNotNullParameter((Object)selectionWithVersion, (String)"selectionWithVersion");
            if (this.state != State.Opened) {
                return false;
            }
            if (SelectionVersionExKt.compareTo(selectionWithVersion.getVersion(), this.versionBeforeOpening) < 0) {
                return false;
            }
            Logger logger = EditorSynchronizerWithTypingSession.this.getLogger();
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("Put remote change into typing session.");
            }
            logger = selectionWithVersion.getSelection();
            this.getOnRemoteChange().fire((Object)logger);
            this.lastRemoteChange = selectionWithVersion;
            return true;
        }

        public void startCommitRemoteVersion() {
            if (!(this.state == State.Opened)) {
                boolean bl = false;
                String string = "state == State.Opened";
                throw new IllegalArgumentException(string.toString());
            }
            this.state = State.Committing;
        }

        public void finishCommitRemoteVersion() {
            SelectionRangeWithVersion selectionRangeWithVersion = this.lastRemoteChange;
            if (selectionRangeWithVersion != null) {
                EditorSynchronizerWithTypingSession.this.version = selectionRangeWithVersion.getVersion();
                EditorSynchronizerWithTypingSession.this.currentSelection = selectionRangeWithVersion.getSelection();
            } else {
                EditorSynchronizerWithTypingSession.this.version = this.versionBeforeOpening;
                EditorSynchronizerWithTypingSession.this.currentSelection = this.selectionBeforeOpening;
            }
        }

        public void rollbackRemoteVersion() {
            if (!(this.state == State.Opened)) {
                boolean bl = false;
                String string = "state == State.Opened";
                throw new IllegalArgumentException(string.toString());
            }
            this.state = State.Closing;
            EditorSynchronizerWithTypingSession.this.sendCaretStateChange("Promote master version");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession$State;", "", "(Ljava/lang/String;I)V", "Opened", "Committing", "Closing", "intellij.rider.rdclient.dotnet"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State Opened = new State();
        public static final /* enum */ State Committing = new State();
        public static final /* enum */ State Closing = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value2) {
            return Enum.valueOf(State.class, value2);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.Opened, State.Committing, State.Closing};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

